/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.optimised;

import org.jpc.emulator.memory.codeblock.CodeBlockCompiler;
import org.jpc.emulator.memory.codeblock.InstructionSource;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.Virtual8086ModeCodeBlock;
import org.jpc.emulator.memory.codeblock.optimised.ProtectedModeUBlock;
import org.jpc.emulator.memory.codeblock.optimised.RealModeUBlock;
import org.jpc.emulator.memory.codeblock.optimised.Virtual8086ModeUBlock;

public class OptimisedCompiler
implements CodeBlockCompiler {
    private int bufferOffset = 0;
    private int[] bufferMicrocodes = new int[100];
    private int[] bufferPositions = new int[100];

    @Override
    public RealModeCodeBlock getRealModeCodeBlock(InstructionSource instructionSource) {
        this.buildCodeBlockBuffers(instructionSource);
        int[] nArray = new int[this.bufferOffset];
        int[] nArray2 = new int[this.bufferOffset];
        System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferOffset);
        System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferOffset);
        return new RealModeUBlock(nArray, nArray2);
    }

    @Override
    public ProtectedModeCodeBlock getProtectedModeCodeBlock(InstructionSource instructionSource) {
        this.buildCodeBlockBuffers(instructionSource);
        int[] nArray = new int[this.bufferOffset];
        int[] nArray2 = new int[this.bufferOffset];
        System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferOffset);
        System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferOffset);
        return new ProtectedModeUBlock(nArray, nArray2);
    }

    @Override
    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(InstructionSource instructionSource) {
        this.buildCodeBlockBuffers(instructionSource);
        int[] nArray = new int[this.bufferOffset];
        int[] nArray2 = new int[this.bufferOffset];
        System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferOffset);
        System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferOffset);
        return new Virtual8086ModeUBlock(nArray, nArray2);
    }

    private void buildCodeBlockBuffers(InstructionSource instructionSource) {
        this.bufferOffset = 0;
        int n = 0;
        while (instructionSource.getNext()) {
            int n2 = instructionSource.getLength();
            int n3 = instructionSource.getX86Length();
            n += n3;
            for (int i = 0; i < n2; ++i) {
                int n4 = instructionSource.getMicrocode();
                try {
                    this.bufferMicrocodes[this.bufferOffset] = n4;
                    this.bufferPositions[this.bufferOffset] = n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int[] nArray = new int[this.bufferMicrocodes.length * 2];
                    int[] nArray2 = new int[this.bufferMicrocodes.length * 2];
                    System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferMicrocodes.length);
                    System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferPositions.length);
                    this.bufferMicrocodes = nArray;
                    this.bufferPositions = nArray2;
                    this.bufferMicrocodes[this.bufferOffset] = n4;
                    this.bufferPositions[this.bufferOffset] = n;
                }
                ++this.bufferOffset;
            }
        }
    }
}

