/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.DMATransferCapable;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class DMAController
extends AbstractHardwareComponent
implements IOPortCapable {
    private static final int pagePortList0 = 1;
    private static final int pagePortList1 = 2;
    private static final int pagePortList2 = 3;
    private static final int pagePortList3 = 7;
    private static final int[] pagePortList = new int[]{1, 2, 3, 7};
    private static final int COMMAND_MEMORY_TO_MEMORY = 1;
    private static final int COMMAND_ADDRESS_HOLD = 2;
    private static final int COMMAND_COMPRESSED_TIMING = 8;
    private static final int COMMAND_CYCLIC_PRIORITY = 16;
    private static final int COMMAND_EXTENDED_WRITE = 32;
    private static final int COMMAND_DREQ_SENSE_LOW = 64;
    private static final int COMMAND_DACK_SENSE_LOW = 128;
    private static final int CMD_NOT_SUPPORTED = 251;
    private static final int ADDRESS_READ_STATUS = 8;
    private static final int ADDRESS_READ_MASK = 15;
    private static final int ADDRESS_WRITE_COMMAND = 8;
    private static final int ADDRESS_WRITE_REQUEST = 9;
    private static final int ADDRESS_WRITE_MASK_BIT = 10;
    private static final int ADDRESS_WRITE_MODE = 11;
    private static final int ADDRESS_WRITE_FLIPFLOP = 12;
    private static final int ADDRESS_WRITE_CLEAR = 13;
    private static final int ADDRESS_WRITE_CLEAR_MASK = 14;
    private static final int ADDRESS_WRITE_MASK = 15;
    private int status;
    private int command;
    private int mask;
    private boolean flipFlop;
    private int dShift;
    private int ioBase;
    private int pageLowBase;
    private int pageHighBase;
    private int controllerNumber;
    private PhysicalAddressSpace memory;
    private DMAChannel[] dmaChannels;
    private static final int[] channels = new int[]{-1, 2, 3, 1, -1, -1, -1, 0};
    private boolean ioportRegistered;

    public DMAController(boolean bl, boolean bl2) {
        this.ioportRegistered = false;
        this.dShift = bl2 ? 0 : 1;
        this.ioBase = bl2 ? 0 : 192;
        int n = this.pageLowBase = bl2 ? 128 : 136;
        this.pageHighBase = bl ? (bl2 ? 1152 : 1160) : -1;
        this.controllerNumber = bl2 ? 0 : 1;
        this.dmaChannels = new DMAChannel[4];
        for (int i = 0; i < 4; ++i) {
            this.dmaChannels[i] = new DMAChannel(this);
        }
        this.reset();
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tstatus " + this.status + " command " + this.command + " mask " + this.mask + " flipFlop " + this.flipFlop);
        statusDumper.println("\tdShift " + this.dShift + " ioBase " + this.ioBase + " pageLowBase " + this.pageLowBase);
        statusDumper.println("\tpageHighBase " + this.pageHighBase + " controllerNumber " + this.controllerNumber);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tmemory <object #" + statusDumper.objectNumber(this.memory) + ">");
        if (this.memory != null) {
            this.memory.dumpStatus(statusDumper);
        }
        for (int i = 0; i < this.dmaChannels.length; ++i) {
            statusDumper.println("\tdmaChannels[" + i + "] <object #" + statusDumper.objectNumber(this.dmaChannels[i]) + ">");
            if (this.dmaChannels[i] == null) continue;
            this.dmaChannels[i].dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": DMAController:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.status);
        sRDumper.dumpInt(this.command);
        sRDumper.dumpInt(this.mask);
        sRDumper.dumpBoolean(this.flipFlop);
        sRDumper.dumpInt(this.dShift);
        sRDumper.dumpInt(this.ioBase);
        sRDumper.dumpInt(this.pageLowBase);
        sRDumper.dumpInt(this.pageHighBase);
        sRDumper.dumpInt(this.controllerNumber);
        sRDumper.dumpObject(this.memory);
        sRDumper.dumpInt(this.dmaChannels.length);
        for (int i = 0; i < this.dmaChannels.length; ++i) {
            sRDumper.dumpObject(this.dmaChannels[i]);
        }
        sRDumper.dumpBoolean(this.ioportRegistered);
    }

    public DMAController(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.status = sRLoader.loadInt();
        this.command = sRLoader.loadInt();
        this.mask = sRLoader.loadInt();
        this.flipFlop = sRLoader.loadBoolean();
        this.dShift = sRLoader.loadInt();
        this.ioBase = sRLoader.loadInt();
        this.pageLowBase = sRLoader.loadInt();
        this.pageHighBase = sRLoader.loadInt();
        this.controllerNumber = sRLoader.loadInt();
        this.memory = (PhysicalAddressSpace)sRLoader.loadObject();
        this.dmaChannels = new DMAChannel[sRLoader.loadInt()];
        for (int i = 0; i < this.dmaChannels.length; ++i) {
            this.dmaChannels[i] = (DMAChannel)sRLoader.loadObject();
        }
        this.ioportRegistered = false;
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.ioportRegistered = sRLoader.loadBoolean();
    }

    public boolean isPrimary() {
        return this.dShift == 0;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.dmaChannels.length; ++i) {
            this.dmaChannels[i].reset();
        }
        this.writeController(13 << this.dShift, 0);
        this.memory = null;
        this.ioportRegistered = false;
    }

    private void writeChannel(int n, int n2) {
        int n3 = n >>> this.dShift & 0xF;
        int n4 = n3 >>> 1;
        DMAChannel dMAChannel = this.dmaChannels[n4];
        if (this.getFlipFlop()) {
            if ((n3 & 1) == 0) {
                dMAChannel.baseAddress = dMAChannel.baseAddress & 0xFF | n2 << 8 & 0xFF00;
            } else {
                dMAChannel.baseWordCount = dMAChannel.baseWordCount & 0xFF | n2 << 8 & 0xFF00;
            }
            this.initChannel(n4);
        } else if ((n3 & 1) == 0) {
            dMAChannel.baseAddress = dMAChannel.baseAddress & 0xFF00 | n2 & 0xFF;
        } else {
            dMAChannel.baseWordCount = dMAChannel.baseWordCount & 0xFF00 | n2 & 0xFF;
        }
    }

    private void writeController(int n, int n2) {
        int n3 = n >>> this.dShift & 0xF;
        switch (n3) {
            case 8: {
                if (n2 != 0 && (n2 & 0xFB) != 0) {
                    System.err.println("Warning: DMA: Command bits " + (n2 & 0xFB) + " not supported.");
                    break;
                }
                this.command = n2;
                break;
            }
            case 9: {
                int n4 = n2 & 3;
                this.status &= ~(1 << n4);
                this.runTransfers();
                break;
            }
            case 10: {
                DMAChannel dMAChannel = this.dmaChannels[n2 & 3];
                int n5 = 1 + dMAChannel.baseWordCount << this.controllerNumber - dMAChannel.currentWordCount;
                if ((n2 & 4) != 0) {
                    this.mask |= 1 << (n2 & 3);
                    break;
                }
                this.mask &= ~(1 << (n2 & 3));
                this.runTransfers();
                break;
            }
            case 11: {
                int n6 = n2 & 3;
                this.dmaChannels[n6].mode = n2;
                break;
            }
            case 12: {
                this.flipFlop = false;
                break;
            }
            case 13: {
                this.flipFlop = false;
                this.mask = -1;
                this.status &= 0xF0;
                this.command = 0;
                break;
            }
            case 14: {
                this.mask = 0;
                this.runTransfers();
                break;
            }
            case 15: {
                this.mask = n2;
                this.runTransfers();
                break;
            }
        }
    }

    private void writePageLow(int n, int n2) {
        int n3 = channels[n & 7];
        if (-1 == n3) {
            return;
        }
        this.dmaChannels[n3].pageLow = 0xFF & n2;
    }

    private void writePageHigh(int n, int n2) {
        int n3 = channels[n & 7];
        if (-1 == n3) {
            return;
        }
        this.dmaChannels[n3].pageHigh = 0x7F & n2;
    }

    private int readChannel(int n) {
        int n2 = n >>> this.dShift & 0xF;
        int n3 = n2 >>> 1;
        int n4 = n2 & 1;
        DMAChannel dMAChannel = this.dmaChannels[n3];
        int n5 = (dMAChannel.mode & 0x20) == 0 ? 1 : -1;
        boolean bl = this.getFlipFlop();
        int n6 = n4 != 0 ? (dMAChannel.baseWordCount << this.dShift) - dMAChannel.currentWordCount : dMAChannel.currentAddress + dMAChannel.currentWordCount * n5;
        return n6 >>> this.dShift + (bl ? 8 : 0) & 0xFF;
    }

    private int readController(int n) {
        int n2;
        int n3 = n >>> this.dShift & 0xF;
        switch (n3) {
            case 8: {
                n2 = this.status;
                this.status &= 0xF0;
                break;
            }
            case 15: {
                n2 = this.mask;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private int readPageLow(int n) {
        int n2 = channels[n & 7];
        if (-1 == n2) {
            return 0;
        }
        return this.dmaChannels[n2].pageLow;
    }

    private int readPageHigh(int n) {
        int n2 = channels[n & 7];
        if (-1 == n2) {
            return 0;
        }
        return this.dmaChannels[n2].pageHigh;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n - this.ioBase >>> this.dShift) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeChannel(n, n2);
                return;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.writeController(n, n2);
                return;
            }
        }
        switch (n - this.pageLowBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.writePageLow(n, n2);
                return;
            }
        }
        switch (n - this.pageHighBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.writePageHigh(n, n2);
                return;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >>> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >>> 16);
    }

    @Override
    public int ioPortReadByte(int n) {
        switch (n - this.ioBase >>> this.dShift) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.readChannel(n);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.readController(n);
            }
        }
        switch (n - this.pageLowBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.readPageLow(n);
            }
        }
        switch (n - this.pageHighBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.readPageHigh(n);
            }
        }
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | this.ioPortReadByte(n) << 8 & 0xFF;
    }

    @Override
    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadByte(n) | this.ioPortReadByte(n) << 16 & 0xFFFF;
    }

    @Override
    public int[] ioPortsRequested() {
        int n;
        int[] nArray = this.pageHighBase >= 0 ? new int[16 + 2 * pagePortList.length] : new int[16 + pagePortList.length];
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            nArray[n2++] = this.ioBase + (n << this.dShift);
        }
        for (n = 0; n < pagePortList.length; ++n) {
            nArray[n2++] = this.pageLowBase + pagePortList[n];
            if (this.pageHighBase < 0) continue;
            nArray[n2++] = this.pageHighBase + pagePortList[n];
        }
        for (n = 0; n < 8; ++n) {
            nArray[n2++] = this.ioBase + (n + 8 << this.dShift);
        }
        return nArray;
    }

    private boolean getFlipFlop() {
        boolean bl = this.flipFlop;
        this.flipFlop = !bl;
        return bl;
    }

    private void initChannel(int n) {
        DMAChannel dMAChannel = this.dmaChannels[n];
        dMAChannel.currentAddress = dMAChannel.baseAddress << this.dShift;
        dMAChannel.currentWordCount = 0;
    }

    private static int numberOfTrailingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 31;
        int n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    private void runTransfers() {
        int n;
        int n2 = ~this.mask & this.status >>> 4 & 0xF;
        if (n2 == 0) {
            return;
        }
        while (n2 != 0 && (n = DMAController.numberOfTrailingZeros(n2)) < 4) {
            this.dmaChannels[n].run();
            n2 &= ~(1 << n);
        }
    }

    public int getChannelMode(int n) {
        return this.dmaChannels[n].mode;
    }

    public void holdDmaRequest(int n) {
        this.status |= 1 << n + 4;
        this.runTransfers();
    }

    public void releaseDmaRequest(int n) {
        this.status &= ~(1 << n + 4);
    }

    public void registerChannel(int n, DMATransferCapable dMATransferCapable) {
        this.dmaChannels[n].transferDevice = dMATransferCapable;
    }

    @Override
    public boolean initialised() {
        return this.memory != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.memory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public String toString() {
        return "DMA Controller [element " + this.dShift + "]";
    }

    public static class DMAChannel
    implements SRDumpable {
        private static final int MODE_CHANNEL_SELECT = 3;
        private static final int MODE_ADDRESS_INCREMENT = 32;
        private static final int MODE_AUTO_REINITIALIZE = 16;
        public static final int ADDRESS = 0;
        public static final int COUNT = 1;
        public int currentAddress;
        public int currentWordCount;
        public int baseAddress;
        public int baseWordCount;
        public int mode;
        public int dack;
        public int eop;
        public DMATransferCapable transferDevice;
        public int pageLow;
        public int pageHigh;
        private DMAController upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpInt(this.currentAddress);
            sRDumper.dumpInt(this.currentWordCount);
            sRDumper.dumpInt(this.baseAddress);
            sRDumper.dumpInt(this.baseWordCount);
            sRDumper.dumpInt(this.mode);
            sRDumper.dumpInt(this.pageLow);
            sRDumper.dumpInt(this.pageHigh);
            sRDumper.dumpInt(this.dack);
            sRDumper.dumpInt(this.eop);
            sRDumper.dumpObject(this.transferDevice);
            sRDumper.dumpObject(this.upperBackref);
        }

        public DMAChannel(DMAController dMAController) {
            this.upperBackref = dMAController;
        }

        public DMAChannel(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.currentAddress = sRLoader.loadInt();
            this.currentWordCount = sRLoader.loadInt();
            this.baseAddress = sRLoader.loadInt();
            this.baseWordCount = sRLoader.loadInt();
            this.mode = sRLoader.loadInt();
            this.pageLow = sRLoader.loadInt();
            this.pageHigh = sRLoader.loadInt();
            this.dack = sRLoader.loadInt();
            this.eop = sRLoader.loadInt();
            this.transferDevice = (DMATransferCapable)sRLoader.loadObject();
            this.upperBackref = (DMAController)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
            statusDumper.println("\tcurrentAddress " + this.currentAddress + " currentWordCount " + this.currentWordCount);
            statusDumper.println("\tbaseAddress " + this.baseAddress + " baseWordCount " + this.baseWordCount);
            statusDumper.println("\tmode " + this.mode + " pageLow " + this.pageLow + " pageHigh " + this.pageHigh);
            statusDumper.println("\tdack " + this.dack + " eop " + this.eop);
            statusDumper.println("\ttransferDevice <object #" + statusDumper.objectNumber(this.transferDevice) + ">");
            if (this.transferDevice != null) {
                this.transferDevice.dumpStatus(statusDumper);
            }
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DMAChannel:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public void readMemory(byte[] byArray, int n, int n2, int n3) {
            int n4 = this.pageHigh << 24 | this.pageLow << 16 | this.currentAddress;
            if ((this.mode & 0x20) != 0) {
                System.err.println("Warning: DMA read in address decrement mode");
                this.upperBackref.memory.copyContentsIntoArray(n4 - n2 - n3, byArray, n, n3);
                int n5 = n;
                for (int i = n + n3 - 1; n5 < i; ++n5, --i) {
                    byte by = byArray[n5];
                    byArray[n5] = byArray[i];
                    byArray[i] = by;
                }
            } else {
                this.upperBackref.memory.copyContentsIntoArray(n4 + n2, byArray, n, n3);
            }
        }

        public void writeMemory(byte[] byArray, int n, int n2, int n3) {
            int n4 = this.pageHigh << 24 | this.pageLow << 16 | this.currentAddress;
            if ((this.mode & 0x20) != 0) {
                System.err.println("Warning: DMA write in address decrement mode");
                int n5 = n;
                for (int i = n + n3 - 1; n5 < i; ++n5, --i) {
                    byte by = byArray[n5];
                    byArray[n5] = byArray[i];
                    byArray[i] = by;
                }
                this.upperBackref.memory.copyArrayIntoContents(n4 - n2 - n3, byArray, n, n3);
            } else {
                this.upperBackref.memory.copyArrayIntoContents(n4 + n2, byArray, n, n3);
            }
        }

        private boolean transferComplete() {
            return this.currentWordCount >= this.baseWordCount + 1 << this.upperBackref.controllerNumber;
        }

        private void run() {
            int n;
            if (this.transferComplete()) {
                if ((this.mode & 0x10) != 0) {
                    this.currentWordCount = 0;
                } else {
                    return;
                }
            }
            this.currentWordCount = n = this.transferDevice.handleTransfer(this, this.currentWordCount, this.baseWordCount + 1 << this.upperBackref.controllerNumber);
            if (this.transferComplete() && (this.mode & 0x10) != 0) {
                this.currentWordCount = 0;
            }
        }

        public void reset() {
            this.transferDevice = null;
            this.mode = 0;
            this.currentWordCount = 0;
            this.currentAddress = 0;
            this.baseWordCount = 0;
            this.baseAddress = 0;
            this.eop = 0;
            this.dack = 0;
            this.pageHigh = 0;
            this.pageLow = 0;
        }
    }
}

