/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.processor.Processor;

public class InterruptController
extends AbstractHardwareComponent
implements IOPortCapable {
    private InterruptControllerElement master;
    private InterruptControllerElement slave;
    private Processor connectedCPU;
    private boolean ioportRegistered;

    public InterruptController() {
        this.ioportRegistered = false;
        this.master = new InterruptControllerElement(this, true);
        this.slave = new InterruptControllerElement(this, false);
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tconnectedCPU <object #" + statusDumper.objectNumber(this.connectedCPU) + ">");
        if (this.connectedCPU != null) {
            this.connectedCPU.dumpStatus(statusDumper);
        }
        statusDumper.println("\tmaster <object #" + statusDumper.objectNumber(this.master) + ">");
        if (this.master != null) {
            this.master.dumpStatus(statusDumper);
        }
        statusDumper.println("\tslave <object #" + statusDumper.objectNumber(this.slave) + ">");
        if (this.slave != null) {
            this.slave.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": InterruptController:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.connectedCPU);
        sRDumper.dumpObject(this.master);
        sRDumper.dumpObject(this.slave);
    }

    public InterruptController(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.connectedCPU = (Processor)sRLoader.loadObject();
        this.master = (InterruptControllerElement)sRLoader.loadObject();
        this.slave = (InterruptControllerElement)sRLoader.loadObject();
    }

    private void updateIRQ() {
        int n;
        int n2 = this.slave.getIRQ();
        if (n2 >= 0) {
            this.master.setIRQ(2, 1);
            this.master.setIRQ(2, 0);
        }
        if ((n = this.master.getIRQ()) >= 0) {
            this.connectedCPU.raiseInterrupt();
        }
    }

    public void setIRQ(int n, int n2) {
        switch (n >>> 3) {
            case 0: {
                this.master.setIRQ(n & 7, n2);
                this.updateIRQ();
                break;
            }
            case 1: {
                this.slave.setIRQ(n & 7, n2);
                this.updateIRQ();
                break;
            }
        }
    }

    public int cpuGetInterrupt() {
        int n = this.master.getIRQ();
        if (n >= 0) {
            this.master.intAck(n);
            if (n == 2) {
                int n2 = this.slave.getIRQ();
                if (n2 >= 0) {
                    this.slave.intAck(n2);
                } else {
                    n2 = 7;
                }
                this.updateIRQ();
                return this.slave.irqBase + n2;
            }
            this.updateIRQ();
            return this.master.irqBase + n;
        }
        n = 7;
        this.updateIRQ();
        return this.master.irqBase + n;
    }

    @Override
    public int[] ioPortsRequested() {
        int[] nArray = this.master.ioPortsRequested();
        int[] nArray2 = this.slave.ioPortsRequested();
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    @Override
    public int ioPortReadByte(int n) {
        switch (n) {
            case 32: 
            case 33: {
                return 0xFF & this.master.ioPortRead(n);
            }
            case 160: 
            case 161: {
                return 0xFF & this.slave.ioPortRead(n);
            }
            case 1232: {
                return 0xFF & this.master.elcrRead();
            }
            case 1233: {
                return 0xFF & this.slave.elcrRead();
            }
        }
        return 0;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 32: 
            case 33: {
                if (!this.master.ioPortWrite(n, (byte)n2)) break;
                this.updateIRQ();
                break;
            }
            case 160: 
            case 161: {
                if (!this.slave.ioPortWrite(n, (byte)n2)) break;
                this.updateIRQ();
                break;
            }
            case 1232: {
                this.master.elcrWrite(n2);
                break;
            }
            case 1233: {
                this.slave.elcrWrite(n2);
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >>> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >>> 16);
    }

    private void masterPollCode() {
        this.master.interruptServiceRegister &= -5;
        this.master.interruptRequestRegister &= -5;
    }

    @Override
    public void reset() {
        this.master.reset();
        this.slave.reset();
        this.ioportRegistered = false;
        this.connectedCPU = null;
    }

    @Override
    public boolean initialised() {
        return this.connectedCPU != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Processor) {
            this.connectedCPU = (Processor)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public String toString() {
        return "Intel i8259 Programmable Interrupt Controller";
    }

    public static class InterruptControllerElement
    implements SRDumpable {
        private int lastInterruptRequestRegister;
        private int interruptRequestRegister;
        private int interruptMaskRegister;
        private int interruptServiceRegister;
        private int priorityAdd;
        private int irqBase;
        private boolean readRegisterSelect;
        private boolean poll;
        private boolean specialMask;
        private int initState;
        private boolean fourByteInit;
        private int elcr;
        private int elcrMask;
        private boolean specialFullyNestedMode;
        private boolean autoEOI;
        private boolean rotateOnAutoEOI;
        private int[] ioPorts;
        private InterruptController upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpInt(this.lastInterruptRequestRegister);
            sRDumper.dumpInt(this.interruptRequestRegister);
            sRDumper.dumpInt(this.interruptMaskRegister);
            sRDumper.dumpInt(this.interruptServiceRegister);
            sRDumper.dumpInt(this.priorityAdd);
            sRDumper.dumpInt(this.irqBase);
            sRDumper.dumpBoolean(this.readRegisterSelect);
            sRDumper.dumpBoolean(this.poll);
            sRDumper.dumpBoolean(this.specialMask);
            sRDumper.dumpInt(this.initState);
            sRDumper.dumpBoolean(this.fourByteInit);
            sRDumper.dumpInt(this.elcr);
            sRDumper.dumpInt(this.elcrMask);
            sRDumper.dumpBoolean(this.specialFullyNestedMode);
            sRDumper.dumpBoolean(this.autoEOI);
            sRDumper.dumpBoolean(this.rotateOnAutoEOI);
            sRDumper.dumpArray(this.ioPorts);
            sRDumper.dumpObject(this.upperBackref);
        }

        public InterruptControllerElement(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.lastInterruptRequestRegister = sRLoader.loadInt();
            this.interruptRequestRegister = sRLoader.loadInt();
            this.interruptMaskRegister = sRLoader.loadInt();
            this.interruptServiceRegister = sRLoader.loadInt();
            this.priorityAdd = sRLoader.loadInt();
            this.irqBase = sRLoader.loadInt();
            this.readRegisterSelect = sRLoader.loadBoolean();
            this.poll = sRLoader.loadBoolean();
            this.specialMask = sRLoader.loadBoolean();
            this.initState = sRLoader.loadInt();
            this.fourByteInit = sRLoader.loadBoolean();
            this.elcr = sRLoader.loadInt();
            this.elcrMask = sRLoader.loadInt();
            this.specialFullyNestedMode = sRLoader.loadBoolean();
            this.autoEOI = sRLoader.loadBoolean();
            this.rotateOnAutoEOI = sRLoader.loadBoolean();
            this.ioPorts = sRLoader.loadArrayInt();
            this.upperBackref = (InterruptController)sRLoader.loadObject();
        }

        public InterruptControllerElement(InterruptController interruptController, boolean bl) {
            if (bl) {
                this.ioPorts = new int[]{32, 33, 1232};
                this.elcrMask = 248;
            } else {
                this.ioPorts = new int[]{160, 161, 1233};
                this.elcrMask = 222;
            }
            this.upperBackref = interruptController;
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
            statusDumper.println("\tlastInterruptRequestRegister " + this.lastInterruptRequestRegister);
            statusDumper.println("\tinterruptRequestRegister " + this.interruptRequestRegister);
            statusDumper.println("\tinterruptMaskRegister " + this.interruptMaskRegister);
            statusDumper.println("\tinterruptServiceRegister " + this.interruptServiceRegister);
            statusDumper.println("\tpriorityAdd " + this.priorityAdd + " irqBase " + this.irqBase + " poll " + this.poll);
            statusDumper.println("\treadRegisterSelect " + this.readRegisterSelect);
            statusDumper.println("\tspecialMask " + this.specialMask + " initState " + this.initState + " fourByteInit " + this.fourByteInit);
            statusDumper.println("\telcr " + this.elcr + " elcrMask " + this.elcrMask);
            statusDumper.println("\tspecialFullyNestedMode " + this.specialFullyNestedMode);
            statusDumper.println("\tautoEOI " + this.autoEOI + " rotateOnAutoEOI " + this.rotateOnAutoEOI);
            for (int i = 0; i < this.ioPorts.length; ++i) {
                statusDumper.println("\tioPorts[" + i + "] " + this.ioPorts[i]);
            }
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": InterruptControllerElement:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public int[] ioPortsRequested() {
            return this.ioPorts;
        }

        public int ioPortRead(int n) {
            if (this.poll) {
                this.poll = false;
                return this.pollRead(n);
            }
            if ((n & 1) == 0) {
                if (this.readRegisterSelect) {
                    return this.interruptServiceRegister;
                }
                return this.interruptRequestRegister;
            }
            return this.interruptMaskRegister;
        }

        public int elcrRead() {
            return this.elcr;
        }

        public boolean ioPortWrite(int n, byte by) {
            block23: {
                block21: {
                    block24: {
                        block22: {
                            if ((n &= 1) != 0) break block21;
                            if (0 == (by & 0x10)) break block22;
                            this.reset();
                            this.upperBackref.connectedCPU.clearInterrupt();
                            this.initState = 1;
                            boolean bl = this.fourByteInit = (by & 1) != 0;
                            if (0 != (by & 2)) {
                                System.err.println("Warning: IRQ controller single mode not supported");
                            }
                            if (0 != (by & 8)) {
                                System.err.println("Warning: IRQ controller level sensitive irq not supported");
                            }
                            break block23;
                        }
                        if (0 == (by & 8)) break block24;
                        if (0 != (by & 4)) {
                            this.poll = true;
                        }
                        if (0 != (by & 2)) {
                            boolean bl = this.readRegisterSelect = (by & 1) != 0;
                        }
                        if (0 != (by & 0x40)) {
                            this.specialMask = (by >>> 5 & 1) != 0;
                        }
                        break block23;
                    }
                    int n2 = by >>> 5;
                    switch (n2) {
                        case 0: 
                        case 4: {
                            this.rotateOnAutoEOI = n2 >>> 2 != 0;
                            break;
                        }
                        case 1: 
                        case 5: {
                            int n3 = this.getPriority(this.interruptServiceRegister);
                            if (n3 != 8) {
                                int n4 = n3 + this.priorityAdd & 7;
                                this.interruptServiceRegister &= ~(1 << n4);
                                if (n2 == 5) {
                                    this.priorityAdd = n4 + 1 & 7;
                                }
                                return true;
                            }
                            break block23;
                        }
                        case 3: {
                            int n5 = by & 7;
                            this.interruptServiceRegister &= ~(1 << n5);
                            return true;
                        }
                        case 6: {
                            this.priorityAdd = by + 1 & 7;
                            return true;
                        }
                        case 7: {
                            int n6 = by & 7;
                            this.interruptServiceRegister &= ~(1 << n6);
                            this.priorityAdd = n6 + 1 & 7;
                            return true;
                        }
                    }
                    break block23;
                }
                switch (this.initState) {
                    case 0: {
                        this.interruptMaskRegister = by;
                        return true;
                    }
                    case 1: {
                        this.irqBase = by & 0xF8;
                        this.initState = 2;
                        break;
                    }
                    case 2: {
                        if (this.fourByteInit) {
                            this.initState = 3;
                            break;
                        }
                        this.initState = 0;
                        break;
                    }
                    case 3: {
                        this.specialFullyNestedMode = (by >>> 4 & 1) != 0;
                        this.autoEOI = (by >>> 1 & 1) != 0;
                        this.initState = 0;
                    }
                }
            }
            return false;
        }

        public void elcrWrite(int n) {
            this.elcr = n & this.elcrMask;
        }

        private int pollRead(int n) {
            int n2 = this.getIRQ();
            if (n2 < 0) {
                this.upperBackref.updateIRQ();
                return 7;
            }
            if (0 != n >>> 7) {
                this.upperBackref.masterPollCode();
            }
            this.interruptRequestRegister &= ~(1 << n2);
            this.interruptServiceRegister &= ~(1 << n2);
            if (0 != n >>> 7 || n2 != 2) {
                this.upperBackref.updateIRQ();
            }
            return n2;
        }

        public void setIRQ(int n, int n2) {
            int n3 = 1 << n;
            if (0 != (this.elcr & n3)) {
                if (0 != n2) {
                    this.interruptRequestRegister |= n3;
                    this.lastInterruptRequestRegister |= n3;
                } else {
                    this.interruptRequestRegister &= ~n3;
                    this.lastInterruptRequestRegister &= ~n3;
                }
            } else if (0 != n2) {
                if ((this.lastInterruptRequestRegister & n3) == 0) {
                    this.interruptRequestRegister |= n3;
                }
                this.lastInterruptRequestRegister |= n3;
            } else {
                this.lastInterruptRequestRegister &= ~n3;
            }
        }

        private int getPriority(int n) {
            if ((0xFF & n) == 0) {
                return 8;
            }
            int n2 = 0;
            while ((n & 1 << (n2 + this.priorityAdd & 7)) == 0) {
                ++n2;
            }
            return n2;
        }

        public int getIRQ() {
            int n;
            int n2 = this.interruptRequestRegister & ~this.interruptMaskRegister;
            int n3 = this.getPriority(n2);
            if (n3 == 8) {
                return -1;
            }
            n2 = this.interruptServiceRegister;
            if (this.specialFullyNestedMode && this.isMaster()) {
                n2 &= 0xFFFFFFFB;
            }
            if (n3 < (n = this.getPriority(n2))) {
                return n3 + this.priorityAdd & 7;
            }
            return -1;
        }

        private void intAck(int n) {
            if (this.autoEOI) {
                if (this.rotateOnAutoEOI) {
                    this.priorityAdd = n + 1 & 7;
                }
            } else {
                this.interruptServiceRegister |= 1 << n;
            }
            if (0 == (this.elcr & 1 << n)) {
                this.interruptRequestRegister &= ~(1 << n);
            }
        }

        private boolean isMaster() {
            return this.upperBackref.master == this;
        }

        private void reset() {
            this.lastInterruptRequestRegister = 0;
            this.interruptRequestRegister = 0;
            this.interruptMaskRegister = 0;
            this.interruptServiceRegister = 0;
            this.priorityAdd = 0;
            this.irqBase = 0;
            this.readRegisterSelect = false;
            this.poll = false;
            this.specialMask = false;
            this.autoEOI = false;
            this.rotateOnAutoEOI = false;
            this.specialFullyNestedMode = false;
            this.initState = 0;
            this.fourByteInit = false;
            this.elcr = 0;
        }

        public String toString() {
            if (this.isMaster()) {
                return this.upperBackref.toString() + ": [Master Element]";
            }
            return this.upperBackref.toString() + ": [Slave  Element]";
        }
    }
}

