/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.pci.PCIDevice;

public abstract class AbstractPCIDevice
extends AbstractHardwareComponent
implements PCIDevice {
    private int deviceFunctionNumber;
    private byte[] configuration;
    private int irq;
    private IRQBouncer irqBouncer;
    private boolean pciRegistered;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tdeviceFunctionNumber " + this.deviceFunctionNumber + " irq " + this.irq + " pciRegistered " + this.pciRegistered);
        statusDumper.println("\tirqBouncer <object #" + statusDumper.objectNumber(this.irqBouncer) + ">");
        if (this.irqBouncer != null) {
            this.irqBouncer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tconfiguration:");
        statusDumper.printArray(this.configuration, "configuration");
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": AbstractPCIDevice:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.deviceFunctionNumber);
        sRDumper.dumpInt(this.irq);
        sRDumper.dumpBoolean(this.pciRegistered);
        sRDumper.dumpObject(this.irqBouncer);
        sRDumper.dumpArray(this.configuration);
    }

    public AbstractPCIDevice(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.deviceFunctionNumber = sRLoader.loadInt();
        this.irq = sRLoader.loadInt();
        this.pciRegistered = sRLoader.loadBoolean();
        this.irqBouncer = (IRQBouncer)sRLoader.loadObject();
        this.configuration = sRLoader.loadArrayByte();
    }

    public AbstractPCIDevice() {
        this.pciRegistered = false;
        this.configuration = new byte[256];
    }

    @Override
    public int getDeviceFunctionNumber() {
        return this.deviceFunctionNumber;
    }

    @Override
    public void assignDeviceFunctionNumber(int n) {
        this.deviceFunctionNumber = n;
    }

    @Override
    public boolean autoAssignDeviceFunctionNumber() {
        return true;
    }

    @Override
    public void deassignDeviceFunctionNumber() {
        this.pciRegistered = false;
        this.assignDeviceFunctionNumber(-1);
    }

    private boolean checkConfigWrite(int n) {
        switch (0xFF & this.configReadByte(14)) {
            case 0: 
            case 128: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 61: {
                        return false;
                    }
                }
                return true;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean configWriteByte(int n, byte by) {
        if (this.checkConfigWrite(n)) {
            this.putConfigByte(n, by);
        }
        return n >= 4 && n < 6;
    }

    @Override
    public final boolean configWriteWord(int n, short s) {
        int n2 = n;
        for (int i = 0; i < 2; ++i) {
            if (this.checkConfigWrite(n2)) {
                this.putConfigByte(n2, (byte)s);
            }
            ++n2;
            s = (short)(s >>> 8);
        }
        return n2 > 4 && n < 6;
    }

    @Override
    public final boolean configWriteLong(int n, int n2) {
        int n3;
        IORegion iORegion;
        if ((n >= 16 && n < 40 || n >= 48 && n < 52) && (iORegion = this.getIORegion(n3 = n >= 48 ? 6 : n - 16 >>> 2)) != null) {
            if (n3 == 6) {
                n2 = (int)((long)n2 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL | 1L));
            } else {
                n2 = (int)((long)n2 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL));
                n2 |= iORegion.getType();
            }
            this.putConfigLong(n, n2);
            return true;
        }
        n3 = n;
        for (int i = 0; i < 4; ++i) {
            if (this.checkConfigWrite(n3)) {
                this.putConfigByte(n3, (byte)n2);
            }
            ++n3;
            n2 >>>= 8;
        }
        return n3 > 4 && n < 6;
    }

    @Override
    public final byte configReadByte(int n) {
        return this.configuration[n];
    }

    @Override
    public final short configReadWord(int n) {
        short s = this.configReadByte(n + 1);
        s = (short)(s << 8);
        s = (short)(s | 0xFF & this.configReadByte(n));
        return s;
    }

    @Override
    public final int configReadLong(int n) {
        int n2 = 0xFFFF & this.configReadWord(n + 2);
        n2 <<= 16;
        return n2 |= 0xFFFF & this.configReadWord(n);
    }

    @Override
    public final void putConfigByte(int n, byte by) {
        this.configuration[n] = by;
    }

    @Override
    public final void putConfigWord(int n, short s) {
        this.putConfigByte(n, (byte)s);
        s = (short)(s >> 8);
        this.putConfigByte(++n, (byte)s);
    }

    @Override
    public final void putConfigLong(int n, int n2) {
        this.putConfigWord(n, (short)n2);
        this.putConfigWord(n += 2, (short)(n2 >>= 16));
    }

    @Override
    public void setIRQIndex(int n) {
        this.irq = n;
    }

    @Override
    public int getIRQIndex() {
        return this.irq;
    }

    @Override
    public void addIRQBouncer(IRQBouncer iRQBouncer) {
        this.irqBouncer = iRQBouncer;
    }

    @Override
    public IRQBouncer getIRQBouncer() {
        return this.irqBouncer;
    }

    @Override
    public boolean initialised() {
        return this.pciRegistered;
    }

    @Override
    public void reset() {
        this.pciRegistered = false;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised() && !this.pciRegistered) {
            this.pciRegistered = ((PCIBus)hardwareComponent).registerDevice(this);
        }
    }

    @Override
    public boolean wantsMappingUpdate() {
        return false;
    }
}

