/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;

public interface PCIDevice
extends SRDumpable {
    public static final int PCI_ROM_SLOT = 6;
    public static final int PCI_NUM_REGIONS = 7;
    public static final int PCI_CONFIG_VENDOR_ID = 0;
    public static final int PCI_CONFIG_DEVICE_ID = 2;
    public static final int PCI_CONFIG_COMMAND = 4;
    public static final int PCI_CONFIG_STATUS = 6;
    public static final int PCI_CONFIG_REVISION = 8;
    public static final int PCI_CONFIG_CLASS_DEVICE = 10;
    public static final int PCI_CONFIG_CLS = 12;
    public static final int PCI_CONFIG_LATENCY = 13;
    public static final int PCI_CONFIG_HEADER = 14;
    public static final int PCI_CONFIG_BIST = 15;
    public static final int PCI_CONFIG_BASE_ADDRESS = 16;
    public static final int PCI_CONFIG_EXPANSION_ROM_BASE_ADDRESS = 48;
    public static final int PCI_CONFIG_INTERRUPT_LINE = 60;
    public static final int PCI_CONFIG_INTERRUPT_PIN = 61;
    public static final int PCI_CONFIG_MIN_GNT = 62;
    public static final int PCI_CONFIG_MAX_LATENCY = 63;
    public static final int PCI_COMMAND_IO = 1;
    public static final int PCI_COMMAND_MEMORY = 2;
    public static final int PCI_HEADER_PCI_PCI_BRIDGE = 1;
    public static final int PCI_HEADER_SINGLE_FUNCTION = 0;
    public static final int PCI_HEADER_MULTI_FUNCTION = 128;

    public int getDeviceFunctionNumber();

    public boolean autoAssignDeviceFunctionNumber();

    public void assignDeviceFunctionNumber(int var1);

    public void deassignDeviceFunctionNumber();

    public boolean configWriteByte(int var1, byte var2);

    public boolean configWriteWord(int var1, short var2);

    public boolean configWriteLong(int var1, int var2);

    public byte configReadByte(int var1);

    public short configReadWord(int var1);

    public int configReadLong(int var1);

    public void putConfigByte(int var1, byte var2);

    public void putConfigWord(int var1, short var2);

    public void putConfigLong(int var1, int var2);

    public IORegion[] getIORegions();

    public IORegion getIORegion(int var1);

    public void setIRQIndex(int var1);

    public int getIRQIndex();

    public void addIRQBouncer(IRQBouncer var1);

    public IRQBouncer getIRQBouncer();

    public boolean wantsMappingUpdate();

    public void dumpStatus(StatusDumper var1);
}

