/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import java.io.IOException;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.PCIBus;

public class PCIHostBridge
extends AbstractPCIDevice
implements IOPortCapable {
    private PCIBus attachedBus;
    private int configRegister;
    private boolean ioportRegistered;
    private boolean pciRegistered;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tconfigRegister" + this.configRegister);
        statusDumper.println("\tattachedBus <object #" + statusDumper.objectNumber(this.attachedBus) + ">");
        if (this.attachedBus != null) {
            this.attachedBus.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PCIHostBridge:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.configRegister);
        sRDumper.dumpObject(this.attachedBus);
    }

    public PCIHostBridge(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.configRegister = sRLoader.loadInt();
        this.attachedBus = (PCIBus)sRLoader.loadObject();
    }

    public PCIHostBridge() {
        this.ioportRegistered = false;
        this.assignDeviceFunctionNumber(0);
        this.putConfigWord(0, (short)-32634);
        this.putConfigWord(2, (short)4663);
        this.putConfigByte(8, (byte)2);
        this.putConfigWord(10, (short)1536);
        this.putConfigByte(14, (byte)0);
    }

    @Override
    public boolean autoAssignDeviceFunctionNumber() {
        return false;
    }

    @Override
    public void deassignDeviceFunctionNumber() {
        System.err.println("Warning: PCI device/function number conflict.");
    }

    @Override
    public IORegion[] getIORegions() {
        return null;
    }

    @Override
    public IORegion getIORegion(int n) {
        return null;
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{3320, 3321, 3322, 3323, 3324, 3325, 3326, 3327};
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) break;
                this.attachedBus.writePCIDataByte(this.configRegister | n & 3, (byte)n2);
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) break;
                this.attachedBus.writePCIDataWord(this.configRegister | n & 3, (short)n2);
                break;
            }
        }
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        switch (n) {
            case 3320: 
            case 3321: 
            case 3322: 
            case 3323: {
                this.configRegister = n2;
                break;
            }
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) break;
                this.attachedBus.writePCIDataLong(this.configRegister | n & 3, n2);
                break;
            }
        }
    }

    @Override
    public int ioPortReadByte(int n) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) {
                    return 255;
                }
                return 0xFF & this.attachedBus.readPCIDataByte(this.configRegister | n & 3);
            }
        }
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) {
                    return 65535;
                }
                return 0xFFFF & this.attachedBus.readPCIDataWord(this.configRegister | n & 3);
            }
        }
        return 65535;
    }

    @Override
    public int ioPortReadLong(int n) {
        switch (n) {
            case 3320: 
            case 3321: 
            case 3322: 
            case 3323: {
                return this.configRegister;
            }
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) {
                    return -1;
                }
                return this.attachedBus.readPCIDataLong(this.configRegister | n & 3);
            }
        }
        return -1;
    }

    @Override
    public boolean initialised() {
        return this.ioportRegistered && this.pciRegistered;
    }

    @Override
    public void reset() {
        this.attachedBus = null;
        this.pciRegistered = false;
        this.ioportRegistered = false;
        this.assignDeviceFunctionNumber(0);
        this.putConfigWord(0, (short)-32634);
        this.putConfigWord(2, (short)4663);
        this.putConfigByte(8, (byte)2);
        this.putConfigWord(10, (short)1536);
        this.putConfigByte(14, (byte)0);
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised() && !this.pciRegistered) {
            this.attachedBus = (PCIBus)hardwareComponent;
            this.pciRegistered = this.attachedBus.registerDevice(this);
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public String toString() {
        return "Intel i440FX PCI-Host Bridge";
    }
}

