/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import java.io.IOException;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.DiskImage;
import org.jpc.diskimages.GenericBlockDevice;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.DMAController;
import org.jpc.emulator.motherboard.DMATransferCapable;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;

public class FloppyController
implements IOPortCapable,
DMATransferCapable,
HardwareComponent,
TimerResponsive {
    private static final int SECTOR_LENGTH = 512;
    private static final int SECTOR_SIZE_CODE = 2;
    private static final int CONTROL_ACTIVE = 1;
    private static final int CONTROL_RESET = 2;
    private static final int CONTROL_SLEEP = 4;
    private static final int CONTROL_BUSY = 8;
    private static final int CONTROL_INTERRUPT = 16;
    private static final int DIRECTION_WRITE = 0;
    private static final int DIRECTION_READ = 1;
    private static final int DIRECTION_SCANE = 2;
    private static final int DIRECTION_SCANL = 3;
    private static final int DIRECTION_SCANH = 4;
    private static final int STATE_COMMAND = 0;
    private static final int STATE_STATUS = 1;
    private static final int STATE_DATA = 2;
    private static final int STATE_STATE = 3;
    private static final int STATE_MULTI = 16;
    private static final int STATE_SEEK = 32;
    private static final int STATE_FORMAT = 64;
    private static final byte CONTROLLER_VERSION = -112;
    private static final int INTERRUPT_LEVEL = 6;
    private static final int DMA_CHANNEL = 2;
    private static final int IOPORT_BASE = 1008;
    private boolean drivesUpdated;
    private Timer resultTimer;
    private Clock clock;
    private int state;
    private boolean dmaEnabled;
    private int currentDrive;
    private int bootSelect;
    private byte[] fifo;
    private int dataOffset;
    private int dataLength;
    private int dataState;
    private int dataDirection;
    private int interruptStatus;
    private byte eot;
    private byte timer0;
    private byte timer1;
    private byte preCompensationTrack;
    private byte config;
    private byte lock;
    private byte pwrd;
    private FloppyDrive[] drives;
    private InterruptController irqDevice;
    private DMAController dma;
    private boolean ioportRegistered;

    public FloppyController() {
        this.ioportRegistered = false;
        this.drives = new FloppyDrive[2];
        this.config = (byte)96;
        this.state = 1;
        this.fifo = new byte[512];
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        int n;
        statusDumper.println("\tdrivesUpdated " + this.drivesUpdated + " state " + this.state + " dmaEnabled " + this.dmaEnabled);
        statusDumper.println("\tcurrentDrive " + this.currentDrive + " bootSelect " + this.bootSelect + " dataOffset " + this.dataOffset);
        statusDumper.println("\tdataLength " + this.dataLength + " dataState " + this.dataState + " dataDirection " + this.dataDirection);
        statusDumper.println("\tinterruptStatus " + this.interruptStatus + " eot " + this.eot + " timer0 " + this.timer0);
        statusDumper.println("\ttimer1 " + this.timer1 + " preCompensationTrack " + this.preCompensationTrack);
        statusDumper.println("\tconfig " + this.config + " lock " + this.lock + " pwrd " + this.pwrd);
        statusDumper.println("\tresultTimer <object #" + statusDumper.objectNumber(this.resultTimer) + ">");
        if (this.resultTimer != null) {
            this.resultTimer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tclock <object #" + statusDumper.objectNumber(this.clock) + ">");
        if (this.clock != null) {
            this.clock.dumpStatus(statusDumper);
        }
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        statusDumper.println("\tdma <object #" + statusDumper.objectNumber(this.dma) + ">");
        if (this.dma != null) {
            this.dma.dumpStatus(statusDumper);
        }
        for (n = 0; n < this.drives.length; ++n) {
            statusDumper.println("\tdrives[" + n + "] <object #" + statusDumper.objectNumber(this.drives[n]) + ">");
            if (this.drives[n] == null) continue;
            this.drives[n].dumpStatus(statusDumper);
        }
        for (n = 0; n < this.fifo.length; ++n) {
            statusDumper.println("\tfifo[" + n + "] " + this.fifo[n]);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": FloppyController:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpBoolean(this.drivesUpdated);
        sRDumper.dumpObject(this.resultTimer);
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpInt(this.state);
        sRDumper.dumpBoolean(this.dmaEnabled);
        sRDumper.dumpInt(this.currentDrive);
        sRDumper.dumpInt(this.bootSelect);
        sRDumper.dumpArray(this.fifo);
        sRDumper.dumpInt(this.dataOffset);
        sRDumper.dumpInt(this.dataLength);
        sRDumper.dumpInt(this.dataState);
        sRDumper.dumpInt(this.dataDirection);
        sRDumper.dumpInt(this.interruptStatus);
        sRDumper.dumpByte(this.eot);
        sRDumper.dumpByte(this.timer0);
        sRDumper.dumpByte(this.timer1);
        sRDumper.dumpByte(this.preCompensationTrack);
        sRDumper.dumpByte(this.config);
        sRDumper.dumpByte(this.lock);
        sRDumper.dumpByte(this.pwrd);
        sRDumper.dumpInt(this.drives.length);
        for (int i = 0; i < this.drives.length; ++i) {
            sRDumper.dumpObject(this.drives[i]);
        }
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpObject(this.dma);
    }

    public FloppyController(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.drivesUpdated = sRLoader.loadBoolean();
        this.resultTimer = (Timer)sRLoader.loadObject();
        this.clock = (Clock)sRLoader.loadObject();
        this.state = sRLoader.loadInt();
        this.dmaEnabled = sRLoader.loadBoolean();
        this.currentDrive = sRLoader.loadInt();
        this.bootSelect = sRLoader.loadInt();
        this.fifo = sRLoader.loadArrayByte();
        this.dataOffset = sRLoader.loadInt();
        this.dataLength = sRLoader.loadInt();
        this.dataState = sRLoader.loadInt();
        this.dataDirection = sRLoader.loadInt();
        this.interruptStatus = sRLoader.loadInt();
        this.eot = sRLoader.loadByte();
        this.timer0 = sRLoader.loadByte();
        this.timer1 = sRLoader.loadByte();
        this.preCompensationTrack = sRLoader.loadByte();
        this.config = sRLoader.loadByte();
        this.lock = sRLoader.loadByte();
        this.pwrd = sRLoader.loadByte();
        this.drives = new FloppyDrive[sRLoader.loadInt()];
        for (int i = 0; i < this.drives.length; ++i) {
            this.drives[i] = (FloppyDrive)sRLoader.loadObject();
        }
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.dma = (DMAController)sRLoader.loadObject();
    }

    @Override
    public int getTimerType() {
        return 1;
    }

    @Override
    public void callback() {
        this.stopTransfer((byte)0, (byte)0, (byte)0);
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{1009, 1010, 1011, 1012, 1013, 1015};
    }

    @Override
    public int ioPortReadByte(int n) {
        switch (n & 7) {
            case 1: {
                return this.readStatusB();
            }
            case 2: {
                return this.readDOR();
            }
            case 3: {
                return this.readTape();
            }
            case 4: {
                return this.readMainStatus();
            }
            case 5: {
                return this.readData();
            }
            case 7: {
                return this.readDirection();
            }
        }
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) & 0xFF | this.ioPortReadByte(n + 1) << 8 & 0xFF00;
    }

    @Override
    public int ioPortReadLong(int n) {
        return this.ioPortReadWord(n) & 0xFFFF | this.ioPortReadWord(n + 2) << 16 & 0xFFFF0000;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n & 7) {
            case 2: {
                this.writeDOR(n2);
                break;
            }
            case 3: {
                this.writeTape(n2);
                break;
            }
            case 4: {
                this.writeRate(n2);
                break;
            }
            case 5: {
                this.writeData(n2);
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2 & 0xFFFF);
        this.ioPortWriteWord(n + 2, n2 >>> 16 & 0xFFFF);
    }

    private void reset(boolean bl) {
        this.resetIRQ();
        this.currentDrive = 0;
        this.dataOffset = 0;
        this.dataLength = 0;
        this.dataState = 0;
        this.dataDirection = 0;
        this.drives[0].reset();
        this.drives[1].reset();
        this.resetFIFO();
        if (bl) {
            this.raiseIRQ(192);
        }
    }

    private void raiseIRQ(int n) {
        if (~(this.state & 0x10) != 0) {
            this.irqDevice.setIRQ(6, 1);
            this.state |= 0x10;
        }
        this.interruptStatus = n;
    }

    private void resetFIFO() {
        this.dataDirection = 0;
        this.dataOffset = 0;
        this.dataState = this.dataState & 0xFFFFFFFC | 0;
    }

    private void resetIRQ() {
        this.irqDevice.setIRQ(6, 0);
        this.state &= 0xFFFFFFEF;
    }

    private int readStatusB() {
        return 0;
    }

    private int readDOR() {
        int n = 0;
        if ((this.getDrive((int)0).driveFlags & 1) != 0) {
            n |= 0x20;
        }
        if ((this.getDrive((int)1).driveFlags & 1) != 0) {
            n |= 0x10;
        }
        n |= this.dmaEnabled ? 8 : 0;
        n |= (this.state & 2) == 0 ? 4 : 0;
        return n |= this.currentDrive;
    }

    private int readTape() {
        return this.bootSelect << 2;
    }

    private int readMainStatus() {
        int n = 0;
        this.state &= 0xFFFFFFF9;
        if ((this.state & 8) == 0) {
            n |= 0x80;
            if (this.dataDirection == 1) {
                n |= 0x40;
            }
        }
        if ((this.dataState & 3) == 2 || (this.dataState & 3) == 1) {
            n |= 0x10;
        }
        return n;
    }

    private int readData() {
        int n;
        FloppyDrive floppyDrive = this.getCurrentDrive();
        this.state &= 0xFFFFFFFB;
        if ((this.dataState & 3) == 0) {
            System.err.println("Warning: FDC cannot read data in command state");
            return 0;
        }
        int n2 = this.dataOffset;
        if ((this.dataState & 3) == 2 && (n2 %= 512) == 0) {
            n = Math.min(this.dataLength - this.dataOffset, 512);
            floppyDrive.read(floppyDrive.currentSector(), this.fifo, n);
        }
        n = this.fifo[n2];
        if (++this.dataOffset == this.dataLength) {
            this.dataOffset = 0;
            if ((this.dataState & 3) == 2) {
                this.stopTransfer((byte)32, (byte)0, (byte)0);
            } else {
                this.resetFIFO();
                this.resetIRQ();
            }
        }
        return n;
    }

    private int readDirection() {
        int n = 0;
        if ((this.getDrive((int)0).driveFlags & 2) != 0 || (this.getDrive((int)1).driveFlags & 2) != 0) {
            n |= 0x80;
        }
        this.getDrive((int)0).driveFlags &= 0xFFFFFFFD;
        this.getDrive((int)1).driveFlags &= 0xFFFFFFFD;
        return n;
    }

    private void writeDOR(int n) {
        if ((this.state & 2) != 0 && (n & 4) == 0) {
            return;
        }
        if ((n & 0x20) != 0) {
            this.getDrive(1).start();
        } else {
            this.getDrive(1).stop();
        }
        if ((n & 0x10) != 0) {
            this.getDrive(0).start();
        } else {
            this.getDrive(0).stop();
        }
        if ((n & 4) == 0) {
            if ((this.state & 2) == 0) {
                this.state |= 2;
            } else if ((this.state & 2) != 0) {
                this.reset(true);
                this.state &= 0xFFFFFFF9;
            }
        }
        this.currentDrive = n & 1;
    }

    private void writeTape(int n) {
        if ((this.state & 2) != 0) {
            return;
        }
        this.bootSelect = n >>> 2 & 1;
    }

    private void writeRate(int n) {
        if ((this.state & 2) != 0) {
            return;
        }
        if ((n & 0x80) != 0) {
            this.state |= 2;
            this.reset(true);
            this.state &= 0xFFFFFFFD;
        }
        if ((n & 0x40) != 0) {
            this.state |= 4;
            this.reset(true);
        }
    }

    private void writeData(int n) {
        FloppyDrive floppyDrive = this.getCurrentDrive();
        if ((this.state & 2) != 0) {
            System.err.println("Warning: FDC cannot write data in reset state");
            return;
        }
        this.state &= 0xFFFFFFFB;
        if ((this.dataState & 3) == 1) {
            System.err.println("Warning: FDC cannot write data in status mode");
            return;
        }
        if ((this.dataState & 3) == 2) {
            this.fifo[this.dataOffset++] = (byte)n;
            if (this.dataOffset % 512 == 511 || this.dataOffset == this.dataLength) {
                floppyDrive.write(floppyDrive.currentSector(), this.fifo, 512);
            }
            if ((this.dataState & 3) == 2) {
                this.stopTransfer((byte)32, (byte)0, (byte)0);
            }
            return;
        }
        if (this.dataOffset == 0) {
            switch (n & 0x5F) {
                case 70: 
                case 76: 
                case 80: 
                case 86: 
                case 89: 
                case 93: {
                    this.dataLength = 9;
                    this.enqueue(floppyDrive, n);
                    return;
                }
            }
            switch (n & 0x7F) {
                case 69: 
                case 73: {
                    this.dataLength = 9;
                    this.enqueue(floppyDrive, n);
                    return;
                }
            }
            switch (n) {
                case 3: 
                case 15: {
                    this.dataLength = 3;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 4: 
                case 7: 
                case 18: 
                case 51: 
                case 74: {
                    this.dataLength = 2;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 8: {
                    this.fifo[0] = (byte)(0x20 | floppyDrive.head << 2 | this.currentDrive);
                    this.fifo[1] = (byte)floppyDrive.track;
                    this.setFIFO(2, false);
                    this.resetIRQ();
                    this.interruptStatus = 192;
                    return;
                }
                case 14: {
                    this.fifo[0] = (byte)this.getDrive((int)0).track;
                    this.fifo[1] = (byte)this.getDrive((int)1).track;
                    this.fifo[2] = 0;
                    this.fifo[3] = 0;
                    this.fifo[4] = this.timer0;
                    this.fifo[5] = this.dmaEnabled ? (byte)(this.timer1 << 1) : (byte)0;
                    this.fifo[6] = (byte)floppyDrive.sectorCount;
                    this.fifo[7] = (byte)(this.lock << 7 | floppyDrive.perpendicular << 2);
                    this.fifo[8] = this.config;
                    this.fifo[9] = this.preCompensationTrack;
                    this.setFIFO(10, false);
                    return;
                }
                case 16: {
                    this.fifo[0] = -112;
                    this.setFIFO(1, true);
                    return;
                }
                case 19: {
                    this.dataLength = 4;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 20: {
                    this.lock = 0;
                    this.fifo[0] = 0;
                    this.setFIFO(1, false);
                    return;
                }
                case 23: 
                case 143: 
                case 207: {
                    this.dataLength = 3;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 24: {
                    this.fifo[0] = 65;
                    this.setFIFO(1, false);
                    return;
                }
                case 44: {
                    this.fifo[0] = 0;
                    this.fifo[1] = 0;
                    this.fifo[2] = (byte)this.getDrive((int)0).track;
                    this.fifo[3] = (byte)this.getDrive((int)1).track;
                    this.fifo[4] = 0;
                    this.fifo[5] = 0;
                    this.fifo[6] = this.timer0;
                    this.fifo[7] = this.timer1;
                    this.fifo[8] = (byte)floppyDrive.sectorCount;
                    this.fifo[9] = (byte)(this.lock << 7 | floppyDrive.perpendicular << 2);
                    this.fifo[10] = this.config;
                    this.fifo[11] = this.preCompensationTrack;
                    this.fifo[12] = this.pwrd;
                    this.fifo[13] = 0;
                    this.fifo[14] = 0;
                    this.setFIFO(15, true);
                    return;
                }
                case 66: {
                    this.dataLength = 9;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 76: {
                    this.dataLength = 18;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 77: 
                case 142: {
                    this.dataLength = 6;
                    this.enqueue(floppyDrive, n);
                    return;
                }
                case 148: {
                    this.lock = 1;
                    this.fifo[0] = 16;
                    this.setFIFO(1, true);
                    return;
                }
                case 205: {
                    this.dataLength = 11;
                    this.enqueue(floppyDrive, n);
                    return;
                }
            }
            this.unimplemented();
            return;
        }
        this.enqueue(floppyDrive, n);
    }

    private void enqueue(FloppyDrive floppyDrive, int n) {
        this.fifo[this.dataOffset] = (byte)n;
        if (++this.dataOffset == this.dataLength) {
            if ((this.dataState & 0x40) != 0) {
                this.formatSector();
                return;
            }
            switch (this.fifo[0] & 0x1F) {
                case 6: {
                    this.startTransfer(1);
                    return;
                }
                case 12: {
                    this.startTransferDelete(1);
                    return;
                }
                case 22: {
                    this.stopTransfer((byte)32, (byte)0, (byte)0);
                    return;
                }
                case 16: {
                    this.startTransfer(2);
                    return;
                }
                case 25: {
                    this.startTransfer(3);
                    return;
                }
                case 29: {
                    this.startTransfer(4);
                    return;
                }
            }
            switch (this.fifo[0] & 0x3F) {
                case 5: {
                    this.startTransfer(0);
                    return;
                }
                case 9: {
                    this.startTransferDelete(0);
                    return;
                }
            }
            switch (this.fifo[0]) {
                case 3: {
                    this.timer0 = (byte)(this.fifo[1] >>> 4 & 0xF);
                    this.timer1 = (byte)(this.fifo[2] >>> 1);
                    this.dmaEnabled = (this.fifo[2] & 1) != 1;
                    this.resetFIFO();
                    break;
                }
                case 4: {
                    this.currentDrive = this.fifo[1] & 1;
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.head = this.fifo[1] >>> 2 & 1;
                    this.fifo[0] = (byte)(floppyDrive.readOnly << 6 | (floppyDrive.track == 0 ? 16 : 0) | floppyDrive.head << 2 | this.currentDrive | 0x28);
                    this.setFIFO(1, false);
                    break;
                }
                case 7: {
                    this.currentDrive = this.fifo[1] & 1;
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.recalibrate();
                    this.resetFIFO();
                    this.raiseIRQ(32);
                    break;
                }
                case 15: {
                    this.currentDrive = this.fifo[1] & 1;
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.start();
                    floppyDrive.direction = this.fifo[2] <= floppyDrive.track ? 1 : 0;
                    this.resetFIFO();
                    if (this.fifo[2] > floppyDrive.maxTrack) {
                        this.raiseIRQ(96);
                        break;
                    }
                    floppyDrive.track = this.fifo[2];
                    this.raiseIRQ(32);
                    break;
                }
                case 18: {
                    if ((this.fifo[1] & 0x80) != 0) {
                        floppyDrive.perpendicular = this.fifo[1] & 7;
                    }
                    this.resetFIFO();
                    break;
                }
                case 19: {
                    this.config = this.fifo[2];
                    this.preCompensationTrack = this.fifo[3];
                    this.resetFIFO();
                    break;
                }
                case 23: {
                    this.pwrd = this.fifo[1];
                    this.fifo[0] = this.fifo[1];
                    this.setFIFO(1, true);
                    break;
                }
                case 51: {
                    this.resetFIFO();
                    break;
                }
                case 66: {
                    System.err.println("Warning: FDC implement READ_TRACK command");
                    this.startTransfer(1);
                    break;
                }
                case 74: {
                    floppyDrive.head = this.fifo[1] >>> 2 & 1;
                    this.resultTimer.setExpiry(this.clock.getTime() + this.clock.getTickRate() / 50L);
                    break;
                }
                case 76: {
                    this.getDrive((int)0).track = this.fifo[3];
                    this.getDrive((int)1).track = this.fifo[4];
                    this.timer0 = this.fifo[7];
                    this.timer1 = this.fifo[8];
                    floppyDrive.sectorCount = this.fifo[9];
                    this.lock = (byte)(this.fifo[10] >>> 7);
                    floppyDrive.perpendicular = this.fifo[10] >>> 2 & 0xF;
                    this.config = this.fifo[11];
                    this.preCompensationTrack = this.fifo[12];
                    this.pwrd = this.fifo[13];
                    this.resetFIFO();
                    break;
                }
                case 77: {
                    this.currentDrive = this.fifo[1] & 1;
                    floppyDrive = this.getCurrentDrive();
                    this.dataState |= 0x40;
                    this.dataState = (this.fifo[0] & 0x80) != 0 ? (this.dataState |= 0x10) : (this.dataState &= 0xFFFFFFEF);
                    this.dataState &= 0xFFFFFFDF;
                    floppyDrive.bps = this.fifo[2] > 7 ? 16384 : 128 << this.fifo[2];
                    floppyDrive.sectorCount = this.fifo[3];
                    this.dataState &= 0xFFFFFFBF;
                    this.stopTransfer((byte)0, (byte)0, (byte)0);
                    break;
                }
                case -114: {
                    if ((this.fifo[this.dataOffset - 1] & 0x80) != 0) {
                        if ((this.fifo[this.dataOffset - 1] & 0x40) != 0) {
                            this.fifo[0] = this.fifo[1];
                            this.fifo[2] = 0;
                            this.fifo[3] = 0;
                            this.setFIFO(4, true);
                            break;
                        }
                        this.resetFIFO();
                        break;
                    }
                    if (this.dataLength <= 7) break;
                    this.fifo[0] = (byte)(0x80 | floppyDrive.head << 2 | this.currentDrive);
                    this.setFIFO(1, true);
                    break;
                }
                case -113: {
                    this.currentDrive = this.fifo[1] & 1;
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.start();
                    floppyDrive.direction = 0;
                    floppyDrive.track = this.fifo[2] + floppyDrive.track >= floppyDrive.maxTrack ? floppyDrive.maxTrack - 1 : (floppyDrive.track += this.fifo[2]);
                    this.resetFIFO();
                    this.raiseIRQ(32);
                    break;
                }
                case -51: {
                    System.err.println("Warning: FDC implement FORMAT_AND_WRITE command");
                    this.unimplemented();
                    break;
                }
                case -49: {
                    this.currentDrive = this.fifo[1] & 1;
                    floppyDrive = this.getCurrentDrive();
                    floppyDrive.start();
                    floppyDrive.direction = 1;
                    floppyDrive.track = this.fifo[2] > floppyDrive.track ? 0 : (floppyDrive.track -= this.fifo[2]);
                    this.resetFIFO();
                    this.raiseIRQ(32);
                }
            }
        }
    }

    private void setFIFO(int n, boolean bl) {
        this.dataDirection = 1;
        this.dataLength = n;
        this.dataOffset = 0;
        this.dataState = this.dataState & 0xFFFFFFFC | 1;
        if (bl) {
            this.raiseIRQ(0);
        }
    }

    private FloppyDrive getCurrentDrive() {
        return this.getDrive(this.currentDrive);
    }

    private FloppyDrive getDrive(int n) {
        return this.drives[n - this.bootSelect];
    }

    public void changeDisk(DiskImage diskImage, int n) throws IOException {
        this.getDrive(n).changeDisk(diskImage);
    }

    private void unimplemented() {
        this.fifo[0] = -128;
        this.setFIFO(1, false);
    }

    private void startTransfer(int n) {
        int n2;
        this.currentDrive = this.fifo[1] & 1;
        FloppyDrive floppyDrive = this.getCurrentDrive();
        byte by = this.fifo[2];
        byte by2 = this.fifo[3];
        byte by3 = this.fifo[4];
        boolean bl = false;
        switch (floppyDrive.seek(0xFF & by2, 0xFF & by, 0xFF & by3, floppyDrive.sectorCount)) {
            case 2: {
                this.stopTransfer((byte)64, (byte)0, (byte)0);
                this.fifo[3] = by;
                this.fifo[4] = by2;
                this.fifo[5] = by3;
                return;
            }
            case 3: {
                this.stopTransfer((byte)64, (byte)-128, (byte)0);
                this.fifo[3] = by;
                this.fifo[4] = by2;
                this.fifo[5] = by3;
                return;
            }
            case 4: {
                this.stopTransfer((byte)64, (byte)0, (byte)0);
                this.fifo[3] = by;
                this.fifo[4] = by2;
                this.fifo[5] = by3;
                return;
            }
            case 1: {
                bl = true;
                break;
            }
        }
        this.dataDirection = n;
        this.dataOffset = 0;
        this.dataState = this.dataState & 0xFFFFFFFC | 2;
        this.dataState = (this.fifo[0] & 0x80) != 0 ? (this.dataState |= 0x10) : (this.dataState &= 0xFFFFFFEF);
        this.dataState = bl ? (this.dataState |= 0x20) : (this.dataState &= 0xFFFFFFDF);
        if (this.fifo[5] == 0) {
            this.dataLength = this.fifo[8];
        } else {
            this.dataLength = 128 << this.fifo[5];
            n2 = floppyDrive.sectorCount - by3 + 1;
            if ((this.fifo[0] & 0x80) != 0) {
                n2 += floppyDrive.sectorCount;
            }
            this.dataLength *= n2;
        }
        this.eot = this.fifo[6];
        if (this.dmaEnabled) {
            n2 = this.dma.getChannelMode(2);
            n2 = n2 >>> 2 & 3;
            if ((n == 2 || n == 3 || n == 4) && n2 == 0 || n == 0 && n2 == 2 || n == 1 && n2 == 1) {
                this.state |= 8;
                this.dma.holdDmaRequest(2);
                return;
            }
            System.err.println("Warning: FDC DMA mode " + n2 + ", direction" + n + ".");
        }
        this.raiseIRQ(0);
    }

    private void stopTransfer(byte by, byte by2, byte by3) {
        FloppyDrive floppyDrive = this.getCurrentDrive();
        this.fifo[0] = (byte)(by | floppyDrive.head << 2 | this.currentDrive);
        this.fifo[1] = by2;
        this.fifo[2] = by3;
        this.fifo[3] = (byte)floppyDrive.track;
        this.fifo[4] = (byte)floppyDrive.head;
        this.fifo[5] = (byte)floppyDrive.sector;
        this.fifo[6] = 2;
        this.dataDirection = 1;
        if ((this.state & 8) != 0) {
            this.dma.releaseDmaRequest(2);
            this.state &= 0xFFFFFFF7;
        }
        this.setFIFO(7, true);
    }

    private void startTransferDelete(int n) {
        this.stopTransfer((byte)96, (byte)0, (byte)0);
    }

    private void formatSector() {
        System.err.println("Warning: FDC format sector not implemented");
    }

    private static int memcmp(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i + n]) continue;
            return byArray[i] - byArray2[i + n];
        }
        return 0;
    }

    @Override
    public int handleTransfer(DMAController.DMAChannel dMAChannel, int n, int n2) {
        int n3;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        if ((this.state & 8) == 0) {
            return 0;
        }
        FloppyDrive floppyDrive = this.getCurrentDrive();
        if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
            by3 = 4;
        }
        n2 = Math.min(n2, this.dataLength);
        if (floppyDrive.device == null) {
            if (this.dataDirection == 0) {
                this.stopTransfer((byte)96, (byte)0, (byte)0);
            } else {
                this.stopTransfer((byte)64, (byte)0, (byte)0);
            }
            return 0;
        }
        int n4 = this.dataOffset % 512;
        int n5 = this.dataOffset;
        while (this.dataOffset < n2) {
            n3 = Math.min(n2 - this.dataOffset, 512 - n4);
            if ((this.dataDirection != 0 || n3 < 512 || n4 != 0) && floppyDrive.read(floppyDrive.currentSector(), this.fifo, 1) < 0) {
                for (int i = 0; i < Math.min(this.fifo.length, 512); ++i) {
                    this.fifo[i] = 0;
                }
            }
            switch (this.dataDirection) {
                case 1: {
                    dMAChannel.writeMemory(this.fifo, n4, this.dataOffset, n3);
                    break;
                }
                case 0: {
                    dMAChannel.readMemory(this.fifo, n4, this.dataOffset, n3);
                    if (floppyDrive.write(floppyDrive.currentSector(), this.fifo, 1) >= 0) break;
                    this.stopTransfer((byte)96, (byte)0, (byte)0);
                    return n3;
                }
                default: {
                    byte[] byArray = new byte[512];
                    dMAChannel.readMemory(byArray, 0, this.dataOffset, n3);
                    int n6 = FloppyController.memcmp(byArray, this.fifo, n4, n3);
                    if (n6 == 0) {
                        by3 = 8;
                        n3 = this.dataOffset - n5;
                        if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
                            by3 = 8;
                        }
                        if ((this.dataState & 0x20) != 0) {
                            by = (byte)(by | 0x20);
                        }
                        this.dataLength -= n3;
                        this.stopTransfer(by, by2, by3);
                        return n3;
                    }
                    if ((n6 >= 0 || this.dataDirection != 3) && (n6 <= 0 || this.dataDirection != 4)) break;
                    by3 = 0;
                    n3 = this.dataOffset - n5;
                    if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
                        by3 = 8;
                    }
                    if ((this.dataState & 0x20) != 0) {
                        by = (byte)(by | 0x20);
                    }
                    this.dataLength -= n3;
                    this.stopTransfer(by, by2, by3);
                    return n3;
                }
            }
            this.dataOffset += n3;
            n4 = this.dataOffset % 512;
            if (n4 != 0) continue;
            if (floppyDrive.sector >= floppyDrive.sectorCount || floppyDrive.sector == this.eot) {
                floppyDrive.sector = 1;
                if ((this.dataState & 0x10) != 0) {
                    if (floppyDrive.head == 0 && floppyDrive.headCount > 0) {
                        floppyDrive.head = 1;
                        continue;
                    }
                    floppyDrive.head = 0;
                    ++floppyDrive.track;
                    continue;
                }
                ++floppyDrive.track;
                continue;
            }
            ++floppyDrive.sector;
        }
        n3 = this.dataOffset - n5;
        if (this.dataDirection == 2 || this.dataDirection == 3 || this.dataDirection == 4) {
            by3 = 8;
        }
        if ((this.dataState & 0x20) != 0) {
            by = (byte)(by | 0x20);
        }
        this.dataLength -= n3;
        this.stopTransfer(by, by2, by3);
        return n3;
    }

    @Override
    public void reset() {
        this.irqDevice = null;
        this.clock = null;
        this.resultTimer = null;
        this.dma = null;
        this.ioportRegistered = false;
        this.fifo = new byte[512];
        this.config = (byte)96;
        this.drives[0].reset();
        this.drives[1].reset();
        this.state = 1;
    }

    @Override
    public boolean initialised() {
        return this.irqDevice != null && this.clock != null && this.dma != null && this.drives[0] != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
            this.resultTimer = this.clock.newTimer(this);
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof DMAController && hardwareComponent.initialised() && ((DMAController)hardwareComponent).isPrimary()) {
            this.dma = (DMAController)hardwareComponent;
            this.dmaEnabled = true;
            this.dma.registerChannel(2, this);
        }
        if (this.drives[0] == null) {
            this.drives[0] = new FloppyDrive(new GenericBlockDevice(BlockDevice.Type.FLOPPY));
            this.drives[1] = new FloppyDrive(new GenericBlockDevice(BlockDevice.Type.FLOPPY));
        }
        if (this.initialised()) {
            this.reset(false);
            for (int i = 0; i < 2; ++i) {
                if (this.drives[i] == null) continue;
                this.drives[i].revalidate();
            }
        }
    }

    public String toString() {
        if (this.drives[0] != null && this.drives[1] != null) {
            return "Intel 82078 Floppy Controller [A:" + this.drives[0].toString() + ", B:" + this.drives[1].toString() + "]";
        }
        if (this.drives[0] != null && this.drives[1] == null) {
            return "Intel 82078 Floppy Controller [A:" + this.drives[0].toString() + "]";
        }
        if (this.drives[0] == null && this.drives[1] != null) {
            return "Intel 82078 Floppy Controller [B:" + this.drives[1].toString() + "]";
        }
        if (this.drives[0] == null && this.drives[1] == null) {
            return "Intel 82078 Floppy Controller [<no drives>]";
        }
        return "Intel 82078 Floppy Controller [CAN'T HAPPEN]";
    }

    public static class FloppyDrive
    implements SRDumpable {
        static final int MOTOR_ON = 1;
        static final int REVALIDATE = 2;
        static final int DOUBLE_SIDES = 1;
        BlockDevice device;
        int driveFlags;
        int perpendicular;
        int head;
        int headCount;
        int track;
        int sector;
        int sectorCount;
        int direction;
        int readWrite;
        int flags;
        int maxTrack;
        int bps;
        int readOnly;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.device);
            sRDumper.dumpInt(this.driveFlags);
            sRDumper.dumpInt(this.perpendicular);
            sRDumper.dumpInt(this.head);
            sRDumper.dumpInt(this.track);
            sRDumper.dumpInt(this.sector);
            sRDumper.dumpInt(this.direction);
            sRDumper.dumpInt(this.readWrite);
            sRDumper.dumpInt(this.flags);
            sRDumper.dumpInt(this.maxTrack);
            sRDumper.dumpInt(this.bps);
            sRDumper.dumpInt(this.readOnly);
            sRDumper.dumpInt(this.headCount);
            sRDumper.dumpInt(this.sectorCount);
        }

        public FloppyDrive(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.device = (BlockDevice)sRLoader.loadObject();
            this.driveFlags = sRLoader.loadInt();
            this.perpendicular = sRLoader.loadInt();
            this.head = sRLoader.loadInt();
            this.track = sRLoader.loadInt();
            this.sector = sRLoader.loadInt();
            this.direction = sRLoader.loadInt();
            this.readWrite = sRLoader.loadInt();
            this.flags = sRLoader.loadInt();
            this.maxTrack = sRLoader.loadInt();
            this.bps = sRLoader.loadInt();
            this.readOnly = sRLoader.loadInt();
            this.headCount = sRLoader.loadInt();
            this.sectorCount = sRLoader.loadInt();
        }

        FloppyDrive(BlockDevice blockDevice) {
            this.device = blockDevice;
            this.driveFlags = 0;
            this.perpendicular = 0;
            this.sectorCount = 0;
            this.maxTrack = 0;
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tdriveFlags " + this.driveFlags + " perpendicular " + this.perpendicular);
            statusDumper.println("\thead " + this.head + " track " + this.track + " sector " + this.sector + " direction " + this.direction);
            statusDumper.println("\treadWrite " + this.readWrite + " flags " + this.flags);
            statusDumper.println("\tmaxTrack " + this.maxTrack + " bps " + this.bps + " readOnly " + this.readOnly);
            statusDumper.println("\theadCount " + this.headCount + " sectorCount " + this.sectorCount);
            statusDumper.println("\tdevice <object #" + statusDumper.objectNumber(this.device) + ">");
            if (this.device != null) {
                this.device.dumpStatus(statusDumper);
            }
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": FloppyDrive:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        private void changeDisk(DiskImage diskImage) throws IOException {
            if (this.device != null) {
                ((GenericBlockDevice)this.device).configure(diskImage);
            } else if (diskImage != null) {
                this.device = new GenericBlockDevice(diskImage, BlockDevice.Type.FLOPPY);
            }
            if (diskImage == null) {
                this.device = null;
            }
            this.revalidate();
        }

        private void start() {
            this.driveFlags |= 1;
        }

        private void stop() {
            this.driveFlags &= 0xFFFFFFFE;
        }

        private int seek(int n, int n2, int n3, int n4) {
            if (n2 > this.maxTrack || n != 0 && this.headCount == 0) {
                return 2;
            }
            if (n3 > this.sectorCount) {
                return 3;
            }
            int n5 = this.calculateSector(n2, n, this.headCount, n3, this.sectorCount);
            if (n5 != this.currentSector()) {
                if (n4 == 0) {
                    return 4;
                }
                this.head = n;
                if (this.track != n2) {
                    this.track = n2;
                    this.sector = n3;
                    return 1;
                }
                this.sector = n3;
            }
            return 0;
        }

        private int currentSector() {
            return this.calculateSector(this.track, this.head, this.headCount, this.sector, this.sectorCount);
        }

        private int calculateSector(int n, int n2, int n3, int n4, int n5) {
            return ((0xFF & n) * n3 + (0xFF & n2)) * (0xFF & n5) + (0xFF & n4) - 1;
        }

        private void recalibrate() {
            this.head = 0;
            this.track = 0;
            this.sector = 1;
            this.direction = 1;
            this.readWrite = 0;
        }

        private int read(int n, byte[] byArray, int n2) {
            return this.device.read(0xFFFFFFFFL & (long)n, byArray, n2);
        }

        private int write(int n, byte[] byArray, int n2) {
            return this.device.write(0xFFFFFFFFL & (long)n, byArray, n2);
        }

        private void reset() {
            this.stop();
            this.recalibrate();
        }

        private void revalidate() {
            this.driveFlags &= 0xFFFFFFFD;
            if (this.device != null && this.device.isInserted()) {
                this.headCount = this.device.getHeads();
                this.flags = this.headCount == 1 ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
                this.maxTrack = this.device.getCylinders();
                this.sectorCount = (byte)this.device.getSectors();
                this.readOnly = this.device.isReadOnly() ? 1 : 0;
            } else {
                this.sectorCount = 0;
                this.maxTrack = 0;
                this.flags &= 0xFFFFFFFE;
            }
            this.driveFlags |= 2;
        }

        public String toString() {
            return this.device == null ? "<none>" : "<disk>";
        }
    }
}

