/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.EventDispatchTarget;
import org.jpc.emulator.EventRecorder;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.KeyboardStatusListener;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.processor.Processor;

public class Keyboard
extends AbstractHardwareComponent
implements IOPortCapable,
EventDispatchTarget,
TimerResponsive {
    private static final byte KBD_CCMD_READ_MODE = 32;
    private static final byte KBD_CCMD_WRITE_MODE = 96;
    private static final byte KBD_CCMD_MOUSE_DISABLE = -89;
    private static final byte KBD_CCMD_MOUSE_ENABLE = -88;
    private static final byte KBD_CCMD_TEST_MOUSE = -87;
    private static final byte KBD_CCMD_SELF_TEST = -86;
    private static final byte KBD_CCMD_KBD_TEST = -85;
    private static final byte KBD_CCMD_KBD_DISABLE = -83;
    private static final byte KBD_CCMD_KBD_ENABLE = -82;
    private static final byte KBD_CCMD_READ_INPORT = -64;
    private static final byte KBD_CCMD_READ_OUTPORT = -48;
    private static final byte KBD_CCMD_WRITE_OUTPORT = -47;
    private static final byte KBD_CCMD_WRITE_OBUF = -46;
    private static final byte KBD_CCMD_WRITE_AUX_OBUF = -45;
    private static final byte KBD_CCMD_WRITE_MOUSE = -44;
    private static final byte KBD_CCMD_DISABLE_A20 = -35;
    private static final byte KBD_CCMD_ENABLE_A20 = -33;
    private static final byte KBD_CCMD_RESET = -2;
    private static final byte KBD_CMD_SET_LEDS = -19;
    private static final byte KBD_CMD_ECHO = -18;
    private static final byte KBD_CMD_GET_ID = -14;
    private static final byte KBD_CMD_SET_RATE = -13;
    private static final byte KBD_CMD_ENABLE = -12;
    private static final byte KBD_CMD_RESET_DISABLE = -11;
    private static final byte KBD_CMD_RESET_ENABLE = -10;
    private static final byte KBD_CMD_RESET = -1;
    private static final byte KBD_REPLY_POR = -86;
    private static final byte KBD_REPLY_ACK = -6;
    private static final byte KBD_REPLY_RESEND = -2;
    private static final byte KBD_STAT_OBF = 1;
    private static final byte KBD_STAT_SELFTEST = 4;
    private static final byte KBD_STAT_CMD = 8;
    private static final byte KBD_STAT_UNLOCKED = 16;
    private static final byte KBD_STAT_MOUSE_OBF = 32;
    private static final int KBD_MODE_KBD_INT = 1;
    private static final int KBD_MODE_MOUSE_INT = 2;
    private static final int KBD_MODE_DISABLE_KBD = 16;
    private static final int KBD_MODE_DISABLE_MOUSE = 32;
    private static final byte AUX_SET_SCALE11 = -26;
    private static final byte AUX_SET_SCALE21 = -25;
    private static final byte AUX_SET_RES = -24;
    private static final byte AUX_GET_SCALE = -23;
    private static final byte AUX_SET_STREAM = -22;
    private static final byte AUX_POLL = -21;
    private static final byte AUX_RESET_WRAP = -20;
    private static final byte AUX_SET_WRAP = -18;
    private static final byte AUX_SET_REMOTE = -16;
    private static final byte AUX_GET_TYPE = -14;
    private static final byte AUX_SET_SAMPLE = -13;
    private static final byte AUX_ENABLE_DEV = -12;
    private static final byte AUX_DISABLE_DEV = -11;
    private static final byte AUX_SET_DEFAULT = -10;
    private static final byte AUX_RESET = -1;
    private static final byte AUX_ACK = -6;
    private static final byte MOUSE_STATUS_REMOTE = 64;
    private static final byte MOUSE_STATUS_ENABLED = 32;
    private static final byte MOUSE_STATUS_SCALE21 = 16;
    private static final int MOUSE_TYPE = 0;
    private static final int KBD_QUEUE_SIZE = 256;
    private static final long CLOCKING_MODULO = 66666L;
    private KeyboardQueue queue;
    private int modifierFlags;
    private byte commandWrite;
    private byte status;
    private int mode;
    private int keyboardWriteCommand;
    private boolean keyboardScanEnabled;
    private int mouseWriteCommand;
    private int mouseStatus;
    private int mouseResolution;
    private int mouseSampleRate;
    private boolean mouseWrap;
    private int mouseDetectState;
    private int mouseDx;
    private int mouseDy;
    private int mouseDz;
    private int mouseButtons;
    private boolean ioportRegistered;
    private InterruptController irqDevice;
    private Processor cpu;
    private PhysicalAddressSpace physicalAddressSpace;
    private LinearAddressSpace linearAddressSpace;
    private int ledStatus;
    private Clock clock;
    private Timer mouseStreamTimer;
    private long nextMouseStreamSend;
    private int lastMouseButtons;
    private EventRecorder recorder;
    private long keyboardTimeBound;
    private int modifierFlags2;
    private boolean[] keyStatus;
    private boolean[] execKeyStatus;
    private List<KeyboardStatusListener> listeners;
    private boolean suppressListened;
    private int mouseButtonStatus;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tcommandWrite " + this.commandWrite + " status " + this.status + " mode " + this.mode);
        statusDumper.println("\tkeyboardWriteCommand " + this.keyboardWriteCommand + " keyboardScanEnabled " + this.keyboardScanEnabled);
        statusDumper.println("\tmouseWriteCommand " + this.mouseWriteCommand + " mouseStatus " + this.mouseStatus);
        statusDumper.println("\tmouseResolution " + this.mouseResolution + " mouseSampleRate " + this.mouseSampleRate);
        statusDumper.println("\tmouseWrap " + this.mouseWrap + " mouseDetectState " + this.mouseDetectState);
        statusDumper.println("\tmouseDx " + this.mouseDx + " mouseDy " + this.mouseDy + " mouseDz " + this.mouseDz);
        statusDumper.println("\tmouseButtons " + this.mouseButtons + " ioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tmodifierFlags " + this.modifierFlags);
        statusDumper.println("\tnextMouseStreamSend " + this.nextMouseStreamSend);
        statusDumper.println("\tlastMouseButtons " + this.lastMouseButtons);
        statusDumper.println("\tqueue <object #" + statusDumper.objectNumber(this.queue) + ">");
        if (this.queue != null) {
            this.queue.dumpStatus(statusDumper);
        }
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        statusDumper.println("\tcpu <object #" + statusDumper.objectNumber(this.cpu) + ">");
        if (this.cpu != null) {
            this.cpu.dumpStatus(statusDumper);
        }
        statusDumper.println("\tphysicalAddressSpace <object #" + statusDumper.objectNumber(this.physicalAddressSpace) + ">");
        if (this.physicalAddressSpace != null) {
            this.physicalAddressSpace.dumpStatus(statusDumper);
        }
        statusDumper.println("\tlinearAddressSpace <object #" + statusDumper.objectNumber(this.linearAddressSpace) + ">");
        if (this.linearAddressSpace != null) {
            this.linearAddressSpace.dumpStatus(statusDumper);
        }
        statusDumper.println("\tclock <object #" + statusDumper.objectNumber(this.clock) + ">");
        if (this.clock != null) {
            this.clock.dumpStatus(statusDumper);
        }
        statusDumper.println("\tmouseStreamTimer <object #" + statusDumper.objectNumber(this.mouseStreamTimer) + ">");
        if (this.mouseStreamTimer != null) {
            this.mouseStreamTimer.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Keyboard:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.queue);
        sRDumper.dumpInt(this.modifierFlags);
        sRDumper.dumpByte(this.commandWrite);
        sRDumper.dumpByte(this.status);
        sRDumper.dumpInt(this.mode);
        sRDumper.dumpInt(this.keyboardWriteCommand);
        sRDumper.dumpBoolean(this.keyboardScanEnabled);
        sRDumper.dumpInt(this.mouseWriteCommand);
        sRDumper.dumpInt(this.mouseStatus);
        sRDumper.dumpInt(this.mouseResolution);
        sRDumper.dumpInt(this.mouseSampleRate);
        sRDumper.dumpBoolean(this.mouseWrap);
        sRDumper.dumpInt(this.mouseDetectState);
        sRDumper.dumpInt(this.mouseDx);
        sRDumper.dumpInt(this.mouseDy);
        sRDumper.dumpInt(this.mouseDz);
        sRDumper.dumpInt(this.mouseButtons);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpObject(this.cpu);
        sRDumper.dumpObject(this.physicalAddressSpace);
        sRDumper.dumpObject(this.linearAddressSpace);
        sRDumper.dumpInt(this.ledStatus);
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpObject(this.mouseStreamTimer);
        sRDumper.dumpLong(this.nextMouseStreamSend);
        sRDumper.dumpInt(this.lastMouseButtons);
    }

    public Keyboard(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.queue = (KeyboardQueue)sRLoader.loadObject();
        this.modifierFlags = sRLoader.loadInt();
        this.commandWrite = sRLoader.loadByte();
        this.status = sRLoader.loadByte();
        this.mode = sRLoader.loadInt();
        this.keyboardWriteCommand = sRLoader.loadInt();
        this.keyboardScanEnabled = sRLoader.loadBoolean();
        this.mouseWriteCommand = sRLoader.loadInt();
        this.mouseStatus = sRLoader.loadInt();
        this.mouseResolution = sRLoader.loadInt();
        this.mouseSampleRate = sRLoader.loadInt();
        this.mouseWrap = sRLoader.loadBoolean();
        this.mouseDetectState = sRLoader.loadInt();
        this.mouseDx = sRLoader.loadInt();
        this.mouseDy = sRLoader.loadInt();
        this.mouseDz = sRLoader.loadInt();
        this.mouseButtons = sRLoader.loadInt();
        this.ioportRegistered = sRLoader.loadBoolean();
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.cpu = (Processor)sRLoader.loadObject();
        this.physicalAddressSpace = (PhysicalAddressSpace)sRLoader.loadObject();
        this.linearAddressSpace = (LinearAddressSpace)sRLoader.loadObject();
        this.keyStatus = new boolean[256];
        this.execKeyStatus = new boolean[256];
        this.ledStatus = -1;
        this.clock = null;
        this.mouseStreamTimer = null;
        this.nextMouseStreamSend = -1L;
        this.lastMouseButtons = this.mouseButtons;
        this.listeners = new ArrayList<KeyboardStatusListener>();
        if (!sRLoader.objectEndsHere()) {
            this.ledStatus = sRLoader.loadInt();
        }
        if (!sRLoader.objectEndsHere()) {
            this.clock = (Clock)sRLoader.loadObject();
            this.mouseStreamTimer = (Timer)sRLoader.loadObject();
            this.nextMouseStreamSend = sRLoader.loadLong();
            this.lastMouseButtons = sRLoader.loadInt();
        }
        this.sendKeyStatusReload();
    }

    public Keyboard() {
        this.ioportRegistered = false;
        this.modifierFlags = 0;
        this.keyStatus = new boolean[256];
        this.execKeyStatus = new boolean[256];
        this.queue = new KeyboardQueue(this);
        this.physicalAddressSpace = null;
        this.linearAddressSpace = null;
        this.cpu = null;
        this.reset();
        this.listeners = new ArrayList<KeyboardStatusListener>();
        this.sendKeyStatusReload();
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{96, 100};
    }

    @Override
    public int ioPortReadByte(int n) {
        switch (n) {
            case 96: {
                return this.readData();
            }
            case 100: {
                return 0xFF & this.status;
            }
        }
        return -1;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1);
    }

    @Override
    public int ioPortReadLong(int n) {
        return -1;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 96: {
                this.writeData((byte)n2);
                break;
            }
            case 100: {
                this.writeCommand((byte)n2);
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    @Override
    public void reset() {
        this.irqDevice = null;
        this.cpu = null;
        this.physicalAddressSpace = null;
        this.linearAddressSpace = null;
        this.ioportRegistered = false;
        this.keyboardWriteCommand = -1;
        this.mouseWriteCommand = -1;
        this.mode = 3;
        this.status = (byte)24;
        this.queue.reset();
        this.commandWrite = 0;
        this.keyboardWriteCommand = 0;
        this.keyboardScanEnabled = false;
        this.mouseWriteCommand = 0;
        this.mouseStatus = 0;
        this.mouseResolution = 0;
        this.mouseSampleRate = 0;
        this.mouseWrap = false;
        this.mouseDetectState = 0;
        this.mouseDx = 0;
        this.mouseDy = 0;
        this.mouseDz = 0;
        this.mouseButtons = 0;
        this.clock = null;
        this.mouseStreamTimer = null;
        this.nextMouseStreamSend = -1L;
        this.lastMouseButtons = this.mouseButtons;
    }

    private void setGateA20State(boolean bl) {
        this.physicalAddressSpace.setGateA20State(bl);
    }

    private byte readData() {
        byte by = this.queue.readData();
        this.updateIRQ();
        return by;
    }

    private void writeData(byte by) {
        switch (this.commandWrite) {
            case 0: {
                this.writeKeyboard(by);
                break;
            }
            case 96: {
                this.mode = 0xFF & by;
                this.updateIRQ();
                break;
            }
            case -46: {
                this.queue.writeData(by, (byte)0);
                break;
            }
            case -45: {
                this.queue.writeData(by, (byte)1);
                break;
            }
            case -47: {
                this.setGateA20State((by & 2) != 0);
                if (1 == (by & 1)) break;
                this.cpu.reset();
                break;
            }
            case -44: {
                this.writeMouse(by);
                break;
            }
        }
        this.commandWrite = 0;
    }

    private void writeCommand(byte by) {
        switch (by) {
            case 32: {
                this.queue.writeData((byte)this.mode, (byte)0);
                break;
            }
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case 96: {
                this.commandWrite = by;
                break;
            }
            case -89: {
                this.mode |= 0x20;
                break;
            }
            case -88: {
                this.mode &= 0xFFFFFFDF;
                break;
            }
            case -87: {
                this.queue.writeData((byte)0, (byte)0);
                break;
            }
            case -86: {
                this.status = (byte)(this.status | 4);
                this.queue.writeData((byte)85, (byte)0);
                break;
            }
            case -85: {
                this.queue.writeData((byte)0, (byte)0);
                break;
            }
            case -83: {
                this.mode |= 0x10;
                this.updateIRQ();
                break;
            }
            case -82: {
                this.mode &= 0xFFFFFFEF;
                this.updateIRQ();
                break;
            }
            case -64: {
                this.queue.writeData((byte)0, (byte)0);
                break;
            }
            case -48: {
                by = (byte)(1 | (this.physicalAddressSpace.getGateA20State() ? 2 : 0));
                if (0 != (this.status & 1)) {
                    by = (byte)(by | 0x10);
                }
                if (0 != (this.status & 0x20)) {
                    by = (byte)(by | 0x20);
                }
                this.queue.writeData(by, (byte)0);
                break;
            }
            case -33: {
                this.setGateA20State(true);
                break;
            }
            case -35: {
                this.setGateA20State(false);
                break;
            }
            case -2: {
                this.cpu.reset();
                break;
            }
            case -1: {
                break;
            }
            default: {
                System.err.println("Warning: unsupported keyboard command " + Integer.toHexString(0xFF & by) + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeKeyboard(byte by) {
        switch (this.keyboardWriteCommand) {
            default: {
                switch (by) {
                    case 0: {
                        this.queue.writeData((byte)-6, (byte)0);
                        return;
                    }
                    case 5: {
                        this.queue.writeData((byte)-2, (byte)0);
                        return;
                    }
                    case -14: {
                        KeyboardQueue keyboardQueue = this.queue;
                        synchronized (keyboardQueue) {
                            this.queue.writeData((byte)-6, (byte)0);
                            this.queue.writeData((byte)-85, (byte)0);
                            this.queue.writeData((byte)-125, (byte)0);
                            return;
                        }
                    }
                    case -18: {
                        this.queue.writeData((byte)-18, (byte)0);
                        return;
                    }
                    case -12: {
                        this.keyboardScanEnabled = true;
                        this.queue.writeData((byte)-6, (byte)0);
                        return;
                    }
                    case -19: 
                    case -13: {
                        this.keyboardWriteCommand = by;
                        this.queue.writeData((byte)-6, (byte)0);
                        return;
                    }
                    case -11: {
                        this.resetKeyboard();
                        this.keyboardScanEnabled = false;
                        this.queue.writeData((byte)-6, (byte)0);
                        return;
                    }
                    case -10: {
                        this.resetKeyboard();
                        this.keyboardScanEnabled = true;
                        this.queue.writeData((byte)-6, (byte)0);
                        return;
                    }
                    case -1: {
                        this.resetKeyboard();
                        KeyboardQueue keyboardQueue = this.queue;
                        synchronized (keyboardQueue) {
                            this.queue.writeData((byte)-6, (byte)0);
                            this.queue.writeData((byte)-86, (byte)0);
                            return;
                        }
                    }
                }
                this.queue.writeData((byte)-6, (byte)0);
                return;
            }
            case -19: {
                this.queue.writeData((byte)-6, (byte)0);
                this.ledStatus = by & 0xFF;
                this.sendLEDStatusChange(this.ledStatus);
                this.keyboardWriteCommand = -1;
                return;
            }
            case -13: 
        }
        this.queue.writeData((byte)-6, (byte)0);
        this.keyboardWriteCommand = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMouse(byte by) {
        block8 : switch (this.mouseWriteCommand) {
            default: {
                if (this.mouseWrap) {
                    if (by == -20) {
                        this.mouseWrap = false;
                        this.queue.writeData((byte)-6, (byte)1);
                        return;
                    }
                    if (by != -1) {
                        this.queue.writeData(by, (byte)1);
                        return;
                    }
                }
                switch (by) {
                    case -26: {
                        this.mouseStatus &= 0xFFFFFFEF;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -25: {
                        this.mouseStatus |= 0x10;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -22: {
                        this.mouseStatus &= 0xFFFFFFBF;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -18: {
                        this.mouseWrap = true;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -16: {
                        this.mouseStatus |= 0x40;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -14: {
                        KeyboardQueue keyboardQueue = this.queue;
                        synchronized (keyboardQueue) {
                            this.queue.writeData((byte)-6, (byte)1);
                            this.queue.writeData((byte)0, (byte)1);
                            break block8;
                        }
                    }
                    case -24: 
                    case -13: {
                        this.mouseWriteCommand = by;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -23: {
                        KeyboardQueue keyboardQueue = this.queue;
                        synchronized (keyboardQueue) {
                            this.queue.writeData((byte)-6, (byte)1);
                            this.queue.writeData((byte)this.mouseStatus, (byte)1);
                            this.queue.writeData((byte)this.mouseResolution, (byte)1);
                            this.queue.writeData((byte)this.mouseSampleRate, (byte)1);
                            break block8;
                        }
                    }
                    case -21: {
                        KeyboardQueue keyboardQueue = this.queue;
                        synchronized (keyboardQueue) {
                            this.queue.writeData((byte)-6, (byte)1);
                            this.mouseSendPacket(true);
                            break block8;
                        }
                    }
                    case -12: {
                        this.mouseStatus |= 0x20;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -11: {
                        this.mouseStatus &= 0xFFFFFFDF;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -10: {
                        this.mouseSampleRate = 100;
                        this.mouseResolution = 2;
                        this.mouseStatus = 0;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block8;
                    }
                    case -1: {
                        this.mouseSampleRate = 100;
                        this.mouseResolution = 2;
                        this.mouseStatus = 0;
                        KeyboardQueue keyboardQueue = this.queue;
                        synchronized (keyboardQueue) {
                            this.queue.writeData((byte)-6, (byte)1);
                            this.queue.writeData((byte)-86, (byte)1);
                            this.queue.writeData((byte)0, (byte)1);
                            break block8;
                        }
                    }
                    default: {
                        break block8;
                    }
                }
            }
            case -13: {
                this.mouseSampleRate = by & 0xFF;
                this.queue.writeData((byte)-6, (byte)1);
                this.mouseWriteCommand = -1;
                break;
            }
            case -24: {
                this.mouseResolution = by;
                this.queue.writeData((byte)-6, (byte)1);
                this.mouseWriteCommand = -1;
            }
        }
    }

    private void resetKeyboard() {
        this.keyboardScanEnabled = true;
    }

    private int scale2(int n) {
        switch (n) {
            case -5: {
                return -9;
            }
            case -4: {
                return -6;
            }
            case -3: {
                return -3;
            }
            case -2: {
                return -1;
            }
            case -1: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 9;
            }
        }
        return 2 * n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mouseSendPacket(boolean bl) {
        System.err.println("Called mouseSendPacket: dx=" + this.mouseDx + " dy=" + this.mouseDy + " dz=" + this.mouseDz + " buttons=" + this.mouseButtons + ".");
        int n = this.mouseDx;
        int n2 = this.mouseDy;
        int n3 = this.mouseDz;
        if (!bl && (this.mouseStatus & 0x10) != 0) {
            n = this.scale2(n);
            n2 = this.scale2(n2);
        }
        if (n > 255) {
            n = 255;
            System.err.println("Warning: Mouse X motion too fast!");
        } else if (n < -255) {
            n = -255;
            System.err.println("Warning: Mouse X motion too fast!");
        }
        if (n2 > 255) {
            n2 = 255;
            System.err.println("Warning: Mouse Y motion too fast!");
        } else if (n2 < -255) {
            n2 = -255;
            System.err.println("Warning: Mouse Y motion too fast!");
        }
        if (n3 > 7) {
            n3 = 7;
            System.err.println("Warning: Mouse Z motion too fast!");
        } else if (n3 < -7) {
            n3 = -7;
            System.err.println("Warning: Mouse Z motion too fast!");
        }
        int n4 = 0;
        int n5 = 0;
        if (n < 0) {
            n4 = 1;
        }
        if (n2 < 0) {
            n5 = 1;
        }
        byte by = (byte)(8 | n4 << 4 | n5 << 5 | this.mouseButtons & 7);
        KeyboardQueue keyboardQueue = this.queue;
        synchronized (keyboardQueue) {
            this.queue.writeData(by, (byte)1);
            this.queue.writeData((byte)n, (byte)1);
            this.queue.writeData((byte)n2, (byte)1);
            switch (0) {
                default: {
                    break;
                }
                case 3: {
                    this.queue.writeData((byte)n3, (byte)1);
                    break;
                }
                case 4: {
                    by = (byte)(n3 & 0xF | (this.mouseButtons & 0x18) << 1);
                    this.queue.writeData(by, (byte)1);
                }
            }
        }
        this.mouseDx -= n;
        this.mouseDy -= n2;
        this.mouseDz -= n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIRQ() {
        int n = 0;
        int n2 = 0;
        this.status = (byte)(this.status & 0xFFFFFFDE);
        KeyboardQueue keyboardQueue = this.queue;
        synchronized (keyboardQueue) {
            if (this.queue.length != 0) {
                this.status = (byte)(this.status | 1);
                if (0 != this.queue.getAux()) {
                    this.status = (byte)(this.status | 0x20);
                    if (0 != (this.mode & 2)) {
                        n2 = 1;
                    }
                } else if (0 != (this.mode & 1) && 0 == (this.mode & 0x10)) {
                    n = 1;
                }
            }
        }
        this.irqDevice.setIRQ(1, n);
        this.irqDevice.setIRQ(12, n2);
    }

    public boolean getKeyStatus(byte by) {
        return this.keyStatus[by & 0xFF];
    }

    public boolean getKeyExecStatus(byte by) {
        return this.execKeyStatus[by & 0xFF];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(byte by) {
        if (by != -1) {
            this.keyStatus[by & 0xFF] = true;
            this.sendKeyStatusChange(by & 0xFF, true);
        }
        if ((by & 0x7F) == 29) {
            this.modifierFlags |= 1;
        }
        if ((by & 0x7F) == 56) {
            this.modifierFlags |= 2;
        }
        if ((this.modifierFlags & 1) != 0 && by == -1) {
            by = (byte)-58;
        }
        if ((this.modifierFlags & 2) != 0 && by == -73) {
            by = (byte)84;
            this.modifierFlags |= 4;
        }
        KeyboardQueue keyboardQueue = this.queue;
        synchronized (keyboardQueue) {
            switch (by) {
                case -1: {
                    this.putKeyboardEvent((byte)-31);
                    this.putKeyboardEvent((byte)29);
                    this.putKeyboardEvent((byte)69);
                    this.putKeyboardEvent((byte)-31);
                    this.putKeyboardEvent((byte)-99);
                    this.putKeyboardEvent((byte)-59);
                    return;
                }
                case -58: {
                    this.putKeyboardEvent((byte)-32);
                    this.putKeyboardEvent((byte)70);
                    this.putKeyboardEvent((byte)-32);
                    this.putKeyboardEvent((byte)-58);
                }
            }
            if (by < 0) {
                this.putKeyboardEvent((byte)-32);
            }
            this.putKeyboardEvent((byte)(by & 0x7F));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(byte by) {
        if (by == -1) {
            return;
        }
        this.keyStatus[by & 0xFF] = false;
        this.sendKeyStatusChange(by & 0xFF, false);
        if ((by & 0x7F) == 29) {
            this.modifierFlags &= 0xFFFFFFFE;
        }
        if ((by & 0x7F) == 56) {
            this.modifierFlags &= 0xFFFFFFFD;
        }
        if ((this.modifierFlags & 4) != 0 && by == -73) {
            by = (byte)84;
            this.modifierFlags &= 0xFFFFFFFB;
        }
        KeyboardQueue keyboardQueue = this.queue;
        synchronized (keyboardQueue) {
            if (by < 0) {
                this.putKeyboardEvent((byte)-32);
            }
            this.putKeyboardEvent((byte)(by | 0x80));
        }
    }

    private void putKeyboardEvent(byte by) {
        this.queue.writeData(by, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMouseEvent(int n, int n2, int n3, int n4) {
        if (0 == (this.mouseStatus & 0x20)) {
            return;
        }
        this.mouseDx += n;
        this.mouseDy -= n2;
        this.mouseDz += n3;
        this.mouseButtons = n4;
        KeyboardQueue keyboardQueue = this.queue;
        synchronized (keyboardQueue) {
            if (0 == (this.mouseStatus & 0x40) && this.queue.length < 240) {
                do {
                    this.mouseSendPacket(false);
                } while (this.mouseDx != 0 || this.mouseDy != 0 || this.mouseDz != 0);
            }
        }
    }

    @Override
    public boolean initialised() {
        return this.ioportRegistered && this.irqDevice != null && this.cpu != null && this.physicalAddressSpace != null && this.linearAddressSpace != null && this.clock != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof Processor && hardwareComponent.initialised()) {
            this.cpu = (Processor)hardwareComponent;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalAddressSpace = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddressSpace = (LinearAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
            this.mouseStreamTimer = this.clock.newTimer(this);
            this.nextMouseStreamSend = this.clock.getTime();
            this.mouseStreamTimer.setExpiry(this.nextMouseStreamSend);
            this.lastMouseButtons = 0;
        }
    }

    @Override
    public void callback() {
        boolean bl;
        boolean bl2 = (this.mouseStatus & 0x60) == 32;
        boolean bl3 = bl = this.mouseDx != 0 || this.mouseDy != 0 || this.mouseDz != 0 || this.lastMouseButtons != this.mouseButtons;
        if (this.clock.getTime() >= this.nextMouseStreamSend) {
            int n;
            if (bl2 && bl && this.queue.length < 248) {
                this.mouseSendPacket(false);
                this.mouseDx = 0;
                this.mouseDy = 0;
                this.mouseDz = 0;
                this.lastMouseButtons = this.mouseButtons;
            }
            if ((n = this.mouseSampleRate) < 10) {
                n = 10;
            }
            if (n > 200) {
                n = 200;
            }
            this.nextMouseStreamSend += 1000000000L / (long)n;
        }
        this.mouseStreamTimer.setExpiry(this.nextMouseStreamSend);
    }

    @Override
    public int getTimerType() {
        return 67;
    }

    @Override
    public void setEventRecorder(EventRecorder eventRecorder) {
        this.recorder = eventRecorder;
    }

    @Override
    public void endEventCheck() throws IOException {
        this.suppressListened = false;
        this.sendKeyStatusReload();
    }

    @Override
    public void startEventCheck() {
        int n;
        this.suppressListened = true;
        this.modifierFlags2 = 0;
        this.keyboardTimeBound = 0L;
        for (n = 0; n < this.keyStatus.length; ++n) {
            this.keyStatus[n] = false;
        }
        for (n = 0; n < this.execKeyStatus.length; ++n) {
            this.execKeyStatus[n] = false;
        }
        this.mouseButtonStatus = 0;
    }

    @Override
    public void doEvent(long l, String[] stringArray, int n) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IOException("Empty events not allowed");
        }
        if ("PAUSE".equals(stringArray[0])) {
            if (l < this.keyboardTimeBound && n <= 2) {
                throw new IOException("Invalid PAUSE event");
            }
            if (stringArray.length != 1 || l % 66666L != 0L) {
                throw new IOException("Invalid PAUSE event");
            }
            if (n >= 3) {
                this.keyPressed((byte)-1);
            } else {
                this.keyboardTimeBound = (this.modifierFlags2 & 1) == 0 ? l + 3999960L : l + 2666640L;
            }
        } else if ("KEYEDGE".equals(stringArray[0])) {
            int n2;
            if (l < this.keyboardTimeBound && n <= 2) {
                throw new IOException("Invalid KEYEDGE event");
            }
            if (stringArray.length != 2 || l % 66666L != 0L) {
                long l2 = l;
                long l3 = l % 66666L;
                long l4 = l2 - l3;
                long l5 = l4 + 66666L;
                throw new IOException("Invalid KEYEDGE event at " + l2 + " (remainder = " + l3 + "); try " + l4 + "  or " + l5 + ")");
            }
            try {
                n2 = Integer.parseInt(stringArray[1]);
                if (n2 < 1 || n2 > 95 && n2 < 129 || n2 > 223) {
                    throw new IOException("Invalid key number");
                }
                if (n2 == 84 || n2 == 198) {
                    throw new IOException("Invalid key number");
                }
            }
            catch (Exception exception) {
                throw new IOException("Invalid KEYEDGE event");
            }
            if (n == 2 || n == 1) {
                this.keyStatus[n2] = !this.keyStatus[n2];
                this.sendKeyStatusChange(n2, this.keyStatus[n2]);
            }
            if (n >= 2) {
                this.execKeyStatus[n2] = !this.execKeyStatus[n2];
                this.sendKeyExecStatusChange(n2, this.execKeyStatus[n2]);
            }
            if (n >= 3) {
                if (this.execKeyStatus[n2]) {
                    this.keyPressed((byte)n2);
                    System.err.println("Executing keyPress on " + n2 + ".");
                } else {
                    this.keyReleased((byte)n2);
                    System.err.println("Executing keyRelease on " + n2 + ".");
                }
            } else {
                this.keyboardTimeBound = (this.modifierFlags2 & 6) != 0 && n2 == 183 ? l + 666660L : (n2 < 128 ? l + 666660L : l + 1333320L);
            }
            if ((n2 & 0x7F) == 29) {
                this.modifierFlags2 ^= 1;
            }
            if ((n2 & 0x7F) == 56) {
                this.modifierFlags2 ^= 2;
            }
            if ((this.modifierFlags2 & 6) != 0 && n2 == 183) {
                this.modifierFlags2 ^= 4;
            }
        } else if ("MOUSEBUTTON".equals(stringArray[0])) {
            int n3;
            try {
                n3 = Integer.parseInt(stringArray[1]);
                if (n3 < 0 || n3 > 4) {
                    throw new IOException("Invalid mouse button number");
                }
            }
            catch (Exception exception) {
                throw new IOException("Invalid MOUSEBUTTON event");
            }
            if (n == 2 || n == 1) {
                this.mouseButtonStatus ^= 1 << n3;
                this.sendMouseButtonsChange(this.mouseButtonStatus);
            }
            if (n == 3) {
                this.mouseButtons ^= 1 << n3;
                this.sendMouseExecButtonsChange(this.mouseButtons);
            }
        } else if ("XMOUSEMOTION".equals(stringArray[0])) {
            int n4;
            try {
                n4 = Integer.parseInt(stringArray[1]);
                if (n4 < -255 || n4 > 255) {
                    throw new IOException("Invalid mouse X motion");
                }
            }
            catch (Exception exception) {
                throw new IOException("Invalid XMOUSEMOTION event");
            }
            if (n == 3) {
                this.mouseDx += n4;
            }
        } else if ("YMOUSEMOTION".equals(stringArray[0])) {
            int n5;
            try {
                n5 = Integer.parseInt(stringArray[1]);
                if (n5 < -255 || n5 > 255) {
                    throw new IOException("Invalid mouse Y motion");
                }
            }
            catch (Exception exception) {
                throw new IOException("Invalid YMOUSEMOTION event");
            }
            if (n == 3) {
                this.mouseDy += n5;
            }
        } else if ("ZMOUSEMOTION".equals(stringArray[0])) {
            int n6;
            try {
                n6 = Integer.parseInt(stringArray[1]);
                if (n6 < -7 || n6 > 7) {
                    throw new IOException("Invalid mouse Z motion");
                }
            }
            catch (Exception exception) {
                throw new IOException("Invalid ZMOUSEMOTION event");
            }
            if (n == 3) {
                this.mouseDz += n6;
            }
        } else {
            throw new IOException("Invalid keyboard event subtype");
        }
    }

    @Override
    public long getEventTimeLowBound(long l, String[] stringArray) throws IOException {
        if (stringArray != null && stringArray.length > 0 && ("MOUSEBUTTON".equals(stringArray[0]) || "XMOUSEMOTION".equals(stringArray[0]) || "YMOUSEMOTION".equals(stringArray[0]) || "ZMOUSEMOTION".equals(stringArray[0]))) {
            return l;
        }
        if (this.keyboardTimeBound >= l) {
            return this.keyboardTimeBound;
        }
        return l + (66666L - l % 66666L) % 66666L;
    }

    public void sendEdge(int n) throws IOException {
        String string = new Integer(n).toString();
        if (this.recorder == null) {
            return;
        }
        if (n < 0 || n > 95 && n < 129 || n > 223 && n != 255) {
            throw new IOException("Invalid key number");
        }
        if (n == 84 || n == 198) {
            throw new IOException("Invalid key number");
        }
        if (n == 255) {
            this.recorder.addEvent(this.keyboardTimeBound, this.getClass(), new String[]{"PAUSE"});
        } else if (n < 128) {
            this.recorder.addEvent(this.keyboardTimeBound, this.getClass(), new String[]{"KEYEDGE", string});
            this.keyStatus[n] = !this.keyStatus[n];
            this.sendKeyStatusChange(n, this.keyStatus[n]);
        } else {
            this.recorder.addEvent(this.keyboardTimeBound, this.getClass(), new String[]{"KEYEDGE", string});
            this.keyStatus[n] = !this.keyStatus[n];
            this.sendKeyStatusChange(n, this.keyStatus[n]);
        }
    }

    public int getLEDStatus() {
        return this.ledStatus;
    }

    private void sendKeyStatusChange(int n, boolean bl) {
        if (this.suppressListened) {
            return;
        }
        for (KeyboardStatusListener keyboardStatusListener : this.listeners) {
            keyboardStatusListener.keyStatusChange(n, bl);
        }
    }

    private void sendKeyExecStatusChange(int n, boolean bl) {
        if (this.suppressListened) {
            return;
        }
        for (KeyboardStatusListener keyboardStatusListener : this.listeners) {
            keyboardStatusListener.keyExecStatusChange(n, bl);
        }
    }

    private void sendKeyStatusReload() {
        if (this.suppressListened) {
            return;
        }
        for (KeyboardStatusListener keyboardStatusListener : this.listeners) {
            keyboardStatusListener.keyStatusReload();
        }
    }

    private void sendLEDStatusChange(int n) {
        if (this.suppressListened) {
            return;
        }
        for (KeyboardStatusListener keyboardStatusListener : this.listeners) {
            keyboardStatusListener.ledStatusChange(n);
        }
    }

    public void sendMouseButtonsChange(int n) {
        if (this.suppressListened) {
            return;
        }
        for (KeyboardStatusListener keyboardStatusListener : this.listeners) {
            keyboardStatusListener.mouseButtonsChange(n);
        }
    }

    public void sendMouseExecButtonsChange(int n) {
        if (this.suppressListened) {
            return;
        }
        for (KeyboardStatusListener keyboardStatusListener : this.listeners) {
            keyboardStatusListener.mouseExecButtonsChange(n);
        }
    }

    public void addStatusListener(KeyboardStatusListener keyboardStatusListener) {
        this.listeners.add(keyboardStatusListener);
    }

    public void removeStatusListener(KeyboardStatusListener keyboardStatusListener) {
        this.listeners.remove(keyboardStatusListener);
    }

    public void sendMouseButton(int n) throws IOException {
        String string = new Integer(n).toString();
        if (this.recorder == null) {
            return;
        }
        if (n < 0 || n > 4) {
            throw new IOException("Invalid mouse button number");
        }
        this.recorder.addEvent(-1L, this.getClass(), new String[]{"MOUSEBUTTON", string});
        this.mouseButtonStatus ^= 1 << n;
    }

    public void sendXMouseMotion(int n) throws IOException {
        String string = new Integer(n).toString();
        if (this.recorder == null) {
            return;
        }
        if (n < -255 || n > 255) {
            throw new IOException("Invalid X mouse motion amount");
        }
        this.recorder.addEvent(-1L, this.getClass(), new String[]{"XMOUSEMOTION", string});
    }

    public void sendYMouseMotion(int n) throws IOException {
        String string = new Integer(n).toString();
        if (this.recorder == null) {
            return;
        }
        if (n < -255 || n > 255) {
            throw new IOException("Invalid Y mouse motion amount");
        }
        this.recorder.addEvent(-1L, this.getClass(), new String[]{"YMOUSEMOTION", string});
    }

    public void sendZMouseMotion(int n) throws IOException {
        String string = new Integer(n).toString();
        if (this.recorder == null) {
            return;
        }
        if (n < -7 || n > 7) {
            throw new IOException("Invalid Z mouse motion amount");
        }
        this.recorder.addEvent(-1L, this.getClass(), new String[]{"ZMOUSEMOTION", string});
    }

    public int getMouseButtonStatus() {
        return this.mouseButtonStatus;
    }

    public int getMouseXPendingMotion() {
        return this.mouseDx;
    }

    public int getMouseYPendingMotion() {
        return this.mouseDy;
    }

    public int getMouseZPendingMotion() {
        return this.mouseDz;
    }

    public static class KeyboardQueue
    implements SRDumpable {
        private byte[] aux;
        private byte[] data;
        private int readPosition;
        private int writePosition;
        private int length;
        private Keyboard upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpArray(this.aux);
            sRDumper.dumpArray(this.data);
            sRDumper.dumpInt(this.readPosition);
            sRDumper.dumpInt(this.writePosition);
            sRDumper.dumpInt(this.length);
            sRDumper.dumpObject(this.upperBackref);
        }

        public KeyboardQueue(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.aux = sRLoader.loadArrayByte();
            this.data = sRLoader.loadArrayByte();
            this.readPosition = sRLoader.loadInt();
            this.writePosition = sRLoader.loadInt();
            this.length = sRLoader.loadInt();
            this.upperBackref = (Keyboard)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            int n;
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
            statusDumper.println("\treadPosition " + this.readPosition + " writePosition " + this.writePosition + " length " + this.length);
            for (n = 0; n < this.aux.length; ++n) {
                statusDumper.println("\taux[" + n + "] " + this.aux[n]);
            }
            for (n = 0; n < this.data.length; ++n) {
                statusDumper.println("\tdata[" + n + "] " + this.data[n]);
            }
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": KeyboardQueue:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public KeyboardQueue(Keyboard keyboard) {
            this.aux = new byte[256];
            this.data = new byte[256];
            this.readPosition = 0;
            this.writePosition = 0;
            this.length = 0;
            this.upperBackref = keyboard;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            KeyboardQueue keyboardQueue = this;
            synchronized (keyboardQueue) {
                this.readPosition = 0;
                this.writePosition = 0;
                this.length = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte getAux() {
            KeyboardQueue keyboardQueue = this;
            synchronized (keyboardQueue) {
                return this.aux[this.readPosition];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte readData() {
            KeyboardQueue keyboardQueue = this;
            synchronized (keyboardQueue) {
                if (this.length == 0) {
                    int n = this.readPosition - 1;
                    if (n < 0) {
                        n = 255;
                    }
                    return this.data[n];
                }
                byte by = this.aux[this.readPosition];
                byte by2 = this.data[this.readPosition];
                if (++this.readPosition == 256) {
                    this.readPosition = 0;
                }
                --this.length;
                if (0 != by) {
                    this.upperBackref.irqDevice.setIRQ(12, 0);
                } else {
                    this.upperBackref.irqDevice.setIRQ(1, 0);
                }
                return by2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeData(byte by, byte by2) {
            KeyboardQueue keyboardQueue = this;
            synchronized (keyboardQueue) {
                if (this.length >= 256) {
                    return;
                }
                this.aux[this.writePosition] = by2;
                this.data[this.writePosition] = by;
                if (++this.writePosition == 256) {
                    this.writePosition = 0;
                }
                ++this.length;
            }
            this.upperBackref.updateIRQ();
        }
    }
}

