/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.IntervalTimer;
import org.jpc.output.Output;
import org.jpc.output.OutputChannelOBM;

public class PCSpeaker
extends AbstractHardwareComponent
implements IOPortCapable {
    private int dummyRefreshClock;
    private int mode;
    private IntervalTimer pit;
    private Clock clock;
    private boolean pitInput;
    private boolean ioportRegistered;
    private boolean lastState;
    private OutputChannelOBM soundOut;

    public PCSpeaker(Output output, String string) {
        this.ioportRegistered = false;
        this.mode = 0;
        this.pitInput = true;
        this.lastState = true;
        this.soundOut = new OutputChannelOBM(output, string);
        this.soundOut.addFrameOBM(0L, false);
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tdummyRefreshClock " + this.dummyRefreshClock + " mode " + this.mode + " lastState " + this.lastState);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered + " pitInput " + this.pitInput);
        statusDumper.println("\tpit <object #" + statusDumper.objectNumber(this.pit) + ">");
        if (this.pit != null) {
            this.pit.dumpStatus(statusDumper);
        }
        statusDumper.println("\tclock <object #" + statusDumper.objectNumber(this.clock) + ">");
        if (this.clock != null) {
            this.clock.dumpStatus(statusDumper);
        }
        statusDumper.println("\tsoundOut <object #" + statusDumper.objectNumber(this.soundOut) + ">");
        if (this.soundOut != null) {
            this.soundOut.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PCSpeaker:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.dummyRefreshClock);
        sRDumper.dumpInt(this.mode);
        sRDumper.dumpObject(this.pit);
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpObject(this.soundOut);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpBoolean(this.pitInput);
        sRDumper.dumpBoolean(this.lastState);
    }

    public PCSpeaker(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.dummyRefreshClock = sRLoader.loadInt();
        this.mode = sRLoader.loadInt();
        this.pit = (IntervalTimer)sRLoader.loadObject();
        this.clock = (Clock)sRLoader.loadObject();
        this.soundOut = (OutputChannelOBM)sRLoader.loadObject();
        this.ioportRegistered = sRLoader.loadBoolean();
        this.pitInput = sRLoader.loadBoolean();
        this.lastState = sRLoader.loadBoolean();
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{97};
    }

    @Override
    public int ioPortReadByte(int n) {
        int n2 = this.pit.getOut(2);
        this.dummyRefreshClock ^= 1;
        return this.mode | n2 << 5 | this.dummyRefreshClock << 4;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    @Override
    public synchronized void ioPortWriteByte(int n, int n2) {
        this.pit.setGate(2, (n2 & 1) != 0);
        this.mode = n2 & 3;
        this.updateSpeaker();
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    public void setPITInput(boolean bl) {
        this.pitInput = bl;
        this.updateSpeaker();
    }

    private void updateSpeaker() {
        boolean bl = (this.mode & 2) == 0 ? true : ((this.mode & 1) == 0 ? false : this.pitInput);
        long l = this.clock.getTime();
        if (bl != this.lastState) {
            this.soundOut.addFrameOBM(l, this.lastState);
            this.soundOut.addFrameOBM(l, bl);
        }
        this.lastState = bl;
    }

    @Override
    public boolean initialised() {
        return this.ioportRegistered && this.pit != null && this.clock != null;
    }

    @Override
    public void reset() {
        this.pit = null;
        this.ioportRegistered = false;
        this.clock = null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof IntervalTimer && hardwareComponent.initialised()) {
            this.pit = (IntervalTimer)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }
}

