/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public abstract class ProtectedModeExpandDownSegment
extends Segment {
    public static final int TYPE_ACCESSED = 1;
    public static final int TYPE_CODE = 8;
    public static final int TYPE_DATA_WRITABLE = 2;
    public static final int TYPE_DATA_EXPAND_DOWN = 4;
    public static final int TYPE_CODE_READABLE = 2;
    public static final int TYPE_CODE_CONFORMING = 4;
    public static final int DESCRIPTOR_TYPE_CODE_DATA = 16;
    private final boolean defaultSize;
    private final boolean granularity;
    private final boolean present;
    private final boolean system;
    private final int selector;
    private final int base;
    private final int minOffset;
    private final int maxOffset;
    private final int dpl;
    private final long limit;
    private final int rawLimit;
    private final long descriptor;
    private int rpl;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tselector " + this.selector + " base " + this.base + " limit " + this.limit + " rpl " + this.rpl);
        statusDumper.println("\tdefaultSize " + this.defaultSize + " system " + this.system + " present " + this.present);
        statusDumper.println("\tdpl " + this.dpl + " granularity " + this.granularity + " descriptor " + this.descriptor);
        statusDumper.println("\trawLimit " + this.rawLimit + " minOffset " + this.minOffset + " maxOffset " + this.maxOffset);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": ProtectedModeExpandDownSegment:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.selector);
        sRDumper.dumpInt(this.base);
        sRDumper.dumpInt(this.minOffset);
        sRDumper.dumpInt(this.maxOffset);
        sRDumper.dumpInt(this.dpl);
        sRDumper.dumpInt(this.rpl);
        sRDumper.dumpLong(this.descriptor);
        sRDumper.dumpLong(this.limit);
        sRDumper.dumpInt(this.rawLimit);
        sRDumper.dumpBoolean(this.defaultSize);
        sRDumper.dumpBoolean(this.granularity);
        sRDumper.dumpBoolean(this.present);
        sRDumper.dumpBoolean(this.system);
    }

    public ProtectedModeExpandDownSegment(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.selector = sRLoader.loadInt();
        this.base = sRLoader.loadInt();
        this.minOffset = sRLoader.loadInt();
        this.maxOffset = sRLoader.loadInt();
        this.dpl = sRLoader.loadInt();
        this.rpl = sRLoader.loadInt();
        this.descriptor = sRLoader.loadLong();
        this.limit = sRLoader.loadLong();
        this.rawLimit = sRLoader.loadInt();
        this.defaultSize = sRLoader.loadBoolean();
        this.granularity = sRLoader.loadBoolean();
        this.present = sRLoader.loadBoolean();
        this.system = sRLoader.loadBoolean();
    }

    public ProtectedModeExpandDownSegment(AddressSpace addressSpace, int n, long l) {
        super(addressSpace, true);
        this.selector = n;
        this.descriptor = l;
        this.granularity = (l & 0x80000000000000L) != 0L;
        this.defaultSize = (l & 0x40000000000000L) != 0L;
        this.base = (int)(0xFFFFFFL & l >> 16 | l >> 32 & 0xFFFFFFFFFF000000L);
        this.limit = this.granularity ? l << 12 & 0xFFFF000L | l >>> 20 & 0xF0000000L | 0xFFFL : l & 0xFFFFL | l >>> 32 & 0xF0000L;
        this.rawLimit = (int)(l & 0xFFFFL | l >>> 32 & 0xF0000L);
        if (this.defaultSize) {
            this.minOffset = (int)((long)this.base + this.limit - 1L);
            this.maxOffset = -1;
        } else {
            this.minOffset = (int)((long)this.base + this.limit - 1L);
            this.maxOffset = 65535;
        }
        this.rpl = n & 3;
        this.dpl = (int)(l >> 45 & 3L);
        this.present = (l & 0x800000000000L) != 0L;
        this.system = (l & 0x100000000000L) != 0L;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public boolean isSystem() {
        return !this.system;
    }

    @Override
    public int translateAddressRead(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public int translateAddressWrite(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public void checkAddress(int n) {
        if ((n < 0 && this.maxOffset < 0) | (n > 0 && this.maxOffset > 0)) {
            if (n >= this.maxOffset) {
                System.err.println("Emulated: " + this + " expand down segment: offset out of bounds.");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
            }
        } else {
            if (n > 0) {
                return;
            }
            System.err.println("Emulated: " + this + " expand down segment: offset out of bounds.");
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
    }

    @Override
    public boolean getDefaultSizeFlag() {
        return this.defaultSize;
    }

    @Override
    public int getLimit() {
        return (int)this.limit;
    }

    public int getRawLimit() {
        return this.rawLimit;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getSelector() {
        return this.selector & 0xFFFC | this.rpl;
    }

    @Override
    public int getRPL() {
        return this.rpl;
    }

    @Override
    public int getDPL() {
        return this.dpl;
    }

    @Override
    public void setRPL(int n) {
        this.rpl = n;
    }

    @Override
    public boolean setSelector(int n) {
        System.err.println("Critical error: Cannot set a selector for a descriptor table segment.");
        throw new IllegalStateException("Cannot set a selector for a descriptor table segment");
    }

    @Override
    public void printState() {
        System.out.println("PM Expand down segment.");
        System.out.println("selector: " + Integer.toHexString(this.selector));
        System.out.println("base: " + Integer.toHexString(this.base));
        System.out.println("dpl: " + Integer.toHexString(this.dpl));
        System.out.println("rpl: " + Integer.toHexString(this.rpl));
        System.out.println("limit: " + Long.toHexString(this.limit));
        System.out.println("descriptor: " + Long.toHexString(this.descriptor));
    }

    public static final class ReadWriteDataSegment
    extends ProtectedModeExpandDownSegment {
        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ReadWriteDataSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ReadWriteDataSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public ReadWriteDataSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 18;
        }
    }
}

