/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public final class RealModeSegment
extends Segment {
    private int selector;
    private int base;
    private int type;
    private long limit;
    private int rpl;
    private boolean defaultSize = false;
    private boolean segment = true;
    private boolean present = true;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tselector " + this.selector + " base " + this.base + " limit " + this.limit + " rpl " + this.rpl);
        statusDumper.println("\tdefaultSize " + this.defaultSize + " segment " + this.segment + " present " + this.present);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": RealModeSegment:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.selector);
        sRDumper.dumpInt(this.base);
        sRDumper.dumpInt(this.type);
        sRDumper.dumpInt(this.rpl);
        sRDumper.dumpLong(this.limit);
        sRDumper.dumpBoolean(this.defaultSize);
        sRDumper.dumpBoolean(this.segment);
        sRDumper.dumpBoolean(this.present);
    }

    public RealModeSegment(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.selector = sRLoader.loadInt();
        this.base = sRLoader.loadInt();
        this.type = sRLoader.loadInt();
        this.rpl = sRLoader.loadInt();
        this.limit = sRLoader.loadLong();
        this.defaultSize = sRLoader.loadBoolean();
        this.segment = sRLoader.loadBoolean();
        this.present = sRLoader.loadBoolean();
    }

    public RealModeSegment(AddressSpace addressSpace, int n) {
        super(addressSpace, true);
        this.selector = n;
        this.base = n << 4;
        this.limit = 65535L;
        this.rpl = 0;
        this.type = 3;
    }

    public RealModeSegment(AddressSpace addressSpace, Segment segment) {
        super(addressSpace, true);
        this.selector = segment.getSelector();
        this.base = segment.getBase();
        this.type = segment.getType();
        this.limit = 0xFFFFFFFFL & (long)segment.getLimit();
        this.defaultSize = segment.getDefaultSizeFlag();
        this.segment = !segment.isSystem();
        this.present = segment.isPresent();
        this.rpl = segment.getRPL();
    }

    @Override
    public boolean getDefaultSizeFlag() {
        return this.defaultSize;
    }

    @Override
    public int getLimit() {
        return (int)this.limit;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getSelector() {
        return this.selector;
    }

    @Override
    public boolean setSelector(int n) {
        this.selector = n;
        this.base = n << 4;
        this.type = 3;
        return true;
    }

    @Override
    public void checkAddress(int n) {
        if ((0xFFFFFFFFL & (long)n) > this.limit) {
            System.err.println("Emulated: RM Segment Limit exceeded: offset=" + Integer.toHexString(n) + ", limit=" + Long.toHexString(this.limit));
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
    }

    @Override
    public int translateAddressRead(int n) {
        return this.base + n;
    }

    @Override
    public int translateAddressWrite(int n) {
        return this.base + n;
    }

    @Override
    public int getRPL() {
        return this.rpl;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public boolean isSystem() {
        return !this.segment;
    }

    @Override
    public int getDPL() {
        System.err.println("Critical error: RM segment getDPL()");
        throw new IllegalStateException("RM segment getDPL: " + this.getClass().toString());
    }

    @Override
    public void setRPL(int n) {
        System.err.println("Critical error: RM segment setRPL()");
        throw new IllegalStateException("RM segment setRPL: " + this.getClass().toString());
    }

    @Override
    public void printState() {
        System.out.println("RM Segment");
        System.out.println("selector: " + Integer.toHexString(this.selector));
        System.out.println("base: " + Integer.toHexString(this.base));
        System.out.println("rpl: " + Integer.toHexString(this.rpl));
        System.out.println("limit: " + Long.toHexString(this.limit));
        System.out.println("type: " + Integer.toHexString(this.type));
        System.out.println("defaultSize: " + this.defaultSize);
        System.out.println("segment: " + this.segment);
        System.out.println("present: " + this.present);
    }
}

