/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.processor.DescriptorTableSegment;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.ProtectedModeExpandDownSegment;
import org.jpc.emulator.processor.ProtectedModeSegment;
import org.jpc.emulator.processor.RealModeSegment;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.Virtual8086ModeSegment;

public class SegmentFactory
implements SRDumpable {
    private static final long DESCRIPTOR_TYPE = 0x100000000000L;
    private static final long SEGMENT_TYPE = 0xF0000000000L;
    public static final Segment NULL_SEGMENT = new NullSegment();

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": SegmentFactory:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tNULL_SEGMENT <object #" + statusDumper.objectNumber(NULL_SEGMENT) + ">");
        if (NULL_SEGMENT != null) {
            NULL_SEGMENT.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
    }

    public SegmentFactory(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
    }

    private SegmentFactory() {
    }

    protected SegmentFactory STFU() {
        SegmentFactory segmentFactory = new SegmentFactory();
        return segmentFactory;
    }

    public static Segment createRealModeSegment(AddressSpace addressSpace, int n) {
        if (addressSpace == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new RealModeSegment(addressSpace, n);
    }

    public static Segment createRealModeSegment(AddressSpace addressSpace, Segment segment) {
        if (addressSpace == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new RealModeSegment(addressSpace, segment);
    }

    public static Segment createVirtual8086ModeSegment(AddressSpace addressSpace, int n, boolean bl) {
        if (addressSpace == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new Virtual8086ModeSegment(addressSpace, n, bl);
    }

    public static Segment createDescriptorTableSegment(AddressSpace addressSpace, int n, int n2) {
        if (addressSpace == null) {
            throw new NullPointerException("Null reference to memory");
        }
        return new DescriptorTableSegment(addressSpace, n, n2);
    }

    public static Segment createProtectedModeSegment(AddressSpace addressSpace, int n, long l) {
        switch ((int)((l & 0x1F0000000000L) >>> 40)) {
            default: {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
            }
            case 1: {
                return new ProtectedModeSegment.Available16BitTSS(addressSpace, n, l);
            }
            case 2: {
                return new ProtectedModeSegment.LDT(addressSpace, n, l);
            }
            case 3: {
                return new ProtectedModeSegment.Busy16BitTSS(addressSpace, n, l);
            }
            case 4: {
                return new ProtectedModeSegment.CallGate16Bit(addressSpace, n, l);
            }
            case 5: {
                return new ProtectedModeSegment.TaskGate(addressSpace, n, l);
            }
            case 6: {
                return new ProtectedModeSegment.InterruptGate16Bit(addressSpace, n, l);
            }
            case 7: {
                return new ProtectedModeSegment.TrapGate16Bit(addressSpace, n, l);
            }
            case 9: {
                return new ProtectedModeSegment.Available32BitTSS(addressSpace, n, l);
            }
            case 11: {
                return new ProtectedModeSegment.Busy32BitTSS(addressSpace, n, l);
            }
            case 12: {
                return new ProtectedModeSegment.CallGate32Bit(addressSpace, n, l);
            }
            case 14: {
                return new ProtectedModeSegment.InterruptGate32Bit(addressSpace, n, l);
            }
            case 15: {
                return new ProtectedModeSegment.TrapGate32Bit(addressSpace, n, l);
            }
            case 16: {
                return new ProtectedModeSegment.ReadOnlyDataSegment(addressSpace, n, l);
            }
            case 17: {
                return new ProtectedModeSegment.ReadOnlyAccessedDataSegment(addressSpace, n, l);
            }
            case 18: {
                return new ProtectedModeSegment.ReadWriteDataSegment(addressSpace, n, l);
            }
            case 19: {
                return new ProtectedModeSegment.ReadWriteAccessedDataSegment(addressSpace, n, l);
            }
            case 20: {
                System.err.println("Critical error: Unimplemented Data Segment: Read-Only, Expand-Down");
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Expand-Down");
            }
            case 21: {
                System.err.println("Critical error: Unimplemented Data Segment: Read-Only, Expand-Down, Accessed");
                throw new IllegalStateException("Unimplemented Data Segment: Read-Only, Expand-Down, Accessed");
            }
            case 22: {
                return new ProtectedModeExpandDownSegment.ReadWriteDataSegment(addressSpace, n, l);
            }
            case 23: {
                System.err.println("Critical error: Unimplemented Data Segment: Read/Write, Expand-Down, Accessed");
                throw new IllegalStateException("Unimplemented Data Segment: Read/Write, Expand-Down, Accessed");
            }
            case 24: {
                return new ProtectedModeSegment.ExecuteOnlyCodeSegment(addressSpace, n, l);
            }
            case 25: {
                System.err.println("Critical error: Unimplemented Code Segment: Execute-Only, Accessed");
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only, Accessed");
            }
            case 26: {
                return new ProtectedModeSegment.ExecuteReadCodeSegment(addressSpace, n, l);
            }
            case 27: {
                return new ProtectedModeSegment.ExecuteReadAccessedCodeSegment(addressSpace, n, l);
            }
            case 28: {
                System.err.println("Critical error: Unimplemented Code Segment: Execute-Only, Conforming");
                throw new IllegalStateException("Unimplemented Code Segment: Execute-Only, Conforming");
            }
            case 29: {
                return new ProtectedModeSegment.ExecuteOnlyConformingAccessedCodeSegment(addressSpace, n, l);
            }
            case 30: {
                return new ProtectedModeSegment.ExecuteReadConformingCodeSegment(addressSpace, n, l);
            }
            case 31: 
        }
        return new ProtectedModeSegment.ExecuteReadConformingAccessedCodeSegment(addressSpace, n, l);
    }

    public static final class NullSegment
    extends Segment {
        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": NullSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public NullSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public NullSegment() {
            super(null, true);
        }

        @Override
        public void printState() {
            System.out.println("Null Segment");
        }

        @Override
        public int getType() {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }

        @Override
        public int getSelector() {
            return 0;
        }

        @Override
        public void checkAddress(int n) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }

        @Override
        public int translateAddressRead(int n) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }

        @Override
        public int translateAddressWrite(int n) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }

        public void invalidateAddress(int n) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }

        @Override
        public int getBase() {
            System.err.println("Critical error: NULL segment getBase()");
            throw new IllegalStateException("NULL segment getBase(): " + this.getClass().toString());
        }

        @Override
        public int getLimit() {
            System.err.println("Critical error: NULL segment getLimit()");
            throw new IllegalStateException("NULL segment getLimit(): " + this.getClass().toString());
        }

        public int getRawLimit() {
            System.err.println("Critical error: NULL segment getRawLimit()");
            throw new IllegalStateException("NULL segment getRawLimit(): " + this.getClass().toString());
        }

        @Override
        public boolean setSelector(int n) {
            System.err.println("Critical error: NULL segment setSelector()");
            throw new IllegalStateException("NULL segment setSelector(): " + this.getClass().toString());
        }

        @Override
        public int getDPL() {
            System.err.println("Critical error: NULL segment getDPL()");
            throw new IllegalStateException("NULL segment getDPL(): " + this.getClass().toString());
        }

        @Override
        public int getRPL() {
            System.err.println("Critical error: NULL segment getRPL()");
            throw new IllegalStateException("NULL segment getRPL(): " + this.getClass().toString());
        }

        @Override
        public void setRPL(int n) {
            System.err.println("Critical error: NULL segment setRPL()");
            throw new IllegalStateException("NULL segment setRPL(): " + this.getClass().toString());
        }

        @Override
        public boolean getDefaultSizeFlag() {
            System.err.println("Critical error: NULL segment getDefaultSizeFlag()");
            throw new IllegalStateException("NULL segment getDefaultSizeFlag(): " + this.getClass().toString());
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public boolean isSystem() {
            return false;
        }
    }
}

