/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import mnj.lua.Lua;
import mnj.lua.LuaTable;
import org.jpc.emulator.Clock;
import org.jpc.emulator.DisplayController;
import org.jpc.emulator.EventRecorder;
import org.jpc.emulator.PC;
import org.jpc.plugins.LuaPlugin;

public class Base
extends LuaPlugin.LuaResource {
    @Override
    public void destroy() {
    }

    private Base(LuaPlugin luaPlugin) {
        super(luaPlugin);
    }

    private static int intLuaCBInvoke(Lua lua, boolean bl, LuaPlugin luaPlugin) {
        LuaTable luaTable = null;
        String[] stringArray = null;
        int n = 0;
        if (lua.type(1) != 4) {
            lua.error("Unexpected types to invoke");
            return 0;
        }
        String string = lua.value(1).toString();
        if (lua.type(2) != -1 && lua.type(2) != 0) {
            if (lua.type(2) == 5) {
                luaTable = (LuaTable)lua.value(2);
                n = Lua.objLen(luaTable);
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = lua.getTable(luaTable, new Double(i + 1)).toString();
                    if (stringArray[i] != null) continue;
                    stringArray[i] = "";
                }
            } else {
                lua.error("Unexpected types to invoke");
                return 0;
            }
        }
        luaPlugin.callInvokeCommand(string, stringArray, bl);
        return 0;
    }

    public static int luaCB_call(Lua lua, LuaPlugin luaPlugin) {
        Object[] objectArray;
        LuaTable luaTable = null;
        String[] stringArray = null;
        int n = 0;
        if (lua.type(1) != 4) {
            lua.error("Unexpected types to invoke");
            return 0;
        }
        String string = lua.value(1).toString();
        if (lua.type(2) != -1 && lua.type(2) != 0) {
            if (lua.type(2) == 5) {
                luaTable = (LuaTable)lua.value(2);
                n = Lua.objLen(luaTable);
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = lua.getTable(luaTable, new Double(i + 1)).toString();
                    if (stringArray[i] != null) continue;
                    stringArray[i] = "";
                }
            } else {
                lua.error("Unexpected types to invoke");
                return 0;
            }
        }
        if ((objectArray = luaPlugin.callCommand(string, stringArray)) == null) {
            return 0;
        }
        int n2 = 1;
        LuaTable luaTable2 = lua.newTable();
        for (Object object : objectArray) {
            if (object == null) {
                ++n2;
                continue;
            }
            if (object instanceof Boolean) {
                lua.setTable(luaTable2, new Double(n2++), object);
                continue;
            }
            if (object instanceof Integer) {
                lua.setTable(luaTable2, new Double(n2++), new Double(((Integer)object).intValue()));
                continue;
            }
            if (object instanceof Long) {
                lua.setTable(luaTable2, new Double(n2++), new Double(((Long)object).longValue()));
                continue;
            }
            if (object instanceof String) {
                lua.setTable(luaTable2, new Double(n2++), object);
                continue;
            }
            lua.setTable(luaTable2, new Double(n2++), "<unconvertable object>");
        }
        lua.push(luaTable2);
        return 1;
    }

    public static int luaCB_invoke(Lua lua, LuaPlugin luaPlugin) {
        return Base.intLuaCBInvoke(lua, false, luaPlugin);
    }

    public static int luaCB_invoke_synchronous(Lua lua, LuaPlugin luaPlugin) {
        return Base.intLuaCBInvoke(lua, true, luaPlugin);
    }

    public static int luaCB_release_vga(Lua lua, LuaPlugin luaPlugin) {
        luaPlugin.doReleaseVGA();
        return 0;
    }

    public static int luaCB_vga_resolution(Lua lua, LuaPlugin luaPlugin) {
        lua.push(new Double(luaPlugin.getXResolution()));
        lua.push(new Double(luaPlugin.getYResolution()));
        return 2;
    }

    public static int luaCB_pc_running(Lua lua, LuaPlugin luaPlugin) {
        lua.pushBoolean(luaPlugin.getPCRunning());
        return 1;
    }

    public static int luaCB_clock_time(Lua lua, LuaPlugin luaPlugin) {
        Clock clock = (Clock)luaPlugin.getComponent(Clock.class);
        if (clock != null) {
            lua.push(new Double(clock.getTime()));
        } else {
            lua.pushNil();
        }
        return 1;
    }

    public static int luaCB_wait_event(Lua lua, LuaPlugin luaPlugin) {
        LuaPlugin.Event event = luaPlugin.waitEvent();
        int n = 1;
        if (event != null) {
            lua.push(event.type);
            if (event.data != null) {
                lua.push(event.data);
                ++n;
            }
        } else {
            lua.pushNil();
        }
        return n;
    }

    public static int luaCB_poll_message(Lua lua, LuaPlugin luaPlugin) {
        LuaPlugin.Event event = luaPlugin.pollEvent();
        int n = 1;
        if (event != null) {
            lua.push(event.type);
            if (event.data != null) {
                lua.push(event.data);
                ++n;
            }
        } else {
            lua.pushNil();
        }
        return n;
    }

    public static int luaCB_in_frame_hold(Lua lua, LuaPlugin luaPlugin) {
        lua.pushBoolean(luaPlugin.getOwnsVGALock());
        return 1;
    }

    public static int luaCB_pc_connected(Lua lua, LuaPlugin luaPlugin) {
        lua.pushBoolean(luaPlugin.getPCConnected());
        return 1;
    }

    public static int luaCB_stringlessthan(Lua lua, LuaPlugin luaPlugin) {
        int n = 0;
        String string = lua.value(1).toString();
        String string2 = lua.value(2).toString();
        int n2 = string.length();
        int n3 = string2.length();
        for (int i = 0; i < n2 && i < n3; ++i) {
            boolean bl;
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            boolean bl2 = c >= '\ud800' && c <= '\udfff';
            boolean bl3 = bl = c2 >= '\ud800' && c2 <= '\udfff';
            if (!bl2 && bl) {
                n = n == 0 ? 1 : n;
                continue;
            }
            if (bl2 && !bl) {
                n = n == 0 ? -1 : n;
                continue;
            }
            if (c < c2) {
                n = n == 0 ? 1 : n;
                continue;
            }
            if (c <= c2) continue;
            n = n == 0 ? -1 : n;
        }
        if (n == 0 && n2 < n3) {
            n = 1;
        }
        if (n == 0 && n2 > n3) {
            n = -1;
        }
        lua.pushBoolean(n == 1);
        return 1;
    }

    public static int luaCB_frame_number(Lua lua, LuaPlugin luaPlugin) {
        DisplayController displayController = (DisplayController)((Object)luaPlugin.getComponent(DisplayController.class));
        if (displayController == null) {
            lua.pushNil();
        } else {
            lua.pushNumber(displayController.getFrameNumber());
        }
        return 1;
    }

    public static int luaCB_movie_length(Lua lua, LuaPlugin luaPlugin) {
        PC.ResetButton resetButton = (PC.ResetButton)luaPlugin.getComponent(PC.ResetButton.class);
        if (resetButton == null) {
            lua.pushNil();
            return 1;
        }
        EventRecorder eventRecorder = resetButton.getRecorder();
        long l = eventRecorder.getLastEventTime();
        long l2 = eventRecorder.getAttachTime();
        long l3 = 0L;
        if (l2 < l) {
            l3 = l - l2;
        }
        lua.push(new Double(l3));
        return 1;
    }

    public static int luaCB_movie_rerecords(Lua lua, LuaPlugin luaPlugin) {
        PC.ResetButton resetButton = (PC.ResetButton)luaPlugin.getComponent(PC.ResetButton.class);
        if (resetButton == null) {
            lua.pushNil();
            return 1;
        }
        EventRecorder eventRecorder = resetButton.getRecorder();
        lua.push(new Double(eventRecorder.getRerecordCount()));
        return 1;
    }

    public static int luaCB_movie_headers(Lua lua, LuaPlugin luaPlugin) {
        PC.ResetButton resetButton = (PC.ResetButton)luaPlugin.getComponent(PC.ResetButton.class);
        if (resetButton == null) {
            lua.pushNil();
            return 1;
        }
        EventRecorder eventRecorder = resetButton.getRecorder();
        String[][] stringArray = eventRecorder.getHeaders();
        LuaTable luaTable = lua.newTable();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                LuaTable luaTable2 = lua.newTable();
                int n = 1;
                if (stringArray[i] != null) {
                    for (String string : stringArray[i]) {
                        lua.setTable(luaTable2, new Double(n++), string);
                    }
                }
                lua.setTable(luaTable, new Double(i + 1), luaTable2);
            }
        }
        lua.push(luaTable);
        return 1;
    }
}

