/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import mnj.lua.Lua;
import org.jpc.jrsr.FourToFiveDecoder;
import org.jpc.luaextensions.TextInFile;
import org.jpc.plugins.LuaPlugin;

public class BinaryInFile
extends LuaPlugin.LuaResource {
    InputStream object;

    public BinaryInFile(LuaPlugin luaPlugin, InputStream inputStream) throws IOException {
        super(luaPlugin);
        this.object = inputStream;
    }

    @Override
    public void destroy() throws IOException {
        this.object.close();
        this.object = null;
    }

    public int luaCB_four_to_five(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.generateLuaClass(lua, new BinaryInFile(luaPlugin, new FourToFiveDecoder(this.object)));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_inflate(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.generateLuaClass(lua, new BinaryInFile(luaPlugin, new InflaterInputStream(this.object)));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_text(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.generateLuaClass(lua, new TextInFile(luaPlugin, this.object));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_read(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        try {
            int n = (int)lua.checkNumber(2);
            if (n <= 0) {
                lua.pushNil();
                lua.pushString("Length is not positive");
                return 2;
            }
            byte[] byArray = new byte[n];
            if ((n = this.object.read(byArray)) < 0) {
                lua.pushNil();
                lua.pushNil();
                return 2;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.appendCodePoint(byArray[i] & 0xFF);
            }
            lua.push(stringBuffer.toString());
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_close(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.destroyLuaObject(lua);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public static int luaCB_open(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(1);
        try {
            luaPlugin.generateLuaClass(lua, new BinaryInFile(luaPlugin, new FileInputStream(string)));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }
}

