/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.modules;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.fpu64.FpuState64;

public class BasicFPU
extends AbstractHardwareComponent {
    boolean fpuCreated;

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.fpuCreated);
    }

    public BasicFPU(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.fpuCreated = sRLoader.loadBoolean();
    }

    public BasicFPU() throws IOException {
        this.fpuCreated = false;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tfpuCreated " + this.fpuCreated);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": BasicFPU:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public boolean initialised() {
        return this.fpuCreated;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Processor && !this.fpuCreated) {
            System.err.println("Informational: Creating FPU...");
            FpuState64 fpuState64 = new FpuState64((Processor)hardwareComponent);
            ((Processor)hardwareComponent).setFPU(fpuState64);
            this.fpuCreated = true;
        }
    }
}

