/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.modules;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.SoundOutputDevice;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.modulesaux.FMChip;
import org.jpc.output.Output;
import org.jpc.output.OutputChannelFM;

public class FMCard
extends AbstractHardwareComponent
implements IOPortCapable,
TimerResponsive,
SoundOutputDevice {
    private boolean ioportRegistered;
    private Timer timer;
    private Clock clock;
    private FMChip fmChip;
    private int fmIndex;
    private long fmNextAttention;
    private OutputChannelFM fmOutput;
    private int lastStatus;
    public static final long TIME_NEVER = Long.MAX_VALUE;

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpObject(this.timer);
        sRDumper.dumpObject(this.fmChip);
        sRDumper.dumpObject(this.fmOutput);
        sRDumper.dumpInt(this.fmIndex);
        sRDumper.dumpLong(this.fmNextAttention);
    }

    public FMCard(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.ioportRegistered = sRLoader.loadBoolean();
        this.clock = (Clock)sRLoader.loadObject();
        this.timer = (Timer)sRLoader.loadObject();
        this.fmChip = (FMChip)sRLoader.loadObject();
        this.fmOutput = (OutputChannelFM)sRLoader.loadObject();
        this.fmIndex = sRLoader.loadInt();
        this.fmNextAttention = sRLoader.loadLong();
        this.lastStatus = -1;
    }

    public FMCard() throws IOException {
        this.fmChip = new FMChip();
        this.fmOutput = null;
        this.fmIndex = 0;
        this.fmNextAttention = Long.MAX_VALUE;
        this.lastStatus = -1;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tclock <object #" + statusDumper.objectNumber(this.clock) + ">");
        if (this.clock != null) {
            this.clock.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttimer <object #" + statusDumper.objectNumber(this.timer) + ">");
        if (this.timer != null) {
            this.timer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tfmIndex " + this.fmIndex);
        statusDumper.println("\tfmNextAttention " + this.fmNextAttention);
        statusDumper.println("\tfmChip <object #" + statusDumper.objectNumber(this.fmChip) + ">");
        if (this.fmChip != null) {
            this.fmChip.dumpStatus(statusDumper);
        }
        statusDumper.println("\tfmOutput <object #" + statusDumper.objectNumber(this.fmOutput) + ">");
        if (this.fmOutput != null) {
            this.fmOutput.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": FMCard:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public boolean initialised() {
        return this.clock != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
            this.timer = this.clock.newTimer(this);
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public int[] ioPortsRequested() {
        int[] nArray = new int[]{904, 905, 906, 907};
        return nArray;
    }

    @Override
    public int getTimerType() {
        return 37;
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
        this.ioPortWriteByte(n + 2, n2 >>> 16 & 0xFF);
        this.ioPortWriteByte(n + 3, n2 >>> 24 & 0xFF);
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) | this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        return this.ioPortReadByte(n) | this.ioPortReadByte(n + 1) << 8 | this.ioPortReadByte(n + 2) << 16 | this.ioPortReadByte(n + 3) << 24;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        this.ioWrite(n - 904, n2);
    }

    @Override
    public int ioPortReadByte(int n) {
        return this.ioRead(n - 904);
    }

    @Override
    public int requestedSoundChannels() {
        return 1;
    }

    @Override
    public void soundChannelCallback(Output output, String string) {
        if (this.fmOutput == null) {
            OutputChannelFM outputChannelFM = new OutputChannelFM(output, string);
            this.fmChip.setOutput(outputChannelFM);
            this.fmOutput = outputChannelFM;
        }
    }

    public void ioWrite(int n, int n2) {
        switch (n) {
            case 0: {
                this.fmIndex = n2;
                return;
            }
            case 1: {
                this.writeFM(this.fmIndex, n2);
                return;
            }
            case 2: {
                this.fmIndex = 256 + n2;
                return;
            }
            case 3: {
                this.writeFM(this.fmIndex, n2);
                return;
            }
        }
    }

    public int ioRead(int n) {
        switch (n) {
            case 0: 
            case 2: {
                return this.readFMStatus();
            }
            case 1: 
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public void reset() {
        this.fmIndex = 0;
        if (this.clock != null) {
            this.fmChip.resetCard(this.clock.getTime());
        } else {
            this.fmChip.resetCard(0L);
        }
    }

    private final int readFMStatus() {
        int n;
        this.lastStatus = n = this.fmChip.status(this.clock.getTime());
        return n;
    }

    private final void writeFM(int n, int n2) {
        this.fmChip.write(this.clock.getTime(), n, n2);
        this.updateTimer();
    }

    private final void updateTimer() {
        long l = Long.MAX_VALUE;
        long l2 = this.fmChip.nextAttention(this.clock.getTime());
        if (l2 < l) {
            l = l2;
        }
        if (l != Long.MAX_VALUE) {
            if (this.timer != null) {
                this.timer.setExpiry(l);
            }
        } else if (this.timer != null) {
            this.timer.disable();
        }
    }

    @Override
    public void callback() {
        long l = this.clock.getTime();
        boolean bl = true;
        while (bl) {
            bl = false;
            long l2 = this.fmChip.nextAttention(this.clock.getTime());
            if (l2 <= l) {
                this.fmChip.attention(this.clock.getTime());
                bl = true;
            }
            if (!bl) continue;
            this.updateTimer();
        }
    }
}

