/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.modules;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.SoundOutputDevice;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.DMAController;
import org.jpc.emulator.motherboard.DMATransferCapable;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.modulesaux.FMChip;
import org.jpc.output.Output;
import org.jpc.output.OutputChannelFM;
import org.jpc.output.OutputChannelPCM;

public class SoundCard
extends AbstractHardwareComponent
implements IOPortCapable,
TimerResponsive,
DMATransferCapable,
SoundOutputDevice {
    private int baseIOAddress;
    private boolean irq2;
    private boolean irq5;
    private boolean irq7;
    private boolean irq10;
    private int dmaMask;
    private int dmaRequested;
    private boolean ioportRegistered;
    private DMAController primaryDMAController;
    private DMAController secondaryDMAController;
    private Timer timer;
    private Clock clock;
    private InterruptController irqController;
    private OutputChannelPCM pcmOutput;
    private boolean irq8Bit;
    private boolean irq16Bit;
    private int mixerIndex;
    private int mixerPrevIndex;
    private int[] mixerRegisters;
    private int dspCommandState;
    private int[] dspOutput;
    private int dspOutputUsed;
    private long dspNextAttention;
    private int dmaState;
    private int samplesLeft;
    private int origSamplesLeft;
    private int soundFormat;
    private boolean stereo;
    private long interSampleTime;
    private boolean istStereoAdjust;
    private boolean dmaPaused;
    private int dmaPauseLeft;
    private int dmaActiveMask;
    private boolean dmaRequest;
    private long dmaRequestTime;
    private int partialSample;
    private int partialSampleBytes;
    private int wholeSampleBytes;
    private int byteBuffer;
    private int byteBufferSamples;
    private int adpcmReference;
    private byte adpcmScale;
    private long nextSampleTime;
    private int dspArgumentRegister;
    private int dspNextDMA;
    private int dspLastCommand;
    private boolean e2Mode;
    private byte e2Value;
    private int e2Count;
    private boolean speakerConnected;
    private FMChip fmChip;
    private int fmIndex;
    private long fmNextAttention;
    private OutputChannelFM fmOutput;
    private static final int DMA_NONE = 0;
    private static final int DMA_SINGLE = 1;
    private static final int DMA_CONTINUOUS = 2;
    private static final int DMA_CONTINUOUS_EXIT = 3;
    private static final int SNDFMT_2BIT_ADPCM = 0;
    private static final int SNDFMT_26BIT_ADPCM = 1;
    private static final int SNDFMT_4BIT_ADPCM = 2;
    private static final int SNDFMT_2BIT_ADPCM_REF = 3;
    private static final int SNDFMT_26BIT_ADPCM_REF = 4;
    private static final int SNDFMT_4BIT_ADPCM_REF = 5;
    private static final int SNDFMT_8BIT_PCM_SIGNED = 6;
    private static final int SNDFMT_8BIT_PCM_UNSIGNED = 7;
    private static final int SNDFMT_16BIT_PCM_LE_SIGNED = 8;
    private static final int SNDFMT_16BIT_PCM_LE_UNSIGNED = 9;
    private static final int SNDFMT_16BIT_PCM_BE_SIGNED = 10;
    private static final int SNDFMT_16BIT_PCM_BE_UNSIGNED = 11;
    private static final byte ADPCM_SCALE_INIT = 0;
    private static final int typeFlag = 16;
    private static final int QUEUE_SIZE = 256;
    private static final int DSP_VERSION = 1028;
    private static final int MIXER_REGISTERS = 25;
    private static final int MIXREG_RESET = 0;
    private static final int MIXREG_STATUS = 1;
    private static final int MIXREG_DAC = 4;
    private static final int MIXREG_MIC = 10;
    private static final int MIXREG_OUTPUT_CONTROL = 14;
    private static final int MIXREG_MASTER = 34;
    private static final int MIXREG_FM = 38;
    private static final int MIXREG_CD = 40;
    private static final int MIXREG_LINEIN = 46;
    private static final int MIXREG_IRQSELECT = 128;
    private static final int MIXREG_DMASELECT = 129;
    private static final int MIXREG_IRQSTATUS = 130;
    private static final int MIXREG_SB16_FIRST = 48;
    private static final int MIXREG_LAST = 71;
    private static final int MIXER_MASTER_LEFT = 0;
    private static final int MIXER_MASTER_RIGHT = 1;
    private static final int MIXER_DAC_LEFT = 2;
    private static final int MIXER_DAC_RIGHT = 3;
    private static final int MIXER_FM_LEFT = 4;
    private static final int MIXER_FM_RIGHT = 5;
    private static final int MIXER_OUTPUT_GAIN_CONTROL_LEFT = 17;
    private static final int MIXER_OUTPUT_GAIN_CONTROL_RIGHT = 18;
    private static final int MIXER_TREBLE_LEFT = 20;
    private static final int MIXER_TREBLE_RIGHT = 21;
    private static final int MIXER_BASS_LEFT = 22;
    private static final int MIXER_BASS_RIGHT = 23;
    private static final int MIXER_OUTPUT_CONTROL = 24;
    private static final int MIXER_CD_LEFT = 6;
    private static final int MIXER_CD_RIGHT = 7;
    private static final int MIXER_LINEIN_LEFT = 8;
    private static final int MIXER_LINEIN_RIGHT = 9;
    private static final int MIXER_MIC = 10;
    private static final int MIXER_PCSPEAKER = 11;
    private static final int MIXER_INPUT_CONTROL_LEFT = 13;
    private static final int MIXER_INPUT_CONTROL_RIGHT = 14;
    private static final int MIXER_INPUT_GAIN_CONTROL_LEFT = 15;
    private static final int MIXER_INPUT_GAIN_CONTROL_RIGHT = 16;
    private static final int MIXER_AUTOMATIC_GAIN_CONTROL = 19;
    private static final int DSPSTATE_WAIT_COMMAND = 0;
    private static final int DSPSTATE_DIRECT_DAC_SAMPLE = 1;
    private static final int DSPSTATE_SILENCE_LOW = 2;
    private static final int DSPSTATE_SILENCE_HIGH = 3;
    private static final int DSPSTATE_TESTWRITE = 4;
    private static final int DSPSTATE_IDWRITE = 5;
    private static final int DSPSTATE_RATE_LOW = 6;
    private static final int DSPSTATE_RATE_HIGH = 7;
    private static final int DSPSTATE_BLOCKSIZE_LOW = 8;
    private static final int DSPSTATE_BLOCKSIZE_HIGH = 9;
    private static final int DSPSTATE_TC = 10;
    private static final int DSPSTATE_OLDDMA_LOW = 11;
    private static final int DSPSTATE_OLDDMA_HIGH = 12;
    private static final int DSPSTATE_NEWDMA_LOW = 13;
    private static final int DSPSTATE_NEWDMA_MID = 14;
    private static final int DSPSTATE_NEWDMA_HIGH = 15;
    private static final int DSPSTATE_DMA_IDENTIFY = 16;
    private static final int ADPCM_4BIT_SCALE_MAX = 3;
    private static final int ADPCM_26BIT_SCALE_MAX = 4;
    private static final int ADPCM_2BIT_SCALE_MAX = 5;
    private static final byte[] ADPCM_4BIT_LEVEL_SHIFT;
    private static final byte[] ADPCM_26BIT_LEVEL_SHIFT;
    private static final byte[] ADPCM_2BIT_LEVEL_SHIFT;
    private static final int[] ADPCM_4BIT_LEVEL_MULT;
    private static final int[] ADPCM_26BIT_LEVEL_MULT;
    private static final int[] ADPCM_2BIT_LEVEL_MULT;
    private static final int[] ADPCM_4BIT_SAMPLE_MULT;
    private static final int[] ADPCM_26BIT_SAMPLE_MULT;
    private static final int[] ADPCM_2BIT_SAMPLE_MULT;
    private static final int DSPCMD_SC_DMA_8_1 = 20;
    private static final int DSPCMD_SC_DMA_8_2 = 21;
    private static final int DSPCMD_SC_DMA_8_3 = 145;
    private static final int DSPCMD_AI_DMA_8_1 = 28;
    private static final int DSPCMD_AI_DMA_8_2 = 144;
    private static final int DSPCMD_SC_ADPCM_2 = 22;
    private static final int DSPCMD_SC_ADPCM_2_REF = 23;
    private static final int DSPCMD_SC_ADPCM_26 = 118;
    private static final int DSPCMD_SC_ADPCM_26_REF = 119;
    private static final int DSPCMD_SC_ADPCM_4 = 116;
    private static final int DSPCMD_SC_ADPCM_4_REF = 117;
    private static final int DSPCMD_GENERIC_DMA_0 = 176;
    private static final int DSPCMD_GENERIC_DMA_1 = 177;
    private static final int DSPCMD_GENERIC_DMA_2 = 178;
    private static final int DSPCMD_GENERIC_DMA_3 = 179;
    private static final int DSPCMD_GENERIC_DMA_4 = 180;
    private static final int DSPCMD_GENERIC_DMA_5 = 181;
    private static final int DSPCMD_GENERIC_DMA_6 = 182;
    private static final int DSPCMD_GENERIC_DMA_7 = 183;
    private static final int DSPCMD_GENERIC_DMA_8 = 184;
    private static final int DSPCMD_GENERIC_DMA_9 = 185;
    private static final int DSPCMD_GENERIC_DMA_A = 186;
    private static final int DSPCMD_GENERIC_DMA_B = 187;
    private static final int DSPCMD_GENERIC_DMA_C = 188;
    private static final int DSPCMD_GENERIC_DMA_D = 189;
    private static final int DSPCMD_GENERIC_DMA_E = 190;
    private static final int DSPCMD_GENERIC_DMA_F = 191;
    private static final int DSPCMD_GENERIC_DMA_G = 192;
    private static final int DSPCMD_GENERIC_DMA_H = 193;
    private static final int DSPCMD_GENERIC_DMA_I = 194;
    private static final int DSPCMD_GENERIC_DMA_J = 195;
    private static final int DSPCMD_GENERIC_DMA_K = 196;
    private static final int DSPCMD_GENERIC_DMA_L = 197;
    private static final int DSPCMD_GENERIC_DMA_M = 198;
    private static final int DSPCMD_GENERIC_DMA_N = 199;
    private static final int DSPCMD_GENERIC_DMA_O = 200;
    private static final int DSPCMD_GENERIC_DMA_P = 201;
    private static final int DSPCMD_GENERIC_DMA_Q = 202;
    private static final int DSPCMD_GENERIC_DMA_R = 203;
    private static final int DSPCMD_GENERIC_DMA_S = 204;
    private static final int DSPCMD_GENERIC_DMA_T = 205;
    private static final int DSPCMD_GENERIC_DMA_U = 206;
    private static final int DSPCMD_GENERIC_DMA_V = 207;
    private static final int DSPCMD_DIRECT_DAC = 16;
    private static final int DSPCMD_CONTINUE_DMA_AI = 69;
    private static final int DSPCMD_CONTINUE_DMA_AI_16 = 71;
    private static final int DSPCMD_SET_TC = 64;
    private static final int DSPCMD_SET_OUTPUT_RATE = 65;
    private static final int DSPCMD_SET_INPUT_RATE = 66;
    private static final int DSPCMD_SET_BLOCKSIZE = 72;
    private static final int DSPCMD_SILENCE = 128;
    private static final int DSPCMD_PAUSE_DMA = 208;
    private static final int DSPCMD_SPEAKER_ON = 209;
    private static final int DSPCMD_SPEAKER_OFF = 211;
    private static final int DSPCMD_CONTINUE_DMA = 212;
    private static final int DSPCMD_PAUSE_DMA_16 = 213;
    private static final int DSPCMD_CONTINUE_DMA_16 = 214;
    private static final int DSPCMD_SPEAKER_STATUS = 216;
    private static final int DSPCMD_EXIT_DMA_16 = 217;
    private static final int DSPCMD_EXIT_DMA = 218;
    private static final int DSPCMD_DSP_IDENTIFY = 224;
    private static final int DSPCMD_DSP_VERSION = 225;
    private static final int DSPCMD_DMA_IDENTIFY = 226;
    private static final int DSPCMD_COPYRIGHT = 227;
    private static final int DSPCMD_WRITE_TEST = 228;
    private static final int DSPCMD_READ_TEST = 232;
    private static final int DSPCMD_RAISE_8BIT_IRQ = 242;
    private static final int DSPCMD_UNDOCUMENTED1 = 248;
    private static final byte[] E2_MAGIC;
    private static final int FM_CHIPS = 1;
    private static final String copyright = "COPYRIGHT (C) CREATIVE TECHNOLOGY LTD, 1992.";
    public static final long TIME_NEVER = Long.MAX_VALUE;
    String lastMessage;
    int portRepeats;
    boolean soundDebuggingEnabled;

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.baseIOAddress);
        sRDumper.dumpBoolean(this.irq2);
        sRDumper.dumpBoolean(this.irq5);
        sRDumper.dumpBoolean(this.irq7);
        sRDumper.dumpBoolean(this.irq10);
        sRDumper.dumpInt(this.dmaMask);
        sRDumper.dumpInt(this.dmaRequested);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpObject(this.primaryDMAController);
        sRDumper.dumpObject(this.secondaryDMAController);
        sRDumper.dumpObject(this.irqController);
        sRDumper.dumpObject(this.timer);
        sRDumper.dumpObject(this.pcmOutput);
        sRDumper.dumpBoolean(this.irq8Bit);
        sRDumper.dumpBoolean(this.irq16Bit);
        sRDumper.dumpInt(this.mixerIndex);
        sRDumper.dumpInt(this.mixerPrevIndex);
        sRDumper.dumpInt(this.dspCommandState);
        sRDumper.dumpArray(this.dspOutput);
        sRDumper.dumpInt(this.dspOutputUsed);
        sRDumper.dumpArray(this.mixerRegisters);
        sRDumper.dumpLong(this.dspNextAttention);
        sRDumper.dumpBoolean(this.speakerConnected);
        sRDumper.dumpObject(this.fmChip);
        sRDumper.dumpObject(this.fmOutput);
        sRDumper.dumpInt(this.fmIndex);
        sRDumper.dumpLong(this.fmNextAttention);
        sRDumper.dumpInt(this.dmaState);
        sRDumper.dumpInt(this.samplesLeft);
        sRDumper.dumpInt(this.origSamplesLeft);
        sRDumper.dumpInt(this.soundFormat);
        sRDumper.dumpBoolean(this.stereo);
        sRDumper.dumpLong(this.interSampleTime);
        sRDumper.dumpBoolean(this.istStereoAdjust);
        sRDumper.dumpInt(this.dmaActiveMask);
        sRDumper.dumpBoolean(this.dmaRequest);
        sRDumper.dumpLong(this.dmaRequestTime);
        sRDumper.dumpInt(this.partialSample);
        sRDumper.dumpInt(this.partialSampleBytes);
        sRDumper.dumpInt(this.wholeSampleBytes);
        sRDumper.dumpInt(this.byteBuffer);
        sRDumper.dumpInt(this.byteBufferSamples);
        sRDumper.dumpInt(this.adpcmReference);
        sRDumper.dumpByte(this.adpcmScale);
        sRDumper.dumpLong(this.nextSampleTime);
        sRDumper.dumpBoolean(this.dmaPaused);
        sRDumper.dumpInt(this.dmaPauseLeft);
        sRDumper.dumpInt(this.dspArgumentRegister);
        sRDumper.dumpInt(this.dspNextDMA);
        sRDumper.dumpInt(this.dspLastCommand);
        sRDumper.dumpBoolean(this.e2Mode);
        sRDumper.dumpByte(this.e2Value);
        sRDumper.dumpInt(this.e2Count);
    }

    public SoundCard(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.baseIOAddress = sRLoader.loadInt();
        this.irq2 = sRLoader.loadBoolean();
        this.irq5 = sRLoader.loadBoolean();
        this.irq7 = sRLoader.loadBoolean();
        this.irq10 = sRLoader.loadBoolean();
        this.dmaMask = sRLoader.loadInt();
        this.dmaRequested = sRLoader.loadInt();
        this.ioportRegistered = sRLoader.loadBoolean();
        this.clock = (Clock)sRLoader.loadObject();
        this.primaryDMAController = (DMAController)sRLoader.loadObject();
        this.secondaryDMAController = (DMAController)sRLoader.loadObject();
        this.irqController = (InterruptController)sRLoader.loadObject();
        this.timer = (Timer)sRLoader.loadObject();
        this.pcmOutput = (OutputChannelPCM)sRLoader.loadObject();
        this.irq8Bit = sRLoader.loadBoolean();
        this.irq16Bit = sRLoader.loadBoolean();
        this.mixerIndex = sRLoader.loadInt();
        this.mixerPrevIndex = sRLoader.loadInt();
        this.dspCommandState = sRLoader.loadInt();
        this.dspOutput = sRLoader.loadArrayInt();
        this.dspOutputUsed = sRLoader.loadInt();
        this.mixerRegisters = sRLoader.loadArrayInt();
        this.dspNextAttention = sRLoader.loadLong();
        this.speakerConnected = sRLoader.loadBoolean();
        this.fmChip = (FMChip)sRLoader.loadObject();
        this.fmOutput = (OutputChannelFM)sRLoader.loadObject();
        this.fmIndex = sRLoader.loadInt();
        this.fmNextAttention = sRLoader.loadLong();
        this.dmaState = sRLoader.loadInt();
        this.samplesLeft = sRLoader.loadInt();
        this.origSamplesLeft = sRLoader.loadInt();
        this.soundFormat = sRLoader.loadInt();
        this.stereo = sRLoader.loadBoolean();
        this.interSampleTime = sRLoader.loadLong();
        this.istStereoAdjust = sRLoader.loadBoolean();
        this.dmaActiveMask = sRLoader.loadInt();
        this.dmaRequest = sRLoader.loadBoolean();
        this.dmaRequestTime = sRLoader.loadLong();
        this.partialSample = sRLoader.loadInt();
        this.partialSampleBytes = sRLoader.loadInt();
        this.wholeSampleBytes = sRLoader.loadInt();
        this.byteBuffer = sRLoader.loadInt();
        this.byteBufferSamples = sRLoader.loadInt();
        this.adpcmReference = sRLoader.loadInt();
        this.adpcmScale = sRLoader.loadByte();
        this.nextSampleTime = sRLoader.loadLong();
        this.dmaPaused = sRLoader.loadBoolean();
        this.dmaPauseLeft = sRLoader.loadInt();
        this.dspArgumentRegister = sRLoader.loadInt();
        this.dspNextDMA = sRLoader.loadInt();
        this.dspLastCommand = sRLoader.loadInt();
        this.e2Mode = sRLoader.loadBoolean();
        this.e2Value = sRLoader.loadByte();
        this.e2Count = sRLoader.loadInt();
    }

    public SoundCard(String string) throws IOException {
        char c = '\u0000';
        int n = 0;
        int n2 = 5;
        this.baseIOAddress = 544;
        int n3 = 1;
        int n4 = 5;
        this.interSampleTime = 50000L;
        this.dspNextDMA = -1;
        this.fmChip = new FMChip();
        this.fmOutput = null;
        this.fmIndex = 0;
        this.fmNextAttention = Long.MAX_VALUE;
        this.dspNextAttention = Long.MAX_VALUE;
        this.dspOutput = new int[256];
        this.mixerRegisters = new int[25];
        this.mixerPrevIndex = 128;
        this.mixerIndex = 128;
        this.dspCommandState = 0;
        for (int i = 0; i < string.length() + 1; ++i) {
            char c2 = '\u0000';
            if (i < string.length()) {
                c2 = string.charAt(i);
            }
            if (c2 >= '0' && c2 <= '9' && c != '\u0000') {
                n = n * 10 + (c2 - 48);
                continue;
            }
            if (c2 >= '0' && c2 <= '9' && c == '\u0000') {
                throw new IOException("Soundcard: Invalid spec '" + string + "'.");
            }
            if (c == 'A') {
                if (n > 65516) {
                    throw new IOException("Soundcard: Bad I/O port " + n + ".");
                }
                this.baseIOAddress = n;
            } else if (c == 'I') {
                if (n != 2 && n != 5 && n != 7 && n != 10) {
                    throw new IOException("Soundcard: Bad IRQ " + n + ".");
                }
                n2 = n;
            } else if (c == 'D') {
                if (n != 0 && n != 1 && n != 3) {
                    throw new IOException("Soundcard: Bad low DMA " + n + ".");
                }
                n3 = n;
            } else if (c == 'H') {
                if (n == 0) {
                    n4 = 0;
                } else {
                    if (n != 5 && n != 6 || n != 7) {
                        throw new IOException("Soundcard: Bad high DMA " + n + ".");
                    }
                    n4 = n;
                }
            } else if (c > '\u0000' || i > 0) {
                throw new IOException("Soundcard: Invalid setting type '" + c + "'.");
            }
            if (c2 == '\u0000') break;
            c = c2;
            n = 0;
        }
        if (n2 == 2) {
            this.irq2 = true;
        }
        if (n2 == 5) {
            this.irq5 = true;
        }
        if (n2 == 7) {
            this.irq7 = true;
        }
        if (n2 == 10) {
            this.irq10 = true;
        }
        this.dmaMask = n4 > 0 ? 1 << n3 | 1 << n4 : 1 << n3;
        this.dmaRequested = 0;
        this.resetMixer();
    }

    private final void grabDMAChannels() {
        int n = this.dmaMask & ~this.dmaRequested;
        if (this.primaryDMAController == null) {
            n &= 0xF0;
        }
        if (this.secondaryDMAController == null) {
            n &= 0xF;
        }
        if ((n & 1) != 0 && this.primaryDMAController != null) {
            this.primaryDMAController.registerChannel(0, this);
        }
        if ((n & 2) != 0 && this.primaryDMAController != null) {
            this.primaryDMAController.registerChannel(1, this);
        }
        if ((n & 8) != 0 && this.primaryDMAController != null) {
            this.primaryDMAController.registerChannel(3, this);
        }
        if ((n & 0x20) != 0 && this.secondaryDMAController != null) {
            this.secondaryDMAController.registerChannel(1, this);
        }
        if ((n & 0x40) != 0 && this.secondaryDMAController != null) {
            this.secondaryDMAController.registerChannel(2, this);
        }
        if ((n & 0x80) != 0 && this.secondaryDMAController != null) {
            this.secondaryDMAController.registerChannel(3, this);
        }
        this.dmaRequested |= n;
        this.dmaEngineUpdateDMADREQ();
    }

    public SoundCard() throws IOException {
        this("");
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tbaseIOAddress " + this.baseIOAddress);
        statusDumper.println("\tirq8Bit " + this.irq8Bit);
        statusDumper.println("\tirq16Bit " + this.irq16Bit);
        statusDumper.println("\tirq2 " + this.irq2);
        statusDumper.println("\tirq5 " + this.irq5);
        statusDumper.println("\tirq7 " + this.irq7);
        statusDumper.println("\tirq10 " + this.irq10);
        statusDumper.println("\tdmaMask " + this.dmaMask);
        statusDumper.println("\tdmaRequested " + this.dmaRequested);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tirqController <object #" + statusDumper.objectNumber(this.irqController) + ">");
        if (this.irqController != null) {
            this.irqController.dumpStatus(statusDumper);
        }
        statusDumper.println("\tprimaryDMAController <object #" + statusDumper.objectNumber(this.primaryDMAController) + ">");
        if (this.primaryDMAController != null) {
            this.primaryDMAController.dumpStatus(statusDumper);
        }
        statusDumper.println("\tsecondaryDMAController <object #" + statusDumper.objectNumber(this.secondaryDMAController) + ">");
        if (this.secondaryDMAController != null) {
            this.secondaryDMAController.dumpStatus(statusDumper);
        }
        statusDumper.println("\tclock <object #" + statusDumper.objectNumber(this.clock) + ">");
        if (this.clock != null) {
            this.clock.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttimer <object #" + statusDumper.objectNumber(this.timer) + ">");
        if (this.timer != null) {
            this.timer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tpcmOutput <object #" + statusDumper.objectNumber(this.pcmOutput) + ">");
        if (this.pcmOutput != null) {
            this.pcmOutput.dumpStatus(statusDumper);
        }
        statusDumper.println("\tmixerIndex " + this.mixerIndex);
        statusDumper.println("\tmixerPrevIndex " + this.mixerPrevIndex);
        statusDumper.printArray(this.mixerRegisters, "mixerRegisters");
        statusDumper.println("\tspeakerConnected " + this.speakerConnected);
        statusDumper.println("\tfmIndex " + this.fmIndex);
        statusDumper.println("\tfmNextAttention " + this.fmNextAttention);
        statusDumper.println("\tfmChip <object #" + statusDumper.objectNumber(this.fmChip) + ">");
        if (this.fmChip != null) {
            this.fmChip.dumpStatus(statusDumper);
        }
        statusDumper.println("\tfmOutput <object #" + statusDumper.objectNumber(this.fmOutput) + ">");
        if (this.fmOutput != null) {
            this.fmOutput.dumpStatus(statusDumper);
        }
        statusDumper.printArray(this.dspOutput, "dspOutput");
        statusDumper.println("\tdspOutputUsed " + this.dspOutputUsed);
        statusDumper.println("\tdspCommandState " + this.dspCommandState);
        statusDumper.println("\tdspNextAttention " + this.dspNextAttention);
        statusDumper.println("\tdmaState " + this.dmaState);
        statusDumper.println("\tsamplesLeft " + this.samplesLeft);
        statusDumper.println("\torigSamplesLeft " + this.origSamplesLeft);
        statusDumper.println("\tsoundFormat " + this.soundFormat);
        statusDumper.println("\tstereo " + this.stereo);
        statusDumper.println("\tinterSampleTime " + this.interSampleTime);
        statusDumper.println("\tistStereoAdjust " + this.istStereoAdjust);
        statusDumper.println("\tdmaActiveMask " + this.dmaActiveMask);
        statusDumper.println("\tdmaRequest " + this.dmaRequest);
        statusDumper.println("\tdmaRequestTime " + this.dmaRequestTime);
        statusDumper.println("\tpartialSample " + this.partialSample);
        statusDumper.println("\tpartialSampleBytes " + this.partialSampleBytes);
        statusDumper.println("\twholeSampleBytes " + this.wholeSampleBytes);
        statusDumper.println("\tbyteBuffer " + this.byteBuffer);
        statusDumper.println("\tbyteBufferSamples " + this.byteBufferSamples);
        statusDumper.println("\tadpcmReference " + this.adpcmReference);
        statusDumper.println("\tadpcmScale " + this.adpcmScale);
        statusDumper.println("\tnextSampleTime " + this.nextSampleTime);
        statusDumper.println("\tdmaPaused " + this.dmaPaused);
        statusDumper.println("\tdmaPauseLeft " + this.dmaPauseLeft);
        statusDumper.println("\tdspArgumentRegister " + this.dspArgumentRegister);
        statusDumper.println("\tdspNextDMA " + this.dspNextDMA);
        statusDumper.println("\tdspLastCommand " + this.dspLastCommand);
        statusDumper.println("\te2Mode " + this.e2Mode);
        statusDumper.println("\te2Value " + this.e2Value);
        statusDumper.println("\te2Count " + this.e2Count);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": SoundCard:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public void DEBUGOPTION_soundcard_transfer_debugging(boolean bl) {
        this.soundDebuggingEnabled = bl;
    }

    @Override
    public boolean initialised() {
        return this.irqController != null && this.clock != null && this.primaryDMAController != null && this.secondaryDMAController != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqController = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof DMAController && ((DMAController)hardwareComponent).isPrimary() && hardwareComponent.initialised()) {
            this.primaryDMAController = (DMAController)hardwareComponent;
            this.grabDMAChannels();
        }
        if (hardwareComponent instanceof DMAController && !((DMAController)hardwareComponent).isPrimary() && hardwareComponent.initialised()) {
            this.secondaryDMAController = (DMAController)hardwareComponent;
            this.grabDMAChannels();
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
            this.timer = this.clock.newTimer(this);
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised() && !this.ioportRegistered) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public int[] ioPortsRequested() {
        int[] nArray = new int[20];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = this.baseIOAddress + i;
        }
        nArray[nArray.length - 4] = 904;
        nArray[nArray.length - 3] = 905;
        nArray[nArray.length - 2] = 906;
        nArray[nArray.length - 1] = 907;
        return nArray;
    }

    @Override
    public int getTimerType() {
        return 36;
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
        this.ioPortWriteByte(n + 2, n2 >>> 16 & 0xFF);
        this.ioPortWriteByte(n + 3, n2 >>> 24 & 0xFF);
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) | this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        return this.ioPortReadByte(n) | this.ioPortReadByte(n + 1) << 8 | this.ioPortReadByte(n + 2) << 16 | this.ioPortReadByte(n + 3) << 24;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        if (n >= this.baseIOAddress && n < this.baseIOAddress + 16) {
            if ((n - this.baseIOAddress & 0xFFFFFFFE) != 8) {
                this.ioWrite(n - this.baseIOAddress, n2);
            } else {
                this.ioWrite(n - this.baseIOAddress - 8, n2);
            }
        } else if (n >= 904 && n < 908) {
            this.ioWrite(n - 904, n2);
        }
    }

    @Override
    public int ioPortReadByte(int n) {
        int n2 = -1;
        if (n >= this.baseIOAddress && n < this.baseIOAddress + 16) {
            n2 = (n - this.baseIOAddress & 0xFFFFFFFE) != 8 ? this.ioRead(n - this.baseIOAddress) : this.ioRead(n - this.baseIOAddress - 8);
        } else if (n >= 904 && n < 908) {
            n2 = this.ioRead(n - 904);
        }
        return n2;
    }

    @Override
    public int handleTransfer(DMAController.DMAChannel dMAChannel, int n, int n2) {
        byte[] byArray = new byte[1];
        if (this.e2Mode) {
            byArray[0] = this.e2Value;
            dMAChannel.writeMemory(byArray, 0, n, 1);
            this.e2Mode = false;
            this.dmaEngineUpdateDMADREQ();
            return n + 1;
        }
        for (int i = n2 - n; i > 0 && this.partialSampleBytes < this.wholeSampleBytes; --i) {
            dMAChannel.readMemory(byArray, 0, n, 1);
            this.partialSample |= (byArray[0] & 0xFF) << 8 * this.partialSampleBytes;
            ++n;
            ++this.partialSampleBytes;
        }
        this.dmaEngineUpdateDMADREQ();
        if (this.partialSampleBytes == this.wholeSampleBytes) {
            this.dmaEngineSampleAvailable();
        }
        return n;
    }

    @Override
    public int requestedSoundChannels() {
        return 2;
    }

    @Override
    public void soundChannelCallback(Output output, String string) {
        if (this.pcmOutput == null) {
            this.pcmOutput = new OutputChannelPCM(output, string);
        } else if (this.fmOutput == null) {
            OutputChannelFM outputChannelFM = new OutputChannelFM(output, string);
            this.fmChip.setOutput(outputChannelFM);
            this.fmOutput = outputChannelFM;
        }
        this.recomputeVolume(0L);
    }

    private final void setIRQ(int n) {
        if (this.irq2) {
            this.irqController.setIRQ(2, n);
        }
        if (this.irq5) {
            this.irqController.setIRQ(5, n);
        }
        if (this.irq7) {
            this.irqController.setIRQ(7, n);
        }
        if (this.irq10) {
            this.irqController.setIRQ(10, n);
        }
    }

    private final int readDMARegister() {
        return this.dmaMask;
    }

    private final void writeDMARegister(int n) {
        this.dmaMask = n &= 0xEB;
        this.grabDMAChannels();
    }

    private final int readIRQRegister() {
        int n = 240;
        if (this.irq2) {
            n |= 1;
        }
        if (this.irq5) {
            n |= 2;
        }
        if (this.irq7) {
            n |= 4;
        }
        if (this.irq10) {
            n |= 8;
        }
        return n;
    }

    private final void writeIRQRegister(int n) {
        this.irq2 = (n & 1) != 0;
        this.irq5 = (n & 2) != 0;
        this.irq7 = (n & 4) != 0;
        this.irq10 = (n & 8) != 0;
    }

    private final int readIRQStatus() {
        return 0x10 | (this.irq8Bit ? 1 : 0) | (this.irq16Bit ? 2 : 0);
    }

    private final void set8BitIRQ(boolean bl) {
        boolean bl2;
        boolean bl3 = this.irq8Bit || this.irq16Bit;
        this.irq8Bit = bl;
        boolean bl4 = bl2 = this.irq8Bit || this.irq16Bit;
        if (bl3 != bl2) {
            this.setIRQ(bl2 ? 1 : 0);
        }
    }

    private final void set16BitIRQ(boolean bl) {
        boolean bl2;
        boolean bl3 = this.irq8Bit || this.irq16Bit;
        this.irq16Bit = bl;
        boolean bl4 = bl2 = this.irq8Bit || this.irq16Bit;
        if (bl3 != bl2) {
            this.setIRQ(bl2 ? 1 : 0);
        }
    }

    private final void writeMessage(String string) {
        this.writeMessage(string, false);
    }

    private final void writeMessage(String string, boolean bl) {
        if (!bl) {
            if (!this.soundDebuggingEnabled) {
                return;
            }
            string = "Informational: " + string;
        }
        if (string.equals(this.lastMessage)) {
            ++this.portRepeats;
        } else {
            if (this.portRepeats > 1) {
                System.err.println("<Last message repeted " + this.portRepeats + " times.>");
            }
            System.err.println(string);
            this.lastMessage = string;
            this.portRepeats = 1;
        }
    }

    public void ioWrite(int n, int n2) {
        switch (n) {
            case 0: {
                this.fmIndex = n2;
                return;
            }
            case 1: {
                this.writeFM(this.fmIndex, n2);
                return;
            }
            case 2: {
                this.fmIndex = 256 + n2;
                return;
            }
            case 3: {
                this.writeFM(this.fmIndex, n2);
                return;
            }
            case 4: {
                this.mixerPrevIndex = this.mixerIndex;
                if (!this.validMixerRegister(this.mixerPrevIndex, 0)) {
                    this.mixerPrevIndex |= 0x80;
                }
                this.mixerIndex = n2;
                return;
            }
            case 5: {
                this.writeMixer(this.mixerIndex, n2);
                return;
            }
            case 6: {
                this.writeMessage("SB: Resetting card.");
                this.doReset(n2);
                return;
            }
            case 12: {
                this.dspWrite(n2);
                return;
            }
        }
        this.writeMessage("SB: Attempted write to port " + n + ".");
    }

    public int ioRead(int n) {
        switch (n) {
            case 0: 
            case 2: {
                int n2 = this.readFMStatus();
                return n2;
            }
            case 1: 
            case 3: {
                this.writeMessage("SB: Tried to read FM data port.");
                return 0;
            }
            case 4: {
                return this.mixerIndex;
            }
            case 5: {
                int n3 = this.readMixer(this.mixerIndex);
                return n3;
            }
            case 10: {
                int n4 = this.dspRead();
                return n4;
            }
            case 12: {
                return this.writeBufferStatus();
            }
            case 13: {
                return 255;
            }
            case 14: {
                this.set8BitIRQ(false);
                int n5 = this.dspDataAvailableStatus();
            }
            case 15: {
                this.set16BitIRQ(false);
                return -1;
            }
        }
        this.writeMessage("SB: Attempted read from port " + n + ".");
        return 255;
    }

    public void resetCard() {
        this.irq8Bit = false;
        this.irq16Bit = false;
        this.mixerIndex = 128;
        this.mixerPrevIndex = 128;
        this.dspOutputUsed = 0;
        this.dspLastCommand = 0;
        this.setIRQ(0);
        this.speakerConnected = false;
        this.dspCommandState = 0;
        this.resetMixer();
        this.dmaEngineKillTransfer();
        this.e2Mode = false;
        this.e2Value = (byte)-86;
        this.e2Count = 0;
    }

    @Override
    public void reset() {
        this.fmIndex = 0;
        this.ioportRegistered = false;
        if (this.clock != null) {
            this.fmChip.resetCard(this.clock.getTime());
        } else {
            this.fmChip.resetCard(0L);
        }
        this.resetCard();
    }

    private final int writeBufferStatus() {
        return 127;
    }

    private final int dspDataAvailableStatus() {
        return 0x7F | (this.dspOutputUsed > 0 ? 128 : 0);
    }

    private final boolean validMixerRegister(int n, int n2) {
        if (n == 128 || n == 129 || n == 4 || n == 10 || n == 14) {
            return true;
        }
        if (n == 34 || n == 38 || n == 40 || n == 46) {
            return true;
        }
        if (n == 130 && n2 >= 0) {
            return true;
        }
        if (n < 0 || n > 71) {
            return false;
        }
        if (n == 0) {
            return n2 <= 0;
        }
        if (n == 1) {
            return n2 >= 0;
        }
        return n >= 48;
    }

    private final void writeMixer(int n, int n2) {
        if (n == 128) {
            this.writeIRQRegister(n2);
            return;
        }
        if (n == 129) {
            this.writeDMARegister(n2);
            return;
        }
        if (n == 0) {
            this.resetMixer();
            return;
        }
        if (n == 4) {
            this.mixerRegisters[2] = n2 & 0xF0 | 8;
            this.mixerRegisters[3] = (n2 & 0xF) << 4 | 8;
            this.recomputeVolume(this.clock.getTime());
            return;
        }
        if (n == 10) {
            this.mixerRegisters[10] = (n2 & 7) << 5;
            return;
        }
        if (n == 14) {
            this.mixerRegisters[24] = n2;
            return;
        }
        if (n == 34) {
            this.mixerRegisters[0] = n2 & 0xF0 | 8;
            this.mixerRegisters[1] = (n2 & 0xF) << 4 | 8;
            this.recomputeVolume(this.clock.getTime());
            return;
        }
        if (n == 38) {
            this.mixerRegisters[4] = n2 & 0xF0 | 8;
            this.mixerRegisters[5] = (n2 & 0xF) << 4 | 8;
            this.recomputeVolume(this.clock.getTime());
            return;
        }
        if (n == 40) {
            this.mixerRegisters[6] = n2 & 0xF0 | 8;
            this.mixerRegisters[7] = (n2 & 0xF) << 4 | 8;
            return;
        }
        if (n == 46) {
            this.mixerRegisters[8] = n2 & 0xF0 | 8;
            this.mixerRegisters[9] = (n2 & 0xF) << 4 | 8;
            return;
        }
        if (!this.validMixerRegister(n, -1)) {
            return;
        }
        this.mixerRegisters[n - 48] = n2;
        this.recomputeVolume(this.clock.getTime());
    }

    private final int readMixer(int n) {
        if (n == 128) {
            return this.readIRQRegister();
        }
        if (n == 129) {
            return this.readDMARegister();
        }
        if (n == 130) {
            return this.readIRQStatus();
        }
        if (n == 1) {
            return this.mixerPrevIndex;
        }
        if (n == 4) {
            return this.mixerRegisters[2] & 0xF0 | (this.mixerRegisters[3] & 0xF0) >> 4;
        }
        if (n == 10) {
            return this.mixerRegisters[10] >> 5;
        }
        if (n == 14) {
            return this.mixerRegisters[24];
        }
        if (n == 34) {
            return this.mixerRegisters[0] & 0xF0 | (this.mixerRegisters[1] & 0xF0) >> 4;
        }
        if (n == 38) {
            return this.mixerRegisters[4] & 0xF0 | (this.mixerRegisters[5] & 0xF0) >> 4;
        }
        if (n == 40) {
            return this.mixerRegisters[6] & 0xF0 | (this.mixerRegisters[7] & 0xF0) >> 4;
        }
        if (n == 46) {
            return this.mixerRegisters[8] & 0xF0 | (this.mixerRegisters[9] & 0xF0) >> 4;
        }
        if (!this.validMixerRegister(n, 1)) {
            return -1;
        }
        return this.mixerRegisters[n - 48];
    }

    private final void resetMixer() {
        this.mixerRegisters[0] = 192;
        this.mixerRegisters[1] = 192;
        this.mixerRegisters[2] = 192;
        this.mixerRegisters[3] = 192;
        this.mixerRegisters[4] = 192;
        this.mixerRegisters[5] = 192;
        this.mixerRegisters[6] = 0;
        this.mixerRegisters[7] = 0;
        this.mixerRegisters[8] = 0;
        this.mixerRegisters[9] = 0;
        this.mixerRegisters[10] = 0;
        this.mixerRegisters[11] = 0;
        this.mixerRegisters[24] = 31;
        this.mixerRegisters[13] = 21;
        this.mixerRegisters[14] = 11;
        this.mixerRegisters[15] = 0;
        this.mixerRegisters[16] = 0;
        this.mixerRegisters[17] = 0;
        this.mixerRegisters[18] = 0;
        this.mixerRegisters[19] = 0;
        this.mixerRegisters[20] = 128;
        this.mixerRegisters[21] = 128;
        this.mixerRegisters[22] = 128;
        this.mixerRegisters[23] = 128;
        this.mixerRegisters[24] = 0;
        if (this.clock != null) {
            this.recomputeVolume(this.clock.getTime());
        } else {
            this.recomputeVolume(0L);
        }
    }

    private final void recomputeVolume(long l) {
        int n = 65025;
        int n2 = this.mixerRegisters[0];
        int n3 = this.mixerRegisters[1];
        int n4 = this.mixerRegisters[2];
        int n5 = this.mixerRegisters[3];
        int n6 = this.mixerRegisters[4];
        int n7 = this.mixerRegisters[5];
        int n8 = 1 << (this.mixerRegisters[17] >> 6);
        int n9 = 1 << (this.mixerRegisters[18] >> 6);
        int n10 = n2 * n4 * n8;
        int n11 = n3 * n5 * n9;
        int n12 = n2 * n6 * n8;
        int n13 = n3 * n7 * n9;
        if (this.pcmOutput != null) {
            this.pcmOutput.addFrameVolumeChange(l, n10, n, n11, n);
        }
        if (this.fmOutput != null) {
            this.fmOutput.addFrameVolumeChange(l, n12, n, n13, n);
        }
    }

    private final void sendPCMSample(long l, short s, short s2) {
        this.pcmOutput.addFrameSampleStereo(l, s, s2);
    }

    private final int readFMStatus() {
        return this.fmChip.status(this.clock.getTime());
    }

    private final int dspRead() {
        int n = this.dspOutput[0];
        if (this.dspOutputUsed > 1) {
            System.arraycopy(this.dspOutput, 1, this.dspOutput, 0, this.dspOutputUsed - 1);
        }
        --this.dspOutputUsed;
        return n;
    }

    private final void writeFM(int n, int n2) {
        this.fmChip.write(this.clock.getTime(), n, n2);
        this.updateTimer();
    }

    private final void doReset(int n) {
        this.resetCard();
        this.dspOutput[0] = 170;
        this.dspOutputUsed = 1;
    }

    private final void updateTimer() {
        long l;
        long l2 = Long.MAX_VALUE;
        if (this.dspNextAttention < l2) {
            l2 = this.dspNextAttention;
        }
        if ((l = this.fmChip.nextAttention(this.clock.getTime())) < l2) {
            l2 = l;
        }
        if (l2 != Long.MAX_VALUE) {
            if (this.timer != null) {
                this.timer.setExpiry(l2);
            }
        } else if (this.timer != null) {
            this.timer.disable();
        }
    }

    private final void updateTimer(long l) {
        this.dspNextAttention = l;
        this.updateTimer();
    }

    @Override
    public void callback() {
        long l = this.clock.getTime();
        boolean bl = true;
        while (bl) {
            long l2;
            bl = false;
            if (this.dspNextAttention <= l) {
                this.dspAttention(this.dspNextAttention);
                bl = true;
            }
            if ((l2 = this.fmChip.nextAttention(this.clock.getTime())) <= l) {
                this.fmChip.attention(this.clock.getTime());
                bl = true;
            }
            if (!bl) continue;
            this.updateTimer();
        }
    }

    private final void dspOutputPut(int n) {
        this.dspOutput[this.dspOutputUsed++] = n;
    }

    private final String interpretMode(int n) {
        if (n == 0) {
            return "NONE";
        }
        if (n == 1) {
            return "SC";
        }
        if (n == 2) {
            return "AI";
        }
        if (n == 3) {
            return "AI_EXIT";
        }
        return "UNKNOWN(" + n + ")";
    }

    private final String interpretFormat(int n) {
        switch (n) {
            case 0: {
                return "ADPCM_2_BIT";
            }
            case 1: {
                return "ADPCM_2.6_BIT";
            }
            case 2: {
                return "ADPCM_4_BIT";
            }
            case 3: {
                return "ADPCM_2_BIT_REF";
            }
            case 4: {
                return "ADPCM_2.6_BIT_REF";
            }
            case 5: {
                return "ADPCM_4_BIT_REF";
            }
            case 6: {
                return "PCM_8BIT_SIGNED";
            }
            case 7: {
                return "PCM_8BIT_PCM_UNSIGNED";
            }
            case 8: {
                return "PCM_16BIT_LE_SIGNED";
            }
            case 9: {
                return "PCM_16BIT_LE_UNSIGNED";
            }
            case 10: {
                return "PCM_16BIT_BE_SIGNED";
            }
            case 11: {
                return "PCM_16BIT_BE_UNSIGNED";
            }
        }
        return "UNKNOWN(" + n + ")";
    }

    private final void dmaEngineStartTransfer(int n, int n2, int n3, boolean bl) {
        long l = this.clock.getTime();
        this.dmaState = n;
        this.samplesLeft = this.origSamplesLeft = n2;
        this.soundFormat = n3;
        this.stereo = bl;
        this.partialSample = 0;
        this.partialSampleBytes = 0;
        this.wholeSampleBytes = 0;
        this.byteBuffer = 0;
        this.byteBufferSamples = 0;
        this.dmaPaused = false;
        this.nextSampleTime = l;
        this.updateTimer(this.nextSampleTime);
        this.writeMessage("SBDSP: Starting DMA: mode=" + this.interpretMode(n) + " samples=" + n2 + " format=" + this.interpretFormat(n3) + " stereoFlag=" + bl);
    }

    private final void dmaEngineKillTransfer() {
        int n = this.dmaActiveMask;
        this.dmaState = 0;
        this.dmaPaused = false;
        this.partialSample = 0;
        this.wholeSampleBytes = 0;
        this.partialSampleBytes = 0;
        this.dmaEngineUpdateDMADREQ();
        this.updateTimer(Long.MAX_VALUE);
        if (n != 0) {
            this.writeMessage("SBDSP: Killed DMA transfer.");
        }
    }

    private final void dmaEngineEndTransfer() {
        if (this.dmaState == 2) {
            this.writeMessage("SBDSP: Exiting DMA transfer.");
            this.dmaState = 3;
        }
    }

    private final void dmaEnginePauseTransfer() {
        this.dmaPaused = true;
        this.dmaPauseLeft = -1;
        this.updateTimer(Long.MAX_VALUE);
        this.writeMessage("SBDSP: Pausing DMA transfer.");
    }

    private final void dmaEnginePauseTransfer(int n) {
        this.dmaPaused = true;
        this.dmaPauseLeft = n;
        this.writeMessage("SBDSP: Pausing DMA transfer for " + n + " samples.");
    }

    private final void dmaEngineContinueTransfer() {
        this.dmaPaused = false;
        this.nextSampleTime = this.clock.getTime();
        this.updateTimer(this.nextSampleTime);
        this.writeMessage("SBDSP: Continuing DMA transfer.");
    }

    private static final boolean is16Bit(int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private final void dmaEngineNextSample() {
        this.partialSample = 0;
        this.partialSampleBytes = 0;
        this.wholeSampleBytes = 0;
        if (this.dmaPaused && this.dmaPauseLeft > 0) {
            --this.dmaPauseLeft;
            if (this.dmaPauseLeft == 0) {
                this.writeMessage("SBDSP: Continuing DMA transfer after timed pause.");
                this.set8BitIRQ(true);
                this.dmaPaused = false;
            }
        }
        if (this.dmaState == 0 || this.dmaPaused) {
            if (this.dmaPaused) {
                this.writeMessage("Halting paused transfer.");
            }
            this.updateTimer(Long.MAX_VALUE);
            return;
        }
        if (this.samplesLeft > 0) {
            this.samplesLeft -= this.stereo ? 2 : 1;
        }
        if (this.samplesLeft <= 0) {
            if (SoundCard.is16Bit(this.soundFormat)) {
                this.set16BitIRQ(true);
            } else {
                this.set8BitIRQ(true);
            }
            this.dspProgramNextDMA();
            if (this.dmaState == 2) {
                this.writeMessage("SBDSP: DMA transfer auto-reinitialized.");
                this.samplesLeft = this.origSamplesLeft;
            } else {
                this.writeMessage("SBDSP: DMA transfer ended.");
                this.dmaState = 0;
                this.updateTimer(Long.MAX_VALUE);
                return;
            }
        }
        long l = this.clock.getTime();
        long l2 = this.interSampleTime;
        if (this.stereo && this.istStereoAdjust) {
            l2 *= 2L;
        }
        this.nextSampleTime = this.dmaRequestTime == l ? (this.nextSampleTime += l2) : l + l2;
        this.updateTimer(this.nextSampleTime);
    }

    private final void dmaEngineUpdateDMADREQ() {
        int n;
        boolean bl;
        if (!this.dmaRequest && this.partialSampleBytes < this.wholeSampleBytes) {
            this.dmaRequest = true;
            this.dmaRequestTime = this.clock.getTime();
        }
        boolean bl2 = SoundCard.is16Bit(this.soundFormat) && (this.dmaMask & 0xF0) != 0 && !this.e2Mode;
        int n2 = this.dmaMask & ~this.dmaActiveMask;
        boolean bl3 = bl = this.partialSampleBytes < this.wholeSampleBytes || this.e2Mode;
        if (bl2) {
            for (n = 0; n < 4; ++n) {
                if (this.secondaryDMAController == null || !bl || (n2 >> 4 >> n & 1) == 0) continue;
                this.dmaActiveMask |= 16 << n;
                this.secondaryDMAController.holdDmaRequest(n);
            }
        }
        for (n = 0; n < 4; ++n) {
            if (this.primaryDMAController == null || !bl || (n2 >> n & 1) == 0) continue;
            this.dmaActiveMask |= 1 << n;
            this.primaryDMAController.holdDmaRequest(n);
        }
        if (this.partialSampleBytes == this.wholeSampleBytes && !this.e2Mode) {
            n2 = this.dmaActiveMask;
            this.dmaRequest = false;
            for (n = 0; n < 4; ++n) {
                if (this.secondaryDMAController != null && (n2 >> 4 >> n & 1) != 0) {
                    this.secondaryDMAController.releaseDmaRequest(n);
                    this.dmaActiveMask &= ~(16 << n);
                }
                if (this.primaryDMAController == null || (n2 >> n & 1) == 0) continue;
                this.primaryDMAController.releaseDmaRequest(n);
                this.dmaActiveMask &= ~(1 << n);
            }
        }
    }

    private final void dmaEngineAttention() {
        if (this.clock.getTime() < this.nextSampleTime) {
            return;
        }
        this.updateTimer(Long.MAX_VALUE);
        if (!this.dmaRequest) {
            int n = 0;
            switch (this.soundFormat) {
                case 6: 
                case 7: {
                    n += this.stereo ? 2 : 1;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n += this.stereo ? 4 : 2;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (this.byteBufferSamples != 0) break;
                    ++n;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    ++n;
                    if (this.byteBufferSamples == 0) {
                        // empty if block
                    }
                    ++n;
                }
            }
            this.partialSampleBytes = 0;
            this.partialSample = 0;
            if (!this.dmaPaused) {
                this.wholeSampleBytes = n;
                this.dmaEngineUpdateDMADREQ();
                if (n == 0) {
                    this.dmaEngineSampleAvailable();
                }
            } else {
                this.wholeSampleBytes = 0;
                this.dmaEngineSampleAvailable();
            }
        }
    }

    private final void dspAttention(long l) {
        this.dmaEngineAttention();
    }

    private final int extractBufferByte() {
        int n = this.partialSample & 0xFF;
        this.partialSample >>>= 8;
        --this.partialSampleBytes;
        --this.wholeSampleBytes;
        return n;
    }

    private final int nonRefFormatFor(int n) {
        switch (n) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return n;
    }

    private final boolean hasReference(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private final int byteBufferSamplesADPCM(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private final void dmaEngineSampleAvailable() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = this.clock.getTime();
        if (this.dmaPaused) {
            this.dmaEngineNextSample();
            return;
        }
        if (this.hasReference(this.soundFormat)) {
            this.adpcmReference = this.extractBufferByte();
            this.adpcmScale = 0;
            this.soundFormat = this.nonRefFormatFor(this.soundFormat);
        }
        switch (this.soundFormat) {
            case 0: 
            case 1: 
            case 2: {
                if (this.byteBufferSamples != 0) break;
                this.byteBuffer = this.extractBufferByte();
                this.byteBufferSamples = this.byteBufferSamplesADPCM(this.soundFormat);
            }
        }
        switch (this.soundFormat) {
            case 0: {
                this.dmaEngineADPCMDecode(this.byteBuffer >>> 6 & 3);
                this.byteBuffer <<= 2;
                --this.byteBufferSamples;
                n = n2 = 256 * (this.adpcmReference - 128);
                break;
            }
            case 1: {
                this.dmaEngineADPCMDecode(this.byteBuffer >>> 5 & 7);
                this.byteBuffer <<= 3;
                --this.byteBufferSamples;
                n = n2 = 256 * (this.adpcmReference - 128);
                break;
            }
            case 2: {
                this.dmaEngineADPCMDecode(this.byteBuffer >>> 4 & 0xF);
                this.byteBuffer <<= 4;
                --this.byteBufferSamples;
                n = n2 = 256 * (this.adpcmReference - 128);
                break;
            }
            case 7: {
                n3 = 32768;
            }
            case 6: {
                n = 256 * this.extractBufferByte();
                if (this.stereo) {
                    n2 = 256 * this.extractBufferByte();
                    break;
                }
                n2 = n;
                break;
            }
            case 9: {
                n3 = 32768;
            }
            case 8: {
                n = this.extractBufferByte();
                n |= this.extractBufferByte() << 8;
                if (this.stereo) {
                    n2 = this.extractBufferByte();
                    n2 |= this.extractBufferByte() << 8;
                    break;
                }
                n2 = n;
                break;
            }
            case 11: {
                n3 = 32768;
            }
            case 10: {
                n = this.extractBufferByte() << 8;
                n |= this.extractBufferByte();
                if (this.stereo) {
                    n2 = this.extractBufferByte() << 8;
                    n2 |= this.extractBufferByte();
                    break;
                }
                n2 = n;
            }
        }
        this.sendPCMSample(l, (short)(n - n3), (short)(n2 - n3));
        this.dmaEngineNextSample();
    }

    private final void dspWrite(int n) {
        block66: {
            block65: {
                int n2 = this.origSamplesLeft - 1;
                if (this.dspCommandState != 0) break block65;
                switch (n) {
                    case 20: 
                    case 21: 
                    case 145: {
                        this.dspArgumentRegister = 0;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 28: 
                    case 144: {
                        this.dspNextDMA = this.dspArgumentRegister = 0x10000 | (n2 & 0xFF) << 8 | (n2 & 0xFF00) >> 8;
                        break;
                    }
                    case 22: {
                        this.dspArgumentRegister = 2;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 23: {
                        this.dspArgumentRegister = 3;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 118: {
                        this.dspArgumentRegister = 4;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 119: {
                        this.dspArgumentRegister = 5;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 116: {
                        this.dspArgumentRegister = 6;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 117: {
                        this.dspArgumentRegister = 7;
                        this.dspCommandState = 11;
                        break;
                    }
                    case 176: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 207: {
                        this.dspArgumentRegister = n - 176;
                        this.dspCommandState = 13;
                        break;
                    }
                    case 16: {
                        this.dspCommandState = 1;
                        break;
                    }
                    case 72: {
                        this.dspCommandState = 8;
                        break;
                    }
                    case 64: {
                        this.dspCommandState = 10;
                        break;
                    }
                    case 65: 
                    case 66: {
                        this.dspCommandState = 6;
                        break;
                    }
                    case 209: {
                        this.speakerConnected = true;
                        this.recomputeVolume(this.clock.getTime());
                        break;
                    }
                    case 211: {
                        this.speakerConnected = false;
                        this.recomputeVolume(this.clock.getTime());
                        break;
                    }
                    case 216: {
                        if (this.speakerConnected) {
                            this.dspOutputPut(255);
                            break;
                        }
                        this.dspOutputPut(0);
                        break;
                    }
                    case 208: 
                    case 213: {
                        this.dmaEnginePauseTransfer();
                        break;
                    }
                    case 69: 
                    case 71: 
                    case 212: 
                    case 214: {
                        this.dmaEngineContinueTransfer();
                        break;
                    }
                    case 128: {
                        this.dspCommandState = 2;
                        this.dspArgumentRegister = 0;
                        break;
                    }
                    case 217: 
                    case 218: {
                        this.dmaEngineEndTransfer();
                        break;
                    }
                    case 224: {
                        this.dspCommandState = 5;
                        break;
                    }
                    case 225: {
                        this.dspOutputUsed = 0;
                        this.dspOutputPut(4);
                        this.dspOutputPut(4);
                        break;
                    }
                    case 226: {
                        this.dspCommandState = 16;
                        break;
                    }
                    case 227: {
                        this.dspOutputUsed = 0;
                        for (int i = 0; i < copyright.length(); ++i) {
                            this.dspOutputPut(copyright.charAt(i));
                        }
                        break block66;
                    }
                    case 228: {
                        this.dspCommandState = 4;
                        break;
                    }
                    case 232: {
                        this.dspOutputUsed = 0;
                        this.dspOutputPut(this.dspLastCommand);
                        break;
                    }
                    case 242: {
                        this.set8BitIRQ(true);
                        break;
                    }
                    case 248: {
                        this.dspOutputUsed = 0;
                        this.dspOutputPut(0);
                        break;
                    }
                    default: {
                        this.writeMessage("SBDSP: Received unknown command " + n + ".");
                        break;
                    }
                }
                break block66;
            }
            if (this.dspCommandState == 1) {
                this.writeMessage("SBDSP: Setting direct output to " + n + ".");
                this.sendPCMSample(this.clock.getTime(), (short)(256 * n - 32768), (short)(256 * n - 32768));
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 2) {
                this.dspArgumentRegister = n;
                this.dspCommandState = 3;
            } else if (this.dspCommandState == 3) {
                this.dspArgumentRegister |= n << 8;
                this.dmaEnginePauseTransfer(this.dspArgumentRegister + 1);
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 4) {
                this.writeMessage("SBDSP: Writing test register: data=" + n + ".");
                this.dspLastCommand = n;
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 5) {
                this.dspOutputUsed = 0;
                this.writeMessage("SBDSP: Doing ID write: data=" + n + ".");
                this.dspOutputPut(~n);
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 8) {
                this.dspArgumentRegister = n;
                this.dspCommandState = 9;
            } else if (this.dspCommandState == 9) {
                this.dspArgumentRegister |= n << 8;
                this.writeMessage("SBDSP: Setting block size to " + (this.dspArgumentRegister + 1) + " samples.");
                this.origSamplesLeft = this.dspArgumentRegister + 1;
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 6) {
                this.dspArgumentRegister = n << 8;
                this.dspCommandState = 7;
            } else if (this.dspCommandState == 7) {
                this.dspArgumentRegister |= n;
                this.writeMessage("SBDSP: Setting rate to " + this.dspArgumentRegister + "Hz.");
                this.interSampleTime = 1000000000 / this.dspArgumentRegister;
                this.istStereoAdjust = false;
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 10) {
                this.writeMessage("SBDSP: Setting time constant to " + n + "(" + 1000000 / (256 - n) + "Hz mono/" + 500000 / (256 - n) + "Hz stereo).");
                this.interSampleTime = 1000 * (256 - n);
                this.istStereoAdjust = true;
                this.dspCommandState = 0;
            } else if (this.dspCommandState == 11) {
                this.dspArgumentRegister = this.dspArgumentRegister << 8 | n;
                this.dspCommandState = 12;
            } else if (this.dspCommandState == 13) {
                this.dspArgumentRegister = this.dspArgumentRegister << 8 | n;
                this.dspCommandState = 14;
            } else if (this.dspCommandState == 14) {
                this.dspArgumentRegister = this.dspArgumentRegister << 8 | n;
                this.dspCommandState = 15;
            } else if (this.dspCommandState == 12) {
                this.dspArgumentRegister = this.dspArgumentRegister << 8 | n;
                this.dspCommandState = 0;
                this.dspNextDMA = this.dspArgumentRegister;
            } else if (this.dspCommandState == 15) {
                this.dspArgumentRegister = this.dspArgumentRegister << 8 | n;
                this.dspCommandState = 0;
                this.dspArgumentRegister |= 0x20000000;
                this.dspNextDMA = this.dspArgumentRegister;
            } else if (this.dspCommandState == 16) {
                for (int i = 0; i < 8; ++i) {
                    if ((n >>> i & 1) == 0) continue;
                    this.e2Value = (E2_MAGIC[this.e2Count % 4] >>> i & 1) != 0 ? (byte)(this.e2Value - (byte)(1 << i)) : (byte)(this.e2Value + (byte)(1 << i));
                }
                this.e2Value = (byte)(this.e2Value + E2_MAGIC[this.e2Count % 4]);
                this.writeMessage("Sending DMA identification " + this.e2Value + ".");
                ++this.e2Count;
                this.e2Mode = true;
                this.dmaEngineUpdateDMADREQ();
                this.dspCommandState = 0;
            }
        }
        if (this.dmaState == 0 || this.dmaPaused && this.dmaPauseLeft < 0) {
            this.dspProgramNextDMA();
        }
    }

    private final void dspProgramNextDMA() {
        boolean bl;
        boolean bl2 = bl = (this.mixerRegisters[24] & 2) != 0;
        if (this.dspNextDMA == -1) {
            return;
        }
        int n = 1 + ((this.dspNextDMA & 0xFF) << 8 | this.dspNextDMA >> 8 & 0xFF);
        this.dspNextDMA >>>= 16;
        if (this.dspNextDMA < 8192) {
            switch (this.dspNextDMA) {
                case 0: {
                    this.dmaEngineStartTransfer(1, n, 7, bl);
                    break;
                }
                case 1: {
                    this.dmaEngineStartTransfer(2, n, 7, bl);
                    break;
                }
                case 2: {
                    this.dmaEngineStartTransfer(1, n, 0, false);
                    break;
                }
                case 3: {
                    this.dmaEngineStartTransfer(1, n, 3, false);
                    break;
                }
                case 4: {
                    this.dmaEngineStartTransfer(1, n, 1, false);
                    break;
                }
                case 5: {
                    this.dmaEngineStartTransfer(1, n, 4, false);
                    break;
                }
                case 6: {
                    this.dmaEngineStartTransfer(1, n, 2, false);
                    break;
                }
                case 7: {
                    this.dmaEngineStartTransfer(1, n, 5, false);
                    break;
                }
                default: {
                    this.writeMessage("Trying to program unknown DMA mode " + this.dspNextDMA + ".");
                    break;
                }
            }
        } else if ((this.dspNextDMA & 0x2000) != 0) {
            int n2;
            boolean bl3 = (this.dspNextDMA & 0x1000) == 0;
            boolean bl4 = (this.dspNextDMA & 0x400) != 0;
            boolean bl5 = (this.dspNextDMA & 0x10) != 0;
            boolean bl6 = (this.dspNextDMA & 0x20) != 0;
            int n3 = n2 = bl4 ? 2 : 1;
            if (bl3) {
                if (bl5) {
                    this.dmaEngineStartTransfer(n2, n, 8, bl6);
                } else {
                    this.dmaEngineStartTransfer(n2, n, 9, bl6);
                }
            } else if (bl5) {
                this.dmaEngineStartTransfer(n2, n, 6, bl6);
            } else {
                this.dmaEngineStartTransfer(n2, n, 7, bl6);
            }
        } else {
            this.writeMessage("Trying to program unknown DMA mode " + this.dspNextDMA + ".");
        }
        this.dspNextDMA = -1;
    }

    private final void dmaEngineADPCMDecode(int n) {
        byte by = 0;
        byte[] byArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.soundFormat == 0) {
            by = 5;
            byArray = ADPCM_2BIT_LEVEL_SHIFT;
            nArray = ADPCM_2BIT_LEVEL_MULT;
            nArray2 = ADPCM_2BIT_SAMPLE_MULT;
        } else if (this.soundFormat == 1) {
            by = 4;
            byArray = ADPCM_26BIT_LEVEL_SHIFT;
            nArray = ADPCM_26BIT_LEVEL_MULT;
            nArray2 = ADPCM_26BIT_SAMPLE_MULT;
        } else if (this.soundFormat == 2) {
            by = 3;
            byArray = ADPCM_4BIT_LEVEL_SHIFT;
            nArray = ADPCM_4BIT_LEVEL_MULT;
            nArray2 = ADPCM_4BIT_SAMPLE_MULT;
        }
        byte by2 = this.adpcmScale;
        if (by2 > by) {
            this.writeMessage("Error: SB: ADPCM level out of range.", true);
            by2 = by;
        }
        byte by3 = byArray[n];
        if (by2 == 0 && by3 < 0 || by2 == by && by3 > 0) {
            by3 = 0;
        }
        this.adpcmScale = (byte)(this.adpcmScale + by3);
        this.adpcmReference += nArray[by2] * nArray2[n] / (by2 == 0 ? 2 : 1);
        if (this.adpcmReference < 0) {
            this.adpcmReference = 0;
        }
        if (this.adpcmReference > 255) {
            this.adpcmReference = 255;
        }
    }

    static {
        E2_MAGIC = new byte[]{-106, -91, 105, 90};
        ADPCM_4BIT_LEVEL_SHIFT = new byte[]{-1, 0, 0, 0, 0, 1, 1, 1, -1, 0, 0, 0, 0, 1, 1, 1};
        ADPCM_26BIT_LEVEL_SHIFT = new byte[]{-1, 0, 0, 1, -1, 0, 0, 1};
        ADPCM_2BIT_LEVEL_SHIFT = new byte[]{-1, 1, -1, 1};
        ADPCM_4BIT_LEVEL_MULT = new int[]{1, 1, 2, 4};
        ADPCM_26BIT_LEVEL_MULT = new int[]{1, 1, 2, 4, 5};
        ADPCM_2BIT_LEVEL_MULT = new int[]{1, 1, 2, 4, 8, 16};
        ADPCM_4BIT_SAMPLE_MULT = new int[]{1, 3, 5, 7, 9, 11, 13, 15, -1, -3, -5, -7, -9, -11, -13, -15};
        ADPCM_26BIT_SAMPLE_MULT = new int[]{1, 3, 5, 7, -1, -3, -5, -7};
        ADPCM_2BIT_SAMPLE_MULT = new int[]{1, 3, -1, -3};
    }
}

