/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.modulesaux;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.output.OutputChannelFM;

public class FMChip
implements SRDumpable {
    private long timer1ExpiresAt;
    private long timer2ExpiresAt;
    private boolean timer1Masked;
    private boolean timer2Masked;
    private boolean timer1Expired;
    private boolean timer2Expired;
    private boolean timer1Enabled;
    private boolean timer2Enabled;
    private int reg2Value;
    private int reg3Value;
    private OutputChannelFM output;
    private static final int REG1_WAVEFORM_SELECT = 32;
    private static final int REG4_IRQ_RESET = 128;
    private static final int REG4_TIMER1_MASK = 64;
    private static final int REG4_TIMER2_MASK = 32;
    private static final int REG4_TIMER2_CONTROL = 2;
    private static final int REG4_TIMER1_CONTROL = 1;

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": FMChip:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public int status(long l) {
        int n = 0;
        if (this.timer1Expired) {
            n |= 0xC0;
        }
        if (this.timer2Expired) {
            n |= 0xA0;
        }
        return n;
    }

    public void setOutput(OutputChannelFM outputChannelFM) {
        this.output = outputChannelFM;
    }

    public long nextAttention(long l) {
        long l2 = Long.MAX_VALUE;
        if (this.timer1ExpiresAt < l2) {
            l2 = this.timer1ExpiresAt;
        }
        if (this.timer2ExpiresAt < l2) {
            l2 = this.timer2ExpiresAt;
        }
        return l2;
    }

    public void attention(long l) {
        if (this.timer1ExpiresAt <= l) {
            this.timer1ExpiresAt = Long.MAX_VALUE;
            if (!this.timer1Masked) {
                this.timer1Expired = true;
            }
        }
        if (this.timer2ExpiresAt <= l) {
            this.timer2ExpiresAt = Long.MAX_VALUE;
            if (!this.timer2Masked) {
                this.timer2Expired = true;
            }
        }
    }

    private final void computeExpirations(long l, int n) {
        long l2;
        long l3;
        if ((n & 1) != 0) {
            l3 = l / 80000L;
            l2 = l3 + (long)(256 - this.reg2Value);
            if ((n & 4) == 0 || this.timer1Enabled) {
                this.timer1ExpiresAt = l2 * 80000L;
                this.timer1Enabled = true;
            } else {
                this.timer1ExpiresAt = Long.MAX_VALUE;
            }
        }
        if ((n & 2) != 0) {
            l3 = l / 320000L;
            l2 = l3 + (long)(256 - this.reg3Value);
            if ((n & 4) == 0 || this.timer2Enabled) {
                this.timer2ExpiresAt = l2 * 320000L;
                this.timer2Enabled = true;
            } else {
                this.timer2ExpiresAt = Long.MAX_VALUE;
            }
        }
    }

    public void write(long l, int n, int n2) {
        int n3 = n;
        if (n == 2) {
            this.reg2Value = n2;
        } else if (n == 3) {
            this.reg3Value = n2;
        } else if (n == 4) {
            if ((n2 & 0x80) != 0) {
                this.timer1Expired = false;
                this.timer2Expired = false;
                this.computeExpirations(l, 7);
                return;
            }
            if ((n2 & 0x40) != 0) {
                this.timer1Masked = true;
                this.timer1Expired = false;
            } else {
                this.timer1Masked = false;
            }
            if ((n2 & 0x20) != 0) {
                this.timer2Masked = true;
                this.timer2Expired = false;
            } else {
                this.timer2Masked = false;
            }
            if ((n2 & 1) != 0) {
                this.computeExpirations(l, 1);
            } else {
                this.timer1Enabled = false;
                this.timer1ExpiresAt = Long.MAX_VALUE;
            }
            if ((n2 & 2) != 0) {
                this.computeExpirations(l, 2);
            } else {
                this.timer2Enabled = false;
                this.timer2ExpiresAt = Long.MAX_VALUE;
            }
        } else {
            this.output.addFrameWrite(l, (short)n, (byte)n2);
        }
    }

    public void resetCard(long l) {
        this.timer1Expired = false;
        this.timer2Expired = false;
        this.timer1Enabled = false;
        this.timer2Enabled = false;
        this.timer1Masked = false;
        this.timer2Masked = false;
        this.timer1ExpiresAt = Long.MAX_VALUE;
        this.timer2ExpiresAt = Long.MAX_VALUE;
        this.reg2Value = 0;
        this.reg3Value = 0;
        if (this.output != null) {
            this.output.addFrameReset(l);
        }
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpBoolean(this.timer1Enabled);
        sRDumper.dumpBoolean(this.timer2Enabled);
        sRDumper.dumpBoolean(this.timer1Expired);
        sRDumper.dumpBoolean(this.timer2Expired);
        sRDumper.dumpBoolean(this.timer1Masked);
        sRDumper.dumpBoolean(this.timer2Masked);
        sRDumper.dumpLong(this.timer1ExpiresAt);
        sRDumper.dumpLong(this.timer2ExpiresAt);
        sRDumper.dumpInt(this.reg2Value);
        sRDumper.dumpInt(this.reg3Value);
        sRDumper.dumpObject(this.output);
    }

    public FMChip(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.timer1Enabled = sRLoader.loadBoolean();
        this.timer2Enabled = sRLoader.loadBoolean();
        this.timer1Expired = sRLoader.loadBoolean();
        this.timer2Expired = sRLoader.loadBoolean();
        this.timer1Masked = sRLoader.loadBoolean();
        this.timer2Masked = sRLoader.loadBoolean();
        this.timer1ExpiresAt = sRLoader.loadLong();
        this.timer2ExpiresAt = sRLoader.loadLong();
        this.reg2Value = sRLoader.loadInt();
        this.reg3Value = sRLoader.loadInt();
        this.output = (OutputChannelFM)sRLoader.loadObject();
    }

    public FMChip() {
        this.resetCard(0L);
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tTimer1Enabled " + this.timer1Enabled);
        statusDumper.println("\tTimer2Enabled " + this.timer2Enabled);
        statusDumper.println("\tTimer1Expired " + this.timer1Expired);
        statusDumper.println("\tTimer2Expired " + this.timer2Expired);
        statusDumper.println("\tTimer1Masked " + this.timer1Masked);
        statusDumper.println("\tTimer2Masked " + this.timer2Masked);
        statusDumper.println("\tTimer1ExpiresAt " + this.timer1ExpiresAt);
        statusDumper.println("\tTimer2ExpiresAt " + this.timer2ExpiresAt);
        statusDumper.println("\tReg2Value " + this.reg2Value);
        statusDumper.println("\tReg3Value " + this.reg3Value);
        statusDumper.println("\toutput <object #" + statusDumper.objectNumber(this.output) + ">");
        if (this.output != null) {
            this.output.dumpStatus(statusDumper);
        }
    }
}

