/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.output;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.output.Output;
import org.jpc.output.OutputFrame;

public class OutputChannel
implements SRDumpable {
    private short type;
    private String name;
    private short chan;
    private Output out;

    public OutputChannel(Output output, short s, String string) {
        this.type = s;
        this.name = string;
        this.chan = (short)-1;
        this.out = output;
        this.out.newChannel(this);
    }

    protected void setChan(short s) {
        this.chan = s;
    }

    protected short getChan() {
        return this.chan;
    }

    protected String getName() {
        return this.name;
    }

    protected short getType() {
        return this.type;
    }

    public void addFrame(OutputFrame outputFrame, boolean bl) {
        this.out.addFrame(this, outputFrame, bl);
    }

    public byte[] channelHeader() {
        ByteBuffer byteBuffer = null;
        byte[] byArray = null;
        try {
            byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(this.name));
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        }
        catch (Exception exception) {
            byArray = new byte[]{51};
        }
        int n = 6 + byArray.length;
        byte[] byArray2 = new byte[n];
        byArray2[0] = (byte)(this.chan >> 8 & 0xFF);
        byArray2[1] = (byte)(this.chan & 0xFF);
        byArray2[2] = (byte)(this.type >> 8 & 0xFF);
        byArray2[3] = (byte)(this.type & 0xFF);
        byArray2[4] = (byte)(byArray.length >> 8 & 0xFF);
        byArray2[5] = (byte)(byArray.length & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 6, byArray.length);
        return byArray2;
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpShort(this.type);
        sRDumper.dumpShort(this.chan);
        sRDumper.dumpString(this.name);
        sRDumper.dumpObject(this.out);
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\ttype " + this.type + " chan " + this.chan);
        statusDumper.println("\tname " + this.name);
        statusDumper.println("\tout <object #" + statusDumper.objectNumber(this.out) + ">");
        if (this.out != null) {
            this.out.dumpStatus(statusDumper);
        }
    }

    public OutputChannel(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.type = sRLoader.loadShort();
        this.chan = sRLoader.loadShort();
        this.name = sRLoader.loadString();
        this.out = (Output)sRLoader.loadObject();
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": OutputChannel:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }
}

