/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jpc.output.OutputChannel;
import org.jpc.output.OutputClient;
import org.jpc.output.OutputFrame;
import org.jpc.output.OutputFrameRaw;

public class OutputStatic {
    long timeBase = 0L;
    long lastTime = 0L;
    LinkedList<OutputPair> frames = new LinkedList();
    Map<Short, OutputChannel> activeChannelTable;
    volatile int clientsNew;
    volatile int clientsAquiring;
    volatile int clientsAquired;
    volatile int clientsReleasing;
    volatile int clientsReleased;
    volatile boolean waiting;
    Set<OutputClient> clients = new HashSet<OutputClient>();

    public long getLastTime() {
        return this.lastTime;
    }

    public byte[] makeChannelTable() {
        return this.makeChannelTable(this.activeChannelTable);
    }

    public byte[] makeChannelTable(Map<Short, OutputChannel> map) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        byte[] byArray = new byte[]{-1, -1, 74, 80, 67, 82, 82, 77, 85, 76, 84, 73, 68, 85, 77, 80, (byte)(map.size() >>> 8 & 0xFF), (byte)(map.size() & 0xFF)};
        linkedList.add(byArray);
        for (Map.Entry<Short, OutputChannel> object22 : map.entrySet()) {
            linkedList.add(object22.getValue().channelHeader());
        }
        int n = 0;
        for (byte[] byArray2 : linkedList) {
            n += byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        n = 0;
        for (byte[] byArray4 : linkedList) {
            System.arraycopy(byArray4, 0, byArray3, n, byArray4.length);
            n += byArray4.length;
        }
        return byArray3;
    }

    public void updateChannelTable(Map<Short, OutputChannel> map) {
        byte[] byArray = this.makeChannelTable(map);
        this.addFrame((short)-1, new OutputFrameRaw(byArray), false);
        this.activeChannelTable = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(short s, OutputFrame outputFrame, boolean bl) {
        OutputStatic outputStatic = this;
        synchronized (outputStatic) {
            this.lastTime = outputFrame.getTime();
            this.frames.add(new OutputPair(s, outputFrame));
        }
        if (bl) {
            this.waitReaders();
            if (this.frames.size() > 0) {
                this.timeBase = this.frames.getLast().frame.getTime();
            }
            this.frames.clear();
        }
    }

    public synchronized OutputFrame lastFrame(Class<? extends OutputFrame> clazz) {
        OutputFrame outputFrame = null;
        for (OutputPair outputPair : this.frames) {
            if (clazz != null && !clazz.isAssignableFrom(outputPair.frame.getClass())) continue;
            outputFrame = outputPair.frame;
        }
        return outputFrame;
    }

    public synchronized long writeFrames(OutputStream outputStream, FrameFilter frameFilter) throws IOException {
        long l = this.timeBase;
        for (OutputPair outputPair : this.frames) {
            long l2 = outputPair.frame.getTime();
            OutputFrame outputFrame = null;
            outputFrame = frameFilter != null ? frameFilter.doFilter(outputPair.frame, outputPair.channel) : outputPair.frame;
            if (outputFrame == null) continue;
            outputStream.write(outputFrame.dump(outputPair.channel, l));
            if (l2 < l) continue;
            l = l2;
        }
        return l;
    }

    private void setClientState(OutputClient outputClient, int n) {
        if (outputClient.getState() != -1) {
            if (outputClient.getState() == 0) {
                --this.clientsNew;
            } else if (outputClient.getState() == 1) {
                --this.clientsAquiring;
            } else if (outputClient.getState() == 2) {
                --this.clientsAquired;
            } else if (outputClient.getState() == 3) {
                --this.clientsReleasing;
            } else if (outputClient.getState() == 4) {
                --this.clientsReleased;
            } else {
                throw new IllegalStateException("Client in illegal state #" + outputClient.getState());
            }
        }
        if (n != -1) {
            if (n == 0) {
                ++this.clientsNew;
            } else if (n == 1) {
                ++this.clientsAquiring;
            } else if (n == 2) {
                ++this.clientsAquired;
            } else if (n == 3) {
                ++this.clientsReleasing;
            } else if (n == 4) {
                ++this.clientsReleased;
            } else {
                throw new IllegalStateException("Trying to set illegal state #" + n);
            }
        }
        outputClient.setState(n);
        this.notifyAll();
    }

    private synchronized void waitReaders() {
        for (OutputClient outputClient : this.clients) {
            if (outputClient.getState() != 4) continue;
            this.setClientState(outputClient, 0);
        }
        this.waiting = true;
        this.notifyAll();
        while (this.clientsNew > 0 || this.clientsAquiring > 0 || this.clientsAquired > 0 || this.clientsReleasing > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.waiting = false;
    }

    protected synchronized void clientNew(OutputClient outputClient) {
        if (this.clients.add(outputClient)) {
            outputClient.setState(-1);
            this.setClientState(outputClient, 0);
        }
    }

    protected synchronized void clientDestroy(OutputClient outputClient) {
        if (this.clients.remove(outputClient)) {
            this.setClientState(outputClient, -1);
        }
    }

    protected synchronized boolean clientAquire(OutputClient outputClient) {
        int n = outputClient.getState();
        if (n != 0 && n != 4) {
            throw new IllegalStateException("Trying to lock already locked lock (state=" + n + ")");
        }
        while (outputClient.getState() == 4) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (outputClient.getState() == 0 && this.waiting) {
                    this.setClientState(outputClient, 2);
                    return true;
                }
                return false;
            }
        }
        if (this.waiting) {
            this.setClientState(outputClient, 2);
            return true;
        }
        this.setClientState(outputClient, 1);
        while (!this.waiting) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (outputClient.getState() == 1) {
            this.setClientState(outputClient, this.waiting ? 2 : 0);
        }
        return this.waiting;
    }

    protected synchronized void clientRelease(OutputClient outputClient, boolean bl) {
        int n = outputClient.getState();
        if (n != 2) {
            throw new IllegalStateException("Trying to unlock already unlocked lock");
        }
        if (bl) {
            this.setClientState(outputClient, 3);
            while (this.clientsNew > 0 || this.clientsAquiring > 0 || this.clientsAquired > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.setClientState(outputClient, 4);
    }

    public static interface FrameFilter {
        public OutputFrame doFilter(OutputFrame var1, short var2);
    }

    public class OutputPair {
        public short channel;
        public OutputFrame frame;

        public OutputPair(short s, OutputFrame outputFrame) {
            this.channel = s;
            this.frame = outputFrame;
        }
    }
}

