/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import mnj.lua.BaseLib;
import mnj.lua.Lua;
import mnj.lua.LuaError;
import mnj.lua.LuaJavaCallback;
import mnj.lua.LuaTable;
import mnj.lua.LuaUserdata;
import mnj.lua.MathLib;
import mnj.lua.StringLib;
import mnj.lua.TableLib;
import org.jpc.Misc;
import org.jpc.emulator.DisplayController;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.PC;
import org.jpc.output.OutputClient;
import org.jpc.output.OutputStatic;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class LuaPlugin
implements ActionListener,
Plugin {
    private JFrame window;
    private JPanel panel;
    private Plugins vPluginManager;
    private String kernelName;
    private Map<String, String> kernelArguments;
    private Map<String, String> userArguments;
    private int nativeWidth;
    private int nativeHeight;
    private JLabel execLabel;
    private JTextField execName;
    private JButton execButton;
    private JButton termButton;
    private JButton clearButton;
    private JTextArea console;
    private int nextHandle;
    private Thread luaThread;
    private Lua luaState;
    private volatile boolean pcRunning;
    private volatile boolean inCall;
    private volatile String luaInvokeReq;
    private volatile boolean luaTerminateReq;
    private volatile boolean luaTerminateReqAsync;
    private OutputClient screenOut;
    private OutputStatic outputConnector;
    private PC pc;
    private volatile boolean ownsVGALock;
    private volatile boolean signalComplete;
    private volatile boolean luaStarted;
    private volatile boolean mainThreadWait;
    private volatile boolean reconnectInProgress;
    private VGARetraceWaiter vgaPoller;
    private boolean consoleMode;
    private boolean specialNoGUIMode;
    private Map<String, LuaResource> resources;
    private IdentityHashMap<LuaResource, Integer> liveObjects;
    private Queue<Event> eventQueue;

    private String getMethodHandle(Lua lua) {
        if (lua.type(1) == -1) {
            lua.error("Handle required for method call");
            return null;
        }
        lua.checkType(1, 7);
        Object object = lua.toUserdata(lua.value(1)).getUserdata();
        if (!(object instanceof String)) {
            if (object != null) {
                lua.error("Invalid handle to resource: " + object.getClass().getName());
            } else {
                lua.error("Invalid handle to resource: Null");
            }
            return null;
        }
        return (String)object;
    }

    public void destroyLuaObject(Lua lua) throws IOException {
        String string = this.getMethodHandle(lua);
        LuaResource luaResource = this.resources.get(string);
        if (luaResource == null) {
            lua.error("Bad or closed handle passed to method");
        }
        luaResource.release(false);
    }

    @Override
    public boolean systemShutdown() {
        return true;
    }

    private void reconnectBody(PC pC) {
        this.reconnectInProgress = false;
        if (this.ownsVGALock) {
            this.screenOut.release();
            this.ownsVGALock = false;
        }
        if (this.screenOut != null) {
            this.screenOut.detach();
            this.screenOut = null;
        }
        this.pc = pC;
        if (this.luaThread != null) {
            this.screenOut = new OutputClient(this.outputConnector);
            this.vgaPoller.reactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect(PC pC) {
        this.vgaPoller.deactivate();
        if (this.inCall) {
            this.reconnectBody(pC);
        } else {
            this.reconnectInProgress = true;
            if (this.luaThread != null) {
                this.luaThread.interrupt();
            }
            LuaPlugin luaPlugin = this;
            synchronized (luaPlugin) {
                this.reconnectBody(pC);
            }
        }
        this.queueEvent("attach", null);
    }

    @Override
    public void pcStarting() {
        this.pcRunning = true;
    }

    @Override
    public void pcStopping() {
        this.pcRunning = false;
        this.queueEvent("stop", null);
    }

    public void tableAddFunctions(Lua lua, LuaTable luaTable, Object object, Class<?> clazz) {
        Method[] methodArray;
        if (object != null) {
            clazz = object.getClass();
        }
        for (Method method : methodArray = clazz.getMethods()) {
            if (object != null && Modifier.isStatic(method.getModifiers()) || object == null && !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("luaCB_")) continue;
            String string = method.getName().substring(6);
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = method.getReturnType();
            if (clazz2 != Integer.TYPE) {
                System.err.println("Warning: Incorrect return type for " + method.getName() + ": " + clazz2.getName() + ".");
                continue;
            }
            if (classArray == null || classArray.length != 2) {
                System.err.println("Warning: Incorrect parameter type for " + method.getName() + ".");
                continue;
            }
            if (classArray[0] != Lua.class || classArray[1] != LuaPlugin.class) {
                System.err.println("Warning: Incorrect parameter type for " + method.getName() + ".");
                continue;
            }
            lua.setTable(luaTable, string, new LuaCallback(object, method));
        }
    }

    public LuaUserdata generateLuaClass(Lua lua, LuaResource luaResource) {
        LuaUserdata luaUserdata = new LuaUserdata(luaResource.getHandle());
        LuaTable luaTable = lua.newTable();
        this.tableAddFunctions(lua, luaTable, luaResource, null);
        this.liveObjects.put(luaResource, null);
        lua.setTable(luaTable, "__index", luaTable);
        lua.setMetatable(luaUserdata, luaTable);
        lua.push(luaUserdata);
        return luaUserdata;
    }

    private void cleanupLuaResources() {
        this.vgaPoller.deactivate();
        if (this.ownsVGALock) {
            this.screenOut.release();
            this.ownsVGALock = false;
        }
        if (this.screenOut != null) {
            this.screenOut.detach();
            this.screenOut = null;
        }
        while (this.resources.size() > 0) {
            Map.Entry<String, LuaResource> entry = this.resources.entrySet().iterator().next();
            String string = entry.getKey();
            LuaResource luaResource = entry.getValue();
            try {
                luaResource.release(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resources.remove(string);
            this.liveObjects.remove(luaResource);
        }
        this.resources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main() {
        while (true) {
            LuaPlugin luaPlugin;
            try {
                luaPlugin = this;
                synchronized (luaPlugin) {
                    this.mainThreadWait = true;
                    this.notifyAll();
                    if (this.luaInvokeReq == null && !this.luaTerminateReq) {
                        this.wait();
                    }
                    this.mainThreadWait = false;
                }
            }
            catch (Exception exception) {
                continue;
            }
            if (this.luaInvokeReq != null && this.luaThread == null) {
                this.eventQueue = new LinkedList<Event>();
                if (this.screenOut == null) {
                    this.screenOut = new OutputClient(this.outputConnector);
                    this.vgaPoller.reactivate();
                }
                this.luaStarted = false;
                this.luaState = new Lua();
                this.luaThread = new Thread((Runnable)new LuaThread(this.luaState, this.luaInvokeReq), "Lua execution thread");
                this.luaThread.start();
                luaPlugin = this;
                synchronized (luaPlugin) {
                    this.luaInvokeReq = null;
                    this.signalComplete = true;
                    this.luaStarted = true;
                    this.notifyAll();
                }
            }
            if (this.luaInvokeReq != null) {
                System.err.println("Error: Lua invoke request with Lua running!");
                this.luaInvokeReq = null;
                continue;
            }
            if (this.luaTerminateReq && this.luaThread != null) {
                this.luaThread.interrupt();
                luaPlugin = this;
                synchronized (luaPlugin) {
                    this.luaThread.stop();
                    this.cleanupLuaResources();
                    this.luaState = null;
                    this.luaThread = null;
                    this.luaTerminateReq = false;
                    this.signalComplete = true;
                    this.notifyAll();
                    if (this.luaTerminateReqAsync) {
                        this.setLuaButtons();
                    }
                }
                this.printConsoleMsg("Lua VM: Lua VM terminated.\n");
                this.cleanupLuaResources();
                continue;
            }
            if (this.luaTerminateReq) {
                System.err.println("Error: Lua terminate request with Lua not running!");
                this.luaTerminateReq = false;
                this.setLuaButtons();
                continue;
            }
            this.setLuaButtons();
        }
    }

    public void printConsoleMsg(String string) {
        final String string2 = string;
        if (this.consoleMode || this.specialNoGUIMode) {
            System.out.print(string);
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        LuaPlugin.this.console.setText(LuaPlugin.this.console.getText() + string2);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.console.setText(this.console.getText() + string);
        }
    }

    private synchronized void invokeLuaVM(String string) throws Exception {
        if (this.luaThread != null) {
            return;
        }
        int n = string.indexOf(40);
        if (n < 0) {
            this.userArguments = new HashMap<String, String>();
        } else {
            String string2 = string.substring(n + 1);
            int n2 = string2.lastIndexOf(41);
            if (n2 != string2.length() - 1) {
                throw new Exception("Bad argument syntax");
            }
            string2 = string2.substring(0, n2);
            this.userArguments = Misc.parseStringToComponents(string2);
        }
        this.signalComplete = false;
        this.luaInvokeReq = n < 0 ? string : string.substring(0, n);
        this.luaTerminateReq = false;
        this.notifyAll();
        while (!this.signalComplete) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.setLuaButtons();
    }

    private synchronized void terminateLuaVM() {
        this.notifyAll();
        if (this.luaThread == null) {
            return;
        }
        this.signalComplete = false;
        this.luaTerminateReq = true;
        this.luaTerminateReqAsync = false;
        this.notifyAll();
        while (this.luaThread != null) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.setLuaButtons();
    }

    private synchronized void terminateLuaVMAsync() {
        if (this.luaThread == null) {
            return;
        }
        this.signalComplete = false;
        this.luaTerminateReq = true;
        this.luaTerminateReqAsync = true;
        this.notifyAll();
    }

    private void setLuaButtons() {
        if (this.consoleMode || this.specialNoGUIMode) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        LuaPlugin.this.execButton.setText(LuaPlugin.this.luaThread == null ? "Run" : "Send");
                        LuaPlugin.this.termButton.setEnabled(LuaPlugin.this.luaThread != null);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.execButton.setText(this.luaThread == null ? "Run" : "Send");
            this.termButton.setEnabled(this.luaThread != null);
        }
    }

    private void clearConsole() {
        if (this.consoleMode || this.specialNoGUIMode) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        LuaPlugin.this.console.setText("");
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.console.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            if (actionEvent.getSource() == this.execButton) {
                try {
                    if (this.luaThread == null) {
                        this.invokeLuaVM(this.execName.getText());
                        break block9;
                    }
                    this.postMessage(this.execName.getText());
                }
                catch (Exception exception) {
                    this.printConsoleMsg("Lua script starting / message send error: " + exception.getMessage());
                }
            } else if (actionEvent.getSource() == this.termButton) {
                this.luaTerminateReq = true;
                if (this.luaThread != null) {
                    this.luaThread.interrupt();
                }
                this.terminateLuaVM();
            } else if (actionEvent.getSource() == this.clearButton) {
                this.clearConsole();
            }
        }
    }

    public void eci_luaplugin_sendmessage(String string) {
        if (this.luaThread != null && string != null) {
            this.postMessage(string);
        }
    }

    public void eci_luaplugin_setwinpos(Integer n, Integer n2) {
        Misc.moveWindow(this.window, n, n2, this.nativeWidth, this.nativeHeight);
    }

    public void eci_luaplugin_run(String string) {
        if (this.luaThread == null) {
            try {
                this.invokeLuaVM(string);
            }
            catch (Exception exception) {
                this.printConsoleMsg("Lua script starting error: " + exception.getMessage());
            }
        }
    }

    public void eci_luaplugin_terminate() {
        this.luaTerminateReq = true;
        if (this.luaThread != null) {
            this.luaThread.interrupt();
        }
        this.terminateLuaVMAsync();
    }

    public void eci_luaplugin_clearconsole() {
        this.clearConsole();
    }

    private void invokeCommand(String string, String[] stringArray) {
        if ("luaplugin-terminate".equals(string) && stringArray == null && this.luaThread != null) {
            this.luaTerminateReq = true;
            if (this.luaThread != null) {
                this.luaThread.interrupt();
            }
            this.terminateLuaVMAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callInvokeCommand(String string, String[] stringArray, boolean bl) {
        try {
            this.inCall = true;
            if (this.consoleMode) {
                this.invokeCommand(string, stringArray);
            } else if (bl) {
                this.vPluginManager.invokeExternalCommandSynchronous(string, stringArray);
            } else {
                this.vPluginManager.invokeExternalCommand(string, stringArray);
            }
        }
        finally {
            this.inCall = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callCommand(String string, String[] stringArray) {
        try {
            this.inCall = true;
            if (this.consoleMode) {
                this.invokeCommand(string, stringArray);
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] objectArray = this.vPluginManager.invokeExternalCommandReturn(string, stringArray);
            return objectArray;
        }
        finally {
            this.inCall = false;
        }
    }

    public HardwareComponent getComponent(Class<?> clazz) {
        if (this.pc == null) {
            return null;
        }
        return this.pc.getComponent(clazz);
    }

    public void postMessage(String string) {
        this.queueEvent("message", string);
    }

    public void doReleaseVGA() {
        if (this.screenOut != null && this.ownsVGALock) {
            this.screenOut.release();
        }
        this.ownsVGALock = false;
        this.vgaPoller.reactivate();
    }

    public boolean getOwnsVGALock() {
        return this.ownsVGALock;
    }

    public int getXResolution() {
        DisplayController displayController = (DisplayController)((Object)this.getComponent(DisplayController.class));
        if (displayController != null) {
            return displayController.getWidth();
        }
        return -1;
    }

    public int getYResolution() {
        DisplayController displayController = (DisplayController)((Object)this.getComponent(DisplayController.class));
        if (displayController != null) {
            return displayController.getHeight();
        }
        return -1;
    }

    public boolean getPCConnected() {
        return this.pc != null;
    }

    public boolean getPCRunning() {
        return this.pcRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(String string, String string2) {
        Event event = new Event();
        event.type = string;
        event.data = string2;
        Queue<Event> queue = this.eventQueue;
        synchronized (queue) {
            this.eventQueue.offer(event);
            this.eventQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event pollEvent() {
        Queue<Event> queue = this.eventQueue;
        synchronized (queue) {
            return this.eventQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event waitEvent() {
        Queue<Event> queue = this.eventQueue;
        synchronized (queue) {
            Event event = null;
            while ((event = this.eventQueue.poll()) == null && !this.luaTerminateReq && !this.reconnectInProgress) {
                try {
                    this.eventQueue.wait();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return event;
        }
    }

    public LuaPlugin(String string) throws Exception {
        this.kernelArguments = Misc.parseStringToComponents(string);
        this.userArguments = new HashMap<String, String>();
        this.kernelName = this.kernelArguments.get("kernel");
        this.kernelArguments.remove("kernel");
        this.vgaPoller = new VGARetraceWaiter();
        this.vgaPoller.start();
        if (this.kernelArguments.get("noguimode") != null) {
            this.specialNoGUIMode = true;
        }
        this.pcRunning = false;
        this.luaThread = null;
        this.luaInvokeReq = null;
        this.luaTerminateReq = false;
        this.consoleMode = true;
        this.resources = new HashMap<String, LuaResource>();
        this.liveObjects = new IdentityHashMap();
        this.eventQueue = new LinkedList<Event>();
        this.liveObjects.put(null, null);
    }

    public LuaPlugin(Plugins plugins, String string) throws Exception {
        this(string);
        this.consoleMode = false;
        this.vPluginManager = plugins;
        this.outputConnector = plugins.getOutputConnector();
        if (this.specialNoGUIMode) {
            return;
        }
        this.window = new JFrame("Lua window" + Misc.emuname);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel = new JPanel(gridBagLayout);
        this.window.add(this.panel);
        this.console = new JTextArea(25, 80);
        this.console.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this.console);
        this.console.setEditable(false);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)jScrollPane, gridBagConstraints);
        this.execLabel = new JLabel("Lua script");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.execLabel, gridBagConstraints);
        this.execName = new JTextField("", 40);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.execName, gridBagConstraints);
        this.execButton = new JButton("Run");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.execButton, gridBagConstraints);
        this.execButton.addActionListener(this);
        this.termButton = new JButton("Terminate Lua VM");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.termButton, gridBagConstraints);
        this.termButton.addActionListener(this);
        this.termButton.setEnabled(false);
        this.clearButton = new JButton("Clear Console");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.clearButton, gridBagConstraints);
        this.clearButton.addActionListener(this);
        this.window.pack();
        this.window.setDefaultCloseOperation(0);
        Dimension dimension = this.window.getSize();
        this.nativeWidth = dimension.width;
        this.nativeHeight = dimension.height;
        this.window.setVisible(true);
    }

    public List<Object> getRenderers() {
        return this.vPluginManager.getRenderers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        LuaPlugin luaPlugin;
        if (stringArray.length != 2) {
            System.err.println("Syntax: LuaPlugin <script> <args>");
            return;
        }
        try {
            luaPlugin = new LuaPlugin(stringArray[1]);
        }
        catch (Exception exception) {
            System.err.println("Can't initialize LuaPlugin: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
        Runtime.getRuntime().addShutdownHook(luaPlugin.new DedicatedShutdownHandler());
        Thread thread = new Thread((Runnable)luaPlugin.new RunMainThread(), "Lua execution thread");
        thread.start();
        LuaPlugin luaPlugin2 = luaPlugin;
        synchronized (luaPlugin2) {
            while (!luaPlugin.mainThreadWait) {
                try {
                    luaPlugin.wait();
                }
                catch (Exception exception) {}
            }
            try {
                luaPlugin.invokeLuaVM(stringArray[0]);
            }
            catch (Exception exception) {
                System.err.println("Error: Can't start Lua VM: " + exception.getMessage());
            }
            while (luaPlugin.luaThread != null || luaPlugin.luaInvokeReq != null) {
                try {
                    luaPlugin.wait();
                }
                catch (Exception exception) {}
            }
        }
        thread.stop();
    }

    public static int luaCB_print_console_msg(Lua lua, LuaPlugin luaPlugin) {
        if (lua.type(1) != 4) {
            lua.error("Unexpected types to print_console_msg");
            return 0;
        }
        luaPlugin.printConsoleMsg(lua.value(1).toString() + "\n");
        return 0;
    }

    public static int luaCB_loadmodule(Lua lua, LuaPlugin luaPlugin) {
        if (lua.type(1) != 4) {
            lua.error("Unexpected types to loadmodule");
            return 0;
        }
        try {
            Class<?> clazz = Class.forName(lua.checkString(1));
            LuaTable luaTable = lua.newTable();
            luaPlugin.tableAddFunctions(lua, luaTable, null, clazz);
            lua.push(luaTable);
        }
        catch (Exception exception) {
            lua.error("No such extension module: " + lua.checkString(1));
            return 0;
        }
        return 1;
    }

    class RunMainThread
    implements Runnable {
        RunMainThread() {
        }

        @Override
        public void run() {
            LuaPlugin.this.main();
        }
    }

    class DedicatedShutdownHandler
    extends Thread {
        DedicatedShutdownHandler() {
        }

        @Override
        public void run() {
            LuaPlugin.this.terminateLuaVM();
        }
    }

    public class Event {
        public String type;
        public String data;
    }

    class VGARetraceWaiter
    extends Thread {
        private volatile boolean active;
        private volatile boolean reactivateFlag;
        private volatile boolean deactivateFlag;

        public VGARetraceWaiter() {
            super("VGA Lua Trace waiting thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                VGARetraceWaiter vGARetraceWaiter = this;
                synchronized (vGARetraceWaiter) {
                    if (!this.active || LuaPlugin.this.screenOut == null) {
                        this.active = false;
                        while (!this.reactivateFlag) {
                            try {
                                this.wait();
                            }
                            catch (Exception exception) {}
                        }
                        this.active = true;
                        this.reactivateFlag = false;
                    } else {
                        boolean bl = LuaPlugin.this.screenOut.aquire();
                        if (bl) {
                            LuaPlugin.this.ownsVGALock = true;
                            LuaPlugin.this.queueEvent("lock", null);
                            this.active = false;
                        }
                        if (this.deactivateFlag) {
                            this.active = false;
                            this.deactivateFlag = false;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate() {
            if (!this.active) {
                return;
            }
            this.deactivateFlag = true;
            this.interrupt();
            while (true) {
                VGARetraceWaiter vGARetraceWaiter = this;
                synchronized (vGARetraceWaiter) {
                    if (!this.active) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reactivate() {
            if (this.active) {
                return;
            }
            this.reactivateFlag = true;
            VGARetraceWaiter vGARetraceWaiter = this;
            synchronized (vGARetraceWaiter) {
                this.notifyAll();
            }
        }
    }

    class LuaThread
    implements Runnable {
        Lua lua;
        String script;

        LuaThread(Lua lua, String string) {
            BaseLib.open(lua);
            StringLib.open(lua);
            MathLib.open(lua);
            TableLib.open(lua);
            this.lua = lua;
            this.script = string;
        }

        private String describeFault(int n) {
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return "Main thread yielded.";
            }
            if (n == 2) {
                return "Unprotected runtime error";
            }
            if (n == 3) {
                return "syntax error";
            }
            if (n == 6) {
                return "I/O error loading";
            }
            if (n == 5) {
                return "Double fault";
            }
            return "Unknown fault #" + n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lua.setGlobal("script", this.script);
            LuaTable luaTable = this.lua.newTable();
            this.lua.setGlobal("args", luaTable);
            for (Map.Entry entry : LuaPlugin.this.kernelArguments.entrySet()) {
                this.lua.setTable(luaTable, entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : LuaPlugin.this.userArguments.entrySet()) {
                this.lua.setTable(luaTable, "x-" + (String)entry.getKey(), entry.getValue());
            }
            LuaPlugin.this.tableAddFunctions(this.lua, this.lua.getGlobals(), null, LuaPlugin.class);
            while (!LuaPlugin.this.luaStarted) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            Object object = null;
            try {
                object = new BufferedInputStream(Misc.openStream(LuaPlugin.this.kernelName, "datafiles/luakernel"));
                int n = this.lua.load((InputStream)object, "Kernel");
                String string = this.describeFault(n);
                if (string != null) {
                    throw new Exception("Kernel loading error: " + string);
                }
                n = this.lua.pcall(0, 0, null);
                string = this.describeFault(n);
                if (string != null) {
                    throw new Exception("Kernel error: " + string);
                }
            }
            catch (Exception exception) {
                LuaPlugin.this.printConsoleMsg("\n\nLua Error: " + exception.getMessage() + "\n" + this.lua.value(-1).toString() + "\n\n");
                Misc.errorDialog(exception, "Lua error", null, "Dismiss");
            }
            LuaPlugin luaPlugin = LuaPlugin.this;
            synchronized (luaPlugin) {
                LuaPlugin.this.cleanupLuaResources();
                LuaPlugin.this.luaThread = null;
                LuaPlugin.this.luaState = null;
                LuaPlugin.this.notifyAll();
            }
            LuaPlugin.this.printConsoleMsg("Lua VM: Lua script finished.\n");
        }
    }

    class LuaCallback
    extends LuaJavaCallback {
        Method callbackMethod;
        Object onObject;

        LuaCallback(Object object, Method method) {
            this.onObject = object;
            this.callbackMethod = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int luaFunction(Lua lua) {
            LuaPlugin luaPlugin = LuaPlugin.this;
            synchronized (luaPlugin) {
                try {
                    if (!LuaPlugin.this.liveObjects.containsKey(this.onObject)) {
                        lua.error("Attempted to call method on dead object");
                        return 0;
                    }
                    return (Integer)this.callbackMethod.invoke(this.onObject, LuaPlugin.this.luaState, LuaPlugin.this);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getCause() instanceof LuaError) {
                        throw (LuaError)invocationTargetException.getCause();
                    }
                    Misc.errorDialog(invocationTargetException.getCause(), "Error in callback", null, "Terminate Lua VM");
                    LuaPlugin.this.terminateLuaVMAsync();
                }
                catch (Exception exception) {
                    if (exception instanceof LuaError) {
                        throw (LuaError)exception;
                    }
                    Misc.errorDialog(exception, "Error invoking callback", null, "Terminate Lua VM");
                    LuaPlugin.this.terminateLuaVMAsync();
                }
            }
            while (true) {
                // Infinite loop
            }
        }
    }

    public static abstract class LuaResource {
        String handle;
        LuaPlugin plugin;

        public LuaResource(LuaPlugin luaPlugin) {
            this.handle = "h" + luaPlugin.nextHandle++;
            this.plugin = luaPlugin;
            this.plugin.resources.put(this.handle, this);
        }

        public final String getHandle() {
            return this.handle;
        }

        public final void release(boolean bl) throws IOException {
            block2: {
                try {
                    this.destroy();
                }
                catch (IOException iOException) {
                    if (bl) break block2;
                    throw iOException;
                }
            }
            this.plugin.liveObjects.remove(this);
            this.plugin.resources.remove(this.handle);
        }

        public abstract void destroy() throws IOException;
    }
}

