/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.jpc.Misc;
import org.jpc.emulator.PC;
import org.jpc.pluginsaux.HUDRenderer;
import org.jpc.pluginsaux.PCMonitorPanel;
import org.jpc.pluginsaux.PCMonitorPanelEmbedder;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class PCMonitor
implements Plugin,
PCMonitorPanelEmbedder {
    private static final long serialVersionUID = 7L;
    private int nativeWidth;
    private int nativeHeight;
    private JFrame monitorWindow;
    private PCMonitorPanel panel;
    private Plugins pManager;

    public PCMonitor(Plugins plugins) {
        this.pManager = plugins;
        this.panel = new PCMonitorPanel(this, plugins.getOutputConnector());
        plugins.addSlaveObject(this, this.panel);
        this.monitorWindow = new JFrame("VGA Monitor" + Misc.emuname);
        this.monitorWindow.getContentPane().add("Center", this.panel.getMonitorPanel());
        JMenuBar jMenuBar = new JMenuBar();
        for (JMenu jMenu : this.panel.getMenusNeeded()) {
            jMenuBar.add(jMenu);
        }
        this.monitorWindow.setJMenuBar(jMenuBar);
        this.monitorWindow.pack();
        this.monitorWindow.setDefaultCloseOperation(0);
        Dimension dimension = this.monitorWindow.getSize();
        this.nativeWidth = dimension.width;
        this.nativeHeight = dimension.height;
        this.panel.startThread();
        this.monitorWindow.setVisible(true);
    }

    @Override
    public void sendMessage(String string) {
        this.pManager.invokeExternalCommand("luaplugin-sendmessage", new Object[]{string});
    }

    public void eci_pcmonitor_setwinpos(Integer n, Integer n2) {
        Misc.moveWindow(this.monitorWindow, n, n2, this.nativeWidth, this.nativeHeight);
    }

    @Override
    public boolean systemShutdown() {
        return true;
    }

    @Override
    public void pcStopping() {
    }

    @Override
    public void pcStarting() {
    }

    @Override
    public void reconnect(PC pC) {
        this.panel.setPC(pC);
    }

    @Override
    public void notifySizeChange(int n, int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PCMonitor.this.monitorWindow.pack();
                Dimension dimension = PCMonitor.this.monitorWindow.getSize();
                PCMonitor.this.nativeWidth = dimension.width;
                PCMonitor.this.nativeHeight = dimension.height;
            }
        });
    }

    @Override
    public void notifyRenderer(HUDRenderer hUDRenderer) {
        this.pManager.addRenderer(hUDRenderer);
    }

    @Override
    public void notifyFrameReceived(int n, int n2) {
    }

    @Override
    public void main() {
    }
}

