/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;

public class ConstantTableLayout
implements LayoutManager2 {
    private HashMap<Component, Placement> components = new HashMap();
    private boolean cacheValid = false;
    private int rowHeight = 0;
    private int columnWidth = 0;
    private int rows = 0;
    private int columns = 0;

    @Override
    public void addLayoutComponent(String string, Component component) {
        System.err.println("Error: addLayoutComponent(String, Component): Not supported.");
    }

    private void recomputeCache() {
        if (this.cacheValid) {
            return;
        }
        this.rowHeight = 0;
        this.columnWidth = 0;
        this.rows = 0;
        this.columns = 0;
        for (Map.Entry<Component, Placement> entry : this.components.entrySet()) {
            Placement placement = entry.getValue();
            this.columns = Math.max(this.columns, placement.posX + placement.sizeW);
            this.rows = Math.max(this.rows, placement.posY + placement.sizeH);
            Dimension dimension = entry.getKey().getMinimumSize();
            this.columnWidth = Math.max(this.columnWidth, (dimension.width + placement.sizeW - 1) / placement.sizeW);
            this.rowHeight = Math.max(this.rowHeight, (dimension.height + placement.sizeH - 1) / placement.sizeH);
        }
        this.cacheValid = true;
    }

    @Override
    public void layoutContainer(Container container) {
        this.recomputeCache();
        double d = (double)container.getWidth() / (double)(this.columnWidth * this.columns);
        double d2 = (double)container.getHeight() / (double)(this.rowHeight * this.rows);
        for (Map.Entry<Component, Placement> entry : this.components.entrySet()) {
            Placement placement = entry.getValue();
            entry.getKey().setBounds((int)((double)(placement.posX * this.columnWidth) * d), (int)((double)(placement.posY * this.rowHeight) * d2), (int)((double)(placement.sizeW * this.columnWidth) * d), (int)((double)(placement.sizeH * this.rowHeight) * d2));
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.recomputeCache();
        return new Dimension(this.columns * this.columnWidth, this.rows * this.rowHeight);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.cacheValid = false;
        this.components.remove(component);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.cacheValid = false;
        this.components.put(component, (Placement)object);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.cacheValid = false;
    }

    public static class Placement {
        public int posX;
        public int posY;
        public int sizeW;
        public int sizeH;

        public Placement(int n, int n2, int n3, int n4) {
            this.posX = n;
            this.posY = n2;
            this.sizeW = n3;
            this.sizeH = n4;
        }
    }
}

