/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jpc.Misc;
import org.jpc.diskimages.DiskImage;
import org.jpc.diskimages.FileRawDiskImage;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.diskimages.ImageMaker;
import org.jpc.diskimages.RawDiskImage;
import org.jpc.diskimages.TreeDirectoryFile;
import org.jpc.diskimages.TreeRawDiskImage;

public class ImportDiskImage
implements ActionListener,
KeyListener {
    private JFrame window;
    private JPanel cpanel;
    private JPanel lpanel;
    private JPanel rpanel;
    private JTextField imageName;
    private JTextField imageFile;
    private JComboBox imageType;
    private JLabel feedback;
    private JButton importDisk;
    private JButton cancel;
    private JCheckBox stdGeometry;
    private JCheckBox doublesided;
    private JTextField sides;
    private JLabel sidesFixed;
    private JTextField sectors;
    private JLabel sectorsFixed;
    private JTextField tracks;
    private JLabel tracksFixed;
    private JCheckBox volumeLabelLabel;
    private JTextField volumeLabel;
    private JCheckBox createTimeLabel;
    private JTextField createTime;
    private static String NOT_VALID = "<No valid choice>";
    private static String FLOPPY = "Floppy Disk";
    private static String HDD = "Hard Disk";
    private static String CDROM = "CD-ROM Disk";
    private static String BIOS = "BIOS image";
    private boolean fileSelected;
    private long fileSelectedLength;
    private boolean directorySelected;
    private boolean constructed;
    private long fileCase;

    public ImportDiskImage() {
        int n = 9;
        this.fileCase = -1L;
        this.window = new JFrame("Import Disk Image");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.cpanel = new JPanel(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.lpanel = new JPanel(gridBagLayout2);
        this.rpanel = new JPanel();
        this.rpanel.setLayout(new BoxLayout(this.rpanel, 1));
        this.rpanel.add(this.cpanel);
        this.rpanel.add(this.lpanel);
        this.window.add(this.rpanel);
        this.add(new JLabel("New image name"), 0, 0);
        this.imageName = new JTextField("", 50);
        this.add(this.imageName, 1, 0);
        this.imageName.addKeyListener(this);
        JButton jButton = new JButton("Image file/directory");
        this.add(jButton, 0, 1);
        this.imageFile = new JTextField("", 50);
        this.add(this.imageFile, 1, 1);
        this.imageFile.addKeyListener(this);
        jButton.addActionListener(this);
        jButton.setActionCommand("SELECT");
        this.add(new JLabel("Image Type"), 0, 2);
        this.imageType = new JComboBox();
        this.add(this.imageType, 1, 2);
        this.imageType.addActionListener(this);
        this.setNoValidChoice(this.imageType);
        this.stdGeometry = new JCheckBox("Standard geometry");
        this.add(this.stdGeometry, 0, 3);
        this.stdGeometry.setEnabled(false);
        this.stdGeometry.addActionListener(this);
        this.doublesided = new JCheckBox("Double-sided");
        this.add(this.doublesided, 0, 4);
        this.doublesided.setEnabled(false);
        this.doublesided.addActionListener(this);
        this.add(new JLabel("Sides"), 0, 5);
        this.sides = new JTextField("16", 50);
        this.add(this.sides, 1, 5);
        this.sidesFixed = new JLabel("N/A");
        this.add(this.sidesFixed, 1, 5);
        this.sides.setVisible(false);
        this.sides.addKeyListener(this);
        this.add(new JLabel("Sectors"), 0, 6);
        this.sectors = new JTextField("63", 50);
        this.add(this.sectors, 1, 6);
        this.sectorsFixed = new JLabel("N/A");
        this.add(this.sectorsFixed, 1, 6);
        this.sectors.setVisible(false);
        this.sectors.addKeyListener(this);
        this.add(new JLabel("Tracks"), 0, 7);
        this.tracks = new JTextField("16", 50);
        this.add(this.tracks, 1, 7);
        this.tracksFixed = new JLabel("N/A");
        this.add(this.tracksFixed, 1, 7);
        this.tracks.setVisible(false);
        this.tracks.addKeyListener(this);
        this.volumeLabelLabel = new JCheckBox("Volume label");
        this.add(this.volumeLabelLabel, 0, 8);
        this.volumeLabel = new JTextField("", 50);
        this.add(this.volumeLabel, 1, 8);
        this.volumeLabel.setEnabled(false);
        this.volumeLabelLabel.setEnabled(false);
        this.volumeLabelLabel.addActionListener(this);
        this.volumeLabel.addKeyListener(this);
        this.createTimeLabel = new JCheckBox("File timestamps");
        this.add(this.createTimeLabel, 0, 9);
        this.createTime = new JTextField("19900101000000", 50);
        this.add(this.createTime, 1, 9);
        this.createTime.setEnabled(false);
        this.createTimeLabel.setEnabled(false);
        this.createTimeLabel.addActionListener(this);
        this.createTime.addKeyListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.feedback = new JLabel("");
        this.lpanel.add((Component)this.feedback, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.importDisk = new JButton("Import");
        this.lpanel.add((Component)this.importDisk, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.cancel = new JButton("Cancel");
        this.lpanel.add((Component)this.cancel, gridBagConstraints);
        this.importDisk.setActionCommand("IMPORT");
        this.importDisk.addActionListener(this);
        this.importDisk.setEnabled(false);
        this.cancel.setActionCommand("CANCEL");
        this.cancel.addActionListener(this);
        this.revalidateForm();
        this.constructed = true;
        this.keyTyped(null);
        this.window.pack();
        this.window.setDefaultCloseOperation(2);
        this.window.setVisible(true);
    }

    private void selectImage() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText("Select");
        jFileChooser.setDialogTitle("Select image file or directory to import");
        jFileChooser.setFileSelectionMode(2);
        int n = jFileChooser.showOpenDialog(this.window);
        if (n == 0) {
            this.imageFile.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.keyTyped(null);
        }
    }

    private void setNoValidChoice(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(NOT_VALID);
        jComboBox.setSelectedItem(NOT_VALID);
        jComboBox.setEnabled(false);
    }

    private void add(JComponent jComponent, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (n == 1) {
            gridBagConstraints.fill = 2;
        }
        this.cpanel.add((Component)jComponent, gridBagConstraints);
    }

    private int checkVolumeLabel(String string) {
        if (string.length() > 11) {
            return 1;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '|') {
                return 2;
            }
            if (c >= '!' && c <= ')' || c == '-' || c >= '0' && c <= '9' || c >= '@' && c <= 'Z' || c >= '^' && c <= '~' || c >= '\u00a0' && c <= '\u00ff') continue;
            return 2;
        }
        return 0;
    }

    private boolean checkTimeStamp(String string) {
        try {
            TreeDirectoryFile.dosFormatTimeStamp(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void revalidateForm() {
        if ("".equals(this.imageName.getText())) {
            this.feedback.setText("No image name specified");
            this.importDisk.setEnabled(false);
            return;
        }
        if (this.imageName.getText().startsWith("/")) {
            this.feedback.setText("Image name can't start with '/'");
            this.importDisk.setEnabled(false);
            return;
        }
        if (this.imageName.getText().indexOf("//") >= 0) {
            this.feedback.setText("Image name can't have '//'");
            this.importDisk.setEnabled(false);
            return;
        }
        if (this.imageName.getText().lastIndexOf("/") == this.imageName.getText().length() - 1) {
            this.feedback.setText("Image name can't end in '/'");
            this.importDisk.setEnabled(false);
            return;
        }
        if ("".equals(this.imageFile.getText())) {
            this.feedback.setText("No image file specified");
            this.importDisk.setEnabled(false);
            return;
        }
        String string = this.imageFile.getText();
        File file = new File(string);
        if (!file.exists()) {
            this.feedback.setText("Image file does not exist");
            this.importDisk.setEnabled(false);
            return;
        }
        if (!file.isFile() && !file.isDirectory()) {
            this.feedback.setText("Special devices not allowed as image files");
            this.importDisk.setEnabled(false);
            return;
        }
        int n = this.getSides();
        int n2 = this.getSectors();
        int n3 = this.getTracks();
        String string2 = (String)this.imageType.getSelectedItem();
        if (FLOPPY.equals(string2)) {
            if (n < 1 || n > 2) {
                this.feedback.setText("Sides out of range (1-2)");
                this.importDisk.setEnabled(false);
                return;
            }
            if (n2 < 1 || n2 > 255) {
                this.feedback.setText("Sectors out of range (1-255)");
                this.importDisk.setEnabled(false);
                return;
            }
            if (n3 < 1 || n3 > 256) {
                this.feedback.setText("Tracks out of range (1-256)");
                this.importDisk.setEnabled(false);
                return;
            }
        } else if (HDD.equals(string2)) {
            if (n < 1 || n > 16) {
                this.feedback.setText("Sides out of range (1-16)");
                this.importDisk.setEnabled(false);
                return;
            }
            if (n2 < 1 || n2 > 63) {
                this.feedback.setText("Sectors out of range (1-63)");
                this.importDisk.setEnabled(false);
                return;
            }
            if (n3 < 1 || n3 > 1024) {
                this.feedback.setText("Tracks out of range (1-1024)");
                this.importDisk.setEnabled(false);
                return;
            }
        } else if (!CDROM.equals(string2) && !BIOS.equals(string2)) {
            this.feedback.setText("Bad image type");
            this.importDisk.setEnabled(false);
            return;
        }
        if (this.volumeLabelLabel.isEnabled() && this.volumeLabelLabel.isSelected()) {
            int n4 = 0;
            n4 = this.checkVolumeLabel(this.volumeLabel.getText());
            if (n4 == 1) {
                this.feedback.setText("Volume label too long");
                this.importDisk.setEnabled(false);
                return;
            }
            if (n4 == 2) {
                this.feedback.setText("Invalid character in volume label");
                this.importDisk.setEnabled(false);
                return;
            }
        }
        if (this.createTimeLabel.isEnabled() && this.createTimeLabel.isSelected() && !this.checkTimeStamp(this.createTime.getText())) {
            this.feedback.setText("Bad timestamp (YYYYMMDDHHMMSS)");
            this.importDisk.setEnabled(false);
            return;
        }
        this.feedback.setText("");
        this.importDisk.setEnabled(true);
    }

    private void importDisk() throws IOException {
        String string = this.imageName.getText();
        String string2 = this.imageFile.getText();
        String string3 = (String)this.imageType.getSelectedItem();
        int n = this.getSides();
        int n2 = this.getSectors();
        int n3 = this.getTracks();
        String string4 = null;
        if (this.volumeLabelLabel.isEnabled() && this.volumeLabelLabel.isSelected()) {
            string4 = this.volumeLabel.getText();
        }
        String string5 = null;
        if (this.createTimeLabel.isEnabled() && this.createTimeLabel.isSelected()) {
            string5 = this.createTime.getText();
        }
        int n4 = -1;
        if (FLOPPY.equals(string3)) {
            n4 = 0;
            if (n < 1 || n > 2 || n2 < 1 || n2 > 255 || n3 < 1 || n3 > 256) {
                throw new IOException("Illegal floppy geometry " + n + " sides " + n2 + " sectors " + n3 + " tracks");
            }
        } else if (HDD.equals(string3)) {
            n4 = 1;
            if (n < 1 || n > 16 || n2 < 1 || n2 > 63 || n3 < 1 || n3 > 1024) {
                throw new IOException("Illegal HDD geometry " + n + " sides " + n2 + " sectors " + n3 + " tracks");
            }
        } else if (CDROM.equals(string3)) {
            n4 = 2;
        } else if (BIOS.equals(string3)) {
            n4 = 3;
        } else {
            throw new IOException("Illegal Image type: " + string3);
        }
        ImportTask importTask = new ImportTask();
        importTask.name = string;
        importTask.file = string2;
        importTask.typeCode = n4;
        importTask.sides = n;
        importTask.sectors = n2;
        importTask.tracks = n3;
        importTask.label = string4;
        importTask.timestamp = string5;
        new Thread((Runnable)importTask, "Import task thread").start();
    }

    private void doImportFinished(Exception exception, byte[] byArray) {
        final Exception exception2 = exception;
        final byte[] byArray2 = byArray;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportDiskImage.this.importFinished(exception2, byArray2);
                }
            });
        }
        catch (Exception exception3) {
            // empty catch block
        }
    }

    private void importFinished(Exception exception, byte[] byArray) {
        if (exception != null) {
            Misc.errorDialog(exception, "Error making image", this.window, "Dismiss");
            this.cancel.setEnabled(true);
            this.keyTyped(null);
        } else {
            Misc.callShowOptionDialog(null, "New image (ID " + new ImageLibrary.ByteArray(byArray) + ") imported", "Image imported", 0, 2, null, new String[]{"Dismiss"}, "Dismiss");
            this.window.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("IMPORT".equals(string)) {
            this.feedback.setText("Importing disk...");
            this.importDisk.setEnabled(false);
            this.cancel.setEnabled(false);
            try {
                this.importDisk();
            }
            catch (Exception exception) {
                Misc.errorDialog(exception, "Error making image", this.window, "Dismiss");
                this.cancel.setEnabled(true);
                this.keyTyped(null);
            }
        } else if ("CANCEL".equals(string)) {
            this.window.dispose();
        } else if ("SELECT".equals(string)) {
            this.selectImage();
        } else {
            this.keyTyped(null);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    private void updateFile() {
        String string = this.imageFile.getText();
        if (!"".equals(string)) {
            String string2 = null;
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                this.fileSelected = true;
                this.directorySelected = false;
                this.fileSelectedLength = file.length();
                if (this.fileCase == this.fileSelectedLength) {
                    return;
                }
                this.fileCase = this.fileSelectedLength;
                this.imageType.removeAllItems();
                if (this.fileSelectedLength > 0L && this.fileSelectedLength <= 262144L) {
                    this.imageType.addItem(BIOS);
                    if (string2 == null) {
                        string2 = BIOS;
                    }
                }
                if (file.length() > 0L && file.length() % 512L == 0L) {
                    this.imageType.addItem(FLOPPY);
                    this.imageType.addItem(HDD);
                    this.imageType.addItem(CDROM);
                    if (string2 == null) {
                        string2 = FLOPPY;
                    }
                }
            }
            if (file.exists() && file.isDirectory()) {
                if (this.fileCase == -2L) {
                    return;
                }
                this.fileCase = -2L;
                this.fileSelected = false;
                this.directorySelected = true;
                this.imageType.removeAllItems();
                this.imageType.addItem(FLOPPY);
                this.imageType.addItem(HDD);
                if (string2 == null) {
                    string2 = FLOPPY;
                }
            }
            if (string2 != null) {
                this.imageType.setSelectedItem(string2);
                this.imageType.setEnabled(true);
            } else {
                if (this.fileCase == -3L) {
                    return;
                }
                this.fileCase = -3L;
                this.fileSelected = false;
                this.directorySelected = false;
                this.setNoValidChoice(this.imageType);
            }
        } else {
            if (this.fileCase == -4L) {
                return;
            }
            this.fileCase = -4L;
            this.fileSelected = false;
            this.directorySelected = false;
            this.setNoValidChoice(this.imageType);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.constructed) {
            return;
        }
        this.updateFile();
        this.changeGeometry();
        if (this.directorySelected) {
            this.createTimeLabel.setEnabled(true);
            this.volumeLabelLabel.setEnabled(true);
            if (this.createTimeLabel.isSelected()) {
                this.createTime.setEnabled(true);
            } else {
                this.createTime.setEnabled(false);
            }
            if (this.volumeLabelLabel.isSelected()) {
                this.volumeLabel.setEnabled(true);
            } else {
                this.volumeLabel.setEnabled(false);
            }
        } else {
            this.volumeLabel.setEnabled(false);
            this.volumeLabelLabel.setEnabled(false);
            this.createTime.setEnabled(false);
            this.createTimeLabel.setEnabled(false);
        }
        this.revalidateForm();
        this.window.pack();
    }

    private int textToInt(String string) {
        if (string == null) {
            return -1;
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                return -1;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private boolean stdGeometryValid(long l) {
        if (l % 512L != 0L) {
            return false;
        }
        if (l < 327680L && l % 20480L != 0L) {
            return true;
        }
        if (l < 327680L && l % 20992L != 0L) {
            return true;
        }
        if (l < 327680L && l % 21504L != 0L) {
            return true;
        }
        if (l < 327680L && l % 22016L != 0L) {
            return true;
        }
        if (l < 327680L) {
            return false;
        }
        if (l < 737280L && l % 40960L != 0L) {
            return true;
        }
        if (l < 737280L && l % 41984L != 0L) {
            return true;
        }
        if (l < 737280L && l % 43008L != 0L) {
            return true;
        }
        if (l < 737280L && l % 44032L != 0L) {
            return true;
        }
        if (l < 327680L) {
            return false;
        }
        if (l > 4079616L) {
            return false;
        }
        if (l % 81920L != 0L) {
            return true;
        }
        if (l % 82944L != 0L) {
            return true;
        }
        if (l % 83968L != 0L) {
            return true;
        }
        return l % 84992L != 0L;
    }

    private int stdGeometrySides(long l) {
        if (l < 327680L) {
            return 1;
        }
        return 2;
    }

    private int getSides() {
        String string = (String)this.imageType.getSelectedItem();
        if (FLOPPY.equals(string)) {
            if (this.stdGeometry.isEnabled() && this.stdGeometry.isSelected()) {
                return this.stdGeometrySides(this.fileSelectedLength);
            }
            return this.doublesided.isSelected() ? 2 : 1;
        }
        if (HDD.equals(string)) {
            return this.textToInt(this.sides.getText());
        }
        return -1;
    }

    private boolean forceSides() {
        String string = (String)this.imageType.getSelectedItem();
        return !HDD.equals(string);
    }

    private long sideSectors(long l) {
        if (l < 327680L) {
            return l / 512L;
        }
        return l / 1024L;
    }

    private int stdGeometrySectors(long l) {
        long l2 = this.sideSectors(l);
        int n = 80;
        if (l2 < 720L) {
            n = 40;
        }
        for (int i = 0; i < 4; ++i) {
            if ((int)l2 % (n + i) != 0) continue;
            return (int)l2 / (n + i);
        }
        return -1;
    }

    private int getSectors() {
        String string = (String)this.imageType.getSelectedItem();
        if (this.stdGeometry.isEnabled() && this.stdGeometry.isSelected()) {
            return this.stdGeometrySectors(this.fileSelectedLength);
        }
        if (HDD.equals(string) || FLOPPY.equals(string)) {
            return this.textToInt(this.sectors.getText());
        }
        return -1;
    }

    private boolean forceSectors() {
        String string = (String)this.imageType.getSelectedItem();
        if (this.stdGeometry.isEnabled() && this.stdGeometry.isSelected()) {
            return true;
        }
        return !HDD.equals(string) && !FLOPPY.equals(string);
    }

    private int stdGeometryTracks(long l) {
        long l2 = this.sideSectors(l);
        int n = 80;
        if (l2 < 720L) {
            n = 40;
        }
        for (int i = 0; i < 4; ++i) {
            if ((int)l2 % (n + i) != 0) continue;
            return n + i;
        }
        return -1;
    }

    private int getTracks() {
        String string = (String)this.imageType.getSelectedItem();
        if (!HDD.equals(string) && !FLOPPY.equals(string)) {
            return -1;
        }
        if (this.stdGeometry.isEnabled() && this.stdGeometry.isSelected()) {
            return this.stdGeometryTracks(this.fileSelectedLength);
        }
        if (this.directorySelected) {
            return this.textToInt(this.tracks.getText());
        }
        if (this.fileSelected) {
            int n = 256;
            if (HDD.equals(string)) {
                n = 1024;
            }
            if (this.fileSelectedLength % 512L != 0L) {
                return -2;
            }
            long l = this.fileSelectedLength / 512L;
            if (l % (long)this.getSides() != 0L) {
                return -2;
            }
            if ((l /= (long)this.getSides()) % (long)this.getSectors() != 0L) {
                return -2;
            }
            if ((l /= (long)this.getSectors()) < 1L || l > (long)n) {
                return -2;
            }
            return (int)l;
        }
        return -1;
    }

    private boolean forceTracks() {
        String string = (String)this.imageType.getSelectedItem();
        if (!HDD.equals(string) && !FLOPPY.equals(string)) {
            return true;
        }
        if (this.stdGeometry.isEnabled() && this.stdGeometry.isSelected()) {
            return true;
        }
        return !this.directorySelected;
    }

    private void changeGeometry() {
        int n;
        String string = (String)this.imageType.getSelectedItem();
        if (FLOPPY.equals(string) && this.fileSelected) {
            this.stdGeometry.setEnabled(this.stdGeometryValid(this.fileSelectedLength));
        } else {
            this.stdGeometry.setEnabled(false);
        }
        if (FLOPPY.equals(string) && !this.stdGeometry.isSelected()) {
            this.doublesided.setEnabled(true);
        } else {
            this.doublesided.setEnabled(false);
        }
        if (this.forceSides()) {
            this.sides.setVisible(false);
            this.sidesFixed.setVisible(true);
            n = this.getSides();
            if (n >= 0) {
                this.sidesFixed.setText("" + n);
            } else if (n == -1) {
                this.sidesFixed.setText("N/A");
            } else {
                this.sidesFixed.setText("Unsatisfiable");
            }
        } else {
            this.sides.setVisible(true);
            this.sidesFixed.setVisible(false);
        }
        if (this.forceSectors()) {
            this.sectors.setVisible(false);
            this.sectorsFixed.setVisible(true);
            n = this.getSectors();
            if (n >= 0) {
                this.sectorsFixed.setText("" + n);
            } else if (n == -1) {
                this.sectorsFixed.setText("N/A");
            } else {
                this.sectorsFixed.setText("Unsatisfiable");
            }
        } else {
            this.sectors.setVisible(true);
            this.sectorsFixed.setVisible(false);
        }
        if (this.forceTracks()) {
            this.tracks.setVisible(false);
            this.tracksFixed.setVisible(true);
            n = this.getTracks();
            if (n >= 0) {
                this.tracksFixed.setText("" + n);
            } else if (n == -1) {
                this.tracksFixed.setText("N/A");
            } else {
                this.tracksFixed.setText("Unsatisfiable");
            }
        } else {
            this.tracks.setVisible(true);
            this.tracksFixed.setVisible(false);
        }
    }

    public class ImportTask
    implements Runnable {
        String name;
        String file;
        int typeCode;
        int sides;
        int sectors;
        int tracks;
        String label;
        String timestamp;

        private byte[] writeImage(RandomAccessFile randomAccessFile, String string, ImageMaker.IFormat iFormat) throws IOException {
            File file = new File(string);
            if (iFormat.typeCode == 3) {
                if (!file.isFile()) {
                    throw new IOException("BIOS images can only be made out of regular files");
                }
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(string, "r");
                return ImageMaker.makeBIOSImage(randomAccessFile, randomAccessFile2, iFormat);
            }
            if (iFormat.typeCode == 2) {
                if (!file.isFile()) {
                    throw new IOException("CD images can only be made out of regular files");
                }
                FileRawDiskImage fileRawDiskImage = new FileRawDiskImage(string);
                return ImageMaker.makeCDROMImage(randomAccessFile, fileRawDiskImage, iFormat);
            }
            if (iFormat.typeCode == 0 || iFormat.typeCode == 1) {
                RawDiskImage rawDiskImage;
                if (file.isFile()) {
                    rawDiskImage = new FileRawDiskImage(string);
                } else if (file.isDirectory()) {
                    TreeDirectoryFile treeDirectoryFile = TreeDirectoryFile.importTree(string, iFormat.volumeLabel, iFormat.timestamp);
                    rawDiskImage = new TreeRawDiskImage(treeDirectoryFile, iFormat, iFormat.volumeLabel);
                } else {
                    throw new IOException("Source is neither regular file nor directory");
                }
                return ImageMaker.makeFloppyHDDImage(randomAccessFile, rawDiskImage, iFormat);
            }
            throw new IOException("BUG: Invalid image type code " + iFormat.typeCode);
        }

        private byte[] warpedRun() throws Exception {
            File file;
            byte[] byArray = null;
            String string = DiskImage.getLibrary().getPathPrefix() + this.name;
            ImageMaker.IFormat iFormat = new ImageMaker.IFormat(null);
            iFormat.typeCode = this.typeCode;
            iFormat.tracks = this.tracks;
            iFormat.sectors = this.sectors;
            iFormat.sides = this.sides;
            iFormat.timestamp = this.timestamp;
            iFormat.volumeLabel = this.label;
            int n = string.lastIndexOf("/");
            if (n < 0) {
                n = string.lastIndexOf(File.separator);
            }
            if (!(file = new File(string.substring(0, n))).isDirectory() && !file.mkdirs()) {
                throw new IOException("Can't create directory '" + file.getAbsolutePath() + "'");
            }
            String string2 = Misc.tempname(string);
            File file2 = new File(string2);
            while (file2.exists()) {
                string2 = Misc.tempname(string);
                file2 = new File(string2);
            }
            file2.deleteOnExit();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
            try {
                byArray = this.writeImage(randomAccessFile, this.file, iFormat);
            }
            catch (Exception exception) {
                randomAccessFile.close();
                file2.delete();
                throw exception;
            }
            file2.renameTo(new File(string));
            DiskImage.getLibrary().insertFileName(new ImageLibrary.ByteArray(byArray), string, this.name);
            return byArray;
        }

        @Override
        public void run() {
            byte[] byArray = null;
            try {
                byArray = this.warpedRun();
            }
            catch (Exception exception) {
                ImportDiskImage.this.doImportFinished(exception, null);
                return;
            }
            ImportDiskImage.this.doImportFinished(null, byArray);
        }
    }
}

