/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsbase;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.jpc.Misc;
import org.jpc.emulator.PC;
import org.jpc.output.OutputStatic;
import org.jpc.pluginsbase.Plugin;

public class Plugins {
    private Set<Plugin> plugins = new HashSet<Plugin>();
    private Set<Plugin> nonRegisteredPlugins = new HashSet<Plugin>();
    private IdentityHashMap<Plugin, List<Object>> slaveObjects = new IdentityHashMap();
    private boolean manualShutdown;
    private boolean shutDown;
    private boolean commandComplete;
    private volatile boolean shuttingDown;
    private volatile boolean emulatorKill;
    private volatile boolean running;
    private volatile boolean valueReturned;
    private volatile Object[] returnValueObj;
    private PC currentPC;
    private OutputStatic outputConnector;
    private List<Object> renderers;

    public Plugins() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.manualShutdown = true;
        this.shutDown = false;
        this.shuttingDown = false;
        this.running = false;
        this.outputConnector = new OutputStatic();
        this.renderers = new ArrayList<Object>();
    }

    public void addRenderer(Object object) {
        this.renderers.add(object);
    }

    public List<Object> getRenderers() {
        return this.renderers;
    }

    public OutputStatic getOutputConnector() {
        return this.outputConnector;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void shutdownEmulator() {
        boolean bl = true;
        this.shuttingDown = true;
        HashSet<Plugin> hashSet = new HashSet<Plugin>();
        if (this.shutDown) {
            return;
        }
        while (bl) {
            bl = false;
            for (Plugin plugin : this.plugins) {
                System.err.println("Informational: Shutting down " + plugin.getClass().getName() + "...");
                if (plugin.systemShutdown()) {
                    System.err.println("Informational: Shut down " + plugin.getClass().getName() + ".");
                    continue;
                }
                bl = true;
                hashSet.add(plugin);
            }
            this.plugins = hashSet;
        }
        this.shutDown = true;
        if (this.manualShutdown) {
            System.exit(0);
        }
    }

    public synchronized void reconnect(PC pC) {
        if (this.currentPC != null) {
            this.currentPC.getOutputs().setStaticOutput(null, 0L);
        }
        this.currentPC = pC;
        if (this.currentPC != null) {
            this.currentPC.getOutputs().setStaticOutput(this.outputConnector, this.outputConnector.getLastTime() - pC.getTime());
        }
        this.running = false;
        this.plugins.addAll(this.nonRegisteredPlugins);
        this.nonRegisteredPlugins.clear();
        for (Plugin plugin : this.plugins) {
            System.err.println("Informational: Reconnecting " + plugin.getClass().getName() + "...");
            plugin.reconnect(pC);
            System.err.println("Informational: Reconnected " + plugin.getClass().getName() + "...");
        }
    }

    public synchronized void pcStopped() {
        for (Plugin plugin : this.plugins) {
            plugin.pcStopping();
        }
        for (Plugin plugin : this.nonRegisteredPlugins) {
            System.err.println("Informational: Reconnecting " + plugin.getClass().getName() + "...");
            plugin.reconnect(this.currentPC);
            System.err.println("Informational: Reconnected " + plugin.getClass().getName() + "...");
        }
        this.plugins.addAll(this.nonRegisteredPlugins);
        this.nonRegisteredPlugins.clear();
        this.running = false;
    }

    public synchronized void pcStarted() {
        for (Plugin plugin : this.plugins) {
            plugin.pcStarting();
        }
        this.running = true;
    }

    private final boolean reinterpretable(Class<?> clazz, Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass() == clazz) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (clazz == Integer.class) {
            try {
                Integer.decode(object.toString());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (clazz == Long.class) {
            try {
                Long.decode(object.toString());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private final boolean methodOk(Method method, Object[] objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            return objectArray == null || objectArray.length == 0;
        }
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i].getComponentType();
            if (clazz == null) {
                if (n < objectArray.length) {
                    if (this.reinterpretable(classArray[i], objectArray[n++])) continue;
                    return false;
                }
                return false;
            }
            if (n == objectArray.length) continue;
            for (int j = 0; j < objectArray.length - n; ++j) {
                if (this.reinterpretable(clazz, objectArray[n++])) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean namesMatch(String string, String string2) {
        if (!string2.startsWith("eci_")) {
            return false;
        }
        string = string.replaceAll("-", "_");
        return string2.substring(4).equals(string);
    }

    private final Method chooseMethod(Class<?> clazz, String string, Object[] objectArray) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this.namesMatch(string, method.getName()) || !this.methodOk(method, objectArray)) continue;
            return method;
        }
        return null;
    }

    private final Object reinterpretToType(Class<?> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == clazz) {
            return object;
        }
        if (clazz == String.class) {
            return object.toString();
        }
        if (clazz == Integer.class) {
            try {
                return new Integer(Integer.decode(object.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (clazz == Long.class) {
            try {
                return new Long(Long.decode(object.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private final Object[] prepareArguments(Method method, Object[] objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray2 = new Object[classArray.length];
        if (classArray.length == 0) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i].getComponentType();
            if (clazz == null) {
                if (n < objectArray.length) {
                    objectArray2[i] = this.reinterpretToType(classArray[i], objectArray[n++]);
                    continue;
                }
                System.err.println("Warning: Ran out of arguments for ECI (incorrect method array argument?).");
                objectArray2[i] = null;
                continue;
            }
            if (n == objectArray.length) {
                objectArray2[i] = null;
                continue;
            }
            int n2 = objectArray.length - n;
            objectArray2[i] = Array.newInstance(clazz, n2);
            for (int j = 0; j < n2; ++j) {
                Array.set(objectArray2[i], j, this.reinterpretToType(clazz, objectArray[n++]));
            }
        }
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeCommand(Object object, String string, Object[] objectArray, boolean bl) {
        Object object2;
        boolean bl2 = false;
        boolean bl3 = false;
        Class<?> clazz = object.getClass();
        Method method = null;
        Object[] objectArray2 = null;
        method = this.chooseMethod(clazz, string, objectArray);
        this.commandComplete = false;
        if (method != null) {
            objectArray2 = this.prepareArguments(method, objectArray);
            if (method.getReturnType() == Void.TYPE) {
                try {
                    method.invoke(object, objectArray2);
                    bl2 = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Misc.errorDialog(invocationTargetException.getCause(), "Error in ECI method", null, "Ignore");
                }
                catch (Exception exception) {
                    System.err.println("Error calling ECI method: " + exception.getMessage());
                }
                bl3 = true;
            } else if (method.getReturnType() == Boolean.TYPE) {
                object2 = null;
                try {
                    object2 = method.invoke(object, objectArray2);
                    bl2 = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Misc.errorDialog(invocationTargetException.getCause(), "Error in ECI method", null, "Ignore");
                }
                catch (Exception exception) {
                    System.err.println("Error calling ECI method: " + exception.getMessage());
                }
                bl3 = object2 != null && object2 instanceof Boolean ? (Boolean)object2 == false : true;
            } else {
                System.err.println("Error: Bad return type '" + method.getReturnType() + "' for ECI.");
                bl3 = true;
            }
        } else {
            bl3 = true;
        }
        while (bl && !bl3 && !this.commandComplete) {
            try {
                object2 = this;
                synchronized (object2) {
                    this.wait();
                }
            }
            catch (Exception exception) {
            }
        }
        return bl2;
    }

    public void invokeExternalCommand(String string, Object[] objectArray) {
        boolean bl = false;
        for (Plugin plugin : this.plugins) {
            boolean bl2 = bl = this.invokeCommand(plugin, string, objectArray, false) || bl;
            List<Object> list = this.slaveObjects.get(plugin);
            if (list == null) continue;
            for (Object object : list) {
                bl = this.invokeCommand(object, string, objectArray, false) || bl;
            }
        }
        if (!bl) {
            System.err.println("Warning: ECI invocation '" + string + "' not delivereble.");
        }
    }

    public void invokeExternalCommandSynchronous(String string, String[] stringArray) {
        boolean bl = false;
        for (Plugin plugin : this.plugins) {
            boolean bl2 = bl = this.invokeCommand(plugin, string, stringArray, true) || bl;
            List<Object> list = this.slaveObjects.get(plugin);
            if (list == null) continue;
            for (Object object : list) {
                bl = this.invokeCommand(object, string, stringArray, true) || bl;
            }
        }
        if (!bl) {
            System.err.println("Warning: Synchronous ECI invocation '" + string + "' not delivereble.");
        }
    }

    public synchronized Object[] invokeExternalCommandReturn(String string, String[] stringArray) {
        this.valueReturned = false;
        this.returnValueObj = null;
        for (Plugin plugin : this.plugins) {
            this.invokeCommand(plugin, string, stringArray, true);
            if (this.valueReturned) {
                return this.returnValueObj;
            }
            List<Object> list = this.slaveObjects.get(plugin);
            if (list == null) continue;
            for (Object object : list) {
                this.invokeCommand(object, string, stringArray, true);
                if (!this.valueReturned) continue;
                return this.returnValueObj;
            }
        }
        System.err.println("Warning: ECI call '" + string + "' not delivereble.");
        return null;
    }

    public synchronized void returnValue(Object ... objectArray) {
        this.returnValueObj = objectArray;
        this.valueReturned = true;
        this.commandComplete = true;
        this.notifyAll();
    }

    public synchronized void signalCommandCompletion() {
        this.commandComplete = true;
        this.notifyAll();
    }

    public synchronized void addSlaveObject(Plugin plugin, Object object) {
        if (this.slaveObjects.get(plugin) == null) {
            this.slaveObjects.put(plugin, new ArrayList());
        }
        List<Object> list = this.slaveObjects.get(plugin);
        list.add(object);
    }

    public synchronized void registerPlugin(Plugin plugin) {
        if (this.currentPC == null || !this.running) {
            this.plugins.add(plugin);
        } else {
            this.nonRegisteredPlugins.add(plugin);
        }
        new PluginThread(plugin).start();
        if (this.currentPC != null && !this.running) {
            System.err.println("Informational: Reconnecting " + plugin.getClass().getName() + "...");
            plugin.reconnect(this.currentPC);
            System.err.println("Informational: Reconnected " + plugin.getClass().getName() + "...");
        }
    }

    public synchronized boolean unregisterPlugin(Plugin plugin) {
        if (this.nonRegisteredPlugins.contains(plugin)) {
            this.nonRegisteredPlugins.remove(plugin);
            System.err.println("Informational: Shutting down " + plugin.getClass().getName() + "...");
            plugin.systemShutdown();
            System.err.println("Informational: Shut down " + plugin.getClass().getName() + ".");
            this.slaveObjects.put(plugin, null);
            return true;
        }
        System.err.println("Informational: Shutting down " + plugin.getClass().getName() + "...");
        if (plugin.systemShutdown()) {
            System.err.println("Informational: Shut down " + plugin.getClass().getName() + ".");
            this.plugins.remove(plugin);
            this.slaveObjects.put(plugin, null);
            return true;
        }
        System.err.println("Error: " + plugin.getClass().getName() + " does not want to shut down.");
        return false;
    }

    public void doKillEmulator() {
        this.emulatorKill = true;
        System.exit(1);
    }

    private class PluginThread
    extends Thread {
        private Plugin plugin;

        public PluginThread(Plugin plugin) {
            super("Plugin thread for " + plugin.getClass().getName());
            this.plugin = plugin;
        }

        @Override
        public void run() {
            this.plugin.main();
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            if (Plugins.this.emulatorKill) {
                return;
            }
            Plugins.this.manualShutdown = false;
            Plugins.this.shutdownEmulator();
        }
    }
}

