/* genbmps - get text bitmaps from txtbmp.pbm */

#include <stdio.h>

/* value of I used */
#define USED_I	0xc

unsigned char rom[8192];
unsigned char bmp[32*192];


main()
{
int w,h,x,y,c,i,mask;
char buf[128];
unsigned char *ptr;
FILE *in;

if((in=fopen("/usr/local/lib/z81/zx81.rom","rb"))==NULL)
  {
  fprintf(stderr,"Couldn't load ROM.\n");
  exit(1);
  }

fread(rom,1,8192,in);
fclose(in);

scanf("%s",buf);
if(strcmp(buf,"P4")!=0)
  {
  fprintf(stderr,"Raw PBM files only.\n");
  exit(1);
  }

scanf("%d%d",&w,&h);
getchar();  /* throw away the LF */

if(w!=256 || h!=192)
  {
  fprintf(stderr,"Must be 256x192.\n");
  exit(1);
  }

fread(bmp,1,32*192,stdin);

printf(";txtbmp - automatically generated by genbmps from txtbmp.pbm.\n");
printf(";edits will be lost!\n\n");

printf("bmpdigits:\n");

for(x=0;x<2;x++)
  {
  for(y=0;y<5;y++)
    {
    printf(";%d\n",x*5+y);
    dump(x*2,3+y*20,2,19);	/* DON'T CHANGE... */
    				/* ...as the m/c depends on the 2x19 size */
    printf("\n");
    }
  }

printf("\n\nbmplines:\n");
dump(5,4,8,20);

printf("\n\nbmpgamovr:\n");
dump(5,28,15,20);

printf("\n\nbmpbanner:\n");
dump(5,51,20,20);

printf("\n\nbmppresskey:\n");
dump(5,70,12,20);

exit(0);
}


/* find byte available which has least bits different from c. */
int closest(c)
int c;
{
int mask;
int f;
int diff,least,leastf;

least=9;

for(f=0;f<64;f++)
  {
  diff=diffbits(rom[USED_I*256+f*8],c);
  if(diff<least)
    {
    least=diff;
    leastf=f;
    }
  diff=diffbits(rom[USED_I*256+f*8]^255,c);
  if(diff<least)
    {
    least=diff;
    leastf=f+128;
    }
  }

return(leastf);
}


/* return number of bit mismatches between a and b */
int diffbits(a,b)
int a,b;
{
int count=0;
int f,mask;

for(f=0,mask=128;f<8;f++,mask>>=1)
  if((a&mask)!=(b&mask)) count++;

return(count);
}


/* dump part of scrn */
dump(x,y,w,h)
{
int a,b,c,i,mask;

printf("defb %d,%d\n",w,h);

#if 0
for(b=0;b<h;b++)
  {
  for(a=0;a<w;a++)
    {
    c=bmp[(y+b)*32+x+a];
    for(i=0,mask=128;i<8;i++,mask>>=1)
      printf("%s",(c&mask)?"#":" ");
    }
  printf("|\n");
  }
#else
for(b=0;b<h;b++)
  {
  printf("defb ");
  for(a=0;a<w;a++)
    {
    c=closest(bmp[(y+b)*32+x+a]);
    printf("0%02Xh%c",c,(a==w-1)?'\n':',');
    }
  }
#endif
}
