/* zx81send
 * based on my zxsend
 * PD by RJM 95-96
 * 9508?? - initial version
 * 960415 - made faster and added compile-time option for normal saving.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>

#ifdef TAPE_VERSION
/* this produces output almost exactly like saving from a ZX81.
 * use this if you want to save to tape.
 */
#define TWEEN_BIT_LEN	16
#define ONE_BIT_LEN	12
#define ZERO_BIT_LEN	6
#else
/* these save as fast as possible (default). this is great when you're
 * sending straight from the soundcard to the ZX81, but probably
 * not a good idea if you're recording to tape.
 * these settings send stuff twice as fast as the above.
 * note that the 'time left' display will be all wrong. :-)
 */
#define TWEEN_BIT_LEN	8
#define ONE_BIT_LEN	7
#define ZERO_BIT_LEN	2
#endif


#ifdef linux
#define BOTTOM_SIG	0x00
#define MIDDLE_SIG	0x80
#define WEIRD_SIG	0xAA
#define TOP_SIG		0xFF
#else
/* I used sox to mangle a file ub -> ul with the above bytes and got this: */
#define BOTTOM_SIG	0x02
#define MIDDLE_SIG	0xFF
#define WEIRD_SIG	0x9A
#define TOP_SIG		0x80
#endif


int verbose=1;	/* so slow, it needs it on as default :-) */
unsigned char filedata[16384];  /* as much as you could possibly save */


main(argc,argv)
int argc;
char **argv;
{
int size;
int filetype;
FILE *in;

if((argc>=2)&&(strcmp(argv[1],"-v")==0))
  {
  verbose=1;
  argc--; argv++;
  }

if(argc!=2)
  usage();
else
  {
  if((in=fopen(argv[1],"rb"))==NULL)
    die("Couldn't open file.\n");

  if((size=fread(filedata,1,sizeof(filedata),in))<=0)
    die("Couldn't read file.\n");

  fclose(in);

  sendfile(size);
  }

exit(0);
}


usage()
{
printf("usage: zx81send file.p\n");
exit(1);
}


die(mes)
char *mes;
{
fprintf(stderr,mes);
exit(1);
}


sendfile(int length)
{
int audio;
FILE *in;
int spd,a,f;
char audiodev[256];
unsigned char c;

#ifdef linux
#if 1
strcpy(audiodev,"/dev/dsp");
#else
strcpy(audiodev,"output");
#endif
#else
strcpy(audiodev,"/dev/audio");
#endif

audio=open(audiodev,O_WRONLY,0600);
if(audio==-1)
  die("Couldn't open %s.\n",audiodev);

/* wait half-sec */
c=0x80;
for(f=0;f<4000;f++)
  write(audio,&c,1);

/* the filename - 'Z' */
sendbyte(audio,0x3F|0x80);

for(f=0;f<length;f++)
  {
  if((verbose)&&((f%256==0)||(f==length-1)))
    pcntbar(f,length);
  sendbyte(audio,filedata[f]);
  }

/* wait half-sec */
c=0x80;
for(f=0;f<4000;f++)
  write(audio,&c,1);

close(audio);
if(verbose) fprintf(stderr,"\n");
}


pcntbar(done,outof)
int done,outof;
{
int f,stp,timeleft;

stp=done*71/outof;
timeleft=((outof-done)<<3)/300;  /* approximate time left */
fprintf(stderr,"%0.2d:%0.2d [",timeleft/60,timeleft%60);
for(f=0;f<stp;f++)
  fprintf(stderr,"#");
for(f=stp;f<70;f++)
  fprintf(stderr,":");
fprintf(stderr,"]\r");
}



sendbyte(fd,b)
int fd,b;
{
int f,g,n,mask;

mask=0x80;

for(g=0;g<8;g++)
  {
  /* send the 'off' (or 'bit pending' :-)) part. */
  for(f=0;f<TWEEN_BIT_LEN;f++)
    writen(fd,MIDDLE_SIG);
  
  if(b&mask)
    {
    /* one */
    /* send just over 2ms, normally */
    for(f=0;f<ONE_BIT_LEN;f++)
      {
      writen(fd,TOP_SIG);
      writen(fd,BOTTOM_SIG);
      }
    }
  else
    {
    /* zero */
    /* send just over 1ms, normally */
    for(f=0;f<ZERO_BIT_LEN;f++)
      {
      writen(fd,TOP_SIG);
      writen(fd,BOTTOM_SIG);
      }
    }
  mask>>=1;
  }
}


writen(fd,n)
int fd,n;
{
unsigned char c=n;
write(fd,&c,1);
}
