//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC AvP[V ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "filepath.h"
#include "mfc_frm.h"
#include "mfc_asm.h"
#include "mfc_com.h"
#include "mfc_info.h"
#include "mfc_res.h"
#include "mfc_app.h"

//---------------------------------------------------------------------------
//
//	AvP[V CX^X
//
//---------------------------------------------------------------------------
CApp theApp;

//---------------------------------------------------------------------------
//
//	֐|C^`
//
//---------------------------------------------------------------------------
extern "C" {
typedef int (WINAPI *DRAWTEXTWIDE)(HDC, LPCWSTR, int, LPRECT, UINT);
typedef LANGID (WINAPI *GETUSERUILANG)(VOID);
typedef ULONG (WINAPI *NOTIFYREGISTER)(HWND, int, LONG, UINT, int, SHChangeNotifyEntry*);
typedef BOOL (WINAPI *NOTIFYDEREGISTER)(ULONG);
typedef HANDLE (WINAPI *NOTIFICATIONLOCK)(HANDLE, DWORD, LPITEMIDLIST**, LONG*);
typedef BOOL (WINAPI *NOTIFICATIONUNLOCK)(HANDLE);
}

//---------------------------------------------------------------------------
//
//	O[o [N
//
//---------------------------------------------------------------------------
VM *pVM;								// Virtual Machine

//---------------------------------------------------------------------------
//
//	X^eBbN [N
//
//---------------------------------------------------------------------------
static CCriticalSection csect;			// VMbNpNeBJZNV
static BOOL bJapanese;					// {EpꔻʃtO
static BOOL bWinNT;						// WindowsNTEWindows9xʃtO
static BOOL bSupport932;				// CP932(SHIFT-JIS)T|[gtO
static BOOL bMMX;						// MMXʃtO
static BOOL bCMOV;						// CMOVʃtO
static LPSTR lpszInfoMsg;				// 񃁃bZ[Wobt@

//---------------------------------------------------------------------------
//
//	_Ci~bN[h֐
//
//---------------------------------------------------------------------------
static DRAWTEXTWIDE pDrawTextW;							// DrawTextW
static NOTIFYREGISTER pSHChangeNotifyRegister;			// SHChangeNotifyRegister
static NOTIFYDEREGISTER pSHChangeNotifyDeregister;		// SHChangeNotifyDeregister
static NOTIFICATIONLOCK pSHChangeNotification_Lock;		// SHChangeNotification_Lock
static NOTIFICATIONUNLOCK pSHChangeNotification_Unlock;	// SHChangeNotification_Unlock

//---------------------------------------------------------------------------
//
//	{̔
//
//---------------------------------------------------------------------------
BOOL FASTCALL IsJapanese(void)
{
	return bJapanese;
}

//---------------------------------------------------------------------------
//
//	WindowsNT̔
//
//---------------------------------------------------------------------------
BOOL FASTCALL IsWinNT(void)
{
	return bWinNT;
}

//---------------------------------------------------------------------------
//
//	CP932T|[g̔
//
//---------------------------------------------------------------------------
BOOL FASTCALL Support932(void)
{
	return bSupport932;
}

//---------------------------------------------------------------------------
//
//	MMX̔
//
//---------------------------------------------------------------------------
BOOL FASTCALL IsMMX(void)
{
	return bMMX;
}

//---------------------------------------------------------------------------
//
//	CMOV̔
//
//---------------------------------------------------------------------------
BOOL FASTCALL IsCMOV(void)
{
	return bCMOV;
}

//---------------------------------------------------------------------------
//
//	bZ[W擾
//
//---------------------------------------------------------------------------
void FASTCALL GetMsg(UINT uID, CString& string)
{
	// uID=0Ŕłꍇ
	if (uID == 0) {
		string.Empty();
		return;
	}

	// {ꂩ
	if (IsJapanese()) {
		if (!string.LoadString(uID)) {
#if defined(_DEBUG)
			TRACE(_T("GetMsg:񃍁[hɎs ID:%d\n"), uID);
#endif	// _DEBUG
			string.Empty();
		}
		return;
	}

	// pB+5000Ŏ
	if (string.LoadString(uID + 5000)) {
		return;
	}

	// +0łx
	if (!string.LoadString(uID)) {
#if defined(_DEBUG)
		TRACE(_T("GetMsg:񃍁[hɎs ID:%d\n"), uID);
#endif	// _DEBUG
		string.Empty();
	}
}

//---------------------------------------------------------------------------
//
//	z}V擾
//
//---------------------------------------------------------------------------
VM* FASTCALL GetVM(void)
{
	ASSERT(pVM);
	return pVM;
}

//---------------------------------------------------------------------------
//
//	z}VbN
//
//---------------------------------------------------------------------------
void FASTCALL LockVM(void)
{
	csect.Lock();
}

//---------------------------------------------------------------------------
//
//	z}VAbN
//
//---------------------------------------------------------------------------
void FASTCALL UnlockVM(void)
{
	csect.Unlock();
}

//---------------------------------------------------------------------------
//
//	t@CI[v_CAO
//	lpszPath͕KČĂяo
//
//---------------------------------------------------------------------------
BOOL FASTCALL FileOpenDlg(CWnd *pParent, LPSTR lpszPath, UINT nFilterID)
{
	OPENFILENAME ofn;
	TCHAR szFilter[0x200];
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];
	CString strFilter;
	int i;
	int nLen;
	WIN32_FIND_DATA wfd;
	HANDLE hFind;

	ASSERT(pParent);
	ASSERT(lpszPath);
	ASSERT(nFilterID);

	// \̂ݒ
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = pParent->m_hWnd;
	ofn.lpstrFilter = szFilter;
	ofn.lpstrFile = lpszPath;
	ofn.nMaxFile = _MAX_PATH;
	ofn.lpstrInitialDir = Filepath::GetDefaultDir();
	ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;

	// tB^ݒ
	GetMsg(nFilterID, strFilter);
	_tcscpy(szFilter, (LPCTSTR)strFilter);
	nLen = (int)_tcslen(szFilter);
	for (i=0; i<nLen; i++) {
		if (szFilter[i] == _T('|')) {
			szFilter[i] = _T('\0');
		}
	}

	// R_CAOs
	if (!GetOpenFileName(&ofn)) {
		return FALSE;
	}

	// ȃt@C𓾂(FindFirstFileœ̂̓t@C+gq̂)
	hFind = FindFirstFile(lpszPath, &wfd);
	FindClose(hFind);
	_tsplitpath(lpszPath, szDrive, szDir, NULL, NULL);
	_tcscpy(lpszPath, szDrive);
	_tcscat(lpszPath, szDir);
	_tcscat(lpszPath, wfd.cFileName);

	// ftHgfBNgۑ
	Filepath::SetDefaultDir(lpszPath);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	t@CZ[u_CAO
//	lpszPath͕KČĂяoƁBlpszExt͐擪3̂ݗL
//
//---------------------------------------------------------------------------
BOOL FASTCALL FileSaveDlg(CWnd *pParent, LPSTR lpszPath, LPCTSTR lpszExt, UINT nFilterID)
{
	OPENFILENAME ofn;
	TCHAR szFilter[0x200];
	CString strFilter;
	int i;
	int nLen;

	ASSERT(pParent);
	ASSERT(lpszPath);
	ASSERT(nFilterID);

	// \̂ݒ
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = pParent->m_hWnd;
	ofn.lpstrFilter = szFilter;
	ofn.lpstrFile = lpszPath;
	ofn.nMaxFile = _MAX_PATH;
	ofn.lpstrInitialDir = Filepath::GetDefaultDir();
	ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	ofn.lpstrDefExt = lpszExt;

	// tB^ݒ
	GetMsg(nFilterID, strFilter);
	_tcscpy(szFilter, (LPCTSTR)strFilter);
	nLen = (int)_tcslen(szFilter);
	for (i=0; i<nLen; i++) {
		if (szFilter[i] == _T('|')) {
			szFilter[i] = _T('\0');
		}
	}

	// R_CAOs
	if (!GetSaveFileName(&ofn)) {
		return FALSE;
	}

	// ftHgfBNgۑ
	Filepath::SetDefaultDir(lpszPath);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	񃁃bZ[Wݒ
//
//---------------------------------------------------------------------------
void FASTCALL SetInfoMsg(LPCTSTR lpszMsg, BOOL bRec)
{
	// LtO
	if (bRec) {
		// obt@AhXL
		lpszInfoMsg = (LPSTR)lpszMsg;
		return;
	}

	// obt@AhX^ĂȂ΁A
	if (!lpszInfoMsg) {
		return;
	}

	// obt@TCY`FbN
	if (_tcslen(lpszInfoMsg) < CInfo::InfoBufMax) {
		// ^ꂽRs[
		_tcscpy(lpszInfoMsg, lpszMsg);
	}
}

//---------------------------------------------------------------------------
//
//	DrawTextW
//	T|[gOSł́AȂ
//
//---------------------------------------------------------------------------
int FASTCALL DrawTextWide(HDC hDC, LPCWSTR lpString, int nCount, LPRECT lpRect, UINT uFormat)
{
	// T|[gĂ邩
	if (!pDrawTextW) {
		// Ȃ
		return 1;
	}

	// ChDraw
	return pDrawTextW(hDC, lpString, nCount, lpRect, uFormat);
}

//---------------------------------------------------------------------------
//
//	ShellChangeNotifyRegister
//	T|[gOSł́AȂ
//
//---------------------------------------------------------------------------
ULONG ShellChangeNotifyRegister(HWND hWnd, int fSrcs, LONG fEvents, UINT wMsg, int cEntries, SHChangeNotifyEntry *pfsne)
{
	// T|[gĂ邩
	if (!pSHChangeNotifyRegister) {
		// Ȃ
		return 1;
	}

	// Ăяo
	return pSHChangeNotifyRegister(hWnd, fSrcs, fEvents, wMsg, cEntries, pfsne);
}

//---------------------------------------------------------------------------
//
//	ShellChangeNotifyDeregister
//	T|[gOSł́AȂ
//
//---------------------------------------------------------------------------
BOOL ShellChangeNotifyDeregister(ULONG ulID)
{
	// T|[gĂ邩
	if (!pSHChangeNotifyDeregister) {
		// Ȃ
		return TRUE;
	}

	// Ăяo
	return pSHChangeNotifyDeregister(ulID);
}

//---------------------------------------------------------------------------
//
//	ShellChangeNotification_Lock
//	T|[gOSł́AȂ
//
//---------------------------------------------------------------------------
HANDLE ShellChangeNotification_Lock(HANDLE hChange, DWORD dwId, LPITEMIDLIST **pppidl, LONG *plEvent)
{
	// T|[gĂ邩
	if (!pSHChangeNotification_Lock) {
		// Ȃ
		return INVALID_HANDLE_VALUE;
	}

	// Ăяo
	return pSHChangeNotification_Lock(hChange, dwId, pppidl, plEvent);
}

//---------------------------------------------------------------------------
//
//	ShellChangeNotification_Unlock
//	T|[gOSł́AȂ
//
//---------------------------------------------------------------------------
BOOL ShellChangeNotification_Unlock(HANDLE hLock)
{
	// T|[gĂ邩
	if (!pSHChangeNotification_Unlock) {
		// Ȃ
		return TRUE;
	}

	// Ăяo
	return pSHChangeNotification_Unlock(hLock);
}

//===========================================================================
//
//	AvP[V
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CApp::CApp() : CWinApp(_T("XM6"))
{
	m_hMutex = NULL;
	m_hUser32 = NULL;
	m_hShell32 = NULL;
}

//---------------------------------------------------------------------------
//
//	CX^X
//
//---------------------------------------------------------------------------
BOOL CApp::InitInstance()
{
	CFrmWnd *pFrmWnd;

	// {NX
	if (!CWinApp::InitInstance()) {
		return FALSE;
	}

	// ftHgfBNgNA
	Filepath::ClearDefaultDir();

	// 
	if (!CheckEnvironment()) {
		return FALSE;
	}

	// VFAPĨ[h
	LoadShellAPI();

	// dN`FbN
	if (!CheckMutex()) {
		// R}hC΁An
		if (m_lpCmdLine[0] != _T('\0')) {
			SendCmd();
		}
		return FALSE;
	}

	// CEChE쐬(m_pMainWnd֑)
	pFrmWnd = new CFrmWnd();
	m_pMainWnd = (CWnd*)pFrmWnd;

	// 
	if (!pFrmWnd->Init()) {
		return FALSE;
	}

	// \
	pFrmWnd->ShowWindow(m_nCmdShow);
	pFrmWnd->UpdateWindow();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	CX^XI
//
//---------------------------------------------------------------------------
BOOL CApp::ExitInstance()
{
	// Mutex폜
	if (m_hMutex) {
		::CloseHandle(m_hMutex);
		m_hMutex = NULL;
	}

	// SHELL32.DLL
	if (m_hShell32) {
		pSHChangeNotifyRegister = NULL;
		pSHChangeNotifyDeregister = NULL;
		pSHChangeNotification_Lock = NULL;
		pSHChangeNotification_Unlock = NULL;
		::FreeLibrary(m_hShell32);
		m_hShell32 = NULL;
	}

	// USER32.DLL
	if (m_hUser32) {
		pDrawTextW = NULL;
		::FreeLibrary(m_hUser32);
		m_hUser32 = NULL;
	}

	// {NX
	return CWinApp::ExitInstance();
}

//---------------------------------------------------------------------------
//
//	Mutex`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CApp::CheckMutex()
{
	HANDLE hMutex;

	ASSERT(this);

	// Lɂ炸A쐬
	hMutex = ::CreateMutex(NULL, TRUE, _T("XM6"));
	if (hMutex) {
		// ɋNH
		if (::GetLastError() == ERROR_ALREADY_EXISTS) {
			return FALSE;
		}

		// OK
		m_hMutex = hMutex;
		return TRUE;
	}

	// Ȃs
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	̔
//
//---------------------------------------------------------------------------
BOOL FASTCALL CApp::CheckEnvironment()
{
	LANGID langID;
	OSVERSIONINFO ovi;
	CString strError;

	ASSERT(this);

	//
	//	OS̔
	//

	// {̔
	::bJapanese = FALSE;

	// ID擾(GetUserDefaultUILanguagegp)
	langID = GetUserLangID();
	if (PRIMARYLANGID(langID) == LANG_JAPANESE) {
		::bJapanese = TRUE;
	}

	// WindowsNT̔
	memset(&ovi, 0, sizeof(ovi));
	ovi.dwOSVersionInfoSize = sizeof(ovi);
	VERIFY(::GetVersionEx(&ovi));
	if (ovi.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		::bWinNT = TRUE;
	}
	else {
		::bWinNT = FALSE;
	}

	// R[hy[W932T|[g̔(UNICODET|[gO)
	::bSupport932 = FALSE;
	::pDrawTextW = NULL;
	if (::bWinNT) {
		// UNICODET|[gOS
		if (::IsValidCodePage(932)) {
			// USER32.DLL[h
			m_hUser32 = ::LoadLibrary(_T("USER32.DLL"));
			if (m_hUser32) {
				// DrawTextW̃AhX𓾂
				pDrawTextW = (DRAWTEXTWIDE)::GetProcAddress(m_hUser32, _T("DrawTextW"));
				if (pDrawTextW) {
					// CP932ւ̕ϊƕ\\
					::bSupport932 = TRUE;
				}
			}
		}
	}

	//
	//	vZbT̔
	//

	// CMOV̔
	::bCMOV = FALSE;
	if (::IsCMOVSupport()) {
		::bCMOV = TRUE;
	}

	// MMX̔(Windows98ȍ~̂)
	::bMMX = FALSE;
	if (ovi.dwMajorVersion >= 4) {
		// Windows95 or WindowsNT4 ȍ~
		if ((ovi.dwMajorVersion == 4) && (ovi.dwMinorVersion == 0)) {
			// Windows95 or WindowsNT4
			::bMMX = FALSE;
		}
		else {
			// vZbTɂ
			::bMMX = ::IsMMXSupport();
		}
	}

	// version2.05ACMOV,MMXƂK{
	if (!::bCMOV || !::bMMX) {
		::GetMsg(IDS_PROCESSOR ,strError);
		AfxMessageBox(strError, MB_ICONSTOP | MB_OK);
		return FALSE;
	}

	// ׂOK
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ID擾
//	Platform SDK̃o[WɈˑ邽
//
//---------------------------------------------------------------------------
LANGID FASTCALL CApp::GetUserLangID()
{
	HMODULE hModule;
	LANGID langID;
	GETUSERUILANG pGetUserDefaultUILang;
	BOOL bSuccess;

	ASSERT(this);

	// tOOFFAID
	bSuccess = FALSE;
	langID = LANG_JAPANESE;

	// [h
	hModule = ::LoadLibrary(_T("KERNEL32.DLL"));
	if (hModule) {
		// AhX擾
		pGetUserDefaultUILang = (GETUSERUILANG)::GetProcAddress(hModule, _T("GetUserDefaultUILanguage"));
		if (pGetUserDefaultUILang) {
			// 擾
			langID = pGetUserDefaultUILang();
			bSuccess = TRUE;
		}

		// W[
		::FreeLibrary(hModule);
		hModule = NULL;
	}

	// ꎸsꍇAȑOT|[gĂAPIg
	if (!bSuccess) {
		langID = GetUserDefaultLangID();
	}

	return langID;
}

//---------------------------------------------------------------------------
//
//	VFAPĨ[h
//	SHELL32.DLL̃o[WAPlatform SDK̃o[WɈˑ邽
//
//---------------------------------------------------------------------------
void FASTCALL CApp::LoadShellAPI()
{
	ASSERT(this);
	ASSERT(!m_hShell32);

	// 
	::pSHChangeNotifyRegister = NULL;
	::pSHChangeNotifyDeregister = NULL;
	::pSHChangeNotification_Lock = NULL;
	::pSHChangeNotification_Unlock = NULL;

	// [h
	m_hShell32 = ::LoadLibrary(_T("SHELL32.DLL"));
	if (!m_hShell32) {
		// [hłȂ͂͂Ȃ
		ASSERT(FALSE);
		return;
	}

	// lgpāA֐|C^𓾂(NULLł܂Ȃ)
	::pSHChangeNotifyRegister = (NOTIFYREGISTER)::GetProcAddress(m_hShell32, MAKEINTRESOURCE(2));
	::pSHChangeNotifyDeregister = (NOTIFYDEREGISTER)::GetProcAddress(m_hShell32, MAKEINTRESOURCE(4));
	::pSHChangeNotification_Lock = (NOTIFICATIONLOCK)::GetProcAddress(m_hShell32, MAKEINTRESOURCE(644));
	::pSHChangeNotification_Unlock = (NOTIFICATIONUNLOCK)::GetProcAddress(m_hShell32, MAKEINTRESOURCE(645));
}

//---------------------------------------------------------------------------
//
//	R}hCM
//
//---------------------------------------------------------------------------
void FASTCALL CApp::SendCmd()
{
	HWND hWnd;
	COPYDATASTRUCT cds;

	ASSERT(this);

	// EBhE
	hWnd = SearchXM6Wnd();
	if (!hWnd) {
		return;
	}

	// WM_COPYDATAőM
	memset(&cds, 0, sizeof(cds));
	cds.dwData = WM_COPYDATA;
	cds.cbData = ((DWORD)_tcslen(m_lpCmdLine) + 1) * sizeof(TCHAR);
	cds.lpData = m_lpCmdLine;
	::SendMessage(hWnd, WM_COPYDATA, NULL, (LPARAM)&cds);
}

//---------------------------------------------------------------------------
//
//	XM6EBhE
//
//---------------------------------------------------------------------------
HWND FASTCALL CApp::SearchXM6Wnd()
{
	HWND hWnd;

	// EBhENULL
	hWnd = NULL;

	// 
	::EnumWindows(EnumXM6Proc, (LPARAM)&hWnd);

	// R[obN֐Ōʂ
	return hWnd;
}

//---------------------------------------------------------------------------
//
//	XM6EBhER[obN
//
//---------------------------------------------------------------------------
BOOL CALLBACK CApp::EnumXM6Proc(HWND hWnd, LPARAM lParam)
{
	HWND *phWnd;
	LONG lUser;

	// p[^󂯎
	phWnd = (HWND*)lParam;
	ASSERT(phWnd);
	ASSERT(*phWnd == NULL);

	// YEBhẼ[Uf[^𓾂
	lUser = ::GetWindowLong(hWnd, GWL_USERDATA);

	// XM6`FbNs
	if (lUser == (LONG)MAKEID('X', 'M', '6', ' ')) {
		// XM6t[EBhEƔ肵Ał؂
		*phWnd = hWnd;
		return FALSE;
	}

	// Ă̂ő
	return TRUE;
}

#endif	// _WIN32
