//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC RtBO ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_cfg_h)
#define mfc_cfg_h

#include "config.h"
#include "ppi.h"

//===========================================================================
//
//	RtBO
//
//===========================================================================
class CConfig : public CComponent
{
public:
	// {t@NV
	CConfig(CFrmWnd *pWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv

	// ݒf[^(S)
	void FASTCALL GetConfig(Config *pConfigBuf) const;
										// ݒf[^擾
	void FASTCALL SetConfig(Config *pConfigBuf);
										// ݒf[^ݒ

	// ݒf[^()
	void FASTCALL SetStretch(BOOL bStretch);
										// ʊgݒ
	void FASTCALL SetMIDIDevice(int nDevice, BOOL bIn);
										// MIDIfoCXݒ

	// MRU
	void FASTCALL SetMRUFile(int nType, LPCTSTR pszFile);
										// MRUt@Cݒ(łV)
	void FASTCALL GetMRUFile(int nType, int nIndex, LPTSTR pszFile) const;
										// MRUt@C擾
	int FASTCALL GetMRUNum(int nType) const;
										// MRUt@C擾

	// Z[uE[h
	BOOL FASTCALL Save(Fileio *pFio, int nVer);
										// Z[u
	BOOL FASTCALL Load(Fileio *pFio, int nVer);
										// [h
	BOOL FASTCALL IsApply();
										// Kp邩

private:
	// ݒf[^
	typedef struct _INIKEY {
		void *pBuf;						// |C^
		LPCTSTR pszSection;				// ZNV
		LPCTSTR pszKey;					// L[
		int nType;						// ^
		int nDef;						// ftHgl
		int nMin;						// ŏl(ꕔ^Cv̂)
		int nMax;						// ől(ꕔ̂)
	} INIKEY, *PINIKEY;

	// INIt@C
	TCHAR m_IniFile[FILEPATH_MAX];
										// INIt@C

	// ݒf[^
	void FASTCALL LoadConfig();
										// ݒf[^[h
	void FASTCALL SaveConfig() const;
										// ݒf[^Z[u
	static const INIKEY IniTable[];
										// ݒf[^INIe[u
	static Config m_Config;
										// ݒf[^

	// o[W݊
	void FASTCALL ResetSASI();
										// SASIĐݒ
	void FASTCALL ResetCDROM();
										// CD-ROMĐݒ
	static BOOL m_bCDROM;
										// CD-ROML

	// MRU
	enum {
		MruTypes = 5					// MRU^Cv
	};
	void FASTCALL ClearMRU(int nType);
										// MRUNA
	void FASTCALL LoadMRU(int nType);
										// MRU[h
	void FASTCALL SaveMRU(int nType) const;
										// MRUZ[u
	TCHAR m_MRUFile[MruTypes][9][FILEPATH_MAX];
										// MRUt@C
	int m_MRUNum[MruTypes];
										// MRU

	// L[
	void FASTCALL LoadKey() const;
										// L[[h
	void FASTCALL SaveKey() const;
										// L[Z[u

	// TrueKey
	void FASTCALL LoadTKey() const;
										// TrueKey[h
	void FASTCALL SaveTKey() const;
										// TrueKeyZ[u

	// o[W݊
	BOOL FASTCALL Load200(Fileio *pFio);
										// version2.00`version2.01
	BOOL FASTCALL Load202(Fileio *pFio);
										// version2.02`version2.03
	BOOL FASTCALL Load204(Fileio *pFio);
										// version2.04`version2.05

	// [hEZ[u
	BOOL m_bApply;
										// [hApplyCfgv
};

//---------------------------------------------------------------------------
//
//	NXs`
//
//---------------------------------------------------------------------------
class CConfigSheet;

//===========================================================================
//
//	RtBOvpeBy[W
//
//===========================================================================
class CConfigPage : public CPropertyPage
{
public:
	CConfigPage();
										// RXgN^
	void FASTCALL Init(CConfigSheet *pSheet);
										// 
	virtual BOOL OnInitDialog();
										// _CAO
	virtual BOOL OnSetActive();
										// y[WANeBu
	DWORD FASTCALL GetID() const		{ return m_dwID; }
										// ID擾

protected:
	afx_msg BOOL OnSetCursor(CWnd *pWnd, UINT nHitTest, UINT nMsg);
										// }EXJ[\ݒ
	Config *m_pConfig;
										// ݒf[^
	DWORD m_dwID;
										// y[WID
	int m_nTemplate;
										// ev[gID
	UINT m_uHelpID;
										// wvID
	UINT m_uMsgID;
										// wvbZ[WID
	CConfigSheet *m_pSheet;
										// vpeBV[g

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	{y[W
//
//===========================================================================
class CBasicPage : public CConfigPage
{
public:
	CBasicPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 

protected:
	afx_msg void OnMPUFull();
										// MPUtXs[h

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	TEhy[W
//
//===========================================================================
class CSoundPage : public CConfigPage
{
public:
	CSoundPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 

protected:
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pBar);
										// cXN[
	afx_msg void OnSelChange();
										// R{{bNXύX

private:
	void FASTCALL EnableControls(BOOL bEnable);
										// Rg[ԕύX
	BOOL m_bEnableCtrl;
										// Rg[
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	ʃy[W
//
//===========================================================================
class CVolPage : public CConfigPage
{
public:
	CVolPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	void OnCancel();
										// LZ

protected:
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar);
										// XN[
	afx_msg void OnFMCheck();
										// FM`FbN
	afx_msg void OnADPCMCheck();
										// ADPCM`FbN
#if _MFC_VER >= 0x700
	afx_msg void OnTimer(UINT_PTR nTimerID);
										// ^C}
#else
	afx_msg void OnTimer(UINT nTimerID);
										// ^C}
#endif	// _MFC_VER

private:
	CSound *m_pSound;
										// TEh
	OPMIF *m_pOPMIF;
										// OPMC^tF[X
	ADPCM *m_pADPCM;
										// ADPCM
	CMIDI *m_pMIDI;
										// MIDI
#if _MFC_VER >= 0x700
	UINT_PTR m_nTimerID;
										// ^C}ID
#else
	UINT m_nTimerID;
										// ^C}ID
#endif	// _MFC_VER
	int m_nMasterVol;
										// }X^[
	int m_nMasterOrg;
										// }X^[ʃIWi
	int m_nMIDIVol;
										// MIDI
	int m_nMIDIOrg;
										// MIDIʃIWi

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	L[{[hy[W
//
//===========================================================================
class CKbdPage : public CConfigPage
{
public:
	CKbdPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	void OnCancel();
										// LZ

protected:
	afx_msg void OnEdit();
										// ҏW
	afx_msg void OnDefault();
										// ftHg
	afx_msg void OnClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JNbN
	afx_msg void OnRClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JENbN
	afx_msg void OnConnect();
										// ڑ
	afx_msg void OnDrawItem(int nID, LPDRAWITEMSTRUCT lpdis);
										// I[i[h[

private:
	void FASTCALL UpdateReport();
										// |[gXV
	void FASTCALL EnableControls(BOOL bEnable);
										// Rg[ԕύX
	DWORD m_dwEdit[0x100];
										// GfBbg
	DWORD m_dwBackup[0x100];
										// obNAbv
	CInput *m_pInput;
										// CInput
	BOOL m_bEnableCtrl;
										// Rg[
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	L[{[h}bvҏW_CAO
//
//===========================================================================
class CKbdMapDlg : public CDialog
{
public:
	CKbdMapDlg(CWnd *pParent, DWORD *pMap);
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// OK
	void OnCancel();
										// LZ

protected:
	afx_msg void OnPaint();
										// _CAO`
	afx_msg LONG OnKickIdle(UINT uParam, LONG lParam);
										// ACh
	afx_msg LONG OnApp(UINT uParam, LONG lParam);
										// [U(ʃEBhE̒ʒm)

private:
	void FASTCALL OnDraw(CDC *pDC);
										// `Tu
	CRect m_rectStat;
										// Xe[^X`
	CString m_strStat;
										// Xe[^XbZ[W
	CString m_strGuide;
										// KChbZ[W
	CWnd *m_pDispWnd;
										// CKeyDispWnd
	CInput *m_pInput;
										// CInput
	DWORD *m_pEditMap;
										// ҏW̃}bv

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	L[̓_CAO
//
//===========================================================================
class CKeyinDlg : public CDialog
{
public:
	CKeyinDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// OK
	UINT m_nTarget;
										// ^[QbgL[
	UINT m_nKey;
										// 蓖ăL[

protected:
	afx_msg void OnPaint();
										// `
	afx_msg UINT OnGetDlgCode();
										// _CAOR[h擾
	afx_msg LONG OnKickIdle(UINT uParam, LONG lParam);
										// ACh
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
										// ENbN

private:
	void FASTCALL OnDraw(CDC *pDC);
										// `Tu
	CInput *m_pInput;
										// CInput
	BOOL m_bKey[0x100];
										// L[Lp
	CRect m_GuideRect;
										// KCh`
	CString m_GuideString;
										// KCh
	CRect m_AssignRect;
										// L[蓖ċ`
	CString m_AssignString;
										// L[蓖ĕ
	CRect m_KeyRect;
										// L[`
	CString m_KeyString;
										// L[

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	}EXy[W
//
//===========================================================================
class CMousePage : public CConfigPage
{
public:
	CMousePage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 

protected:
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar);
										// XN[
	afx_msg void OnPort();
										// |[gI

private:
	void FASTCALL EnableControls(BOOL bEnable);
										// Rg[ԕύX
	BOOL m_bEnableCtrl;
										// Rg[
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	WCXeBbNy[W
//
//===========================================================================
class CJoyPage : public CConfigPage
{
public:
	CJoyPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	void OnCancel();
										// LZ

protected:
	BOOL OnCommand(WPARAM wParam, LPARAM lParam);
										// R}hʒm

private:
	void FASTCALL OnSelChg(CComboBox* pComboBox);
										// R{{bNXύX
	void FASTCALL OnDetail(UINT nButton);
										// ڍ
	void FASTCALL OnSetting(UINT nButton);
										// ݒ
	CButton* GetCorButton(UINT nComboBox);
										// Ή{^擾
	CComboBox* GetCorCombo(UINT nButton);
										// ΉR{{bNX擾
	CInput *m_pInput;
										// CInput
	static UINT ControlTable[];
										// Rg[e[u
};

//===========================================================================
//
//	WCXeBbNڍ׃_CAO
//
//===========================================================================
class CJoyDetDlg : public CDialog
{
public:
	CJoyDetDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// 

	CString m_strDesc;
										// foCX
	int m_nPort;
										// |[gԍ(0 or 1)
	int m_nType;
										// ^Cv(0`12)
};

//===========================================================================
//
//	{^ݒy[W
//
//===========================================================================
class CBtnSetPage : public CPropertyPage
{
public:
	CBtnSetPage();
										// RXgN^
	void FASTCALL Init(CPropertySheet *pSheet);
										// 쐬
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	void OnCancel();
										// LZ
	int m_nJoy;
										// WCXeBbNԍ(0 or 1)
	int m_nType[PPI::PortMax];
										// WCXeBbN^Cv(0`12)

protected:
	afx_msg void OnPaint();
										// _CAO`
#if _MFC_VER >= 0x700
	afx_msg void OnTimer(UINT_PTR nTimerID);
										// ^C}
#else
	afx_msg void OnTimer(UINT nTimerID);
										// ^C}
#endif	// _MFC_VER
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar);
										// XN[
	BOOL OnCommand(WPARAM wParam, LPARAM lParam);
										// R}hʒm

private:
	enum CtrlType {
		BtnLabel,						// x({^n)
		BtnCombo,						// R{{bNX
		BtnRapid,						// A˃XC_
		BtnValue						// A˃x
	};
	void FASTCALL OnDraw(CDC *pDC, BOOL *pButton, BOOL bForce);
										// `惁C
	void FASTCALL OnSlider(int nButton);
										// XC_ύX
	void FASTCALL OnSelChg(int nButton);
										// R{{bNXύX
	void FASTCALL GetButtonDesc(const char *pszDesc, CString &strDesc);
										// {^\擾
	UINT FASTCALL GetControl(int nButton, CtrlType ctlType) const;
										// Rg[ID擾
	CPropertySheet *m_pSheet;
										// eV[g
	CInput *m_pInput;
										// CInput
	CRect m_rectLabel[12];
										// xʒu
	BOOL m_bButton[12];
										// {^L
#if _MFC_VER >= 0x700
	UINT_PTR m_nTimerID;
										// ^C}ID
#else
	UINT m_nTimerID;
										// ^C}ID
#endif	// _MFC_VER
	static const UINT ControlTable[];
										// Rg[e[u
	static const int RapidTable[];
										// A˃e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	WCXeBbNvpeBV[g
//
//===========================================================================
class CJoySheet : public CPropertySheet
{
public:
	CJoySheet(CWnd *pParent);
										// RXgN^
	void FASTCALL SetParam(int nJoy, int nCombo, int nType[]);
										// p[^ݒ
	void FASTCALL InitSheet();
										// V[g
	int FASTCALL GetAxes() const;
										// 擾
	int FASTCALL GetButtons() const;
										// {^擾

private:
	CBtnSetPage m_BtnSet;
										// {^ݒy[W
	CInput *m_pInput;
										// CInput
	int m_nJoy;
										// WCXeBbNԍ(0 or 1)
	int m_nCombo;
										// R{{bNXI
	int m_nType[PPI::PortMax];
										// VM^CvI
	DIDEVCAPS m_DevCaps;
										// foCXCaps
};

//===========================================================================
//
//	SASIy[W
//
//===========================================================================
class CSASIPage : public CConfigPage
{
public:
	CSASIPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	BOOL OnSetActive();
										// y[WANeBu
	int FASTCALL GetDrives(const Config *pConfig) const;
										// SASIhCu擾

protected:
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pBar);
										// cXN[
	afx_msg void OnClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JNbN

private:
	void FASTCALL UpdateList();
										// XgRg[XV
	void FASTCALL CheckSASI(DWORD *pDisk);
										// SASIt@C`FbN
	void FASTCALL EnableControls(BOOL bEnable, BOOL bDrive = TRUE);
										// Rg[ԕύX
	SASI *m_pSASI;
										// SASI
	BOOL m_bInit;
										// tO
	int m_nDrives;
										// hCu
	TCHAR m_szFile[16][FILEPATH_MAX];
										// SASIn[hfBXNt@C
	CString m_strError;
										// G[

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	SxSIy[W
//
//===========================================================================
class CSxSIPage : public CConfigPage
{
public:
	CSxSIPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	BOOL OnSetActive();
										// y[WANeBu
	void OnOK();
										// 
	int FASTCALL GetDrives(const Config *pConfig) const;
										// SxSIhCu擾

protected:
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pBar);
										// cXN[
	afx_msg void OnClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JNbN
	afx_msg void OnCheck();
										// `FbN{bNXNbN

private:
	enum DevType {
		DevSASI,						// SASI n[hfBXNhCu
		DevSCSI,						// SCSI n[hfBXNhCu
		DevMO,							// SCSI MOhCu
		DevInit,						// SCSI CjVG[^(zXg)
		DevNone							// foCXȂ
	};
	void FASTCALL UpdateList();
										// XgRg[XV
	void FASTCALL BuildMap();
										// foCX}bv쐬
	int FASTCALL CheckSCSI(int nDrive);
										// SCSIfoCX`FbN
	void FASTCALL EnableControls(BOOL bEnable, BOOL bDrive = TRUE);
										// Rg[ԕύX
	BOOL m_bInit;
										// tO
	int m_nSASIDrives;
										// SASIhCu
	DevType m_DevMap[8];
										// foCX}bv
	TCHAR m_szFile[6][FILEPATH_MAX];
										// SCSIn[hfBXNt@C
	CString m_strSASI;
										// SASI HD
	CString m_strMO;
										// SCSI MO
	CString m_strInit;
										// CjVG[^
	CString m_strNone;
										// n/a
	CString m_strError;
										// foCXG[
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	SCSIy[W
//
//===========================================================================
class CSCSIPage : public CConfigPage
{
public:
	CSCSIPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	int FASTCALL GetInterface(const Config *pConfig) const;
										// C^tF[Xʎ擾

protected:
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pBar);
										// cXN[
	afx_msg void OnClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JNbN
	afx_msg void OnButton();
										// WI{^I
	afx_msg void OnCheck();
										// `FbN{bNXNbN

private:
	enum DevType {
		DevSCSI,						// SCSI n[hfBXNhCu
		DevMO,							// SCSI MOhCu
		DevCD,							// SCSI CD-ROMhCu
		DevInit,						// SCSI CjVG[^(zXg)
		DevNone							// foCXȂ
	};
	int FASTCALL GetIfCtrl() const;
										// C^tF[Xʎ擾(Rg[)
	BOOL FASTCALL CheckROM(int nType) const;
										// ROM`FbN
	void FASTCALL UpdateList();
										// XgRg[XV
	void FASTCALL BuildMap();
										// foCX}bv쐬
	int FASTCALL CheckSCSI(int nDrive);
										// SCSIfoCX`FbN
	void FASTCALL EnableControls(BOOL bEnable, BOOL bDrive = TRUE);
										// Rg[ԕύX
	SCSI *m_pSCSI;
										// SCSIfoCX
	BOOL m_bInit;
										// tO
	int m_nDrives;
										// hCu
	BOOL m_bMOFirst;
										// MO擪tO
	DevType m_DevMap[8];
										// foCX}bv
	TCHAR m_szFile[5][FILEPATH_MAX];
										// SCSIn[hfBXNt@C
	CString m_strMO;
										// SCSI MO
	CString m_strCD;
										// SCSI CD
	CString m_strInit;
										// CjVG[^
	CString m_strNone;
										// n/a
	CString m_strError;
										// foCXG[
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	|[gy[W
//
//===========================================================================
class CPortPage : public CConfigPage
{
public:
	CPortPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
};

//===========================================================================
//
//	MIDIy[W
//
//===========================================================================
class CMIDIPage : public CConfigPage
{
public:
	CMIDIPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 
	void OnCancel();
										// LZ

protected:
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar);
										// cXN[
	afx_msg void OnBIDClick();
										// {[hIDNbN

private:
	void FASTCALL EnableControls(BOOL bEnable);
										// Rg[ԕύX
	CMIDI *m_pMIDI;
										// MIDIR|[lg
	BOOL m_bEnableCtrl;
										// Rg[
	int m_nInDelay;
										// InfBC(ms)
	int m_nOutDelay;
										// OutfBC(ms)
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	y[W
//
//===========================================================================
class CAlterPage : public CConfigPage
{
public:
	CAlterPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	BOOL OnKillActive();
										// y[Wړ
	BOOL FASTCALL HasParity(const Config *pConfig) const;
										// SASIpeB@\`FbN

protected:
	void DoDataExchange(CDataExchange *pDX);
										// f[^

private:
	BOOL m_bInit;
										// 
	BOOL m_bParity;
										// peB
};

//===========================================================================
//
//	TrueKey̓_CAO
//
//===========================================================================
class CTKeyDlg : public CDialog
{
public:
	CTKeyDlg(CWnd *pParent);
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// OK
	void OnCancel();
										// LZ
	int m_nTarget;
										// ^[QbgL[
	int m_nKey;
										// 蓖ăL[

protected:
	afx_msg void OnPaint();
										// `
	afx_msg UINT OnGetDlgCode();
										// _CAOR[h擾
#if _MFC_VER >= 0x700
	afx_msg void OnTimer(UINT_PTR nTimerID);
										// ^C}
#else
	afx_msg void OnTimer(UINT nTimerID);
										// ^C}
#endif	// _MFC_VER
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
										// ENbN

private:
	void FASTCALL OnDraw(CDC *pDC);
										// `惁C
#if _MFC_VER >= 0x700
	UINT_PTR m_nTimerID;
										// ^C}ID
#else
	UINT m_nTimerID;
										// ^C}ID
#endif	// _MFC_VER
	BYTE m_KeyState[0x100];
										// VKL[
	CTKey *m_pTKey;
										// TrueKey
	CRect m_rectGuide;
										// KCh`
	CString m_strGuide;
										// KCh
	CRect m_rectAssign;
										// L[蓖ċ`
	CString m_strAssign;
										// L[蓖ĕ
	CRect m_rectKey;
										// L[`
	CString m_strKey;
										// L[

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	TrueKeyy[W
//
//===========================================================================
class CTKeyPage : public CConfigPage
{
public:
	CTKeyPage();
										// RXgN^
	BOOL OnInitDialog();
										// 
	void OnOK();
										// 

protected:
	afx_msg void OnSelChange();
										// R{{bNXύX
	afx_msg void OnClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JNbN
	afx_msg void OnRClick(NMHDR *pNMHDR, LRESULT *pResult);
										// JENbN

private:
	void FASTCALL EnableControls(BOOL bEnable);
										// Rg[ԕύX
	void FASTCALL UpdateReport();
										// |[gXV
	BOOL m_bEnableCtrl;
										// Rg[LtO
	CInput *m_pInput;
										// CInput
	CTKey *m_pTKey;
										// TrueKey
	int m_nKey[0x73];
										// ҏW̕ϊe[u
	static const UINT ControlTable[];
										// Rg[e[u

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	W[y[W
//
//===========================================================================
class CResumePage : public CConfigPage
{
public:
	CResumePage();
										// RXgN^

protected:
	void DoDataExchange(CDataExchange *pDX);
										// f[^
};

//===========================================================================
//
//	xȐݒy[W
//
//===========================================================================
class CAdvancePage : public CConfigPage
{
public:
	CAdvancePage();
										// RXgN^

protected:
	void DoDataExchange(CDataExchange *pDX);
										// f[^
};

//===========================================================================
//
//	̑y[W
//
//===========================================================================
class CMiscPage : public CConfigPage
{
public:
	CMiscPage();
										// RXgN^

protected:
	void DoDataExchange(CDataExchange *pDX);
										// f[^
};

//===========================================================================
//
//	RtBOvpeBV[g
//
//===========================================================================
class CConfigSheet : public CPropertySheet
{
public:
	CConfigSheet(CWnd *pParent);
										// RXgN^
	Config *m_pConfig;
										// ݒf[^
	CConfigPage* FASTCALL SearchPage(DWORD dwID) const;
										// y[W

protected:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EBhE쐬
	afx_msg void OnDestroy();
										// EBhE폜
#if _MFC_VER >= 0x700
	afx_msg void OnTimer(UINT_PTR nTimerID);
										// ^C}
#else
	afx_msg void OnTimer(UINT nTimerID);
										// ^C}
#endif	// _MFC_VER

private:
	CFrmWnd *m_pFrmWnd;
										// t[EBhE
#if _MFC_VER >= 0x700
	UINT_PTR m_nTimerID;
										// ^C}ID
#else
	UINT m_nTimerID;
										// ^C}ID
#endif	// _MFC_VER

	CBasicPage m_Basic;
										// {
	CSoundPage m_Sound;
										// TEh
	CVolPage m_Vol;
										// 
	CKbdPage m_Kbd;
										// L[{[h
	CMousePage m_Mouse;
										// }EX
	CJoyPage m_Joy;
										// WCXeBbN
	CSASIPage m_SASI;
										// SASI
	CSxSIPage m_SxSI;
										// SxSI
	CSCSIPage m_SCSI;
										// SCSI
	CPortPage m_Port;
										// |[g
	CMIDIPage m_MIDI;
										// MIDI
	CAlterPage m_Alter;
										// 
	CTKeyPage m_TKey;
										// TrueKey
	CResumePage m_Resume;
										// W[
	CAdvancePage m_Advance;
										// xȐݒ
	CMiscPage m_Misc;
										// ̑

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

#endif	// mfc_cfg_h
#endif	// _WIN32
