//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TuEBhE(CPU) ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "cpu.h"
#include "memory.h"
#include "schedule.h"
#include "mfp.h"
#include "scc.h"
#include "dmac.h"
#include "iosc.h"
#include "render.h"
#include "mfc_sub.h"
#include "mfc_draw.h"
#include "mfc_res.h"
#include "mfc_cpu.h"

//---------------------------------------------------------------------------
//
//	cpudebug.cƂ̘A
//
//---------------------------------------------------------------------------
#if defined(__cplusplus)
extern "C" {
#endif	// __cplusplus

void cpudebug_disassemble(int n);
										// 1stAZu
extern void (*cpudebug_put)(const char*);
										// 1so
extern DWORD debugpc;
										// tAZuPC

#if defined(__cplusplus)
}
#endif	// __cplusplus

static char debugbuf[0x200];
										// o̓obt@

//===========================================================================
//
//	qXgt_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CHistoryDlg::CHistoryDlg(UINT nID, CWnd *pParentWnd) : CDialog(nID, pParentWnd)
{
	// 
	m_dwValue = 0;
	m_nBit = 32;
}

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CHistoryDlg::OnInitDialog()
{
	int i;
	int nNum;
	DWORD *pData;
	CString strText;
	CComboBox *pComboBox;

	// {NX
	if (!CDialog::OnInitDialog()) {
		return FALSE;
	}

	// }XN
	m_dwMask = 0;
	for (i=0; i<(int)m_nBit; i++) {
		m_dwMask <<= 1;
		m_dwMask |= 0x01;
	}

	// R{{bNXNA
	pComboBox = (CComboBox*)GetDlgItem(IDC_ADDR_ADDRE);
	ASSERT(pComboBox);
	pComboBox->ResetContent();

	// R{{bNXǉ
	nNum = *(int *)GetNumPtr();
	pData = GetDataPtr();
	for (i=0; i<nNum; i++) {
		if (pData[i] > m_dwMask) {
			// }XN傫̂ŁAꗥ32bitOK
			strText.Format(_T("%08X"), pData[i]);
		}
		else {
			// }XNȉ
			switch (m_nBit) {
				case 8:
					strText.Format(_T("%02X"), pData[i]);
					break;
				case 16:
					strText.Format(_T("%04X"), pData[i]);
					break;
				case 24:
					strText.Format(_T("%06X"), pData[i]);
					break;
				default:
					strText.Format(_T("%08X"), pData[i]);
					break;
			}
		}
		// ǉ
		pComboBox->AddString(strText);
	}

	// dwValue͕K}XN
	m_dwValue &= m_dwMask;
	switch (m_nBit) {
		case 8:
			strText.Format(_T("%02X"), m_dwValue);
			break;
		case 16:
			strText.Format(_T("%04X"), m_dwValue);
			break;
		case 24:
			strText.Format(_T("%06X"), m_dwValue);
			break;
		default:
			strText.Format(_T("%08X"), m_dwValue);
			break;
	}
	pComboBox->SetWindowText(strText);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	_CAOOK
//
//---------------------------------------------------------------------------
void CHistoryDlg::OnOK()
{
	CComboBox *pComboBox;
	CString strText;
	int i;
	int nHit;
	int nNum;
	DWORD *pData;

	// ͐l擾
	pComboBox = (CComboBox*)GetDlgItem(IDC_ADDR_ADDRE);
	ASSERT(pComboBox);
	pComboBox->GetWindowText(strText);
	m_dwValue = _tcstoul((LPCTSTR)strText, NULL, 16);

	// ɓ͂ꂽ̂Ɠ`FbN
	nNum = *(int *)GetNumPtr();
	pData = GetDataPtr();
	nHit = -1;
	for (i=0; i<nNum; i++) {
		if (pData[i] == m_dwValue) {
			nHit = i;
			break;
		}
	}

	// VKA̗p
	if (nHit >= 0) {
		// ɂ̂ƓBꏊւ
		for (i=(nHit - 1); i>=0; i--) {
			pData[i + 1] = pData[i];
		}
		pData[0] = m_dwValue;
	}
	else {
		// VKB̂ЂƂ֊i
		for (i=9; i>=1; i--) {
			pData[i] = pData[i - 1];
		}

		// ŐV[0]
		pData[0] = m_dwValue;

		// 10܂ł͒ǉł
		if (nNum < 10) {
			*(int *)GetNumPtr() = (nNum + 1);
		}
	}

	// dwValue}XNOK
	m_dwValue &= m_dwMask;

	// {NX
	CDialog::OnOK();
}

//===========================================================================
//
//	AhX̓_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CAddrDlg::CAddrDlg(CWnd *pParent) : CHistoryDlg(IDD_ADDRDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_ADDRDLG);
		m_nIDHelp = IDD_US_ADDRDLG;
	}

	m_nBit = 24;
}

//---------------------------------------------------------------------------
//
//	j[ZbgAbv
//
//---------------------------------------------------------------------------
void CAddrDlg::SetupHisMenu(CMenu *pMenu)
{
	int i;
	CString string;

	ASSERT(pMenu);

	// j[
	for (i=0; i<(int)m_Num; i++) {
		string.Format("$%06X", m_Data[i]);
		pMenu->ModifyMenu(IDM_HISTORY_0 + i, MF_BYCOMMAND | MF_STRING,
							IDM_HISTORY_0 + i, (LPCTSTR)string);
	}

	// j[폜
	for (i=m_Num; i<10; i++) {
		pMenu->DeleteMenu(IDM_HISTORY_0 + i, MF_BYCOMMAND);
	}
}

//---------------------------------------------------------------------------
//
//	j[ʎ擾
//
//---------------------------------------------------------------------------
DWORD CAddrDlg::GetAddr(UINT nID)
{
	DWORD dwAddr;
    int i;

	ASSERT((nID >= IDM_HISTORY_0) && (nID <= IDM_HISTORY_9));

	// AhX擾
	nID -= IDM_HISTORY_0;
	ASSERT(nID < 10);
	dwAddr = m_Data[nID];

	// ꏊւ
	for (i=(int)(nID - 1); i>=0; i--) {
		m_Data[i + 1] = m_Data[i];
	}
	m_Data[0] = dwAddr;

	return dwAddr;
}

//---------------------------------------------------------------------------
//
//	qXg|C^擾
//
//---------------------------------------------------------------------------
UINT* CAddrDlg::GetNumPtr()
{
	return &m_Num;
}

//---------------------------------------------------------------------------
//
//	qXgf[^|C^擾
//
//---------------------------------------------------------------------------
DWORD* CAddrDlg::GetDataPtr()
{
	return m_Data;
}

//---------------------------------------------------------------------------
//
//	qXg
//
//---------------------------------------------------------------------------
UINT CAddrDlg::m_Num = 0;

//---------------------------------------------------------------------------
//
//	qXgf[^
//
//---------------------------------------------------------------------------
DWORD CAddrDlg::m_Data[10] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

//===========================================================================
//
//	WX^̓_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CRegDlg::CRegDlg(CWnd *pParent) : CHistoryDlg(IDD_REGDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_REGDLG);
		m_nIDHelp = IDD_US_REGDLG;
	}

	m_nIndex = 0;
	m_nBit = 32;
}

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CRegDlg::OnInitDialog()
{
	CWnd *pWnd;
	CString strRegister;
	CPU *pCPU;
	CPU::cpu_t reg;

	ASSERT(this);
	ASSERT(m_nIndex < 20);

	// CPUWX^擾
	::LockVM();
	pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(pCPU);
	pCPU->GetCPU(&reg);
	::UnlockVM();

	// 쐬
	if (m_nIndex <= 7) {
		strRegister.Format("D%d", m_nIndex);
		m_dwValue = reg.dreg[m_nIndex];
	}
	if ((m_nIndex >= 8) && (m_nIndex <= 15)) {
		strRegister.Format("A%d", m_nIndex & 7);
		m_dwValue = reg.areg[m_nIndex & 7];
	}
	switch (m_nIndex) {
		// USP
		case 16:
			strRegister = "USP";
			if (reg.sr & 0x2000) {
				m_dwValue = reg.sp;
			}
			else {
				m_dwValue = reg.areg[7];
			}
			break;
		// SSP
		case 17:
			strRegister = "SSP";
			if (reg.sr & 0x2000) {
				m_dwValue = reg.areg[7];
			}
			else {
				m_dwValue = reg.sp;
			}
			break;
		// PC
		case 18:
			strRegister = "PC";
			m_dwValue = reg.pc;
			break;
		// SR
		case 19:
			strRegister = "SR";
			m_dwValue = reg.sr;
			break;
	}

	// {NXŌĂ
	if (!CHistoryDlg::OnInitDialog()) {
		return FALSE;
	}

	// lݒ
	pWnd = GetDlgItem(IDC_ADDR_ADDRL);
	ASSERT(pWnd);
	pWnd->SetWindowText(strRegister);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	OK
//
//---------------------------------------------------------------------------
void CRegDlg::OnOK()
{
	CComboBox *pComboBox;
	CString string;
	DWORD dwValue;
	CPU *pCPU;
	CPU::cpu_t reg;

	ASSERT(this);

	// Value擾
	pComboBox = (CComboBox*)GetDlgItem(IDC_ADDR_ADDRE);
	ASSERT(pComboBox);
	pComboBox->GetWindowText(string);
	dwValue = ::strtoul((LPCTSTR)string, NULL, 16);

	// VMbNAWX^擾
	::LockVM();
	pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(pCPU);
	pCPU->GetCPU(&reg);

	// CfbNX
	if (m_nIndex <= 7) {
		reg.dreg[m_nIndex] = dwValue;
	}
	if ((m_nIndex >= 8) && (m_nIndex <= 15)) {
		reg.areg[m_nIndex & 7] = dwValue;
	}
	switch (m_nIndex) {
		// USP
		case 16:
			if (reg.sr & 0x2000) {
				reg.sp = dwValue;
			}
			else {
				reg.areg[7] = dwValue;
			}
			break;
		// SSP
		case 17:
			if (reg.sr & 0x2000) {
				reg.areg[7] = dwValue;
			}
			else {
				reg.sp = dwValue;
			}
			break;
		// PC
		case 18:
			reg.pc = dwValue & 0xfffffe;
			break;
		// SR
		case 19:
			reg.sr = (WORD)dwValue;
			break;
	}

	// WX^ݒAVMAbN
	pCPU->SetCPU(&reg);
	::UnlockVM();

	// {NX
	CHistoryDlg::OnOK();
}

//---------------------------------------------------------------------------
//
//	qXg|C^擾
//
//---------------------------------------------------------------------------
UINT* CRegDlg::GetNumPtr()
{
	return &m_Num;
}

//---------------------------------------------------------------------------
//
//	qXgf[^|C^擾
//
//---------------------------------------------------------------------------
DWORD* CRegDlg::GetDataPtr()
{
	return m_Data;
}

//---------------------------------------------------------------------------
//
//	qXg
//
//---------------------------------------------------------------------------
UINT CRegDlg::m_Num = 0;

//---------------------------------------------------------------------------
//
//	qXgf[^
//
//---------------------------------------------------------------------------
DWORD CRegDlg::m_Data[10] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

//===========================================================================
//
//	f[^̓_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CDataDlg::CDataDlg(CWnd *pParent) : CHistoryDlg(IDD_DATADLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_DATADLG);
		m_nIDHelp = IDD_US_DATADLG;
	}

	// ꉞA
	m_dwAddr = 0;
	m_nSize = 0;
}

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CDataDlg::OnInitDialog()
{
	CWnd *pWnd;
	CString string;

	ASSERT(this);
	ASSERT(m_dwAddr < 0x1000000);

	// AhXƃrbg
	switch (m_nSize) {
		// Byte
		case 0:
			string.Format("$%06X (B)", m_dwAddr);
			m_nBit = 8;
			break;
		// Word
		case 1:
			string.Format("$%06X (W)", m_dwAddr);
			m_nBit = 16;
			break;
		// Long
		case 2:
			string.Format("$%06X (L)", m_dwAddr);
			m_nBit = 32;
			break;
		// ̑
		default:
			ASSERT(FALSE);
			break;
	}

	// {NX
	if (!CHistoryDlg::OnInitDialog()) {
		return FALSE;
	}

	// m̌Őݒ
	pWnd = GetDlgItem(IDC_ADDR_ADDRL);
	ASSERT(pWnd);
	pWnd->SetWindowText(string);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	qXg|C^擾
//
//---------------------------------------------------------------------------
UINT* CDataDlg::GetNumPtr()
{
	return &m_Num;
}

//---------------------------------------------------------------------------
//
//	qXgf[^|C^擾
//
//---------------------------------------------------------------------------
DWORD* CDataDlg::GetDataPtr()
{
	return m_Data;
}

//---------------------------------------------------------------------------
//
//	qXg
//
//---------------------------------------------------------------------------
UINT CDataDlg::m_Num = 0;

//---------------------------------------------------------------------------
//
//	qXgf[^
//
//---------------------------------------------------------------------------
DWORD CDataDlg::m_Data[10] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

//===========================================================================
//
//	CPUWX^EBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CCPURegWnd::CCPURegWnd()
{
	// EBhEp[^`
	m_dwID = MAKEID('M', 'P', 'U', 'R');
	::GetMsg(IDS_SWND_CPUREG, m_strCaption);
	m_nWidth = 27;
	m_nHeight = 10;

	// CPU擾
	m_pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(m_pCPU);
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CCPURegWnd, CSubTextWnd)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_CONTEXTMENU()
	ON_COMMAND_RANGE(IDM_REG_D0, IDM_REG_SR, OnReg)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CCPURegWnd::Setup()
{
	CPU::cpu_t buf;
	int i;
	CString string;

	ASSERT(this);

	// NA
	Clear();

	// CPUWX^擾
	m_pCPU->GetCPU(&buf);

	// Zbg(D, A)
	for (i=0; i<8; i++) {
		string.Format("D%1d  %08X", i, buf.dreg[i]);
		SetString(0, i, string);

		string.Format("A%1d  %08X", i, buf.areg[i]);
		SetString(15, i, string);
	}

	// Zbg(X^bN)
	if (buf.sr & 0x2000) {
		string.Format("USP %08X", buf.sp);
		SetString(0, 8, string);
		string.Format("SSP %08X", buf.areg[7]);
		SetString(15, 8, string);
	}
	else {
		string.Format("USP %08X", buf.areg[7]);
		SetString(0, 8, string);
		string.Format("SSP %08X", buf.sp);
		SetString(15, 8, string);
	}

	// Zbg(̑)
	string.Format("PC    %06X", buf.pc);
	SetString(0, 9, string);
	string.Format("SR      %04X", buf.sr);
	SetString(15, 9, string);
}

//---------------------------------------------------------------------------
//
//	{^_uNbN
//
//---------------------------------------------------------------------------
void CCPURegWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	int x;
	int y;
	int index;
	CRegDlg dlg(this);

	// x,yZo
	x = point.x / m_tmWidth;
	y = point.y / m_tmHeight;

	// CfbNXo
	if (y < 8) {
		if (x < 15) {
			// D0-D7
			index = y;
		}
		else {
			// A0-A7
			index = y + 8;
		}
	}
	else {
		index = y - 8;
		index <<= 1;
		if (x >= 15) {
			index++;
		}
		index += 16;
	}

	// _CAOs
	dlg.m_nIndex = index;
	dlg.DoModal();
}

//---------------------------------------------------------------------------
//
//	ReLXgj[
//
//---------------------------------------------------------------------------
void CCPURegWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;

	// NCAg̈ŉꂽ肷
	GetClientRect(&rect);
	ClientToScreen(&rect);
	if (!rect.PtInRect(point)) {
		CSubTextWnd::OnContextMenu(pWnd, point);
		return;
	}

	// j[[h
	menu.LoadMenu(IDR_REGMENU);
	pMenu = menu.GetSubMenu(0);

	// j[ZbgAbv
	SetupRegMenu(pMenu, m_pCPU, TRUE);

	// j[s
	pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
							point.x, point.y, this);
}

//---------------------------------------------------------------------------
//
//	j[ZbgAbv
//
//---------------------------------------------------------------------------
void CCPURegWnd::SetupRegMenu(CMenu *pMenu, CPU *pCPU, BOOL bSR)
{
	int i;
	CString string;
	CPU::cpu_t reg;

	ASSERT(pMenu);
	ASSERT(pCPU);

	// CPUWX^擾
	::LockVM();
	pCPU->GetCPU(&reg);
	::UnlockVM();

	// ZbgAbv(D)
	for (i=0; i<8; i++) {
		string.Format("D%1d ($%08X)", i, reg.dreg[i]);
		pMenu->ModifyMenu(IDM_REG_D0 + i, MF_BYCOMMAND | MF_STRING,
							IDM_REG_D0 + i, (LPCTSTR)string);
	}
	// ZbgAbv(A)
	for (i=0; i<8; i++) {
		string.Format("A%1d ($%08X)", i, reg.areg[i]);
		pMenu->ModifyMenu(IDM_REG_A0 + i, MF_BYCOMMAND | MF_STRING,
							IDM_REG_A0 + i, (LPCTSTR)string);
	}
	// ZbgAbv(USP,SSP)
	if (reg.sr & 0x2000) {
		string.Format("USP ($%08X)", reg.sp);
		pMenu->ModifyMenu(IDM_REG_USP, MF_BYCOMMAND | MF_STRING, IDM_REG_USP, (LPCTSTR)string);
		string.Format("SSP ($%08X)", reg.areg[7]);
		pMenu->ModifyMenu(IDM_REG_SSP, MF_BYCOMMAND | MF_STRING, IDM_REG_SSP, (LPCTSTR)string);
	}
	else {
		string.Format("USP ($%08X)", reg.areg[7]);
		pMenu->ModifyMenu(IDM_REG_USP, MF_BYCOMMAND | MF_STRING, IDM_REG_USP, (LPCTSTR)string);
		string.Format("SSP ($%08X)", reg.sp);
		pMenu->ModifyMenu(IDM_REG_SSP, MF_BYCOMMAND | MF_STRING, IDM_REG_SSP, (LPCTSTR)string);
	}

	// ZbgAbv(PC)
	string.Format("PC ($%06X)", reg.pc);
	pMenu->ModifyMenu(IDM_REG_PC, MF_BYCOMMAND | MF_STRING, IDM_REG_PC, (LPCTSTR)string);

	// ZbgAbv(SR)
	if (bSR) {
		string.Format("SR ($%04X)", reg.sr);
		pMenu->ModifyMenu(IDM_REG_SR, MF_BYCOMMAND | MF_STRING, IDM_REG_SR, (LPCTSTR)string);
	}
}

//---------------------------------------------------------------------------
//
//	WX^l擾
//
//---------------------------------------------------------------------------
DWORD CCPURegWnd::GetRegValue(CPU *pCPU, UINT uID)
{
	CPU::cpu_t reg;

	ASSERT(pCPU);
	ASSERT((uID >= IDM_REG_D0) && (uID <= IDM_REG_SR));

	// CPUWX^擾
	::LockVM();
	pCPU->GetCPU(&reg);
	::UnlockVM();

	// D0`D7
	if (uID <= IDM_REG_D7) {
		return reg.dreg[uID - IDM_REG_D0];
	}

	// A0-A7
	if (uID <= IDM_REG_A7) {
		return reg.areg[uID - IDM_REG_A0];
	}

	// USP
	if (uID == IDM_REG_USP) {
		if (reg.sr & 0x2000) {
			return reg.sp;
		}
		else {
			return reg.areg[7];
		}
	}

	// SSP
	if (uID == IDM_REG_SSP) {
		if (reg.sr & 0x2000) {
			return reg.areg[7];
		}
		else {
			return reg.sp;
		}
	}

	// PC
	if (uID == IDM_REG_PC) {
		return reg.pc;
	}

	// SR
	ASSERT(uID == IDM_REG_SR);
	return reg.sr;
}

//---------------------------------------------------------------------------
//
//	WX^R}h
//
//---------------------------------------------------------------------------
void CCPURegWnd::OnReg(UINT nID)
{
	CRegDlg dlg(this);

	ASSERT((nID >= IDM_REG_D0) && (nID <= IDM_REG_SR));

	// Z
	nID -= IDM_REG_D0;

	// _CAOɂ܂
	dlg.m_nIndex = nID;
	dlg.DoModal();
}

//===========================================================================
//
//	荞݃EBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CIntWnd::CIntWnd()
{
	// EBhEp[^`
	m_dwID = MAKEID('I', 'N', 'T', ' ');
	::GetMsg(IDS_SWND_INT, m_strCaption);
	m_nWidth = 47;
	m_nHeight = 9;

	// CPU擾
	m_pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(m_pCPU);
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CIntWnd, CSubTextWnd)
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CIntWnd::Setup()
{
	static const char *desc_table[] = {
		"INTSW",
		"MFP",
		"SCC",
		"(Ext.)",
		"DMAC",
		"(Ext.)",
		"IOSC"
	};
	int y;
	int i;
	int level;
	CString string;
	CPU::cpu_t cpu;

	// CPUf[^擾
	m_pCPU->GetCPU(&cpu);
	level = (cpu.sr >> 8);
	level &= 0x07;

	// NA
	Clear();
	y = 0;

	// KCh
	SetString(0, y, "(High)  Device  Mask  Vector     Req        Ack");
	y++;

	// 7x
	for (i=7; i>=1; i--) {
		// 荞ݖ̃Zbg
		string.Format("Level%1d  ", i);
		string += desc_table[7 - i];
		SetString(0, y, string);

		// }XN
		if (i < 7) {
			if (i <= level) {
				SetString(16, y, "Mask");
			}
		}

		// NGXg
		if (cpu.intr[0] & 0x80) {
			// NGXgBxN^\
			string.Format("$%02X", cpu.intr[i]);
			SetString(22, y, string);
		}

		// NGXgJE^
		string.Format("%10d", cpu.intreq[i]);
		SetString(26, y, string);
		
		// JE^
		string.Format("%10d", cpu.intack[i]);
		SetString(37, y, string);

		// 
		y++;
		cpu.intr[0] <<= 1;
	}

	// KCh
	SetString(0, y, "(Low)");
}

//---------------------------------------------------------------------------
//
//	{^_uNbN
//
//---------------------------------------------------------------------------
void CIntWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	int y;
	int level;
	CPU::cpu_t cpu;

	// yZo
	y = point.y / m_tmHeight;

	// y=1,2,3,4,5,6,7ꂼint7,6,5,4,3,2,1ɑΉ
	level = 8 - y;
	if ((level < 1) || (level > 7)) {
		return;
	}

	// bNAf[^擾
	::LockVM();
	m_pCPU->GetCPU(&cpu);

	// NA
	ASSERT((level >= 1) && (level <= 7));
	cpu.intreq[level] = 0;
	cpu.intack[level] = 0;

	// f[^ݒAAbN
	m_pCPU->SetCPU(&cpu);
	::UnlockVM();
}

//===========================================================================
//
//	tAZuEBhE
//
//===========================================================================

#if defined(__cplusplus)
extern "C" {
#endif
//---------------------------------------------------------------------------
//
//	cpudebug.c o
//
//---------------------------------------------------------------------------
void disasm_put(const char *s)
{
	strcpy(debugbuf, s);
}

//---------------------------------------------------------------------------
//
//	foCX
//
//---------------------------------------------------------------------------
static Memory* cpudebug_memory;

//---------------------------------------------------------------------------
//
//	cpudebug.c [hǂݏo
//
//---------------------------------------------------------------------------
WORD cpudebug_fetch(DWORD addr)
{
	WORD w;

	ASSERT(cpudebug_memory);

	addr &= 0xfffffe;
	w = cpudebug_memory->ReadOnly(addr);
	w <<= 8;
	w |= cpudebug_memory->ReadOnly(addr + 1);

	return w;
}
#if defined(__cplusplus)
};
#endif

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CDisasmWnd::CDisasmWnd(int index)
{
	// tAZuEBhE8ނ܂
	ASSERT((index >= 0) && (index <= 0x07));

	// EBhEp[^`
	m_dwID = MAKEID('D', 'I', 'S', (index + 'A'));
	::GetMsg(IDS_SWND_DISASM, m_strCaption);
	m_nWidth = 70;
	m_nHeight = 16;

	// EBhEp[^`(XN[)
	m_ScrlWidth = 70;
	m_ScrlHeight = 0x8000;

	// ŏ̃EBhEPCAȊO͖
	if (index == 0) {
		m_bSync = TRUE;
	}
	else {
		m_bSync = FALSE;
	}

	// ̑
	m_pAddrBuf = NULL;
	m_Caption = m_strCaption;
	m_CaptionSet = "";

	// foCX擾
	m_pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(m_pCPU);
	cpudebug_memory = (Memory*)::GetVM()->SearchDevice(MAKEID('M', 'E', 'M', ' '));
	ASSERT(cpudebug_memory);
	m_pScheduler = (Scheduler*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pScheduler);
	m_pMFP = (MFP*)::GetVM()->SearchDevice(MAKEID('M', 'F', 'P', ' '));
	ASSERT(m_pMFP);
	m_pMemory = (Memory*)::GetVM()->SearchDevice(MAKEID('M', 'E', 'M', ' '));
	ASSERT(m_pMemory);
	m_pSCC = (SCC*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'C', ' '));
	ASSERT(m_pSCC);
	m_pDMAC = (DMAC*)::GetVM()->SearchDevice(MAKEID('D', 'M', 'A', 'C'));
	ASSERT(m_pDMAC);
	m_pIOSC = (IOSC*)::GetVM()->SearchDevice(MAKEID('I', 'O', 'S', 'C'));
	ASSERT(m_pIOSC);

	// AhXPCɏ
	m_dwSetAddr = m_pCPU->GetPC();
	m_dwAddr = m_dwSetAddr;
	m_dwAddr = m_dwAddr & 0xff0000;
	m_dwPC = 0xffffffff;

	// tAZuobt@ڑ
	::cpudebug_put = ::disasm_put;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CDisasmWnd, CSubTextScrlWnd)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_VSCROLL()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_DIS_NEWWIN, OnNewWin)
	ON_COMMAND(IDM_DIS_PC, OnPC)
	ON_COMMAND(IDM_DIS_SYNC, OnSync)
	ON_COMMAND(IDM_DIS_ADDR, OnAddr)
	ON_COMMAND_RANGE(IDM_REG_D0, IDM_REG_PC, OnReg)
	ON_COMMAND_RANGE(IDM_STACK_0, IDM_STACK_F, OnStack)
	ON_COMMAND_RANGE(IDM_DIS_BREAKP0, IDM_DIS_BREAKP7, OnBreak)
	ON_COMMAND_RANGE(IDM_HISTORY_0, IDM_HISTORY_9, OnHistory)
	ON_COMMAND_RANGE(IDM_DIS_RESET, IDM_DIS_FLINE, OnCPUExcept)
	ON_COMMAND_RANGE(IDM_DIS_TRAP0, IDM_DIS_TRAPF, OnTrap)
	ON_COMMAND_RANGE(IDM_DIS_MFP0, IDM_DIS_MFPF, OnMFP)
	ON_COMMAND_RANGE(IDM_DIS_SCC0, IDM_DIS_SCC7, OnSCC)
	ON_COMMAND_RANGE(IDM_DIS_DMAC0, IDM_DIS_DMAC7, OnDMAC)
	ON_COMMAND_RANGE(IDM_DIS_IOSC0, IDM_DIS_IOSC3, OnIOSC)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
int CDisasmWnd::OnCreate(LPCREATESTRUCT lpcs)
{
	int i;

	// AhXobt@Ɋm
	m_pAddrBuf = new DWORD[ m_nHeight ];
	for (i=0; i<m_nHeight; i++) {
		m_pAddrBuf[i] = 0xffffffff;
	}

	// {NX
	if (CSubTextScrlWnd::OnCreate(lpcs) != 0) {
		return -1;
	}

	// AhX
	SetAddr(m_dwSetAddr);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhE폜
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnDestroy()
{
	m_bEnable = FALSE;

	// AhXobt@
	if (m_pAddrBuf) {
		delete[] m_pAddrBuf;
		m_pAddrBuf = NULL;
	}

	// {NX
	CSubTextScrlWnd::OnDestroy();
}

//---------------------------------------------------------------------------
//
//	TCYύX
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnSize(UINT nType, int cx, int cy)
{
	CRect rect;
	int i;

	ASSERT(this);
	ASSERT(cx >= 0);
	ASSERT(cy >= 0);

	// AhXobt@Έx
	::LockVM();
	if (m_pAddrBuf) {
		delete[] m_pAddrBuf;
		m_pAddrBuf = NULL;
	}
	::UnlockVM();

	// {NX(̒ŁACDisasmWnd::OnSizeēxĂ΂ꍇ)
	CSubTextScrlWnd::OnSize(nType, cx, cy);

	// AhXobt@ēxmہB`FbNs
	::LockVM();
	if (m_pAddrBuf) {
		delete[] m_pAddrBuf;
		m_pAddrBuf = NULL;
	}
	m_pAddrBuf = new DWORD[ m_nHeight ];
	for (i=0; i<m_nHeight; i++) {
		m_pAddrBuf[i] = 0xffffffff;
	}
	::UnlockVM();

	// ăAhXZbg
	SetAddr(m_dwSetAddr);
}

//---------------------------------------------------------------------------
//
//	NbN
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	OnLButtonDblClk(nFlags, point);
}

//---------------------------------------------------------------------------
//
//	{^_uNbN
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	int y;
	DWORD dwAddr;

	// AhXobt@ΏI
	if (!m_pAddrBuf) {
		return;
	}

	// AhX擾A`FbN
	y = point.y / m_tmHeight;
	dwAddr = m_pAddrBuf[y];
	if (dwAddr >= 0x01000000) {
		return;
	}

	// VMbN
	::LockVM();

	// AhX΍폜AȂΐݒ
	if (m_pScheduler->IsBreak(dwAddr) >= 0) {
		m_pScheduler->DelBreak(dwAddr);
	}
	else {
		m_pScheduler->SetBreak(dwAddr);
	}

	// VMAbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	XN[()
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar)
{
	SCROLLINFO si;
	DWORD dwDiff;
	DWORD dwAddr;
	int i;

	// XN[擾
	memset(&si, 0, sizeof(si));
	si.cbSize = sizeof(si);
	GetScrollInfo(SB_VERT, &si, SIF_ALL);

	// XN[o[R[h
	switch (nSBCode) {
		// 
		case SB_TOP:
			m_ScrlY = si.nMin;
			break;

		// 
		case SB_BOTTOM:
			m_ScrlY = si.nMax;
			break;

		// 1C
		case SB_LINEUP:
			// AhXobt@`FbN
			if (m_pAddrBuf) {
				// ÕAhX擾AvZ
				dwDiff = GetPrevAddr(m_pAddrBuf[0]);
				dwDiff = m_pAddrBuf[0] - dwDiff;

				// ΌAȂ-1
				if (dwDiff > 0) {
					dwDiff >>= 1;
					m_ScrlY -= dwDiff;
				}
				else {
					m_ScrlY--;
				}
			}
			break;

		// 1C
		case SB_LINEDOWN:
			// AhXobt@āA1ߕi߂
			if (m_nHeight >= 2) {
				if (m_pAddrBuf) {
					dwDiff = m_pAddrBuf[1] - m_pAddrBuf[0];
					dwDiff >>= 1;
					m_ScrlY += dwDiff;
				}
			}
			break;

		// 1y[W
		case SB_PAGEUP:
			// AhXobt@`FbN
			if (m_pAddrBuf) {
				dwAddr = m_pAddrBuf[0];
				for (i=0; i<m_nHeight-1; i++) {
					// ÕAhX擾AvZ
					dwDiff = GetPrevAddr(dwAddr);
					dwDiff = dwAddr - dwDiff;
					dwAddr -= dwDiff;

					// ΌAȂ-1
					if (dwDiff > 0) {
						dwDiff >>= 1;
						m_ScrlY -= dwDiff;
					}
					else {
						m_ScrlY--;
					}

					// I[o[`FbN
					if (m_ScrlY < 0) {
						m_ScrlY = 0;
					}
				}

				// S߂Ȃꍇl
				if (dwAddr == m_pAddrBuf[0]) {
					m_ScrlY -= si.nPage;
				}
			}
			break;

		// 1y[W
		case SB_PAGEDOWN:
			// AhXobt@āAm_nHeightߕi߂
			if (m_pAddrBuf) {
				dwDiff = m_pAddrBuf[m_nHeight - 1] - m_pAddrBuf[0];
				dwDiff >>= 1;
				m_ScrlY += dwDiff;
			}
			break;

		// Tړ
		case SB_THUMBPOSITION:
			m_ScrlY = nPos;
			break;
		case SB_THUMBTRACK:
			m_ScrlY = nPos;
			break;
	}

	// I[o[`FbN
	if (m_ScrlY < 0) {
		m_ScrlY = 0;
	}
	if (m_ScrlY > si.nMax) {
		m_ScrlY = si.nMax;
	}

	// Zbg
	SetupScrlV();
}

//---------------------------------------------------------------------------
//
//	ReLXgj[
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;

	// NCAg̈ŉꂽ肷
	GetClientRect(&rect);
	ClientToScreen(&rect);
	if (!rect.PtInRect(point)) {
		CSubTextScrlWnd::OnContextMenu(pWnd, point);
		return;
	}

	// j[[h
	if (::IsJapanese()) {
		menu.LoadMenu(IDR_DISMENU);
	}
	else {
		menu.LoadMenu(IDR_US_DISMENU);
	}
	pMenu = menu.GetSubMenu(0);

	// ZbgAbv
	SetupContext(pMenu);

	// j[s
	pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
							point.x, point.y, this);
}

//---------------------------------------------------------------------------
//
//	ReLXgj[ ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::SetupContext(CMenu *pMenu)
{
	CMenu *pSubMenu;
	int i;

	ASSERT(pMenu);

	// PCɓ
	if (m_bSync) {
		pMenu->CheckMenuItem(IDM_DIS_SYNC, MF_BYCOMMAND | MF_CHECKED);
	}

	// VEBhE
	if (!m_pDrawView->IsNewWindow(TRUE)) {
		pMenu->EnableMenuItem(IDM_DIS_NEWWIN, MF_BYCOMMAND | MF_GRAYED);
	}

	// MPUWX^EX^bNEAhXqXg
	CCPURegWnd::SetupRegMenu(pMenu, m_pCPU, FALSE);
	CMemoryWnd::SetupStackMenu(pMenu, m_pMemory, m_pCPU);
	CAddrDlg::SetupHisMenu(pMenu);

	// u[N|Cg
	SetupBreakMenu(pMenu, m_pScheduler);

	// VMbN
	::LockVM();

	// 荞݃xN^
	pSubMenu = pMenu->GetSubMenu(9);

	// MPUW
	SetupVector(pSubMenu, 0, 1, 11);

	// trap #x
	SetupVector(pSubMenu, 12, 0x20, 16);

	// MFP
	SetupVector(pSubMenu, 29, (m_pMFP->GetVR() & 0xf0), 16);

	// SCC
	for (i=0; i<8; i++) {
		SetupVector(pSubMenu, 46 + i, m_pSCC->GetVector(i), 1);
	}

	// DMAC
	for (i=0; i<8; i++) {
		SetupVector(pSubMenu, 55 + i, m_pDMAC->GetVector(i), 1);
	}

	// IOSC
	SetupVector(pSubMenu, 64, m_pIOSC->GetVector(), 4);

	// VMAbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	荞݃xN^ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::SetupVector(CMenu *pMenu, UINT index, DWORD vector, int num)
{
	int i;
	DWORD handler;

	ASSERT(pMenu);
	ASSERT(num > 0);

	// 荞݃xN^AhX
	vector <<= 2;

	// [v
	for (i=0; i<num; i++) {
		// 荞݃nhAhX擾
		handler = (DWORD)m_pMemory->ReadOnly(vector + 1);
		handler <<= 8;
		handler |= (DWORD)m_pMemory->ReadOnly(vector + 2);
		handler <<= 8;
		handler |= (DWORD)m_pMemory->ReadOnly(vector + 3);
		vector += 4;

		// AhXZbg
		SetupAddress(pMenu, index, handler);
		index++;
	}
}

//---------------------------------------------------------------------------
//
//	AhXZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::SetupAddress(CMenu *pMenu, UINT index, DWORD addr)
{
	CString string;
	CString menustr;
	int ext;
	UINT id;

	ASSERT(pMenu);
	ASSERT(addr <= 0xffffff);

	// ݂̕擾
	pMenu->GetMenuString(index, string, MF_BYPOSITION);

	// JbR̐擪TāA΂ȍ~̂
	ext = string.Find(" : ");
	if (ext >= 0) {
		menustr = string.Mid(ext + 3);
	}
	else {
		menustr = string;
	}

	// ($)̕쐬
	string.Format("$%06X : ", addr);
	string += menustr;

	// Zbg
	id = pMenu->GetMenuItemID(index);
	pMenu->ModifyMenu(index, MF_BYPOSITION | MF_STRING, id, string);
}

//---------------------------------------------------------------------------
//
//	VEBhE
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnNewWin()
{
	CDisasmWnd *pDisasmWnd;
	DWORD dwAddr;

	// eEBhEɑ΂AVEBhE̍쐬v
	pDisasmWnd = (CDisasmWnd*)m_pDrawView->NewWindow(TRUE);

	// AƓAhXn
	if (pDisasmWnd) {
		dwAddr = m_ScrlY * 2;
		dwAddr += m_dwAddr;
		pDisasmWnd->SetAddr(dwAddr);
	}
}

//---------------------------------------------------------------------------
//
//	PCֈړ
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnPC()
{
	// ݂PCɃAhXZbg(Refreshs)
	SetAddr(m_pCPU->GetPC());
}

//---------------------------------------------------------------------------
//
//	PCƓ
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnSync()
{
	m_bSync = (!m_bSync);
}

//---------------------------------------------------------------------------
//
//	AhX
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnAddr()
{
	CAddrDlg dlg(this);

	// _CAOs
	dlg.m_dwValue = m_dwSetAddr;
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// AhXZbg
	SetAddr(dlg.m_dwValue);
}

//---------------------------------------------------------------------------
//
//	MPUWX^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnReg(UINT nID)
{
	DWORD dwAddr;

	ASSERT((nID >= IDM_REG_D0) && (nID <= IDM_REG_PC));

	dwAddr = CCPURegWnd::GetRegValue(m_pCPU, nID);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	X^bN
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnStack(UINT nID)
{
	DWORD dwAddr;

	ASSERT((nID >= IDM_STACK_0) && (nID <= IDM_STACK_F));

	dwAddr = CMemoryWnd::GetStackAddr(nID, m_pMemory, m_pCPU);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	u[N|Cg
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnBreak(UINT nID)
{
	DWORD dwAddr;

	ASSERT((nID >= IDM_DIS_BREAKP0) && (nID <= IDM_DIS_BREAKP7));

	dwAddr = GetBreak(nID, m_pScheduler);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	AhXqXg
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnHistory(UINT nID)
{
	DWORD dwAddr;

	ASSERT((nID >= IDM_HISTORY_0) && (nID <= IDM_HISTORY_9));

	dwAddr = CAddrDlg::GetAddr(nID);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	CPUOxN^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnCPUExcept(UINT nID)
{
	nID -= IDM_DIS_RESET;

	OnVector(nID + 1);
}

//---------------------------------------------------------------------------
//
//	trapxN^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnTrap(UINT nID)
{
	nID -= IDM_DIS_TRAP0;

	OnVector(nID + 0x20);
}

//---------------------------------------------------------------------------
//
//	MFPxN^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnMFP(UINT nID)
{
	nID -= IDM_DIS_MFP0;

	OnVector(nID + (m_pMFP->GetVR() & 0xf0));
}

//---------------------------------------------------------------------------
//
//	SCCxN^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnSCC(UINT nID)
{
	DWORD vector;

	nID -= IDM_DIS_SCC0;
	ASSERT(nID <= 7);

	// xN^ԍ𓾂
	::LockVM();
	vector = m_pSCC->GetVector(nID);
	::UnlockVM();

	OnVector(vector);
}

//---------------------------------------------------------------------------
//
//	DMACxN^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnDMAC(UINT nID)
{
	DWORD vector;

	nID -= IDM_DIS_DMAC0;
	ASSERT(nID <= 7);

	// xN^ԍ𓾂
	::LockVM();
	vector = m_pDMAC->GetVector(nID);
	::UnlockVM();

	OnVector(vector);
}

//---------------------------------------------------------------------------
//
//	IOSCxN^
//
//---------------------------------------------------------------------------
void CDisasmWnd::OnIOSC(UINT nID)
{
	DWORD vector;

	nID -= IDM_DIS_IOSC0;
	ASSERT(nID <= 3);

	// xN^ԍ𓾂
	::LockVM();
	vector = m_pIOSC->GetVector() + nID;
	::UnlockVM();

	OnVector(vector);
}

//---------------------------------------------------------------------------
//
//	xN^w
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::OnVector(UINT vector)
{
	DWORD addr;

	// xN^ǂݏo
	::LockVM();
	vector <<= 2;
	addr = (DWORD)m_pMemory->ReadOnly(vector + 1);
	addr <<= 8;
	addr |= (DWORD)m_pMemory->ReadOnly(vector + 2);
	addr <<= 8;
	addr |= (DWORD)m_pMemory->ReadOnly(vector + 3);
	::UnlockVM();

	// AhXw
	SetAddr(addr);
}

//---------------------------------------------------------------------------
//
//	AhXw
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::SetAddr(DWORD dwAddr)
{
	int offset;
	CString string;

	::LockVM();

	// AhXL
	dwAddr &= 0xffffff;
	m_dwSetAddr = dwAddr;
	m_dwAddr = dwAddr & 0xff0000;

	// ʂ̂ݎo
	offset = dwAddr & 0x00ffff;
	offset >>= 1;

	// XN[
	m_ScrlY = offset;
	::UnlockVM();
	SetScrollPos(SB_VERT, offset, TRUE);

	// LvVXV
	string.Format(" [%d] ($%06X - $%06X)", (m_dwID & 0xff) - 'A' + 1, m_dwAddr, m_dwAddr + 0xffff);
	string = m_strCaption + string;
	if (m_Caption != string) {
		m_Caption = string;
		SetWindowText(string);
	}
}

//---------------------------------------------------------------------------
//
//	PCw
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::SetPC(DWORD pc)
{
	ASSERT(pc <= 0xffffff);

	// tOĂ΁AAhXZbg
	if (m_bSync) {
		m_dwPC = pc;
	}
	else {
		m_dwPC = 0xffffffff;
	}
}

//---------------------------------------------------------------------------
//
//	bZ[WXbh̍XV
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::Update()
{
	// PCw
	if (m_dwPC < 0x1000000) {
		SetAddr(m_dwPC);
		m_dwPC = 0xffffffff;
	}
}

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::Setup()
{
	DWORD dwAddr;
	DWORD dwPC;
	int i;
	int j;
	int k;

	// AhXw
	dwAddr = (m_dwAddr & 0xff0000);
	dwAddr |= (DWORD)(m_ScrlY * 2);
	::debugpc = dwAddr;

	// PC擾
	dwPC = m_pCPU->GetPC();

	// [v
	for (i=0; i<m_nHeight; i++) {
		dwAddr = ::debugpc;

		// AhXi[
		if (m_pAddrBuf) {
			m_pAddrBuf[i] = dwAddr;
		}

		// AhX[v`FbN(FFFFFFF[vl)
		if (dwAddr > 0xffffff) {
			// [vBAhX̓z[h
			ASSERT(i > 0);
			if (m_pAddrBuf) {
				m_pAddrBuf[i] = m_pAddrBuf[i - 1];
			}

			// 
			Reverse(FALSE);
			for (j=0; j<m_nWidth; j++) {
				SetChr(j, i, ' ');
			}
			continue;
		}

		// 
		k = m_pScheduler->IsBreak(dwAddr);
		if (k >= 0) {
			Reverse(TRUE);
		}
		else {
			Reverse(FALSE);
		}
		// hԂ
		for (j=0; j<m_nWidth; j++) {
			SetChr(j, i, ' ');
		}

		// tAZu
		::cpudebug_disassemble(1);

		// PC}[NAu[N}[N
		if (k >= 0) {
			::debugbuf[0] = (char)(k + '1');
		}
		else {
			::debugbuf[0] = ' ';
		}
		if (dwAddr == dwPC) {
			::debugbuf[1] = '>';
		}
		else {
			::debugbuf[1] = ' ';
		}

		// \
		if (m_ScrlX < (int)strlen(::debugbuf)) {
			SetString(0, i, &debugbuf[m_ScrlX]);
		}

		// u[N|CgŖ̏ꍇɑΉ
		k = m_pScheduler->IsBreak(dwAddr, TRUE);
		if (k >= 0) {
			Reverse(TRUE);
			SetChr(0, i, (char)(k + '1'));
		}
	}
}

//---------------------------------------------------------------------------
//
//	ÕAhX擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CDisasmWnd::GetPrevAddr(DWORD dwAddr)
{
	int i;
	DWORD dwTest;

	ASSERT(dwAddr <= 0xffffff);

	// AhX
	dwTest = dwAddr;

	for (i=0; i<16; i++) {
		// dwTestAI[o[`FbN
		dwTest -= 2;
		if (dwTest >= 0x01000000) {
			return dwAddr;
		}

		// tAZuāAAhX݂
		::debugpc = dwTest;
		::cpudebug_disassemble(1);

		// vĂ"UNRECOG"`FbN
		if (::debugpc == dwAddr) {
			if ((::debugbuf[35] == 'U') || (::debugbuf[36] == 'N') || (::debugbuf[37] == 'R')) {
				continue;
			}
			// okA^[
			return dwTest;
		}
	}

	// svBdwAddrԂ
	return dwAddr;
}

//---------------------------------------------------------------------------
//
//	u[N|Cgj[ ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CDisasmWnd::SetupBreakMenu(CMenu *pMenu, Scheduler *pScheduler)
{
	int num;
	int i;
	Scheduler::breakpoint_t buf;
	CString string;

	ASSERT(pMenu);
	ASSERT(pScheduler);

	// NA
	num = 0;

	// ݒ
	::LockVM();
	for (i=0; i<Scheduler::BreakMax; i++) {
		pScheduler->GetBreak(i, &buf);
		if (buf.use) {
			// gpȂ̂ŁAݒ
			string.Format("%1d : $%06X", num + 1, buf.addr);
			pMenu->ModifyMenu(IDM_DIS_BREAKP0 + num, MF_BYCOMMAND | MF_STRING,
				IDM_DIS_BREAKP0 + num, (LPCTSTR)string);

			// +1
			num++;
		}
	}
	::UnlockVM();

	// ȊÔƂ̓NA
	for (i=num; i<Scheduler::BreakMax; i++) {
		pMenu->DeleteMenu(IDM_DIS_BREAKP0 + i, MF_BYCOMMAND);
	}
}

//---------------------------------------------------------------------------
//
//	u[N|Cgj[擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CDisasmWnd::GetBreak(UINT nID, Scheduler *pScheduler)
{
	int i;
	Scheduler::breakpoint_t buf;

	ASSERT((nID >= IDM_DIS_BREAKP0) && (nID <= IDM_DIS_BREAKP7));
	ASSERT(pScheduler);
	nID -= IDM_DIS_BREAKP0;

	// [v
	::LockVM();
	for (i=0; i<Scheduler::BreakMax; i++) {
		pScheduler->GetBreak(i, &buf);
		if (buf.use) {
			// gpȂ̂ŁAꂩH
			if (nID == 0) {
				::UnlockVM();
				return buf.addr;
			}
			nID--;
		}
	}
	::UnlockVM();

	return 0;
}

//===========================================================================
//
//	EBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CMemoryWnd::CMemoryWnd(int nWnd)
{
	// EBhE8ނ܂
	ASSERT((nWnd >= 0) && (nWnd <= 7));

	// EBhEp[^`
	m_dwID = MAKEID('M', 'E', 'M', (nWnd + 'A'));
	::GetMsg(IDS_SWND_MEMORY, m_strCaption);
	m_nWidth = 73;
	m_nHeight = 16;

	// EBhEp[^`(XN[)
	m_ScrlWidth = 73;
	m_ScrlHeight = 0x8000;

	// CPU擾
	m_pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(m_pCPU);

	// 擾
	m_pMemory = (Memory*)::GetVM()->SearchDevice(MAKEID('M', 'E', 'M', ' '));
	ASSERT(m_pMemory);

	// ̑
	m_dwAddr = 0;
	m_nUnit = 0;
	m_strCaptionReq.Empty();
	m_strCaptionSet.Empty();
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CMemoryWnd, CSubTextScrlWnd)
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_MEMORY_ADDR, OnAddr)
	ON_COMMAND(IDM_MEMORY_NEWWIN, OnNewWin)
	ON_COMMAND_RANGE(IDM_MEMORY_BYTE, IDM_MEMORY_LONG, OnUnit)
	ON_COMMAND_RANGE(IDM_MEMORY_0, IDM_MEMORY_F, OnRange)
	ON_COMMAND_RANGE(IDM_REG_D0, IDM_REG_PC, OnReg)
	ON_COMMAND_RANGE(IDM_AREA_MPU, IDM_AREA_IPLROM, OnArea)
	ON_COMMAND_RANGE(IDM_HISTORY_0, IDM_HISTORY_9, OnHistory)
	ON_COMMAND_RANGE(IDM_STACK_0, IDM_STACK_F, OnStack)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
int CMemoryWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	// {NX
	if (CSubTextScrlWnd::OnCreate(lpCreateStruct) != 0) {
		return -1;
	}

	// AhX
	SetAddr(0);
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	`
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnPaint()
{
	// {NX
	CSubTextScrlWnd::OnPaint();

	// LvVݒ
	SetWindowText(m_strCaption);
}

//---------------------------------------------------------------------------
//
//	{^_uNbN
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnLButtonDblClk(UINT /*nFlags*/, CPoint point)
{
	int x;
	int y;
	DWORD dwAddr;
	DWORD dwData;
	CDataDlg dlg(this);

	// x, yZo
	x = point.x / m_tmWidth;
	y = point.y / m_tmHeight;

	// x`FbN
	if (x < 8) {
		return;
	}
	x -= 8;

	// ỹAhX𓾂
	dwAddr = m_dwAddr | (m_ScrlY << 5);
	dwAddr += (y << 4);
	if ((dwAddr - m_dwAddr) >= 0x100000) {
		return;
	}

	// xAhX𓾂
	switch (m_nUnit) {
		// Byte
		case 0:
			x /= 3;
			break;
		// Word
		case 1:
			x /= 5;
			x <<= 1;
			break;
		// Long
		case 2:
			x /= 9;
			x <<= 2;
			break;
		// ̑
		default:
			ASSERT(FALSE);
			break;
	}
	if (x >= 16) {
		return;
	}
	dwAddr += x;

	// f[^ǂݍ
	::LockVM();
	switch (m_nUnit) {
		// Byte
		case 0:
			dwData = m_pMemory->ReadOnly(dwAddr);
			break;
		// Word
		case 1:
			dwData = m_pMemory->ReadOnly(dwAddr);
			dwData <<= 8;
			dwData |= m_pMemory->ReadOnly(dwAddr + 1);
			break;
		// Long
		case 2:
			dwData = m_pMemory->ReadOnly(dwAddr);
			dwData <<= 8;
			dwData |= m_pMemory->ReadOnly(dwAddr + 1);
			dwData <<= 8;
			dwData |= m_pMemory->ReadOnly(dwAddr + 2);
			dwData <<= 8;
			dwData |= m_pMemory->ReadOnly(dwAddr + 3);
			break;
		// ̑
		default:
			dwData = 0;
			ASSERT(FALSE);
			break;
	}
	::UnlockVM();

	// _CAOs
	dlg.m_dwAddr = dwAddr;
	dlg.m_dwValue = dwData;
	dlg.m_nSize = m_nUnit;
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// 
	dwData = dlg.m_dwValue;
	::LockVM();
	switch (m_nUnit) {
		// Byte
		case 0:
			m_pMemory->WriteByte(dwAddr, dwData);
			break;
		// Word
		case 1:
			m_pMemory->WriteWord(dwAddr, dwData);
			break;
		// Long
		case 2:
			m_pMemory->WriteWord(dwAddr, (WORD)(dwData >> 16));
			m_pMemory->WriteWord(dwAddr + 2, (WORD)dwData);
			break;
		// ̑
		default:
			ASSERT(FALSE);
			break;
	}
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	ReLXgj[
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;

	// NCAg̈ŉꂽ肷
	GetClientRect(&rect);
	ClientToScreen(&rect);
	if (!rect.PtInRect(point)) {
		CSubTextScrlWnd::OnContextMenu(pWnd, point);
		return;
	}

	// j[s
	if (::IsJapanese()) {
		menu.LoadMenu(IDR_MEMORYMENU);
	}
	else {
		menu.LoadMenu(IDR_US_MEMORYMENU);
	}
	pMenu = menu.GetSubMenu(0);
	SetupContext(pMenu);
	pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
							point.x, point.y, this);
}

//---------------------------------------------------------------------------
//
//	ReLXgj[ ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CMemoryWnd::SetupContext(CMenu *pMenu)
{
	ASSERT(pMenu);

	// VEBhE
	if (!m_pDrawView->IsNewWindow(FALSE)) {
		pMenu->EnableMenuItem(IDM_MEMORY_NEWWIN, MF_BYCOMMAND | MF_GRAYED);
	}

	// TCY`FbN
	pMenu->CheckMenuRadioItem(IDM_MEMORY_BYTE, IDM_MEMORY_LONG,
			IDM_MEMORY_BYTE + m_nUnit, MF_BYCOMMAND);

	// AhX`FbN
	pMenu->CheckMenuRadioItem(IDM_MEMORY_0, IDM_MEMORY_F,
			IDM_MEMORY_0 + (m_dwAddr >> 20), MF_BYCOMMAND);

	// MPUWX^
	CCPURegWnd::SetupRegMenu(pMenu, m_pCPU, FALSE);

	// AhXqXg
	CAddrDlg::SetupHisMenu(pMenu);

	// X^bN
	SetupStackMenu(pMenu, m_pMemory, m_pCPU);
}

//---------------------------------------------------------------------------
//
//	AhX
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnAddr()
{
	CAddrDlg dlg(this);

	// _CAOs
	dlg.m_dwValue = m_dwAddr | (m_ScrlY * 0x20);
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// AhXZbg
	SetAddr(dlg.m_dwValue);
}

//---------------------------------------------------------------------------
//
//	VEBhE
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnNewWin()
{
	CMemoryWnd *pWnd;

	// eEBhEɑ΂AVEBhE̍쐬v
	pWnd = (CMemoryWnd*)m_pDrawView->NewWindow(FALSE);

	// 쐬łAƓAhXETCYw
	if (pWnd) {
		pWnd->SetAddr(m_dwAddr | (m_ScrlY * 0x20));
		pWnd->SetUnit(m_nUnit);
	}
}

//---------------------------------------------------------------------------
//
//	\Pʎw
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnUnit(UINT uID)
{
	int unit;

	unit = (int)(uID - IDM_MEMORY_BYTE);
	ASSERT((unit >= 0) && (unit <= 2));

	SetUnit(unit);
}

//---------------------------------------------------------------------------
//
//	\PʃZbg
//
//---------------------------------------------------------------------------
void FASTCALL CMemoryWnd::SetUnit(int nUnit)
{
	ASSERT(this);
	ASSERT((nUnit >= 0) && (nUnit <= 2));

	// bNAύX
	::LockVM();
	m_nUnit = nUnit;
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	AhX͈͎w
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnRange(UINT uID)
{
	DWORD dwAddr;

	ASSERT((uID >= IDM_MEMORY_0) && (uID <= IDM_MEMORY_F));

	dwAddr = (DWORD)(uID - IDM_MEMORY_0);
	dwAddr *= 0x100000;
	dwAddr |= (DWORD)(m_ScrlY * 0x20);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	WX^w
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnReg(UINT uID)
{
	DWORD dwAddr;

	ASSERT((uID >= IDM_REG_D0) && (uID <= IDM_REG_PC));

	dwAddr = CCPURegWnd::GetRegValue(m_pCPU, uID);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	GAw
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnArea(UINT uID)
{
	CMenu menu;
	TCHAR buf[0x100];
	DWORD dwAddr;

	ASSERT((uID >= IDM_AREA_MPU) && (uID <= IDM_AREA_IPLROM));

	// j[[h
	if (::IsJapanese()) {
		menu.LoadMenu(IDR_MEMORYMENU);
	}
	else {
		menu.LoadMenu(IDR_US_MEMORYMENU);
	}

	// wID̃j[擾
	menu.GetMenuString(uID, buf, 0x100, MF_BYCOMMAND);

	// "$000000 : "̌`肷
	buf[0] = _T('0');
	buf[7] = _T('\0');
	dwAddr = ::_tcstoul(buf, NULL, 16);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	qXgw
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnHistory(UINT uID)
{
	DWORD dwAddr;

	ASSERT((uID >= IDM_HISTORY_0) && (uID <= IDM_HISTORY_9));
	dwAddr = CAddrDlg::GetAddr(uID);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	X^bNw
//
//---------------------------------------------------------------------------
void CMemoryWnd::OnStack(UINT uID)
{
	DWORD dwAddr;

	ASSERT((uID >= IDM_STACK_0) && (uID <= IDM_STACK_F));
	dwAddr = GetStackAddr(uID, m_pMemory, m_pCPU);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	AhXw
//
//---------------------------------------------------------------------------
void FASTCALL CMemoryWnd::SetAddr(DWORD dwAddr)
{
	int offset;
	CString strCap;

	ASSERT(this);
	ASSERT(dwAddr <= 0x1000000);

	// ʂ̂ݎo
	m_dwAddr = dwAddr & 0xf00000;

	// ʂ̂ݎo
	offset = dwAddr & 0x0fffff;
	offset /= 0x20;

	// XN[
	m_ScrlY = offset;
	SetScrollPos(SB_VERT, offset, TRUE);

	// LvV쐬
	strCap.Format(_T(" [%d] ($%06X - $%06X)"), (m_dwID & 0xff) - 'A' + 1,
									m_dwAddr, m_dwAddr + 0x0fffff);
	m_CSection.Lock();
	m_strCaptionReq = m_strCaption + strCap;
	m_CSection.Unlock();
}

//---------------------------------------------------------------------------
//
//	bZ[WXbh̍XV
//
//---------------------------------------------------------------------------
void FASTCALL CMemoryWnd::Update()
{
	CString strCap;

	// LvV擾
	m_CSection.Lock();
	strCap = m_strCaptionReq;
	m_CSection.Unlock();

	// r
	if (m_strCaptionSet != strCap) {
		m_strCaptionSet = strCap;
		SetWindowText(m_strCaptionSet);
	}
}

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CMemoryWnd::Setup()
{
	int x;
	int y;
	CString strText;
	CString strHex;
	DWORD dwAddr;
	DWORD dwOffset;
	TCHAR szAscii[2];

	// NAAAhX
	Clear();
	dwAddr = (m_dwAddr & 0xf00000);
	dwOffset = (DWORD)(m_ScrlY << 5);
	dwAddr |= dwOffset;

	// 񏉊
	szAscii[1] = _T('\0');

	// y[v
	for (y=0; y<m_nHeight; y++) {
		// I[o[`FbN
		if (dwOffset >= 0x100000) {
			break;
		}

		// AhX\
		strText.Format(_T("%06X:"), dwAddr);

		// x[v
		switch (m_nUnit) {
			// Byte
			case 0:
				for (x=0; x<16; x++) {
					strHex.Format(_T(" %02X"), m_pMemory->ReadOnly(dwAddr));
					strText += strHex;
					dwAddr++;
				}
				break;
			// Word
			case 1:
				for (x=0; x<8; x++) {
					strHex.Format(_T(" %02X%02X"),  m_pMemory->ReadOnly(dwAddr),
													m_pMemory->ReadOnly(dwAddr + 1));
					strText += strHex;
					dwAddr += 2;
				}
				break;
			// Long
			case 2:
				for (x=0; x<4; x++) {
					strHex.Format(" %02X%02X%02X%02X",  m_pMemory->ReadOnly(dwAddr),
														m_pMemory->ReadOnly(dwAddr + 1),
														m_pMemory->ReadOnly(dwAddr + 2),
														m_pMemory->ReadOnly(dwAddr + 3));
					strText += strHex;
					dwAddr += 4;
				}
				break;
			// ̑(肦Ȃ)
			default:
				ASSERT(FALSE);
				break;
		}

		// x߂
		dwAddr -= 0x10;
		dwAddr &= 0xffffff;

		// ASCIILN^ǉ
		strText += _T("  ");
		for (x=0; x<16; x++) {
			szAscii[0] = (TCHAR)m_pMemory->ReadOnly(dwAddr + x);
			if ((szAscii[0] >= 0) && (szAscii[0] < 0x20)) {
				szAscii[0] = TCHAR('.');
			}
			if ((szAscii[0] < 0) || (szAscii[0] >= 0x7f)) {
				szAscii[0] = TCHAR('.');
			}
			strText += szAscii;
		}
		dwAddr += 0x10;
		dwAddr &= 0xffffff;

		// ItZbgi߂
		dwOffset += 0x10;

		// \
		if (m_ScrlX < strText.GetLength()) {
			SetString(0, y, (LPCTSTR)(strText) + m_ScrlX * sizeof(TCHAR));
		}
	}
}

//---------------------------------------------------------------------------
//
//	XN[()
//
//---------------------------------------------------------------------------
void FASTCALL CMemoryWnd::SetupScrlV()
{
	SCROLLINFO si;
	CRect rect;
	int height;

	// \LN^擾
	GetClientRect(&rect);
	height = rect.bottom / m_tmHeight;

	// ␳(XN[Pʂɂ2ŝ)
	height >>= 1;

	// XN[Zbg
	memset(&si, 0, sizeof(si));
	si.cbSize = sizeof(si);
	si.fMask = SIF_ALL;
	si.nMin = 0;
	si.nMax = m_ScrlHeight - 1;
	si.nPage = height;

	// ʒúAKvȂ␳
	si.nPos = m_ScrlY;
	if (si.nPos + height > m_ScrlHeight) {
		si.nPos = m_ScrlHeight - height;
		if (si.nPos < 0) {
			si.nPos = 0;
		}
		m_ScrlY = si.nPos;
	}

	SetScrollInfo(SB_VERT, &si, TRUE);
}

//---------------------------------------------------------------------------
//
//	X^bNj[ZbgAbv
//
//---------------------------------------------------------------------------
void CMemoryWnd::SetupStackMenu(CMenu *pMenu, Memory *pMemory, CPU *pCPU)
{
	int i;
	CPU::cpu_t reg;
	DWORD dwAddr;
	DWORD dwValue;
	CString strMenu;

	ASSERT(pMenu);
	ASSERT(pMemory);
	ASSERT(pCPU);

	// VMbNAWX^擾
	::LockVM();
	pCPU->GetCPU(&reg);

	// 16x
	for (i=0; i<16; i++) {
		// AhXZo
		dwAddr = reg.areg[7];
		dwAddr += (i << 1);
		dwAddr &= 0xfffffe;

		// f[^擾
		dwValue = pMemory->ReadOnly(dwAddr + 1);
		dwAddr = (dwAddr + 2) & 0xfffffe;
		dwValue <<= 8;
		dwValue |= pMemory->ReadOnly(dwAddr);
		dwValue <<= 8;
		dwValue |= pMemory->ReadOnly(dwAddr + 1);

		// j[XV
		strMenu.Format(_T("(A7+%1X) : $%06X"), (i << 1), dwValue);
		pMenu->ModifyMenu(IDM_STACK_0 + i, MF_BYCOMMAND | MF_STRING,
							IDM_STACK_0 + i, (LPCTSTR)strMenu);
	}

	// VMAbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	X^bNAhX擾
//
//---------------------------------------------------------------------------
DWORD CMemoryWnd::GetStackAddr(UINT nID, Memory *pMemory, CPU *pCPU)
{
	CPU::cpu_t reg;
	DWORD dwAddr;
	DWORD dwValue;

	ASSERT((nID >= IDM_STACK_0) && (nID <= IDM_STACK_F));
	ASSERT(pMemory);
	ASSERT(pCPU);

	// ItZbgZo
	nID -= IDM_STACK_0;
	ASSERT(nID <= 15);
	nID <<= 1;

	// CPUWX^AhXAZo
	::LockVM();
	pCPU->GetCPU(&reg);
	dwAddr = reg.areg[7];
	dwAddr += nID;
	dwAddr &= 0xfffffe;

	// f[^擾
	dwValue = pMemory->ReadOnly(dwAddr + 1);
	dwAddr = (dwAddr + 2) & 0xfffffe;
	dwValue <<= 8;
	dwValue |= pMemory->ReadOnly(dwAddr);
	dwValue <<= 8;
	dwValue |= pMemory->ReadOnly(dwAddr + 1);
	::UnlockVM();

	return dwValue;
}

//===========================================================================
//
//	u[N|CgEBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CBreakPWnd::CBreakPWnd()
{
	// EBhEp[^`
	m_dwID = MAKEID('B', 'R', 'K', 'P');
	::GetMsg(IDS_SWND_BREAKP, m_strCaption);
	m_nWidth = 43;
	m_nHeight = Scheduler::BreakMax + 1;

	// XPW[擾
	m_pScheduler = (Scheduler*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pScheduler);
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CBreakPWnd, CSubTextWnd)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDM_BREAKP_ENABLE, OnEnable)
	ON_COMMAND(IDM_BREAKP_CLEAR, OnClear)
	ON_COMMAND(IDM_BREAKP_DEL, OnDel)
	ON_COMMAND(IDM_BREAKP_ADDR, OnAddr)
	ON_COMMAND_RANGE(IDM_HISTORY_0, IDM_HISTORY_9, OnHistory)
	ON_COMMAND(IDM_BREAKP_ALL, OnAll)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	{^_uNbN
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnLButtonDblClk(UINT /*nFlags*/, CPoint point)
{
	int y;
	Scheduler::breakpoint_t buf;

	// y擾A␳(-1)A`FbN
	y = point.y / m_tmHeight;
	y--;
	if ((y < 0) || (y >= Scheduler::BreakMax)) {
		return;
	}

	// bNAu[N|Cg擾
	::LockVM();
	m_pScheduler->GetBreak(y, &buf);

	// gpȂ甽]
	if (buf.use) {
		m_pScheduler->EnableBreak(y, !(buf.enable));
	}

	// AbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	ReLXgj[
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CRect rect;
	CMenu menu;
	CMenu *pMenu;

	// NCAg̈ŉꂽ肷
	GetClientRect(&rect);
	ClientToScreen(&rect);
	if (!rect.PtInRect(point)) {
		CSubTextWnd::OnContextMenu(pWnd, point);
		return;
	}

	// ʒuL
	m_Point = point;

	// j[s
	if (::IsJapanese()) {
		menu.LoadMenu(IDR_BREAKPMENU);
	}
	else {
		menu.LoadMenu(IDR_US_BREAKPMENU);
	}
	pMenu = menu.GetSubMenu(0);
	SetupContext(pMenu);
	pMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
							point.x, point.y, this);
}

//---------------------------------------------------------------------------
//
//	ReLXgj[ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CBreakPWnd::SetupContext(CMenu *pMenu)
{
	int y;
	CPoint point;
	Scheduler::breakpoint_t buf;
	int nCount;
	int nBreak;

	ASSERT(pMenu);

	// 
	buf.enable = FALSE;
	buf.use = FALSE;

	// y擾
	point = m_Point;
	ScreenToClient(&point);
	y = point.y / m_tmHeight;
	y--;

	// u[N|Cg̎gp擾ƁAJg̎擾
	nCount = 0;
	::LockVM();
	for (nBreak=0; nBreak<Scheduler::BreakMax; nBreak++) {
		m_pScheduler->GetBreak(nBreak, &buf);
		if (buf.use) {
			nCount++;
		}
	}
	buf.use = FALSE;
	if ((y >= 0) && (y < Scheduler::BreakMax)) {
		m_pScheduler->GetBreak(y, &buf);
	}
	::UnlockVM();

	// Sč폜
	if (nCount > 0) {
		pMenu->EnableMenuItem(IDM_BREAKP_ALL, MF_BYCOMMAND | MF_ENABLED);
	}
	else {
		pMenu->EnableMenuItem(IDM_BREAKP_ALL, MF_BYCOMMAND | MF_GRAYED);
	}

	// AhXqXg
	CAddrDlg::SetupHisMenu(pMenu);

	// JggpȂAύXn͖
	if (!buf.use) {
		pMenu->EnableMenuItem(IDM_BREAKP_ENABLE, MF_BYCOMMAND | MF_GRAYED);
		pMenu->EnableMenuItem(IDM_BREAKP_CLEAR, MF_BYCOMMAND | MF_GRAYED);
		pMenu->EnableMenuItem(IDM_BREAKP_DEL, MF_BYCOMMAND | MF_GRAYED);
		return;
	}

	// gpȂAEnable`FbN
	if (buf.enable) {
		pMenu->CheckMenuItem(IDM_BREAKP_ENABLE, MF_BYCOMMAND | MF_CHECKED);
	}
	else {
		pMenu->CheckMenuItem(IDM_BREAKP_ENABLE, MF_BYCOMMAND | MF_UNCHECKED);
	}
}

//---------------------------------------------------------------------------
//
//	LE
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnEnable()
{
	int y;
	CPoint point;
	Scheduler::breakpoint_t buf;

	// y擾
	point = m_Point;
	ScreenToClient(&point);
	y = point.y / m_tmHeight;
	y--;
	ASSERT((y >= 0) && (y < Scheduler::BreakMax));

	// u[N|Cg]
	::LockVM();
	m_pScheduler->GetBreak(y, &buf);
	ASSERT(buf.use);
	m_pScheduler->EnableBreak(y, !(buf.enable));
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	񐔃NA
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnClear()
{
	int y;
	CPoint point;

	// y擾
	point = m_Point;
	ScreenToClient(&point);
	y = point.y / m_tmHeight;
	y--;
	ASSERT((y >= 0) && (y < Scheduler::BreakMax));

	// 񐔃NA
	::LockVM();
	m_pScheduler->ClearBreak(y);
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	u[N|Cg폜
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnDel()
{
	int y;
	CPoint point;
	Scheduler::breakpoint_t buf;

	// y擾
	point = m_Point;
	ScreenToClient(&point);
	y = point.y / m_tmHeight;
	y--;
	ASSERT((y >= 0) && (y < Scheduler::BreakMax));

	// 񐔃NA
	::LockVM();
	m_pScheduler->GetBreak(y, &buf);
	ASSERT(buf.use);
	m_pScheduler->DelBreak(buf.addr);
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	AhXw
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnAddr()
{
	int y;
	CPoint point;
	Scheduler::breakpoint_t buf;
	CPU *pCPU;
	CPU::cpu_t reg;
	DWORD dwAddr;
	CAddrDlg dlg(this);

	// y擾
	point = m_Point;
	ScreenToClient(&point);
	y = point.y / m_tmHeight;
	y--;

	::LockVM();
	// Lȃu[N|CgwĂ΁ÃAhX
	dwAddr = 0xffffffff;
	if ((y >= 0) && (y < Scheduler::BreakMax)) {
		m_pScheduler->GetBreak(y, &buf);
		if (buf.use) {
			dwAddr = buf.addr & 0xffffff;
		}
	}
	// łȂ΁APC
	if (dwAddr == 0xffffffff) {
		pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
		ASSERT(pCPU);
		pCPU->GetCPU(&reg);
		dwAddr = reg.pc & 0xffffff;
	}
	::UnlockVM();
	ASSERT(dwAddr <= 0xffffff);

	// ̓_CAO
	dlg.m_dwValue = dwAddr;
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// ʃ[`ɂ܂
	SetAddr(dlg.m_dwValue);
}

//---------------------------------------------------------------------------
//
//	AhXqXg
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnHistory(UINT nID)
{
	DWORD dwAddr;

	ASSERT((nID >= IDM_HISTORY_0) && (nID <= IDM_HISTORY_9));

	// ʃ[`ɂ܂
	dwAddr = CAddrDlg::GetAddr(nID);
	SetAddr(dwAddr);
}

//---------------------------------------------------------------------------
//
//	Sč폜
//
//---------------------------------------------------------------------------
void CBreakPWnd::OnAll()
{
	Scheduler::breakpoint_t buf;
	int i;

	// SăNA
	::LockVM();
	for (i=0; i<Scheduler::BreakMax; i++) {
		m_pScheduler->GetBreak(i, &buf);
		if (buf.use) {
			m_pScheduler->DelBreak(buf.addr);
		}
	}
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	AhXݒ
//
//---------------------------------------------------------------------------
void FASTCALL CBreakPWnd::SetAddr(DWORD dwAddr)
{
	int y;
	CPoint point;
	Scheduler::breakpoint_t buf;

	ASSERT(dwAddr <= 0xffffff);

	// ɓo^ĂAhXȂA
	::LockVM();
	for (y=0; y<Scheduler::BreakMax; y++) {
		m_pScheduler->GetBreak(y, &buf);
		if (buf.use) {
			if (buf.addr == dwAddr) {
				::UnlockVM();
				return;
			}
		}
	}
	::UnlockVM();

	// y擾
	point = m_Point;
	ScreenToClient(&point);
	y = point.y / m_tmHeight;
	y--;

	// gp̃u[N|CgwĂ΁Aւ
	::LockVM();
	if ((y >= 0) && (y < Scheduler::BreakMax)) {
		m_pScheduler->GetBreak(y, &buf);
		if (buf.use) {
			m_pScheduler->AddrBreak(y, dwAddr);
			::UnlockVM();
			return;
		}
	}

	// łȂ΁AVKݒ
	m_pScheduler->SetBreak(dwAddr);
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CBreakPWnd::Setup()
{
	int i;
	CString strText;
	CString strFmt;
	Scheduler::breakpoint_t buf;

	// NA
	Clear();

	// KCh\
	SetString(0, 0, _T("No."));
	SetString(5, 0, _T("Address"));
	SetString(14, 0, _T("Flag"));
	SetString(28, 0, _T("Time"));
	SetString(38, 0, _T("Count"));

	// [v
	for (i=0; i<Scheduler::BreakMax; i++) {
		// ԍ
		strText.Format(_T("%2d "), i + 1);

		// 擾AL`FbN
		m_pScheduler->GetBreak(i, &buf);
		if (buf.use) {
			// AhX
			strFmt.Format(_T("  $%06X "), buf.addr);
			strText += strFmt;

			// tO
			if (buf.enable) {
				strText += _T(" Enable");
			}
			else {
				strText += _T("Disable");
			}

			// 
			if (buf.count > 0) {
				strFmt.Format(_T(" %7d.%05dms"), (buf.time / 2000), (buf.time % 2000) * 5);
				strText += strFmt;

				// JEg
				strFmt.Format(_T("   %4d"), buf.count);
				strText += strFmt;
			}
		}

		// Zbg
		SetString(0, i + 1, strText);
	}
}

#endif	// _WIN32
