//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TuEBhE(CPU) ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_cpu_h)
#define mfc_cpu_h

#include "mfc_sub.h"

//===========================================================================
//
//	qXgt_CAO
//
//===========================================================================
class CHistoryDlg : public CDialog
{
public:
	CHistoryDlg(UINT nID, CWnd *pParentWnd);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	void OnOK();
										// OK
	DWORD m_dwValue;
										// GfBbgl

protected:
	virtual UINT* GetNumPtr() = 0;
										// qXg|C^擾
	virtual DWORD* GetDataPtr() = 0;
										// qXgf[^|C^擾
	UINT m_nBit;
										// Lrbg
	DWORD m_dwMask;
										// }XN(rbg)
};

//===========================================================================
//
//	AhX̓_CAO
//
//===========================================================================
class CAddrDlg : public CHistoryDlg
{
public:
	CAddrDlg(CWnd *pParent = NULL);
										// RXgN^
	static void SetupHisMenu(CMenu *pMenu);
										// j[ZbgAbv
	static DWORD GetAddr(UINT nID);
										// j[ʎ擾

protected:
	UINT* GetNumPtr();
										// qXg|C^擾
	DWORD* GetDataPtr();
										// qXgf[^|C^擾
	static UINT m_Num;
										// qXg
	static DWORD m_Data[10];
										// qXgf[^
};

//===========================================================================
//
//	WX^̓_CAO
//
//===========================================================================
class CRegDlg : public CHistoryDlg
{
public:
	CRegDlg(CWnd *pParent = NULL);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	void OnOK();
										// OK
	UINT m_nIndex;
										// WX^CfbNX

protected:
	UINT* GetNumPtr();
										// qXg|C^擾
	DWORD* GetDataPtr();
										// qXgf[^|C^擾
	static UINT m_Num;
										// qXg
	static DWORD m_Data[10];
										// qXgf[^
};

//===========================================================================
//
//	f[^̓_CAO
//
//===========================================================================
class CDataDlg : public CHistoryDlg
{
public:
	CDataDlg(CWnd *pParent = NULL);
										// RXgN^
	BOOL OnInitDialog();
										// _CAO
	UINT m_nSize;
										// TCY
	DWORD m_dwAddr;
										// AhX

protected:
	UINT* GetNumPtr();
										// qXg|C^擾
	DWORD* GetDataPtr();
										// qXgf[^|C^擾
	static UINT m_Num;
										// qXg
	static DWORD m_Data[10];
										// qXgf[^
};

//===========================================================================
//
//	MPUWX^EBhE
//
//===========================================================================
class CCPURegWnd : public CSubTextWnd
{
public:
	CCPURegWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv
	static void SetupRegMenu(CMenu *pMenu, CPU *pCPU, BOOL bSR);
										// j[ZbgAbv
	static DWORD GetRegValue(CPU *pCPU, UINT uID);
										// WX^l擾

protected:
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnReg(UINT nID);
										// WX^I

private:
	CPU *m_pCPU;
										// CPU

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	荞݃EBhE
//
//===========================================================================
class CIntWnd : public CSubTextWnd
{
public:
	CIntWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

protected:
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[

private:
	CPU* m_pCPU;
										// CPU

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	tAZuEBhE
//
//===========================================================================
class CDisasmWnd : public CSubTextScrlWnd
{
public:
	CDisasmWnd(int index);
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv
	void FASTCALL SetAddr(DWORD dwAddr);
										// AhXw
	void FASTCALL SetPC(DWORD pc);
										// PCw
	void FASTCALL Update();
										// bZ[WXbh̍XV
	static void FASTCALL SetupBreakMenu(CMenu *pMenu, Scheduler *pScheduler);
										// u[N|Cgj[ݒ
	static DWORD FASTCALL GetBreak(UINT nID, Scheduler *pScheduler);
										// u[N|Cg擾

protected:
	afx_msg int OnCreate(LPCREATESTRUCT lpcs);
										// EBhE쐬
	afx_msg void OnDestroy();
										// EBhE폜
	afx_msg void OnSize(UINT nType, int cx, int cy);
										// TCYύX
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
										// NbN
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pBar);
										// XN[
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnNewWin();
										// VEBhE
	afx_msg void OnPC();
										// PCֈړ
	afx_msg void OnSync();
										// PCɓ
	afx_msg void OnAddr();
										// AhX
	afx_msg void OnReg(UINT nID);
										// WX^
	afx_msg void OnStack(UINT nID);
										// X^bN
	afx_msg void OnBreak(UINT nID);
										// u[N|Cg
	afx_msg void OnHistory(UINT nID);
										// AhXqXg
	afx_msg void OnCPUExcept(UINT nID);
										// CPUOxN^
	afx_msg void OnTrap(UINT nID);
										// trapxN^
	afx_msg void OnMFP(UINT nID);
										// MFPxN^
	afx_msg void OnSCC(UINT nID);
										// SCCxN^
	afx_msg void OnDMAC(UINT uID);
										// DMACxN^
	afx_msg void OnIOSC(UINT uID);
										// IOSCxN^

private:
	DWORD FASTCALL GetPrevAddr(DWORD dwAddr);
										// ÕAhX擾
	void FASTCALL SetupContext(CMenu *pMenu);
										// ReLXgj[ZbgAbv
	void FASTCALL SetupVector(CMenu *pMenu, UINT index, DWORD vector, int num);
										// 荞݃xN^ZbgAbv
	void FASTCALL SetupAddress(CMenu *pMenu, UINT index, DWORD addr);
										// AhXZbgAbv
	void FASTCALL OnVector(UINT vector);
										// xN^w
	CPU *m_pCPU;
										// CPU
	Scheduler *m_pScheduler;
										// XPW[
	MFP *m_pMFP;
										// MFP
	Memory *m_pMemory;
										// 
	SCC * m_pSCC;
										// SCC
	DMAC *m_pDMAC;
										// DMAC
	IOSC *m_pIOSC;
										// IOSC
	BOOL m_bSync;
										// PCtO
	DWORD m_dwPC;
										// PC
	DWORD m_dwAddr;
										// \JnAhX
	DWORD m_dwSetAddr;
										// ZbgꂽAhX
	DWORD *m_pAddrBuf;
										// AhXobt@
	CString m_Caption;
										// LvV
	CString m_CaptionSet;
										// LvVݒ蕶

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	EBhE
//
//===========================================================================
class CMemoryWnd : public CSubTextScrlWnd
{
public:
	CMemoryWnd(int nWnd);
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv
	void FASTCALL SetAddr(DWORD dwAddr);
										// AhXw
	void FASTCALL SetUnit(int nUnit);
										// \Pʎw
	void FASTCALL Update();
										// bZ[WXbh̍XV
	static void SetupStackMenu(CMenu *pMenu, Memory *pMemory, CPU *pCPU);
										// X^bNj[ZbgAbv
	static DWORD GetStackAddr(UINT nID, Memory *pMemory, CPU *pCPU);
										// X^bN擾

protected:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EBhE쐬
	afx_msg void OnPaint();
										// `
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnAddr();
										// AhX
	afx_msg void OnNewWin();
										// VEBhE
	afx_msg void OnUnit(UINT uID);
										// \Pʎw
	afx_msg void OnRange(UINT uID);
										// AhX͈͎w
	afx_msg void OnReg(UINT uID);
										// WX^lw
	afx_msg void OnArea(UINT uID);
										// GAw
	afx_msg void OnHistory(UINT uID);
										// AhXqXg
	afx_msg void OnStack(UINT uID);
										// X^bN
	void FASTCALL SetupScrlV();
										// XN[()

private:
	void FASTCALL SetupContext(CMenu *pMenu);
										// ReLXgj[ ZbgAbv
	Memory *m_pMemory;
										// 
	CPU *m_pCPU;
										// CPU
	DWORD m_dwAddr;
										// \JnAhX
	CString m_strCaptionReq;
										// LvV(v)
	CString m_strCaptionSet;
										// LvV(ݒ)
	CCriticalSection m_CSection;
										// NeBJZNV
	UINT m_nUnit;
										// \TCY0/1/2=Byte/Word/Long

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

//===========================================================================
//
//	u[N|CgEBhE
//
//===========================================================================
class CBreakPWnd : public CSubTextWnd
{
public:
	CBreakPWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

protected:
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnEnable();
										// LE
	afx_msg void OnClear();
										// 񐔃NA
	afx_msg void OnDel();
										// 폜
	afx_msg void OnAddr();
										// AhXw
	afx_msg void OnAll();
										// Sč폜
	afx_msg void OnHistory(UINT nID);
										// AhXqXg

private:
	void FASTCALL SetupContext(CMenu *pMenu);
										// ReLXgj[ ZbgAbv
	void FASTCALL SetAddr(DWORD dwAddr);
										// AhXݒ
	Scheduler* m_pScheduler;
										// XPW[
	CPoint m_Point;
										// ReLXgj[|Cg

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

#endif	// mfc_cpu_h
#endif	// _WIN32
