//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TuEBhE(foCX) ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_dev_h)
#define mfc_dev_h

#include "mfp.h"
#include "dmac.h"
#include "scc.h"
#include "fdc.h"
#include "midi.h"
#include "sasi.h"
#include "scsi.h"
#include "mfc_sub.h"

//===========================================================================
//
//	MFPEBhE
//
//===========================================================================
class CMFPWnd : public CSubTextWnd
{
public:
	CMFPWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupInt(int x, int y);
										// ZbgAbv(荞)
	void FASTCALL SetupGPIP(int x, int y);
										// ZbgAbv(GPIP)
	void FASTCALL SetupTimer(int x, int y);
										// ZbgAbv(^C})
	static LPCTSTR DescInt[];
										// 荞݃e[u
	static LPCTSTR DescGPIP[];
										// GPIPe[u
	static LPCTSTR DescTimer[];
										// ^C}e[u
	MFP *m_pMFP;
										// MFP
	MFP::mfp_t m_mfp;
										// MFPf[^
};

//===========================================================================
//
//	DMACEBhE
//
//===========================================================================
class CDMACWnd : public CSubTextWnd
{
public:
	CDMACWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupCh(int nCh, DMAC::dma_t *pDMA, LPCTSTR lpszTitle);
										// ZbgAbv(`l)
	DMAC *m_pDMAC;
										// DMAC
};

//===========================================================================
//
//	CRTCEBhE
//
//===========================================================================
class CCRTCWnd : public CSubTextWnd
{
public:
	CCRTCWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	CRTC *m_pCRTC;
										// CRTC
};

//===========================================================================
//
//	VCEBhE
//
//===========================================================================
class CVCWnd : public CSubTextWnd
{
public:
	CVCWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	VC *m_pVC;
										// VC
};

//===========================================================================
//
//	RTCEBhE
//
//===========================================================================
class CRTCWnd : public CSubTextWnd
{
public:
	CRTCWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	RTC* m_pRTC;
										// FDC
};

//===========================================================================
//
//	OPMEBhE
//
//===========================================================================
class COPMWnd : public CSubTextWnd
{
public:
	COPMWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	OPMIF *m_pOPM;
										// OPM
};

//===========================================================================
//
//	L[{[hEBhE
//
//===========================================================================
class CKeyboardWnd : public CSubTextWnd
{
public:
	CKeyboardWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	static LPCTSTR DescLED[];
										// LEDe[u
	Keyboard *m_pKeyboard;
										// L[{[h
};

//===========================================================================
//
//	FDDEBhE
//
//===========================================================================
class CFDDWnd : public CSubTextWnd
{
public:
	CFDDWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupFDD(int nDrive, int x);
										// ZbgAbvTu
	BOOL FASTCALL SetupTrack();
										// ZbgAbvgbN
	static LPCTSTR DescTable[];
										// e[u
	FDD *m_pFDD;
										// FDD
	FDC *m_pFDC;
										// FDC
	DWORD m_dwDrive;
										// ANZXhCu
	DWORD m_dwHD;
										// ANZXwbh
	DWORD m_CHRN[4];
										// ANZXCHRN
};

//===========================================================================
//
//	FDCEBhE
//
//===========================================================================
class CFDCWnd : public CSubTextWnd
{
public:
	CFDCWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupGeneral(int x, int y);
										// ZbgAbv()
	void FASTCALL SetupParam(int x, int y);
										// ZbgAbv(p[^)
	void FASTCALL SetupSR(int x, int y);
										// ZbgAbv(Xe[^XWX^)
	static LPCTSTR SRDesc[8];
										// (Xe[^XWX^)
	void FASTCALL SetupST0(int x, int y);
										// ZbgAbv(ST0)
	static LPCTSTR ST0Desc[8];
										// (ST0)
	void FASTCALL SetupST1(int x, int y);
										// ZbgAbv(ST1)
	static LPCTSTR ST1Desc[8];
										// (ST1)
	void FASTCALL SetupST2(int x, int y);
										// ZbgAbv(ST2)
	static LPCTSTR ST2Desc[8];
										// (ST2)
	void FASTCALL SetupSub(int x, int y, LPCTSTR lpszTitle, LPCTSTR *lpszDesc,
					DWORD data);		// ZbgAbv(Tu)
	FDC *m_pFDC;
										// FDC
	const FDC::fdc_t *m_pWork;
										// FDCf[^
};

//===========================================================================
//
//	SCCEBhE
//
//===========================================================================
class CSCCWnd : public CSubTextWnd
{
public:
	CSCCWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupSCC(SCC::ch_t *pCh, int x, int y);
										// ZbgAbv(`l)
	SCC *m_pSCC;
										// SCC
	static LPCTSTR DescTable[];
										// e[u
};

//===========================================================================
//
//	CynthiaEBhE
//
//===========================================================================
class CCynthiaWnd : public CSubTextWnd
{
public:
	CCynthiaWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	Sprite *m_pSprite;
										// CYNTHIA
};

//===========================================================================
//
//	SASIEBhE
//
//===========================================================================
class CSASIWnd : public CSubTextWnd
{
public:
	CSASIWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupCmd(int x, int y);
										// ZbgAbv(R}h)
	void FASTCALL SetupCtrl(int x, int y);
										// ZbgAbv(Rg[)
	void FASTCALL SetupDrive(int x, int y);
										// ZbgAbv(hCu)
	void FASTCALL SetupCache(int x, int y);
										// ZbgAbv(LbV)
	SASI *m_pSASI;
										// SASI
	SASI::sasi_t m_sasi;
										// SASIf[^
};

//===========================================================================
//
//	MIDIEBhE
//
//===========================================================================
class CMIDIWnd : public CSubTextWnd
{
public:
	CMIDIWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupCtrl(int x, int y);
										// ZbgAbv(Rg[)
	static LPCTSTR DescCtrl[];
										// e[u(Rg[)
	void FASTCALL SetupInt(int x, int y);
										// ZbgAbv(荞)
	static LPCTSTR DescInt[];
										// e[u(荞)
	void FASTCALL SetupTrans(int x, int y);
										// ZbgAbv(M)
	static LPCTSTR DescTrans[];
										// e[u(M)
	void FASTCALL SetupRecv(int x, int y);
										// ZbgAbv(M)
	static LPCTSTR DescRecv[];
										// e[u(M)
	void FASTCALL SetupRT(int x, int y);
										// ZbgAbv(A^CM)
	static LPCTSTR DescRT[];
										// e[u(A^CM)
	void FASTCALL SetupRR(int x, int y);
										// ZbgAbv(A^CM)
	static LPCTSTR DescRR[];
										// e[u(A^CM)
	void FASTCALL SetupCount(int x, int y);
										// ZbgAbv(JE^)
	static LPCTSTR DescCount[];
										// e[u(JE^)
	void FASTCALL SetupHunter(int x, int y);
										// ZbgAbv(AhXn^)
	static LPCTSTR DescHunter[];
										// e[u(AhXn^)
	void FASTCALL SetupFSK(int x, int y);
										// ZbgAbv(FSK)
	static LPCTSTR DescFSK[];
										// e[u(FSK)
	void FASTCALL SetupGPIO(int x, int y);
										// ZbgAbv(GPIO)
	static LPCTSTR DescGPIO[];
										// e[u(GPIO)

	MIDI *m_pMIDI;
										// MIDI
	MIDI::midi_t m_midi;
										// MIDIf[^
};

//===========================================================================
//
//	SCSIEBhE
//
//===========================================================================
class CSCSIWnd : public CSubTextWnd
{
public:
	CSCSIWnd();
										// RXgN^
	void FASTCALL Setup();
										// ZbgAbv

private:
	void FASTCALL SetupCmd(int x, int y);
										// ZbgAbv(R}h)
	void FASTCALL SetupCtrl(int x, int y);
										// ZbgAbv(Rg[)
	void FASTCALL SetupDrive(int x, int y);
										// ZbgAbv(hCu)
	void FASTCALL SetupReg(int x, int y);
										// ZbgAbv(WX^)
	void FASTCALL SetupCDB(int x, int y);
										// ZbgAbv(CDB)
	SCSI *m_pSCSI;
										// SCSI
	SCSI::scsi_t m_scsi;
										// SCSIf[^
};

#endif	// mfc_dev_h
#endif	// _WIN32
