//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Drawr[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "render.h"
#include "crtc.h"
#include "config.h"
#include "mfc_sub.h"
#include "mfc_frm.h"
#include "mfc_com.h"
#include "mfc_sch.h"
#include "mfc_cpu.h"
#include "mfc_cfg.h"
#include "mfc_res.h"
#include "mfc_sch.h"
#include "mfc_inp.h"
#include "mfc_draw.h"

//===========================================================================
//
//	Drawr[
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CDrawView::CDrawView()
{
	// [N({)
	m_bEnable = FALSE;
	m_pSubWnd = NULL;
	m_pFrmWnd = NULL;

	// R|[lg
	m_pScheduler = NULL;
	m_pInput = NULL;

	// [N(`S)
	m_Info.bPower = FALSE;
	m_Info.pRender = NULL;
	m_Info.pWork = NULL;
	m_Info.dwDrawCount = 0;

	// [N(DIBZNV)
	m_Info.hBitmap = NULL;
	m_Info.pBits = NULL;
	m_Info.nBMPWidth = 0;
	m_Info.nBMPHeight = 0;

	// [N(TCY)
	m_Info.nRendWidth = 0;
	m_Info.nRendHeight = 0;
	m_Info.nRendHMul = 0;
	m_Info.nRendVMul = 0;
	m_Info.nLeft = 0;
	m_Info.nTop = 0;
	m_Info.nWidth = 0;
	m_Info.nHeight = 0;

	// [N(Blt)
	m_Info.nBltTop = 0;
	m_Info.nBltBottom = 0;
	m_Info.nBltLeft = 0;
	m_Info.nBltRight = 0;
	m_Info.bBltAll = TRUE;
	m_Info.bBltStretch = FALSE;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CDrawView, CView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_MESSAGE(WM_DISPLAYCHANGE, OnDisplayChange)
	ON_WM_DROPFILES()
#if _MFC_VER >= 0x600
	ON_WM_MOUSEWHEEL()
#endif	// _MFC_VER
	ON_WM_KEYDOWN()
	ON_WM_SYSKEYDOWN()
	ON_WM_KEYUP()
	ON_WM_SYSKEYUP()
	ON_WM_MOVE()
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDrawView::Init(CWnd *pParent)
{
	ASSERT(pParent);

	// t[EBhEL
	m_pFrmWnd = (CFrmWnd*)pParent;

	// ŏ̃r[Ƃč쐬
	if (!Create(NULL, NULL, WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN,
				CRect(0, 0, 0, 0), pParent, AFX_IDW_PANE_FIRST, NULL)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
BOOL CDrawView::PreCreateWindow(CREATESTRUCT& cs)
{
	// {NX
	if (!CView::PreCreateWindow(cs)) {
		return FALSE;
	}

	// WS_CLIPCHILDRENǉ
	cs.style |= WS_CLIPCHILDREN;

	// NCAgGbWǉ
	cs.dwExStyle |= WS_EX_CLIENTEDGE;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
int CDrawView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	// {NX
	if (CView::OnCreate(lpCreateStruct) != 0) {
		return -1;
	}

	// IMEIt
	::ImmAssociateContext(m_hWnd, (HIMC)NULL);

	// eLXgtHg쐬
	if (IsJapanese()) {
		// {
		m_TextFont.CreateFont(14, 0, 0, 0,
							FW_NORMAL, 0, 0, 0,
							SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
							CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
							FIXED_PITCH, NULL);
	}
	else {
		// p
		m_TextFont.CreateFont(14, 0, 0, 0,
							FW_NORMAL, 0, 0, 0,
							DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
							CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
							FIXED_PITCH, NULL);
	}

	// hbOhbv
	DragAcceptFiles(TRUE);

	return 0;
}

//---------------------------------------------------------------------------
//
//	EBhE폜
//
//---------------------------------------------------------------------------
void CDrawView::OnDestroy()
{
	// ~
	Enable(FALSE);

	// rbg}bv폜
	if (m_Info.hBitmap) {
		::DeleteObject(m_Info.hBitmap);
		m_Info.hBitmap = NULL;
		m_Info.pBits = NULL;
	}

	// eLXgtHg폜
	m_TextFont.DeleteObject();

	// {NX
	CView::OnDestroy();
}

//---------------------------------------------------------------------------
//
//	TCYύX
//
//---------------------------------------------------------------------------
void CDrawView::OnSize(UINT nType, int cx, int cy)
{
	// rbg}bv̍XV
	SetupBitmap();

	// {NX
	CView::OnSize(nType, cx, cy);
}

//---------------------------------------------------------------------------
//
//	`
//
//---------------------------------------------------------------------------
void CDrawView::OnPaint()
{
	Render *pRender;
	CRTC *pCRTC;
	const CRTC::crtc_t *p;
	CFrmWnd *pFrmWnd;
	PAINTSTRUCT ps;

	// VMbN
	::LockVM();

	// S`tOON
	m_Info.bBltAll = TRUE;

	// Cl[uŃXPW[OFFȂAMixobt@ɍ쐬(Ȃ苭)
	if (m_bEnable) {
		pFrmWnd = (CFrmWnd*)GetParent();
		ASSERT(pFrmWnd);
		if (!pFrmWnd->GetScheduler()->IsEnable()) {
			// Cl[uȂKRender,CRTC͑
			pRender = (Render*)::GetVM()->SearchDevice(MAKEID('R', 'E', 'N', 'D'));
			ASSERT(pRender);
			pCRTC = (CRTC*)::GetVM()->SearchDevice(MAKEID('C', 'R', 'T', 'C'));
			ASSERT(pCRTC);
			p = pCRTC->GetWorkAddr();

			// 쐬
			m_Info.bPower = ::GetVM()->IsPower();
			if (m_Info.bPower) {
				pRender->Complete();
				pRender->EnableAct(TRUE);
				pRender->StartFrame();
				pRender->HSync(p->v_dots);
				pRender->EndFrame();
			}
			else {
				// rbg}bvׂď
				memset(m_Info.pBits, 0, m_Info.nBMPWidth * m_Info.nBMPHeight * 4);
			}

			// `(CDrawView::OnDrawւȂ)
			CView::OnPaint();

			// VMAbN
			::UnlockVM();
			return;
		}
	}

	// DCĂ(_~[)
	BeginPaint(&ps);
	EndPaint(&ps);

	// VMAbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	wi`
//
//---------------------------------------------------------------------------
BOOL CDrawView::OnEraseBkgnd(CDC *pDC)
{
	CRect rect;

	// Cl[ułȂ΁AœhԂ
	if (!m_bEnable) {
		GetClientRect(&rect);
		pDC->FillSolidRect(&rect, RGB(0, 0, 0));
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	\ύX
//
//---------------------------------------------------------------------------
LRESULT CDrawView::OnDisplayChange(WPARAM /* wParam */, LPARAM /* lParam */)
{
	// rbg}bv
	SetupBitmap();

	return 0;
}

//---------------------------------------------------------------------------
//
//	t@Chbv
//
//---------------------------------------------------------------------------
void CDrawView::OnDropFiles(HDROP hDropInfo)
{
	TCHAR szPath[_MAX_PATH];
	POINT point;
	CRect rect;
	int nFiles;
	int nDrive;

	// hbvꂽt@Č𓾂
	nFiles = ::DragQueryFile(hDropInfo, 0xffffffff, szPath, _MAX_PATH);
	ASSERT(nFiles > 0);

	// hbvꂽʒuAhCuo
	::DragQueryPoint(hDropInfo, &point);
	GetClientRect(rect);
	if (point.x < (rect.right >> 1)) {
		// (hCu0)
		nDrive = 0;
	}
	else {
		// E(hCu1)
		nDrive = 1;
	}

	// t@Cŕ
	if (nFiles == 1) {
		// VOt@ĆAEBhE̍EE
		::DragQueryFile(hDropInfo, 0, szPath, _MAX_PATH);
		m_pFrmWnd->InitCmdSub(nDrive, szPath);
	}
	else {
		// _ut@ĆAꂼ0,1
		::DragQueryFile(hDropInfo, 0, szPath, _MAX_PATH);
		m_pFrmWnd->InitCmdSub(0, szPath);
		::DragQueryFile(hDropInfo, 1, szPath, _MAX_PATH);
		m_pFrmWnd->InitCmdSub(1, szPath);
	}

	// I
	::DragFinish(hDropInfo);

	// _ut@C̓Zbg
	if (nFiles > 1) {
		m_pFrmWnd->PostMessage(WM_COMMAND, IDM_RESET, 0);
	}
}

//---------------------------------------------------------------------------
//
//	}EXzC[
//
//---------------------------------------------------------------------------
BOOL CDrawView::OnMouseWheel(UINT /*nFlags*/, short zDelta, CPoint /*pt*/)
{
	CConfig *pConfig;

	// RtBO擾
	pConfig = m_pFrmWnd->GetConfig();

	// VMbN
	::LockVM();

	// ŽɂĕύX
	if (zDelta > 0) {
		// |g傷
		Stretch(TRUE);
		pConfig->SetStretch(TRUE);
	}
	else {
		// O|g債Ȃ
		Stretch(FALSE);
		pConfig->SetStretch(FALSE);
	}

	// VMAbN
	::UnlockVM();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	L[
//
//---------------------------------------------------------------------------
void CDrawView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// OL[𔻕
	if (!KeyUpDown(nChar, nFlags, TRUE)) {
		return;
	}

	// {NX֗
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

//---------------------------------------------------------------------------
//
//	VXeL[
//
//---------------------------------------------------------------------------
void CDrawView::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// OL[𔻕
	if (!KeyUpDown(nChar, nFlags, TRUE)) {
		return;
	}

	// {NX֗
	CView::OnSysKeyDown(nChar, nRepCnt, nFlags);
}

//---------------------------------------------------------------------------
//
//	L[
//
//---------------------------------------------------------------------------
void CDrawView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// OL[𔻕
	if (!KeyUpDown(nChar, nFlags, FALSE)) {
		return;
	}

	// {NX֗
	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

//---------------------------------------------------------------------------
//
//	VXeL[
//
//---------------------------------------------------------------------------
void CDrawView::OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// OL[𔻕
	if (!KeyUpDown(nChar, nFlags, FALSE)) {
		return;
	}

	// {NX֗
	CView::OnSysKeyUp(nChar, nRepCnt, nFlags);
}

//---------------------------------------------------------------------------
//
//	L[
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDrawView::KeyUpDown(UINT nChar, UINT nFlags, BOOL bDown)
{
#if defined(INPUT_MOUSE) && defined(INPUT_KEYBOARD) && defined(INPUT_HARDWARE)
	INPUT input;

	ASSERT(this);
	ASSERT(nChar < 0x100);

	// XPW[擾
	if (!m_pScheduler) {
		m_pScheduler = m_pFrmWnd->GetScheduler();
		if (!m_pScheduler) {
			// XPW[݂Ȃ̂ŁAOȂ
			return TRUE;
		}
	}

	// Cvbg擾
	if (!m_pInput) {
		m_pInput = m_pFrmWnd->GetInput();
		if (!m_pScheduler) {
			// Cvbg݂Ȃ̂ŁAOȂ
			return TRUE;
		}
	}

	// XPW[~Ă΁AOȂ
	if (!m_pScheduler->IsEnable()) {
		return TRUE;
	}

	// CvbgANeBu̓j[ȂAOȂ
	if (!m_pInput->IsActive()) {
		return TRUE;
	}
	if (m_pInput->IsMenu()) {
		return TRUE;
	}

	// L[̔
	switch (nChar) {
		// F10
		case VK_F10:
			if (m_pInput->IsKeyMapped(DIK_F10)) {
				// }bvĂ
				return FALSE;
			}
			// }bvĂȂ
			return TRUE;

		// ALT
		case VK_LMENU:
			if (m_pInput->IsKeyMapped(DIK_LMENU)) {
				if (bDown) {
					// ̃L[荞܂
					memset(&input, 0, sizeof(input));
					input.type = INPUT_KEYBOARD;
					input.ki.wVk = VK_SHIFT;
					::SendInput(1, &input, sizeof(INPUT));
					input.type = INPUT_KEYBOARD;
					input.ki.wVk = VK_SHIFT;
					input.ki.dwFlags = KEYEVENTF_KEYUP;
					::SendInput(1, &input, sizeof(INPUT));
				}

				// }bvĂ
				return FALSE;
			}
			// }bvĂȂ
			return TRUE;

		// EALT
		case VK_RMENU:
			if (m_pInput->IsKeyMapped(DIK_RMENU)) {
				// }bvĂ
				return FALSE;
			}
			// }bvĂȂ
			return TRUE;

		// ALT
		case VK_MENU:
			if (m_pInput->IsKeyMapped(DIK_LMENU) || m_pInput->IsKeyMapped(DIK_RMENU)) {
				// }bvĂ
				return FALSE;
			}
			// }bvĂȂ
			return TRUE;

		// Windows
		case VK_LWIN:
			if (m_pInput->IsKeyMapped(DIK_LWIN)) {
				// }bvĂ
				if (bDown) {
					memset(&input, 0, sizeof(input));
					input.type = INPUT_KEYBOARD;
					input.ki.wVk = VK_SHIFT;
					::SendInput(1, &input, sizeof(INPUT));
					input.type = INPUT_KEYBOARD;
					input.ki.wVk = VK_SHIFT;
					input.ki.dwFlags = KEYEVENTF_KEYUP;
					::SendInput(1, &input, sizeof(INPUT));
				}
				return FALSE;
			}
			// }bvĂȂ
			return TRUE;

		// EWindows
		case VK_RWIN:
			if (m_pInput->IsKeyMapped(DIK_RWIN)) {
				// }bvĂ
				if (bDown) {
					// WindowsL[ubN̂ł͂ȂÃL[荞܂
					memset(&input, 0, sizeof(input));
					input.type = INPUT_KEYBOARD;
					input.ki.wVk = VK_SHIFT;
					::SendInput(1, &input, sizeof(INPUT));
					input.type = INPUT_KEYBOARD;
					input.ki.wVk = VK_SHIFT;
					input.ki.dwFlags = KEYEVENTF_KEYUP;
					::SendInput(1, &input, sizeof(INPUT));
				}
				return FALSE;
			}
			// }bvĂȂ
			return TRUE;

		// ̑
		default:
			// ALT̃L[
			if (nFlags & 0x2000) {
				// ALT܂͉EALT}bvĂ邩
				if (m_pInput->IsKeyMapped(DIK_LMENU) || m_pInput->IsKeyMapped(DIK_RMENU)) {
					// ǂ炩ALT}bvĂ΁AALT+L[𖳌
					return FALSE;
				}
			}
			break;
	}
#endif	// INPUT_MOUSE && INPUT_KEYBOARD && INPUT_HARDWARE

	// ȊÓA
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhEړ
//
//---------------------------------------------------------------------------
void CDrawView::OnMove(int x, int y)
{
	ASSERT(m_pFrmWnd);

	// {NX
	CView::OnMove(x, y);

	// t[EBhE̍ĔzuĂ
	m_pFrmWnd->RecalcStatusView();
}

//---------------------------------------------------------------------------
//
//	rbg}bv
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::SetupBitmap()
{
	CClientDC *pDC;
	BITMAPINFOHEADER *p;
	CRect rect;

	// rbg}bv΁AU
	if (m_Info.hBitmap) {
		if (m_Info.pRender) {
			m_Info.pRender->SetMixBuf(NULL, 0, 0);
		}
		::DeleteObject(m_Info.hBitmap);
		m_Info.hBitmap = NULL;
		m_Info.pBits = NULL;
	}

	// ŏ͓ʈ
	GetClientRect(&rect);
	if ((rect.Width() == 0) || (rect.Height() == 0)) {
		return;
	}

	// rbg}bvwb_̂߂̃m
	p = (BITMAPINFOHEADER*) new BYTE[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD)];
	memset(p, 0, sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD));

	// rbg}bv쐬
	m_Info.nBMPWidth = rect.Width();
	m_Info.nBMPHeight = rect.Height();
	p->biSize = sizeof(BITMAPINFOHEADER);
	p->biWidth = m_Info.nBMPWidth;
	p->biHeight = -m_Info.nBMPHeight;
	p->biPlanes = 1;
	p->biBitCount = 32;
	p->biCompression = BI_RGB;
	p->biSizeImage = m_Info.nBMPWidth * m_Info.nBMPHeight * (32 >> 3);

	// DC擾ADIBZNV쐬
	pDC = new CClientDC(this);
	m_Info.hBitmap = ::CreateDIBSection(pDC->m_hDC, (BITMAPINFO*)p, DIB_RGB_COLORS,
								(void**)&(m_Info.pBits), NULL, 0);
	// A_ɓ`
	if (m_Info.hBitmap && m_Info.pRender) {
		m_Info.pRender->SetMixBuf(m_Info.pBits, m_Info.nBMPWidth, m_Info.nBMPHeight);
	}
	delete pDC;
	delete[] p;

	// ČvZ
	m_Info.nRendHMul = -1;
	m_Info.nRendVMul = -1;
	ReCalc(rect);
}

//---------------------------------------------------------------------------
//
//	쐧
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::Enable(BOOL bEnable)
{
	CSubWnd *pWnd;

	// tOL
	m_bEnable = bEnable;

	// LȂ烌_L
	if (m_bEnable) {
		if (!m_Info.pRender) {
			m_Info.pRender = (Render*)::GetVM()->SearchDevice(MAKEID('R', 'E', 'N', 'D'));
			ASSERT(m_Info.pRender);
			m_Info.pWork = m_Info.pRender->GetWorkAddr();
			ASSERT(m_Info.pWork);
			if (m_Info.pBits) {
				m_Info.pRender->SetMixBuf(m_Info.pBits, m_Info.nBMPWidth, m_Info.nBMPHeight);
			}
		}
	}

	// TuEBhEɑ΂Aw
	pWnd = m_pSubWnd;
	while (pWnd) {
		pWnd->Enable(bEnable);
		pWnd = pWnd->m_pNextWnd;
	}
}

//---------------------------------------------------------------------------
//
//	tO擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDrawView::IsEnable() const
{
	return m_bEnable;
}

//---------------------------------------------------------------------------
//
//	tbV`
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::Refresh()
{
	CSubWnd *pWnd;
	CClientDC dc(this);

	// Drawr[ĕ`
	OnDraw(&dc);

	// TuEBhEĕ`
	pWnd = m_pSubWnd;
	while (pWnd) {
		pWnd->Refresh();

		// ̃TuEBhE
		pWnd = pWnd->m_pNextWnd;
	}
}

//---------------------------------------------------------------------------
//
//	`(XPW[)
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::Draw(int nChildWnd)
{
	CSubWnd *pSubWnd;
	CClientDC *pDC;

	ASSERT(nChildWnd >= -1);

	// -1Drawr[
	if (nChildWnd < 0) {
		pDC = new CClientDC(this);
		OnDraw(pDC);
		delete pDC;
		return;
	}

	// 0ȍ~̓TuEBhE
	pSubWnd = m_pSubWnd;

	while (nChildWnd > 0) {
		// ̃TuEBhE
		pSubWnd = pSubWnd->m_pNextWnd;
		ASSERT(pSubWnd);
		nChildWnd--;
	}

	// tbV
	pSubWnd->Refresh();
}

//---------------------------------------------------------------------------
//
//	bZ[WXbh̍XV
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::Update()
{
	CSubWnd *pWnd;

	// TuEBhEɑ΂Aw
	pWnd = m_pSubWnd;
	while (pWnd) {
		pWnd->Update();
		pWnd = pWnd->m_pNextWnd;
	}
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::ApplyCfg(const Config *pConfig)
{
	CSubWnd *pWnd;

	ASSERT(pConfig);

	// Xgb`
	Stretch(pConfig->aspect_stretch);

	// TuEBhEɑ΂Aw
	pWnd = m_pSubWnd;
	while (pWnd) {
		pWnd->ApplyCfg(pConfig);
		pWnd = pWnd->m_pNextWnd;
	}
}

//---------------------------------------------------------------------------
//
//	`擾
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::GetDrawInfo(LPDRAWINFO pDrawInfo) const
{
	ASSERT(this);
	ASSERT(pDrawInfo);

	// [NRs[
	*pDrawInfo = m_Info;
}

//---------------------------------------------------------------------------
//
//	`
//
//---------------------------------------------------------------------------
void CDrawView::OnDraw(CDC *pDC)
{
	CRect rect;
	HDC hMemDC;
	HBITMAP hDefBitmap;
	int i;
	int vmul;
	int hmul;

	// rbg}bv̏oĂȂΓhԂ
	GetClientRect(&rect);
	if (!m_Info.hBitmap || !m_bEnable || !m_Info.pWork) {
		pDC->FillSolidRect(&rect, RGB(0, 0, 0));
		return;
	}

	// ČvZ
	ReCalc(rect);

	// dOFF΍
	if (::GetVM()->IsPower() != m_Info.bPower) {
		m_Info.bPower = ::GetVM()->IsPower();
		if (!m_Info.bPower) {
			// rbg}bvׂď
			memset(m_Info.pBits, 0, m_Info.nBMPWidth * m_Info.nBMPHeight * 4);
			m_Info.bBltAll = TRUE;
		}
	}

	// `
	if (m_Info.bBltAll) {
		DrawRect(pDC);
	}

	// ŏI\{m
	hmul = 1;
	if (m_Info.nRendHMul == 2) {
		// 256Ȃ
		hmul = 2;
	}
	if ((m_Info.nRendWidth < 600) && m_Info.bBltStretch) {	// ifǗv
		// 768~512ȊOŁAAXyNgꃂ[hw
		hmul *= 5;
	}
	else {
		// AXyNg䓯͂ȂB{g
		hmul <<= 2;
	}
	vmul = 4;
	if (m_Info.nRendVMul == 2) {
		// c256Ȃ
		vmul = 8;
	}

	// bBltAll̎͑S̈Ō܂
	if (m_Info.bBltAll) {
		// DC쐬AZNg
		hMemDC = CreateCompatibleDC(pDC->m_hDC);
		if (!hMemDC) {
			return;
		}
		hDefBitmap = (HBITMAP)SelectObject(hMemDC, m_Info.hBitmap);
		if (!hDefBitmap) {
			DeleteDC(hMemDC);
			return;
		}

		// Blt
		if ((hmul == 4) && (vmul == 4)) {
			::BitBlt(pDC->m_hDC,
				m_Info.nLeft, m_Info.nTop,
				m_Info.nWidth, m_Info.nHeight,
				hMemDC, 0, 0,
				SRCCOPY);
		}
		else {
			::StretchBlt(pDC->m_hDC,
				m_Info.nLeft, m_Info.nTop,
				(m_Info.nWidth * hmul) >> 2,
				(m_Info.nHeight * vmul) >> 2,
				hMemDC, 0, 0,
				m_Info.nWidth, m_Info.nHeight,
				SRCCOPY);
		}
		::GdiFlush();
		m_Info.bBltAll = FALSE;

		// rbg}bv߂
		SelectObject(hMemDC, hDefBitmap);
		DeleteDC(hMemDC);

		// `tO~낷ƂYꂸ
		for (i=0; i<m_Info.nHeight * 64; i++) {
			m_Info.pWork->drawflag[i] = FALSE;
		}
		m_Info.dwDrawCount++;
		m_Info.nBltLeft = 0;
		m_Info.nBltTop = 0;
		m_Info.nBltRight = m_Info.nWidth - 1;
		m_Info.nBltBottom = m_Info.nHeight - 1;
		return;
	}

	// `̈𒲂ׂ
	if (!CalcRect()) {
		return;
	}
	ASSERT(m_Info.nBltTop <= m_Info.nBltBottom);
	ASSERT(m_Info.nBltLeft <= m_Info.nBltRight);

	// DC쐬AZNg
	hMemDC = CreateCompatibleDC(pDC->m_hDC);
	if (!hMemDC) {
		m_Info.bBltAll = TRUE;
		return;
	}
	hDefBitmap = (HBITMAP)SelectObject(hMemDC, m_Info.hBitmap);
	if (!hDefBitmap) {
		DeleteDC(hMemDC);
		m_Info.bBltAll = TRUE;
		return;
	}

	// ꕔ̈̂ݕ`
	if ((hmul == 4) && (vmul == 4)) {
		::BitBlt(pDC->m_hDC,
			m_Info.nLeft + m_Info.nBltLeft,
			m_Info.nTop + m_Info.nBltTop,
			m_Info.nBltRight - m_Info.nBltLeft + 1,
			m_Info.nBltBottom - m_Info.nBltTop + 1,
			hMemDC,
			m_Info.nBltLeft,
			m_Info.nBltTop,
			SRCCOPY);
	}
	else {
		::StretchBlt(pDC->m_hDC,
			m_Info.nLeft + ((m_Info.nBltLeft * hmul) >> 2),
			m_Info.nTop + ((m_Info.nBltTop * vmul) >> 2),
			((m_Info.nBltRight - m_Info.nBltLeft + 1) * hmul) >> 2,
			((m_Info.nBltBottom - m_Info.nBltTop + 1) * vmul) >> 2,
			hMemDC,
			m_Info.nBltLeft,
			m_Info.nBltTop,
			m_Info.nBltRight - m_Info.nBltLeft + 1,
			m_Info.nBltBottom - m_Info.nBltTop + 1,
			SRCCOPY);
	}
	::GdiFlush();

	// rbg}bv߂
	SelectObject(hMemDC, hDefBitmap);
	DeleteDC(hMemDC);

	// tOCalcRectō~낵Ă
	m_Info.dwDrawCount++;
}

//---------------------------------------------------------------------------
//
//	ČvZ
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::ReCalc(CRect& rect)
{
	int width;
	int height;
	BOOL flag;

	// _[NArbg}bvȂreturn
	if (!m_Info.pWork || !m_Info.hBitmap) {
		return;
	}

	// r
	flag = FALSE;
	if (m_Info.nRendWidth != m_Info.pWork->width) {
		m_Info.nRendWidth = m_Info.pWork->width;
		flag = TRUE;
	}
	if (m_Info.nRendHeight != m_Info.pWork->height) {
		m_Info.nRendHeight = m_Info.pWork->height;
		flag = TRUE;
	}
	if (m_Info.nRendHMul != m_Info.pWork->h_mul) {
		m_Info.nRendHMul = m_Info.pWork->h_mul;
		flag = TRUE;
	}
	if (m_Info.nRendVMul != m_Info.pWork->v_mul) {
		m_Info.nRendVMul = m_Info.pWork->v_mul;
		flag = TRUE;
	}
	if (!flag) {
		return;
	}

	// _Arbg}bv̂قƂ
	m_Info.nWidth = m_Info.nRendWidth;
	if (m_Info.nBMPWidth < m_Info.nWidth) {
		m_Info.nWidth = m_Info.nBMPWidth;
	}
	m_Info.nHeight = m_Info.nRendHeight;
	if (m_Info.nRendVMul == 0) {
		// 15kC^[X̂߂̏
		m_Info.nHeight <<= 1;
	}
	if (m_Info.nBMPHeight < m_Info.nRendHeight) {
		m_Info.nHeight = m_Info.nBMPHeight;
	}

	// {lăZ^OA]Zo
	width = m_Info.nWidth * m_Info.nRendHMul;
	if ((m_Info.nRendWidth < 600) && m_Info.bBltStretch) {	// ifǗv
		width = (width * 5) >> 2;
	}
	height = m_Info.nHeight;
	if (m_Info.nRendVMul == 2) {
		height <<= 1;
	}

	m_Info.nLeft = 0;
	if (width < rect.Width()) {
		m_Info.nLeft = (rect.Width() - width) >> 1;
	}
	m_Info.nTop = 0;
	if (height < rect.Height()) {
		m_Info.nTop = (rect.Height() - height) >> 1;
	}

	// ̈`w
	m_Info.bBltAll = TRUE;
}

//---------------------------------------------------------------------------
//
//	g僂[h
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::Stretch(BOOL bStretch)
{
	CRect rect;

	ASSERT(this);

	// vȂ牽Ȃ
	if (bStretch == m_Info.bBltStretch) {
		return;
	}
	m_Info.bBltStretch = bStretch;

	// 768~512łȂ΁AČvZ
	if ((m_Info.nRendWidth > 0) && (m_Info.nRendWidth < 600)) {		// ifǗv
		m_Info.nRendWidth = m_Info.pWork->width + 1;
		GetClientRect(&rect);
		ReCalc(rect);
	}
}

//---------------------------------------------------------------------------
//
//	`
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::DrawRect(CDC *pDC)
{
	CRect crect;
	CRect brect;

	ASSERT(m_Info.bBltAll);
	ASSERT(pDC);

	// Sg悤ȂKv
	if ((m_Info.nLeft == 0) && (m_Info.nTop == 0)) {
		return;
	}

	// NCAg`𓾂
	GetClientRect(&crect);

	if (m_Info.nLeft > 0) {
		// 
		brect.left = 0;
		brect.top = 0;
		brect.right = m_Info.nLeft;
		brect.bottom = crect.bottom;
		pDC->FillSolidRect(&brect, RGB(0, 0, 0));

		// E
		brect.right = crect.right;
		brect.left = brect.right - m_Info.nLeft - 1;
		pDC->FillSolidRect(&brect, RGB(0, 0, 0));
	}

	if (m_Info.nTop > 0) {
		// 㔼
		brect.left = 0;
		brect.top = 0;
		brect.right = crect.right;
		brect.bottom = m_Info.nTop;
		pDC->FillSolidRect(&brect, RGB(0, 0, 0));

		// E
		brect.bottom = crect.bottom;
		brect.top = brect.bottom - m_Info.nTop - 1;
		pDC->FillSolidRect(&brect, RGB(0, 0, 0));
	}
}

//---------------------------------------------------------------------------
//
//	`͈͂𒲂ׂ
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDrawView::CalcRect()
{
	int i;
	int j;
	int left;
	int top;
	int right;
	int bottom;
	BOOL *p;
	BOOL flag;

	// 
	left = 64;
	top = 2048;
	right = -1;
	bottom = -1;
	p = m_Info.pWork->drawflag;

	// y[v
	for (i=0; i<m_Info.nHeight; i++) {
		flag = FALSE;

		// x[v
		for(j=0; j<64; j++) {
			if (*p) {
				// 
				*p = FALSE;

				// 16dot͕`悪Kv
				if (left > j) {
					left = j;
				}
				if (right < j) {
					right = j;
				}
				flag = TRUE;
			}
			p++;
		}

		if (flag) {
			// ̃C͕`悪Kv
			if (top > i) {
				top = i;
			}
			if (bottom < i) {
				bottom = i;
			}
		}
	}

	// yωȂΕKv
	if (bottom < top) {
		return FALSE;
	}

	// x␳(x16)
	left <<= 4;
	right = ((right + 1) << 4) - 1;
	if (right >= m_Info.nWidth) {
		right = m_Info.nWidth - 1;
	}

	// Rs[
	m_Info.nBltLeft = left;
	m_Info.nBltTop = top;
	m_Info.nBltRight = right;
	m_Info.nBltBottom = bottom;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	TuEBhEVKCfbNX擾
//
//---------------------------------------------------------------------------
int FASTCALL CDrawView::GetNewSWnd() const
{
	CSubWnd *pWnd;
	int nSubWnd;

	ASSERT(this);
	ASSERT_VALID(this);

	// ŏ̃TuEBhE
	if (!m_pSubWnd) {
		return 0;
	}

	// 
	nSubWnd = 1;
	pWnd = m_pSubWnd;

	// [v
	while (pWnd->m_pNextWnd) {
		pWnd = pWnd->m_pNextWnd;
		nSubWnd++;
	}

	// CfbNXԂ
	return nSubWnd;
}

//---------------------------------------------------------------------------
//
//	TuEBhEǉ
//	ǉCSubWndĂяo
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::AddSWnd(CSubWnd *pSubWnd)
{
	CSubWnd *pWnd;

	ASSERT(this);
	ASSERT(pSubWnd);
	ASSERT_VALID(this);

	// ŏ̃TuEBhE
	if (!m_pSubWnd) {
		// ̃EBhEŏBo^
		m_pSubWnd = pSubWnd;
		ASSERT(!pSubWnd->m_pNextWnd);
		return;
	}

	// I[T
	pWnd = m_pSubWnd;
	while (pWnd->m_pNextWnd) {
		pWnd = pWnd->m_pNextWnd;
	}

	// pWnďɒǉ
	pWnd->m_pNextWnd = pSubWnd;
	ASSERT(!pSubWnd->m_pNextWnd);
}

//---------------------------------------------------------------------------
//
//	TuEBhE폜
//	폜CSubWndĂяo
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::DelSWnd(CSubWnd *pSubWnd)
{
	CSubWnd *pWnd;

	// assert
	ASSERT(pSubWnd);

	// VMbN
	::LockVM();

	// ŏ̃TuEBhE
	if (m_pSubWnd == pSubWnd) {
		// ȂAo^BȂNULL
		if (pSubWnd->m_pNextWnd) {
			m_pSubWnd = pSubWnd->m_pNextWnd;
		}
		else {
			m_pSubWnd = NULL;
		}
		::UnlockVM();
		return;
	}

	// pSubWndLĂTuEBhET
	pWnd = m_pSubWnd;
	while (pWnd->m_pNextWnd != pSubWnd) {
		ASSERT(pWnd->m_pNextWnd);
		pWnd = pWnd->m_pNextWnd;
	}

	// pSubWnd->m_pNextWndApWndɌтXLbv
	pWnd->m_pNextWnd = pSubWnd->m_pNextWnd;

	// VMAbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	TuEBhEׂč폜
//
//---------------------------------------------------------------------------
void FASTCALL CDrawView::ClrSWnd()
{
	CSubWnd *pWnd;
    CSubWnd *pNext;

	ASSERT(this);

	// ŏ̃TuEBhE擾
	pWnd = GetFirstSWnd();

	// [v
	while (pWnd) {
		// 擾
		pNext = pWnd->m_pNextWnd;

		// ̃EBhE폜
		pWnd->DestroyWindow();

		// ړ
		pWnd = pNext;
	}
}

//---------------------------------------------------------------------------
//
//	ŏ̃TuEBhE擾
//	ȂNULLԂ
//
//---------------------------------------------------------------------------
CSubWnd* FASTCALL CDrawView::GetFirstSWnd() const
{
	return m_pSubWnd;
}

//---------------------------------------------------------------------------
//
//	TuEBhE
//	ȂNULLԂ
//
//---------------------------------------------------------------------------
CSubWnd* FASTCALL CDrawView::SearchSWnd(DWORD dwID) const
{
	CSubWnd *pWnd;

	// EBhE
	pWnd = m_pSubWnd;

	// [v
	while (pWnd) {
		// IDv邩`FbN
		if (pWnd->GetID() == dwID) {
			return pWnd;
		}

		// 
		pWnd = pWnd->m_pNextWnd;
	}

	// Ȃ
	return NULL;
}

//---------------------------------------------------------------------------
//
//	eLXgtHg擾
//
//---------------------------------------------------------------------------
CFont* FASTCALL CDrawView::GetTextFont()
{
	ASSERT(m_TextFont.m_hObject);

	return &m_TextFont;
}

//---------------------------------------------------------------------------
//
//	VEBhE쐬
//
//---------------------------------------------------------------------------
CSubWnd* FASTCALL CDrawView::NewWindow(BOOL bDis)
{
	DWORD dwID;
	int i;
	CSubWnd *pWnd;
	CDisasmWnd *pDisWnd;
	CMemoryWnd *pMemWnd;

	// ID쐬
	if (bDis) {
		dwID = MAKEID('D', 'I', 'S', 'A');
	}
	else {
		dwID = MAKEID('M', 'E', 'M', 'A');
	}

	// 8񃋁[v
	for (i=0; i<8; i++) {
		// EBhEȂ΁AVK쐬\
		pWnd = SearchSWnd(dwID);
		if (!pWnd) {
			if (bDis) {
				pDisWnd = new CDisasmWnd(i);
				VERIFY(pDisWnd->Init(this));
				return pDisWnd;
			}
			else {
				pMemWnd = new CMemoryWnd(i);
				VERIFY(pMemWnd->Init(this));
				return pMemWnd;
			}
		}

		// ̃EBhEID
		dwID++;
	}

	// 쐬łȂ
	return NULL;
}

//---------------------------------------------------------------------------
//
//	VEBhE쐬ł邩`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CDrawView::IsNewWindow(BOOL bDis)
{
	DWORD dwID;
	int i;
	CSubWnd *pWnd;

	// ID쐬
	if (bDis) {
		dwID = MAKEID('D', 'I', 'S', 'A');
	}
	else {
		dwID = MAKEID('M', 'E', 'M', 'A');
	}

	// 8񃋁[v
	for (i=0; i<8; i++) {
		// EBhEȂ΁AVK쐬\
		pWnd = SearchSWnd(dwID);
		if (!pWnd) {
			return TRUE;
		}

		// ̃EBhEID
		dwID++;
	}

	// ׂẴEBhE遨VK쐬łȂ
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	TuEBhĚ擾
//	ȂNULLԂ
//
//---------------------------------------------------------------------------
int FASTCALL CDrawView::GetSubWndNum() const
{
	CSubWnd *pWnd;
	int num;

	// 
	pWnd = m_pSubWnd;
	num = 0;

	// [v
	while (pWnd) {
		// ++
		num++;

		// 
		pWnd = pWnd->m_pNextWnd;
	}

	return num;
}

//---------------------------------------------------------------------------
//
//	EBhENX擾
//
//---------------------------------------------------------------------------
LPCTSTR FASTCALL CDrawView::GetWndClassName() const
{
	ASSERT(this);
	ASSERT(m_pFrmWnd);
	return m_pFrmWnd->GetWndClassName();
}

#endif	// _WIN32
