//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Drawr[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_draw_h)
#define mfc_draw_h

//===========================================================================
//
//	Drawr[
//
//===========================================================================
class CDrawView : public CView
{
public:
	// [N`
	typedef struct _DRAWINFO {
		BOOL bPower;					// d
		Render *pRender;				// _
		Render::render_t *pWork;		// _[N
        DWORD dwDrawCount;				// `

		// DIBZNV
		HBITMAP hBitmap;				// DIBZNV
		DWORD *pBits;					// rbgf[^
		int nBMPWidth;					// BMP
		int nBMPHeight;					// BMP

		// _Ag
		int nRendWidth;					// _
		int nRendHeight;				// _
		int nRendHMul;					// _{
		int nRendVMul;					// _c{
		int nLeft;						// }[W
		int nTop;						// c}[W
		int nWidth;						// BitBlt
		int nHeight;					// BitBlt

		// Bltn
		int nBltTop;					// `JnY
		int nBltBottom;					// `IY
		int nBltLeft;					// `JnX
		int nBltRight;					// `IX
		BOOL bBltAll;					// S\tO
		BOOL bBltStretch;				// AXyNgɂ킹g
	} DRAWINFO, *LPDRAWINFO;

public:
	// {t@NV
	CDrawView();
										// RXgN^
	void FASTCALL Enable(BOOL bEnable);
										// 쐧
	BOOL FASTCALL IsEnable() const;
										// tO擾
	BOOL FASTCALL Init(CWnd *pParent);
										// 
	BOOL PreCreateWindow(CREATESTRUCT& cs);
										// EBhE쐬
	void FASTCALL Refresh();
										// tbV`
	void FASTCALL Draw(int index);
										// `(EBhÊ)
	void FASTCALL Update();
										// bZ[WXbh̍XV
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp
	void FASTCALL GetDrawInfo(LPDRAWINFO pDrawInfo) const;
										// `擾

	// _O`
	void OnDraw(CDC *pDC);
										// `
	void FASTCALL Stretch(BOOL bStretch);
										// g僂[h
	BOOL IsStretch() const				{ return m_Info.bBltStretch; }
										// g僂[h擾

	// TuEBhEǗ
	int FASTCALL GetNewSWnd() const;
										// TuEBhEVKCfbNX擾
	void FASTCALL AddSWnd(CSubWnd *pSubWnd);
										// TuEBhEǉ(qĂ΂)
	void FASTCALL DelSWnd(CSubWnd *pSubWnd);
										// TuEBhE폜(qĂ΂)
	void FASTCALL ClrSWnd();
										// TuEBhEׂč폜
	CSubWnd* FASTCALL GetFirstSWnd() const;
										// ŏ̃TuEBhE擾
	CSubWnd* FASTCALL SearchSWnd(DWORD dwID) const;
										// CID̃TuEBhE擾
	CFont* FASTCALL GetTextFont();
										// eLXgtHg擾
	CSubWnd* FASTCALL NewWindow(BOOL bDis);
										// VKEBhE쐬(Dis, Mem)
	BOOL FASTCALL IsNewWindow(BOOL bDis);
										// VKEBhE쐬\₢킹
	int FASTCALL GetSubWndNum() const;
										// TuEBhĚ擾
	LPCTSTR FASTCALL GetWndClassName() const;
										// EBhENX擾

protected:
	// WMbZ[W
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EBhE쐬
	afx_msg void OnDestroy();
										// EBhE폜
	afx_msg void OnSize(UINT nType, int cx, int cy);
										// EBhETCYύX
	afx_msg void OnPaint();
										// `
	afx_msg BOOL OnEraseBkgnd(CDC *pDC);
										// wi`
	afx_msg LRESULT OnDisplayChange(WPARAM wParam, LPARAM lParam);
										// fBXvCύX
	afx_msg void OnDropFiles(HDROP hDropInfo);
										// t@Chbv
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
										// }EXzC[
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
										// L[
	afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
										// VXeL[
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
										// L[
	afx_msg void OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
										// VXeL[
	afx_msg void OnMove(int x, int y);
										// EBhEړ

	BOOL m_bEnable;
										// LtO
	CFont m_TextFont;
										// eLXgtHg

private:
	void FASTCALL SetupBitmap();
										// rbg}bv
	inline void FASTCALL ReCalc(CRect& rect);
										// ČvZ
	inline void FASTCALL DrawRect(CDC *pDC);
										// ̗͂]`
	inline BOOL FASTCALL CalcRect();
										// `Kv̈𒲂ׂ
	int FASTCALL MakeBits();
										// rbg쐬
	BOOL FASTCALL KeyUpDown(UINT nChar, UINT nFlags, BOOL bDown);
										// L[
	CSubWnd *m_pSubWnd;
										// ŏ̃TuEBhE
	CFrmWnd *m_pFrmWnd;
										// t[EBhE
	CScheduler *m_pScheduler;
										// XPW[
	CInput *m_pInput;
										// Cvbg
	DRAWINFO m_Info;
										// [N

	DECLARE_MESSAGE_MAP()
										// bZ[W }bv
};

#endif	// mfc_draw_h
#endif	// _WIN32
