//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC t[EBhE ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "schedule.h"
#include "memory.h"
#include "sasi.h"
#include "scsi.h"
#include "fdd.h"
#include "fdc.h"
#include "fdi.h"
#include "render.h"
#include "mfc_frm.h"
#include "mfc_draw.h"
#include "mfc_res.h"
#include "mfc_sub.h"
#include "mfc_cpu.h"
#include "mfc_com.h"
#include "mfc_sch.h"
#include "mfc_snd.h"
#include "mfc_inp.h"
#include "mfc_port.h"
#include "mfc_midi.h"
#include "mfc_tkey.h"
#include "mfc_host.h"
#include "mfc_info.h"
#include "mfc_cfg.h"
#include "mfc_stat.h"
#include "mfc_rom.h"

//===========================================================================
//
//	t[EBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	VF萔`
//	includet@Cł͂ȂAAvP[VŒ`悤߂Ă
//
//---------------------------------------------------------------------------
#define SHCNRF_InterruptLevel			0x0001
#define SHCNRF_ShellLevel				0x0002
#define SHCNRF_NewDelivery				0x8000

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CFrmWnd::CFrmWnd()
{
	// VMEXe[^XR[h
	::pVM = NULL;
	m_nStatus = -1;

	// foCX
	m_pFDD = NULL;
	m_pSASI = NULL;
	m_pSCSI = NULL;
	m_pScheduler = NULL;
	m_pKeyboard = NULL;
	m_pMouse = NULL;

	// R|[lg
	m_pFirstComponent = NULL;
	m_pDrawView = NULL;
	m_pStatusView = NULL;
	m_pSch = NULL;
	m_pSound = NULL;
	m_pInput = NULL;
	m_pPort = NULL;
	m_pMIDI = NULL;
	m_pTKey = NULL;
	m_pHost = NULL;
	m_pInfo = NULL;
	m_pConfig = NULL;

	// tXN[
	m_bFullScreen = FALSE;
	m_hTaskBar = NULL;
	memset(&m_DevMode, 0, sizeof(m_DevMode));
	m_nWndLeft = 0;
	m_nWndTop = 0;

	// TuEBhE
	m_strWndClsName.Empty();

	// Xe[^Xo[Ej[ELvV
	m_bStatusBar = FALSE;
	m_bMenuBar = TRUE;
	m_bCaption = TRUE;

	// VFʒm
	m_uNotifyId = NULL;

	// RtBM[V
	m_bMouseMid = TRUE;
	m_bPopup = FALSE;
	m_bAutoMouse = TRUE;

	// ̑ϐ
	m_bExit = FALSE;
	m_bSaved = FALSE;
	m_nFDDStatus[0] = 0;
	m_nFDDStatus[1] = 0;
	m_dwExec = 0;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CFrmWnd, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_MESSAGE(WM_DISPLAYCHANGE, OnDisplayChange)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_MOVE()
	ON_WM_ACTIVATE()
	ON_WM_ACTIVATEAPP()
	ON_WM_ENTERMENULOOP()
	ON_WM_EXITMENULOOP()
	ON_WM_PARENTNOTIFY()
	ON_MESSAGE(WM_KICK, OnKick)
	ON_WM_DRAWITEM()
	ON_WM_CONTEXTMENU()
	ON_MESSAGE(WM_POWERBROADCAST, OnPowerBroadCast)
	ON_WM_SYSCOMMAND()
#if _MFC_VER >= 0x700
	ON_WM_COPYDATA()
#else
	ON_MESSAGE(WM_COPYDATA, OnCopyData)
#endif
	ON_WM_ENDSESSION()
	ON_MESSAGE(WM_SHELLNOTIFY, OnShellNotify)

	ON_COMMAND(IDM_OPEN, OnOpen)
	ON_UPDATE_COMMAND_UI(IDM_OPEN, OnOpenUI)
	ON_COMMAND(IDM_SAVE, OnSave)
	ON_UPDATE_COMMAND_UI(IDM_SAVE, OnSaveUI)
	ON_COMMAND(IDM_SAVEAS, OnSaveAs)
	ON_UPDATE_COMMAND_UI(IDM_SAVEAS, OnSaveAsUI)
	ON_COMMAND(IDM_RESET, OnReset)
	ON_UPDATE_COMMAND_UI(IDM_RESET, OnResetUI)
	ON_COMMAND(IDM_INTERRUPT, OnInterrupt)
	ON_UPDATE_COMMAND_UI(IDM_INTERRUPT, OnInterruptUI)
	ON_COMMAND(IDM_POWER, OnPower)
	ON_UPDATE_COMMAND_UI(IDM_POWER, OnPowerUI)
	ON_COMMAND_RANGE(IDM_XM6_MRU0, IDM_XM6_MRU8, OnMRU)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_XM6_MRU0, IDM_XM6_MRU8, OnMRUUI)
	ON_COMMAND(IDM_EXIT, OnExit)

	ON_COMMAND_RANGE(IDM_D0OPEN, IDM_D1_MRU8, OnFD)
	ON_UPDATE_COMMAND_UI(IDM_D0OPEN, OnFDOpenUI)
	ON_UPDATE_COMMAND_UI(IDM_D1OPEN, OnFDOpenUI)
	ON_UPDATE_COMMAND_UI(IDM_D0EJECT, OnFDEjectUI)
	ON_UPDATE_COMMAND_UI(IDM_D1EJECT, OnFDEjectUI)
	ON_UPDATE_COMMAND_UI(IDM_D0WRITEP, OnFDWritePUI)
	ON_UPDATE_COMMAND_UI(IDM_D1WRITEP, OnFDWritePUI)
	ON_UPDATE_COMMAND_UI(IDM_D0FORCE, OnFDForceUI)
	ON_UPDATE_COMMAND_UI(IDM_D1FORCE, OnFDForceUI)
	ON_UPDATE_COMMAND_UI(IDM_D0INVALID, OnFDInvalidUI)
	ON_UPDATE_COMMAND_UI(IDM_D1INVALID, OnFDInvalidUI)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_D0_MEDIA0, IDM_D0_MEDIAF, OnFDMediaUI)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_D1_MEDIA0, IDM_D1_MEDIAF, OnFDMediaUI)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_D0_MRU0, IDM_D0_MRU8, OnFDMRUUI)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_D1_MRU0, IDM_D1_MRU8, OnFDMRUUI)

	ON_COMMAND(IDM_MOOPEN, OnMOOpen)
	ON_UPDATE_COMMAND_UI(IDM_MOOPEN, OnMOOpenUI)
	ON_COMMAND(IDM_MOEJECT, OnMOEject)
	ON_UPDATE_COMMAND_UI(IDM_MOEJECT, OnMOEjectUI)
	ON_COMMAND(IDM_MOWRITEP, OnMOWriteP)
	ON_UPDATE_COMMAND_UI(IDM_MOWRITEP, OnMOWritePUI)
	ON_COMMAND(IDM_MOFORCE, OnMOForce)
	ON_UPDATE_COMMAND_UI(IDM_MOFORCE, OnMOForceUI)
	ON_COMMAND_RANGE(IDM_MO_MRU0, IDM_MO_MRU8, OnMOMRU)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_MO_MRU0, IDM_MO_MRU8, OnMOMRUUI)

	ON_COMMAND(IDM_CDOPEN, OnCDOpen)
	ON_UPDATE_COMMAND_UI(IDM_CDOPEN, OnCDOpenUI)
	ON_COMMAND(IDM_CDEJECT, OnCDEject)
	ON_UPDATE_COMMAND_UI(IDM_CDEJECT, OnCDEjectUI)
	ON_COMMAND(IDM_CDFORCE, OnCDForce)
	ON_UPDATE_COMMAND_UI(IDM_CDFORCE, OnCDForceUI)
	ON_COMMAND_RANGE(IDM_CD_MRU0, IDM_CD_MRU8, OnCDMRU)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_CD_MRU0, IDM_CD_MRU8, OnCDMRUUI)

	ON_COMMAND(IDM_LOG, OnLog)
	ON_UPDATE_COMMAND_UI(IDM_LOG, OnLogUI)
	ON_COMMAND(IDM_SCHEDULER, OnScheduler)
	ON_UPDATE_COMMAND_UI(IDM_SCHEDULER, OnSchedulerUI)
	ON_COMMAND(IDM_DEVICE, OnDevice)
	ON_UPDATE_COMMAND_UI(IDM_DEVICE, OnDeviceUI)
	ON_COMMAND(IDM_CPUREG, OnCPUReg)
	ON_UPDATE_COMMAND_UI(IDM_CPUREG, OnCPURegUI)
	ON_COMMAND(IDM_INT, OnInt)
	ON_UPDATE_COMMAND_UI(IDM_INT, OnIntUI)
	ON_COMMAND(IDM_DISASM, OnDisasm)
	ON_UPDATE_COMMAND_UI(IDM_DISASM, OnDisasmUI)
	ON_COMMAND(IDM_MEMORY, OnMemory)
	ON_UPDATE_COMMAND_UI(IDM_MEMORY, OnMemoryUI)
	ON_COMMAND(IDM_BREAKP, OnBreakP)
	ON_UPDATE_COMMAND_UI(IDM_BREAKP, OnBreakPUI)
	ON_COMMAND(IDM_MFP, OnMFP)
	ON_UPDATE_COMMAND_UI(IDM_MFP, OnMFPUI)
	ON_COMMAND(IDM_DMAC, OnDMAC)
	ON_UPDATE_COMMAND_UI(IDM_DMAC, OnDMACUI)
	ON_COMMAND(IDM_CRTC, OnCRTC)
	ON_UPDATE_COMMAND_UI(IDM_CRTC, OnCRTCUI)
	ON_COMMAND(IDM_VC, OnVC)
	ON_UPDATE_COMMAND_UI(IDM_VC, OnVCUI)
	ON_COMMAND(IDM_RTC, OnRTC)
	ON_UPDATE_COMMAND_UI(IDM_RTC, OnRTCUI)
	ON_COMMAND(IDM_OPM, OnOPM)
	ON_UPDATE_COMMAND_UI(IDM_OPM, OnOPMUI)
	ON_COMMAND(IDM_KEYBOARD, OnKeyboard)
	ON_UPDATE_COMMAND_UI(IDM_KEYBOARD, OnKeyboardUI)
	ON_COMMAND(IDM_FDD, OnFDD)
	ON_UPDATE_COMMAND_UI(IDM_FDD, OnFDDUI)
	ON_COMMAND(IDM_FDC, OnFDC)
	ON_UPDATE_COMMAND_UI(IDM_FDC, OnFDCUI)
	ON_COMMAND(IDM_SCC, OnSCC)
	ON_UPDATE_COMMAND_UI(IDM_SCC, OnSCCUI)
	ON_COMMAND(IDM_CYNTHIA, OnCynthia)
	ON_UPDATE_COMMAND_UI(IDM_CYNTHIA, OnCynthiaUI)
	ON_COMMAND(IDM_SASI, OnSASI)
	ON_UPDATE_COMMAND_UI(IDM_SASI, OnSASIUI)
	ON_COMMAND(IDM_MIDI, OnMIDI)
	ON_UPDATE_COMMAND_UI(IDM_MIDI, OnMIDIUI)
	ON_COMMAND(IDM_SCSI, OnSCSI)
	ON_UPDATE_COMMAND_UI(IDM_SCSI, OnSCSIUI)
//	ON_COMMAND(IDM_TVRAM, OnTVRAM)
//	ON_UPDATE_COMMAND_UI(IDM_TVRAM, OnTVRAMUI)
	ON_COMMAND(IDM_G1024, OnG1024)
	ON_UPDATE_COMMAND_UI(IDM_G1024, OnG1024UI)
	ON_COMMAND_RANGE(IDM_G16P0, IDM_G16P3, OnG16)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_G16P0, IDM_G16P3, OnG16UI)
	ON_COMMAND_RANGE(IDM_G256P0, IDM_G256P1, OnG256)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_G256P0, IDM_G256P1, OnG256UI)
	ON_COMMAND(IDM_G64K, OnG64K)
	ON_UPDATE_COMMAND_UI(IDM_G64K, OnG64KUI)
	ON_COMMAND(IDM_PCG, OnPCG)
	ON_UPDATE_COMMAND_UI(IDM_PCG, OnPCGUI)
	ON_COMMAND_RANGE(IDM_BG0, IDM_BG1, OnBG)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_BG0, IDM_BG1, OnBGUI)
	ON_COMMAND(IDM_PALET, OnPalet)
	ON_UPDATE_COMMAND_UI(IDM_PALET, OnPaletUI)
	ON_COMMAND(IDM_REND_TEXT, OnTextBuf)
	ON_UPDATE_COMMAND_UI(IDM_REND_TEXT, OnTextBufUI)
	ON_COMMAND_RANGE(IDM_REND_GP0, IDM_REND_GP3, OnGrpBuf)
	ON_UPDATE_COMMAND_UI_RANGE(IDM_REND_GP0, IDM_REND_GP3, OnGrpBufUI)
	ON_COMMAND(IDM_REND_PCG, OnPCGBuf)
	ON_UPDATE_COMMAND_UI(IDM_REND_PCG, OnPCGBufUI)
	ON_COMMAND(IDM_REND_BGSPRITE, OnBGSpBuf)
	ON_UPDATE_COMMAND_UI(IDM_REND_BGSPRITE, OnBGSpBufUI)
	ON_COMMAND(IDM_REND_PALET, OnPaletBuf)
	ON_UPDATE_COMMAND_UI(IDM_REND_PALET, OnPaletBufUI)
	ON_COMMAND(IDM_REND_MIX, OnMixBuf)
	ON_UPDATE_COMMAND_UI(IDM_REND_MIX, OnMixBufUI)
	ON_COMMAND(IDM_COMPONENT, OnComponent)
	ON_UPDATE_COMMAND_UI(IDM_COMPONENT, OnComponentUI)
	ON_COMMAND(IDM_OSINFO, OnOSInfo)
	ON_UPDATE_COMMAND_UI(IDM_OSINFO, OnOSInfoUI)
	ON_COMMAND(IDM_SOUND, OnSound)
	ON_UPDATE_COMMAND_UI(IDM_SOUND, OnSoundUI)
	ON_COMMAND(IDM_INPUT, OnInput)
	ON_UPDATE_COMMAND_UI(IDM_INPUT, OnInputUI)
	ON_COMMAND(IDM_PORT, OnPort)
	ON_UPDATE_COMMAND_UI(IDM_PORT, OnPortUI)
	ON_COMMAND(IDM_BITMAP, OnBitmap)
	ON_UPDATE_COMMAND_UI(IDM_BITMAP, OnBitmapUI)
	ON_COMMAND(IDM_MIDIDRV, OnMIDIDrv)
	ON_UPDATE_COMMAND_UI(IDM_MIDIDRV, OnMIDIDrvUI)
	ON_COMMAND(IDM_CAPTION, OnCaption)
	ON_UPDATE_COMMAND_UI(IDM_CAPTION, OnCaptionUI)
	ON_COMMAND(IDM_MENU, OnMenu)
	ON_UPDATE_COMMAND_UI(IDM_MENU, OnMenuUI)
	ON_COMMAND(IDM_STATUS, OnStatus)
	ON_UPDATE_COMMAND_UI(IDM_STATUS, OnStatusUI)
	ON_COMMAND(IDM_REFRESH, OnRefresh)
	ON_COMMAND(IDM_STRETCH, OnStretch)
	ON_UPDATE_COMMAND_UI(IDM_STRETCH, OnStretchUI)
	ON_COMMAND(IDM_FULLSCREEN, OnFullScreen)
	ON_UPDATE_COMMAND_UI(IDM_FULLSCREEN, OnFullScreenUI)

	ON_COMMAND(IDM_EXEC, OnExec)
	ON_UPDATE_COMMAND_UI(IDM_EXEC, OnExecUI)
	ON_COMMAND(IDM_BREAK, OnBreak)
	ON_UPDATE_COMMAND_UI(IDM_BREAK, OnBreakUI)
	ON_COMMAND(IDM_TRACE, OnTrace)
	ON_UPDATE_COMMAND_UI(IDM_TRACE, OnTraceUI)

	ON_COMMAND(IDM_MOUSEMODE, OnMouseMode)
	ON_COMMAND(IDM_SOFTKEY, OnSoftKey)
	ON_UPDATE_COMMAND_UI(IDM_SOFTKEY, OnSoftKeyUI)
	ON_COMMAND(IDM_TIMEADJ, OnTimeAdj)
	ON_COMMAND(IDM_TRAP0, OnTrap)
	ON_UPDATE_COMMAND_UI(IDM_TRAP0, OnTrapUI)
	ON_COMMAND(IDM_SAVEWAV, OnSaveWav)
	ON_UPDATE_COMMAND_UI(IDM_SAVEWAV, OnSaveWavUI)
	ON_COMMAND(IDM_NEWFD, OnNewFD)
	ON_COMMAND_RANGE(IDM_NEWSASI, IDM_NEWMO, OnNewDisk)
	ON_COMMAND(IDM_OPTIONS, OnOptions)

	ON_COMMAND(IDM_CASCADE, OnCascade)
	ON_UPDATE_COMMAND_UI(IDM_CASCADE, OnCascadeUI)
	ON_COMMAND(IDM_TILE, OnTile)
	ON_UPDATE_COMMAND_UI(IDM_TILE, OnTileUI)
	ON_COMMAND(IDM_ICONIC, OnIconic)
	ON_UPDATE_COMMAND_UI(IDM_ICONIC, OnIconicUI)
	ON_COMMAND(IDM_ARRANGEICON, OnArrangeIcon)
	ON_UPDATE_COMMAND_UI(IDM_ARRANGEICON, OnArrangeIconUI)
	ON_COMMAND(IDM_HIDE, OnHide)
	ON_UPDATE_COMMAND_UI(IDM_HIDE, OnHideUI)
	ON_COMMAND(IDM_RESTORE, OnRestore)
	ON_UPDATE_COMMAND_UI(IDM_RESTORE, OnRestoreUI)
	ON_COMMAND_RANGE(IDM_SWND_START, IDM_SWND_END, OnWindow)

	ON_COMMAND(IDM_ABOUT, OnAbout)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL CFrmWnd::Init()
{
	// EBhE쐬
	if (!Create(NULL, _T("XM6"),
			WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU |
			WS_BORDER | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
			rectDefault, NULL, NULL, 0, NULL)) {
		return FALSE;
	}

	// ȊȌOnCrateɔC
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
BOOL CFrmWnd::PreCreateWindow(CREATESTRUCT& cs)
{
	// {NX
	if (!CFrameWnd::PreCreateWindow(cs)) {
		return FALSE;
	}

	// NCAgGbWO
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
int CFrmWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	LONG lUser;
	CMenu *pSysMenu;
	UINT nCount;
	CString string;

	// {NX
	if (CFrameWnd::OnCreate(lpCreateStruct) != 0) {
		return -1;
	}

	// [Uf[^w
	lUser = (LONG)MAKEID('X', 'M', '6', ' ');
	::SetWindowLong(m_hWnd, GWL_USERDATA, lUser);

	// ANZ[^wAACRwAIMMw
	LoadAccelTable(MAKEINTRESOURCE(IDR_ACCELERATOR));
	SetIcon(AfxGetApp()->LoadIcon(IDI_APPICON), TRUE);
	::ImmAssociateContext(m_hWnd, (HIMC)NULL);

	// j[(EBhE)
	if (::IsJapanese()) {
		// {ꃁj[
		m_Menu.LoadMenu(IDR_MENU);
		m_PopupMenu.LoadMenu(IDR_MENUPOPUP);
	}
	else {
		// pꃁj[
		m_Menu.LoadMenu(IDR_US_MENU);
		m_PopupMenu.LoadMenu(IDR_US_MENUPOPUP);
	}
	SetMenu(&m_Menu);
	m_bMenuBar = TRUE;
	m_bPopupMenu = FALSE;

	// j[(VXe)
	::GetMsg(IDS_STDWIN, string);
	pSysMenu = GetSystemMenu(FALSE);
	ASSERT(pSysMenu);
	nCount = pSysMenu->GetMenuItemCount();

	// uEBhEWʒuv}
	pSysMenu->InsertMenu(nCount - 2, MF_BYPOSITION | MF_STRING, IDM_STDWIN, string);
	pSysMenu->InsertMenu(nCount - 2, MF_BYPOSITION | MF_SEPARATOR);

	// `ChEBhE
	if (!InitChild()) {
		return -1;
	}

	// EBhEʒuA`
	InitPos();

	// VFʒm
	InitShell();

	// VM
	if (!InitVM()) {
		// VMG[
		m_nStatus = 1;
		PostMessage(WM_KICK, 0, 0);
		return 0;
	}

	// o[W\[XVMփo[W`B
	InitVer();

	// foCXL
	m_pFDD = (FDD*)::GetVM()->SearchDevice(MAKEID('F', 'D', 'D', ' '));
	ASSERT(m_pFDD);
	m_pSASI = (SASI*)::GetVM()->SearchDevice(MAKEID('S', 'A', 'S', 'I'));
	ASSERT(m_pSASI);
	m_pSCSI = (SCSI*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'S', 'I'));
	ASSERT(m_pSCSI);
	m_pScheduler = (Scheduler*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pScheduler);
	m_pKeyboard = (Keyboard*)::GetVM()->SearchDevice(MAKEID('K', 'E', 'Y', 'B'));
	ASSERT(m_pKeyboard);
	m_pMouse = (Mouse*)::GetVM()->SearchDevice(MAKEID('M', 'O', 'U', 'S'));
	ASSERT(m_pMouse);

	// R|[lg쐬A
	if (!InitComponent()) {
		// R|[lgG[
		m_nStatus = 2;
		PostMessage(WM_KICK, 0, 0);
		return 0;
	}

	// ݒKp(OnOptionƓlAVMbN)
	::LockVM();
	ApplyCfg();
	::UnlockVM();

	// Zbg
	::GetVM()->Reset();

	// EChEʒuW[(m_nStatus != 0ɗ)
	ASSERT(m_nStatus != 0);
	RestoreFrameWnd(FALSE);

	// bZ[W|XgďI
	m_nStatus = 0;
	PostMessage(WM_KICK, 0, 0);
	return 0;
}

//---------------------------------------------------------------------------
//
//	`ChEBhE
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::InitChild()
{
	HDC hDC;
	HFONT hFont;
	HFONT hDefFont;
	TEXTMETRIC tm;
	int i;
	int nWidth;
	UINT uIndicator[6];

	// r[쐬
	m_pDrawView = new CDrawView;
	if (!m_pDrawView->Init(this)) {
		return FALSE;
	}

	// Xe[^Xo[[N
	ResetStatus();

	// Xe[^Xo[쐬
	if (!m_StatusBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_BOTTOM,
							AFX_IDW_STATUS_BAR)) {
		return FALSE;
	}
	m_bStatusBar = TRUE;
	uIndicator[0] = ID_SEPARATOR;
	for (i=1; i<6; i++) {
		uIndicator[i] = (UINT)i;
	}
	m_StatusBar.SetIndicators(uIndicator, 6);

	// eLXggbN擾
	hDC = ::GetDC(m_hWnd);
	hFont = (HFONT)::GetStockObject(DEFAULT_GUI_FONT);
	hDefFont = (HFONT)::SelectObject(hDC, hFont);
	ASSERT(hDefFont);
	::GetTextMetrics(hDC, &tm);
	::SelectObject(hDC, hDefFont);
	::ReleaseDC(m_hWnd, hDC);

	// TCYݒ胋[v
	m_StatusBar.SetPaneInfo(0, 0, SBPS_NOBORDERS | SBPS_STRETCH, 0);
	nWidth = 0;
	for (i=1; i<6; i++) {
		switch (i) {
			// FD0, FD1
			case 1:
			case 2:
				nWidth = tm.tmAveCharWidth * 32;
				break;

			// HD BUSY
			case 3:
				nWidth = tm.tmAveCharWidth * 10;
				break;

			// TIMER
			case 4:
				nWidth = tm.tmAveCharWidth * 9;
				break;

			// POWER
			case 5:
				nWidth = tm.tmAveCharWidth * 9;
				break;
		}
		m_StatusBar.SetPaneInfo(i, i, SBPS_NORMAL | SBPS_OWNERDRAW, nWidth);
	}

	// ăCAEg
	RecalcLayout();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ʒuE`
//	bStart=FALSȄꍇAbFullScreen=FALSE̎Ɉʒu𕜌邱
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::InitPos(BOOL bStart)
{
	int cx;
	int cy;
	CRect rect;
	CRect rectStatus;
	CRect rectWnd;

	ASSERT(this);

	// XN[TCYAEBhE`擾
	cx = ::GetSystemMetrics(SM_CXSCREEN);
	cy = ::GetSystemMetrics(SM_CYSCREEN);
	GetWindowRect(&rectWnd);

	// 800x600ȉ̓XN[TCYςɍL
	if ((cx <= 800) || (cy <= 600)) {
		if ((rectWnd.left != 0) || (rectWnd.top != 0)) {
			SetWindowPos(&wndTop, 0, 0, cx, cy, SWP_NOZORDER);
			return;
		}
		if ((rectWnd.Width() != cx) || (rectWnd.Height() != cy)) {
			SetWindowPos(&wndTop, 0, 0, cx, cy, SWP_NOZORDER);
			return;
		}
		return;
	}

	// 824x560(DDP2)mC^[[X̍őTCYƔF
	rect.left = 0;
	rect.top = 0;
	rect.right = 824;
	rect.bottom = 560;
	::AdjustWindowRectEx(&rect, GetView()->GetStyle(), FALSE, GetView()->GetExStyle());
	m_StatusBar.GetWindowRect(&rectStatus);
	rect.bottom += rectStatus.Height();
	::AdjustWindowRectEx(&rect, GetStyle(), TRUE, GetExStyle());

	// rect.left, rect.bottomɂȂ炵(ȍ~Aright,bottomcx,cy)
	rect.right -= rect.left;
	rect.left = 0;
	rect.bottom -= rect.top;
	rect.top = 0;

	// ]T΁AZ^O
	if (rect.right < cx) {
		rect.left = (cx - rect.right) / 2;
	}
	if (rect.bottom < cy) {
		rect.top = (cy - rect.bottom) / 2;
	}

	// bStartŕ(JnAEBhE|tXN[̐؂ւ)
	if (bStart) {
		// EBhEʒuUۑ(̌AēxRestoreFrameWnd̃`X)
		m_nWndLeft = rect.left;
		m_nWndTop = rect.top;
	}
	else {
		// EBhE[h̎ɌAʒu␳
		if (!m_bFullScreen) {
			if ((rect.left == 0) && (rect.top == 0)) {
				// WM_DISPLAYCHANGEbZ[WāAEBhEȂꍇ
				m_nWndLeft = rect.left;
				m_nWndTop = rect.top;
			}
			else {
				// ȊO(tXN[EBhEւ̏ԑJڂ܂)
				rect.left = m_nWndLeft;
				rect.top = m_nWndTop;
			}
		}
	}

	// ݒ
	if ((rect.left != rectWnd.left) || (rect.top != rectWnd.top)) {
		SetWindowPos(&wndTop, rect.left, rect.top, rect.right, rect.bottom, 0);
		return;
	}
	if ((rect.right != rectWnd.Width()) || (rect.bottom != rectWnd.Height())) {
		SetWindowPos(&wndTop, rect.left, rect.top, rect.right, rect.bottom, 0);
		return;
	}
}

//---------------------------------------------------------------------------
//
//	VFAg
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::InitShell()
{
	int nSources;

	// ʒmvݒ
	if (::IsWinNT()) {
		// Windows2000/XP:shared memory𗘗ptOǉ
		nSources = SHCNRF_InterruptLevel | SHCNRF_ShellLevel | SHCNRF_NewDelivery;
	}
	else {
		// Windows9x:shared memory͎gpȂ
		nSources = SHCNRF_InterruptLevel | SHCNRF_ShellLevel;
	}

	// Gg
	m_fsne[0].pidl = NULL;
	m_fsne[0].fRecursive = FALSE;

	// VFʒmbZ[Wo^
	m_uNotifyId = ::ShellChangeNotifyRegister(m_hWnd,
							nSources,
							SHCNE_MEDIAINSERTED | SHCNE_MEDIAREMOVED | SHCNE_DRIVEADD | SHCNE_DRIVEREMOVED,
							WM_SHELLNOTIFY,
							sizeof(m_fsne)/sizeof(m_fsne[0]),
							m_fsne);
	ASSERT(m_uNotifyId);
}

//---------------------------------------------------------------------------
//
//	VM
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::InitVM()
{
	::pVM = new VM;
	if (!::GetVM()->Init()) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	R|[lg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::InitComponent()
{
	BOOL bSuccess;
	CComponent *pComponent;

	ASSERT(!m_pFirstComponent);
	ASSERT(!m_pSch);
	ASSERT(!m_pSound);
	ASSERT(!m_pInput);
	ASSERT(!m_pPort);
	ASSERT(!m_pMIDI);
	ASSERT(!m_pTKey);
	ASSERT(!m_pHost);
	ASSERT(!m_pInfo);
	ASSERT(!m_pConfig);

	// RXgNg(ԂlKvBŏConfigAŌScheduler)
	m_pConfig = new CConfig(this);
	m_pFirstComponent = m_pConfig;
	m_pSound = new CSound(this);
	m_pFirstComponent->AddComponent(m_pSound);
	m_pInput = new CInput(this);
	m_pFirstComponent->AddComponent(m_pInput);
	m_pPort = new CPort(this);
	m_pFirstComponent->AddComponent(m_pPort);
	m_pMIDI = new CMIDI(this);
	m_pFirstComponent->AddComponent(m_pMIDI);
	m_pTKey = new CTKey(this);
	m_pFirstComponent->AddComponent(m_pTKey);
	m_pHost = new CHost(this);
	m_pFirstComponent->AddComponent(m_pHost);
	m_pInfo = new CInfo(this, &m_StatusBar);
	m_pFirstComponent->AddComponent(m_pInfo);
	m_pSch = new CScheduler(this);
	m_pFirstComponent->AddComponent(m_pSch);

	// 
	pComponent = m_pFirstComponent;
	bSuccess = TRUE;

	// [v
	while (pComponent) {
		if (!pComponent->Init()) {
			bSuccess = FALSE;
		}
		pComponent = pComponent->GetNextComponent();
	}

	return bSuccess;
}

//---------------------------------------------------------------------------
//
//	o[W
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::InitVer()
{
	TCHAR szPath[_MAX_PATH];
	DWORD dwHandle;
	DWORD dwLength;
	BYTE *pVerInfo;
	VS_FIXEDFILEINFO *pFileInfo;
	UINT uLength;
	DWORD dwMajor;
	DWORD dwMinor;

	ASSERT(this);

	// pX擾
	::GetModuleFileName(NULL, szPath, _MAX_PATH);

	// o[Wǂݎ
	dwLength = GetFileVersionInfoSize(szPath, &dwHandle);
	if (dwLength == 0) {
		return;
	}

	pVerInfo = new BYTE[ dwLength ];
	if (::GetFileVersionInfo(szPath, dwHandle, dwLength, pVerInfo) == 0) {
		delete[] pVerInfo;
		return;
	}

	// o[Wo
	if (::VerQueryValue(pVerInfo, _T("\\"), (LPVOID*)&pFileInfo, &uLength) == 0) {
		delete[] pVerInfo;
		return;
	}

	// o[W𕪗AVM֒ʒm
	dwMajor = (DWORD)HIWORD(pFileInfo->dwProductVersionMS);
	dwMinor = (DWORD)(LOWORD(pFileInfo->dwProductVersionMS) * 16
					+ HIWORD(pFileInfo->dwProductVersionLS));
	::GetVM()->SetVersion(dwMajor, dwMinor);

	// I
	delete[] pVerInfo;
}

//---------------------------------------------------------------------------
//
//	ROM
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::InitROM(UINT nType)
{
	CROMDlg dlg(this);
	Memory *pMemory;
	Config config;

	ASSERT((nType >= 0) && (nType <= 2));

	// ݒ擾
	GetConfig()->GetConfig(&config);

	// 擾
	pMemory = (Memory*)::GetVM()->SearchDevice(MAKEID('M', 'E', 'M', ' '));
	ASSERT(pMemory);

	// 炩߁A_CAOɃ^CvZbgĂ
	dlg.m_nType = nType;

	// ^Cv
	switch (nType) {
		// IPL-ROM
		case 0:
			// `FbN邩
			if (!config.rom_ipl) {
				return TRUE;
			}

			// `FbN{
			if (pMemory->CheckIPL()) {
				return TRUE;
			}

			// _CAO
			if (dlg.DoModal() == IDCANCEL) {
				return FALSE;
			}

			// `FbN{bNX
			config.rom_ipl = dlg.m_bFuture;
			break;

		// CG-ROM
		case 1:
			// `FbN邩
			if (!config.rom_cg) {
				return TRUE;
			}

			// `FbN{
			if (pMemory->CheckCG()) {
				return TRUE;
			}

			// _CAO
			if (dlg.DoModal() == IDCANCEL) {
				return FALSE;
			}

			// `FbN{bNX
			config.rom_cg = dlg.m_bFuture;
			break;

		// SCSI-ROM
		case 2:
			// `FbN邩
			if (!config.rom_scsi) {
				return TRUE;
			}

			// `FbN{
			if (pMemory->CheckSCSI()) {
				return TRUE;
			}

			// _CAO
			if (dlg.DoModal() == IDCANCEL) {
				return FALSE;
			}

			// `FbN{bNX
			config.rom_scsi = dlg.m_bFuture;
			break;

		// ̑(肦Ȃ)
		default:
			ASSERT(FALSE);
			return FALSE;
	}

	// ݒXV
	GetConfig()->SetConfig(&config);

	// p
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	R}hC
//	R}hCAWM_COPYDATAŋ
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::InitCmd(LPCTSTR lpszCmd)
{
	LPCTSTR lpszCurrent;
	LPCTSTR lpszNext;
	TCHAR szPath[_MAX_PATH];
	int nLen;
	int i;
	BOOL bReset;

	ASSERT(this);
	ASSERT(lpszCmd);

	// |C^AtO
	lpszCurrent = lpszCmd;
	bReset = FALSE;

	// [v
	for (i=0; i<2; i++) {
		// Xy[XA^u̓XLbv
		while (lpszCurrent[0] <= _T(0x20)) {
			if (lpszCurrent[0] == _T('\0')) {
				break;
			}
			lpszCurrent++;
		}
		if (lpszCurrent[0] == _T('\0')) {
			break;
		}

		// ŏ_uNH[gȂÃNH[gT
		if (lpszCurrent[0] == _T('\x22')) {
			lpszNext = _tcschr(lpszCurrent + 1, _T('\x22'));
			if (!lpszNext) {
				// Ή_uNH[gȂ
				return;
			}
			nLen = (int)(lpszNext - (lpszCurrent + 1));
			if (nLen >= _MAX_PATH) {
				// 
				return;
			}

			// NH[gꂽRs[
			_tcsnccpy(szPath, &lpszCurrent[1], nLen);
			szPath[nLen] = _T('\0');

			// NH[g̎w
			lpszCurrent = &lpszNext[1];
		}
		else {
			// ̃Xy[XT
			lpszNext = _tcschr(lpszCurrent + 1, _T(' '));
			if (lpszNext) {
				// Xy[X܂
				nLen = (int)(lpszNext - lpszCurrent);
				if (nLen >= _MAX_PATH) {
					// 
					return;
				}

				// Xy[X܂ł̕Rs[
				_tcsnccpy(szPath, lpszCurrent, nLen);
				szPath[nLen] = _T('\0');

				// Xy[X̎w
				lpszCurrent = &lpszNext[1];
			}
			else {
				// I[܂
				_tcscpy(szPath, lpszCurrent);
				lpszCurrent = NULL;
			}
		}

		// I[v݂
		bReset = InitCmdSub(i, szPath);

		// I[ȂI
		if (!lpszCurrent) {
			break;
		}
	}

	// Zbgv΁AZbg
	if (bReset) {
		OnReset();
	}
}

//---------------------------------------------------------------------------
//
//	R}hC Tu
//	R}hCAWM_COPYDATAAhbO&hbvŋ
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::InitCmdSub(int nDrive, LPCTSTR lpszPath)
{
	Filepath path;
	Fileio fio;
	LPTSTR lpszFile;
	DWORD dwSize;
	TCHAR szPath[_MAX_PATH];
	FDI *pFDI;
	CString strMsg;

	ASSERT(this);
	ASSERT((nDrive == 0) || (nDrive == 1));
	ASSERT(lpszPath);

	// pFDI
	pFDI = NULL;

	// t@CI[v`FbN
	path.SetPath(lpszPath);
	if (!fio.Open(path, Fileio::ReadOnly)) {
		return FALSE;
	}
	dwSize = fio.GetFileSize();
	fio.Close();

	// tpX
	::GetFullPathName(lpszPath, _MAX_PATH, szPath, &lpszFile);
	path.SetPath(szPath);

	// VMbN
	::LockVM();

	// 128MO or 230MO or 540MO or 640MO
	if ((dwSize == 0x797f400) || (dwSize == 0xd9eea00) ||
		(dwSize == 0x1fc8b800) || (dwSize == 0x25e28000)) {
		// MO̊蓖Ă݂
		nDrive = 2;

		if (!m_pSASI->Open(path)) {
			// MO蓖Ďs
			GetScheduler()->Reset();
			ResetCaption();
			::UnlockVM();
			return FALSE;
		}
	}
	else {
		if (dwSize >= 0x200000) {
			// VM̊蓖Ă݂
			nDrive = 4;

			// I[vO
			if (!OnOpenPrep(path, FALSE)) {
				// t@CȂAo[WȂǂȂ
				GetScheduler()->Reset();
				ResetCaption();
				::UnlockVM();
				return FALSE;
			}

			// [hs(OnOpenSubɔC)
			::UnlockVM();
			if (OnOpenSub(path)) {
				Filepath::SetDefaultDir(szPath);
			}
			// Zbg͍sȂ
			return FALSE;
		}
		else {
			// FD̊蓖Ă݂
			if (!m_pFDD->Open(nDrive, path)) {
				// FD蓖Ďs
				GetScheduler()->Reset();
				ResetCaption();
				::UnlockVM();
				return FALSE;
			}
			pFDI = m_pFDD->GetFDI(nDrive);
		}
	}

	// VMZbgAbN
	GetScheduler()->Reset();
	ResetCaption();
	::UnlockVM();

	// BfBNgۑMRUǉ
	Filepath::SetDefaultDir(szPath);
	GetConfig()->SetMRUFile(nDrive, szPath);

	// tbs[ȂABADC[Wx
	if (pFDI) {
		if (pFDI->GetID() == MAKEID('B', 'A', 'D', ' ')) {
			::GetMsg(IDS_BADFDI_WARNING, strMsg);
			MessageBox(strMsg, NULL, MB_ICONSTOP | MB_OK);
		}

		// tbs[蓖ĂƂAZbg
		return TRUE;
	}

	// I
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	R|[lgZ[u
//	XPW[͒~Ă邪ACSound,CInput͓쒆
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::SaveComponent(const Filepath& path, DWORD dwPos)
{
	Fileio fio;
	DWORD dwID;
	CComponent *pComponent;
	DWORD dwMajor;
	DWORD dwMinor;
	int nVer;

	ASSERT(this);
	ASSERT(dwPos > 0);

	// o[W쐬
	::GetVM()->GetVersion(dwMajor, dwMinor);
	nVer = (int)((dwMajor << 8) | dwMinor);

	// t@CI[vƃV[N
	if (!fio.Open(path, Fileio::Append)) {
		return FALSE;
	}
	if (!fio.Seek(dwPos)) {
		fio.Close();
		return FALSE;
	}

	// CR|[lgۑ
	dwID = MAKEID('M', 'A', 'I', 'N');
	if (!fio.Write(&dwID, sizeof(dwID))) {
		fio.Close();
		return FALSE;
	}

	// R|[lg[v
	pComponent = m_pFirstComponent;
	while (pComponent) {
		// IDۑ
		dwID = pComponent->GetID();
		if (!fio.Write(&dwID, sizeof(dwID))) {
			fio.Close();
			return FALSE;
		}

		// R|[lgŗL
		if (!pComponent->Save(&fio, nVer)) {
			fio.Close();
			return FALSE;
		}

		// 
		pComponent = pComponent->GetNextComponent();
	}

	// I[
	dwID = MAKEID('E', 'N', 'D', ' ');
	if (!fio.Write(&dwID, sizeof(dwID))) {
		fio.Close();
		return FALSE;
	}

	// I
	fio.Close();
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	R|[lg[h
//	XPW[͒~Ă邪ACSound,CInput͓쒆
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::LoadComponent(const Filepath& path, DWORD dwPos)
{
	Fileio fio;
	DWORD dwID;
	CComponent *pComponent;
	char cHeader[0x10];
	int nVer;

	ASSERT(this);
	ASSERT(dwPos > 0);

	// t@CI[v
	if (!fio.Open(path, Fileio::ReadOnly)) {
		return FALSE;
	}

	// wb_ǂݎ
	if (!fio.Read(cHeader, sizeof(cHeader))) {
		fio.Close();
		return FALSE;
	}

	// wb_`FbNAo[Wǂݎ
	cHeader[0x0a] = '\0';
	nVer = ::strtoul(&cHeader[0x09], NULL, 16);
	nVer <<= 8;
	cHeader[0x0d] = '\0';
	nVer |= ::strtoul(&cHeader[0x0b], NULL, 16);
	cHeader[0x09] = '\0';
	if (strcmp(cHeader, "XM6 DATA ") != 0) {
		fio.Close();
		return FALSE;
	}

	// V[N
	if (!fio.Seek(dwPos)) {
		fio.Close();
		return FALSE;
	}

	// CR|[lgǂݎ
	if (!fio.Read(&dwID, sizeof(dwID))) {
		fio.Close();
		return FALSE;
	}
	if (dwID != MAKEID('M', 'A', 'I', 'N')) {
		fio.Close();
		return FALSE;
	}

	// R|[lg[v
	for (;;) {
		// IDǂݎ
		if (!fio.Read(&dwID, sizeof(dwID))) {
			fio.Close();
			return FALSE;
		}

		// I`FbN
		if (dwID == MAKEID('E', 'N', 'D', ' ')) {
			break;
		}

		// R|[lgT
		pComponent = m_pFirstComponent->SearchComponent(dwID);
		if (!pComponent) {
			// Z[u̓R|[lg݂A͌Ȃ
			fio.Close();
			return FALSE;
		}

		// R|[lgŗL
		if (!pComponent->Load(&fio, nVer)) {
			fio.Close();
			return FALSE;
		}
	}

	// N[Y
	fio.Close();

	// ݒKp(VMbNčs)
	if (GetConfig()->IsApply()) {
		::LockVM();
		ApplyCfg();
		::UnlockVM();
	}

	// EBhEĕ`
	GetView()->Invalidate(FALSE);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::ApplyCfg()
{
	Config config;
	CComponent *pComponent;

	// ݒ擾
	GetConfig()->GetConfig(&config);

	// ܂VMɓKp
	::GetVM()->ApplyCfg(&config);

	// ɃR|[lgɓKp
	pComponent = m_pFirstComponent;
	while (pComponent) {
		pComponent->ApplyCfg(&config);
		pComponent = pComponent->GetNextComponent();
	}

	// Ƀr[ɓKp
	GetView()->ApplyCfg(&config);

	// t[EBhE(|bvAbv)
	if (config.popup_swnd != m_bPopup) {
		// TuEBhEׂăNA
		GetView()->ClrSWnd();

		// ύX
		m_bPopup = config.popup_swnd;
	}

	// t[EBhE(}EX)
	m_bMouseMid = config.mouse_mid;
	m_bAutoMouse = config.auto_mouse;
	if (config.mouse_port == 0) {
		// }EXڑȂȂA}EX[hOFF
		if (GetInput()->GetMouseMode()) {
			OnMouseMode();
		}
	}
}

//---------------------------------------------------------------------------
//
//	LbN
//
//---------------------------------------------------------------------------
LONG CFrmWnd::OnKick(UINT /*uParam*/, LONG /*lParam*/)
{
	CComponent *pComponent;
	CInfo *pInfo;
	Config config;
	CString strMsg;
	MSG msg;
	int nIdle;
	LPSTR lpszCmd;
	LPCTSTR lpszCommand;
	BOOL bFullScreen;
	UINT nROM;

	// G[ɍs
	switch (m_nStatus) {
		// VMG[
		case 1:
			::GetMsg(IDS_INIT_VMERR, strMsg);
			MessageBox(strMsg, NULL, MB_ICONSTOP | MB_OK);
			PostMessage(WM_CLOSE, 0, 0);
			return 0;

		// R|[lgG[
		case 2:
			::GetMsg(IDS_INIT_COMERR, strMsg);
			MessageBox(strMsg, NULL, MB_ICONSTOP | MB_OK);
			PostMessage(WM_CLOSE, 0, 0);
			return 0;
	}
	// ̏ꍇ
	ASSERT(m_nStatus == 0);

	// ROM`FbN
	for (nROM=0; nROM<3; nROM++) {
		// `FbN
		if (!InitROM(nROM)) {
			// IIꂽ̂ŁAI
			PostMessage(WM_CLOSE, 0, 0);
			return 0;
		}
	}

	// CP932`FbN(x݂̂ŁA)
	if (!::IsJapanese() && ::IsWinNT() && !::Support932) {
		::GetMsg(IDS_INIT_CPERR, strMsg);
		MessageBox(strMsg, NULL, MB_ICONEXCLAMATION | MB_OK);
	}

	// ݒ擾(power_offݒ̂)
	GetConfig()->GetConfig(&config);
	if (config.power_off) {
		// dOFFŋN
		::GetVM()->SetPower(FALSE);
		::GetVM()->PowerSW(FALSE);
	}

	// TuEBhȄ
	m_strWndClsName = AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS);

	// R|[lgCl[uBScheduler͐ݒɂ
	GetView()->Enable(TRUE);
	pComponent = m_pFirstComponent;
	while (pComponent) {
		// XPW[
		if (pComponent->GetID() == MAKEID('S', 'C', 'H', 'E')) {
			if (config.power_off) {
				// dOFFŋN
				pComponent->Enable(FALSE);
				pComponent = pComponent->GetNextComponent();
				continue;
			}
		}

		// Cl[u
		pComponent->Enable(TRUE);
		pComponent = pComponent->GetNextComponent();
	}

	// Zbg(Xe[^Xo[̂)
	if (!config.power_off) {
		OnReset();
	}

	// R}hC
	lpszCmd = AfxGetApp()->m_lpCmdLine;
	lpszCommand = A2T(lpszCmd);
	if (_tcslen(lpszCommand) > 0) {
		InitCmd(lpszCommand);
	}

	// ő剻wł΁A߂ɁAtXN[
	bFullScreen = FALSE;
	if (IsZoomed()) {
		ShowWindow(SW_RESTORE);
		bFullScreen = TRUE;
	}

	// EChEʒuW[
	bFullScreen = RestoreFrameWnd(bFullScreen);
	if (bFullScreen) {
		// ő剻w肩AOsɃtXN[
		PostMessage(WM_COMMAND, IDM_FULLSCREEN);
	}

	// fBXNEXe[gW[
	RestoreDiskState();

	// [v
	nIdle = 0;
	while (!m_bExit) {
		// bZ[W`FbN|v
		if (::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
			if (!AfxGetApp()->PumpMessage()) {
				::PostQuitMessage(0);
				return 0;
			}
			// continue邱ƂŁAWM_DESTROYm_bExit`FbNۏ
			continue;
		}

		// X[v
		if (!PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
			Sleep(20);

			// Info𖈉蒼
			pInfo = GetInfo();
			if (!pInfo) {
				continue;
			}

			// XVJE^Up
			nIdle++;

			// Xe[^XEs20ms
			pInfo->UpdateStatus();
			UpdateExec();

			if ((nIdle & 1) == 0) {
				// r[40ms
				GetView()->Update();
			}

			if ((nIdle & 3) == 0) {
				// LvVA80ms
				pInfo->UpdateCaption();
				pInfo->UpdateInfo();
			}
		}
	}

	return 0;
}

//---------------------------------------------------------------------------
//
//	EBhENX擾
//
//---------------------------------------------------------------------------
LPCTSTR FASTCALL CFrmWnd::GetWndClassName() const
{
	ASSERT(this);
	ASSERT(m_strWndClsName.GetLength() != 0);

	return (LPCTSTR)m_strWndClsName;
}

//---------------------------------------------------------------------------
//
//	|bvAbv
//
//---------------------------------------------------------------------------
BOOL FASTCALL CFrmWnd::IsPopupSWnd() const
{
	ASSERT(this);
	return m_bPopup;
}

//---------------------------------------------------------------------------
//
//	EBhEN[Y
//
//---------------------------------------------------------------------------
void CFrmWnd::OnClose()
{
	CString strFormat;
	CString strText;
	Filepath path;
	int nResult;

	ASSERT(this);
	ASSERT(!m_bSaved);

	// LȃXe[gt@C΁AZ[u₤
	::LockVM();
	::GetVM()->GetPath(path);
	::UnlockVM();

	// LȃXe[gt@C
	if (!path.IsClear()) {
		// WindowsTCh20msȏ̎sт
		if (m_dwExec >= 2) {
			// mF
			::GetMsg(IDS_SAVECLOSE, strFormat);
			strText.Format(strFormat, path.GetFileExt());
			nResult = MessageBox(strText, NULL, MB_ICONQUESTION | MB_YESNOCANCEL);

			// mFʂɂ
			switch (nResult) {
				// YES
				case IDYES:
					// ۑ
					OnSaveSub(path);
					break;

				// NO
				case IDNO:
					// pXNA(Xe[gȂ)
					::GetVM()->Clear();
					break;

				// LZ
				case IDCANCEL:
					// N[YȂƂɂ
					return;
			}
		}
	}

	// ς݂Ȃ
	if ((m_nStatus == 0) && !m_bSaved) {
		// EBhEԁEfBXNEXe[gۑ
		SaveFrameWnd();
		SaveDiskState();
		m_bSaved = TRUE;
	}

	// tXN[͉
	if (m_bFullScreen) {
		ASSERT(m_nStatus == 0);
		OnFullScreen();
	}

	// ς݂Ȃ
	if (m_nStatus == 0) {
		// }EX
		if (GetInput()->GetMouseMode()) {
			OnMouseMode();
		}
	}

	// {NX
	CFrameWnd::OnClose();
}

//---------------------------------------------------------------------------
//
//	EBhE폜
//
//---------------------------------------------------------------------------
void CFrmWnd::OnDestroy()
{
	ASSERT(this);

	// ς݂Ȃ
	if ((m_nStatus == 0) && !m_bSaved) {
		// EBhEԁEfBXNEXe[gۑ
		SaveFrameWnd();
		SaveDiskState();
		m_bSaved = TRUE;
	}

	// tXN[͉
	if (m_bFullScreen) {
		ASSERT(m_nStatus == 0);
		OnFullScreen();
	}

	// N[Abv(WM_ENDSESSIONƋ)
	CleanSub();

	// {NX
	CFrameWnd::OnDestroy();
}

//---------------------------------------------------------------------------
//
//	ZbVI
//
//---------------------------------------------------------------------------
void CFrmWnd::OnEndSession(BOOL bEnding)
{
	ASSERT(this);

	// ÍAN[Abvs
	if (bEnding) {
		// ς݂Ȃ
		if (m_nStatus == 0) {
			// EBhEԁEfBXNEXe[gۑ
			if (!m_bSaved) {
				SaveFrameWnd();
				SaveDiskState();
				m_bSaved = TRUE;
			}

			// N[Abv
			CleanSub();
		}
	}

	// {NX
	CFrameWnd::OnEndSession(bEnding);
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::CleanSub()
{
	CComponent *pComponent;
	CComponent *pNext;
	int i;

	// ItOグ
	m_bExit = TRUE;

	// R|[lg~߂
	GetView()->Enable(FALSE);
	pComponent = m_pFirstComponent;
	while (pComponent) {
		pComponent->Enable(FALSE);
		pComponent = pComponent->GetNextComponent();
	}

	// }EX
	if (m_nStatus == 0) {
		if (GetInput()->GetMouseMode()) {
			OnMouseMode();
		}
	}

	// XPW[s߂܂ő҂
	for (i=0; i<8; i++) {
		::LockVM();
		::UnlockVM();
	}

	// XPW[~(CScheduler)
	if (m_nStatus == 0) {
		GetScheduler()->Stop();
	}

	// R|[lg폜
	pComponent = m_pFirstComponent;
	while (pComponent) {
		pComponent->Cleanup();
		pComponent = pComponent->GetNextComponent();
	}
	pComponent = m_pFirstComponent;
	while (pComponent) {
		pNext = pComponent->GetNextComponent();
		delete pComponent;
		pComponent = pNext;
	}

	// z}V폜
	if (::pVM) {
		::LockVM();
		::GetVM()->Cleanup();
		delete ::pVM;
		::pVM = NULL;
		::UnlockVM();
	}

	// VFʒm폜
	if (m_uNotifyId) {
		 VERIFY(::ShellChangeNotifyDeregister(m_uNotifyId));
		 m_uNotifyId = NULL;
	}
}

//---------------------------------------------------------------------------
//
//	EBhEԂۑ
//
//---------------------------------------------------------------------------
void CFrmWnd::SaveFrameWnd()
{
	CRect rectWnd;
	Config config;

	ASSERT(this);
	ASSERT_VALID(this);

	// ݒ擾
	GetConfig()->GetConfig(&config);

	// LvVEj[EXe[^Xo[
	config.caption = m_bCaption;
	config.menu_bar = m_bMenuBar;
	config.status_bar = m_bStatusBar;

	// EBhE`
	if (m_bFullScreen) {
		// tXN[́AEBhËʒuۑ
		config.window_left = m_nWndLeft;
		config.window_top = m_nWndTop;
	}
	else {
		// EBhÉÄ݂ʒuۑ
		GetWindowRect(&rectWnd);
		config.window_left = rectWnd.left;
		config.window_top = rectWnd.top;
	}

	// tXN[
	config.window_full = m_bFullScreen;

	// ݒύX
	GetConfig()->SetConfig(&config);
}

//---------------------------------------------------------------------------
//
//	fBXNEXe[gۑ
//
//---------------------------------------------------------------------------
void CFrmWnd::SaveDiskState()
{
	int nDrive;
	Filepath path;
	Config config;

	ASSERT(this);
	ASSERT_VALID(this);

	// bN
	::LockVM();

	// ݒ擾
	GetConfig()->GetConfig(&config);

	// tbs[fBXN
	for (nDrive=0; nDrive<2; nDrive++) {
		// fB
		config.resume_fdi[nDrive] = m_pFDD->IsReady(nDrive, FALSE);

		// fBłȂ΁A
		if (!config.resume_fdi[nDrive]) {
			continue;
		}

		// fBA
		config.resume_fdm[nDrive]  = m_pFDD->GetMedia(nDrive);

		// CgveNg
		config.resume_fdw[nDrive] = m_pFDD->IsWriteP(nDrive);
	}

	// MOfBXN
	config.resume_mos = m_pSASI->IsReady();
	if (config.resume_mos) {
		config.resume_mow = m_pSASI->IsWriteP();
	}

	// CD-ROM
	config.resume_iso = m_pSCSI->IsReady(FALSE);

	// Xe[g
	::GetVM()->GetPath(path);
	config.resume_xm6 = !path.IsClear();

	// ftHgfBNg
	_tcscpy(config.resume_path, Filepath::GetDefaultDir());

	// ݒύX
	GetConfig()->SetConfig(&config);

	// AbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	EBhEԂ𕜌
//	OnCreateOnKickƁA2Ă΂
//
//---------------------------------------------------------------------------
BOOL CFrmWnd::RestoreFrameWnd(BOOL bFullScreen)
{
	int nWidth;
	int nHeight;
	int nLeft;
	int nTop;
	CRect rectWnd;
	BOOL bValid;
	Config config;

	ASSERT(this);

	// ݒ擾
	GetConfig()->GetConfig(&config);

	// EBhEʒu̕w肳ĂȂ΁AftHgԂœ
	if (!config.resume_screen) {
		return bFullScreen;
	}

	// LvV
	m_bCaption = config.caption;
	ShowCaption();

	// j[
	m_bMenuBar = config.menu_bar;
	ShowMenu();

	// Xe[^Xo[
	m_bStatusBar = config.status_bar;
	ShowStatus();

	// zʂ̃TCYƌ_擾
	nWidth = ::GetSystemMetrics(SM_CXVIRTUALSCREEN);
	nHeight = ::GetSystemMetrics(SM_CYVIRTUALSCREEN);
	nLeft = ::GetSystemMetrics(SM_XVIRTUALSCREEN);
	nTop = ::GetSystemMetrics(SM_YVIRTUALSCREEN);

	// EBhE`擾
	GetWindowRect(&rectWnd);

	// ̓͂Ƃɂ΁AEBhEʒuړB܂̓`FbN
	bValid = TRUE;
	if (config.window_left < nLeft) {
		if (config.window_left < nLeft - rectWnd.Width()) {
			bValid = FALSE;
		}
	}
	else {
		if (config.window_left >= (nLeft + nWidth)) {
			bValid = FALSE;
		}
	}
	if (config.window_top < nTop) {
		if (config.window_top < nTop - rectWnd.Height()) {
			bValid = FALSE;
		}
	}
	else {
		if (config.window_top >= (nTop + nHeight)) {
			bValid = FALSE;
		}
	}

	// EBhEʒuړ
	if (bValid) {
		SetWindowPos(&wndTop, config.window_left, config.window_top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

		// [NGAɕύX
		m_nWndLeft = config.window_left;
		m_nWndTop = config.window_top;
	}

	// VMȂA܂
	if (m_nStatus != 0) {
		return FALSE;
	}

	// tXN[
	if (bFullScreen || config.window_full) {
		// ő剻NAOtXN[
		if (IsIconic() || (AfxGetApp()->m_nCmdShow == SW_MINIMIZE)) {
			// AŏwŋNĂ΁Awincore.cppŔj]̂ŁA}~
			return FALSE;
		}

		// ŏwłȂBtXN[ɂĂ悢
		return TRUE;
	}

	// ő剻NłȂAAOʏ\
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	fBXNEXe[g𕜌
//
//---------------------------------------------------------------------------
void CFrmWnd::RestoreDiskState()
{
	int nDrive;
	TCHAR szMRU[_MAX_PATH];
	BOOL bResult;
	Filepath path;
	Config config;

	ASSERT(this);

	// ݒ擾
	GetConfig()->GetConfig(&config);

	// Xe[gw肳Ă΁Aɍs
	if (config.resume_state) {
		// Xe[g
		if (config.resume_xm6) {
			// pX擾
			GetConfig()->GetMRUFile(4, 0, szMRU);
			path.SetPath(szMRU);

			// I[vO
			if (OnOpenPrep(path)) {
				// I[vTu
				if (OnOpenSub(path)) {
					// Ȃ̂ŁAftHgfBNg
					if (config.resume_dir) {
						Filepath::SetDefaultDir(config.resume_path);
					}

					// ȍ~͏Ȃ(FD, MO, CD̃ANZXɃZ[uꍇ)
					return;
				}
			}
		}
	}

	// tbs[fBXN
	if (config.resume_fd) {
		for (nDrive=0; nDrive<2; nDrive++) {
			// fBXN}Ă
			if (!config.resume_fdi[nDrive]) {
				// fBXN}ĂȂBXLbv
				continue;
			}

			// fBXN}
			GetConfig()->GetMRUFile(nDrive, 0, szMRU);
			ASSERT(szMRU[0] != _T('\0'));
			path.SetPath(szMRU);

			// VMbNsAfBXN蓖Ă݂
			::LockVM();
			bResult = m_pFDD->Open(nDrive, path, config.resume_fdm[nDrive]);
			::UnlockVM();

			// 蓖ĂłȂ΃XLbv
			if (!bResult) {
				continue;
			}

			// ݋֎~
			if (config.resume_fdw[nDrive]) {
				::LockVM();
				m_pFDD->WriteP(nDrive, TRUE);
				::UnlockVM();
			}
		}
	}

	// MOfBXN
	if (config.resume_mo) {
		// fBXN}Ă
		if (config.resume_mos) {
			// fBXN}
			GetConfig()->GetMRUFile(2, 0, szMRU);
			ASSERT(szMRU[0] != _T('\0'));
			path.SetPath(szMRU);

			// VMbNsAfBXN蓖Ă݂
			::LockVM();
			bResult = m_pSASI->Open(path);
			::UnlockVM();

			// 蓖Ăł
			if (bResult) {
				// ݋֎~
				if (config.resume_mow) {
					::LockVM();
					m_pSASI->WriteP(TRUE);
					::UnlockVM();
				}
			}
		}
	}

	// CD-ROM
	if (config.resume_cd) {
		// fBXN}Ă
		if (config.resume_iso) {
			// fBXN}
			GetConfig()->GetMRUFile(3, 0, szMRU);
			ASSERT(szMRU[0] != _T('\0'));
			path.SetPath(szMRU);

			// VMbNsAfBXN蓖Ă݂
			::LockVM();
			m_pSCSI->Open(path, FALSE);
			::UnlockVM();
		}
	}

	// ftHgfBNg
	if (config.resume_dir) {
		Filepath::SetDefaultDir(config.resume_path);
	}
}

//---------------------------------------------------------------------------
//
//	fBXvCύX
//
//---------------------------------------------------------------------------
LRESULT CFrmWnd::OnDisplayChange(UINT uParam, LONG lParam)
{
	LRESULT lResult;

	// {NX
	lResult = CFrameWnd::OnDisplayChange(uParam, lParam);

	// ŏ͉Ȃ
	if (IsIconic()) {
		return lResult;
	}

	// |WVݒ
	InitPos(FALSE);

	return lResult;
}

//---------------------------------------------------------------------------
//
//	EBhEwi`
//
//---------------------------------------------------------------------------
BOOL CFrmWnd::OnEraseBkgnd(CDC * /* pDC */)
{
	// wi`}
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhE`
//
//---------------------------------------------------------------------------
void CFrmWnd::OnPaint()
{
	PAINTSTRUCT ps;

	// KbNčs
	::LockVM();

	BeginPaint(&ps);

	// VMLȂLvVAXe[^Xo[Zbg
	if (m_nStatus == 0) {
		ResetCaption();
		ResetStatus();
	}

	EndPaint(&ps);

	// AbN
	::UnlockVM();
}

//---------------------------------------------------------------------------
//
//	EBhEړ
//
//---------------------------------------------------------------------------
void CFrmWnd::OnMove(int x, int y)
{
	CRect rect;

	// ς݂Ȃ
	if (m_nStatus == 0) {
		// }EX[h`FbN
		if (GetInput()->GetMouseMode()) {
			// Nbv͈͂ύX
			ClipCursor(NULL);
			GetWindowRect(&rect);
			SetCursorPos((rect.left + rect.right) / 2, (rect.top + rect.bottom) / 2);
			ClipCursor(&rect);
		}
	}

	// {NX
	CFrameWnd::OnMove(x, y);
}

//---------------------------------------------------------------------------
//
//	ANeBx[g
//
//---------------------------------------------------------------------------
void CFrmWnd::OnActivate(UINT nState, CWnd *pWnd, BOOL bMinimized)
{
	CInput *pInput;
	CScheduler *pScheduler;

	// ς݂Ȃ
	if (m_nStatus == 0) {
		// CvbgAXPW[֒ʒm
		pInput = GetInput();
		pScheduler = GetScheduler();
		if (pInput && pScheduler) {
			// WA_INACTIVEŏȂAfBZ[u
			if ((nState == WA_INACTIVE) || bMinimized) {
				// ͎󂯕tȂAᑬs
				pInput->Activate(FALSE);
				pScheduler->Activate(FALSE);

				// }EX[hOFF(POPUPEBhE΍)
				if (pInput->GetMouseMode()) {
					OnMouseMode();
				}
			}
			else {
				// ͎󂯕tAʏs
				pInput->Activate(TRUE);
				pScheduler->Activate(TRUE);
			}
		}
	}

	// {NX
	CFrameWnd::OnActivate(nState, pWnd, bMinimized);
}

//---------------------------------------------------------------------------
//
//	ANeBx[gAvP[V
//
//---------------------------------------------------------------------------
#if _MFC_VER >= 0x700
void CFrmWnd::OnActivateApp(BOOL bActive, DWORD dwThreadID)
#else
void CFrmWnd::OnActivateApp(BOOL bActive, HTASK hTask)
#endif
{
	// ς݂Ȃ
	if (m_nStatus == 0) {
		// tXN[p
		if (m_bFullScreen) {
			if (bActive) {
				// ꂩANeBuɂȂ
				HideTaskBar(TRUE, TRUE);
				RecalcStatusView();
			}
			else {
				// ANeBuOꂽ
				HideTaskBar(FALSE, FALSE);
			}
		}
	}

	// {NX
#if _MFC_VER >= 0x700
	CFrameWnd::OnActivateApp(bActive, dwThreadID);
#else
	CFrameWnd::OnActivateApp(bActive, hTask);
#endif
}

//---------------------------------------------------------------------------
//
//	j[[vJn
//
//---------------------------------------------------------------------------
void CFrmWnd::OnEnterMenuLoop(BOOL bTrackPopup)
{
	CInput *pInput;
	CScheduler *pScheduler;

	// LvVZbg
	ResetCaption();

	::LockVM();

	// Cvbg֒ʒm
	pInput = GetInput();
	if (pInput) {
		pInput->Menu(TRUE);
	}

	// }EX[hFALSE(}EXŃj[ł悤)
	if (pInput->GetMouseMode()) {
		OnMouseMode();
	}

	// XPW[֒ʒm
	pScheduler = GetScheduler();
	if (pScheduler) {
		pScheduler->Menu(TRUE);
	}

	::UnlockVM();

	// {NX
	CFrameWnd::OnEnterMenuLoop(bTrackPopup);
}

//---------------------------------------------------------------------------
//
//	j[[vI
//
//---------------------------------------------------------------------------
void CFrmWnd::OnExitMenuLoop(BOOL bTrackPopup)
{
	CInput *pInput;
	CScheduler *pScheduler;

	::LockVM();

	// Cvbg֒ʒm
	pInput = GetInput();
	if (pInput) {
		pInput->Menu(FALSE);
	}

	// XPW[֒ʒm
	pScheduler = GetScheduler();
	if (pScheduler) {
		pScheduler->Menu(FALSE);
	}

	::UnlockVM();

	// LvVZbg
	ResetCaption();

	// {NX
	CFrameWnd::OnExitMenuLoop(bTrackPopup);
}

//---------------------------------------------------------------------------
//
//	eEBhEʒm
//
//---------------------------------------------------------------------------
void CFrmWnd::OnParentNotify(UINT message, LPARAM lParam)
{
	CInput *pInput;

	// CInput擾Aʒm
	if ((message == WM_MBUTTONDOWN) && (m_nStatus == 0)) {
		// Cvbg擾
		pInput = GetInput();
		if (pInput) {
			// }EXȂLɂBt͂Ȃ
			if (!pInput->GetMouseMode()) {
				// ݒ"{^֎~"ɂĂȂƂ
				if (m_bMouseMid) {
					OnMouseMode();
				}
			}
		}
	}

	// {NX
	CFrameWnd::OnParentNotify(message, lParam);
}

//---------------------------------------------------------------------------
//
//	ReLXgj[
//
//---------------------------------------------------------------------------
void CFrmWnd::OnContextMenu(CWnd * /*pWnd*/, CPoint pos)
{
	CMenu *pMenu;
	SHORT sF10;
	SHORT sShift;

	// L[{[h̓͂̂Ƃ
	if ((pos.x == -1) && (pos.y == -1)) {
		// XPW[`FbNA̓`FbN
		if (GetScheduler()->IsEnable()) {
			if (GetInput()->IsActive() && !GetInput()->IsMenu()) {
				// DIK_APPS}bvĂ邩
				if (GetInput()->IsKeyMapped(DIK_APPS)) {
					// SHIFT+F10Ă邩
					sF10 = ::GetAsyncKeyState(VK_F10);
					sShift = ::GetAsyncKeyState(VK_SHIFT);
					if (((sF10 & 0x8000) == 0) || ((sShift & 0x8000) == 0)) {
						// VK_APPSꂽ߂Ɣ
						return;
					}
				}
			}
		}

		// }EX[hł΁A(L[{[h̃j[N)
		if (GetInput()->GetMouseMode()) {
			OnMouseMode();
		}
	}
	else {
		// }EX[hł΁A(}EX̃j[N)
		if (GetInput()->GetMouseMode()) {
			return;
		}
	}

	// |bvAbvj[
	m_bPopupMenu = TRUE;
	pMenu = m_PopupMenu.GetSubMenu(0);
	pMenu->TrackPopupMenu(TPM_CENTERALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
							pos.x, pos.y, this, 0);
	m_bPopupMenu = FALSE;
}

//---------------------------------------------------------------------------
//
//	d͕ύXʒm
//
//---------------------------------------------------------------------------
LONG CFrmWnd::OnPowerBroadCast(UINT /*uParam*/, LONG /*lParam*/)
{
	// ς݂Ȃ
	if (m_nStatus == 0) {
		// VMbNAԍĐݒ
		::LockVM();
		timeEndPeriod(1);
		timeBeginPeriod(1);
		::UnlockVM();
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	VXeR}h
//
//---------------------------------------------------------------------------
void CFrmWnd::OnSysCommand(UINT nID, LPARAM lParam)
{
	// WEBhEʒuT|[g
	if ((nID & 0xfff0) == IDM_STDWIN) {
		InitPos(TRUE);
		return;
	}

	// ő剻̓tXN[
	if ((nID & 0xfff0) == SC_MAXIMIZE) {
		if (!m_bFullScreen) {
			PostMessage(WM_COMMAND, IDM_FULLSCREEN);
		}
		return;
	}

	// {NX
	CFrameWnd::OnSysCommand(nID, lParam);
}

//---------------------------------------------------------------------------
//
//	f[^]
//
//---------------------------------------------------------------------------
#if _MFC_VER >= 0x700
afx_msg BOOL CFrmWnd::OnCopyData(CWnd* /*pWnd*/, COPYDATASTRUCT* pCopyDataStruct)
#else
LONG CFrmWnd::OnCopyData(UINT /*uParam*/, LONG pCopyDataStruct)
#endif
{
	PCOPYDATASTRUCT pCDS;

	// p[^󂯎
	pCDS = (PCOPYDATASTRUCT)pCopyDataStruct;

	// R}hC
	InitCmd((LPSTR)pCDS->lpData);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	VFʒm
//
//---------------------------------------------------------------------------
LRESULT CFrmWnd::OnShellNotify(UINT uParam, LONG lParam)
{
	HANDLE hMemoryMap;
	DWORD dwProcessId;
	LPITEMIDLIST *pidls;
	HANDLE hLock;
	LONG nEvent;
	TCHAR szPath[_MAX_PATH];
	CHost *pHost;

	// Windows NT
	if (::IsWinNT()) {
		// Windows2000/XP̏ꍇASHChangeNotification_LockŃbN(ԐڌĂяo)
		hMemoryMap = (HANDLE)uParam;
		dwProcessId = (DWORD)lParam;
		hLock = ::ShellChangeNotification_Lock(hMemoryMap, dwProcessId, &pidls, &nEvent);
	}
	else {
		// Windows9x̏ꍇApidlsnEventuParam,lParam璼ړ
		pidls = (LPITEMIDLIST*)uParam;
		nEvent = lParam;
		hLock = NULL;
	}

	// sŁACHost΁Aʒm
	if (m_nStatus == 0) {
		pHost = GetHost();

#if 1
		// Windrv܂ŝ߁AۂEnableɂĂȂꍇ͉Ȃ(version2.04)
		{
			Config config;
			GetConfig()->GetConfig(&config);
			if ((config.windrv_enable <= 0) || (config.windrv_enable > 3)) {
				pHost = NULL;
			}
		}
#endif

		if (pHost) {
			// pX擾
			::SHGetPathFromIDList(pidls[0], szPath);

			// ʒm
			pHost->ShellNotify(nEvent, szPath);
		}
	}

	// NT̏ꍇASHCnangeNotifcation_UnlockŃAbN(ԐڌĂяo)
	if (::IsWinNT()) {
		::ShellChangeNotification_Unlock(hLock);
	}

	return 0;
}

//---------------------------------------------------------------------------
//
//	XV(s)
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::UpdateExec()
{
	ASSERT(this);
	ASSERT_VALID(this);

	// XPW[LȂAsJE^グ(Z[uɃNA)
	if (GetScheduler()->IsEnable()) {
		m_dwExec++;
		if (m_dwExec == 0) {
			m_dwExec--;
		}
	}
}

//---------------------------------------------------------------------------
//
//	bZ[W
//
//---------------------------------------------------------------------------
void CFrmWnd::GetMessageString(UINT nID, CString& rMessage) const
{
	Filepath path;
	TCHAR szPath[_MAX_PATH];
	TCHAR szName[60];
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];
	TCHAR szFile[_MAX_FNAME];
	TCHAR szExt[_MAX_EXT];
	int nMRU;
	int nDisk;
	BOOL bValid;
	CInfo *pInfo;

	// tOFALSE
	bValid = FALSE;

	// j[ɍs(p+MRUl)
	if ((nID >= IDM_OPEN) && (nID <= IDM_ABOUT)) {
		// p
		if (!::IsJapanese()) {
			// +5000Ŏ
			if (rMessage.LoadString(nID + 5000)) {
				bValid = TRUE;
			}
		}
	}

	// j[(IDM_STDWIN)
	if (nID == IDM_STDWIN) {
		// p
		if (!::IsJapanese()) {
			// +5000Ŏ
			if (rMessage.LoadString(nID + 5000)) {
				bValid = TRUE;
			}
		}
	}

	// MRU0
	if ((nID >= IDM_D0_MRU0) && (nID <= IDM_D0_MRU8)) {
		nMRU = nID - IDM_D0_MRU0;
		ASSERT((nMRU >= 0) && (nMRU <= 8));
		GetConfig()->GetMRUFile(0, nMRU, szPath);
		szPath[60] = _T('\0');
		rMessage = szPath;
		bValid = TRUE;
	}

	// MRU1
	if ((nID >= IDM_D1_MRU0) && (nID <= IDM_D1_MRU8)) {
		nMRU = nID - IDM_D1_MRU0;
		ASSERT((nMRU >= 0) && (nMRU <= 8));
		GetConfig()->GetMRUFile(1, nMRU, szPath);
		szPath[60] = _T('\0');
		rMessage = szPath;
		bValid = TRUE;
	}

	// MRU2
	if ((nID >= IDM_MO_MRU0) && (nID <= IDM_MO_MRU8)) {
		nMRU = nID - IDM_MO_MRU0;
		ASSERT((nMRU >= 0) && (nMRU <= 8));
		GetConfig()->GetMRUFile(2, nMRU, szPath);
		szPath[60] = _T('\0');
		rMessage = szPath;
		bValid = TRUE;
	}

	// MRU3
	if ((nID >= IDM_CD_MRU0) && (nID <= IDM_CD_MRU8)) {
		nMRU = nID - IDM_CD_MRU0;
		ASSERT((nMRU >= 0) && (nMRU <= 8));
		GetConfig()->GetMRUFile(3, nMRU, szPath);
		szPath[60] = _T('\0');
		rMessage = szPath;
		bValid = TRUE;
	}

	// MRU4
	if ((nID >= IDM_XM6_MRU0) && (nID <= IDM_XM6_MRU8)) {
		nMRU = nID - IDM_XM6_MRU0;
		ASSERT((nMRU >= 0) && (nMRU <= 8));
		GetConfig()->GetMRUFile(4, nMRU, szPath);
		szPath[60] = _T('\0');
		rMessage = szPath;
		bValid = TRUE;
	}

	// fBXN0
	if ((nID >= IDM_D0_MEDIA0) && (nID <= IDM_D0_MEDIAF)) {
		nDisk = nID - IDM_D0_MEDIA0;
		ASSERT((nDisk >= 0) && (nDisk <= 15));
		::LockVM();
		m_pFDD->GetName(0, szName, nDisk);
		m_pFDD->GetPath(0, path);
		::UnlockVM();
		_tsplitpath(path.GetPath(), szDrive, szDir, szFile, szExt);
		rMessage = szName;
		rMessage += _T(" (");
		rMessage += szFile;
		rMessage += szExt;
		rMessage += _T(")");
		bValid = TRUE;
	}

	// fBXN1
	if ((nID >= IDM_D1_MEDIA0) && (nID <= IDM_D1_MEDIAF)) {
		nDisk = nID - IDM_D1_MEDIA0;
		ASSERT((nDisk >= 0) && (nDisk <= 15));
		::LockVM();
		m_pFDD->GetName(1, szName, nDisk);
		m_pFDD->GetPath(1, path);
		::UnlockVM();
		_tsplitpath(path.GetPath(), szDrive, szDir, szFile, szExt);
		rMessage = szName;
		rMessage += _T(" (");
		rMessage += szFile;
		rMessage += szExt;
		rMessage += _T(")");
		bValid = TRUE;
	}

	// ܂łŊm肵ĂȂ΁A{NX
	if (!bValid) {
		CFrameWnd::GetMessageString(nID, rMessage);
	}

	// ʂInfo֒(ێp)
	pInfo = GetInfo();
	if (pInfo) {
		pInfo->SetMessageString(rMessage);
	}

	// ʂXe[^Xr[֒
	if (m_pStatusView) {
		m_pStatusView->SetMenuString(rMessage);
	}
}

//---------------------------------------------------------------------------
//
//	^XNo[B
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::HideTaskBar(BOOL bHide, BOOL bFore)
{
	if (bHide) {
		// "ɑO"
		m_hTaskBar = ::FindWindow(_T("Shell_TrayWnd"), NULL);
		if (m_hTaskBar) {
			::ShowWindow(m_hTaskBar, SW_HIDE);
		}
		ModifyStyleEx(0, WS_EX_TOPMOST, 0);
	}
	else {
		// "ʏ"
		ModifyStyleEx(WS_EX_TOPMOST, 0, 0);
		if (m_hTaskBar) {
			::ShowWindow(m_hTaskBar, SW_SHOWNA);
		}
	}

	// OʃIvV
	if (bFore) {
		SetForegroundWindow();
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^Xo[\
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::ShowStatus()
{
	ASSERT(this);

	// KvȂVMbN
	if (m_nStatus == 0) {
		::LockVM();
	}

	// tXN[
	if (m_bFullScreen) {
		// Xe[^Xo[͏ɔ\
		ShowControlBar(&m_StatusBar, FALSE, FALSE);

		// Xe[^Xo[\
		if (m_bStatusBar) {
			// Xe[^Xr[݂Ȃ
			if (!m_pStatusView) {
				// 쐬
				CreateStatusView();

				// Ĕzu
				if (m_bStatusBar) {
					RecalcStatusView();
				}
			}
		}
		else {
			// Xe[^Xr[݂Ă
			if (m_pStatusView) {
				// 폜
				DestroyStatusView();

				// Ĕzu
				RecalcStatusView();
			}
		}

		// Kv΃AbN
		if (m_nStatus == 0) {
			::UnlockVM();
		}
		return;
	}

	// Xe[^Xr[̓tXN[pȂ̂ŁA폜
	if (m_pStatusView) {
		DestroyStatusView();
		RecalcLayout();
	}

	// EBhEȂ̂ŁAShowControlBarŐ
	ShowControlBar(&m_StatusBar, m_bStatusBar, FALSE);

	// Kv΃AbN
	if (m_nStatus == 0) {
		::UnlockVM();
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^Xr[쐬(tXN[)
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::CreateStatusView()
{
	CInfo *pInfo;

	ASSERT(!m_pStatusView);

	if (m_bStatusBar) {
		// Xe[^Xr[쐬(Ĕzu͍sȂ)
		m_pStatusView = new CStatusView;
		if (m_pStatusView->Init(this)) {
			// 쐬
			pInfo = GetInfo();
			if (pInfo) {
				// Infô݂ŁAXe[^Xr[쐬ʒm
				pInfo->SetStatusView(m_pStatusView);
			}
		}
		else {
			// 쐬s
			m_bStatusBar = FALSE;
		}
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^Xr[I(tXN[)
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::DestroyStatusView()
{
	CInfo *pInfo;

	// LȃXe[^Xr[݂ꍇ̂
	if (m_pStatusView) {
		// Info擾
		pInfo = GetInfo();
		if (pInfo) {
			// Infô݂ŁAXe[^Xr[폜ʒm
			pInfo->SetStatusView(NULL);
		}

		// Xe[^Xr[폜(Ĕzu͍sȂ)
		m_pStatusView->DestroyWindow();
		m_pStatusView = NULL;
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^Xr[Ĕzu
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::RecalcStatusView()
{
	CRect rectFrame;
	CRect rectDraw;
	CRect rectStatus;
	LONG lDraw;
	LONG lStatus;
	BOOL bMove;

	// t[̃TCY擾
	GetClientRect(&rectFrame);

	// Xe[^Xr[̗Lŕ
	if (m_pStatusView) {
		// Xe[^Xr[BXe[^Xr[̈ʒuD
		m_pStatusView->GetWindowRect(&rectStatus);
		lStatus = rectStatus.Height();
		lDraw = rectFrame.Height() - lStatus;

		// Drawr[̈ʒu擾
		m_pDrawView->GetWindowRect(&rectDraw);
		ScreenToClient(&rectDraw);

		// ύX`FbN
		bMove = FALSE;
		if ((rectDraw.left != 0) || (rectDraw.top != 0)) {
			bMove = TRUE;
		}
		if ((rectDraw.Width () != rectFrame.Width()) || (rectDraw.Height() != lDraw)) {
			bMove = TRUE;
		}
		if (bMove) {
			m_pDrawView->SetWindowPos(&wndTop, 0, 0, rectFrame.Width(), lDraw, SWP_NOZORDER);
		}

		// Statusr[̈ʒu擾
		m_pStatusView->GetWindowRect(&rectStatus);
		ScreenToClient(&rectStatus);

		// ύX`FbN
		bMove = FALSE;
		if ((rectStatus.left != 0) || (rectStatus.top != lDraw)) {
			bMove = TRUE;
		}
		if ((rectStatus.Width() != rectFrame.Width()) || (rectStatus.Height() != lStatus)) {
			bMove = TRUE;
		}
		if (bMove) {
			m_pStatusView->SetWindowPos(&wndTop, 0, lDraw, rectFrame.Width(), lStatus, SWP_NOZORDER);
		}
	}
	else {
		// Xe[^Xr[ȂBDrawr[̂
		m_pDrawView->GetWindowRect(&rectDraw);
		ScreenToClient(&rectDraw);

		// ύX`FbN
		bMove = FALSE;
		if ((rectDraw.left != 0) || (rectDraw.top != 0)) {
			bMove = TRUE;
		}
		if ((rectDraw.Width () != rectFrame.Width()) || (rectDraw.Height() != rectFrame.Height())) {
			bMove = TRUE;
		}
		if (bMove) {
			m_pDrawView->SetWindowPos(&wndTop, 0, 0, rectFrame.Width(), rectFrame.Height(), SWP_NOZORDER);
		}
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^Xo[Zbg
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::ResetStatus()
{
	CInfo *pInfo;

	// Info΃Zbg
	pInfo = GetInfo();
	if (pInfo) {
		pInfo->ResetStatus();
	}
}

//---------------------------------------------------------------------------
//
//	I[i[h[
//
//---------------------------------------------------------------------------
void CFrmWnd::OnDrawItem(int nID, LPDRAWITEMSTRUCT lpDIS)
{
	int nPane;
	HDC hDC;
	CRect rectDraw;
	CInfo *pInfo;

	// EBhEnh̃`FbN
	if (lpDIS->hwndItem != m_StatusBar.m_hWnd) {
		CFrameWnd::OnDrawItem(nID, lpDIS);
		return;
	}

	// ʁADCA`擾
	nPane = lpDIS->itemID;
	if (nPane == 0) {
		return;
	}
	nPane--;
	hDC = lpDIS->hDC;
	rectDraw = &lpDIS->rcItem;

	// Infõ`FbN
	pInfo = GetInfo();
	if (!pInfo) {
		// œhԂ
		::SetBkColor(hDC, RGB(0, 0, 0));
		::ExtTextOut(hDC, 0, 0, ETO_OPAQUE, &rectDraw, NULL, 0, NULL);
		return;
	}

	// InfoɎw
	pInfo->DrawStatus(nPane, hDC, rectDraw);
}

//---------------------------------------------------------------------------
//
//	j[o[\
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::ShowMenu()
{
	HMENU hMenu;

	ASSERT(this);

	// KvłVMbN
	if (m_nStatus == 0) {
		::LockVM();
	}

	// ݂̃j[擾
	hMenu = ::GetMenu(m_hWnd);

	// j[sKvȏꍇ
	if (m_bFullScreen || !m_bMenuBar) {
		// j[݂邩
		if (hMenu != NULL) {
			// j[
			SetMenu(NULL);
		}
		if (m_nStatus == 0) {
			::UnlockVM();
		}
		return;
	}

	// j[Kvȏꍇ
	if (hMenu != NULL) {
		// Zbgj[Ɠ
		if (m_Menu.GetSafeHmenu() == hMenu) {
			// ύX̕Kv͂Ȃ
			if (m_nStatus == 0) {
				::UnlockVM();
			}
			return;
		}
	}

	// j[Zbg
	SetMenu(&m_Menu);

	// KvȂVMAbN
	if (m_nStatus == 0) {
		::UnlockVM();
	}
}

//---------------------------------------------------------------------------
//
//	LvV\
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::ShowCaption()
{
	DWORD dwStyle;

	ASSERT(this);

	// KvłVMbN
	if (m_nStatus == 0) {
		::LockVM();
	}

	// ݂̃LvVԂ擾
	dwStyle = GetStyle() & WS_CAPTION;

	// LvVsKvȏꍇ
	if (m_bFullScreen || !m_bCaption) {
		// LvV݂邩
		if (dwStyle) {
			// LvV
			ModifyStyle(WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
							0, SWP_NOMOVE | SWP_NOZORDER | SWP_FRAMECHANGED);
		}
		if (m_nStatus == 0) {
			::UnlockVM();
		}
		return;
	}

	// LvVKvȏꍇ
	if (!dwStyle) {
		// LvVZbg
		ModifyStyle(0, WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
							SWP_NOMOVE | SWP_NOZORDER | SWP_FRAMECHANGED);
	}

	// KvȂVMAbN
	if (m_nStatus == 0) {
		::UnlockVM();
	}
}

//---------------------------------------------------------------------------
//
//	LvVZbg
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::ResetCaption()
{
	CInfo *pInfo;

	// Info΃Zbg
	pInfo = GetInfo();
	if (pInfo) {
		pInfo->ResetCaption();
	}
}

//---------------------------------------------------------------------------
//
//	ݒ
//
//---------------------------------------------------------------------------
void FASTCALL CFrmWnd::SetInfo(CString& strInfo)
{
	CInfo *pInfo;

	// Infoΐݒ
	pInfo = GetInfo();
	if (pInfo) {
		pInfo->SetInfo(strInfo);
	}
}

//---------------------------------------------------------------------------
//
//	`r[擾
//
//---------------------------------------------------------------------------
CDrawView* FASTCALL CFrmWnd::GetView() const
{
	ASSERT(this);
	ASSERT(m_pDrawView);
	ASSERT(m_pDrawView->m_hWnd);
	return m_pDrawView;
}

//---------------------------------------------------------------------------
//
//	ŏ̃R|[lg擾
//
//---------------------------------------------------------------------------
CComponent* FASTCALL CFrmWnd::GetFirstComponent() const
{
	ASSERT(this);
	return m_pFirstComponent;
}

//---------------------------------------------------------------------------
//
//	XPW[擾
//
//---------------------------------------------------------------------------
CScheduler* FASTCALL CFrmWnd::GetScheduler() const
{
	ASSERT(this);
	ASSERT(m_pSch);
	return m_pSch;
}

//---------------------------------------------------------------------------
//
//	TEh擾
//
//---------------------------------------------------------------------------
CSound* FASTCALL CFrmWnd::GetSound() const
{
	ASSERT(this);
	ASSERT(m_pSound);
	return m_pSound;
}

//---------------------------------------------------------------------------
//
//	Cvbg擾
//
//---------------------------------------------------------------------------
CInput* FASTCALL CFrmWnd::GetInput() const
{
	ASSERT(this);
	ASSERT(m_pInput);
	return m_pInput;
}

//---------------------------------------------------------------------------
//
//	|[g擾
//
//---------------------------------------------------------------------------
CPort* FASTCALL CFrmWnd::GetPort() const
{
	ASSERT(this);
	ASSERT(m_pPort);
	return m_pPort;
}

//---------------------------------------------------------------------------
//
//	MIDI擾
//
//---------------------------------------------------------------------------
CMIDI* FASTCALL CFrmWnd::GetMIDI() const
{
	ASSERT(this);
	ASSERT(m_pMIDI);
	return m_pMIDI;
}

//---------------------------------------------------------------------------
//
//	TrueKey擾
//
//---------------------------------------------------------------------------
CTKey* FASTCALL CFrmWnd::GetTKey() const
{
	ASSERT(this);
	ASSERT(m_pTKey);
	return m_pTKey;
}

//---------------------------------------------------------------------------
//
//	Host擾
//
//---------------------------------------------------------------------------
CHost* FASTCALL CFrmWnd::GetHost() const
{
	ASSERT(this);
	ASSERT(m_pHost);
	return m_pHost;
}

//---------------------------------------------------------------------------
//
//	Info擾
//
//---------------------------------------------------------------------------
CInfo* FASTCALL CFrmWnd::GetInfo() const
{
	ASSERT(this);

	// Info݂ȂNULL
	if (!m_pInfo) {
		return NULL;
	}

	// ~ȂNULL
	if (!m_pInfo->IsEnable()) {
		return NULL;
	}

	// 쒆BInfoԂ
	return m_pInfo;
}

//---------------------------------------------------------------------------
//
//	RtBO擾
//
//---------------------------------------------------------------------------
CConfig* FASTCALL CFrmWnd::GetConfig() const
{
	ASSERT(this);
	ASSERT(m_pConfig);
	return m_pConfig;
}

#endif	// _WIN32
