//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	Modified (C) 2006 co (cogoodgmail.com)
//	[ MFC Host ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "windrv.h"
#include "memory.h"
#include "mfc_com.h"
#include "mfc_cfg.h"
#include "mfc_host.h"

#include <shlobj.h>
#include <winioctl.h>

//===========================================================================
//
//	Windowst@ChCu
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CWinFileDrv::CWinFileDrv()
{
	// 
	m_bWriteProtect = FALSE;
	m_bSlow = FALSE;
	m_bRemovable = FALSE;
	m_bManual = FALSE;
	m_bEnable = FALSE;
	m_bDevice = FALSE;
	m_hDevice = INVALID_HANDLE_VALUE;
	m_szDevice[0] = _T('\0');
	m_szDrive[0] = _T('\0');
	memset(&m_capCache, 0, sizeof(m_capCache));
	m_bVolumeCache = FALSE;
	m_szVolumeCache[0] = _T('\0');
	m_nUpdate = 0;
	m_bUpdateFile = FALSE;
	m_nUpdateFile = 0;
#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	m_nUpdateMedia = 0;
#endif // XM6_HOST_UPDATE_BY_SEQUENCE
#ifdef XM6_HOST_UPDATE_BY_FREQUENCY
	m_nUpdateCount = 0;
	memset(m_nUpdateBuffer, 0, sizeof(m_nUpdateBuffer));
#endif // XM6_HOST_UPDATE_BY_FREQUENCY
	m_szBase[0] = _T('\0');
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
CWinFileDrv::~CWinFileDrv()
{
#ifdef XM6_HOST_KEEP_OPEN_ERROR
	// foCXN[Y
	CloseDevice();
#endif // XM6_HOST_KEEP_OPEN_ERROR
}

//---------------------------------------------------------------------------
//
//	foCXI[v
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::OpenDevice()
{
	ASSERT(this);
	ASSERT(m_hDevice == INVALID_HANDLE_VALUE);

	m_hDevice = ::CreateFile(
		m_szDevice,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_DELETE | FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL);
}

//---------------------------------------------------------------------------
//
//	foCXN[Y
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::CloseDevice()
{
	ASSERT(this);

	if (m_hDevice != INVALID_HANDLE_VALUE) {
		CloseHandle(m_hDevice);
		m_hDevice = INVALID_HANDLE_VALUE;
	}
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::Init(LPCTSTR szBase, DWORD nFlag)
{
	ASSERT(this);
	ASSERT(szBase);
	ASSERT(_tcslen(szBase) < _MAX_PATH);
	ASSERT(m_bWriteProtect == FALSE);
	ASSERT(m_bSlow == FALSE);
	ASSERT(m_bRemovable == FALSE);
	ASSERT(m_bManual == FALSE);
	ASSERT(m_bEnable == FALSE);
	ASSERT(m_bDevice == FALSE);
	ASSERT(m_hDevice == INVALID_HANDLE_VALUE);
	ASSERT(m_szDevice[0] == _T('\0'));
	ASSERT(m_szDrive[0] == _T('\0'));
	ASSERT(m_capCache.sectors == 0);
	ASSERT(m_bVolumeCache == FALSE);
	ASSERT(m_szVolumeCache[0] == _T('\0'));
	ASSERT(m_nUpdate == 0);
	ASSERT(m_bUpdateFile == FALSE);
	ASSERT(m_nUpdateFile == 0);
#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	ASSERT(m_nUpdateMedia == 0);
#endif // XM6_HOST_UPDATE_BY_SEQUENCE
#ifdef XM6_HOST_UPDATE_BY_FREQUENCY
	ASSERT(m_nUpdateCount == 0);
	ASSERT(m_szBase[0] == _T('\0'));
#endif // XM6_HOST_UPDATE_BY_FREQUENCY

	// p[^󂯎
	if (nFlag & FSFLAG_WRITE_PROTECT) m_bWriteProtect = TRUE;
	if (nFlag & FSFLAG_SLOW) m_bSlow = TRUE;
	if (nFlag & FSFLAG_REMOVABLE) m_bRemovable = TRUE;
	if (nFlag & FSFLAG_MANUAL) m_bManual = TRUE;
	_tcscpy(m_szBase, szBase);

	// x[XpX̍Ō̃pX؂}[N폜
	// WARNING: Unicodep͏CKv
	TCHAR* pClear = NULL;
	TCHAR* p = m_szBase;
	for (;;) {
		TCHAR c = *p;
		if (c == _T('\0')) break;
		if (c == '/' || c== '\\') {
			pClear = p;
		} else {
			pClear = NULL;
		}
		if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
			p++;
			if (*p == _T('\0')) break;
		}
		p++;
	}
	if (pClear) *pClear = _T('\0');

	// hCul
	DWORD n = m_szBase[0] & 0xDF;
	if (n < 'A' || 'Z' < n || m_szBase[1] != ':') {
		// hCusȂlbg[NhCuUNCƂĈ
		m_bSlow = TRUE;
		CheckMedia();
		return;
	}

	// hCu
	_stprintf(m_szDrive, _T("%c:\\"), n);

	// hCuނ̔
	DWORD nResult = ::GetDriveType(m_szDrive);
	switch (nResult) {
	case DRIVE_REMOVABLE:
	{
		m_bSlow = TRUE;
		m_bRemovable = TRUE;

		// tbs[fBXN
		SHFILEINFO shfi;
		nResult = ::SHGetFileInfo(m_szDrive, 0, &shfi, sizeof(shfi), SHGFI_TYPENAME);
		if (nResult) {
			if (_tcsstr(shfi.szTypeName, _T("tbs[")) != NULL ||
				_tcsstr(shfi.szTypeName, _T("Floppy")) != NULL)
				m_bManual = TRUE;
		}
		break;
	}

	case DRIVE_CDROM:
		m_bSlow = TRUE;
		m_bRemovable = TRUE;
		break;

	case DRIVE_FIXED:
	case DRIVE_RAMDISK:
		break;

	default:
		m_bSlow = TRUE;
		break;
	}

	// foCXI[vpUNC
	OSVERSIONINFO v;
	memset(&v, 0, sizeof(v));
	v.dwOSVersionInfoSize = sizeof(v);
	::GetVersionEx(&v);
	if (v.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		m_bDevice = TRUE;
		_stprintf(m_szDevice, _T("\\\\.\\%c:"), n);
	}

#ifdef XM6_HOST_KEEP_OPEN_ERROR
	// I[v/N[Yƒx̂ŁAI[v܂܎g
	// ĝɂȂȂB
	// ŃI[vꍇAŏhCuɃfBAĂ
	// Ήx}EroĂȂAŏhCuɃfB
	// AĂȂꍇÃnh܂Windows
	// fBA}FȂȂĂ܂B

	// foCXI[v
	OpenDevice();
#endif // XM6_HOST_KEEP_OPEN_ERROR

	// fBAL`FbN
	if (m_bManual == FALSE) CheckMedia();
}

//---------------------------------------------------------------------------
//
//	hCuԂ̎擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWinFileDrv::GetStatus() const
{
	ASSERT(this);

	return
		(m_bRemovable ? 0 : 0x40) |
		(m_bEnable ? (m_bWriteProtect ? 0x08 : 0) | 0x02 : 0);
}

//---------------------------------------------------------------------------
//
//	fBAԐݒ
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::SetEnable(BOOL bEnable)
{
	ASSERT(this);

	m_bEnable = bEnable;

	// fBAĂȂ΃LbV
	if (bEnable == FALSE) {
		memset(&m_capCache, 0, sizeof(m_capCache));
		m_bVolumeCache = FALSE;
		m_szVolumeCache[0] = _T('\0');
	}
}

//---------------------------------------------------------------------------
//
//	[oufBÃt@CLbVLԂXV
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::SetTimeout()
{
	ASSERT(this);

	// [oufBAłȂΑI
	if (m_bRemovable == FALSE) return;

	// LԂXV
	m_bUpdateFile = TRUE;
	m_nUpdateFile = ::GetTickCount();
}

//---------------------------------------------------------------------------
//
//	[oufBÃt@CLbVLԂmF
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::CheckTimeout()
{
	ASSERT(this);

	// [oufBAłȂΑI
	if (m_bRemovable == FALSE) return FALSE;

	// ^CAEgmF
	DWORD nCount = ::GetTickCount();
	DWORD nDelta = nCount - m_nUpdateFile;
	if (nDelta < XM6_HOST_REMOVABLE_CACHE_TIME) return FALSE;	// XVsv

	if (m_bUpdateFile == FALSE) return FALSE;	// ɍXVς
	m_bUpdateFile = FALSE;

	return TRUE;	// XVZ
}

#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
//---------------------------------------------------------------------------
//
//	[oufBȀԍXVLɂ
//
//	R}h$41(fBNg`FbN)̒̃R}h$57(fBA
//	`FbN)ŃfBA}`FbNs邽߁AXe[gϐ
//	ǗsȂB
//
//	OƂāAR}h$57(fBA`FbN)̌ʂG[
//	̏ꍇ́A̒ɕKHuman68kR}h$41(fBNg`Fb
//	N)Ăт߁A̒̃fBA`FbNł͉s
//	Ȃ悤ɂB
//
//	₱Ǐ̗͈ȉ̂悤ȊB
//	R}h$57 - fBA`FbN fBAȂ  SetMediaUpdate(TRUE) S2
//	$41 - fBNg`FbN S2 SetMediaUpdate(FALSE) Disableԉ S0
//	R}h$57 - fBA`FbN S0 Ȃ fBAȂ  SetMediaUpdate(TRUE) S2
//	$41 - fBNg`FbN S2 SetMediaUpdate(FALSE) Disableԉ S0
//	R}h$41 - fBNg`FbN S0 SetMediaUpdate(FALSE) EnableԐݒ S1
//	R}h$57 - fBA`FbN S1 `FbNs fBAȂ  SetMediaUpdate(TRUE) S2
//	$41 - fBNg`FbN S2 SetMediaUpdate(FALSE) Disableԉ S0
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::SetMediaUpdate(BOOL bDisable)
{
	ASSERT(this);
	if (bDisable) {
		m_nUpdateMedia = 2;
	} else {
		if (m_nUpdateMedia > 1) {
			m_nUpdateMedia = 0;
		} else {
			m_nUpdateMedia = 1;
		}
	}
}
#endif // XM6_HOST_UPDATE_BY_SEQUENCE

//---------------------------------------------------------------------------
//
//	[oufBȀԍXV`FbN
//
//	蓮CWFNg̃fBAɂāAZԓɘACheckMedia
//	ĂяoꂽꍇAANZXO`FbNɈڍsB
//
//	mint Ȃǂ̃fBAĎp^[͈ȉ̒ʂB
//	5000msȓCheckMedia1`2Ă΂: [oufBAĎ
//	100msȓCheckMedia12ȏĂ΂: [oufBAJ
//
//	Tv: ݂IBM-PC/AT݊@ł́AFDD̃fBȂ݂AFDD
//	̃f[^ɒڃANZX邱ƂłϑłȂB̊ϑsׂ
//	3̖肪݂B
//
//	1. ʓIAT݊@ł́AFDD̃[^[~ĂԂ̃h
//	Cuւ̃ANZX܂ŁAǂAPI𗘗pĂ1000msȏォ
//	Ă܂BX680x0ł́Amint̑\Iȃt@C[ɂāAhC
//	uύX̓xɑShCũfBA}ԂpɂɊmFĂ邽߁A
//	ϑĂ܂ƁA쑬xɒ[ɒቺA[U̎gp
//	B
//
//	2. FDD̃[^[]ĂꍇłAϑ܂ł͐10`
//	100msx̏ԂvBX680x0ł́AʏHuman68k̗p
//	ĂAfBAԂ̃`FbNpɂɍsȂ邽߁AVM
//	̎w̓xɊϑƓ쑬xቺĂ܂B
//
//	3. FDDɃfBA݂ȂꍇɊϑsȂƁAFDD
//	Ă܂B̓n[hEFA̐ł\tgEFA
//	͉łȂBAX680x0ł́A|[Oɂ胁fBA
//	݊mFsȂ̂ʓIłBVM̎wʂɊϑsׂs
//	ȂꍇAԊuFDDىtłň̎ԂA^
//	@̈ėB
//
//	ŁA蓮CWFNg^̃[oufBAɂẮAȉ
//	ŃfBÅϑsȂdlƂB
//
//	1. ۂɃzXgOSɂANZXsȂ钼OɊϑB
//	   CHostEntry::CheckMediaAccess()̃p^[1,2B
//	2. ZԂɏWăfBAϑvꍇɊϑB
//	   fBA}ołȂUSBfoCX̂ŁA̔
//	   [oufBASĂōsȂ悤ύXB
//     mint2.xxnɑΉ邽߁AԂł͂ȂfBNg
//     `FbÑfBAϑṽ^C~OōsȂ悤ύXB
//	   CHostEntry::CheckMediaAccess()̃p^[3B
//	3. L2ł̓fBAꊷƂołȂ\
//	   邽߁ALbV̗LԂ𐔕bԂɐđΏB
//	   LbVŗpĂFindFirstChangeNotification()hC
//	   ubNăCWFNgsɂȂ邽߁AZԂŊJ邱ƁB
//	   CHostEntry::isMediaOffline()CHostEntry::CheckTimeout()ŏB
//	4. AĊϑsȂȂ悤AxANZX琔bԂ̃K[
//	   hԂ݂AVMւ̓LbVnB
//
//	Ldl̂߁A蓮CWFNg^̃[oufBAɂẮA
//	fBA݂Ȃꍇ̃ANZX͐nƂ݂ȂAуG[
//	oȂƂɂB
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::CheckMediaUpdate()
{
	ASSERT(this);

	// [oufBAłȂΑI
	if (m_bRemovable == FALSE) return FALSE;

#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	// XVtO𔻒
	if (m_nUpdateMedia == 1) {
		m_nUpdateMedia = 0;
		return TRUE;	// XVZ
	}
	m_nUpdateMedia = 0;	// ŏ1ڂXV΂̂ŃtO~낷
#endif // XM6_HOST_UPDATE_BY_SEQUENCE

#ifdef XM6_HOST_UPDATE_BY_FREQUENCY
	// `FbNL^
	DWORD n = ::GetTickCount();
	DWORD nOld = m_nUpdateBuffer[m_nUpdateCount];
	m_nUpdateBuffer[m_nUpdateCount] = n;
	m_nUpdateCount++;
	m_nUpdateCount %= XM6_HOST_REMOVABLE_RELOAD_COUNT;

	// Ԃ̌Ăяo񐔂Ȃ΃LbVgp
	if (n - nOld <= XM6_HOST_REMOVABLE_RELOAD_TIME) return TRUE;	// XVZ
#endif // XM6_HOST_UPDATE_BY_FREQUENCY

#ifdef XM6_HOST_UPDATE_ALWAYS
	return TRUE;	// XVZ
#endif //XM6_HOST_UPDATE_ALWAYS

	return FALSE;	// XVsv
}

//---------------------------------------------------------------------------
//
//	[oufBÃANZXO`FbN
//
//	蓮CWFNg̃fBÁAANZX钼OɏԂmFB
//	AČĂяoꂽꍇ̓LbVgpB
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::CheckMediaAccess(BOOL bManual)
{
	ASSERT(this);

	if (bManual) {
		// 蓮CWFNgłȂΑI
		if (m_bManual == FALSE) return FALSE;
	} else {
		// [oufBAłȂΑI
		if (m_bRemovable == FALSE) return FALSE;
	}

	// AČĂяoꂽꍇ̓LbVgp
	DWORD nCount = ::GetTickCount();
	DWORD nDelta = nCount - m_nUpdate;
	if (nDelta < XM6_HOST_REMOVABLE_GUARD_TIME) return FALSE;	// XVsv
	m_nUpdate = nCount;

	return TRUE;	// XVZ
}

//---------------------------------------------------------------------------
//
//	fBAL`FbN
//
//	[oufBA}ɎsƁAOpen
//	DeviceIoControlŒ~ď\bԋAĂȂƂ̂
//	Ăяo^C~Oɒӂ邱ƁB
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::CheckMedia()
{
	ASSERT(this);

	// fBA}Ƃ݂Ȃ
	BOOL bEnable = TRUE;

	if (m_bDevice) {
		bEnable = FALSE;

		// foCXI[v
		OpenDevice();

		if (m_hDevice != INVALID_HANDLE_VALUE) {
			// Ԋl
			DWORD nSize;
			bEnable = ::DeviceIoControl(
				m_hDevice,
				IOCTL_STORAGE_CHECK_VERIFY,
				NULL,
				0,
				NULL,
				0,
				&nSize,
				NULL);
		}

		// foCXN[Y
		CloseDevice();
	}

	// fBAԔf
	SetEnable(bEnable);

	// ŏIXV
	m_nUpdate = ::GetTickCount();

	return bEnable;
}

//---------------------------------------------------------------------------
//
//	CWFNg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::Eject()
{
	ASSERT(this);

	// [oufBAłȂΑI
	if (m_bRemovable == FALSE) return FALSE;

	// ɃCWFNgς݂Ȃ瑦I
	if (m_bEnable == FALSE) return FALSE;

	// foCX䂪łȂΑI
	if (m_bDevice == FALSE) return FALSE;

	// foCXI[v
	OpenDevice();
	if (m_hDevice == INVALID_HANDLE_VALUE) return FALSE;

	// }Eg
	DWORD nSize;
	BOOL bResult = DeviceIoControl(
		m_hDevice,
		FSCTL_DISMOUNT_VOLUME,
		NULL,
		0,
		NULL,
		0,
		&nSize,
		NULL);

	// CWFNg
	bResult = ::DeviceIoControl(
		m_hDevice,
		IOCTL_STORAGE_EJECT_MEDIA,
		NULL,
		0,
		NULL,
		0,
		&nSize,
		NULL);

	// foCXN[Y
	CloseDevice();

	return bResult;
}

//---------------------------------------------------------------------------
//
//	{[x̎擾
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileDrv::GetVolume(TCHAR* szLabel)
{
	ASSERT(this);
	ASSERT(szLabel);

#if 0	// gȂWbN
	// fBAԃ`FbN
	if (m_bEnable == FALSE) {
		m_bVolumeCache = FALSE;
		m_szVolumeCache[0] = _T('\0');
		szLabel[0] = _T('\0');
		return;
	}
#endif

	// {[x̎擾
	DWORD dwMaximumComponentLength;
	DWORD dwFileSystemFlags;
	BOOL bResult = ::GetVolumeInformation(
		m_szDrive,
		m_szVolumeCache,
		sizeof(m_szVolumeCache) / sizeof(TCHAR),
		NULL,
		&dwMaximumComponentLength,
		&dwFileSystemFlags,
		NULL,
		0);
	if (bResult == 0) {
		m_bVolumeCache = FALSE;
		m_szVolumeCache[0] = _T('\0');
		szLabel[0] = _T('\0');
		return;
	}

	// LbVXV
	m_bVolumeCache = TRUE;
	_tcscpy(szLabel, m_szVolumeCache);
}

//---------------------------------------------------------------------------
//
//	LbV{[x擾
//
//	LbVĂ{[x]B
//	LbVeLȂ TRUE AȂ FALSE ԂB
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::GetVolumeCache(TCHAR* szLabel) const
{
	ASSERT(this);
	ASSERT(szLabel);

	// e]
	_tcscpy(szLabel, m_szVolumeCache);

	// fBA}ȂɃLbVeg
	if (m_bEnable == FALSE) return TRUE;

	return m_bVolumeCache;
}

//---------------------------------------------------------------------------
//
//	eʂ̎擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWinFileDrv::GetCapacity(Human68k::capacity_t* pCapacity)
{
	ASSERT(this);
	ASSERT(pCapacity);

#if 0	// gȂWbN
	// fBAԃ`FbN
	if (m_bEnable == FALSE) {
		// LbV
		memset(&m_capCache, 0, sizeof(m_capCache));
		memset(pCapacity, 0, sizeof(*pCapacity));
		return 0;
	}
#endif

	// ULARGE_INTEGER`Ŏ擾(Win95OSR2ȍ~AWinNTŃT|[gꂽAPI)
	ULARGE_INTEGER ulFree;
	ULARGE_INTEGER ulTotal;
	ULARGE_INTEGER ulTotalFree;
	BOOL bResult = ::GetDiskFreeSpaceEx(m_szDrive, &ulFree, &ulTotal, &ulTotalFree);
	if (bResult == FALSE) {
		// LbV
		memset(&m_capCache, 0, sizeof(m_capCache));
		memset(pCapacity, 0, sizeof(*pCapacity));
		return 0;
	}

	// gp\oCg(2GBŃNbv)
	DWORD nFree = 0x7FFFFFFF;
	if (ulFree.HighPart == 0 && ulFree.LowPart < 0x80000000) {
		nFree = ulFree.LowPart;
	}

	// NX^\̌vZ
	DWORD free;
	DWORD clusters;
	DWORD sectors;
	DWORD bytes;
	if (ulTotal.HighPart == 0 && ulTotal.LowPart < 0x80000000) {
		// 2GBȂGetDiskFreeSpacegĒl擾
		bResult = ::GetDiskFreeSpace(m_szDrive, &sectors, &bytes, &free, &clusters);
		if (bResult == FALSE) {	// Ô
			free = nFree;
			clusters = ulTotal.LowPart;
			sectors = 1;
			bytes = 512;
		}

		// ZN^TCY512傫p^[␳ (ƂȂÔ)
		while (bytes > 512) {
			bytes >>= 1;
			sectors <<= 1;

			free <<= 1;
		}

		// ZN^TCY256ȉ̃p^[␳ (ƂȂÔ)
		while (1 <= bytes && bytes <= 256) {
			bytes <<= 1;
			if (sectors > 1) {
				sectors >>= 1;
			} else {
				clusters >>= 1;
			}

			free >>= 1;
		}

		// NX^16rbg͈̔͂Ɏ܂Ȃp^[␳
		while (clusters >= 0x10000) {
			clusters >>= 1;
			sectors <<= 1;

			free >>= 1;
		}
	} else {
		// 2GBȏȂA512(ZN^)~128(NX^)~32768ɌŒ
		sectors = 0x80;
		clusters = 0x8000;
		bytes = 512;

		// 󂫗eʂ2GB𒴂邱Ƃ͖
		free = (WORD)(nFree >> 16);
		if (nFree & 0xFFFF) free++;
	}

	// p[^͈̓`FbN (Ô)
	ASSERT(free < 0x10000);
	ASSERT(clusters < 0x10000);
	ASSERT(sectors < 0x10000);
	ASSERT(bytes == 512);

	// Sp[^Zbg
	m_capCache.free = (WORD)free;
	m_capCache.clusters = (WORD)clusters;
	m_capCache.sectors = (WORD)sectors;
	m_capCache.bytes = 512;

	// e]
	memcpy(pCapacity, &m_capCache, sizeof(m_capCache));

	return nFree;
}

//---------------------------------------------------------------------------
//
//	LbVNX^TCY擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileDrv::GetCapacityCache(Human68k::capacity_t* pCapacity) const
{
	ASSERT(this);
	ASSERT(pCapacity);

	// e]
	memcpy(pCapacity, &m_capCache, sizeof(m_capCache));

	// fBA}ȂɃLbVeg
	if (m_bEnable == FALSE) return TRUE;

	return (m_capCache.sectors != 0);
}

//===========================================================================
//
//	fBNgGg t@C
//
//===========================================================================

DWORD CHostFilename::g_nOption;			// tO (t@Cϊ֘A)

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CHostFilename::CHostFilename()
{
	m_pszWin32 = NULL;
	m_bCorrect = FALSE;
	m_szHuman[0] = '\0';
	// memset(&m_dirEntry, 0, sizeof(m_dirEntry));		// oOv͕sv
	m_pszHumanLast = m_szHuman;
	m_pszHumanExt = m_szHuman;
	m_pEntry = NULL;
	m_pChild = NULL;
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
CHostFilename::~CHostFilename()
{
	FreeWin32();
	DeleteCache();
}

//---------------------------------------------------------------------------
//
//	Win32̖̂̐ݒ
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilename::SetWin32(const TCHAR* szWin32)
{
	ASSERT(this);
	ASSERT(szWin32);
	ASSERT(_tcslen(szWin32) < _MAX_PATH);
	ASSERT(m_pszWin32 == NULL);

	// Win32̃Rs[
	m_pszWin32 = (TCHAR*)malloc(_tcslen(szWin32) + 1);
	ASSERT(m_pszWin32);
	_tcscpy(m_pszWin32, szWin32);
}

//---------------------------------------------------------------------------
//
//	Human68k̃t@CvfRs[
//
//---------------------------------------------------------------------------
BYTE* FASTCALL CHostFilename::CopyName(BYTE* pWrite, const BYTE* pFirst, const BYTE* pLast)
{
	ASSERT(this);
	ASSERT(pWrite);
	ASSERT(pFirst);
	ASSERT(pLast);

	for (const BYTE* p = pFirst; p < pLast; p++) {
		*pWrite++ = *p;
	}

	return pWrite;
}

//---------------------------------------------------------------------------
//
//	Human68k̖̂ϊ
//
//	炩 SetWin32() sĂƁB
//	18+3̖Kɏ]OϊsȂB
//	t@C擪і̋󔒂́AHuman68kňȂߎIɍ폜B
//	fBNgGg̖OAt@Cϊ̊gq̈ʒugĐB
//	̌At@Cُ̈픻sȂB(Xy[X8̃t@CȂ)
//	t@C̏d͍sȂȂ̂ŒӁB̔͏ʃNXōsȂB
//	TwentyOne version 1.36c modified +14 patchlevel9 ȍ~̊gqKɑΉB
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilename::SetHuman(int nCount)
{
	ASSERT(this);
	ASSERT(m_pszWin32);
	ASSERT(_tcslen(m_pszWin32) < _MAX_PATH);

	// TufBNg̏ꍇ͕ϊȂ
	if (m_pszWin32[0] == '.') {
		if (m_pszWin32[1] == '\0' || (m_pszWin32[1] == '.' && m_pszWin32[2] == '\0')) {
			strcpy((char*)m_szHuman, (char*)m_pszWin32);	// WARNING: UnicodevC

			m_bCorrect = TRUE;
			m_pszHumanLast = m_szHuman + strlen((char*)m_szHuman);
			m_pszHumanExt = m_pszHumanLast;
			return;
		}
	}

	DWORD nMax = 18;	// x[X(x[XƊgq)̃oCg
	if (g_nOption & WINDRV_OPT_CONVERT_LENGTH) nMax = 8;

	// x[X̕␳
	BYTE szNumber[8];
	BYTE* pNumber = NULL;
	if (nCount >= 0) {
		pNumber = &szNumber[8];
		for (int i = 0; i < 5; i++) {	// ő5+1܂ (x[X擪2oCg͕Kc)
			int n = nCount % 36;
			nMax--;
			pNumber--;
			*pNumber = (BYTE)n + (n < 10 ? '0' : 'A' - 10);
			nCount /= 36;
			if (nCount == 0) break;
		}
		nMax--;
		pNumber--;
		BYTE c = (BYTE)(g_nOption >> 24) & 0x7F;
		if (c == 0) c = XM6_HOST_FILENAME_MARK;
		*pNumber = c;
	}

	// ϊ
	// WARNING: UnicodeΉBUnicode̐EɟZ܂ꂽ͂ŕϊsȂ
	BYTE szHuman[_MAX_PATH];
	const BYTE* pFirst = szHuman;
	const BYTE* pLast;
	const BYTE* pExt = NULL;

	{
		const BYTE* pRead = (const BYTE*)m_pszWin32;
		BYTE* pWrite = szHuman;
		const BYTE* pPeriod = SeparateExt(pRead);

		for (bool bFirst = true; ; bFirst = false) {
			BYTE c = *pRead++;
			switch (c) {
			case ' ':
				if (g_nOption & WINDRV_OPT_REDUCED_SPACE) continue;
				if (g_nOption & WINDRV_OPT_CONVERT_SPACE) c = '_';
				else if (pWrite == szHuman) continue;	// 擪̋󔒂͖
				break;
			case '=':
			case '+':
				if (g_nOption & WINDRV_OPT_REDUCED_BADCHAR) continue;
				if (g_nOption & WINDRV_OPT_CONVERT_BADCHAR) c = '_';
				break;
			case '-':
				if (bFirst) {
					if (g_nOption & WINDRV_OPT_REDUCED_HYPHEN) continue;
					if (g_nOption & WINDRV_OPT_CONVERT_HYPHEN) c = '_';
					break;
				}
				if (g_nOption & WINDRV_OPT_REDUCED_HYPHENS) continue;
				if (g_nOption & WINDRV_OPT_CONVERT_HYPHENS) c = '_';
				break;
			case '.':
				if (pRead - 1 == pPeriod) {		// Human68kgq͗OƂ
					pExt = pWrite;
					break;
				}
				if (bFirst) {
					if (g_nOption & WINDRV_OPT_REDUCED_PERIOD) continue;
					if (g_nOption & WINDRV_OPT_CONVERT_PERIOD) c = '_';
					break;
				}
				if (g_nOption & WINDRV_OPT_REDUCED_PERIODS) continue;
				if (g_nOption & WINDRV_OPT_CONVERT_PERIODS) c = '_';
				break;
			}
			*pWrite++ = c;
			if (c == '\0') break;
		}

		pLast = pWrite - 1;
	}

	// gq␳
	if (pExt) {
		// ̋󔒂폜
		while(pExt < pLast - 1 && *(pLast - 1) == ' ') {
			pLast--;
			BYTE* p = (BYTE*)pLast;
			*p = '\0';
		}

		// ϊɎ̂ȂȂꍇ͍폜
		if (pExt + 1 >= pLast) {
			pLast = pExt;
			BYTE* p = (BYTE*)pLast;
			*p = '\0';		// Ô
		}
	} else {
		pExt = pLast;
	}

	// olЉ
	//
	// pFirst: ̓[_[Bt@C擪
	// pCut: ʏ̃tFCXBŏ̃sIh̏oʒu ̌x[XI[ʒuƂȂ
	// pSecond: 悧܂ǂBl}[hbNBgq̊JnʒuB牽B
	// pExt: BEAEoJXBHuman68kgq̓V˂BłA3蒷O͊قȁB
	// Ō̃sIh̏oʒu YȂpLastƓl
	//
	// pFirst            pStop pSecond                 pExt
	// T h i s _ i s _ a . V e r y . L o n g . F i l e n a m e . t x t \0
	//         pCut  pCutʒu                                pLast
	//
	// L̏ꍇAϊ This.Long.Filename.txt ƂȂ

	// 1ڔ
	const BYTE* pCut = pFirst;
	const BYTE* pStop = pExt - nMax;	// gq͍ő17oCgƂ(x[Xc)
	if (pFirst < pExt) {
		pCut++;		// K1oCg̓x[Xg
		BYTE c = *pFirst;
		if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
			pCut++;		// x[X ŏ2oCg
			pStop++;	// gq ő16oCg
		}
	}
	if (pStop < pFirst) pStop = pFirst;

	// x[X
	pCut = (BYTE*)strchr((char*)pCut, '.');	// SJIS2oCgڂ͕K0x40ȏȂ̂ŖȂ
	if (pCut == NULL) pCut = pLast;
	if ((DWORD)(pCut - pFirst) > nMax) {
		pCut = pFirst + nMax;	// قSJIS2oCg/␳sȂ Ŕ肵Ă͂Ȃ
	}

	// gq
	const BYTE* pSecond = pExt;
	for (const BYTE* p = pExt - 1; pStop < p; p--) {
		if (*p == '.') pSecond = p;	// SJIS2oCgڂ͕K0x40ȏȂ̂ŖȂ
	}

	// x[XZk
	DWORD nExt = pExt - pSecond;	// gq̒
	if ((DWORD)(pCut - pFirst) + nExt > nMax) pCut = pFirst + nMax - nExt;
	// 2oCg̓rȂ炳ɒZk
	for (p = pFirst; p < pCut; p++) {
		BYTE c = *p;
		if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
			p++;
			if (p >= pCut) {
				pCut--;
				break;
			}
		}
	}

	// Ǒ
	BYTE* pWrite = m_szHuman;
	pWrite = CopyName(pWrite, pFirst, pCut);	// x[X]
	if (pNumber) pWrite = CopyName(pWrite, pNumber, &szNumber[8]);	// ␳]
	pWrite = CopyName(pWrite, pSecond, pExt);	// gq]
	m_pszHumanExt = pWrite;						// gqʒuۑ
	pWrite = CopyName(pWrite, pExt, pLast);		// Human68kgq]
	m_pszHumanLast = pWrite;					// I[ʒuۑ
	*pWrite = '\0';

	// ϊʂ̊mF
	m_bCorrect = TRUE;
	int nSize = m_pszHumanExt - m_szHuman;				// gq̈ʒuۑ

	// t@C{݂̂ȂΕsi
	if (nSize <= 0) m_bCorrect = FALSE;

	// t@C{̂1ȏł󔒂ŏIĂΕsi
	// t@C{̂8ȏ̏ꍇA_͋󔒂ł̏I\
	// \AHuman68kł͐Ȃ߁AsiƂ
	else if (m_szHuman[nSize - 1] == ' ') m_bCorrect = FALSE;

	// ϊʂfBNgƓȂsi
	if (m_szHuman[0] == '.') {
		if (m_szHuman[1] == '\0' || (m_szHuman[1] == '.' && m_szHuman[2] == '\0')) {
			m_bCorrect = FALSE;
		}
	}
}

//---------------------------------------------------------------------------
//
//	Human68k̖̂𕡐
//
//	t@C̏𕡐ASetHuman() ̏sȂB
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilename::CopyHuman(const BYTE* szHuman)
{
	ASSERT(this);
	ASSERT(szHuman);
	ASSERT(strlen((char*)szHuman) < 23);

	strcpy((char*)m_szHuman, (char*)szHuman);
	m_bCorrect = TRUE;
	m_pszHumanLast = m_szHuman + strlen((char*)m_szHuman);
	m_pszHumanExt = (BYTE*)SeparateExt(m_szHuman);
}

//---------------------------------------------------------------------------
//
//	fBNgGg̐ݒ
//
//	zXgFinďʂAETCYEtfBNgG
//	gɔfBt@CFinďʂł͂ȂNXϐɐ
//	ς݂̃f[^𔽉f邽߁A炩 SetHuman() sĂ
//	(sĂȂĂɕs͋NȂ)B
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostFilename::SetEntry(const WIN32_FIND_DATA* pWin32Find)
{
	ASSERT(this);
	ASSERT(pWin32Find);

	// t@Cݒ
	BYTE* p = m_szHuman;
	for (int i = 0; i < 8; i++) {
		if (p < m_pszHumanExt)
			m_dirEntry.name[i] = *p++;
		else
			m_dirEntry.name[i] = ' ';
	}

	for (i = 0; i < 10; i++) {
		if (p < m_pszHumanExt)
			m_dirEntry.add[i] = *p++;
		else
			m_dirEntry.add[i] = '\0';
	}

	if (*p == '.') p++;
	for (i = 0; i < 3; i++) {
		BYTE c = *p;
		if (c) p++;
		m_dirEntry.ext[i] = c;
	}

	// ݒ
	DWORD n = pWin32Find->dwFileAttributes;
	BYTE nHumanAttribute = Human68k::AT_ARCHIVE;
	if ((n & FILE_ATTRIBUTE_DIRECTORY) != 0) {
		nHumanAttribute = Human68k::AT_DIRECTORY;
	}
	if ((n & FILE_ATTRIBUTE_SYSTEM) != 0) nHumanAttribute |= Human68k::AT_SYSTEM;
	if ((n & FILE_ATTRIBUTE_HIDDEN) != 0) nHumanAttribute |= Human68k::AT_HIDDEN;
	if ((n & FILE_ATTRIBUTE_READONLY) != 0) nHumanAttribute |= Human68k::AT_READONLY;
	m_dirEntry.attr = nHumanAttribute;

	// TCYݒ
	m_dirEntry.size = pWin32Find->nFileSizeLow;
	if (pWin32Find->nFileSizeHigh > 0 || pWin32Find->nFileSizeLow > XM6_HOST_FILESIZE_MAX)
		m_dirEntry.size = XM6_HOST_FILESIZE_MAX;

	// tEݒ
	m_dirEntry.date = 0;
	m_dirEntry.time = 0;
	FILETIME ft = pWin32Find->ftLastWriteTime;
	if (ft.dwLowDateTime == 0 && ft.dwHighDateTime == 0) {
		ft = pWin32Find->ftCreationTime;
	}
	FILETIME lt;
	if (::FileTimeToLocalFileTime(&ft, &lt) == 0) return FALSE;
	if (::FileTimeToDosDateTime(&lt, &m_dirEntry.date, &m_dirEntry.time) == 0) return FALSE;

	// NX^ԍݒ
	m_dirEntry.cluster = 0;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Human68k̖̂Hꂽ
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostFilename::isReduce() const
{
	ASSERT(this);
	ASSERT(m_pszWin32);

	return strcmp((char*)m_pszWin32, (char*)m_szHuman) != 0; // WARNING: UnicodevC
}

//---------------------------------------------------------------------------
//
//	YGg̃LbV폜
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilename::DeleteCache()
{
	ASSERT(this);

	if (m_pEntry) m_pEntry->DeleteCache(m_pChild);
}

//---------------------------------------------------------------------------
//
//	Human68kt@Cgq𕪗
//
//---------------------------------------------------------------------------
const BYTE* FASTCALL CHostFilename::SeparateExt(const BYTE* szHuman)
{
	// t@C̒l
	int nLength = strlen((char*)szHuman);
	const BYTE* pFirst = szHuman;
	const BYTE* pLast = pFirst + nLength;

	// Human68kgq̈ʒumF
	const BYTE* pExt = (BYTE*)strrchr((char*)pFirst, '.');	// SJIS2oCgڂ͕K0x40ȏȂ̂ŖȂ
	if (pExt == NULL) pExt = pLast;
	// t@C20`2219ڂ'.''.'ŏIƂp^[ʈ
	if (20 <= nLength && nLength <= 22 && pFirst[18] == '.' && pFirst[nLength-1] == '.')
		pExt = pFirst + 18;
	// gq̕vZ	(-1:Ȃ 0:sIh 1`3:Human68kgq 4ȏ:gq)
	int nExt = pLast - pExt - 1;
	// '.' 擪ȊOɑ݂āA1`3̏ꍇ̂݊gqƂ݂Ȃ
	if (pExt == pFirst || nExt < 1 || nExt > 3) pExt = pLast;

	return pExt;
}

//===========================================================================
//
//	fBNgGg pX
//
//	Human68k̃pX́AK擪 / Ŏn܂A / ȂB
//	( / ŏIꍇ͋̃t@CwƔf)
//	܂AjbgԍAɃyAňB
//	] mfc_host ł̈ƈقȂ̂ŒӁB
//	̂߁AWin32pX̓x[XpX܂ށB
//	x[XpXȂł\ƂB
//
//===========================================================================

DWORD CHostPath::g_nId;				// IDpJE^
DWORD CHostPath::g_nOption;			// tO (pXr֘A)

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CHostPath::CHostPath()
{
	m_nHumanUnit = 0;
	m_pszHuman = NULL;
	m_pszWin32 = NULL;
	m_hChange = INVALID_HANDLE_VALUE;
	m_nId = g_nId++;
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
CHostPath::~CHostPath()
{
#if 0
	OutputDebugString("Cache Delete ");
	OutputDebugString(m_pszWin32);
	OutputDebugString("\r\n");
#endif

	Clean();
}

//---------------------------------------------------------------------------
//
//	Human68k̖̂𒼐ڎw肷
//
//---------------------------------------------------------------------------
void FASTCALL CHostPath::SetHuman(DWORD nUnit, BYTE* szHuman)
{
	ASSERT(this);
	ASSERT(szHuman);
	ASSERT(strlen((char*)szHuman) < HUMAN68K_MAX_PATH);
	ASSERT(m_pszHuman == NULL);

	m_pszHuman = (BYTE*)malloc(strlen((char*)szHuman) + 1);
	ASSERT(m_pszHuman);
	strcpy((char*)m_pszHuman, (char*)szHuman);
	m_nHumanUnit = nUnit;
}

//---------------------------------------------------------------------------
//
//	Win32̖̂𒼐ڎw肷
//
//---------------------------------------------------------------------------
void FASTCALL CHostPath::SetWin32(TCHAR* szWin32)
{
	ASSERT(this);
	ASSERT(szWin32);
	ASSERT(_tcslen(szWin32) < _MAX_PATH);
	ASSERT(m_pszWin32 == NULL);

	m_pszWin32 = (TCHAR*)malloc(_tcslen(szWin32) + 1);
	ASSERT(m_pszWin32);
	_tcscpy(m_pszWin32, szWin32);
}

//---------------------------------------------------------------------------
//
//	r (ChJ[hΉ)
//
//---------------------------------------------------------------------------
int FASTCALL CHostPath::Compare(const BYTE* pFirst, const BYTE* pLast, const BYTE* pBufFirst, const BYTE* pBufLast)
{
	ASSERT(pFirst);
	ASSERT(pLast);
	ASSERT(pBufFirst);
	ASSERT(pBufLast);

	// r
	BOOL bSkip0 = FALSE;
	BOOL bSkip1 = FALSE;
	for (const BYTE* p = pFirst; p < pLast; p++) {
		// 1ǂݍ
		BYTE c = *p;
		BYTE d = '\0';
		if (pBufFirst < pBufLast) d = *pBufFirst++;

		// r̂߂̕␳
		if (bSkip0 == FALSE) {
			if (bSkip1 == FALSE) {	// cd1oCg
				if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
					bSkip0 = TRUE;
				}
				if ((0x80 <= d && d <= 0x9F) || 0xE0 <= d) {	// ɂ 0x81`0x9F 0xE0`0xEF
					bSkip1 = TRUE;
				}
				if (c == d) continue;	// mŔ芮
				if ((g_nOption & WINDRV_OPT_ALPHABET) == 0) {
					if ('A' <= c && c <= 'Z') c += 'a' - 'A';	// 
					if ('A' <= d && d <= 'Z') d += 'a' - 'A';	// 
				}
			} else {		// c1oCg
				if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
					bSkip0 = TRUE;
				}
				bSkip1 = FALSE;
			}
		} else {
			if (bSkip1 == FALSE) {	// d1oCg
				bSkip0 = FALSE;
				if ((0x80 <= d && d <= 0x9F) || 0xE0 <= d) {	// ɂ 0x81`0x9F 0xE0`0xEF
					bSkip1 = TRUE;
				}
			} else {		// cd2oCg
				bSkip0 = FALSE;
				bSkip1 = FALSE;
			}
		}

		// r
		if (c == d) continue;
		if (c == '?') continue;
		//if (c == '*') return 0;
		return 1;
	}
	if (pBufFirst < pBufLast) return 2;

	return 0;
}

//---------------------------------------------------------------------------
//
//	Human68k̖̂r
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostPath::isSameHuman(DWORD nUnit, const BYTE* szHuman) const
{
	ASSERT(this);
	ASSERT(szHuman);
	ASSERT(m_pszHuman);

	// jbgԍ̔r
	if (m_nHumanUnit != nUnit) return FALSE;

	// vZ
	const BYTE* pFirst = m_pszHuman;
	DWORD nLength = strlen((char*)pFirst);
	const BYTE* pLast = pFirst + nLength;

	const BYTE* pBufFirst = szHuman;
	DWORD nBufLength = strlen((char*)pBufFirst);
	const BYTE* pBufLast = pBufFirst + nBufLength;

	// `FbN
	if (nLength != nBufLength) return FALSE;

	// Human68kpX̔r
	return Compare(pFirst, pLast, pBufFirst, pBufLast) == 0;
}

//---------------------------------------------------------------------------
//
//	t@C
//
//	LLVobt@̒猟A΂̖̂ԂB
//	pXOĂƁB
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
CHostFilename* FASTCALL CHostPath::FindFilename(BYTE* szHuman, DWORD nHumanAttribute)
{
	ASSERT(this);
	ASSERT(szHuman);

	// vZ
	const BYTE* pFirst = szHuman;
	DWORD nLength = strlen((char*)pFirst);
	const BYTE* pLast = pFirst + nLength;

	// ĂSẴt@C̒犮Sv̂
	for (CHostFilename* p = (CHostFilename*)m_cRingFilename.Next();
		 p != &m_cRingFilename; p = (CHostFilename*)p->Next()) {
		// `FbN
		if (p->CheckAttribute(nHumanAttribute) == 0) continue;
		// vZ
		const BYTE* pBufFirst = p->GetHuman();
		const BYTE* pBufLast = p->GetHumanLast();
		DWORD nBufLength = pBufLast - pBufFirst;
		// `FbN
		if (nLength != nBufLength) continue;
		// t@C`FbN
		if (Compare(pFirst, pLast, pBufFirst, pBufLast) == 0) return p;
	}

	return NULL;
}

//---------------------------------------------------------------------------
//
//	t@C (ChJ[hΉ)
//
//	Lobt@̒猟A΂̖̂ԂB
//	pXOĂƁB
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
CHostFilename* FASTCALL CHostPath::FindFilenameWildcard(BYTE* szHuman, find_t* pFind, DWORD nHumanAttribute)
{
	ASSERT(this);
	ASSERT(szHuman);
	ASSERT(pFind);

	// t@C{̂Human68kgqɕ
	const BYTE* pFirst = szHuman;
	const BYTE* pLast = pFirst + strlen((char*)pFirst);
	const BYTE* pExt = CHostFilename::SeparateExt(pFirst);

	// Jnn_ֈړ
	CHostFilename* p = (CHostFilename*)m_cRingFilename.Next();
	if (pFind->count > 0) {
		if (pFind->id == m_nId) {
			// LbVeɕωȂꍇ́AÖʒu瑦
			p = pFind->pos;
		} else {
			// Jnn_Gge猟
			DWORD n = 0;
			for (; p != &m_cRingFilename; p = (CHostFilename*)p->Next()) {
				if (p->isSameEntry(&pFind->entry)) {
					pFind->count = n;
					break;
				}
				n++;
			}

			// YGgȂꍇA񐔎wg
			if (p == &m_cRingFilename) {
				CHostFilename* p = (CHostFilename*)m_cRingFilename.Next();
				n = 0;
				for (; p != &m_cRingFilename; p = (CHostFilename*)p->Next()) {
					if (n >= pFind->count) break;
					n++;
				}
			}
		}
	}

	// t@C
	for (; p != &m_cRingFilename; p = (CHostFilename*)p->Next()) {
		pFind->count++;

		// `FbN
		if (p->CheckAttribute(nHumanAttribute) == 0) continue;

		// t@C{̂Human68kgqɕ
		const BYTE* pBufFirst = p->GetHuman();
		const BYTE* pBufLast = p->GetHumanLast();
		const BYTE* pBufExt = p->GetHumanExt();

		// {̔r
		if (Compare(pFirst, pExt, pBufFirst, pBufExt) != 0) continue;

		// Human68kgqr
		// gq .??? (.*) ̏ꍇ́AHuman68kgq̃sIhȂɂ}b`
		if (strcmp((char*)pExt, ".???") == 0 ||	// strncmp((char*)pExt, ".*", 2) == 0 ||
			Compare(pExt, pLast, pBufExt, pBufLast) == 0) {
			// ̌̃GgeL^
			CHostFilename* pNext = (CHostFilename*)p->Next();
			pFind->id = m_nId;
			pFind->pos = pNext;
			if (pNext != &m_cRingFilename) {
				memcpy(&pFind->entry, pNext->GetEntry(), sizeof(pFind->entry));
			} else {
				memset(&pFind->entry, 0, sizeof(pFind->entry));
			}
			return p;
		}
	}

	pFind->id = m_nId;
	pFind->pos = p;
	memset(&pFind->entry, 0, sizeof(pFind->entry));
	return NULL;
}

//---------------------------------------------------------------------------
//
//	ėp̂߂̏
//
//---------------------------------------------------------------------------
void FASTCALL CHostPath::Clean()
{
	ASSERT(this);

	if (m_hChange != INVALID_HANDLE_VALUE) {
		::FindCloseChangeNotification(m_hChange);
		m_hChange = INVALID_HANDLE_VALUE;
	}

	CleanFilename();

	FreeHuman();
	FreeWin32();
}

//---------------------------------------------------------------------------
//
//	St@CJ
//
//---------------------------------------------------------------------------
void FASTCALL CHostPath::CleanFilename()
{
	// ̂J
	CHostFilename* p;
	while ((p = (CHostFilename*)m_cRingFilename.Next()) != &m_cRingFilename) {
		delete p;
	}
}

//---------------------------------------------------------------------------
//
//	t@CύXsȂꂽmF
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostPath::isRefresh()
{
	ASSERT(this);

	if (m_hChange == INVALID_HANDLE_VALUE) return TRUE;		// ĂȂΗvXV

	DWORD nResult = WaitForSingleObject(m_hChange, 0);
	if (nResult == WAIT_TIMEOUT) return FALSE;

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	t@Cč\
//
//	ŏ߂āAWin32t@CVXe̊ϑsȂB
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostPath::Refresh()
{
	ASSERT(this);
	ASSERT(m_pszWin32);
	ASSERT(_tcslen(m_pszWin32) + 22 < _MAX_PATH);
#if 0
	OutputDebugString("Cache Refresh ");
	OutputDebugString(m_pszWin32);
	OutputDebugString("\r\n");
#endif

	// pX
	TCHAR szPath[_MAX_PATH];
	_tcscpy(szPath, m_pszWin32);
	_tcscat(szPath, _T("\\"));

	// XV`FbN
	if (m_hChange == INVALID_HANDLE_VALUE) {
		// 
		DWORD nFlag =
			FILE_NOTIFY_CHANGE_FILE_NAME |
			FILE_NOTIFY_CHANGE_DIR_NAME |
			FILE_NOTIFY_CHANGE_ATTRIBUTES |
			FILE_NOTIFY_CHANGE_SIZE |
			FILE_NOTIFY_CHANGE_LAST_WRITE;
		m_hChange = ::FindFirstChangeNotification(szPath, FALSE, nFlag);
		// OAv̉eŃG[o\B̂܂ܑsĂȂ
	} else {
		// ڈȍ~
		for (int i = 0; i < 3; i++) {	// 1sł̓tbVȂ\
			DWORD nResult = WaitForSingleObject(m_hChange, 0);
			if (nResult == WAIT_TIMEOUT) break;

			BOOL bResult = ::FindNextChangeNotification(m_hChange);
			if (bResult == FALSE) {
				::FindCloseChangeNotification(m_hChange);
				m_hChange = INVALID_HANDLE_VALUE;
				break;
			}
		}
	}

	// ȑÕLbVeړ
	CRing cRingBackup;
	m_cRingFilename.InsertRing(&cRingBackup);

	// pt@C
	_tcscat(szPath, _T("*.*"));

	// t@Co^
	BOOL bUpdate = FALSE;
	HANDLE hFind = INVALID_HANDLE_VALUE;
	for (int i = 0; i < XM6_HOST_FILENAME_CACHE_MAX; i++) {
		WIN32_FIND_DATA w32Find;
		if (hFind == INVALID_HANDLE_VALUE) {
			// ŏ̃t@Cl
			hFind = ::FindFirstFile(szPath, &w32Find);
			if (hFind == INVALID_HANDLE_VALUE) break;
		} else {
			// ̃t@Cl
			BOOL bResult = ::FindNextFile(hFind, &w32Find);
			if (bResult == FALSE) break;
		}

		// VKt@Co^
		CHostFilename* pFilename = new CHostFilename;
		ASSERT(pFilename);
		pFilename->SetWin32((TCHAR*)w32Find.cFileName);

		// ȑÕLbVeɊYt@C΂Human68k̂D悷
		CHostFilename* pCache = (CHostFilename*)cRingBackup.Next();
		for (;;) {
			if (pCache == &cRingBackup) {
				pCache = NULL;			// YGgȂ(̎_ŐVKGgƊm)
				pFilename->SetHuman();
				break;
			}
			if (_tcscmp(pFilename->GetWin32(), pCache->GetWin32()) == 0) {
				pFilename->CopyHuman(pCache->GetHuman());	// Human68k̂̃Rs[
				break;
			}
			pCache = (CHostFilename*)pCache->Next();
		}

		// VKGg̏ꍇ̓t@Cd`FbN
		// t@CɕύXꍇ́Aȉ̃`FbNSăpX̂gp
		// Et@Cł邱
		// Eߋ̃Ggɓ݂̂̂Ȃ
		// E̎t@C݂Ȃ
		if (pFilename->isReduce()) {	// t@C̕ύXsȂꂽꍇ̂݃`FbN
			for (int n = 0; n < 36 * 36 * 36 * 36 * 36; n++) {	// 6疜p^[(365)
				// t@CǂmF
				if (pFilename->isCorrect()) {
					// ߋ̃Ggƈv邩mF
					CHostFilename* pCheck = FindFilename(pFilename->GetHuman());
					if (pCheck == NULL) {
						// v̂Ȃ΁At@C݂邩mF
						TCHAR szBuf[_MAX_PATH];
						_tcscpy(szBuf, m_pszWin32);
						_tcscat(szBuf, _T("\\"));
						_tcscat(szBuf, (TCHAR*)pFilename->GetHuman());	// WARNING: UnicodevC
						WIN32_FIND_DATA w32Check;
						HANDLE hCheck = ::FindFirstFile(szBuf, &w32Check);
						if (hCheck == INVALID_HANDLE_VALUE) break;	// p\p^[𔭌
						FindClose(hCheck);
					}
				}
				// VO𐶐
				pFilename->SetHuman(n);
			}
		}

		// fBNgGg
		pFilename->SetEntry(&w32Find);

		// ȑÕLbVeƔr
		if (pCache) {
			if (pCache->isSameEntry(pFilename->GetEntry())) {
				delete pFilename;		// 쐬Gg͔j
				pFilename = pCache;		// ȑÕLbVeg
			} else {
				bUpdate = TRUE;			// vȂ΍XV
				delete pCache;			// ̌Ώۂ珜O
			}
		} else {
			bUpdate = TRUE;				// VKGĝߍXV
		}

		// O֒ǉ
		pFilename->InsertTail(&m_cRingFilename);
	}

	if (hFind != INVALID_HANDLE_VALUE) FindClose(hFind);

	// cLbVe폜
	CHostFilename* p;
	while ((p = (CHostFilename*)cRingBackup.Next()) != &cRingBackup) {
		bUpdate = TRUE;			// 폜sȂ̂ōXV
		delete p;
	}

	// XVsȂꂽ环IDύX
	if (bUpdate) m_nId = g_nId++;

	// ŌɃG[ʒm
	if (m_hChange == INVALID_HANDLE_VALUE) return FALSE;

	return TRUE;
}

//===========================================================================
//
//	fBNgGgǗ
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	 (N)
//
//---------------------------------------------------------------------------
CHostEntry::CHostEntry()
{
#ifdef XM6_HOST_STRICT_TIMEOUT
	m_hEvent = NULL;
	m_hThread = NULL;
#else // XM6_HOST_STRICT_TIMEOUT
	m_nTimeout = 0;
#endif // XM6_HOST_STRICT_TIMEOUT
	m_nRingPath = 0;

	InitializeCriticalSection(&m_csAccess);
}

//---------------------------------------------------------------------------
//
//	J (I)
//
//---------------------------------------------------------------------------
CHostEntry::~CHostEntry()
{
	Clean();

	DeleteCriticalSection(&m_csAccess);
}

//---------------------------------------------------------------------------
//
//	 (hCogݎ)
//
//---------------------------------------------------------------------------
void CHostEntry::Init(CWinFileDrv** ppBase)
{
	ASSERT(this);
	ASSERT(ppBase);

	m_ppBase = ppBase;

#ifdef XM6_HOST_STRICT_TIMEOUT
	ASSERT(m_hEvent == NULL);
	ASSERT(m_hThread == NULL);

	// Cxgm
	m_hEvent = ::CreateEvent(NULL, FALSE, FALSE, NULL);		// Zbg
	ASSERT(m_hEvent);

	// ĎXbhJn
	DWORD nThread;
	m_hThread = ::CreateThread(NULL, 0, Run, this, 0, &nThread);
	ASSERT(m_hThread);
#endif // XM6_HOST_STRICT_TIMEOUT
}

//---------------------------------------------------------------------------
//
//	J (NEZbg)
//
//---------------------------------------------------------------------------
void CHostEntry::Clean()
{
	ASSERT(this);

#ifdef XM6_HOST_STRICT_TIMEOUT
	// ĎXbhI
	if (m_hThread) {
		ASSERT(m_hEvent);

		// Xbh֒~v
		::SetEvent(m_hEvent);

		// XbhI҂
		DWORD nResult;
		nResult = ::WaitForSingleObject(m_hThread, 30 * 1000);	// P\ 30b
		if (nResult != WAIT_OBJECT_0) {
			// ~
			ASSERT(FALSE);	// Ô
			::TerminateThread(m_hThread, -1);
			nResult = ::WaitForSingleObject(m_hThread, 100);
		}

		// XbhnhJ
		::CloseHandle(m_hThread);
		m_hThread = NULL;
	}

	// CxgJ
	if (m_hEvent) {
		::CloseHandle(m_hEvent);
		m_hEvent = NULL;
	}
#endif // XM6_HOST_STRICT_TIMEOUT

	LockCache();

	CleanCache();

	UnlockCache();
}

#ifdef XM6_HOST_STRICT_TIMEOUT
//---------------------------------------------------------------------------
//
//	XbhsJn|Cg
//
//---------------------------------------------------------------------------
DWORD WINAPI CHostEntry::Run(VOID* pThis)
{
	ASSERT(pThis);

	((CHostEntry*)pThis)->Runner();

	::ExitThread(0);
	return 0;
}

//---------------------------------------------------------------------------
//
//	Xbh
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::Runner()
{
	ASSERT(this);
	ASSERT(m_hEvent);

	for (;;) {
		DWORD nResult = ::WaitForSingleObject(m_hEvent, XM6_HOST_REMOVABLE_CHECK_TIME);
		if (nResult == WAIT_OBJECT_0) break;

		// ShCũ^CAEg`FbN
		CheckTimeout();
	}
}
#endif // XM6_HOST_STRICT_TIMEOUT

//---------------------------------------------------------------------------
//
//	w肳ꂽjbg̃LbVSč폜
//
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::CleanCache()
{
	ASSERT(this);

	// ̂J
	CHostPath* p;
	while ((p = (CHostPath*)m_cRingPath.Next()) != &m_cRingPath) {
		delete p;
		m_nRingPath--;
	}
	ASSERT(m_nRingPath == 0);

	CHostPath::InitId();
}

//---------------------------------------------------------------------------
//
//	w肳ꂽjbg̃LbVSč폜
//
//	[oufBA̔roɔ폜B
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::EraseCache(DWORD nUnit)
{
	ASSERT(this);

	// ĂSẴt@C̒v̂
	for (CHostPath* p = (CHostPath*)m_cRingPath.Next(); p != &m_cRingPath;) {
		if (p->isSameUnit(nUnit)) {
			delete p;
			m_nRingPath--;

			// AŎ̃IuWFNg\̂ōŏ璲ׂȂ
			p = (CHostPath*)m_cRingPath.Next();
			continue;
		}
		p = (CHostPath*)p->Next();
	}
}

//---------------------------------------------------------------------------
//
//	YLbV폜
//
//	LbV͊ɍ폜ς݂̂Ƃ邽߁AmFsȂĂ폜B
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::DeleteCache(CHostPath* pPath)
{
	ASSERT(this);
	ASSERT(pPath);

	// ĂSẴt@C̒v̂
	for (CHostPath* p = (CHostPath*)m_cRingPath.Next();
		 p != &m_cRingPath; p = (CHostPath*)p->Next()) {
		if (p == pPath) {
			delete p;
			m_nRingPath--;
			break;
		}
	}
}

//---------------------------------------------------------------------------
//
//	YpXLbVĂ邩
//
//	LLVobt@̒犮SvŌA΂̖̂ԂB
//	t@COĂƁB
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
CHostPath* FASTCALL CHostEntry::FindCache(DWORD nUnit, const BYTE* szHuman)
{
	ASSERT(this);
	ASSERT(szHuman);

	// ĂSẴt@C̒犮Sv̂
	for (CHostPath* p = (CHostPath*)m_cRingPath.Next();
		 p != &m_cRingPath; p = (CHostPath*)p->Next()) {
		if (p->isSameHuman(nUnit, szHuman)) {
			return p;
		}
	}

	return NULL;
}

//---------------------------------------------------------------------------
//
//	LbVɁAWin32l
//
//	pXEt@C1iKALbVɂ邩mFBȂ΃G[B
//	LbV̍XV`FbNBXVKvȂG[B
//	KʂŔrsȂƁB
//
//---------------------------------------------------------------------------
CHostPath* FASTCALL CHostEntry::CopyCache(DWORD nUnit, const BYTE* szHuman, TCHAR* szWin32Buffer)
{
	ASSERT(this);
	ASSERT(szHuman);
	ASSERT(strlen((char*)szHuman) < HUMAN68K_MAX_PATH);

	// pXƃt@Cɕ
	const BYTE* pSeparate = SeparatePath(szHuman);
	if (pSeparate == NULL) return NULL;	// G[: pXs

	BYTE szHumanPath[HUMAN68K_MAX_PATH];
	int nPath = pSeparate - szHuman;
	strncpy((char*)szHumanPath, (char*)szHuman, nPath);
	szHumanPath[nPath] = '\0';

	BYTE szHumanFilename[_MAX_PATH];
	strcpy((char*)szHumanFilename, (char*)pSeparate + 1);

	// pX̃LbVc`FbN
	CHostPath* pPath = FindCache(nUnit, szHumanPath);
	if (pPath == NULL) return NULL;	// G[: pXLbVĂȂ߉͕s\

	// O擪ֈړ
	pPath->Insert(&m_cRingPath);

	// LbVXV`FbN
	if (pPath->isRefresh()) return NULL;	// G[: LbVXVKv

	// Win32pXRs[
	if (szWin32Buffer) {
		_tcscpy(szWin32Buffer, pPath->GetWin32());
		_tcscat(szWin32Buffer, _T("\\"));
	}

	// t@CȂΏI
	if (szHumanFilename[0] == '\0') {
		return pPath;	// ʂ͂ŏI
	}

	// t@C
	CHostFilename* pFilename = pPath->FindFilename(szHumanFilename);
	if (pFilename == NULL) return NULL;	// G[: r̃pX/t@CȂ

	// Win32t@CRs[
	if (szWin32Buffer) {
		_tcscat(szWin32Buffer, pFilename->GetWin32());
	}

	return pPath;
}

//---------------------------------------------------------------------------
//
//	Win32̍\zɕKvȏׂĎ擾
//
//	t@C͏ȗ\B(ʂ͎w肵Ȃ)
//	KʂŔrsȂƁB
//	x[XpXɃpX؂蕶Ȃ悤ӁB
//	t@CANZX\Ƃ́AVMXbh̓JnB
//
//	g:
//	CopyCache()ăG[̏ꍇMakeCache()BKWin32pX擾łB
//
//	t@CƃpXׂĕB
//	ʃtH_珇ɁALbVĂ邩ǂmFB
//	LbVĂΔj`FbNBjꍇLbVƂȂB
//	LbVĂȂ΃LbV\zB
//	ԂɂׂẴtH_Et@Cɑ΂čsȂIB
//	G[ꍇNULLƂȂB
//
//---------------------------------------------------------------------------
CHostPath* FASTCALL CHostEntry::MakeCache(CWindrv* ps, DWORD nUnit, const BYTE* szHuman, TCHAR* szWin32Buffer)
{
	ASSERT(this);
	ASSERT(szHuman);
	ASSERT(strlen((char*)szHuman) < HUMAN68K_MAX_PATH);

	const TCHAR* szWin32Base = GetBase(nUnit);
	ASSERT(szWin32Base);
	ASSERT(_tcslen(szWin32Base) < _MAX_PATH);

	BYTE szHumanPath[HUMAN68K_MAX_PATH];	// ʃtH_珇ɃpXĂ䂭
	szHumanPath[0] = '\0';
	int nHumanPath = 0;

	TCHAR szWin32Path[_MAX_PATH];
	_tcscpy(szWin32Path, szWin32Base);
	int nWin32Path = _tcslen(szWin32Path);

	CHostFilename* pFilename = NULL;	// etH_̎̂
	CHostPath* pPath;
	const BYTE* p = szHuman;
	for (;;) {
		// t@C
		BYTE szHumanFilename[24];			// t@C
		p = SeparateCopyFilename(p, szHumanFilename);
		if (p == NULL) return NULL;		// G[: t@Cǂݍݎs

		// YpXLbVĂ邩H
		pPath = FindCache(nUnit, szHumanPath);
		if (pPath == NULL) {
			// LbVő吔`FbN
			if (m_nRingPath >= XM6_HOST_DIRENTRY_CACHE_MAX) {
				// ̃IuWFNĝAłÂ̂擾
				pPath = (CHostPath*)m_cRingPath.Prev();
				pPath->Clean();		// St@CJ XV`FbNpnhJ
			} else {
				// VKo^
				pPath = new CHostPath;
				ASSERT(pPath);
				m_nRingPath++;
			}
			pPath->SetHuman(nUnit, szHumanPath);
			pPath->SetWin32(szWin32Path);
		}

		// LbVXV`FbN
		if (pPath->isRefresh()) {
			// ᑬfBAłȂĂVMXbhsJn
			ps->Ready();
			BOOL bResult = CheckMediaAccess(nUnit, FALSE);
			if (bResult) bResult = pPath->Refresh();	// RXg
			if (bResult == FALSE) {
				// XVśAꃆjbg̃LbVSď
				delete pPath;
				m_nRingPath--;
				EraseCache(nUnit);
				return NULL;		// G[: pX擾łȂ
			}
		}

		// O擪
		pPath->Insert(&m_cRingPath);

		// etH_΋L^
		if (pFilename) pFilename->SetChild(this, pPath);

		// t@CȂ΂ŏI(pXꍇ)
		// t@CȂŋAĂ͕̂I[̏ꍇ݂̂Ȃ̂ŏIƂĎg
		if (szHumanFilename[0] == '\0') {
			// pXA
			if (nHumanPath + 1 + 1 > HUMAN68K_MAX_PATH) return NULL;	// G[: Human68kpX
			szHumanPath[nHumanPath++] = '/';
			szHumanPath[nHumanPath] = '\0';
			if (nWin32Path + 1 + 1 > _MAX_PATH) return NULL;	// G[: Win32pX
			szWin32Path[nWin32Path++] = '\\';
			szWin32Path[nWin32Path] = '\0';
			break;	// ʂ͂ŏI
		}

		// ̃pX
		// pX̓rȂfBNgǂmF
		if (*p != '\0') {
			pFilename = pPath->FindFilename(szHumanFilename, Human68k::AT_DIRECTORY);
		} else {
			pFilename = pPath->FindFilename(szHumanFilename);
		}
		if (pFilename == NULL) return NULL;	// G[: r̃pX/t@CȂ

		// pXA
		int n = strlen((char*)szHumanFilename);
		if (nHumanPath + n + 1 > HUMAN68K_MAX_PATH) return NULL;	// G[: Human68kpX
		szHumanPath[nHumanPath++] = '/';
		strcpy((char*)szHumanPath + nHumanPath, (char*)szHumanFilename);
		nHumanPath += n;

		n = _tcslen(pFilename->GetWin32());
		if (nWin32Path + n + 1 > _MAX_PATH) return NULL;	// G[: Win32pX
		szWin32Path[nWin32Path++] = '\\';
		_tcscpy(szWin32Path + nWin32Path, pFilename->GetWin32());
		nWin32Path += n;

		// PLEASE CONTINUE
		if (*p == '\0') break;
	}

	// Win32Rs[
	if (szWin32Buffer) {
		_tcscpy(szWin32Buffer, szWin32Path);
	}

	return pPath;
}

//---------------------------------------------------------------------------
//
//	x[XpX擾
//
//---------------------------------------------------------------------------
TCHAR* FASTCALL CHostEntry::GetBase(DWORD nUnit) const
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	return m_ppBase[nUnit]->GetBase();
}

//---------------------------------------------------------------------------
//
//	݋֎~ǂmF
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::isWriteProtect(CWindrv* ps) const
{
	ASSERT(this);
	ASSERT(ps);
	ASSERT(m_ppBase);

	DWORD nUnit = ps->GetUnit();
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	return m_ppBase[nUnit]->isWriteProtect();
}

//---------------------------------------------------------------------------
//
//	ᑬfBA`FbNƃItCԃ`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::isMediaOffline(CWindrv* ps, BOOL bMedia)
{
	ASSERT(this);
	ASSERT(ps);
	ASSERT(m_ppBase);

	DWORD nUnit = ps->GetUnit();
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	// ᑬfoCXȂVMXbh̓Jn
	if (m_ppBase[nUnit]->isSlow()) ps->Ready();

	// 蓮CWFNgfoCX̃ANZXO`FbN
	if (bMedia) CheckMediaAccess(nUnit, TRUE);

	// [oufBÃLbVLԍXV
	m_ppBase[nUnit]->SetTimeout();

	// 蓮CWFNgfoCX́ufBXNĂ܂vɂȂ
	if (m_ppBase[nUnit]->isManual()) return FALSE;

	// ItCԃ`FbN
	return m_ppBase[nUnit]->isEnable() == FALSE;
}

//---------------------------------------------------------------------------
//
//	fBAoCg̎擾
//
//---------------------------------------------------------------------------
BYTE FASTCALL CHostEntry::GetMediaByte(DWORD nUnit) const
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	if (m_ppBase[nUnit]->isRemovable()) {
		if (m_ppBase[nUnit]->isManual()) {
			return 0xF1;
		}
		return 0xF2;
	}
	return 0xF3;
}

//---------------------------------------------------------------------------
//
//	hCuԂ̎擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CHostEntry::GetStatus(DWORD nUnit) const
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	return m_ppBase[nUnit]->GetStatus();
}

//---------------------------------------------------------------------------
//
//	ShCũ^CAEg`FbN
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::CheckTimeout()
{
	ASSERT(this);
	ASSERT(m_ppBase);

#ifndef XM6_HOST_STRICT_TIMEOUT
	// ^CAEgmF
	DWORD nCount = ::GetTickCount();
	DWORD nDelta = nCount - m_nTimeout;
	if (nDelta < XM6_HOST_REMOVABLE_CHECK_TIME) return;
	m_nTimeout = nCount;
#endif // XM6_HOST_STRICT_TIMEOUT

	for (DWORD n = 0; n < CWinFileSys::DrvMax; n++) {
		if (m_ppBase[n]) {
			BOOL bResult = m_ppBase[n]->CheckTimeout();
			if (bResult) {
				LockCache();
				EraseCache(n);
				UnlockCache();
			}
		}
	}
}

#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
//---------------------------------------------------------------------------
//
//	[oufBȀԍXVLɂ
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::SetMediaUpdate(CWindrv* ps, BOOL bDisable)
{
	ASSERT(this);
	ASSERT(ps);
	ASSERT(m_ppBase);

	DWORD nUnit = ps->GetUnit();
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	m_ppBase[nUnit]->SetMediaUpdate(bDisable);
}
#endif // XM6_HOST_UPDATE_BY_SEQUENCE

//---------------------------------------------------------------------------
//
//	[oufBȀԍXV`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::CheckMediaUpdate(CWindrv* ps)
{
	ASSERT(this);
	ASSERT(ps);
	ASSERT(m_ppBase);

	DWORD nUnit = ps->GetUnit();
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	// XV x1
	BOOL bResult = m_ppBase[nUnit]->CheckMediaUpdate();
	if (bResult) {
		// XV x2
		bResult = m_ppBase[nUnit]->CheckMediaAccess(FALSE);
		if (bResult) {
			// ᑬfBA`FbN
			if (m_ppBase[nUnit]->isSlow()) ps->Ready();

			// fBAL`FbN
			bResult = m_ppBase[nUnit]->CheckMedia();
			if (bResult == FALSE) {
				// fBAgps\̓LbVNA
				LockCache();
				EraseCache(nUnit);
				UnlockCache();
			}
		}
	}

	return m_ppBase[nUnit]->isEnable();
}

//---------------------------------------------------------------------------
//
//	[oufBÃANZXO`FbN
//
//	ĂяoɂAꂼȉ̂悤ȏsȂ
//	1: MakeCache()			ᑬsv/NAsv/蓮CWFNgfBÂ
//	2: isMediaOffline()		ᑬsv/NAKv/蓮CWFNgfBÂ
//	3: CheckMediaUpdate()ɓ	ᑬKv/NAKv/[oufBAS
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::CheckMediaAccess(DWORD nUnit, BOOL bErase)
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	// XV
	BOOL bResult = m_ppBase[nUnit]->CheckMediaAccess(TRUE);
	if (bResult) {
		// fBAL`FbN
		bResult = m_ppBase[nUnit]->CheckMedia();
		if (bResult == FALSE) {
			// fBAgps\̓LbVNA
			if (bErase) {
				LockCache();
				EraseCache(nUnit);
				UnlockCache();
			}
		}
	}

	return m_ppBase[nUnit]->isEnable();
}

//---------------------------------------------------------------------------
//
//	CWFNg
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::Eject(DWORD nUnit)
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	BOOL bResult = m_ppBase[nUnit]->Eject();
	if (bResult) {
		m_ppBase[nUnit]->CheckMedia();
	}

	return bResult;
}

//---------------------------------------------------------------------------
//
//	{[x̎擾
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::GetVolume(DWORD nUnit, TCHAR* szLabel)
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	m_ppBase[nUnit]->GetVolume(szLabel);
}

//---------------------------------------------------------------------------
//
//	LbV{[x擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::GetVolumeCache(DWORD nUnit, TCHAR* szLabel)
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	return m_ppBase[nUnit]->GetVolumeCache(szLabel);
}

//---------------------------------------------------------------------------
//
//	eʂ̎擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CHostEntry::GetCapacity(DWORD nUnit, Human68k::capacity_t* pCapacity)
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	return m_ppBase[nUnit]->GetCapacity(pCapacity);
}

//---------------------------------------------------------------------------
//
//	LbVNX^TCY擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostEntry::GetCapacityCache(DWORD nUnit, Human68k::capacity_t* pCapacity)
{
	ASSERT(this);
	ASSERT(m_ppBase);
	ASSERT(nUnit < CWinFileSys::DrvMax);
	ASSERT(m_ppBase[nUnit]);

	return m_ppBase[nUnit]->GetCapacityCache(pCapacity);
}

//---------------------------------------------------------------------------
//
//	t@CVXeԒʒm
//
//---------------------------------------------------------------------------
void FASTCALL CHostEntry::ShellNotify(DWORD nEvent, const TCHAR* szPath)
{
	ASSERT(this);
	ASSERT(m_ppBase);

	// Y郆jbg (dwl)
	for (int n = 0; n < CWinFileSys::DrvMax; n++) {
		if (m_ppBase[n]) {
			if (m_ppBase[n]->isSameDrive(szPath)) {
				// ro
				if (nEvent & (SHCNE_MEDIAREMOVED | SHCNE_DRIVEREMOVED)) {
					m_ppBase[n]->SetEnable(FALSE);
				}

				// }
				if (nEvent & (SHCNE_MEDIAINSERTED | SHCNE_DRIVEADD)) {
					m_ppBase[n]->SetEnable(TRUE);
				}

				// YLbV
				LockCache();
				EraseCache(n);
				UnlockCache();
			}
		}
	}
}

//---------------------------------------------------------------------------
//
//	Human68ktpXŌ̗vf𕪗
//
//---------------------------------------------------------------------------
const BYTE* FASTCALL CHostEntry::SeparatePath(const BYTE* szHuman)
{
	ASSERT(szHuman);

	DWORD nMax = 22;
	const BYTE* p = szHuman;

	BYTE c = *p;
	if (c != '/' && c != '\\') return NULL;	// G[: sȃpX

	// 񒆂̍Ō /  \ B
	const BYTE* pCut = NULL;
	for (;;) {
		c = *p;
		if (c == '\0') break;
		if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
			p++;
			if (*p == '\0') break;
		}
		if (c == '/' || c == '\\') {
			if (pCut == p - 1) return NULL;	// 2Aċ؂蕶G[
			pCut = p;
		}
		p++;
	}

	// \ǂmF
	if (pCut == NULL) return NULL;			// Ȃꍇ̓G[
	//if (pCut == szHuman) return NULL;		// 擪([g)ꍇ ʈȂ
	//if (pCut[1] == '\0') return NULL;		// t@CȂꍇ ʈȂ
	if (strlen((char*)pCut + 1) > nMax) return NULL;	// t@Cꍇ̓G[

	return pCut;
}

//---------------------------------------------------------------------------
//
//	Human68ktpX擪̗vf𕪗ERs[
//
//	Human68kpX͕K / ŊJn邱ƁB
//	r / 2ȏAďoꍇ̓G[ƂB
//	I[ / ̏ꍇA̕ƂďBG[ɂ͂ȂB
//
//---------------------------------------------------------------------------
const BYTE* FASTCALL CHostEntry::SeparateCopyFilename(const BYTE* szHuman, BYTE* szBuffer)
{
	ASSERT(szHuman);
	ASSERT(szBuffer);

	DWORD nMax = 22;
	const BYTE* p = szHuman;

	BYTE c = *p;
	if (c != '/' && c != '\\') return NULL;	// G[: sȃpX
	p++;

	// t@C
	BYTE* pWrite = szBuffer;
	DWORD i = 0;
	for (;;) {
		c = *p;								// ꕶǂݍ i߂
		if (c == '\0') break;				// I[ȂI
		if (c == '/' || c == '\\') {
			if (pWrite == szBuffer) return NULL;	// G[: pX؂蕶AĂ
			break;	// pX̋؂ǂ񂾂I
		}
		p++;

		if (i >= nMax) return NULL;	// G[: 1oCgڂobt@I[ɂ
		i++;								// ޑOɏI[`FbN
		*pWrite++ = c;						// ꕶ

		if ((0x80 <= c && c <= 0x9F) || 0xE0 <= c) {	// ɂ 0x81`0x9F 0xE0`0xEF
			c = *p;							// ꕶǂݍ i߂
			if (c < 0x40) return NULL;		// G[: sSJIS2oCg
			p++;

			if (i >= nMax) return NULL;	// G[: 2oCgڂobt@I[ɂ
			i++;							// ޑOɏI[`FbN
			*pWrite++ = c;					// ꕶ
		}
	}
	*pWrite = '\0';

	return p;
}

//===========================================================================
//
//	t@C
//
//	Human68k̃t@CUnicodeŏ̂͐LcB
//	킯ŁASBYTEɕϊďBϊ̓fBNgG
//	gLbVɒSAWINDRVׂ͂ăVtgJIŜ݂ň
//	悤ɂB
//	܂AHuman68k̂́ASɃx[XpXw肩ƗB
//
//	t@COɁAfBNgGg̃LbV𐶐B
//	fBNgGg͍̐RXĝ߁ALbV\z
//	OVMXbh̓JnB
//
//	t@C3BׂCHostFiles::Find()ŏB
//	1. pX̂݌ ̓fBNĝ	_CHKDIR _CREATE
//	2. pX+t@C+̌ _OPEN
//	3. pX+ChJ[h+̌ _FILES _NFILES
//	ʂ́AfBNgGgƂĕێĂB
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	NA
//
//---------------------------------------------------------------------------
void FASTCALL CHostFiles::Clear()
{
	ASSERT(this);

	m_nKey = 0;
#if 0
	// : SetPath()Őݒ肳邽ߕsv
	m_nHumanUnit = 0;
	m_szHumanPath[0] = '\0';
	m_szHumanFilename[0] = '\0';
	m_nHumanWildcard = 0;
	m_nHumanAttribute = 0;
	m_findNext.Clear();
#endif
	memset(&m_dirEntry, 0, sizeof(m_dirEntry));
	m_szHumanResult[0] = '\0';
	m_szWin32Result[0] = _T('\0');
}

//---------------------------------------------------------------------------
//
//	pXEt@CŐ
//
//---------------------------------------------------------------------------
void FASTCALL CHostFiles::SetPath(DWORD nUnit, const Human68k::namests_t* pNamests)
{
	ASSERT(this);
	ASSERT(pNamests);

	m_nHumanUnit = nUnit;
	pNamests->GetCopyPath(m_szHumanPath);
	pNamests->GetCopyFilename(m_szHumanFilename);
	m_nHumanWildcard = 0;
	m_nHumanAttribute = Human68k::AT_ARCHIVE;
	m_findNext.Clear();
}

//---------------------------------------------------------------------------
//
//	Win32 (pX + t@C(ȗ) + )
//
//	炩ߑSĂHuman68kpp[^ݒ肵ĂƁB
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostFiles::Find(CWindrv* ps, CHostEntry* pEntry, BOOL bRemove)
{
	ASSERT(this);
	ASSERT(pEntry);

	// r Jn
	pEntry->LockCache();

	// pXlуLbV\z
	CHostPath* pPath;
#ifdef XM6_HOST_STRICT_CACHE_CHECK
	pPath = pEntry->MakeCache(ps, m_nHumanUnit, m_szHumanPath, m_szWin32Result);
#else // XM6_HOST_STRICT_CACHE_CHECK
	pPath = pEntry->CopyCache(m_nHumanUnit, m_szHumanPath, m_szWin32Result);
	if (pPath == NULL) {
		pPath = pEntry->MakeCache(ps, m_nHumanUnit, m_szHumanPath, m_szWin32Result);
	}
#endif // XM6_HOST_STRICT_CACHE_CHECK
	if (pPath == NULL) {
		pEntry->UnlockCache();
		return FALSE;	// G[: LbV\zs
	}

	// t@CȂΏI
	if (m_nHumanWildcard == 0xFF) {
		_tcscpy(m_szWin32Result, pPath->GetWin32());
		_tcscat(m_szWin32Result, _T("\\"));
		pEntry->UnlockCache();
		return TRUE;	// I: pX̂
	}

	// t@Cl
	CHostFilename* pFilename;
	if (m_nHumanWildcard == 0) {
		pFilename = pPath->FindFilename(m_szHumanFilename, m_nHumanAttribute);
	} else {
		pFilename = pPath->FindFilenameWildcard(m_szHumanFilename, &m_findNext, m_nHumanAttribute);
	}
	if (pFilename == NULL) {
		pEntry->UnlockCache();
		return FALSE;	// G[: t@Clł܂
	}

	// fBNg폜̏ꍇ͂ŃnhJ
	if (bRemove) pFilename->DeleteCache();

	// Human68kt@Cۑ
	memcpy(&m_dirEntry, pFilename->GetEntry(), sizeof(m_dirEntry));

	// Human68kt@Cۑ
	strcpy((char*)m_szHumanResult, (char*)pFilename->GetHuman());

	// Win32tpXۑ
	_tcscpy(m_szWin32Result, pPath->GetWin32());
	_tcscat(m_szWin32Result, _T("\\"));
	_tcscat(m_szWin32Result, pFilename->GetWin32());

	// r I
	pEntry->UnlockCache();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Win32Ƀt@Cǉ
//
//---------------------------------------------------------------------------
void FASTCALL CHostFiles::AddFilename()
{
	ASSERT(this);
	ASSERT(_tcslen(m_szWin32Result) + strlen((char*)m_szHumanFilename) < _MAX_PATH);

	// WARNING: UnicodeΉBUnicode̐EɟZ܂ꂽ͂ŕϊsȂ
	_tcscat(m_szWin32Result, (TCHAR*)m_szHumanFilename);
}

//===========================================================================
//
//	t@C̈ }l[W
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	t@C̈  (N)
//
//---------------------------------------------------------------------------
CHostFilesManager::CHostFilesManager()
{
}

//---------------------------------------------------------------------------
//
//	t@C̈ mF (I)
//
//---------------------------------------------------------------------------
CHostFilesManager::~CHostFilesManager()
{
#ifdef _DEBUG
	// ݂̂ȂƂmF
	ASSERT(m_cRingFiles.Next() == &m_cRingFiles);
	ASSERT(m_cRingFiles.Prev() == &m_cRingFiles);

	// Ô(ۂɂ͎gȂ)
	Clean();
#endif // _DEBUG
}

//---------------------------------------------------------------------------
//
//	t@C̈  (hCogݎ)
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilesManager::Init()
{
	ASSERT(this);

	// ݂̂ȂƂmF (Ô)
	ASSERT(m_cRingFiles.Next() == &m_cRingFiles);
	ASSERT(m_cRingFiles.Prev() == &m_cRingFiles);

	// ̂m
	for (int i = 0; i < XM6_HOST_FILES_MAX; i++) {
		CHostFiles* p = new CHostFiles;
		ASSERT(p);
		p->InsertTail(&m_cRingFiles);
	}
}

//---------------------------------------------------------------------------
//
//	t@C̈ J (NEZbg)
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilesManager::Clean()
{
	ASSERT(this);

	// ̂J
	CHostFiles* p;
	while ((p = (CHostFiles*)m_cRingFiles.Next()) != &m_cRingFiles) {
		delete p;
	}
}

//---------------------------------------------------------------------------
//
//	t@C̈ m
//
//---------------------------------------------------------------------------
CHostFiles* FASTCALL CHostFilesManager::Alloc(DWORD nKey)
{
	ASSERT(this);
	ASSERT(nKey != 0);

	// 1I
	CHostFiles* p = (CHostFiles*)m_cRingFiles.Prev();

	// YIuWFNgO擪ֈړ
	p->Insert(&m_cRingFiles);

	// L[ݒ
	p->SetKey(nKey);

	return p;
}

//---------------------------------------------------------------------------
//
//	t@C̈ 
//
//---------------------------------------------------------------------------
CHostFiles* FASTCALL CHostFilesManager::Search(DWORD nKey)
{
	ASSERT(this);
	ASSERT(nKey != 0);

	// YIuWFNg
	for (CHostFiles* p = (CHostFiles*)m_cRingFiles.Next();
		 p != &m_cRingFiles; p = (CHostFiles*)p->Next()) {
		if (p->isSameKey(nKey)) {
			// YIuWFNgO擪ֈړ
			p->Insert(&m_cRingFiles);
			return p;
		}
	}

	return NULL;
}

//---------------------------------------------------------------------------
//
//	t@C̈ J
//
//---------------------------------------------------------------------------
void FASTCALL CHostFilesManager::Free(CHostFiles* p)
{
	ASSERT(this);
	ASSERT(p);

	// ̂̏ (ėp邽ߗ̈J͍sȂȂ)
	p->Free();

	// YIuWFNgOֈړ
	p->InsertTail(&m_cRingFiles);
}

//===========================================================================
//
//	FCB
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	NA
//
//---------------------------------------------------------------------------
void FASTCALL CHostFcb::Clear()
{
	ASSERT(this);

	m_nKey = 0;
	m_nMode = 0;
	m_hFile = INVALID_HANDLE_VALUE;
	m_szFilename[0] = _T('\0');
}

//---------------------------------------------------------------------------
//
//	t@CI[v[h̐ݒ
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostFcb::SetOpenMode(DWORD nHumanMode)
{
	ASSERT(this);

	switch (nHumanMode & 0x0F) {
	case Human68k::OP_READ:
		m_nMode = GENERIC_READ;
		break;
	case Human68k::OP_WRITE:
		m_nMode = GENERIC_WRITE;
		break;
	case Human68k::OP_READWRITE:
		m_nMode = GENERIC_READ | GENERIC_WRITE;
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	t@C̐ݒ
//
//---------------------------------------------------------------------------
void FASTCALL CHostFcb::SetFilename(const TCHAR* szFilename)
{
	ASSERT(this);
	ASSERT(szFilename);
	ASSERT(_tcslen(szFilename) < _MAX_PATH);

	_tcscpy(m_szFilename, szFilename);
}

//---------------------------------------------------------------------------
//
//	t@C쐬
//
//---------------------------------------------------------------------------
HANDLE FASTCALL CHostFcb::Create(DWORD nHumanAttribute, BOOL bForce)
{
	ASSERT(this);
	ASSERT(_tcslen(m_szFilename) > 0);
	ASSERT(m_hFile == INVALID_HANDLE_VALUE);

	// 
	DWORD nAttribute = 0;
	if ((nHumanAttribute & Human68k::AT_DIRECTORY) != 0) return INVALID_HANDLE_VALUE;
	if ((nHumanAttribute & Human68k::AT_SYSTEM) != 0) nAttribute |= FILE_ATTRIBUTE_SYSTEM;
	if ((nHumanAttribute & Human68k::AT_HIDDEN) != 0) nAttribute |= FILE_ATTRIBUTE_HIDDEN;
	if ((nHumanAttribute & Human68k::AT_READONLY) != 0) nAttribute |= FILE_ATTRIBUTE_READONLY;
	if (nAttribute == 0) nAttribute = FILE_ATTRIBUTE_NORMAL;

	DWORD nShare = FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE;
	DWORD nCreation = bForce ? CREATE_ALWAYS : CREATE_NEW;

	// t@CI[v
	m_hFile = ::CreateFile(m_szFilename, m_nMode, nShare, NULL, nCreation, nAttribute, NULL);
	return m_hFile;
}

//---------------------------------------------------------------------------
//
//	t@CI[v/nhl
//
//---------------------------------------------------------------------------
HANDLE FASTCALL CHostFcb::Open()
{
	ASSERT(this);
	ASSERT(_tcslen(m_szFilename) > 0);

	// t@CI[v
	if (m_hFile == INVALID_HANDLE_VALUE) {
		DWORD nShare = FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE;
		DWORD nCreation = OPEN_EXISTING;
		DWORD nAttribute = FILE_ATTRIBUTE_NORMAL;
		m_hFile = ::CreateFile(m_szFilename, m_nMode, nShare, NULL, nCreation, nAttribute, NULL);
	}
	return m_hFile;
}

//---------------------------------------------------------------------------
//
//	t@Cǂݍ
//
//	0oCgǂݍ݂ł퓮ƂB
//	G[̎ -1 ԂB
//
//---------------------------------------------------------------------------
DWORD FASTCALL CHostFcb::ReadFile(void* pBuffer, DWORD nSize)
{
	ASSERT(this);
	ASSERT(pBuffer);
	ASSERT(m_hFile != INVALID_HANDLE_VALUE);

	DWORD nResult;
	BOOL bResult = ::ReadFile(m_hFile, pBuffer, nSize, &nResult, NULL);
	if (bResult == FALSE) nResult = (DWORD)-1;

	return nResult;
}

//---------------------------------------------------------------------------
//
//	t@C
//
//	0oCg݂ł퓮ƂB
//	G[̎ -1 ԂB
//
//---------------------------------------------------------------------------
DWORD FASTCALL CHostFcb::WriteFile(void* pBuffer, DWORD nSize)
{
	ASSERT(this);
	ASSERT(pBuffer);
	ASSERT(m_hFile != INVALID_HANDLE_VALUE);

	DWORD nResult;
	BOOL bResult = ::WriteFile(m_hFile, pBuffer, nSize, &nResult, NULL);
	if (bResult == FALSE) nResult = (DWORD)-1;

	return nResult;
}

//---------------------------------------------------------------------------
//
//	t@C|C^ݒ
//
//	G[̎ -1 ԂB
//
//---------------------------------------------------------------------------
DWORD FASTCALL CHostFcb::SetFilePointer(DWORD nOffset, DWORD nMode)
{
	ASSERT(this);
	ASSERT(nMode == FILE_BEGIN || nMode == FILE_CURRENT || nMode == FILE_END);
	ASSERT(m_hFile != INVALID_HANDLE_VALUE);

	return ::SetFilePointer(m_hFile, nOffset, NULL, nMode);
}

//---------------------------------------------------------------------------
//
//	t@Cݒ
//
//	G[̎ -1 ԂB
//
//---------------------------------------------------------------------------
DWORD FASTCALL CHostFcb::SetFileTime(WORD nFatDate, WORD nFatTime)
{
	ASSERT(this);
	ASSERT(m_hFile != INVALID_HANDLE_VALUE);

	FILETIME lt;
	if (::DosDateTimeToFileTime(nFatDate, nFatTime, &lt) == 0) return (DWORD)-1;
	FILETIME ft;
	if (::LocalFileTimeToFileTime(&lt, &ft) == 0) return (DWORD)-1;

	if (::SetFileTime(m_hFile, NULL, &ft, &ft) == 0) return (DWORD)-1;
	return 0;
}

//---------------------------------------------------------------------------
//
//	t@CN[Y
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHostFcb::Close()
{
	ASSERT(this);

	BOOL bResult = TRUE;

	// t@CN[Y
	if (m_hFile != INVALID_HANDLE_VALUE) {
		bResult = ::CloseHandle(m_hFile);
		// G[CloseFree(ōēxClose) Ƃ̂
		// dCloseȂ悤ɂƐݒ肵Ă
		m_hFile = INVALID_HANDLE_VALUE;
	}

	return bResult;
}

//===========================================================================
//
//	FCB }l[W
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	FCB̈  (N)
//
//---------------------------------------------------------------------------
CHostFcbManager::CHostFcbManager()
{
}

//---------------------------------------------------------------------------
//
//	FCB̈ mF (I)
//
//---------------------------------------------------------------------------
CHostFcbManager::~CHostFcbManager()
{
#ifdef _DEBUG
	// ݂̂ȂƂmF
	ASSERT(m_cRingFcb.Next() == &m_cRingFcb);
	ASSERT(m_cRingFcb.Prev() == &m_cRingFcb);

	// Ô(ۂɂ͎gȂ)
	Clean();
#endif // _DEBUG
}

//---------------------------------------------------------------------------
//
//	FCB̈  (hCogݎ)
//
//---------------------------------------------------------------------------
void FASTCALL CHostFcbManager::Init()
{
	ASSERT(this);

	// ݂̂ȂƂmF
	ASSERT(m_cRingFcb.Next() == &m_cRingFcb);
	ASSERT(m_cRingFcb.Prev() == &m_cRingFcb);

	for (int i = 0; i < XM6_HOST_FCB_MAX; i++) {
		CHostFcb* p = new CHostFcb;
		ASSERT(p);
		p->InsertTail(&m_cRingFcb);
	}
}

//---------------------------------------------------------------------------
//
//	FCB̈ J (NEZbg)
//
//---------------------------------------------------------------------------
void CHostFcbManager::Clean()
{
	ASSERT(this);

	// ̂J
	CHostFcb* p;
	while ((p = (CHostFcb*)m_cRingFcb.Next()) != &m_cRingFcb) {
		delete p;
	}
}

//---------------------------------------------------------------------------
//
//	FCB̈ m
//
//---------------------------------------------------------------------------
CHostFcb* FASTCALL CHostFcbManager::Alloc(DWORD nKey)
{
	ASSERT(this);
	ASSERT(nKey != 0);

	// 1I
	CHostFcb* p = (CHostFcb*)m_cRingFcb.Prev();

	// gpȂG[
	if (p->isSameKey(0) == FALSE) return NULL;

	// YIuWFNgO擪ֈړ
	p->Insert(&m_cRingFcb);

	// L[ݒ
	p->SetKey(nKey);

	return p;
}

//---------------------------------------------------------------------------
//
//	FCB̈ 
//
//---------------------------------------------------------------------------
CHostFcb* FASTCALL CHostFcbManager::Search(DWORD nKey)
{
	ASSERT(this);
	ASSERT(nKey != 0);

	// YIuWFNg
	for (CHostFcb* p = (CHostFcb*)m_cRingFcb.Next();
		 p != &m_cRingFcb; p = (CHostFcb*)p->Next()) {
		if (p->isSameKey(nKey)) {
			// YIuWFNgO擪ֈړ
			p->Insert(&m_cRingFcb);
			return p;
		}
	}

	return NULL;
}

//---------------------------------------------------------------------------
//
//	FCB̈ J
//
//---------------------------------------------------------------------------
void FASTCALL CHostFcbManager::Free(CHostFcb* p)
{
	ASSERT(this);
	ASSERT(p);

	// ̂̏ (ėp邽ߗ̈J͍sȂȂ)
	p->Free();

	// YIuWFNgOֈړ
	p->InsertTail(&m_cRingFcb);
}

//===========================================================================
//
//	Windowst@CVXe
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CWinFileSys::CWinFileSys()
{
	// hCuIuWFNg
	for (int n = 0; n < DrvMax; n++) {
		m_pDrv[n] = NULL;
	}

	// RtBOf[^
	m_bResume = FALSE;
	m_nDrives = 0;

	for (n = 0; n < DrvMax; n++) {
		m_nFlag[n] = 0;
		m_szBase[n][0] = _T('\0');
	}

	// TwentyOneIvVĎ
	m_nKernel = 0;
	m_nKernelSearch = 0;

	// tO
	m_nOptionDefault = 0;
	m_nOption = 0;
	CHostFilename::SetOption(0);
	CHostPath::SetOption(0);
}

//---------------------------------------------------------------------------
//
//	fXgN^
//
//---------------------------------------------------------------------------
CWinFileSys::~CWinFileSys()
{
#ifdef _DEBUG
	int nDrv;

	// IuWFNgmF
	for (nDrv=0; nDrv<DrvMax; nDrv++) {
		// ݂ȂƂmF
		ASSERT(!m_pDrv[nDrv]);

		// Ô(ۂɂ͎gȂ)
		if (m_pDrv[nDrv]) {
			delete m_pDrv[nDrv];
			m_pDrv[nDrv] = NULL;
		}
	}
#endif // _DEBUG
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileSys::ApplyCfg(const Config* pConfig)
{
	ASSERT(this);
	ASSERT(pConfig);

	// RtBOf[^Kp
	m_bResume = pConfig->host_resume;
	m_nDrives = pConfig->host_drives;

	for (int n = 0; n < DrvMax; n++) {
		m_nFlag[n] = pConfig->host_flag[n];
		ASSERT(_tcslen(pConfig->host_path[n]) < _MAX_PATH);
		_tcscpy(m_szBase[n], pConfig->host_path[n]);
	}

	// tOݒ
	m_nOptionDefault = pConfig->host_option;
}

//---------------------------------------------------------------------------
//
//	$40 - 
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWinFileSys::Init(CWindrv* ps, DWORD nDriveMax, const BYTE* pOption)
{
	ASSERT(this);
	ASSERT(nDriveMax < 26);

	// VMXbh̓Jn
	ps->Ready();

	// G[[hݒ
	::SetErrorMode(SEM_FAILCRITICALERRORS | SEM_NOOPENFILEERRORBOX);

	// t@C̈  (hCogݎ)
	m_cFiles.Init();

	// FCB̈  (hCogݎ)
	m_cFcb.Init();

	// fBNgGg  (hCogݎ)
	m_cEntry.Init(m_pDrv);

	// IvV
	InitOption(pOption);

	// ShCuXL̗L𔻒
	DWORD nConfigDrives = m_nDrives;
	if (m_bResume == FALSE) {
		// SRtBO
		for (DWORD i = 0; i < DrvMax; i++) {
			m_nFlag[i] = 0;
			m_szBase[i][0] = _T('\0');
		}

		// ShCuXL
		nConfigDrives = 0;
		DWORD nBits = ::GetLogicalDrives();
		for (DWORD n = 0; n < 26; n++) {
			// rbg`FbN
			if (nBits & 1) {
				// x[XpXݒ
				_stprintf(m_szBase[nConfigDrives], _T("%c:\\"), 'A' + n);

				// tOݒ
				m_nFlag[nConfigDrives] = 0;

				// ̃hCu
				nConfigDrives++;

				// ő吔ɒBĂΏI
				if (nConfigDrives >= DrvMax) break;
			}

			// ̃rbg
			nBits >>= 1;
		}
	}

	// t@CVXeo^
	DWORD nDrives = 0;
	for (DWORD n = 0; n < nConfigDrives; n++) {	// SĂ̗LȃRtBOf[^𒲍
		// x[XpX݂Ȃꍇ͖ȃfoCXƂ݂Ȃ
		if (m_szBase[n][0] == _T('\0')) continue;

		// ȏo^łȂΏI (nDriveMax0̏ꍇ͉o^Ȃ)
		if (nDrives >= nDriveMax) break;

		// zXgt@CVXe1
		ASSERT(m_pDrv[nDrives] == NULL);
		m_pDrv[nDrives] = new CWinFileDrv;
		ASSERT(m_pDrv[nDrives]);

		// 
		m_pDrv[nDrives]->Init(m_szBase[n], m_nFlag[n]);

		// ̃hCu
		nDrives++;
	}

	// o^hCuԂ
	return nDrives;
}

//---------------------------------------------------------------------------
//
//	Zbg(SN[Y)
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileSys::Reset()
{
	int nDrv;

	ASSERT(this);

	// zZN^̈揉
	m_nHostSectorCount = 0;
	memset(m_nHostSectorBuffer, 0, sizeof(m_nHostSectorBuffer));

	// t@C̈ J (NEZbg)
	m_cFiles.Clean();

	// FCB̈ J (NEZbg)
	m_cFcb.Clean();

	// fBNgGg J (NEZbg)
	m_cEntry.Clean();

	// IuWFNg폜
	for (nDrv=0; nDrv<DrvMax; nDrv++) {
		if (m_pDrv[nDrv]) {
			delete m_pDrv[nDrv];
			m_pDrv[nDrv] = NULL;
		}
	}

	// TwentyOneIvVĎ
	m_nKernel = 0;
	m_nKernelSearch = 0;
}

//---------------------------------------------------------------------------
//
//	$41 - fBNg`FbN
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::CheckDir(CWindrv* ps, const Human68k::namests_t* pNamests)
{
	ASSERT(this);
	ASSERT(pNamests);

	// ɕK̃R}hs邽߁AfBA`FbN͕sv
	// Ń`FbNmint̃hCuύXOɖʂȃfBXNANZXĂ܂
	//if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	// ̃fBA`FbNR}hLɂ邽߃tO𗧂Ă
	m_cEntry.SetMediaUpdate(ps, FALSE);
#endif // XM6_HOST_UPDATE_BY_SEQUENCE

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);
	if (f.isRootPath()) return 0;
	f.SetPathOnly();
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_DIRNOTFND;

	return 0;
}

//---------------------------------------------------------------------------
//
//	$42 - fBNg쐬
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::MakeDir(CWindrv* ps, const Human68k::namests_t* pNamests)
{
	ASSERT(this);
	ASSERT(pNamests);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);
	f.SetPathOnly();
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_INVALIDPATH;
	f.AddFilename();

	// fBNg쐬
	BOOL bResult = ::CreateDirectory(f.GetPath(), NULL);
	if (bResult == FALSE) return FS_INVALIDPATH;

	return 0;
}

//---------------------------------------------------------------------------
//
//	$43 - fBNg폜
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::RemoveDir(CWindrv* ps, const Human68k::namests_t* pNamests)
{
	ASSERT(this);
	ASSERT(pNamests);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);

	// fBNgmF
	f.SetAttribute(Human68k::AT_DIRECTORY);
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_DIRNOTFND;

	// fBNg폜
	if ((m_nOption & WINDRV_OPT_REMOVE) == 0) {
		BOOL bResult = ::RemoveDirectory(f.GetPath());
		if (bResult == FALSE) return FS_CANTDELETE;
	} else {
		// fBNg󂩂ǂmF
		TCHAR szBuf[_MAX_PATH];
		_tcscpy(szBuf, f.GetPath());
		_tcscat(szBuf, "\\*.*");
		WIN32_FIND_DATA w32Find;
		HANDLE hFind = ::FindFirstFile(szBuf, &w32Find);
		if (hFind != INVALID_HANDLE_VALUE) {
			for (;;) {
				if (strcmp(w32Find.cFileName, ".") != 0 &&
					strcmp(w32Find.cFileName, "..") != 0) {
					FindClose(hFind);
					return FS_CANTDELETE;
				}
				BOOL bResult = ::FindNextFile(hFind, &w32Find);
				if (bResult == FALSE) break;
			}
			FindClose(hFind);
		}

		// WARNING: UnicodeΉvC
		char szBuffer[_MAX_PATH + 1];
		strcpy(szBuffer, f.GetPath());
		szBuffer[strlen(szBuffer) + 1] = '\0';

		SHFILEOPSTRUCT sop;
		sop.hwnd = NULL;
		sop.wFunc = FO_DELETE;
		sop.pFrom = szBuffer;
		sop.pTo = NULL;
		sop.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_NOERRORUI | FOF_SILENT;
		sop.fAnyOperationsAborted = TRUE;
		sop.hNameMappings = NULL;
		sop.lpszProgressTitle = NULL;

		int nResult = ::SHFileOperation(&sop);
		if (nResult != 0) return FS_CANTDELETE;
	}

	// LbV폜
	f.Find(ps, &m_cEntry, TRUE);

	return 0;
}

//---------------------------------------------------------------------------
//
//	$44 - t@CύX
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Rename(CWindrv* ps, const Human68k::namests_t* pNamests, const Human68k::namests_t* pNamestsNew)
{
	ASSERT(this);
	ASSERT(pNamests);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);
	f.SetAttribute(Human68k::AT_ALL);
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_FILENOTFND;

	CHostFiles fNew;
	fNew.SetPath(nUnit, pNamestsNew);
	fNew.SetPathOnly();
	if (fNew.Find(ps, &m_cEntry) == FALSE) return FS_INVALIDPATH;
	fNew.AddFilename();

	// t@CύX
	BOOL bResult = ::MoveFile(f.GetPath(), fNew.GetPath());
	if (bResult == FALSE) return FS_FILENOTFND;

	return 0;
}

//---------------------------------------------------------------------------
//
//	$45 - t@C폜
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Delete(CWindrv* ps, const Human68k::namests_t* pNamests)
{
	ASSERT(this);
	ASSERT(pNamests);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);

	// t@CmF
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_FILENOTFND;

	// t@C폜
	if ((m_nOption & WINDRV_OPT_REMOVE) == 0) {
		BOOL bResult = ::DeleteFile(f.GetPath());
		if (bResult == FALSE) return FS_CANTDELETE;
	} else {
		// WARNING: UnicodeΉvC
		char szBuffer[_MAX_PATH + 1];
		strcpy(szBuffer, f.GetPath());
		szBuffer[strlen(szBuffer) + 1] = '\0';

		SHFILEOPSTRUCT sop;
		sop.hwnd = NULL;
		sop.wFunc = FO_DELETE;
		sop.pFrom = szBuffer;
		sop.pTo = NULL;
		sop.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_NOERRORUI | FOF_SILENT;
		sop.fAnyOperationsAborted = TRUE;
		sop.hNameMappings = NULL;
		sop.lpszProgressTitle = NULL;

		int nResult = ::SHFileOperation(&sop);
		if (nResult != 0) return FS_CANTDELETE;
	}

	return 0;
}

//---------------------------------------------------------------------------
//
//	$46 - t@C擾/ݒ
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Attribute(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nHumanAttribute)
{
	ASSERT(this);
	ASSERT(pNamests);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);
	f.SetAttribute(Human68k::AT_ALL);
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_FILENOTFND;

	// 擾ȂI
	if (nHumanAttribute == 0xFF) {
		return f.GetAttribute();
	}

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

#if 0
	if (f.GetAttribute() & Human68k::AT_DIRECTORY) {
		if ((nHumanAttribute & Human68k::AT_DIRECTORY) == 0) {
			OutputDebugString("Warning: fBNg̑t@CɕύXł܂\r\n");
		}
	}

	if ((f.GetAttribute() & Human68k::AT_DIRECTORY) == 0) {
		if (nHumanAttribute & Human68k::AT_DIRECTORY) {
			OutputDebugString("Warning: t@C̑fBNgɕύXł܂\r\n");
		}
	}
#endif

	// 
	DWORD nAttribute = 0;
	if ((nHumanAttribute & Human68k::AT_SYSTEM) != 0) nAttribute |= FILE_ATTRIBUTE_SYSTEM;
	if ((nHumanAttribute & Human68k::AT_HIDDEN) != 0) nAttribute |= FILE_ATTRIBUTE_HIDDEN;
	if ((nHumanAttribute & Human68k::AT_READONLY) != 0) nAttribute |= FILE_ATTRIBUTE_READONLY;
	if (nAttribute == 0) nAttribute = FILE_ATTRIBUTE_NORMAL;

	// ݒ
	BOOL bResult = ::SetFileAttributes(f.GetPath(), nAttribute);
	if (bResult == FALSE) return FS_FILENOTFND;

	// ύX̑擾
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_FILENOTFND;
	return f.GetAttribute();
}

//---------------------------------------------------------------------------
//
//	$47 - t@C(First)
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Files(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::files_t* pFiles)
{
	ASSERT(this);
	ASSERT(pNamests);
	ASSERT(nKey);
	ASSERT(pFiles);

	// ɓL[̈悪ΊJĂ
	CHostFiles* pHostFiles = m_cFiles.Search(nKey);
	if (pHostFiles != NULL) {
		m_cFiles.Free(pHostFiles);
	}

	// {[x̏ꍇ
	if (pFiles->fatr == Human68k::AT_VOLUME) {
		// obt@mۂAȂ茋ʂԂ
		if (FilesVolume(ps, pFiles) == FALSE) {
			return FS_FILENOTFND;
		}
		return 0;
	}

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// obt@m
	pHostFiles = m_cFiles.Alloc(nKey);
	if (pHostFiles == NULL) {
		return FS_OUTOFMEM;
	}

	// fBNg`FbN
	DWORD nUnit = ps->GetUnit();
	pHostFiles->SetPath(nUnit, pNamests);
	if (pHostFiles->isRootPath() == FALSE) {
		pHostFiles->SetPathOnly();
		if (pHostFiles->Find(ps, &m_cEntry) == FALSE) {
			m_cFiles.Free(pHostFiles);
			return FS_DIRNOTFND;
		}
	}

	// ChJ[hgp\ɐݒ
	pHostFiles->SetPathWildcard();
	pHostFiles->SetAttribute(pFiles->fatr);

	// t@C
	if (pHostFiles->Find(ps, &m_cEntry) == FALSE) {
		m_cFiles.Free(pHostFiles);
		return FS_FILENOTFND;
	}

	// ʂi[
	pFiles->attr = (BYTE)pHostFiles->GetAttribute();
	pFiles->date = pHostFiles->GetDate();
	pFiles->time = pHostFiles->GetTime();
	pFiles->size = pHostFiles->GetSize();
	strcpy((char*)pFiles->full, (char*)pHostFiles->GetHumanResult());

	// [fBNgGgw
	pFiles->sector = nKey;
	pFiles->offset = 0;

	// t@CɃChJ[hȂ΁A̎_Ńobt@J\
	if (pNamests->wildcard == 0) {
		// AzZN^̃G~[VŎg\邽߁Aɂ͊JȂ
		//m_cFiles.Free(pHostFiles);
	}

	return 0;
}

//---------------------------------------------------------------------------
//
//	$48 - t@C(Next)
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::NFiles(CWindrv* ps, DWORD nKey, Human68k::files_t* pFiles)
{
	ASSERT(this);
	ASSERT(nKey);
	ASSERT(pFiles);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// obt@
	CHostFiles* pHostFiles = m_cFiles.Search(nKey);
	if (pHostFiles == NULL) {
		return FS_FILENOTFND;
	}

	// t@C
	if (pHostFiles->Find(ps, &m_cEntry) == FALSE) {
		m_cFiles.Free(pHostFiles);
		return FS_FILENOTFND;
	}

	// ʂi[
	pFiles->attr = (BYTE)pHostFiles->GetAttribute();
	pFiles->date = pHostFiles->GetDate();
	pFiles->time = pHostFiles->GetTime();
	pFiles->size = pHostFiles->GetSize();
	strcpy((char*)pFiles->full, (char*)pHostFiles->GetHumanResult());

	return 0;
}

//---------------------------------------------------------------------------
//
//	$49 - t@CVK쐬
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Create(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nHumanAttribute, BOOL bForce)
{
	ASSERT(this);
	ASSERT(pNamests);
	ASSERT(nKey);
	ASSERT(pFcb);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// ɓL[̈悪΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb != NULL) return FS_FILEEXIST;

	// t@C㏑`FbN
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);

	// pX
	f.SetPathOnly();
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_INVALIDPATH;
	f.AddFilename();

	// pXۑ
	pHostFcb = m_cFcb.Alloc(nKey);
	if (pHostFcb == NULL) return FS_OUTOFMEM;
	pHostFcb->SetFilename(f.GetPath());

	// I[v[hݒ
	pFcb->mode = (pFcb->mode & ~0x0F) | Human68k::OP_READWRITE;
	if (pHostFcb->SetOpenMode(pFcb->mode) == FALSE) {
		m_cFcb.Free(pHostFcb);
		return FS_ILLEGALMOD;
	}

	// t@C쐬
	HANDLE hFile = pHostFcb->Create(nHumanAttribute, bForce);
	if (hFile == INVALID_HANDLE_VALUE) {
		m_cFcb.Free(pHostFcb);
		return FS_FILEEXIST;
	}

#ifdef XM6_HOST_STRICT_CLOSE
	// 
	pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE

	return 0;
}

//---------------------------------------------------------------------------
//
//	$4A - t@CI[v
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Open(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::fcb_t* pFcb)
{
	ASSERT(this);
	ASSERT(pNamests);
	ASSERT(nKey);
	ASSERT(pFcb);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	switch (pFcb->mode) {
	case Human68k::OP_WRITE:
	case Human68k::OP_READWRITE:
		if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;
	}

	// ɓL[̈悪΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb != NULL) return FS_FILEEXIST;

	// pX
	CHostFiles f;
	DWORD nUnit = ps->GetUnit();
	f.SetPath(nUnit, pNamests);

	// t@C擾
	if (f.Find(ps, &m_cEntry) == FALSE) return FS_FILENOTFND;

	// ^CX^v
	pFcb->date = f.GetDate();
	pFcb->time = f.GetTime();

	// t@CTCY
	pFcb->size = f.GetSize();

	// pXۑ
	pHostFcb = m_cFcb.Alloc(nKey);
	if (pHostFcb == NULL) return FS_OUTOFMEM;
	pHostFcb->SetFilename(f.GetPath());

	// I[v[hݒ
	if (pHostFcb->SetOpenMode(pFcb->mode) == FALSE) {
		m_cFcb.Free(pHostFcb);
		return FS_ILLEGALMOD;
	}

	// t@CI[v
	HANDLE hFile = pHostFcb->Open();
	if (hFile == INVALID_HANDLE_VALUE) {
		m_cFcb.Free(pHostFcb);
		return FS_INVALIDPATH;
	}

#ifdef XM6_HOST_STRICT_CLOSE
	// 
	pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE

	return 0;
}

//---------------------------------------------------------------------------
//
//	$4B - t@CN[Y
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Close(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb)
{
	ASSERT(this);
	ASSERT(nKey);
	ASSERT(pFcb);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ɓL[̈悪Ȃ΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb == NULL) return FS_INVALIDPRM;

	// t@CN[YƗ̈J
	//pHostFcb->Close();	// FreeɎŝŕsv
	m_cFcb.Free(pHostFcb);

	return 0;
}

//---------------------------------------------------------------------------
//
//	$4C - t@Cǂݍ
//
//	0oCgǂݍ݂łIB
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Read(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAddress, DWORD nSize)
{
	ASSERT(this);
	ASSERT(nKey);
	ASSERT(pFcb);
	ASSERT(nAddress);

	Memory* pMemory = ps->GetMemory();
	ASSERT(pMemory);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ɓL[̈悪Ȃ΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb == NULL) return FS_NOTOPENED;

	// t@CI[v/nhl
	HANDLE hFile = pHostFcb->Open();
	if (hFile == INVALID_HANDLE_VALUE) {
		m_cFcb.Free(pHostFcb);
		return FS_NOTOPENED;
	}

	DWORD nResult;
#ifdef XM6_HOST_STRICT_CLOSE
	// t@C|C^
	nResult = pHostFcb->SetFilePointer(pFcb->fileptr);
	if (nResult == (DWORD)-1) {
		m_cFcb.Free(pHostFcb);
		return FS_CANTSEEK;
	}
#endif // XM6_HOST_STRICT_CLOSE

	// t@Cǂݍ
	DWORD nTotal = 0;
	BYTE chBuffer[XM6_HOST_FILE_BUFFER_READ];
	for (DWORD nOffset = 0; nOffset < nSize; nOffset += XM6_HOST_FILE_BUFFER_READ) {
		// TCY傫ꍇVMXbh̓Jn
		if (nOffset == XM6_HOST_FILE_BUFFER_READ) ps->Ready();

		// TCY
		DWORD n = nSize - nOffset;
		if (n > XM6_HOST_FILE_BUFFER_READ) n = XM6_HOST_FILE_BUFFER_READ;

		// ǂݍ
		nResult = pHostFcb->ReadFile(chBuffer, n);
		if (nResult == (DWORD)-1) {
			m_cFcb.Free(pHostFcb);
			return FS_INVALIDFUNC;
		}

		ps->LockXM();

#if 0
		// 8rbgPʂŃf[^]
		for (DWORD i = 0; i < nResult; i++) pMemory->WriteByte(nAddress++, chBuffer[i]);
#else
		// 擪AhXȂŏ1oCg]
		BYTE* pBuffer = chBuffer;
		DWORD nEnd = nAddress + nResult;
		if (nAddress < nEnd && (nAddress & 1) != 0)
			pMemory->WriteByte(nAddress++, *pBuffer++);

		// 16rbgPʂŃf[^]
		DWORD nEndWord = nEnd & ~1;
		while (nAddress < nEndWord) {
			DWORD nData = (*pBuffer++)<<8;
			nData |= *pBuffer++;
			pMemory->WriteWord(nAddress, nData);
			nAddress += 2;
		}

		// f[^cĂ(AhXȂ̂)Ō1oCg]
		if (nAddress < nEnd) pMemory->WriteByte(nAddress++, *pBuffer);
#endif

		ps->UnlockXM();

		// TCYWv
		nTotal += nResult;

		// t@CI[ȂI
		if (nResult != n) break;
	}

	// t@C|C^ۑ
	pFcb->fileptr += nTotal;

#ifdef XM6_HOST_STRICT_CLOSE
	// 
	pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE

	return nTotal;
}

//---------------------------------------------------------------------------
//
//	$4D - t@C
//
//	0oCg݂łIB
//	WARNING: oXG[AhXw肵ꍇA@Ɠ삪قȂ\
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Write(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAddress, DWORD nSize)
{
	ASSERT(this);
	ASSERT(nKey);
	ASSERT(pFcb);
	ASSERT(nAddress);

	Memory* pMemory = ps->GetMemory();
	ASSERT(pMemory);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ɓL[̈悪Ȃ΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb == NULL) return FS_NOTOPENED;

	// t@CI[v/nhl
	HANDLE hFile = pHostFcb->Open();
	if (hFile == INVALID_HANDLE_VALUE) {
		m_cFcb.Free(pHostFcb);
		return FS_NOTOPENED;
	}

	DWORD nResult;
#ifdef XM6_HOST_STRICT_CLOSE
	// t@C|C^
	nResult = pHostFcb->SetFilePointer(pFcb->fileptr);
	if (nResult == (DWORD)-1) {
		m_cFcb.Free(pHostFcb);
		return FS_CANTSEEK;
	}
#endif // XM6_HOST_STRICT_CLOSE

	// t@C
	DWORD nTotal = 0;
	BYTE chBuffer[XM6_HOST_FILE_BUFFER_WRITE];
	for (DWORD nOffset = 0; nOffset < nSize; nOffset += XM6_HOST_FILE_BUFFER_WRITE) {
		// TCY傫ꍇVMXbh̓Jn
		if (nOffset == XM6_HOST_FILE_BUFFER_WRITE) ps->Ready();

		// TCY
		DWORD n = nSize - nOffset;
		if (n > XM6_HOST_FILE_BUFFER_WRITE) n = XM6_HOST_FILE_BUFFER_WRITE;

		ps->LockXM();

#if 0
		// f[^]
		for (DWORD i = 0; i < n; i++) chBuffer[i] = (BYTE)pMemory->ReadOnly(nAddress++);
#else
		// 擪AhXȂŏ1oCg]
		BYTE* pBuffer = chBuffer;
		DWORD nEnd = nAddress + n;
		if (nAddress < nEnd && (nAddress & 1) != 0)
			*pBuffer++ = (BYTE)pMemory->ReadOnly(nAddress++);

		// 16rbgPʂŃf[^]
		DWORD nEndWord = nEnd & ~1;
		while (nAddress < nEndWord) {
			DWORD nData = pMemory->ReadWord(nAddress);
			*pBuffer++ = (BYTE)(nData>>8);
			*pBuffer++ = (BYTE)nData;
			nAddress += 2;
		}

		// f[^cĂ(AhXȂ̂)Ō1oCg]
		if (nAddress < nEnd) *pBuffer = (BYTE)pMemory->ReadOnly(nAddress++);
#endif

		ps->UnlockXM();

		// 
		nResult = pHostFcb->WriteFile(chBuffer, n);
		if (nResult == (DWORD)-1) {
			m_cFcb.Free(pHostFcb);
			return FS_CANTWRITE;
		}

		// TCYWv
		nTotal += nResult;

		// t@CI[ȂI
		if (nResult != n) break;
	}

	// t@C|C^ۑ
	pFcb->fileptr += nTotal;

	// t@CTCYXV
	if (pFcb->size < pFcb->fileptr) pFcb->size = pFcb->fileptr;

#ifdef XM6_HOST_STRICT_CLOSE
	// 
	pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE

	return nTotal;
}

//---------------------------------------------------------------------------
//
//	$4E - t@CV[N
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Seek(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nMode, int nOffset)
{
	ASSERT(this);
	ASSERT(pFcb);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ɓL[̈悪Ȃ΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb == NULL) return FS_NOTOPENED;

	// p[^
	DWORD nSeek;
	switch (nMode) {
	case Human68k::SK_BEGIN:
		nSeek = FILE_BEGIN;
		break;
	case Human68k::SK_CURRENT:
#ifdef XM6_HOST_STRICT_CLOSE
		nSeek = FILE_BEGIN;
		nOffset += pFcb->fileptr;
#else // XM6_HOST_STRICT_CLOSE
		nSeek = FILE_CURRENT;
#endif // XM6_HOST_STRICT_CLOSE
		break;
	case Human68k::SK_END:
		nSeek = FILE_END;
		break;
	default:
		m_cFcb.Free(pHostFcb);
		return FS_CANTSEEK;
	}

	// t@CI[v/nhl
	HANDLE hFile = pHostFcb->Open();
	if (hFile == INVALID_HANDLE_VALUE) {
		m_cFcb.Free(pHostFcb);
		return FS_NOTOPENED;
	}

	// t@CV[N
	DWORD nResult = pHostFcb->SetFilePointer(nOffset, nSeek);
	if (nResult == (DWORD)-1) {
		m_cFcb.Free(pHostFcb);
		return FS_CANTSEEK;
	}

	// t@C|C^ۑ
	pFcb->fileptr = nResult;

#ifdef XM6_HOST_STRICT_CLOSE
	//
	pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE

	return nResult;
}

//---------------------------------------------------------------------------
//
//	$4F - t@C擾/ݒ
//
//	ʂ̏16Bit$FFFFƃG[B
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWinFileSys::TimeStamp(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, WORD nFatDate, WORD nFatTime)
{
	ASSERT(this);
	ASSERT(nKey);
	ASSERT(pFcb);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// 擾̂
	if (nFatDate == 0 && nFatTime == 0) {
		return ((DWORD)pFcb->date << 16) | pFcb->time;
	}

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// ɓL[̈悪Ȃ΃G[Ƃ
	CHostFcb* pHostFcb = m_cFcb.Search(nKey);
	if (pHostFcb == NULL) return FS_NOTOPENED;

	// Human68kł́Aǂݍ݃I[vł^CX^v삪\ɂȂĂ邽
	// ǂݍ݃I[[hŊJĂAꎞIɏ݃[hŊJȂ
	BOOL bReopen = FALSE;
	if ((pFcb->mode & 0x0F) == Human68k::OP_READ) {
		bReopen = TRUE;
#ifndef XM6_HOST_STRICT_CLOSE
		pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE
		pHostFcb->SetOpenMode(Human68k::OP_READWRITE);
	}

	// t@CI[v/nhl
	HANDLE hFile = pHostFcb->Open();
	if (hFile == INVALID_HANDLE_VALUE) {
		m_cFcb.Free(pHostFcb);
		return FS_NOTOPENED;
	}

	// ݒ
	if (pHostFcb->SetFileTime(nFatDate, nFatTime) == (DWORD)-1) {
		m_cFcb.Free(pHostFcb);
		return FS_CANTWRITE;
	}

	// ꎞIɏ݃[hŊJȂꍇ͌ɖ߂
	if (bReopen) {
		pHostFcb->SetOpenMode(pFcb->mode);
#ifndef XM6_HOST_STRICT_CLOSE
		pHostFcb->Close();
		hFile = pHostFcb->Open();
		if (hFile == INVALID_HANDLE_VALUE) {
			m_cFcb.Free(pHostFcb);
			return FS_NOTOPENED;
		}
		DWORD nResult = pHostFcb->SetFilePointer(pFcb->fileptr);
		if (nResult == (DWORD)-1) {
			m_cFcb.Free(pHostFcb);
			return FS_CANTSEEK;
		}
#endif // XM6_HOST_STRICT_CLOSE
	}

#ifdef XM6_HOST_STRICT_CLOSE
	// 
	pHostFcb->Close();
#endif // XM6_HOST_STRICT_CLOSE

	return 0;
}

//---------------------------------------------------------------------------
//
//	$50 - eʎ擾
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::GetCapacity(CWindrv* ps, Human68k::capacity_t* pCapacity)
{
	ASSERT(this);
	ASSERT(pCapacity);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// eʎ擾
	DWORD nUnit = ps->GetUnit();
	return m_cEntry.GetCapacity(nUnit, pCapacity);
}

//---------------------------------------------------------------------------
//
//	$51 - hCuԌ/
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::CtrlDrive(CWindrv* ps, Human68k::ctrldrive_t* pCtrlDrive)
{
	ASSERT(this);
	ASSERT(pCtrlDrive);

	DWORD nUnit = ps->GetUnit();

	switch (pCtrlDrive->status) {
	case 0:		// Ԍ
	case 9:		// Ԍ2
		pCtrlDrive->status = (BYTE)m_cEntry.GetStatus(nUnit);
		return pCtrlDrive->status;

	case 1:		// CWFNg
		m_cEntry.isMediaOffline(ps, FALSE);	// CWFNgɃ`FbN̂ŎO`FbNsv
		m_cEntry.Eject(nUnit);
		return 0;

	case 2:		// CWFNg֎~1 ()
	case 3:		// CWFNg1 ()
	case 4:		// fBA}LED_ ()
	case 5:		// fBA}LED ()
	case 6:		// CWFNg֎~2 ()
	case 7:		// CWFNg2 ()
		return 0;

	case 8:		// CWFNg
		return 1;
	}

	return FS_INVALIDFUNC;
}

//---------------------------------------------------------------------------
//
//	$52 - DPB擾
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::GetDPB(CWindrv* ps, Human68k::dpb_t* pDpb)
{
	ASSERT(this);
	ASSERT(pDpb);

	DWORD nUnit = ps->GetUnit();

	// ZN^l
	Human68k::capacity_t cap;
	BOOL bResult = m_cEntry.GetCapacityCache(nUnit, &cap);
	if (bResult == FALSE) {
		// fBA`FbN
		m_cEntry.isMediaOffline(ps);

		// hCuԎ擾
		m_cEntry.GetCapacity(nUnit, &cap);
	}

	// VtgvZ
	DWORD nSize = 1;
	DWORD nShift = 0;
	for (;;) {
		if (nSize >= cap.sectors) break;
		nSize <<= 1;
		nShift++;
	}

	// ZN^ԍvZ
	//
	// ȉ̏ɕׂB
	//	NX^0:gp
	//	NX^1:FAT
	//	NX^2:[gfBNg
	//	NX^3:f[^̈([ZN^)
	DWORD nFat = 1 * cap.sectors;
	DWORD nRoot = 2 * cap.sectors;
	DWORD nData = 3 * cap.sectors;

	// DPBݒ
	pDpb->sector_size = (WORD)cap.bytes;		// + 0	1ZN^̃oCg
	pDpb->cluster_size = (BYTE)cap.sectors - 1;	// + 2	1NX^̃ZN^ - 1
	pDpb->shift = (BYTE)nShift;					// + 3	NX^ZN^̃Vtg
	pDpb->fat_sector = (WORD)nFat;				// + 4	FAT ̐擪ZN^ԍ
	pDpb->fat_max = 1;							// + 6	FAT ̈̌
	pDpb->fat_size = (BYTE)cap.sectors;			// + 7	FAT ̐߂ZN^(ʕ)
	pDpb->file_max =							// + 8	[gfBNgɓt@Č
		(WORD)(cap.sectors * cap.bytes / 0x20);
	pDpb->data_sector = (WORD)nData;		   	// +10	f[^̈̐擪ZN^ԍ
	pDpb->cluster_max =	(WORD)cap.clusters;		// +12	NX^ + 1
	pDpb->root_sector = (WORD)nRoot;			// +14	[gfBNg̐擪ZN^ԍ
	pDpb->media = 0xF3;							// +20	fBAoCg

	// fBAoCgύX
	if (m_nOption & WINDRV_OPT_MEDIABYTE) {
		pDpb->media = m_cEntry.GetMediaByte(nUnit);
	}

	return 0;
}

//---------------------------------------------------------------------------
//
//	$53 - ZN^ǂݍ
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::DiskRead(CWindrv* ps, DWORD nAddress, DWORD nSector, DWORD nSize)
{
	ASSERT(this);
	ASSERT(nAddress);

	Memory* pMemory = ps->GetMemory();
	ASSERT(pMemory);

	DWORD nUnit = ps->GetUnit();

	// ZN^1ȊȌꍇ̓G[
	if (nSize != 1) return FS_NOTIOCTRL;

	// ZN^l
	Human68k::capacity_t cap;
	BOOL bResult = m_cEntry.GetCapacityCache(nUnit, &cap);
	if (bResult == FALSE) {
		// fBA`FbN
		m_cEntry.isMediaOffline(ps);

		// hCuԎ擾
		m_cEntry.GetCapacity(nUnit, &cap);
	}

	// [fBNgGgւ̃ANZX
	CHostFiles* pHostFiles = m_cFiles.Search(nSector);
	if (pHostFiles) {
		// [fBNgGg𐶐
		// WARNING: gGfBAp
		Human68k::dirent_t dir;
		memcpy(&dir, pHostFiles->GetEntry(), sizeof(dir));

		// [fBNgGgɃt@Ĉw[ZN^ԍL^
		// ȂAlzdsys ł͈ȉ̎œǂݍ݃ZN^ԍZoĂB
		// (dirent.cluster - 2) * (dpb.cluster_size + 1) + dpb.data_sector
		dir.cluster = (WORD)(m_nHostSectorCount + 2);	// [ZN^ԍ
		m_nHostSectorBuffer[m_nHostSectorCount] = nSector;	// [ZN^̎w
		m_nHostSectorCount++;
		m_nHostSectorCount %= XM6_HOST_PSEUDO_CLUSTER_MAX;

		ps->LockXM();

		// [fBNgGg]
		BYTE* p = (BYTE*)&dir;
		for (int i = 0; i < 0x20; i++) pMemory->WriteByte(nAddress++, *p++);
		for (i = 0x20; i < 0x200; i++) pMemory->WriteByte(nAddress++, 0xFF);

		ps->UnlockXM();

		return 0;
	}

	// NX^ԍZN^ԍZo
	DWORD n = nSector - (3 * cap.sectors);
	DWORD nMod = 1;
	if (cap.sectors) {
		// fBA݂Ȃꍇ cap.sectors 0ɂȂ̂Œ
		nMod = n % cap.sectors;
		n /= cap.sectors;
	}

	// t@Ĉւ̃ANZX
	if (nMod == 0 && n < XM6_HOST_PSEUDO_CLUSTER_MAX) {
		pHostFiles = m_cFiles.Search(m_nHostSectorBuffer[n]);	// ̂
		if (pHostFiles) {
			// fBA`FbN
			if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

			// [ZN^𐶐
			CHostFcb f;
			f.SetFilename(pHostFiles->GetPath());
			f.SetOpenMode(Human68k::OP_READ);
			HANDLE hFile = f.Open();
			if (hFile == INVALID_HANDLE_VALUE) return FS_NOTIOCTRL;
			BYTE chBuffer[512];
			memset(chBuffer, 0, sizeof(chBuffer));
			DWORD nResult = f.ReadFile(chBuffer, 512);
			f.Close();
			if (nResult == (DWORD)-1) return FS_NOTIOCTRL;

			ps->LockXM();

			// [ZN^]
			for (int i = 0; i < 0x200; i++) pMemory->WriteByte(nAddress++, chBuffer[i]);

			ps->UnlockXM();

			return 0;
		}
	}

	return FS_NOTIOCTRL;
}

//---------------------------------------------------------------------------
//
//	$54 - ZN^
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::DiskWrite(CWindrv* ps, DWORD nAddress, DWORD nSector, DWORD nSize)
{
	ASSERT(this);
	ASSERT(nAddress);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ݋֎~`FbN
	if (m_cEntry.isWriteProtect(ps)) return FS_FATAL_WRITEPROTECT;

	// ˂
	return FS_NOTIOCTRL;
}

//---------------------------------------------------------------------------
//
//	$55 - IOCTRL
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::IoControl(CWindrv* ps, Human68k::ioctrl_t* pIoctrl, DWORD nFunction)
{
	ASSERT(this);

	switch (nFunction) {
	case 0:
		// fBAID̊l
		pIoctrl->media = 0xF3;
		if (m_nOption & WINDRV_OPT_MEDIABYTE) {
			DWORD nUnit = ps->GetUnit();
			pIoctrl->media = m_cEntry.GetMediaByte(nUnit);
		}
		return 0;

	case 1:
		// Human68k݊̂߂̃_~[
		pIoctrl->param = -1;
		return 0;

	case 2:
		switch (pIoctrl->param) {
		case -1:
			// fBAĔF
			m_cEntry.isMediaOffline(ps);
			return 0;

		case 0:
		case 1:
			// Human68k݊̂߂̃_~[
			return 0;
		}
		break;

	case -1:
		// 풓
		memcpy(pIoctrl->buffer, "WindrvXM", 8);
		return 0;

	case -2:
		// IvVݒ
		SetOption(pIoctrl->param);
		return 0;

	case -3:
		// IvVl
		pIoctrl->param = GetOption();
		return 0;
	}

	return FS_NOTIOCTRL;
}

//---------------------------------------------------------------------------
//
//	$56 - tbV
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Flush(CWindrv* ps)
{
	ASSERT(this);

	DWORD nUnit = ps->GetUnit();

	// tbV
	m_cEntry.LockCache();
	m_cEntry.EraseCache(nUnit);
	m_cEntry.UnlockCache();

	// ɐ
	return 0;
}

//---------------------------------------------------------------------------
//
//	$57 - fBA`FbN
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::CheckMedia(CWindrv* ps)
{
	ASSERT(this);

	// TwentyOneIvVĎ
	CheckKernel(ps);

#ifndef XM6_HOST_STRICT_TIMEOUT
	// ^CAEg`FbN
	m_cEntry.CheckTimeout();
#endif // XM6_HOST_STRICT_TIMEOUT

	// 蓮CWFNgfBȀԍXV`FbN
	BOOL bResult = m_cEntry.CheckMediaUpdate(ps);

	// fBA}ȂG[Ƃ
	if (bResult == FALSE) {
#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
		// ̃fBNg`FbNR}h𖳌ɂ邽߃tO𗧂Ă
		m_cEntry.SetMediaUpdate(ps, TRUE);
#endif // XM6_HOST_UPDATE_BY_SEQUENCE

		return FS_INVALIDFUNC;
	}

	return 0;
}

//---------------------------------------------------------------------------
//
//	$58 - r
//
//---------------------------------------------------------------------------
int FASTCALL CWinFileSys::Lock(CWindrv* ps)
{
	ASSERT(this);

	// fBA`FbN
	if (m_cEntry.isMediaOffline(ps)) return FS_FATAL_MEDIAOFFLINE;

	// ɐ
	return 0;
}

#if 0
//---------------------------------------------------------------------------
//
//	Win32ŏIG[擾 Human68kG[ɕϊ
//
//---------------------------------------------------------------------------
DWORD FASTCALL CWinFileSys::GetLastError(DWORD nUnit) const
{
	ASSERT(this);
	ASSERT(m_cEntry.GetBase(nUnit));

	return FS_INVALIDFUNC;
}
#endif

//---------------------------------------------------------------------------
//
//	IvVݒ
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileSys::SetOption(DWORD nOption)
{
	ASSERT(this);

	// fBNgGg̍č\KvȂLbVNA
	DWORD nDiff = m_nOption ^ nOption;
	if (nDiff & 0x7F3F1F3F) {
		m_cEntry.LockCache();
		m_cEntry.CleanCache();
		m_cEntry.UnlockCache();
	}

	m_nOption = nOption;
	CHostFilename::SetOption(nOption);
	CHostPath::SetOption(nOption);
}

//---------------------------------------------------------------------------
//
//	IvV
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileSys::InitOption(const BYTE* pOption)
{
	pOption += strlen((char*)pOption) + 1;

	DWORD nOption = m_nOptionDefault;
	for (;;) {
		const BYTE* p = pOption;
		BYTE c = *p++;
		if (c == '\0') break;

		DWORD nMode;
		if (c == '+') {
			nMode = 1;
		}
		else if (c == '-') {
			nMode = 0;
		} else {
			// IvVwł͂Ȃ̂Ŏ
			pOption += strlen((char*)pOption) + 1;
			continue;
		}

		for (;;) {
			c = *p++;
			if (c == '\0') break;

			DWORD nBit = 0;
			switch (c) {
			case 'D': case 'd': nBit = WINDRV_OPT_REMOVE; break;
			case 'K': case 'k': nBit = WINDRV_OPT_TWENTYONE; break;
			case 'M': case 'm': nBit = WINDRV_OPT_MEDIABYTE; break;
			case 'A': case 'a': nBit = WINDRV_OPT_CONVERT_LENGTH; break;
			case 'T': case 't': nBit = WINDRV_OPT_COMPARE_LENGTH; nMode ^= 1; break;
			case 'C': case 'c': nBit = WINDRV_OPT_ALPHABET; break;

			case 'E': nBit = WINDRV_OPT_CONVERT_PERIOD; break;
			case 'P': nBit = WINDRV_OPT_CONVERT_PERIODS; break;
			case 'N': nBit = WINDRV_OPT_CONVERT_HYPHEN; break;
			case 'H': nBit = WINDRV_OPT_CONVERT_HYPHENS; break;
			case 'X': nBit = WINDRV_OPT_CONVERT_BADCHAR; break;
			case 'S': nBit = WINDRV_OPT_CONVERT_SPACE; break;

			case 'e': nBit = WINDRV_OPT_REDUCED_PERIOD; break;
			case 'p': nBit = WINDRV_OPT_REDUCED_PERIODS; break;
			case 'n': nBit = WINDRV_OPT_REDUCED_HYPHEN; break;
			case 'h': nBit = WINDRV_OPT_REDUCED_HYPHENS; break;
			case 'x': nBit = WINDRV_OPT_REDUCED_BADCHAR; break;
			case 's': nBit = WINDRV_OPT_REDUCED_SPACE; break;
			}

			if (nMode) {
				nOption |= nBit;
			} else {
				nOption &= ~nBit;
			}
		}

		pOption = p;
	}

	// IvVݒ
	if (nOption != m_nOption) {
		SetOption(nOption);
	}
}

//---------------------------------------------------------------------------
//
//	{[x擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CWinFileSys::FilesVolume(CWindrv* ps, Human68k::files_t* pFiles)
{
	ASSERT(this);
	ASSERT(pFiles);

	DWORD nUnit = ps->GetUnit();

	// {[x擾
	TCHAR szVolume[32];
	BOOL bResult = m_cEntry.GetVolumeCache(nUnit, szVolume);
	if (bResult == FALSE) {
		// fBA`FbN
		m_cEntry.isMediaOffline(ps);

		// {[x擾
		m_cEntry.GetVolume(nUnit, szVolume);
	}
	if (szVolume[0] == _T('\0')) return FALSE;

	pFiles->attr = Human68k::AT_VOLUME;
	pFiles->time = 0;
	pFiles->date = 0;
	pFiles->size = 0;

	CHostFilename fname;
	fname.SetWin32(szVolume);
	fname.SetHuman();
	strcpy((char*)pFiles->full, (char*)fname.GetHuman());

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	TwentyOneIvVĎ
//
//	J[lŝ߁Aނ𓾂[ghCuőΏȂ
//	ȂȂp[^fB
//
//	TODO: J[lEhCoCĂ̏̂̂Ȃ
//
//---------------------------------------------------------------------------
void FASTCALL CWinFileSys::CheckKernel(CWindrv* ps)
{
	ASSERT(this);

	if ((m_nOption & WINDRV_OPT_TWENTYONE) == 0) return;

	ps->LockXM();

	Memory* pMemory = ps->GetMemory();
	ASSERT(pMemory);

	// ܂ĂȂHuman68kJ[l[N𒲍
	if (m_nKernel < 1024) {
		// Ēւ̃JEg_E
		if (m_nKernel > 0) {
			m_nKernel--;		// Ē
			goto CheckKernelExit;
		}

		// Step1: NULfoCX
		if (m_nKernelSearch == 0) {
			DWORD n = 0x6800;
			for (;;) {
				DWORD nData = pMemory->ReadWord(n);
				if (nData == 'NU') {
					if (pMemory->ReadWord(n + 2) == 'L ') break;
				}
				n += 2;
				if (n >= 0x20000 - 2) {
					// NULfoCXł
					m_nKernel = 0xFFFFFFFF;		// J[lُ: xƌȂ
					goto CheckKernelExit;
				}
			}
			n -= 14;
			m_nKernelSearch = n;
		}

		// Step2: NULfoCXN_ƂđSfoCX
		DWORD n = m_nKernelSearch;
		for (;;) {
			// ̃foCX
			n = (pMemory->ReadWord(n) << 16) | pMemory->ReadWord(n + 2);
			if (n == 0xFFFFFFFF) {
				// YfoCXȂ
				m_nKernel = XM6_HOST_TWENTYONE_CHECK_COUNT;	// s: Ē
				goto CheckKernelExit;
			}

			DWORD x1 = (pMemory->ReadWord(n + 14) << 16) | pMemory->ReadWord(n + 16);

			if (x1 == '*Twe') {
				DWORD x2 = (pMemory->ReadWord(n + 18) << 16) | pMemory->ReadWord(n + 20);
				if (x2 == 'nty*') {
					// o[W𔭌
					m_nKernel = 0xFFFFFFFF;		// TwentyOneo[W: xƌȂ
					goto CheckKernelExit;
				}
				continue;
			}

			if (x1 == '?Twe') {
				DWORD x2 = (pMemory->ReadWord(n + 18) << 16) | pMemory->ReadWord(n + 20);
				if (x2 == 'nty?' || x2 == 'ntyE') {
					break;
				}
				continue;
			}
		}

		// 
		m_nKernel = n + 22;
	} else {
		if (m_nKernel == 0xFFFFFFFF) {
			goto CheckKernelExit;
		}
	}

	{
		// J[lIvVl
		DWORD nKernelOption =
			(pMemory->ReadWord(m_nKernel) << 16) | pMemory->ReadWord(m_nKernel + 2);

		// [ghCuIvVl
		DWORD nOption = m_nOption &
			~(WINDRV_OPT_ALPHABET | WINDRV_OPT_COMPARE_LENGTH | WINDRV_OPT_CONVERT_LENGTH);

		// IvVf
		if (nKernelOption & 0x40000000) {	// _TWON_C_BIT: Bit30
			nOption |= WINDRV_OPT_ALPHABET;
		}
		if (nKernelOption & 0x08000000) {	// _TWON_T_BIT: Bit27
			nOption |= WINDRV_OPT_COMPARE_LENGTH;
		}
		if (nKernelOption & 0x00400000) {	// _TWON_A_BIT: Bit22
			nOption |= WINDRV_OPT_CONVERT_LENGTH;
		}

		// IvVݒ
		if (nOption != m_nOption) {
			SetOption(nOption);
		}
	}

CheckKernelExit:
	ps->UnlockXM();
}

//===========================================================================
//
//	Host
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CHost::CHost(CFrmWnd *pWnd) : CComponent(pWnd)
{
	// R|[lgp[^
	m_dwID = MAKEID('H', 'O', 'S', 'T');
	m_strDesc = _T("Host FileSystem");

	// IuWFNg
	m_pWindrv = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CHost::Init()
{
	ASSERT(this);

	// {NX
	if (!CComponent::Init()) {
		return FALSE;
	}

	// Windrv擾
	ASSERT(!m_pWindrv);
	m_pWindrv = (Windrv*)::GetVM()->SearchDevice(MAKEID('W', 'D', 'R', 'V'));
	ASSERT(m_pWindrv);

	// t@CVXeݒ
	m_pWindrv->SetFileSys(&m_WinFileSys);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CHost::Cleanup()
{
	ASSERT(this);

	// t@CVXe؂藣
	if (m_pWindrv) {
		m_pWindrv->SetFileSys(NULL);
	}

	// Zbg(SN[Y)
	m_WinFileSys.Reset();

	// {NX
	CComponent::Cleanup();
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CHost::ApplyCfg(const Config* pConfig)
{
	ASSERT(this);
	ASSERT(pConfig);

	// t@CVXeĂяo
	m_WinFileSys.ApplyCfg(pConfig);
}

#endif // _WIN32
