//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	Modified (C) 2006 co (cogoodgmail.com)
//	[ MFC Host ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_host_h)
#define mfc_host_h

#include "device.h"
#include "windrv.h"

//t@Cl[̃`FbNVtgJISōsȂȂ(pOSp)
//#define XM6_HOST_NO_JAPANESE_NAME

//t@C̃I[v/N[Y𖈉sȂ
// I[v/N[YǗVMōsȂĂ̂ŗLɂĂӖ͂ȂB
// TODO: Xe[g[h̃nhǍ
//#define XM6_HOST_STRICT_CLOSE

//[oufBÃLbVLԂ𐳊mɑ肷
// {@\KpȂꍇAHuman68k̃AvP[V̍
// ɂẮAzXgŃfBÃCWFNg𒷎ԍsȂȂ
// Ȃ镾Q̂ŒӁB
#define XM6_HOST_STRICT_TIMEOUT

//t@CɕԂt@CTCY̍ől
// Human68kG[R[hƏdȂ͈͂Őݒ肷
#define XM6_HOST_FILESIZE_MAX 0xFFFFFF7F

//t@Cǂݏ̃obt@TCY
// 1oCgÂĂ΂ꂽ肷邱Ƃ悤Ȃ̂ŁA܂ʂɎĂ
// ʂɂȂĂ܂\B
// TODO: 炩ߌŒobt@mۂĂׂ
// Xbh[hł́ÃTCY]閈VM̊JsȂ邽߁A
// ő]xɉeB
#define XM6_HOST_FILE_BUFFER_READ 0x10000
#define XM6_HOST_FILE_BUFFER_WRITE 0x10000

//FILESpobt@
// ̃Xbhɐ[KwɓnčƂ鎞Ȃǂ
// ̒l𑝂₷Kv
#define XM6_HOST_FILES_MAX 20

//FCBpobt@
// ɃI[vłt@C͂Ō܂
#define XM6_HOST_FCB_MAX 100

//[ZN^/NX^ ő
// t@Ĉ̐擪ZN^ւ̃ANZXɑΉ
// lzdsysɂANZXsȂXbh̐葽߂Ɋmۂ
#define XM6_HOST_PSEUDO_CLUSTER_MAX 10

//fBNgGg LbV
// ΑقǍɂȂ邪A₵ƃzXgOSɕS
#define XM6_HOST_DIRENTRY_CACHE_MAX 30

//fBNg̃t@C LbV
// SẴt@Cd肳ꂽꍇ͖6疜t@CƂȂ(365)
#define XM6_HOST_FILENAME_CACHE_MAX (36 * 36 * 36 * 36 * 36)

//t@Cdh~}[N
// zXgt@CHuman68kt@Ĉ̖̋ʂƂɎg
// R}hVF̃GXP[vƏdȂȂ̂IԂƋg
#define XM6_HOST_FILENAME_MARK '@'

//[oufBȂ}R}hs_@Ɍo
// mɌoł邪A኱ʂȃANZX\
#define XM6_HOST_UPDATE_BY_SEQUENCE

//[oufBȂ}ANZXpx_@Ɍo
// R}hsł̌o܂Ȃꍇ̂ߎcĂB
// {ł́Amint2.xxn̑}`FbN펞LɂȂ邽߁A쑬
// xቺ肠B
//#define XM6_HOST_UPDATE_BY_FREQUENCY

//[oufBȂ}ANZXpx펞sȂ
// L̓ł܂Ȃꍇ͂gB蓮CWFN
// g̃fBA݂Ɠ쑬x펞ቺ̂ŒӁB
//#define XM6_HOST_UPDATE_ALWAYS

#ifdef XM6_HOST_UPDATE_BY_FREQUENCY
//[oufBA̍XV(ms)ƍXV
// CheckMedia($57)ɂ郁fBA`FbNs񐔂̒l菭ȂΉȂ
// mint3.xn̏ꍇA100msȓ8̃ANZXŃ[hB
#define XM6_HOST_REMOVABLE_RELOAD_TIME 100
#define XM6_HOST_REMOVABLE_RELOAD_COUNT 8
#endif // XM6_HOST_UPDATE_BY_FREQUENCY

//[oufBA̘AANZXK[h(ms)
// Ō̃fBAL`FbNԊu炱̎Ԍo߂܂ł͍ă`FbNȂ
// fBA݂ȂƂ`FbNɎԂ̂foCXւ̑΍B
#define XM6_HOST_REMOVABLE_GUARD_TIME 3000

//[oufBÃLbVL(ms)
// t@CANZXԊu̎ԂJꍇALbVNA
// 蓮CWFNgfBȀꍇAt@CANZX̒Oɂ͕KfB
// A`FbNsȂ߁AAăt@CANZXsꂽ
// ꍇ̓LbVê܂ܕێB
#define XM6_HOST_REMOVABLE_CACHE_TIME 3000

//[oufBÃLbVmFԊu(ms)
// lƂ萳mɊmF悤ɂȂ邪A܂Ӗ͂Ȃ
#define XM6_HOST_REMOVABLE_CHECK_TIME 1000

//TwentyOne풓mFԊu
// TwentyOne풓ĂȂꍇA񌟍͎̂Ԃ̖ʂȂ̂Ŏw
// 񐔂ɊmFB풓Ăꍇ͍͌ŏ1݂̂Ȃ̂
// CɂȂĂ悢B܂AȂꍇ͈ӖȂB
#define XM6_HOST_TWENTYONE_CHECK_COUNT 10

//WINDRVtO
// Bit 0: t@Cϊ Xy[X		0:Ȃ 1:'_'
// Bit 1: t@Cϊ ȕ		0:Ȃ 1:'_'
// Bit 2: t@Cϊ Ԃ̃nCt	0:Ȃ 1:'_'
// Bit 3: t@Cϊ 擪̃nCt	0:Ȃ 1:'_'
// Bit 4: t@Cϊ Ԃ̃sIh	0:Ȃ 1:'_'
// Bit 5: t@Cϊ 擪̃sIh	0:Ȃ 1:'_'
//
// Bit 8: t@C Alphabet	0:Ȃ 1:	0:-C 1:+C
// Bit 9: t@Cr ()	0:18+3 1:8+3	0:+T 1:-T
// Bit10: t@Cϊ 			0:18+3 1:8+3	0:-A 1:+A
// Bit11: \ (R[h)				0:SJIS 1:ANSI
// Bit12: \							0:Ȃ 1:
// Bit13: fBAoCg			0:Œ 1:ϓ
// Bit14: TwentyOneĎ				0:Ȃ 1:Ď
// Bit15: t@C폜				0: 1:ݔ
//
// Bit16: t@CZk Xy[X		0:Ȃ 1:Zk
// Bit17: t@CZk ȕ		0:Ȃ 1:Zk
// Bit18: t@CZk Ԃ̃nCt	0:Ȃ 1:Zk
// Bit19: t@CZk 擪̃nCt	0:Ȃ 1:Zk
// Bit20: t@CZk Ԃ̃sIh	0:Ȃ 1:Zk
// Bit21: t@CZk 擪̃sIh	0:Ȃ 1:Zk
//
// Bit24`30 t@Cdh~}[N	0: 1`127:
enum {
	WINDRV_OPT_CONVERT_SPACE =		0x00000001,
	WINDRV_OPT_CONVERT_BADCHAR =	0x00000002,
	WINDRV_OPT_CONVERT_HYPHENS =	0x00000004,
	WINDRV_OPT_CONVERT_HYPHEN =		0x00000008,
	WINDRV_OPT_CONVERT_PERIODS =	0x00000010,
	WINDRV_OPT_CONVERT_PERIOD =		0x00000020,

	WINDRV_OPT_ALPHABET =			0x00000100,
	WINDRV_OPT_COMPARE_LENGTH =		0x00000200,
	WINDRV_OPT_CONVERT_LENGTH =		0x00000400,

	WINDRV_OPT_MEDIABYTE =			0x00002000,
	WINDRV_OPT_TWENTYONE =			0x00004000,
	WINDRV_OPT_REMOVE =				0x00008000,

	WINDRV_OPT_REDUCED_SPACE =		0x00010000,
	WINDRV_OPT_REDUCED_BADCHAR =	0x00020000,
	WINDRV_OPT_REDUCED_HYPHENS =	0x00040000,
	WINDRV_OPT_REDUCED_HYPHEN =		0x00080000,
	WINDRV_OPT_REDUCED_PERIODS =	0x00100000,
	WINDRV_OPT_REDUCED_PERIOD =		0x00200000,
};

//t@CVXetO
// ʏ0ɂB肪ȃfoCX(USBXg[WƂ)̂߂̕یB
// Bit0: ݋֎~
// Bit1: ᑬfoCX
// Bit2: [oufBA
// Bit3: 蓮CWFNgfBA
enum {
	FSFLAG_WRITE_PROTECT =			0x00000001,
	FSFLAG_SLOW =					0x00000002,
	FSFLAG_REMOVABLE =				0x00000004,
	FSFLAG_MANUAL =					0x00000008,
};

//===========================================================================
//
//	Windowst@ChCu
//
//	hCuɕKvȏ̕ێɐOAǗ͏ʂōsȂB
//	CWinFileSysŎ̂ǗACHostEntryŗpB
//	TODO: ̂CHostEntryֈړ邩
//
//===========================================================================
class CWinFileDrv
{
public:
	// {t@NV
	CWinFileDrv();
										// RXgN^
	virtual ~CWinFileDrv();
										// fXgN^
	void FASTCALL Init(LPCTSTR szBase, DWORD nFlag);
										// 

	TCHAR* FASTCALL GetBase() const { ASSERT(this); return (TCHAR*)m_szBase; }
										// x[XpX̎擾
	BOOL FASTCALL isWriteProtect() const { ASSERT(this); return m_bWriteProtect; }
										// ݋̎擾
	BOOL FASTCALL isSlow() const { ASSERT(this); return m_bSlow; }
										// ݋̎擾
	BOOL FASTCALL isRemovable() const { ASSERT(this); return m_bRemovable; }
										// [oufBAH
	BOOL FASTCALL isManual() const { ASSERT(this); return m_bManual; }
										// 蓮CWFNgfBAH
	BOOL FASTCALL isEnable() const { ASSERT(this); return m_bEnable; }
										// ANZX\H
	BOOL FASTCALL isSameDrive(const TCHAR* szDrive) const { ASSERT(this); return _tcscmp(m_szDrive, szDrive) == 0; }
										// hCuH
	DWORD FASTCALL GetStatus() const;
										// hCuԂ̎擾
	void FASTCALL SetEnable(BOOL bEnable);
										// fBAԐݒ
	void FASTCALL SetTimeout();
										// [oufBÃt@CLbVLԂXV
	BOOL FASTCALL CheckTimeout();
										// [oufBÃt@CLbVLԂmF
#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	void FASTCALL SetMediaUpdate(BOOL bDisable);
										// [oufBȀԍXVLɂ
#endif // XM6_HOST_UPDATE_BY_SEQUENCE
	BOOL FASTCALL CheckMediaUpdate();
										// [oufBȀԍXV`FbN
	BOOL FASTCALL CheckMediaAccess(BOOL bManual);
										// [oufBÃANZXO`FbN
	BOOL FASTCALL CheckMedia();
										// fBAL`FbN
	BOOL FASTCALL Eject();
										// CWFNg
	void FASTCALL GetVolume(TCHAR* szLabel);
										// {[x̎擾
	BOOL FASTCALL GetVolumeCache(TCHAR* szLabel) const;
										// LbV{[x擾
	DWORD FASTCALL GetCapacity(Human68k::capacity_t* pCapacity);
										// eʂ̎擾
	BOOL FASTCALL GetCapacityCache(Human68k::capacity_t* pCapacity) const;
										// LbVNX^TCY擾

private:
	void FASTCALL OpenDevice();
										// foCXI[v
	void FASTCALL CloseDevice();
										// foCXN[Y

	BOOL m_bWriteProtect;
										// ݋֎~ȂTRUE
	BOOL m_bSlow;
										// ᑬfoCXȂTRUE
	BOOL m_bRemovable;
										// [oufBAȂTRUE
	BOOL m_bManual;
										// 蓮CWFNgȂTRUE
	BOOL m_bEnable;
										// fBAp\ȂTRUE
	BOOL m_bDevice;
										// WinNTnŐfoCXĂȂTRUE
	HANDLE m_hDevice;
										// foCXnh(NTnp)
	TCHAR m_szDevice[8];
										// foCX(NTnp)
	TCHAR m_szDrive[4];
										// hCu
	Human68k::capacity_t m_capCache;
										// ZN^LbV sectors == 0 Ȃ疢LbV
	BOOL m_bVolumeCache;
										// {[xǂݍݍς݂ȂTRUE
	TCHAR m_szVolumeCache[24];
										// {[xLbV
	DWORD m_nUpdate;
										// ŌɃfBAp\Ԃl
	BOOL m_bUpdateFile;
										// LbVNA̔肪KvȂTRUE
	DWORD m_nUpdateFile;
										// ŌɃt@CANZXsȂ
#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	DWORD m_nUpdateMedia;
										// [oufBA̍XVXe[g
#endif // XM6_HOST_UPDATE_BY_SEQUENCE
#ifdef XM6_HOST_UPDATE_BY_FREQUENCY
	DWORD m_nUpdateCount;
										// [oufBA̍XVobt@ʒu
	DWORD m_nUpdateBuffer[XM6_HOST_REMOVABLE_RELOAD_COUNT];
										// [oufBA̍XVobt@
#endif // XM6_HOST_UPDATE_BY_FREQUENCY

	TCHAR m_szBase[_MAX_PATH];
										// x[XpX
};

//===========================================================================
//
//	܂ƃOXg
//
//	擪(root.next)łVIuWFNg
//	(root.prev)łÂ/gpIuWFNg
//
//===========================================================================
class CRing {
public:
	CRing() { next = prev = this; }
										// RXgN^
	virtual ~CRing() { Remove(); }
										// fXgN^͉z֐BmɊJ
	CRing* FASTCALL Next() const { ASSERT(this); return next; }
	CRing* FASTCALL Prev() const { ASSERT(this); return prev; }
										// ړp

	void FASTCALL Insert(class CRing* pRoot)
										// IuWFNg؂藣 & O擪֑}
	{
		ASSERT(this);
		// YIuWFNg؂藣
		ASSERT(next);
		ASSERT(prev);
		next->prev = prev;
		prev->next = next;
		// O擪֑}
		ASSERT(pRoot);
		ASSERT(pRoot->next);
		next = pRoot->next;
		prev = pRoot;
		pRoot->next->prev = this;
		pRoot->next = this;
	}

	void FASTCALL InsertTail(class CRing* pRoot)
										// IuWFNg؂藣 & O֑}
	{
		ASSERT(this);
		// YIuWFNg؂藣
		ASSERT(next);
		ASSERT(prev);
		next->prev = prev;
		prev->next = next;
		// O֑}
		ASSERT(pRoot);
		ASSERT(pRoot->prev);
		next = pRoot;
		prev = pRoot->prev;
		pRoot->prev->next = this;
		pRoot->prev = this;
	}

	void FASTCALL InsertRing(class CRing* pRoot)
										// ȊÕIuWFNg؂藣 & O擪֑}
	{
		ASSERT(this);
		if (next == prev) return;

		// O擪֑}
		ASSERT(pRoot);
		ASSERT(pRoot->next);
		pRoot->next->prev = prev;
		prev->next = pRoot->next;
		pRoot->next = next;
		next->prev = pRoot;

		// gɂ
		next = prev = this;
	}

	void FASTCALL Remove()
										// IuWFNg؂藣
	{
		ASSERT(this);
		// YIuWFNg؂藣
		ASSERT(next);
		ASSERT(prev);
		next->prev = prev;
		prev->next = next;
		// ŜߎgwĂ (x؂藣ĂȂ)
		next = prev = this;
	}

	friend void FASTCALL Insert(class CRing* pRoot);
	friend void FASTCALL InsertTail(class CRing* pRoot);
	friend void FASTCALL Remove();
										// oϐ̐ݒ胁\bhJȂ߁A
										// IuWFNg상\bhfriendo^Kv

private:
	class CRing* next;
										// ̗vf
	class CRing* prev;
										// O̗vf
};

//===========================================================================
//
//	fBNgGg t@C
//
//===========================================================================
class CHostFilename: public CRing {
public:
	CHostFilename();
										// RXgN^
	virtual ~CHostFilename();
										// fXgN^
	void FASTCALL FreeWin32() { ASSERT(this); if(m_pszWin32) { free(m_pszWin32); m_pszWin32 = NULL; } }
										// Win32vf̊J
	void FASTCALL SetWin32(const TCHAR* szWin32);
										// Win32̖̂̐ݒ
	void FASTCALL SetHuman(int nCount = -1);
										// Human68k̖̂ϊ
	void FASTCALL CopyHuman(const BYTE* szHuman);
										// Human68k̖̂𕡐
	BOOL FASTCALL SetEntry(const WIN32_FIND_DATA* pWin32Find);
										// fBNgGg̐ݒ
	inline BOOL FASTCALL isReduce() const;
										// Human68k̖̂Hꂽ
	BOOL FASTCALL isCorrect() const { ASSERT(this); return m_bCorrect; }
										// Human68k̃t@CKɍvĂ邩
	BYTE* FASTCALL GetHuman() const { ASSERT(this); return (BYTE*)m_szHuman; }
										// Human68kt@C擾
	BYTE* FASTCALL GetHumanLast() const { ASSERT(this); return m_pszHumanLast; }
										// Human68kt@C擾
	BYTE* FASTCALL GetHumanExt() const { ASSERT(this); return m_pszHumanExt; }
										// Human68kt@C擾
	BOOL FASTCALL CheckAttribute(DWORD nHumanAttribute) const { ASSERT(this); return (m_dirEntry.attr & nHumanAttribute); }
										// Human68k̑̊Y
	Human68k::dirent_t* FASTCALL GetEntry() const { ASSERT(this); return (Human68k::dirent_t*)&m_dirEntry; }
										// Human68kfBNgGg擾
	TCHAR* FASTCALL GetWin32() const { ASSERT(this); return m_pszWin32; }
										// Win32t@C擾
	void FASTCALL SetChild(class CHostEntry* pEntry, class CHostPath* pChild) { ASSERT(this); m_pEntry = pEntry; m_pChild = pChild; }
										// fBNg̎̂o^
	BOOL FASTCALL isSameEntry(Human68k::dirent_t* pdirEntry) const { ASSERT(this); ASSERT(pdirEntry); return memcmp(&m_dirEntry, pdirEntry, sizeof(m_dirEntry)) == 0; }
										// Gg̈v

	// CHostFilespOAPI
	void FASTCALL DeleteCache();
										// YGg̃LbV폜

	// CWinFileSyspOAPI
	static void FASTCALL SetOption(DWORD nOption) { g_nOption = nOption; }
										// tOݒ

	// ėp[`
	static const BYTE* FASTCALL SeparateExt(const BYTE* szHuman);
										// Human68kt@Cgq𕪗

private:
	inline BYTE* FASTCALL CopyName(BYTE* pWrite, const BYTE* pFirst, const BYTE* pLast);
										//	Human68k̃t@CvfRs[

	TCHAR* m_pszWin32;
										// YGg̎
	BOOL m_bCorrect;
										// YGgHuman68k TRUE
	BYTE m_szHuman[24];
										// YGgHuman68k ڌp
	Human68k::dirent_t m_dirEntry;
										// YGgHuman68kS

	BYTE* m_pszHumanLast;
										// YGgE̍p I[ʒu
	BYTE* m_pszHumanExt;
										// YGgE̍p gqʒu

	class CHostEntry* m_pEntry;
										// YGg̊Ǘ (LbVȂNULL)
	class CHostPath* m_pChild;
										// YGg̓e (LbVȂNULL)

	static DWORD g_nOption;
										// tO (t@Cϊ/Zk֘A)
};

//===========================================================================
//
//	fBNgGg pX
//
//===========================================================================
class CHostPath: public CRing {
public:
	// pobt@
	typedef struct {
		DWORD count;
										// s + 1 (0̂Ƃ͈ȉ̒l͖)
		DWORD id;
										// 񌟍𑱍spX̃GgID
		CHostFilename* pos;
										// 񌟍𑱍sʒu (IDv)
		Human68k::dirent_t entry;
										// 񌟍𑱍sGge

		void FASTCALL Clear() { count = 0; }
										// 
	} find_t;

public:
	CHostPath();
										// RXgN^
	virtual ~CHostPath();
										// fXgN^
	void FASTCALL FreeHuman() { ASSERT(this); m_nHumanUnit = 0; if(m_pszHuman) { free(m_pszHuman); m_pszHuman = NULL; } }
										// Human68kvf̊J
	void FASTCALL FreeWin32() { ASSERT(this); if(m_pszWin32) { free(m_pszWin32); m_pszWin32 = NULL; } }
										// Win32vf̊J
	void FASTCALL SetHuman(DWORD nUnit, BYTE* szHuman);
										// Human68k̖̂𒼐ڎw肷
	void FASTCALL SetWin32(TCHAR* szWin32);
										// Win32̖̂𒼐ڎw肷
	BOOL FASTCALL isSameUnit(DWORD nUnit) const { ASSERT(this); return m_nHumanUnit == nUnit; }
										// Human68k̖̂r
	BOOL FASTCALL isSameHuman(DWORD nUnit, const BYTE* szHuman) const;
										// Human68k̖̂r
	TCHAR* FASTCALL GetWin32() const { ASSERT(this); return m_pszWin32; }
										// Win32pX̊l
	CHostFilename* FASTCALL FindFilename(BYTE* szHuman, DWORD nHumanAttribute = Human68k::AT_ALL);
										// t@C
	CHostFilename* FASTCALL FindFilenameWildcard(BYTE* szHuman, find_t* pFind, DWORD nHumanAttribute = Human68k::AT_ALL);
										// t@C (ChJ[hΉ)
	void FASTCALL Clean();
										// ėp̂߂̏
	void FASTCALL CleanFilename();
										// St@CJ
	BOOL FASTCALL isRefresh();
										// t@CύXsȂꂽmF
	BOOL FASTCALL Refresh();
										// t@Cč\

	// CHostEntrypOAPI
	static void FASTCALL InitId() { g_nId = 0; }
										// IDpJE^

	// CWinFileSyspOAPI
	static void FASTCALL SetOption(DWORD nOption) { g_nOption = nOption; }
										// tOݒ

private:
	static inline int FASTCALL Compare(const BYTE* pFirst, const BYTE* pLast, const BYTE* pBufFirst, const BYTE* pBufLast);
										// r (ChJ[hΉ)

	DWORD m_nHumanUnit;
										// YGgHuman68kjbgԍ
	BYTE* m_pszHuman;
										// YGgHuman68kB / Ȃ
	TCHAR* m_pszWin32;
										// YGg̎́B / Ȃ
	HANDLE m_hChange;
										// t@CύXĎpnh
	DWORD m_nId;
										// ID (lωꍇ͍XVӖ)
	CRing m_cRingFilename;
										// t@C IuWFNgێ
										// fBNgGgɕׂ邱ƂD悷

	static DWORD g_nId;
										// IDpJE^

	static DWORD g_nOption;
										// tO (pXr֘A)
};

//===========================================================================
//
//	fBNgGgǗ
//
//===========================================================================
class CHostEntry {
public:
	CHostEntry();
										//  (N)
	virtual ~CHostEntry();
										// J (I)
	void FASTCALL Init(CWinFileDrv** ppBase);
										//  (hCogݎ)
	void FASTCALL Clean();
										// J (NEZbg)

#ifdef XM6_HOST_STRICT_TIMEOUT
	// Xbh
	static DWORD WINAPI Run(VOID* pThis);
										// XbhsJn|Cg
	void FASTCALL Runner();
										// Xbh
#endif // XM6_HOST_STRICT_TIMEOUT

	void FASTCALL LockCache() { ASSERT(this); EnterCriticalSection(&m_csAccess); }
										// LbVANZXJn
	void FASTCALL UnlockCache() { ASSERT(this); LeaveCriticalSection(&m_csAccess); }
										// LbVANZXI

	void FASTCALL CleanCache();
										// SLbV폜
	void FASTCALL EraseCache(DWORD nUnit);
										// Y郆jbg̃LbV폜
	void FASTCALL DeleteCache(CHostPath* pPath);
										// YLbV폜
	CHostPath* FASTCALL FindCache(DWORD nUnit, const BYTE* szHuman);
										// YpXLbVĂ邩
	CHostPath* FASTCALL CopyCache(DWORD nUnit, const BYTE* szHuman, TCHAR* szWin32Buffer = NULL);
										// LbVɁAWin32l
	CHostPath* FASTCALL MakeCache(CWindrv* ps, DWORD nUnit, const BYTE* szHuman, TCHAR* szWin32Buffer = NULL);
										// Win32̌ɕKvȏׂĎ擾

	TCHAR* FASTCALL GetBase(DWORD nUnit) const;
										// x[XpX擾
	BOOL FASTCALL isWriteProtect(CWindrv* ps) const;
										// ݋֎~ǂmF
	BOOL FASTCALL isMediaOffline(CWindrv* ps, BOOL bMedia = TRUE);
										// ᑬfBA`FbNƃItCԃ`FbN
	BYTE FASTCALL GetMediaByte(DWORD nUnit) const;
										// fBAoCg̎擾
	DWORD FASTCALL GetStatus(DWORD nUnit) const;
										// hCuԂ̎擾
	void FASTCALL CheckTimeout();
										// ShCũ^CAEg`FbN
#ifdef XM6_HOST_UPDATE_BY_SEQUENCE
	void FASTCALL SetMediaUpdate(CWindrv* ps, BOOL bDisable);
										// [oufBȀԍXVLɂ
#endif // XM6_HOST_UPDATE_BY_SEQUENCE
	BOOL FASTCALL CheckMediaUpdate(CWindrv* ps);
										// [oufBȀԍXV`FbN
	BOOL FASTCALL CheckMediaAccess(DWORD nUnit, BOOL bErase);
										// [oufBÃANZXO`FbN
	BOOL FASTCALL Eject(DWORD nUnit);
										// CWFNg
	void FASTCALL GetVolume(DWORD nUnit, TCHAR* szLabel);
										// {[x̎擾
	BOOL FASTCALL GetVolumeCache(DWORD nUnit, TCHAR* szLabel);
										// LbV{[x擾
	DWORD FASTCALL GetCapacity(DWORD nUnit, Human68k::capacity_t* pCapacity);
										// eʂ̎擾
	BOOL FASTCALL GetCapacityCache(DWORD nUnit, Human68k::capacity_t* pCapacity);
										// LbVNX^TCY擾

	// t@CVXeԒʒmp OAPI
	void FASTCALL ShellNotify(DWORD nEvent, const TCHAR* szPath);
										// t@CVXeԒʒm

private:
	static inline const BYTE* FASTCALL SeparatePath(const BYTE* szHuman);
										// Human68ktpXŌ̗vf𕪗
	static inline const BYTE* FASTCALL SeparateCopyFilename(const BYTE* szHuman, BYTE* szBuffer);
										// Human68ktpX擪̗vf𕪗ERs[

	CRITICAL_SECTION m_csAccess;
										// rp
	CWinFileDrv** m_ppBase;
										// Win32̂փANZXۂ̃x[XpX

#ifdef XM6_HOST_STRICT_TIMEOUT
	HANDLE m_hEvent;
										// Xbh~Cxg
	HANDLE m_hThread;
										// ^CAEg`FbNpXbh
#else // XM6_HOST_STRICT_TIMEOUT
	DWORD m_nTimeout;
										// ŌɃ^CAEg`FbNsȂ
#endif // XM6_HOST_STRICT_TIMEOUT

	DWORD m_nRingPath;
										// ݂̃pXێ
	CRing m_cRingPath;
										// pX IuWFNgێ
};

//===========================================================================
//
//	t@C
//
//===========================================================================
class CHostFiles: public CRing {
public:
	CHostFiles() { Clear(); }
										// RXgN^
	virtual ~CHostFiles() { Free(); }
										// fXgN^
	void FASTCALL Free() { ASSERT(this); Clear(); }
										// ėp̂߂̊J
	void FASTCALL Clear();
										// 
	void FASTCALL SetKey(DWORD nKey) { ASSERT(this); m_nKey = nKey; }
										// L[ݒ
	BOOL FASTCALL isSameKey(DWORD nKey) const { ASSERT(this); return m_nKey == nKey; }
										// L[r
	void FASTCALL SetPath(DWORD nUnit, const Human68k::namests_t* pNamests);
										// pXEt@CŐ
	BOOL FASTCALL isRootPath() const { return (strlen((char*)m_szHumanPath) == 1); }
										// [gfBNg
	void FASTCALL SetPathWildcard() { m_nHumanWildcard = 1; }
										// ChJ[hɂt@CL
	void FASTCALL SetPathOnly() { m_nHumanWildcard = 0xFF; }
										// pX݂̂L
	void FASTCALL SetAttribute(DWORD nHumanAttribute) { m_nHumanAttribute = nHumanAttribute; }
										// ݒ
	BOOL FASTCALL Find(CWindrv* ps, CHostEntry* pEntry, BOOL bRemove = FALSE);
										// Win32 (pX + t@C(ȗ) + )
	void FASTCALL AddFilename();
										// Win32Ƀt@Cǉ
	const TCHAR* FASTCALL GetPath() const { ASSERT(this); return m_szWin32Result; }
										// Win32擾
	Human68k::dirent_t* FASTCALL GetEntry() const { ASSERT(this); return (Human68k::dirent_t*)&m_dirEntry; }
										// Human68kfBNgGg擾
	DWORD FASTCALL GetAttribute() const { ASSERT(this); return m_dirEntry.attr; }
										// Human68k擾
	WORD FASTCALL GetDate() const { ASSERT(this); return m_dirEntry.date; }
										// Human68kt擾
	WORD FASTCALL GetTime() const { ASSERT(this); return m_dirEntry.time; }
										// Human68k擾
	DWORD FASTCALL GetSize() const { ASSERT(this); return m_dirEntry.size; }
										// Human68kt@CTCY擾
	const BYTE* FASTCALL GetHumanResult() const { ASSERT(this); return m_szHumanResult; }
										// Human68kt@Cʂ擾

private:
	DWORD m_nKey;
										// Human68kFILESobt@AhX 0Ȃ疢gp
	DWORD m_nHumanUnit;
										// Human68k̃jbgԍ
	BYTE m_szHumanPath[HUMAN68K_MAX_PATH];
										// Human68k̃pX
	BYTE m_szHumanFilename[24];
										// Human68k̃t@C
	DWORD m_nHumanWildcard;
										// Human68k̃ChJ[h
	DWORD m_nHumanAttribute;
										// Human68ǩ
	CHostPath::find_t m_findNext;
										// 񌟍ʒu
	Human68k::dirent_t m_dirEntry;
										//  Human68kt@C
	BYTE m_szHumanResult[24];
										//  Human68kt@C
	TCHAR m_szWin32Result[_MAX_PATH];
										//  Win32tpX
};

//===========================================================================
//
//	t@C̈ }l[W
//
//===========================================================================
class CHostFilesManager {
public:
	CHostFilesManager();
										// t@C̈  (N)
	virtual ~CHostFilesManager();
										// t@C̈ mF (I)
	void FASTCALL Init();
										// t@C̈  (hCogݎ)
	void FASTCALL Clean();
										// t@C̈ J (NEZbg)
	CHostFiles* FASTCALL Alloc(DWORD nKey);
										// t@C̈ m
	CHostFiles* FASTCALL Search(DWORD nKey);
										// t@C̈ 
	void FASTCALL Free(CHostFiles* p);
										// t@C̈ J
private:
	CRing m_cRingFiles;
										// t@C̈ IuWFNgێ
};

//===========================================================================
//
//	FCB
//
//===========================================================================
class CHostFcb: public CRing {
public:
	CHostFcb() { Clear(); }
										// RXgN^
	virtual ~CHostFcb() { Free(); }
										// fXgN^
	void FASTCALL Free() { ASSERT(this); Close(); Clear(); }
										// ėp邽߂̊J
	void FASTCALL Clear();
										// NA
	void FASTCALL SetKey(DWORD nKey) { ASSERT(this); m_nKey = nKey; }
										// L[ݒ
	BOOL FASTCALL SetOpenMode(DWORD nHumanMode);
										// t@CI[v[h̐ݒ
	void FASTCALL SetFilename(const TCHAR* szFilename);
										// t@C̐ݒ
	HANDLE FASTCALL Create(DWORD nHumanAttribute, BOOL bForce);
										// t@C쐬
	HANDLE FASTCALL Open();
										// t@CI[v/nhl
	DWORD FASTCALL ReadFile(void* pBuffer, DWORD nSize);
										// t@Cǂݍ
	DWORD FASTCALL WriteFile(void* pBuffer, DWORD nSize);
										// t@C
	DWORD FASTCALL SetFilePointer(DWORD nOffset, DWORD nMode = FILE_BEGIN);
										// t@C|C^ݒ
	DWORD FASTCALL SetFileTime(WORD nFatDate, WORD nFatTime);
										// t@Cݒ
	BOOL FASTCALL Close();
										// t@CN[Y
	BOOL FASTCALL isSameKey(DWORD nKey) const { ASSERT(this); return m_nKey == nKey; }
										// L[r

private:
	DWORD m_nKey;
										// Human68kFCBobt@AhX 0Ȃ疢gp
	DWORD m_nMode;
										// Win32̃t@CI[v[h
	HANDLE m_hFile;
										// Win32̃t@Cnh
	TCHAR m_szFilename[_MAX_PATH];
										// Win32̃t@C
};

//===========================================================================
//
//	FCB }l[W
//
//===========================================================================
class CHostFcbManager {
public:
	CHostFcbManager();
										// FCB̈  (N)
	virtual ~CHostFcbManager();
										// FCB̈ mF (I)
	void FASTCALL Init();
										// FCB̈  (hCogݎ)
	void FASTCALL Clean();
										// FCB̈ J (NEZbg)
	CHostFcb* FASTCALL Alloc(DWORD nKey);
										// FCB̈ m
	CHostFcb* FASTCALL Search(DWORD nKey);
										// FCB̈ 
	void FASTCALL Free(CHostFcb* p);
										// FCB̈ J

private:
	CRing m_cRingFcb;
										// FCB̈ IuWFNgێ
};

//===========================================================================
//
//	Windowst@CVXe
//
//===========================================================================
class CWinFileSys : public FileSys
{
public:
	// {t@NV
	CWinFileSys();
										// RXgN^
	virtual ~CWinFileSys();
										// fXgN^
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp

	// EI
	DWORD FASTCALL Init(CWindrv* ps, DWORD nDriveMax, const BYTE* pOption);
										// $40 - 
	void FASTCALL Reset();
										// Zbg(SN[Y)

	// R}hnh
	int FASTCALL CheckDir(CWindrv* ps, const Human68k::namests_t* pNamests);
										// $41 - fBNg`FbN
	int FASTCALL MakeDir(CWindrv* ps, const Human68k::namests_t* pNamests);
										// $42 - fBNg쐬
	int FASTCALL RemoveDir(CWindrv* ps, const Human68k::namests_t* pNamests);
										// $43 - fBNg폜
	int FASTCALL Rename(CWindrv* ps, const Human68k::namests_t* pNamests, const Human68k::namests_t* pNamestsNew);
										// $44 - t@CύX
	int FASTCALL Delete(CWindrv* ps, const Human68k::namests_t* pNamests);
										// $45 - t@C폜
	int FASTCALL Attribute(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nHumanAttribute);
										// $46 - t@C擾/ݒ
	int FASTCALL Files(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::files_t* pFiles);
										// $47 - t@C(First)
	int FASTCALL NFiles(CWindrv* ps, DWORD nKey, Human68k::files_t* pFiles);
										// $48 - t@C(Next)
	int FASTCALL Create(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nHumanAttribute, BOOL bForce);
										// $49 - t@C쐬
	int FASTCALL Open(CWindrv* ps, const Human68k::namests_t* pNamests, DWORD nKey, Human68k::fcb_t* pFcb);
										// $4A - t@CI[v
	int FASTCALL Close(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb);
										// $4B - t@CN[Y
	int FASTCALL Read(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAddress, DWORD nSize);
										// $4C - t@Cǂݍ
	int FASTCALL Write(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nAddress, DWORD nSize);
										// $4D - t@C
	int FASTCALL Seek(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, DWORD nMode, int nOffset);
										// $4E - t@CV[N
	DWORD FASTCALL TimeStamp(CWindrv* ps, DWORD nKey, Human68k::fcb_t* pFcb, WORD nFatDate, WORD nFatTime);
										// $4F - t@C擾/ݒ
	int FASTCALL GetCapacity(CWindrv* ps, Human68k::capacity_t *pCapacity);
										// $50 - eʎ擾
	int FASTCALL CtrlDrive(CWindrv* ps, Human68k::ctrldrive_t* pCtrlDrive);
										// $51 - hCuԌ/
	int FASTCALL GetDPB(CWindrv* ps, Human68k::dpb_t* pDpb);
										// $52 - DPB擾
	int FASTCALL DiskRead(CWindrv* ps, DWORD nAddress, DWORD nSector, DWORD nSize);
										// $53 - ZN^ǂݍ
	int FASTCALL DiskWrite(CWindrv* ps, DWORD nAddress, DWORD nSector, DWORD nSize);
										// $54 - ZN^
	int FASTCALL IoControl(CWindrv* ps, Human68k::ioctrl_t* pIoctrl, DWORD nFunction);
										// $55 - IOCTRL
	int FASTCALL Flush(CWindrv* ps);
										// $56 - tbV
	int FASTCALL CheckMedia(CWindrv* ps);
										// $57 - fBA`FbN
	int FASTCALL Lock(CWindrv* ps);
										// $58 - r

	// t@CVXeԒʒmp OAPI
	void FASTCALL ShellNotify(DWORD nEvent, const TCHAR* szPath) { ASSERT(this); m_cEntry.ShellNotify(nEvent, szPath); }
										// t@CVXeԒʒm

	enum {
		DrvMax = 10						// hCuő␔
	};

private:
	// G[nh
	//DWORD FASTCALL GetLastError(DWORD nUnit) const;
										// Win32ŏIG[擾 Human68kG[ɕϊ

	// ⏕p
	DWORD FASTCALL GetOption() const { ASSERT(this); return m_nOption; }
										// IvV擾
	void FASTCALL SetOption(DWORD nOption);
										// IvVݒ
	void FASTCALL InitOption(const BYTE* pOption);
										// IvV
	inline BOOL FASTCALL FilesVolume(CWindrv* ps, Human68k::files_t* pFiles);
										// {[x擾
	void FASTCALL CheckKernel(CWindrv* ps);
										// TwentyOneIvVĎ

	DWORD m_bResume;
										// x[XpXԕL FALSEƃx[XpX𖈉XL
	DWORD m_nDrives;
										// hCu␔
	DWORD m_nFlag[DrvMax];
										// tO
	TCHAR m_szBase[DrvMax][_MAX_PATH];
										// x[XpX

	CWinFileDrv* m_pDrv[DrvMax];
										// hCuIuWFNg CHostEntryŗp

	CHostFilesManager m_cFiles;
										// t@C̈ IuWFNgێ
	CHostFcbManager m_cFcb;
										// FCB̈ IuWFNgێ
	CHostEntry m_cEntry;
										// fBNgGg IuWFNgێ
										// 1Â݂΂悢neŵu

	DWORD m_nHostSectorCount;
										// [ZN^ԍ
	DWORD m_nHostSectorBuffer[XM6_HOST_PSEUDO_CLUSTER_MAX];
										// [ZN^̎wt@C

	DWORD m_nKernel;
										// TwentyOneIvVAhX / JnJEg
	DWORD m_nKernelSearch;
										// NULfoCX̐擪AhX

	DWORD m_nOptionDefault;
										// Zbg̓tO
	DWORD m_nOption;
										// tO (t@C폜֘A)
};

//===========================================================================
//
//	Host
//
//===========================================================================
class CHost : public CComponent
{
public:
	// {t@NV
	CHost(CFrmWnd *pWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp

	// t@CVXeԒʒmp OAPI
	void FASTCALL ShellNotify(DWORD nEvent, const TCHAR* szPath) { ASSERT(this); m_WinFileSys.ShellNotify(nEvent, szPath); }
										// t@CVXeԒʒm

private:
	CWinFileSys m_WinFileSys;
										// t@CVXe
	Windrv *m_pWindrv;
										// Windrv
};

#endif // mfc_host_h
#endif // _WIN32
