//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Info ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "schedule.h"
#include "sasi.h"
#include "scsi.h"
#include "fdd.h"
#include "fdi.h"
#include "rtc.h"
#include "memory.h"
#include "fileio.h"
#include "config.h"
#include "mfc_frm.h"
#include "mfc_com.h"
#include "mfc_stat.h"
#include "mfc_sch.h"
#include "mfc_cfg.h"
#include "mfc_res.h"
#include "mfc_info.h"

//===========================================================================
//
//	Info
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CInfo::CInfo(CFrmWnd *pWnd, CStatusBar *pBar) : CComponent(pWnd)
{
	int nPane;

	// R|[lgp[^
	m_dwID = MAKEID('I', 'N', 'F', 'O');
	m_strDesc = _T("Info Center");

	// LvV
	m_strRun.Empty();
	m_strStop.Empty();
	m_strCaption.Empty();
	m_szVM[0] = _T('\0');
	m_szVMFull[0] = _T('\0');
	m_szMO[0] = _T('\0');
	m_szMOFull[0] = _T('\0');
	m_szCD[0] = _T('\0');
	m_szCDFull[0] = _T('\0');
	m_bRun = FALSE;
	m_nParcent = -1;
	m_bCount = FALSE;
	m_dwTime = 0;
	m_dwTick = 0;
	m_pSch = NULL;
	m_pScheduler = NULL;
	m_pSASI = NULL;
	m_pSCSI = NULL;

	// 
	m_bInfo = FALSE;
	m_bPower = FALSE;
	m_dwInfo = 0;
	m_strInfo.Empty();
	m_szInfo[0] = _T('\0');

	// Xe[^X
	for (nPane=0; nPane<PaneMax; nPane++) {
		m_colStatus[nPane] = (COLORREF)-1;
		m_szStatus[nPane][0] = _T('\0');
	}
	m_bFloppyLED = FALSE;
	m_bPowerLED = FALSE;
	m_bCaptionInfo = FALSE;
	m_pFDD = NULL;
	m_pRTC = NULL;
	m_dwNumber = 0;
	m_dwDiskID = 0;
	m_dwDiskTime = DiskTypeTime;

	// Xe[^Xo[
	ASSERT(pBar);
	m_pStatusBar = pBar;

	// Xe[^Xr[
	m_pStatusView = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInfo::Init()
{
	CString strIdle;

	ASSERT(this);

	// {NX
	if (!CComponent::Init()) {
		return FALSE;
	}

	// LvV
	::GetMsg(IDS_CAPTION_RUN, m_strRun);
	::GetMsg(IDS_CAPTION_STOP, m_strStop);
	m_pSch = (CScheduler*)SearchComponent(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pSch);
	m_pScheduler = (Scheduler*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pScheduler);
	m_pSASI = (SASI*)::GetVM()->SearchDevice(MAKEID('S', 'A', 'S', 'I'));
	ASSERT(m_pSASI);
	m_pSCSI = (SCSI*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'S', 'I'));
	ASSERT(m_pSCSI);

	// 
	::SetInfoMsg(m_szInfo, TRUE);
	::GetMsg(AFX_IDS_IDLEMESSAGE, strIdle);
	if (strIdle.GetLength() < 0x100) {
		_tcscpy(m_szInfo, (LPCTSTR)strIdle);
	}
	::GetMsg(IDS_POWEROFF, m_strPower);
	m_bPower = ::GetVM()->IsPower();

	// Xe[^X
	m_pFDD = (FDD*)::GetVM()->SearchDevice(MAKEID('F', 'D', 'D', ' '));
	ASSERT(m_pFDD);
	m_pRTC = (RTC*)::GetVM()->SearchDevice(MAKEID('R', 'T', 'C', ' '));
	ASSERT(m_pRTC);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::Cleanup()
{
	ASSERT(this);

	// {NX
	CComponent::Cleanup();
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::ApplyCfg(const Config* pConfig)
{
	ASSERT(this);
	ASSERT(pConfig);

	// Xe[^X
	m_bFloppyLED = pConfig->floppy_led;
	m_bPowerLED = pConfig->power_led;
	m_bCaptionInfo = pConfig->caption_info;
}

//---------------------------------------------------------------------------
//
//	쐧
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::Enable(BOOL bEnable)
{
	CConfig *pConfig;
	Config cfg;
	int i;
	int x;
	int y;
	BITMAPINFOHEADER *bmi;
	Memory *pMemory;
	const BYTE *pCG;
	const BYTE *pChr;
	BYTE *pBits;
	BYTE byteFont;

	ASSERT(this);

	// Lɂꍇ(NӖ)
	if (bEnable) {
		// RtBO}l[W擾
		pConfig = (CConfig*)SearchComponent(MAKEID('C', 'F', 'G', ' '));
		ASSERT(pConfig);

		// RtBOf[^擾
		pConfig->GetConfig(&cfg);

		// dONNAOFFNŕ
		if (cfg.power_off) {
			// dOFF
			m_bPower = FALSE;
			m_bRun = FALSE;
			m_bCount = TRUE;
		}
		else {
			// dON
			m_bPower = TRUE;
			m_bRun = TRUE;
			m_bCount = FALSE;
		}
		m_dwTick = ::GetTickCount();

		// hCuprbg}bv쐬
		pMemory = (Memory*)::GetVM()->SearchDevice(MAKEID('M', 'E', 'M', ' '));
		ASSERT(pMemory);
		pCG = pMemory->GetCG();
		ASSERT(pCG);

		// hCu[v
		for (i=0; i<2; i++) {
			// TCY`FbN
			ASSERT((sizeof(BITMAPINFOHEADER) + 8 * 8 * 3) <= sizeof(m_bmpDrive[i]));

			// NA
			memset(m_bmpDrive[i], 0, sizeof(m_bmpDrive[i]));

			// rbg}bvwb_ݒ
			bmi = (BITMAPINFOHEADER*)&m_bmpDrive[i][0];
			bmi->biSize = sizeof(BITMAPINFOHEADER);
			bmi->biWidth = 8;
			bmi->biHeight = -8;
			bmi->biPlanes = 1;
			bmi->biBitCount = 24;
			bmi->biCompression = BI_RGB;
			bmi->biSizeImage = 8 * 8 * 3;

			// AhXݒ
			pChr = pCG + 0x3a000 + (('0' + i) << 3);
			pBits = &m_bmpDrive[i][sizeof(BITMAPINFOHEADER)];

			// x, y[v
			for (y=0; y<8; y++) {
				// CGROMf[^擾
				byteFont = pChr[y ^ 1];

				// 1rbgƂɌ
				for (x=0; x<8; x++) {
					if (byteFont & 0x80) {
						pBits[0] = 208;
						pBits[1] = 208;
						pBits[2] = 208;
					}
					byteFont <<= 1;
					pBits += 3;
				}
			}
		}
	}

	// {NX
	CComponent::Enable(bEnable);
}

//===========================================================================
//
//	LvV
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	LvVZbg
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::ResetCaption()
{
	CString strCap;

	ASSERT(this);
	ASSERT(m_pSch);

	// ݂̏ԂƔ]
	m_bRun = !m_pSch->IsEnable();

	// XVASY̋tݒ
	if (m_bRun) {
		m_bCount = FALSE;
		m_nParcent = -1;
	}
	else {
		m_bCount = TRUE;
		m_nParcent = -1;
	}

	// ݂̏Ԃ烁bZ[W
	if (m_pSch->IsEnable()) {
		strCap = m_strRun;
	}
	else {
		strCap = m_strStop;
	}

	// \ȂꍇAI[o[Ch
	if (m_bCaptionInfo == FALSE) {
		strCap = _T("XM6");
	}

	// ݒ
	if (m_strCaption != strCap) {
		m_strCaption = strCap;
		m_pFrmWnd->SetWindowText(strCap);
	}
	if (m_pStatusView) {
		m_pStatusView->SetCaptionString(strCap);
	}
}

//---------------------------------------------------------------------------
//
//	LvVXV
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::UpdateCaption()
{
	BOOL bParcent;
	BOOL bVM;
	BOOL bMO;
	BOOL bCD;

	ASSERT(this);

	// `FbN
	bParcent = CheckParcent();

	// VM`FbN
	bVM = CheckVM();

	// MO`FbN
	bMO = CheckMO();

	// CD`FbN
	bCD = CheckCD();

	// ǂꂩقȂĂALvVݒ
	if (bParcent || bVM || bMO || bCD) {
		SetCaption();
	}
}

//---------------------------------------------------------------------------
//
//	`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInfo::CheckParcent()
{
	BOOL bRun;
	DWORD dwDiff;
	DWORD dwTick;
	int nParcent;

	ASSERT(this);
	ASSERT(m_pSch);
	ASSERT(m_pScheduler);

	// ȌԂobNAbv
	bRun = m_bRun;

	// ̓Ԃ擾
	m_bRun = m_pSch->IsEnable();

	// ~ɂȂĂΓʏ
	if (!m_bRun) {
		// O~Ȃ
		if (!bRun) {
			// vɂȂĂΉ낵āAXV
			if (m_bCount) {
				m_bCount = FALSE;
				return TRUE;
			}
			return FALSE;
		}

		// vȂ
		m_bCount = FALSE;

		// \Ȃ
		m_nParcent = -1;

		// ύX
		return TRUE;
	}

	// vJnĂȂΓʏ(STOPRUN͂ɓ)
	if (!m_bCount || !bRun) {
		// vJn
		m_bCount = TRUE;
		m_dwTick = ::GetTickCount();
		m_dwTime = m_pScheduler->GetTotalTime();

		// \Ȃ
		m_nParcent = -1;

		// ύX
		return TRUE;
	}

	// RUNRUN̏ꍇ̂
	ASSERT(m_bCount);
	ASSERT(bRun);
	ASSERT(m_bRun);

	// ԍ
	dwDiff = ::GetTickCount();
	dwDiff -= m_dwTick;
	if (m_nParcent >= 0) {
		// Ɂ\̏ꍇ
		if (dwDiff < CapTimeLong) {
			// ύXȂ
			return FALSE;
		}
	}
	else {
		// ܂\ĂȂꍇ
		if (dwDiff < CapTimeShort) {
			// ύXȂ
			return FALSE;
		}
	}

	// ԍAs^C𓾂
	dwTick = ::GetTickCount();
	m_dwTime = m_pScheduler->GetTotalTime() - m_dwTime;
	m_dwTick = dwTick - m_dwTick;

	// Zɂ聓Zo
	if ((m_dwTime == 0) || (m_dwTick == 0)) {
		nParcent = 0;
	}
	else {
		// VM0.5usP
		nParcent = (int)m_dwTime;
		nParcent /= (int)m_dwTick;
		if (nParcent > 0) {
			nParcent /= 2;
		}
	}

	// ăZbg
	m_dwTime = m_pScheduler->GetTotalTime();
	m_dwTick = dwTick;

	// H(45)
	if ((nParcent % 10) >= 5) {
		nParcent /= 10;
		nParcent++;
	}
	else {
		nParcent /= 10;
	}

	// قȂĂ΍XVāATRUE
	if (m_nParcent != nParcent) {
		m_nParcent = nParcent;
		return TRUE;
	}

	// OƓBFALSE
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	VMt@C`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInfo::CheckVM()
{
	Filepath path;
	LPCTSTR lpszPath;
	LPCTSTR lpszFileExt;

	ASSERT(this);
	ASSERT(m_pSASI);

	// VMpX擾
	::GetVM()->GetPath(path);
	lpszPath = path.GetPath();

	// tƃpX񂪈vĂ邩ǂׂ
	if (_tcscmp(lpszPath, m_szVMFull) == 0) {
		// ύXȂ
		return FALSE;
	}

	// tɑSăRs[
	_tcscpy(m_szVMFull, lpszPath);

	// t@C{gq̂ݎo
	lpszFileExt = path.GetFileExt();

	// XV
	_tcscpy(m_szVM, lpszFileExt);

	// ύX
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	MOt@C`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInfo::CheckMO()
{
	Filepath path;
	LPCTSTR lpszPath;
	LPCTSTR lpszFileExt;

	ASSERT(this);
	ASSERT(m_pSASI);

	// MOpX擾
	m_pSASI->GetPath(path);
	lpszPath = path.GetPath();

	// tƃpX񂪈vĂ邩ǂׂ
	if (_tcscmp(lpszPath, m_szMOFull) == 0) {
		// ύXȂ
		return FALSE;
	}

	// tɑSăRs[
	_tcscpy(m_szMOFull, lpszPath);

	// t@C{gq̂ݎo
	lpszFileExt = path.GetFileExt();

	// XV
	_tcscpy(m_szMO, lpszFileExt);

	// ύX
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	CDt@C`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInfo::CheckCD()
{
	Filepath path;
	LPCTSTR lpszPath;
	LPCTSTR lpszFileExt;

	ASSERT(this);
	ASSERT(m_pSCSI);

	// CDpX擾
	m_pSCSI->GetPath(path, FALSE);
	lpszPath = path.GetPath();

	// tƃpX񂪈vĂ邩ǂׂ
	if (_tcscmp(lpszPath, m_szCDFull) == 0) {
		// ύXȂ
		return FALSE;
	}

	// tɑSăRs[
	_tcscpy(m_szCDFull, lpszPath);

	// t@C{gq̂ݎo
	lpszFileExt = path.GetFileExt();

	// XV
	_tcscpy(m_szCD, lpszFileExt);

	// ύX
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	LvVݒ
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::SetCaption()
{
	CString strCap;
	CString strSub;

	ASSERT(this);
	ASSERT(m_pFrmWnd);

	// 쒆 or ~
	if (m_bRun) {
		// 쒆
		strCap = m_strRun;
	}
	else {
		// ~
		strCap = m_strStop;
	}

	// ݒ(LvV֏\Ȃꍇ)
	if (m_bCaptionInfo == FALSE) {
		strCap = _T("XM6");

		// LvV
		if (m_strCaption != strCap) {
			m_strCaption = strCap;
			m_pFrmWnd->SetWindowText(strCap);
		}

		// Xe[^Xr[
		if (m_pStatusView) {
			m_pStatusView->SetCaptionString(strCap);
		}
	}

	// %\
	if (m_nParcent >= 0) {
		strSub.Format(_T(" - %3d%%"), m_nParcent);
		strCap += strSub;
	}

	// VM
	if (_tcslen(m_szVM) > 0) {
		strSub.Format(_T(" [%s] "), m_szVM);
		strCap += strSub;
	}

	// MO
	if (_tcslen(m_szMO) > 0) {
		strSub.Format(_T(" (%s) "), m_szMO);
		strCap += strSub;
	}

	// CD
	if (_tcslen(m_szCD) > 0) {
		strSub.Format(_T(" {%s} "), m_szCD);
		strCap += strSub;
	}

	//  ݒ(LvV֏\ꍇ)
	if (m_bCaptionInfo) {
		// LvV
		if (m_strCaption != strCap) {
			m_strCaption = strCap;
			m_pFrmWnd->SetWindowText(strCap);
		}

		// Xe[^Xr[
		if (m_pStatusView) {
			m_pStatusView->SetCaptionString(strCap);
		}
	}
}

//===========================================================================
//
//	
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	ݒ
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::SetInfo(CString& strInfo)
{
	ASSERT(this);

	// bZ[WL
	m_strInfo = strInfo;

	// tOAbvAԋL
	m_bInfo = TRUE;
	m_dwInfo = ::GetTickCount();

	// Xe[^Xo[֐ݒ
	ASSERT(m_pStatusBar);
	m_pStatusBar->SetPaneText(0, m_strInfo, TRUE);

	// Xe[^Xr[֐ݒ
	if (m_pStatusView) {
		m_pStatusView->SetInfoString(m_strInfo);
	}
}

//---------------------------------------------------------------------------
//
//	ʏ탁bZ[Wݒ
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::SetMessageString(const CString& strMessage) const
{
	LPCTSTR lpszMessage;

	// LPCTSTR֕ϊ
	lpszMessage = (LPCTSTR)strMessage;

	// const𔲂邽߁AC`̊֐oR
	::SetInfoMsg(lpszMessage, FALSE);
}

//---------------------------------------------------------------------------
//
//	XV
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::UpdateInfo()
{
	BOOL bPower;
	DWORD dwDiff;
	CString strText;

	ASSERT(this);

	// dԂ`FbN
	bPower = ::GetVM()->IsPower();
	if (m_bPower && !bPower) {
		// dONOFFɑJڂBbZ[W
		SetInfo(m_strPower);
	}
	// dԂɍXV
	m_bPower = bPower;

	// LtOOFFȂ
	if (!m_bInfo) {
		// Ȃ
		return;
	}

	// ԌvB2000msŏ
	dwDiff = ::GetTickCount();
	dwDiff -= m_dwInfo;
	if (dwDiff < InfoTime) {
		// \
		return;
	}

	// LtOOFF
	m_bInfo = FALSE;

	// ʏ탁bZ[W𕜌
	strText = m_szInfo;

	// Xe[^Xo[֐ݒ
	ASSERT(m_pStatusBar);
	m_pStatusBar->SetPaneText(0, strText, TRUE);

	// Xe[^Xr[֐ݒ
	if (m_pStatusView) {
		strText.Empty();
		m_pStatusView->SetInfoString(strText);
	}
}

//===========================================================================
//
//	Xe[^X
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	Xe[^XZbg
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::ResetStatus()
{
	int nPane;

	ASSERT(this);

	// yCׂăNA
	for (nPane=0; nPane<PaneMax; nPane++) {
		// sF
		m_colStatus[nPane] = (COLORREF)-1;

		// \eLXgȂ
		m_szStatus[nPane][0] = _T('\0');
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^XXV
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::UpdateStatus()
{
	COLORREF colStatus[PaneMax];
	TCHAR szStatus[PaneMax][_MAX_PATH];
	int nPane;
	BOOL bDraw;
	BOOL bAll;
	CString strNumber;

	ASSERT(this);
	ASSERT(m_pStatusBar);

	// VMbN
	::LockVM();

	// eLXgƃJ[쐬
	ASSERT(PaneMax == 5);
	colStatus[0] = StatusFloppy(szStatus[0], 0);
	colStatus[1] = StatusFloppy(szStatus[1], 1);
	colStatus[2] = StatusHardDisk(szStatus[2]);
	colStatus[3] = StatusTimer(szStatus[3]);
	colStatus[4] = StatusPower(szStatus[4]);

	// VMAbN
	::UnlockVM();

	// io쐬(̍XVŁAقȂ镶쐬)
	strNumber.Format(_T("%08X"), m_dwNumber);

	// r[vƕ`
	bAll = FALSE;
	for (nPane=0; nPane<5; nPane++) {
		// rA`悷邩ǂ߂
		bDraw = FALSE;
		if (m_colStatus[nPane] != colStatus[nPane]) {
			bDraw = TRUE;
		}
		if (_tcscmp(m_szStatus[nPane], szStatus[nPane]) != 0) {
			bDraw = TRUE;
		}

		// `悷KvȂΎ
		if (!bDraw) {
			continue;
		}

		// Rs[
		m_colStatus[nPane] = colStatus[nPane];
		_tcscpy(m_szStatus[nPane], szStatus[nPane]);

		// `
		m_pStatusBar->SetPaneText(nPane + 1, strNumber, TRUE);

		// Xe[^Xr[
		if (m_pStatusView) {
			m_pStatusView->DrawStatus(nPane);
		}

		// tOUp
		bAll = TRUE;
	}

	// ioXV
	if (bAll) {
		m_dwNumber++;
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^XFD
//
//---------------------------------------------------------------------------
COLORREF FASTCALL CInfo::StatusFloppy(LPTSTR lpszText, int nDrive) const
{
	COLORREF colStatus;
	int nStatus;
	BOOL bPower;
	FDD::drv_t drv;
	char name[60];
	LPCTSTR lpszName;

	ASSERT(this);
	ASSERT(lpszText);
	ASSERT((nDrive == 0) || (nDrive == 1));
	ASSERT(m_pFDD);
	ASSERT(m_pSch);

	// AFDDf[^𓾂
	bPower = ::GetVM()->IsPower();
	lpszText[0] = _T('\0');
	colStatus = RGB(1, 1, 1);
	nStatus = m_pFDD->GetStatus(nDrive);

	// _Œ
	if (nStatus & FDST_BLINK) {
		// _ŒB_Ɩł̂ǂ炩
		if ((nStatus & FDST_CURRENT) && bPower) {
			// 
			colStatus = RGB(15, 159, 15);
		}
		else {
			// 
			colStatus = RGB(0, 0, 0);
		}
	}

	// }܂͌}
	if (nStatus & FDST_INSERT) {
		// D
		colStatus = RGB(95, 95, 95);

		// fBXN擾
		m_pFDD->GetName(nDrive, name);
		lpszName = A2CT(name);
		_tcscpy(lpszText, lpszName);

		// ANZX
		if (m_bFloppyLED) {
			// [^ON&ZNgȂ
			if ((nStatus & FDST_MOTOR) && (nStatus & FDST_SELECT)) {
				colStatus = RGB(208, 31, 31);
			}
		}
		else {
			// ANZXȂ
			if (nStatus & FDST_ACCESS) {
				colStatus = RGB(208, 31, 31);
			}
		}

		// dOFFȂKDF
		if (!bPower) {
			colStatus = RGB(95, 95, 95);
		}
	}

	// XPW[~̏ꍇ̓
	if (!m_pSch->IsEnable()) {
		// hCuڍׂ擾
		m_pFDD->GetDrive(nDrive, &drv);
		if (!(nStatus & FDST_INSERT)) {
			// fBXN͑}ĂȂ
			if (drv.next) {
				// fBXN
				colStatus = RGB(95, 95, 95);

				drv.next->GetName(name, 0);
				lpszName = A2CT(name);
				_tcscpy(lpszText, lpszName);
			}
		}
	}

	// CWFNg֎~Ȃŏʂ𗧂Ă
	if (!(nStatus & FDST_EJECT)) {
		colStatus |= (COLORREF)0x80000000;
	}

	return colStatus;
}

//---------------------------------------------------------------------------
//
//	Xe[^XHD
//
//---------------------------------------------------------------------------
COLORREF FASTCALL CInfo::StatusHardDisk(LPTSTR lpszText)
{
	DWORD dwID;
	COLORREF color;

	ASSERT(this);
	ASSERT(lpszText);
	ASSERT(m_pSASI);

	// d`FbN
	if (!::GetVM()->IsPower()) {
		// dĂȂB
		_tcscpy(lpszText, _T("HD BUSY"));
		m_dwDiskID = 0;
		m_dwDiskTime = DiskTypeTime;
		return RGB(0, 0, 0);
	}

	// foCX擾
	dwID = m_pSASI->GetBusyDevice();
	switch (dwID) {
		// SASI-HD
		case MAKEID('S', 'A', 'H', 'D'):
			color = RGB(208, 31, 31);
			break;

		// SCSI-HD
		case MAKEID('S', 'C', 'H', 'D'):
			color = RGB(208, 31, 31);
			break;

		// SCSI-MO
		case MAKEID('S', 'C', 'M', 'O'):
			color = RGB(208, 32, 31);
			break;

		// SCSI-CD
		case MAKEID('S', 'C', 'C', 'D'):
			color = RGB(208, 31, 32);
			break;

		// BUSYłȂ
		case 0:
			color = RGB(0, 0, 0);
			break;

		// ̑(肦Ȃ)
		default:
			ASSERT(FALSE);
			_tcscpy(lpszText, _T("HD BUSY"));
			return RGB(0, 0, 0);
	}

	// LȃfoCX̏ꍇ
	if (color != RGB(0, 0, 0)) {
		// ÕfoCXƓ
		if (dwID == m_dwDiskID) {
			// Ԃ+1(őDiskTypeTime)
			if (m_dwDiskTime < DiskTypeTime) {
				m_dwDiskTime++;
			}
		}
		else {
			// foCX؂ւ̂ŁALĎԂ
			m_dwDiskID = dwID;
			m_dwDiskTime = 0;
		}
	}
	else {
		// BUSYłȂ΁Aԃ`FbN
		if (m_dwDiskTime >= DiskTypeTime) {
			// HD BUSYɖ߂
			ASSERT(m_dwDiskTime == DiskTypeTime);
			_tcscpy(lpszText, _T("HD BUSY"));
			m_dwDiskID = 0;

			// 
			return RGB(0, 0, 0);
		}

		// ΂炭Aɋ߂FŁAÕfoCXŕ\
		m_dwDiskTime++;
		dwID = m_dwDiskID;
		color = RGB(0, 0, 1);
	}

	// 쐬
	switch (dwID) {
		// SASI-HD
		case MAKEID('S', 'A', 'H', 'D'):
			_tcscpy(lpszText, _T("HD BUSY"));
			break;

		// SCSI-HD
		case MAKEID('S', 'C', 'H', 'D'):
			_tcscpy(lpszText, _T("HD BUSY"));
			break;

		// SCSI-MO
		case MAKEID('S', 'C', 'M', 'O'):
			_tcscpy(lpszText, _T("MO BUSY"));
			break;

		// SCSI-CD
		case MAKEID('S', 'C', 'C', 'D'):
			_tcscpy(lpszText, _T("CD BUSY"));
			break;

		// ̑(肦Ȃ)
		default:
			ASSERT(FALSE);
	}

	return color;
}

//---------------------------------------------------------------------------
//
//	Xe[^XTIMER
//
//---------------------------------------------------------------------------
COLORREF FASTCALL CInfo::StatusTimer(LPTSTR lpszText) const
{
	ASSERT(this);
	ASSERT(lpszText);
	ASSERT(m_pRTC);

	// eLXg
	_tcscpy(lpszText, _T("TIMER"));

	// ^C}[ONȂ(d͊֌WȂ)
	if (m_pRTC->GetTimerLED()) {
		return RGB(208, 31, 31);
	}

	// 
	return RGB(0, 0, 0);
}

//---------------------------------------------------------------------------
//
//	Xe[^XPOWER
//
//---------------------------------------------------------------------------
COLORREF FASTCALL CInfo::StatusPower(LPTSTR lpszText) const
{
	VM *pVM;

	ASSERT(this);
	ASSERT(lpszText);
	ASSERT(m_pRTC);

	// VM擾
	pVM = m_pRTC->GetVM();
	ASSERT(pVM);

	// eLXg
	_tcscpy(lpszText, _T("POWER"));

	// dOFF
	if (!pVM->IsPower()) {
		if (m_bPowerLED) {
			// Ð
			return RGB(12, 23, 129);
		}
		else {
			// 
			return RGB(208, 31, 31);
		}
	}

	// dXCb`ON
	if (pVM->IsPowerSW()) {
		// ΂܂͐
		if (m_bPowerLED) {
			return RGB(50, 50, 255);
		}
		else {
			return RGB(31, 208, 31);
		}
	}

	// dXCb`OFF̎́AALARMo͂ɂgO
	if (m_pRTC->GetAlarmOut()) {
		// ΂܂͐
		if (m_bPowerLED) {
			return RGB(50, 50, 255);
		}
		else {
			return RGB(31, 208, 31);
		}
	}
	if (m_bPowerLED) {
		// Ð
		return RGB(12, 23, 129);
	}
	else {
		// 
		return RGB(0, 0, 0);
	}
}

//---------------------------------------------------------------------------
//
//	Xe[^X`
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::DrawStatus(int nPane, HDC hDC, CRect& rectDraw)
{
	BOOL bHalf;
	COLORREF colStatus;
	HDC hMemDC;
	HBITMAP hBitmap;
	HBITMAP hDefBitmap;
	HFONT hFont;
	HFONT hDefFont;
	CRect rectMem;
	CRect rectLine;
	int nLine;

	ASSERT(this);
	ASSERT((nPane >= 0) && (nPane < PaneMax));
	ASSERT(hDC);

	// J[ƃn[tg[(C`)̐ݒ
	colStatus = m_colStatus[nPane];
	bHalf = FALSE;
	if (colStatus & 0x80000000) {
		bHalf = TRUE;
		colStatus &= (COLORREF)(0x7fffffff);
	}

	// `̐ݒ
	rectMem.left = 0;
	rectMem.top = 0;
	rectMem.right = rectDraw.Width();
	rectMem.bottom = rectDraw.Height();

	// DC쐬
	hMemDC = ::CreateCompatibleDC(hDC);

	// rbg}bv쐬AZNg
	hBitmap = ::CreateCompatibleBitmap(hDC, rectDraw.Width(), rectDraw.Height());
	hDefBitmap = (HBITMAP)::SelectObject(hMemDC, hBitmap);
	ASSERT(hDefBitmap);

	// tHg쐬AZNg
	hFont = (HFONT)::GetStockObject(DEFAULT_GUI_FONT);
	hDefFont = (HFONT)::SelectObject(hMemDC, hFont);
	ASSERT(hDefFont);

	// hԂ
	::SetBkColor(hMemDC, colStatus);
	::ExtTextOut(hMemDC, 0, 0, ETO_OPAQUE, &rectMem, NULL, 0, NULL);

	// n[t
	if (bHalf) {
		// Cɍ
		rectLine = rectMem;
		::SetBkColor(hMemDC, RGB(0, 0, 0));
		for (nLine=0; nLine<rectMem.bottom; nLine+=2) {
			rectLine.top = nLine;
			rectLine.bottom = nLine + 1;
			::ExtTextOut(hMemDC, 0, 0, ETO_OPAQUE, &rectLine, NULL, 0, NULL);
		}
		::SetBkColor(hMemDC, colStatus);
	}

	// eLXg`(AO)
	if (!m_pStatusView || (nPane < 2) || (colStatus != 0)) {
		// et邽߁A1hbgEփVtg
		rectMem.left++;
		rectMem.top++;
		rectMem.right++;
		rectMem.bottom++;

		// e\()
		::SetTextColor(hMemDC, RGB(0, 0, 0));
		::SetBkMode(hMemDC, TRANSPARENT);
		::DrawText(hMemDC, m_szStatus[nPane], (int)_tcslen(m_szStatus[nPane]),
						 &rectMem, DT_NOPREFIX | DT_CENTER | DT_VCENTER | DT_SINGLELINE);

		// ߂߁A1hbgփVtg
		rectMem.left--;
		rectMem.top--;
		rectMem.right--;
		rectMem.bottom--;

		// {̂\()
		::SetTextColor(hMemDC, RGB(255, 255, 255));
		::SetBkMode(hMemDC, TRANSPARENT);
		::DrawText(hMemDC, m_szStatus[nPane], (int)_tcslen(m_szStatus[nPane]),
						 &rectMem, DT_NOPREFIX | DT_CENTER | DT_VCENTER | DT_SINGLELINE);
	}

	// tbs[fBXN̓hCuԍ`
	if ((nPane < 2) && (colStatus != 0)) {
		// O
		if (!m_pStatusView || (colStatus != RGB(1, 1, 1))) {
			::SetDIBitsToDevice(hMemDC, 0, 0, 8, 8, 0, 0, 0, 8,
								&m_bmpDrive[nPane][sizeof(BITMAPINFOHEADER)],
								(BITMAPINFO*)&m_bmpDrive[nPane][0],
								DIB_RGB_COLORS);
		}
	}

	// BitBlt
	::BitBlt(hDC, rectDraw.left, rectDraw.top, rectDraw.Width(), rectDraw.Height(),
						hMemDC, 0, 0, SRCCOPY);

	// tHg߂
	::SelectObject(hMemDC, hDefFont);

	// rbg}bv߂
	::SelectObject(hMemDC, hDefBitmap);
	::DeleteObject(hBitmap);

	// DC߂
	::DeleteDC(hMemDC);
}

//===========================================================================
//
//	̑
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	Xe[^Xr[ʒm
//
//---------------------------------------------------------------------------
void FASTCALL CInfo::SetStatusView(CStatusView *pView)
{
	ASSERT(this);

	// NULLɂ炸AL
	m_pStatusView = pView;
}

#endif	// _WIN32
