//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Info ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_info_h)
#define mfc_info_h

#include "mfc_com.h"

//===========================================================================
//
//	Info
//
//===========================================================================
class CInfo : public CComponent
{
public:
	// 萔l
	enum {
		InfoBufMax = 100				// obt@őLN^
	};

public:
	// {t@NV
	CInfo(CFrmWnd *pWnd, CStatusBar *pBar);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp
	void FASTCALL Enable(BOOL bEnable);
										// 쐧

	// LvV
	void FASTCALL ResetCaption();
										// LvVZbg
	void FASTCALL UpdateCaption();
										// LvVXV

	// 
	void FASTCALL SetInfo(CString& strInfo);
										// ݒ
	void FASTCALL SetMessageString(const CString& strMessage) const;
										// ʏ탁bZ[Wݒ
	void FASTCALL UpdateInfo();
										// XV

	// Xe[^X
	void FASTCALL ResetStatus();
										// Xe[^XZbg
	void FASTCALL UpdateStatus();
										// Xe[^XXV
	void FASTCALL DrawStatus(int nPane, HDC hDC, CRect& rectDraw);
										// Xe[^X`

	// Xe[^Xr[
	void FASTCALL SetStatusView(CStatusView *pView);
										// Xe[^Xr[ݒ

private:
	// 萔l
	enum {
		CapTimeLong = 1500,				// LvVXV(ʏ)
		CapTimeShort = 300,				// LvVXV()
		InfoTime = 2000,				// \
		PaneMax = 5,					// Xe[^XőyC
		DiskTypeTime = 12				// fBXNʕێ
	};

	// LvV
	BOOL FASTCALL CheckParcent();
										// `FbN
	BOOL FASTCALL CheckVM();
										// VMt@C`FbN
	BOOL FASTCALL CheckMO();
										// MOt@C`FbN
	BOOL FASTCALL CheckCD();
										// CDt@C`FbN
	void FASTCALL SetCaption();
										// LvVݒ
	CString m_strRun;
										// 쒆bZ[W
	CString m_strStop;
										// ~bZ[W
	BOOL m_bRun;
										// XPW[쒆
	BOOL m_bCount;
										// 쁓v
	int m_nParcent;
										// 쁓(-1͔\)
	DWORD m_dwTick;
										// v(GetTickCount)
	DWORD m_dwTime;
										// v(GetTotalTime)
	TCHAR m_szVM[_MAX_PATH];
										// VMt@CpX
	TCHAR m_szVMFull[_MAX_PATH];
										// VMt@CpX(t)
	TCHAR m_szMO[_MAX_PATH];
										// MOt@CpX
	TCHAR m_szMOFull[_MAX_PATH];
										// MOt@CpX(t)
	TCHAR m_szCD[_MAX_PATH];
										// CDt@CpX
	TCHAR m_szCDFull[_MAX_PATH];
										// CDt@CpX(t)
	CScheduler *m_pSch;
										// XPW[(Win)
	Scheduler *m_pScheduler;
										// XPW[
	SASI *m_pSASI;
										// SASI
	SCSI *m_pSCSI;
										// SCSI

	// 
	BOOL m_bInfo;
										// ̗L
	BOOL m_bPower;
										// dON/OFF
	CString m_strInfo;
										// 񕶎
	CString m_strPower;
										// dOFF
	CString m_strCaption;
										// LvVݒ蕶
	TCHAR m_szInfo[InfoBufMax];
										// ʏ핶
	DWORD m_dwInfo;
										// \

	// Xe[^X
	COLORREF FASTCALL StatusFloppy(LPTSTR szText, int nDrive) const;
										// Xe[^XFD
	COLORREF FASTCALL StatusHardDisk(LPTSTR szText);
										// Xe[^XHD
	COLORREF FASTCALL StatusTimer(LPTSTR szText) const;
										// Xe[^XTIMER
	COLORREF FASTCALL StatusPower(LPTSTR szText) const;
										// Xe[^XPOWER
	COLORREF m_colStatus[PaneMax];
										// Xe[^X\F
	TCHAR m_szStatus[PaneMax][_MAX_PATH];
										// Xe[^X
	BYTE m_bmpDrive[2][0x100];
										// Xe[^XhCuBMP
	FDD *m_pFDD;
										// FDD
	RTC *m_pRTC;
										// RTC
	DWORD m_dwNumber;
										// XVio
	DWORD m_dwDiskID;
										// fBXNBUSY
	DWORD m_dwDiskTime;
										// fBXNʕێ

	// Xe[^Xo[
	CStatusBar *m_pStatusBar;
										// Xe[^Xo[

	// Xe[^Xr[
	CStatusView *m_pStatusView;
										// Xe[^Xr[

	// RtBM[V
	BOOL m_bFloppyLED;
										// [^ONLED_
	BOOL m_bPowerLED;
										// FdLED
	BOOL m_bCaptionInfo;
										// LvVւ̏\
};

#endif	// mfc_info_h
#endif	// _WIN32
