//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Cvbg ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "crtc.h"
#include "keyboard.h"
#include "mouse.h"
#include "ppi.h"
#include "fileio.h"
#include "mfc_frm.h"
#include "mfc_com.h"
#include "mfc_sch.h"
#include "mfc_res.h"
#include "mfc_cfg.h"
#include "mfc_inp.h"

//===========================================================================
//
//	Cvbg
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CInput::CInput(CFrmWnd *pWnd) : CComponent(pWnd)
{
	int i;
	int nAxis;
	int nButton;

	// R|[lgp[^
	m_dwID = MAKEID('I', 'N', 'P', ' ');
	m_strDesc = _T("Input Manager");

	// ʃ[N
	m_lpDI = NULL;
	m_bActive = TRUE;
	m_bMenu = FALSE;
	m_pCRTC = NULL;
	m_dwDispCount = 0;
	m_dwProcessCount = 0;

	// L[{[h[N
	m_pKeyboard = NULL;
	m_lpDIKey = NULL;
	m_dwKeyAcquire = 0;
	m_bKeyEnable = TRUE;

	// L[obt@NA
	for (i=0; i<0x100; i++) {
		m_KeyBuf[i] = FALSE;
		m_KeyMap[i] = 0;
	}	

	// }EX[N
	m_pMouse = NULL;
	m_lpDIMouse = NULL;
	m_dwMouseAcquire = 0;
	m_bMouseMode = FALSE;
	m_nMouseX = 0;
	m_nMouseY = 0;
	m_bMouseB[0] = FALSE;
	m_bMouseB[1] = FALSE;
	m_dwMouseMid = 0;
	m_bMouseMid = TRUE;

	// WCXeBbN[N
	m_pPPI = NULL;
	m_dwJoyDevs = 0;
	m_bJoyEnable = TRUE;
	for (i=0; i<JoyDevices; i++) {
		// foCX
		m_lpDIJoy[i] = NULL;
		m_lpDIDev2[i] = NULL;

		// RtBO
		memset(&m_JoyCfg[i], 0, sizeof(JOYCFG));
		// nDevice̐ݒ:
		// 蓖ăfoCX+1 (0͖蓖)
		m_JoyCfg[i].nDevice = i + 1;
		for (nAxis=0; nAxis<JoyAxes; nAxis++) {
			if (nAxis < 4) {
				// dwAxis̐ݒ:
				// ʃ[h 蓖ă|[g (0x00000 or 0x10000)
				// ʃ[h 蓖Ď+1 (1`4A0͖蓖)
				m_JoyCfg[i].dwAxis[nAxis] = (DWORD)((i << 16) | (nAxis + 1));
			}
			m_JoyCfg[i].bAxis[nAxis] = FALSE;
		}
		for (nButton=0; nButton<JoyButtons; nButton++) {
			if (nButton < 8) {
				// dwButton̐ݒ:
				// ʃ[h 蓖ă|[g (0x00000 or 0x10000)
				// ʃ[h 蓖ă{^+1 (1`8A0͖蓖)
				m_JoyCfg[i].dwButton[nButton] = (DWORD)((i << 16) | (nButton + 1));
			}
			// A˂ȂAJE^
			m_JoyCfg[i].dwRapid[nButton] = 0;
			m_JoyCfg[i].dwCount[nButton] = 0;
		}

		// W
		memset(m_lJoyAxisMin[i], 0, sizeof(m_lJoyAxisMin[i]));
		memset(m_lJoyAxisMax[i], 0, sizeof(m_lJoyAxisMax[i]));

		// lJE^
		m_dwJoyAcquire[i] = 0;

		// ̓f[^
		memset(&m_JoyState[i], 0, sizeof(DIJOYSTATE));
	}

	// L[}bv(Config ManagerƂ̘Agl[u)
	SetDefaultKeyMap(m_KeyMap);
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::Init()
{
	ASSERT(this);

	// {NX
	if (!CComponent::Init()) {
		return FALSE;
	}

	// CRTC擾
	ASSERT(!m_pCRTC);
	m_pCRTC = (CRTC*)::GetVM()->SearchDevice(MAKEID('C', 'R', 'T', 'C'));
	ASSERT(m_pCRTC);

	// L[{[h擾
	ASSERT(!m_pKeyboard);
	m_pKeyboard = (Keyboard*)::GetVM()->SearchDevice(MAKEID('K', 'E', 'Y', 'B'));
	ASSERT(m_pKeyboard);

	// }EX擾
	ASSERT(!m_pMouse);
	m_pMouse = (Mouse*)::GetVM()->SearchDevice(MAKEID('M', 'O', 'U', 'S'));
	ASSERT(m_pMouse);

	// PPI擾
	ASSERT(!m_pPPI);
	m_pPPI = (PPI*)::GetVM()->SearchDevice(MAKEID('P', 'P', 'I', ' '));
	ASSERT(m_pPPI);

	// DirectInputIuWFNg쐬
	if (FAILED(DirectInputCreate(AfxGetApp()->m_hInstance, DIRECTINPUT_VERSION,
							&m_lpDI, NULL))) {
		return FALSE;
	}

	// L[{[h
	if (!InitKey()) {
		return FALSE;
	}

	// }EX
	if (!InitMouse()) {
		return FALSE;
	}

	// WCXeBbN
	EnumJoy();
	InitJoy();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CInput::Cleanup()
{
	int i;

	ASSERT(this);
	ASSERT_VALID(this);

	// }EX[h
	SetMouseMode(FALSE);

	// WCXeBbNfoCX
	for (i=0; i<JoyDevices; i++) {
		if (m_lpDIDev2[i]) {
			m_lpDIDev2[i]->Release();
			m_lpDIDev2[i] = NULL;
		}

		if (m_lpDIJoy[i]) {
			m_lpDIJoy[i]->Unacquire();
			m_lpDIJoy[i]->Release();
			m_lpDIJoy[i] = NULL;
		}
	}

	// }EXfoCX
	if (m_lpDIMouse) {
		m_lpDIMouse->Unacquire();
		m_lpDIMouse->Release();
		m_lpDIMouse = NULL;
	}

	// L[{[hfoCX
	if (m_lpDIKey) {
		m_lpDIKey->Unacquire();
		m_lpDIKey->Release();
		m_lpDIKey = NULL;
	}

	// DirectInputIuWFNg
	if (m_lpDI) {
		m_lpDI->Release();
		m_lpDI = NULL;
	}

	// {NX
	CComponent::Cleanup();
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CInput::ApplyCfg(const Config* pConfig)
{
	BOOL bFlag;
	int i;
	int nButton;
	int nConfig;

	ASSERT(this);
	ASSERT(pConfig);
	ASSERT_VALID(this);

	// }EX{^
	m_bMouseMid = pConfig->mouse_mid;

	// {^JEg𖳌
	m_dwMouseMid = 5;

	// WCXeBbNfoCX(foCXύXn)
	bFlag = FALSE;
	for (i=0; i<JoyDevices; i++) {
		// gfoCXNo.ςĂAďKv
		if (pConfig->joy_dev[i] != m_JoyCfg[i].nDevice) {
			m_JoyCfg[i].nDevice = pConfig->joy_dev[i];
			bFlag = TRUE;
		}
	}
	if (bFlag) {
		// ď
		InitJoy();
	}

	// WCXeBbNfoCX({^n)
	for (i=0; i<JoyDevices; i++) {
		for (nButton=0; nButton<JoyButtons; nButton++) {
			// RtBOf[^擾(bit16:|[g bit15-8:A bit7-0:{^)
			if (i == 0) {
				nConfig = pConfig->joy_button0[nButton];
			}
			else {
				nConfig = pConfig->joy_button1[nButton];
			}

			// 
			m_JoyCfg[i].dwButton[nButton] = 0;
			m_JoyCfg[i].dwRapid[nButton] = 0;
			m_JoyCfg[i].dwCount[nButton] = 0;

			// 蓖Ă`FbN
			if ((nConfig & 0xff) == 0) {
				continue;
			}

			// {^𒴂ĂȂ`FbN
			if ((nConfig & 0xff) > PPI::ButtonMax) {
				continue;
			}

			// {^蓖Đݒ
			m_JoyCfg[i].dwButton[nButton] = (DWORD)(nConfig & 0xff00ff);

			// Aːݒ
			m_JoyCfg[i].dwRapid[nButton] = (DWORD)((nConfig >> 8) & 0xff);
			if (m_JoyCfg[i].dwRapid[nButton] > JoyRapids) {
				// ͈̓I[ȍꍇAA˂ȂƂ
				m_JoyCfg[i].dwRapid[nButton] = 0;
			}
		}
	}
}

#if defined(_DEBUG)
//---------------------------------------------------------------------------
//
//	ff
//
//---------------------------------------------------------------------------
void CInput::AssertValid() const
{
	ASSERT(this);
	ASSERT(GetID() == MAKEID('I', 'N', 'P', ' '));
	ASSERT(m_pCRTC);
	ASSERT(m_pCRTC->GetID() == MAKEID('C', 'R', 'T', 'C'));
	ASSERT(m_pKeyboard);
	ASSERT(m_pKeyboard->GetID() == MAKEID('K', 'E', 'Y', 'B'));
	ASSERT(m_pMouse);
	ASSERT(m_pMouse->GetID() == MAKEID('M', 'O', 'U', 'S'));
	ASSERT(m_pPPI);
	ASSERT(m_pPPI->GetID() == MAKEID('P', 'P', 'I', ' '));
}
#endif	// _DEBUG

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::Save(Fileio *pFio, int /*nVer*/)
{
	BOOL bResult;

	ASSERT(this);
	ASSERT(pFio);
	ASSERT_VALID(this);

	// VMbNAꎞIɐis~߂
	::LockVM();

	// Z[u{
	bResult = SaveMain(pFio);

	// VMAbN
	::UnlockVM();

	// ʂA
	return bResult;
}

//---------------------------------------------------------------------------
//
//	Z[u{
//
//---------------------------------------------------------------------------
BOOL CInput::SaveMain(Fileio *pFio)
{
	ASSERT(this);
	ASSERT(pFio);
	ASSERT_VALID(this);

	//
	//	version2.00
	//

	// S
	if (!pFio->Write(&m_dwProcessCount, sizeof(m_dwProcessCount))) {
		return FALSE;
	}
	if (!pFio->Write(&m_dwDispCount, sizeof(m_dwDispCount))) {
		return FALSE;
	}

	// L[{[h
	if (!pFio->Write(m_KeyBuf, sizeof(m_KeyBuf))) {
		return FALSE;
	}

	// }EX
	if (!pFio->Write(&m_nMouseX, sizeof(m_nMouseX))) {
		return FALSE;
	}
	if (!pFio->Write(&m_nMouseY, sizeof(m_nMouseY))) {
		return FALSE;
	}
	if (!pFio->Write(&m_dwMouseMid, sizeof(m_dwMouseMid))) {
		return FALSE;
	}

	// WCXeBbN
	if (!pFio->Write(m_JoyState, sizeof(m_JoyState))) {
		return FALSE;
	}

	//
	//	version2.01
	//

	// L[{[h
	if (!pFio->Write(m_KeyMap, sizeof(m_KeyMap))) {
		return FALSE;
	}

	// }EX
	if (!pFio->Write(m_bMouseB, sizeof(m_bMouseB))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::Load(Fileio *pFio, int nVer)
{
	ASSERT(this);
	ASSERT(pFio);
	ASSERT(nVer >= 0x0200);
	ASSERT_VALID(this);

	// VMbNAꎞIɐis~߂
	::LockVM();

	// [h(version2.00)
	if (!Load200(pFio)) {
		::UnlockVM();
		return FALSE;
	}

	if (nVer >= 0x0201) {
		// version2.01
		if (!Load201(pFio)) {
			::UnlockVM();
			return FALSE;
		}
	}

	// VMAbN
	::UnlockVM();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h{ (version2.00)
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::Load200(Fileio *pFio)
{
	ASSERT(this);
	ASSERT(pFio);
	ASSERT_VALID(this);

	// S
	if (!pFio->Read(&m_dwProcessCount, sizeof(m_dwProcessCount))) {
		return FALSE;
	}
	if (!pFio->Read(&m_dwDispCount, sizeof(m_dwDispCount))) {
		return FALSE;
	}

	// L[{[h
	if (!pFio->Read(m_KeyBuf, sizeof(m_KeyBuf))) {
		return FALSE;
	}

	// }EX
	if (!pFio->Read(&m_nMouseX, sizeof(m_nMouseX))) {
		return FALSE;
	}
	if (!pFio->Read(&m_nMouseY, sizeof(m_nMouseY))) {
		return FALSE;
	}
	if (!pFio->Read(&m_dwMouseMid, sizeof(m_dwMouseMid))) {
		return FALSE;
	}

	// WCXeBbN
	if (!pFio->Read(m_JoyState, sizeof(m_JoyState))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h{ (version2.01)
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::Load201(Fileio *pFio)
{
	ASSERT(this);
	ASSERT(pFio);
	ASSERT_VALID(this);

	// L[{[h
	if (!pFio->Read(m_KeyMap, sizeof(m_KeyMap))) {
		return FALSE;
	}

	// }EX
	if (!pFio->Read(m_bMouseB, sizeof(m_bMouseB))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	is
//
//---------------------------------------------------------------------------
void FASTCALL CInput::Process(BOOL bRun)
{
	DWORD dwDispCount;

	ASSERT(this);
	ASSERT_VALID(this);

	// fBZ[uȂ牽Ȃ
	if (!m_bEnable) {
		return;
	}

	// bRun = FALSEȂAXPW[~(10msɌĂ΂)
	if (!bRun) {
		// isJE^Up
		m_dwProcessCount++;

		// _~[
		InputKey(FALSE);
		InputMouse(FALSE);
		InputJoy(FALSE);
		return;
	}

	// CRTC̕\JE^āAt[Ƃɏ
	ASSERT(m_pCRTC);
	dwDispCount = m_pCRTC->GetDispCount();
	if (dwDispCount == m_dwDispCount) {
		return;
	}
	m_dwDispCount = dwDispCount;

	// isJE^Up
	m_dwProcessCount++;

	// ANeBułȂA܂̓j[Ȃ_~[
	if (!m_bActive || m_bMenu) {
		// _~[
		InputKey(FALSE);
		InputMouse(FALSE);
		InputJoy(FALSE);
		MakeJoy(FALSE);
		return;
	}

	// okA͏ł
	InputKey(TRUE);
	InputMouse(TRUE);
	InputJoy(TRUE);
	MakeJoy(m_bJoyEnable);
}

//---------------------------------------------------------------------------
//
//	ANeBx[gʒm
//
//---------------------------------------------------------------------------
void FASTCALL CInput::Activate(BOOL bActive)
{
	ASSERT(this);
	ASSERT_VALID(this);

	// ANeButOɔf
	m_bActive = bActive;
}

//---------------------------------------------------------------------------
//
//	j[ʒm
//
//---------------------------------------------------------------------------
void FASTCALL CInput::Menu(BOOL bMenu)
{
	ASSERT(this);
	ASSERT_VALID(this);

	// j[tOɔf
	m_bMenu = bMenu;
}

//---------------------------------------------------------------------------
//
//	lJE^擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CInput::GetAcquireCount(int nType) const
{
	ASSERT(this);
	ASSERT(JoyDevices >= 2);
	ASSERT_VALID(this);

	switch (nType) {
		// 0:L[{[h
		case 0:
			return m_dwKeyAcquire;

		// 1:}EX
		case 1:
			return m_dwMouseAcquire;

		// 2:WCXeBbNA
		case 2:
			return m_dwJoyAcquire[0];

		// 3:WCXeBbNB
		case 3:
			return m_dwJoyAcquire[1];

		// ̑
		default:
			break;
	}

	// ʏAɂ͂Ȃ
	ASSERT(FALSE);
	return 0;
}

//===========================================================================
//
//	L[{[h
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	L[{[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::InitKey()
{
	ASSERT(this);
	ASSERT(m_lpDI);
	ASSERT(!m_lpDIKey);
	ASSERT_VALID(this);

	// L[{[hfoCX쐬
	if (FAILED(m_lpDI->CreateDevice(GUID_SysKeyboard, &m_lpDIKey, NULL))) {
		return FALSE;
	}

	// L[{[hf[^`ݒ
	if (FAILED(m_lpDIKey->SetDataFormat(&c_dfDIKeyboard))) {
		return FALSE;
	}

	// xݒ
	if (FAILED(m_lpDIKey->SetCooperativeLevel(m_pFrmWnd->m_hWnd,
						DISCL_BACKGROUND | DISCL_NONEXCLUSIVE))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	L[{[h
//
//---------------------------------------------------------------------------
void FASTCALL CInput::InputKey(BOOL bEnable)
{
	HRESULT hr;
	BYTE buf[0x100];
	DWORD dwCode;
	int nKey;

	ASSERT(this);
	ASSERT(m_lpDIKey);
	ASSERT_VALID(this);

	// ݃`FbN
	if (!m_lpDIKey) {
		return;
	}

	// OKł΃foCXԂ擾AłȂ΂ׂOFF
	if (bEnable || !m_bKeyEnable) {
		hr = m_lpDIKey->GetDeviceState(sizeof(buf), buf);
		if (hr != DI_OK) {
			// G[ȂANZX擾Ă
			m_lpDIKey->Acquire();
			m_dwKeyAcquire++;
			return;
		}
	}
	else {
		// ݂̓L[{[h͖
		memset(buf, 0, sizeof(buf));
	}

	// Win2000,WinXPDIK_KANJI,DIK_KANAbN̂ONȂ
	if (::IsWinNT()) {
		buf[DIK_KANJI] = 0;
		buf[DIK_KANA] = 0;
	}

	// L[̏ꍇWin32ɏĂ
	if (!m_bKeyEnable) {
		// HL[obt@ɋL
		for (nKey=0; nKey<0x100; nKey++) {
			if (buf[nKey] & 0x80) {
				m_KeyBuf[nKey] = TRUE;
			}
			else {
				m_KeyBuf[nKey] = FALSE;
			}
		}
		return;
	}

	// ALT+L[̓}bvĂȂ΁A
	if (buf[DIK_LMENU] & 0x80) {
		if (m_KeyMap[DIK_LMENU] == 0) {
			// }bvĂȂ̂ŁA
			return;
		}
	}
	if (buf[DIK_RMENU] & 0x80) {
		if (m_KeyMap[DIK_RMENU] == 0) {
			// }bvĂȂ̂ŁA
			return;
		}
	}

	// VtgL[Ԃ␳
	if (buf[DIK_LSHIFT] | buf[DIK_RSHIFT] & 0x80) {
		buf[DIK_LSHIFT] |= 0x80;
		buf[DIK_RSHIFT] |= 0x80;
	}

	// [v
	for (nKey=0; nKey<0x100; nKey++) {
		if (buf[nKey] & 0x80) {
			// L[ĂAobt@͂ǂ
			if (m_KeyBuf[nKey] == FALSE) {
				// ԑJ(ꂽ)
				m_KeyBuf[nKey] = TRUE;
				// L[ϊ}bv`FbNāALȂ瑗o
				dwCode = m_KeyMap[nKey];
				if (dwCode != 0) {
					m_pKeyboard->MakeKey(dwCode);
				}
			}
		}
		else {
			// L[ĂAobt@͂ǂ
			if (m_KeyBuf[nKey] == TRUE) {
				// ԑJ(ꂽ)
				m_KeyBuf[nKey] = FALSE;
				// L[ϊ}bv`FbNāALȂ瑗o
				dwCode = m_KeyMap[nKey];
				if (dwCode != 0) {
					m_pKeyboard->BreakKey(dwCode);
				}
			}
		}
	}
}

//---------------------------------------------------------------------------
//
//	ftHgL[}bvݒ
//
//---------------------------------------------------------------------------
void FASTCALL CInput::SetDefaultKeyMap(DWORD *pKeyMap)
{
	const DWORD *pTable;
	DWORD dwDX;
	DWORD dw68;

	// ASSERT_VALID͓Ȃ(RXgN^Ă΂)
	ASSERT(this);
	ASSERT(pKeyMap);

	// e[u({106 Only)
	pTable = m_KeyMap106;

	// UNA
	memset(pKeyMap, 0, sizeof(DWORD) * 0x100);

	// [v(X68kADIKR[h)
	dw68 = 0x0001;
	for (;;) {
		// DIKR[h擾
		dwDX = *pTable++;

		// 0xffŏI
		if (dwDX == 0xff) {
			break;
		}

		// 0łȂ΁ÃL[X68kR[h蓖Ă
		if (dwDX != 0) {
			pKeyMap[dwDX] = dw68;
			// DIKLSHIFTȂARSHIFT
			if (dwDX == DIK_LSHIFT) {
				pKeyMap[DIK_RSHIFT] = dw68;
			}
		}

		// 
		dw68++;
	}
}

//---------------------------------------------------------------------------
//
//	ftHg}bv(106L[{[h)
//
//---------------------------------------------------------------------------
const DWORD CInput::m_KeyMap106[] = {
	DIK_ESCAPE,							// 01 [ESC]
	DIK_1,								// 02 [1]
	DIK_2,								// 03 [2]
	DIK_3,								// 04 [3]
	DIK_4,								// 05 [4]
	DIK_5,								// 06 [5]
	DIK_6,								// 07 [6]
	DIK_7,								// 08 [7]
	DIK_8,								// 09 [8]
	DIK_9,								// 0A [9]
	DIK_0,								// 0B [0]
	DIK_MINUS,							// 0C [-]
	DIK_CIRCUMFLEX,						// 0D [^]
	DIK_YEN,							// 0E [\]
	DIK_BACK,							// 0F [BS]

	DIK_TAB,							// 10 [TAB]
	DIK_Q,								// 11 [Q]
	DIK_W,								// 12 [W]
	DIK_E,								// 13 [E]
	DIK_R,								// 14 [R]
	DIK_T,								// 15 [T]
	DIK_Y,								// 16 [Y]
	DIK_U,								// 17 [U]
	DIK_I,								// 18 [I]
	DIK_O,								// 19 [O]
	DIK_P,								// 1A [P]
	DIK_AT,								// 1B [@]
	DIK_LBRACKET,						// 1C [[]
	DIK_RETURN,							// 1D [CR]

	DIK_A,								// 1E [A]
	DIK_S,								// 1F [S]
	DIK_D,								// 20 [D]
	DIK_F,								// 21 [F]
	DIK_G,								// 22 [G]
	DIK_H,								// 23 [H]
	DIK_J,								// 24 [J]
	DIK_K,								// 25 [K]
	DIK_L,								// 26 [L]
	DIK_SEMICOLON,						// 27 [;]
	DIK_COLON,							// 28 [:]
	DIK_RBRACKET,						// 29 []]

	DIK_Z,								// 2A [Z]
	DIK_X,								// 2B [X]
	DIK_C,								// 2C [C]
	DIK_V,								// 2D [V]
	DIK_B,								// 2E [B]
	DIK_N,								// 2F [N]
	DIK_M,								// 30 [M]
	DIK_COMMA,							// 31 [,]
	DIK_PERIOD,							// 32 [.]
	DIK_SLASH,							// 33 [/]
	DIK_BACKSLASH,						// 34 [_]

	DIK_SPACE,							// 35 [SPACE]

	DIK_HOME,							// 36 [HOME]
	DIK_DELETE,							// 37 [DEL]
	DIK_NEXT,							// 38 [ROLL UP]
	DIK_PRIOR,							// 39 [ROLL DOWN]
	DIK_END,							// 3A [UNDO]

	DIK_LEFT,							// 3B [LEFT]
	DIK_UP,								// 3C [UP]
	DIK_RIGHT,							// 3D [RIGHT]
	DIK_DOWN,							// 3E [DOWN]

	DIK_NUMLOCK,						// 3F [Tenkey CLR]
	DIK_DIVIDE,							// 40 [Tenkey /]
	DIK_MULTIPLY,						// 41 [Tenkey *]
	DIK_SUBTRACT,						// 42 [Tenkey -]
	DIK_NUMPAD7,						// 43 [Tenkey 7]
	DIK_NUMPAD8,						// 44 [Tenkey 8]
	DIK_NUMPAD9,						// 45 [Tenkey 9]
	DIK_ADD,							// 46 [Tenkey +]
	DIK_NUMPAD4,						// 47 [Tenkey 4]
	DIK_NUMPAD5,						// 48 [Tenkey 5]
	DIK_NUMPAD6,						// 49 [Tenkey 6]
	0,									// 4A [Tenkey =]
	DIK_NUMPAD1,						// 4B [Tenkey 1]
	DIK_NUMPAD2,						// 4C [Tenkey 2]
	DIK_NUMPAD3,						// 4D [Tenkey 3]
	DIK_NUMPADENTER,					// 4E [Tenkey CR]
	DIK_NUMPAD0,						// 4F [Tenkey 0]
	0,									// 50 [Tenkey ,]
	DIK_DECIMAL,						// 51 [Tenkey .]

	0,									// 52 [L]
	0,									// 53 [o^]
	0,									// 54 [HELP]

	0,									// 55 [XF1]
	0,									// 56 [XF2]
	0,									// 57 [XF3]
	0,									// 58 [XF4]
	0,									// 59 [XF5]

	0,									// 5A []
	0,									// 5B [[}]
	0,									// 5C [R[h]
	DIK_CAPITAL,						// 5D [CAPS]

	DIK_INSERT,							// 5E [INS]
	0,									// 5F [Ђ炪]
	0,									// 60 [Sp]

	DIK_PAUSE,							// 61 [BREAK]
	0,									// 62 [COPY]
	DIK_F1,								// 63 [F1]
	DIK_F2,								// 64 [F2]
	DIK_F3,								// 65 [F3]
	DIK_F4,								// 66 [F4]
	DIK_F5,								// 67 [F5]
	DIK_F6,								// 68 [F6]
	DIK_F7,								// 69 [F7]
	DIK_F8,								// 6A [F8]
	DIK_F9,								// 6B [F9]
	DIK_F11,							// 6C [F10]
	0,									// 6D (Reserved)
	0,									// 6E (Reserved)
	0,									// 6F (Reserved)
	DIK_LSHIFT,							// 70 [SHIFT]
	DIK_LCONTROL,						// 71 [CTRL]
	0,									// 72 [OPT1]
	0,									// 73 [OPT2]
	0xff
};

//---------------------------------------------------------------------------
//
//	L[͏擾
//
//---------------------------------------------------------------------------
void FASTCALL CInput::GetKeyBuf(BOOL *pKeyBuf) const
{
	ASSERT(this);
	ASSERT(pKeyBuf);
	ASSERT_VALID(this);

	// ݂̃obt@Rs[
	memcpy(pKeyBuf, m_KeyBuf, sizeof(m_KeyBuf));
}

//---------------------------------------------------------------------------
//
//	L[LE
//
//---------------------------------------------------------------------------
void FASTCALL CInput::EnableKey(BOOL bEnable)
{
	DWORD dwCode;
	int nKey;

	ASSERT(this);
	ASSERT_VALID(this);

	// ȂKvȂ
	if (m_bKeyEnable == bEnable) {
		return;
	}

	// ύX
	m_bKeyEnable = bEnable;

	// TRUȄꍇAȂ
	if (m_bKeyEnable) {
		return;
	}

	// FALSȄꍇA݉ĂL[ׂBreak
	for (nKey=0; nKey<0x100; nKey++) {
		// L[ĂAobt@͂ǂ
		if (m_KeyBuf[nKey] == TRUE) {
			// L[ϊ}bv`FbNāALȂ瑗o
			dwCode = m_KeyMap[nKey];
			if (dwCode != 0) {
				m_pKeyboard->BreakKey(dwCode);
			}
		}
	}
}

//---------------------------------------------------------------------------
//
//	X68000L[R[hDirectXL[R[h
//
//---------------------------------------------------------------------------
int FASTCALL CInput::Key2DirectX(int nKey)
{
	int nIndex;

	ASSERT(this);
	ASSERT((nKey >= 0) && (nKey <= 0x73));

	for (nIndex=0; nIndex<0x100; nIndex++) {
		// L[}bvɓo^Ăok
		if (m_KeyMap[nIndex] == (UINT)nKey) {
			return nIndex;
		}
	}

	// YȂ
	return 0;
}

//---------------------------------------------------------------------------
//
//	DirectXL[R[hX68000L[R[h
//
//---------------------------------------------------------------------------
int FASTCALL CInput::Key2X68k(int nDXKey)
{
	ASSERT(this);
	ASSERT((nDXKey >= 0) && (nDXKey < 0x100));
	ASSERT_VALID(this);

	// L[}bv̂܂ܕԂB蓖ĂȂ0
	return m_KeyMap[nDXKey];
}

//---------------------------------------------------------------------------
//
//	L[̎擾
//
//---------------------------------------------------------------------------
LPCTSTR FASTCALL CInput::GetKeyName(int nKey)
{
	ASSERT((nKey >= 0) && (nKey <= 0x73));

	return KeyNameTable[nKey];
}

//---------------------------------------------------------------------------
//
//	L[̃e[u
//
//---------------------------------------------------------------------------
LPCTSTR CInput::KeyNameTable[] = {
	NULL,
	_T("ESC"),
	_T("1!"),
	_T("2\x22"),
	_T("3#"),
	_T("4$"),
	_T("5%"),
	_T("6&"),
	_T("7'Ԭ"),
	_T("8(խ"),
	_T("9)֮"),
	_T("0 ܦ"),
	_T("-="),
	_T("^~"),
	_T("\\|"),
	_T("BS"),

	_T("TAB"),
	_T("Q "),
	_T("W "),
	_T("E "),
	_T("R "),
	_T("T "),
	_T("Y "),
	_T("U "),
	_T("I "),
	_T("O "),
	_T("P "),
	_T("@`"),
	_T("[{"),
	_T("RETURN"),

	_T("A "),
	_T("S "),
	_T("D "),
	_T("F "),
	_T("G "),
	_T("H "),
	_T("J "),
	_T("K "),
	_T("L "),
	_T(";+"),
	_T(":*"),
	_T("]}ѣ"),

	_T("Z ¯"),
	_T("X "),
	_T("C "),
	_T("V "),
	_T("B "),
	_T("N "),
	_T("M "),
	_T(",<Ȥ"),
	_T(".>١"),
	_T("/?ҥ"),
	_T(" _"),
	_T("SPACE"),

	_T("HOME"),
	_T("DEL"),
	_T("ROLL UP"),
	_T("ROLL DOWN"),
	_T("UNDO"),
	_T(""),
	_T(""),
	_T(""),
	_T(""),

	_T("CLR"),
	_T("/"),
	_T("*"),
	_T("-"),
	_T("7"),
	_T("8"),
	_T("9"),
	_T("+"),
	_T("4"),
	_T("5"),
	_T("6"),
	_T("="),
	_T("1"),
	_T("2"),
	_T("3"),
	_T("ENTER"),
	_T("0"),
	_T(","),
	_T("."),

	_T("L"),
	_T("o^"),
	_T("HELP"),

	_T("XF1"),
	_T("XF2"),
	_T("XF3"),
	_T("XF4"),
	_T("XF5"),

	_T(""),
	_T("۰ώ"),
	_T("ޓ"),
	_T("CAPS"),
	_T("INS"),
	_T("Ђ炪"),
	_T("Sp"),

	_T("BREAK"),
	_T("COPY"),
	_T("F1"),
	_T("F2"),
	_T("F3"),
	_T("F4"),
	_T("F5"),
	_T("F6"),
	_T("F7"),
	_T("F8"),
	_T("F9"),
	_T("F10"),
	NULL,
	NULL,
	NULL,

	_T("SHIFT"),
	_T("CTRL"),
	_T("OPT.1"),
	_T("OPT.2")
};

//---------------------------------------------------------------------------
//
//	L[ID擾
//
//---------------------------------------------------------------------------
LPCSTR FASTCALL CInput::GetKeyID(int nID)
{
	ASSERT((nID >= 0) && (nID < 0x100));

	return KeyIDTable[nID];
}

//---------------------------------------------------------------------------
//
//	DirectX L[IDe[u
//
//---------------------------------------------------------------------------
LPCSTR CInput::KeyIDTable[] = {
	NULL,							// 0x00
	_T("DIK_ESCAPE"),				// 0x01
	_T("DIK_1"),					// 0x02
	_T("DIK_2"),					// 0x03
	_T("DIK_3"),					// 0x04
	_T("DIK_4"),					// 0x05
	_T("DIK_5"),					// 0x06
	_T("DIK_6"),					// 0x07
	_T("DIK_7"),					// 0x08
	_T("DIK_8"),					// 0x09
	_T("DIK_9"),					// 0x0A
	_T("DIK_0"),					// 0x0B
	_T("DIK_MINUS"),				// 0x0C
	_T("DIK_EQUALS"),				// 0x0D
	_T("DIK_BACK"),					// 0x0E
	_T("DIK_TAB"),					// 0x0F
	_T("DIK_Q"),					// 0x10
	_T("DIK_W"),					// 0x11
	_T("DIK_E"),					// 0x12
	_T("DIK_R"),					// 0x13
	_T("DIK_T"),					// 0x14
	_T("DIK_Y"),					// 0x15
	_T("DIK_U"),					// 0x16
	_T("DIK_I"),					// 0x17
	_T("DIK_O"),					// 0x18
	_T("DIK_P"),					// 0x19
	_T("DIK_LBRACKET"),				// 0x1A
	_T("DIK_RBRACKET"),				// 0x1B
	_T("DIK_RETURN"),				// 0x1C
	_T("DIK_LCONTROL"),				// 0x1D
	_T("DIK_A"),					// 0x1E
	_T("DIK_S"),					// 0x1F
	_T("DIK_D"),					// 0x20
	_T("DIK_F"),					// 0x21
	_T("DIK_G"),					// 0x22
	_T("DIK_H"),					// 0x23
	_T("DIK_J"),					// 0x24
	_T("DIK_K"),					// 0x25
	_T("DIK_L"),					// 0x26
	_T("DIK_SEMICOLON"),			// 0x27
	_T("DIK_APOSTROPHE"),			// 0x28
	_T("DIK_GRAVE"),				// 0x29
	_T("DIK_LSHIFT"),				// 0x2A
	_T("DIK_BACKSLASH"),			// 0x2B
	_T("DIK_Z"),					// 0x2C
	_T("DIK_X"),					// 0x2D
	_T("DIK_C"),					// 0x2E
	_T("DIK_V"),					// 0x2F
	_T("DIK_B"),					// 0x30
	_T("DIK_N"),					// 0x31
	_T("DIK_M"),					// 0x32
	_T("DIK_COMMA"),				// 0x33
	_T("DIK_PERIOD"),				// 0x34
	_T("DIK_SLASH"),				// 0x35
	_T("DIK_RSHIFT"),				// 0x36
	_T("DIK_MULTIPLY"),				// 0x37
	_T("DIK_LMENU"),				// 0x38
	_T("DIK_SPACE"),				// 0x39
	_T("DIK_CAPITAL"),				// 0x3A
	_T("DIK_F1"),					// 0x3B
	_T("DIK_F2"),					// 0x3C
	_T("DIK_F3"),					// 0x3D
	_T("DIK_F4"),					// 0x3E
	_T("DIK_F5"),					// 0x3F
	_T("DIK_F6"),					// 0x40
	_T("DIK_F7"),					// 0x41
	_T("DIK_F8"),					// 0x42
	_T("DIK_F9"),					// 0x43
	_T("DIK_F10"),					// 0x44
	_T("DIK_NUMLOCK"),				// 0x45
	_T("DIK_SCROLL"),				// 0x46
	_T("DIK_NUMPAD7"),				// 0x47
	_T("DIK_NUMPAD8"),				// 0x48
	_T("DIK_NUMPAD9"),				// 0x49
	_T("DIK_SUBTRACT"),				// 0x4A
	_T("DIK_NUMPAD4"),				// 0x4B
	_T("DIK_NUMPAD5"),				// 0x4C
	_T("DIK_NUMPAD6"),				// 0x4D
	_T("DIK_ADD"),					// 0x4E
	_T("DIK_NUMPAD1"),				// 0x4F
	_T("DIK_NUMPAD2"),				// 0x50
	_T("DIK_NUMPAD3"),				// 0x51
	_T("DIK_NUMPAD0"),				// 0x52
	_T("DIK_DECIMAL"),				// 0x53
	NULL,							// 0x54
	NULL,							// 0x55
	_T("DIK_OEM_102"),				// 0x56
	_T("DIK_F11"),					// 0x57
	_T("DIK_F12"),					// 0x58
	NULL,							// 0x59
	NULL,							// 0x5A
	NULL,							// 0x5B
	NULL,							// 0x5C
	NULL,							// 0x5D
	NULL,							// 0x5E
	NULL,							// 0x5F
	NULL,							// 0x60
	NULL,							// 0x61
	NULL,							// 0x62
	NULL,							// 0x63
	_T("DIK_F13"),					// 0x64
	_T("DIK_F14"),					// 0x65
	_T("DIK_F15"),					// 0x66
	NULL,							// 0x67
	NULL,							// 0x68
	NULL,							// 0x69
	NULL,							// 0x6A
	NULL,							// 0x6B
	NULL,							// 0x6C
	NULL,							// 0x6D
	NULL,							// 0x6E
	NULL,							// 0x6F
	_T("DIK_KANA"),					// 0x70
	NULL,							// 0x71
	NULL,							// 0x72
	_T("DIK_ABNT_C1"),				// 0x73
	NULL,							// 0x74
	NULL,							// 0x75
	NULL,							// 0x76
	NULL,							// 0x77
	NULL,							// 0x78
	_T("DIK_CONVERT"),				// 0x79
	NULL,							// 0x7A
	_T("DIK_NOCONVERT"),			// 0x7B
	NULL,							// 0x7C
	_T("DIK_YEN"),					// 0x7D
	_T("DIK_ABNT_C2"),				// 0x7E
	NULL,							// 0x7F
	NULL,							// 0x80
	NULL,							// 0x81
	NULL,							// 0x82
	NULL,							// 0x83
	NULL,							// 0x84
	NULL,							// 0x85
	NULL,							// 0x86
	NULL,							// 0x87
	NULL,							// 0x88
	NULL,							// 0x89
	NULL,							// 0x8A
	NULL,							// 0x8B
	NULL,							// 0x8C
	_T("DIK_NUMPADEQUALS"),			// 0x8D
	NULL,							// 0x8E
	NULL,							// 0x8F
	_T("DIK_PREVTRACK"),			// 0x90
	_T("DIK_AT"),					// 0x91
	_T("DIK_COLON"),				// 0x92
	_T("DIK_UNDERLINE"),			// 0x93
	_T("DIK_KANJI"),				// 0x94
	_T("DIK_STOP"),					// 0x95
	_T("DIK_AX"),					// 0x96
	_T("DIK_UNLABELED"),			// 0x97
	NULL,							// 0x98
	_T("DIK_NEXTTRACK"),			// 0x99
	NULL,							// 0x9A
	NULL,							// 0x9B
	_T("DIK_NUMPADENTER"),			// 0x9C
	_T("DIK_RCONTROL"),				// 0x9D
	NULL,							// 0x9E
	NULL,							// 0x9F
	_T("DIK_MUTE"),					// 0xA0
	_T("DIK_CALCULATOR"),			// 0xA1
	_T("DIK_PLAYPAUSE"),			// 0xA2
	NULL,							// 0xA3
	_T("DIK_MEDIASTOP"),			// 0xA4
	NULL,							// 0xA5
	NULL,							// 0xA6
	NULL,							// 0xA7
	NULL,							// 0xA8
	NULL,							// 0xA9
	NULL,							// 0xAA
	NULL,							// 0xAB
	NULL,							// 0xAC
	NULL,							// 0xAD
	_T("DIK_VOLUMEDOWN"),			// 0xAE
	NULL,							// 0xAF
	_T("DIK_VOLUMEUP"),				// 0xB0
	NULL,							// 0xB1
	_T("DIK_WEBHOME"),				// 0xB2
	_T("DIK_NUMPADCOMMA"),			// 0xB3
	NULL,							// 0xB4
	_T("DIK_DIVIDE"),				// 0xB5
	NULL,							// 0xB6
	_T("DIK_SYSRQ"),				// 0xB7
	_T("DIK_RMENU"),				// 0xB8
	NULL,							// 0xB9
	NULL,							// 0xBA
	NULL,							// 0xBB
	NULL,							// 0xBC
	NULL,							// 0xBD
	NULL,							// 0xBE
	NULL,							// 0xBF
	NULL,							// 0xC0
	NULL,							// 0xC1
	NULL,							// 0xC2
	NULL,							// 0xC3
	NULL,							// 0xC4
	_T("DIK_PAUSE"),				// 0xC5
	NULL,							// 0xC6
	_T("DIK_HOME"),					// 0xC7
	_T("DIK_UP"),					// 0xC8
	_T("DIK_PRIOR"),				// 0xC9
	NULL,							// 0xCA
	_T("DIK_LEFT"),					// 0xCB
	NULL,							// 0xCC
	_T("DIK_RIGHT"),				// 0xCD
	NULL,							// 0xCE
	_T("DIK_END"),					// 0xCF
	_T("DIK_DOWN"),					// 0xD0
	_T("DIK_NEXT"),					// 0xD1
	_T("DIK_INSERT"),				// 0xD2
	_T("DIK_DELETE"),				// 0xD3
	NULL,							// 0xD4
	NULL,							// 0xD5
	NULL,							// 0xD6
	NULL,							// 0xD7
	NULL,							// 0xD8
	NULL,							// 0xD9
	NULL,							// 0xDA
	_T("DIK_LWIN"),					// 0xDB
	_T("DIK_RWIN"),					// 0xDC
	_T("DIK_APPS"),					// 0xDD
	_T("DIK_POWER"),				// 0xDE
	_T("DIK_SLEEP"),				// 0xDF
	NULL,							// 0xE0
	NULL,							// 0xE1
	NULL,							// 0xE2
	_T("DIK_WAKE"),					// 0xE3
	NULL,							// 0xE4
	_T("DIK_WEBSEARCH"),			// 0xE5
	_T("DIK_WEBFAVORITES"),			// 0xE6
	_T("DIK_WEBREFRESH"),			// 0xE7
	_T("DIK_WEBSTOP"),				// 0xE8
	_T("DIK_WEBFORWARD"),			// 0xE9
	_T("DIK_WEBBACK"),				// 0xEA
	_T("DIK_MYCOMPUTER"),			// 0xEB
	_T("DIK_MAIL"),					// 0xEC
	_T("DIK_MEDIASELECT"),			// 0xED
	NULL,							// 0xEE
	NULL,							// 0xEF
	NULL,							// 0xF0
	NULL,							// 0xF1
	NULL,							// 0xF2
	NULL,							// 0xF3
	NULL,							// 0xF4
	NULL,							// 0xF5
	NULL,							// 0xF6
	NULL,							// 0xF7
	NULL,							// 0xF8
	NULL,							// 0xF9
	NULL,							// 0xFA
	NULL,							// 0xFB
	NULL,							// 0xFC
	NULL,							// 0xFD
	NULL,							// 0xFE
	NULL							// 0xFF
};

//---------------------------------------------------------------------------
//
//	L[}bv擾
//
//---------------------------------------------------------------------------
void FASTCALL CInput::GetKeyMap(DWORD *pKeyMap)
{
	ASSERT(this);
	ASSERT(pKeyMap);
	ASSERT_VALID(this);

	// ݂̃L[}bvRs[
	memcpy(pKeyMap, m_KeyMap, sizeof(m_KeyMap));
}

//---------------------------------------------------------------------------
//
//	L[}bvݒ
//
//---------------------------------------------------------------------------
void FASTCALL CInput::SetKeyMap(const DWORD *pKeyMap)
{
	// ASSERT_VALID͓Ȃ(ConfigĂ΂)
	ASSERT(this);
	ASSERT(pKeyMap);

	// L[}bvɐݒ
	memcpy(m_KeyMap, pKeyMap, sizeof(m_KeyMap));
}

//---------------------------------------------------------------------------
//
//	L[蓖Ă̗L`FbN
//	R}hnhĂ΂邽߁AXM6Ŋ蓖ĂL[ׂ͂ă`FbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::IsKeyMapped(int nID) const
{
	ASSERT(this);
	ASSERT((nID >= 0) && (nID < 0x100));
	ASSERT_VALID(this);

	// 蓖ăR[h0Ȃ疢gp(}bvĂȂ)
	if (m_KeyMap[nID] == 0) {
		return FALSE;
	}

	// }bvĂ
	return TRUE;
}

//===========================================================================
//
//	}EX
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	}EX
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::InitMouse()
{
	ASSERT(this);
	ASSERT(m_lpDI);
	ASSERT(!m_lpDIMouse);
	ASSERT_VALID(this);

	// }EXfoCX쐬
	if (FAILED(m_lpDI->CreateDevice(GUID_SysMouse, &m_lpDIMouse, NULL))) {
		return FALSE;
	}

	// }EXf[^`ݒ
	if (FAILED(m_lpDIMouse->SetDataFormat(&c_dfDIMouse))) {
		return FALSE;
	}

	// xݒ(Win9x/WinNTŋقȂ邽߁A)
	if (::IsWinNT()) {
		// WindowsNT
		if (FAILED(m_lpDIMouse->SetCooperativeLevel(m_pFrmWnd->m_hWnd,
						DISCL_BACKGROUND | DISCL_NONEXCLUSIVE))) {
			return FALSE;
		}
	}
	else {
		// Windows9x
		if (FAILED(m_lpDIMouse->SetCooperativeLevel(m_pFrmWnd->m_hWnd,
						DISCL_FOREGROUND | DISCL_EXCLUSIVE))) {
			return FALSE;
		}
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	}EX
//
//---------------------------------------------------------------------------
void FASTCALL CInput::InputMouse(BOOL bEnable)
{
	HRESULT hr;
	DIMOUSESTATE dims;

	ASSERT(this);
	ASSERT(m_pFrmWnd);
	ASSERT(m_lpDIMouse);
	ASSERT(m_pMouse);
	ASSERT_VALID(this);

	// Ă悢
	if (!bEnable) {
		// }EX[hOFF
		if (m_bMouseMode) {
			m_pFrmWnd->PostMessage(WM_COMMAND, IDM_MOUSEMODE, 0);
		}

		// {^UPʒm
		m_pMouse->SetMouse(m_nMouseX, m_nMouseY, FALSE, FALSE);
		return;
	}

	// }EX[hON
	if (!m_bMouseMode) {
		// {^UPʒm
		m_pMouse->SetMouse(m_nMouseX, m_nMouseY, FALSE, FALSE);
		return;
	}

	// foCXԂ擾
	hr = m_lpDIMouse->GetDeviceState(sizeof(dims), &dims);
	if (hr != DI_OK) {
		// Acquire݂
		m_lpDIMouse->Acquire();
		m_dwMouseAcquire++;

		// }EXZbg
		m_pMouse->ResetMouse();
		return;
	}

	// f[^m
	m_nMouseX += dims.lX;
	m_nMouseY += dims.lY;
	if (dims.rgbButtons[0] & 0x80) {
		m_bMouseB[0] = TRUE;
	}
	else {
		m_bMouseB[0] = FALSE;
	}
	if (dims.rgbButtons[1] & 0x80) {
		m_bMouseB[1] = TRUE;
	}
	else {
		m_bMouseB[1] = FALSE;
	}

	// }EXfoCX֒ʒm
	m_pMouse->SetMouse(m_nMouseX, m_nMouseY, m_bMouseB[0], m_bMouseB[1]);

	// {^@\֎~Ă΁AI
	if (!m_bMouseMid) {
		m_dwMouseMid = 5;
		return;
	}

	// {^`FbNBAĉėꂽ}EX[hoff
	if (dims.rgbButtons[2] & 0x80) {
		// Ă
		if (m_dwMouseMid < 4) {
			// ZbgԂ
			m_dwMouseMid++;
			if (m_dwMouseMid == 4) {
				// \ÂĂ̂ŁAz[h
				m_dwMouseMid = 3;
			}
		}
	}
	else {
		// Ă
		if ((m_dwMouseMid == 3) || (m_dwMouseMid == 4)) {
			// \ꂽォǍ̗P񌟏oɌ
			m_dwMouseMid++;
			if (m_dwMouseMid == 5) {
				// 3t[ȏ㉟āǍA2t[ȏ㗣ꂽ
				m_pFrmWnd->PostMessage(WM_COMMAND, IDM_MOUSEMODE, 0);
				m_dwMouseMid++;
			}
		}
		else {
			// \ĂȂ܂ܗꂽBZbg
			m_dwMouseMid = 0;
		}
	}
}

//---------------------------------------------------------------------------
//
//	}EX[hݒ
//
//---------------------------------------------------------------------------
void FASTCALL CInput::SetMouseMode(BOOL bMode)
{
	ASSERT(this);
	ASSERT_VALID(this);

	// ݂̃[hƈĂ
	if (m_bMouseMode != bMode) {
		// [hm
		m_bMouseMode = bMode;

		// ƂɂUnacquire
		if (m_lpDIMouse) {
			m_lpDIMouse->Unacquire();
		}

		// {^JEg𖳌
		m_dwMouseMid = 5;
	}
}

//---------------------------------------------------------------------------
//
//	}EX擾
//
//---------------------------------------------------------------------------
void FASTCALL CInput::GetMouseInfo(int *pPos, BOOL *pBtn) const
{
	ASSERT(this);
	ASSERT(pPos);
	ASSERT(pBtn);
	ASSERT_VALID(this);

	// ꂼ3vf
	pPos[0] = m_nMouseX;
	pPos[1] = m_nMouseY;
	pPos[2] = (int)m_dwMouseMid;

	// {^
	pBtn[0] = m_bMouseB[0];
	pBtn[1] = m_bMouseB[1];
	pBtn[2] = m_bMouseMid;
}

//===========================================================================
//
//	WCXeBbN
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	WCXeBbN
//
//---------------------------------------------------------------------------
void FASTCALL CInput::EnumJoy()
{
	ASSERT(this);
	ASSERT(m_lpDI);

	// WCXeBbNNA
	m_dwJoyDevs = 0;

	// 񋓊Jn
	m_lpDI->EnumDevices(DIDEVTYPE_JOYSTICK, (LPDIENUMDEVICESCALLBACK)EnumCb,
							this, DIEDFL_ATTACHEDONLY);
}

//---------------------------------------------------------------------------
//
//	WCXeBbNR[obN
//
//---------------------------------------------------------------------------
BOOL CALLBACK CInput::EnumCb(LPDIDEVICEINSTANCE pDevInst, LPVOID pvRef)
{
	CInput *pInput;

	ASSERT(pDevInst);
	ASSERT(pvRef);

	// CInputɕϊ
	pInput = (CInput*)pvRef;

	// Ăяo
	return pInput->EnumDev(pDevInst);
}

//---------------------------------------------------------------------------
//
//	WCXeBbNǉ
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::EnumDev(LPDIDEVICEINSTANCE pDevInst)
{
	LPDIRECTINPUTDEVICE pInputDev;

	ASSERT(this);
	ASSERT(pDevInst);
	ASSERT(m_lpDI);

	// ő吔`FbNBőJoyDeviceMaxfoCX̂݃T|[g
	if (m_dwJoyDevs >= JoyDeviceMax) {
		ASSERT(m_dwJoyDevs == JoyDeviceMax);
		return DIENUM_STOP;
	}

	// CX^Xm
	memcpy(&m_JoyDevInst[m_dwJoyDevs], pDevInst, sizeof(DIDEVICEINSTANCE));

	// foCX쐬
	pInputDev = NULL;
	if (FAILED(m_lpDI->CreateDevice(pDevInst->guidInstance,
									&pInputDev,
									NULL))) {
		return DIENUM_CONTINUE;
	}
	ASSERT(pInputDev);

	// f[^tH[}bgw
	if (FAILED(pInputDev->SetDataFormat(&c_dfDIJoystick))) {
		// foCX
		pInputDev->Unacquire();
		pInputDev->Release();
		return DIENUM_CONTINUE;
	}

	// Caps擾
	memset(&m_JoyDevCaps[m_dwJoyDevs], 0, sizeof(DIDEVCAPS));
	m_JoyDevCaps[m_dwJoyDevs].dwSize = sizeof(DIDEVCAPS);
	if (FAILED(pInputDev->GetCapabilities(&m_JoyDevCaps[m_dwJoyDevs]))) {
		// foCX
		pInputDev->Unacquire();
		pInputDev->Release();
		return DIENUM_CONTINUE;
	}

	// foCXU
	pInputDev->Unacquire();
	pInputDev->Release();

	// ǉƌp
	m_dwJoyDevs++;
	return DIENUM_CONTINUE;
}

//---------------------------------------------------------------------------
//
//	WCXeBbN
//	ApplyCfgĂяoꍇAdwDeviceĂꍇ݂̂ɂ邱
//
//---------------------------------------------------------------------------
void FASTCALL CInput::InitJoy()
{
	int i;
	int nDevice;
	int nAxis;
	BOOL bError[JoyDevices];
	DIPROPDWORD dpd;
	DIPROPRANGE dpr;

	ASSERT(this);
	ASSERT(m_lpDI);

	// foCXU
	for (i=0; i<JoyDevices; i++) {
		if (m_lpDIDev2[i]) {
			m_lpDIDev2[i]->Release();
			m_lpDIDev2[i] = NULL;
		}

		if (m_lpDIJoy[i]) {
			m_lpDIJoy[i]->Unacquire();
			m_lpDIJoy[i]->Release();
			m_lpDIJoy[i] = NULL;
		}
	}

	// ̓f[^NA
	for (i=0; i<JoyDevices; i++) {
		memset(&m_JoyState[i], 0, sizeof(DIJOYSTATE));
	}

	// [v
	for (i=0; i<JoyDevices; i++) {
		// G[tOOFF
		bError[i] = FALSE;

		// gpȂAȂ
		if (m_JoyCfg[i].nDevice == 0) {
			continue;
		}

		// foCX쐬
		nDevice = m_JoyCfg[i].nDevice - 1;
		if (FAILED(m_lpDI->CreateDevice(m_JoyDevInst[nDevice].guidInstance,
										&m_lpDIJoy[i],
										NULL))) {
			continue;
		}

		// G[tOON
		bError[i] = TRUE;

		// f[^tH[}bgw
		if (FAILED(m_lpDIJoy[i]->SetDataFormat(&c_dfDIJoystick))) {
			continue;
		}

		// xݒ
		if (FAILED(m_lpDIJoy[i]->SetCooperativeLevel(m_pFrmWnd->m_hWnd,
							DISCL_BACKGROUND | DISCL_NONEXCLUSIVE))) {
			continue;
		}

		// l[hݒ(Βl)
		memset(&dpd, 0, sizeof(dpd));
		dpd.diph.dwSize = sizeof(DIPROPDWORD); 
		dpd.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		dpd.diph.dwHow = DIPH_DEVICE;
		dpd.dwData = DIPROPAXISMODE_ABS;
		if (FAILED(m_lpDIJoy[i]->SetProperty(DIPROP_AXISMODE, (LPDIPROPHEADER)&dpd))) {
			continue;
		}

		// fbh][w(fbh][Ȃ)
		memset(&dpd, 0, sizeof(dpd));
		dpd.diph.dwSize = sizeof(DIPROPDWORD);
		dpd.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		dpd.diph.dwHow = DIPH_DEVICE;
		dpd.dwData = 0;
		if (FAILED(m_lpDIJoy[i]->SetProperty(DIPROP_DEADZONE, (LPDIPROPHEADER)&dpd))) {
			continue;
		}

		// Ƃ̃W擾(ׂĂ̎ɂĎ擾݂)
		for (nAxis=0; nAxis<JoyAxes; nAxis++) {
			// 擾(G[ł悢)
			memset(&dpr, 0, sizeof(dpr));
			dpr.diph.dwSize = sizeof(DIPROPRANGE);
			dpr.diph.dwHeaderSize = sizeof(DIPROPHEADER);
			dpr.diph.dwHow = DIPH_BYOFFSET;
			dpr.diph.dwObj = JoyAxisOffsetTable[nAxis];
			m_lpDIJoy[i]->GetProperty(DIPROP_RANGE, (LPDIPROPHEADER)&dpr);

			// m
			m_lJoyAxisMin[i][nAxis] = dpr.lMin;
			m_lJoyAxisMax[i][nAxis] = dpr.lMax;
		}

		// IDirectInputDevice2擾
		if (FAILED(m_lpDIJoy[i]->QueryInterface(IID_IDirectInputDevice2,
										(LPVOID*)&m_lpDIDev2[i]))) {
			// IDirectInputDevice2擾łȂꍇ
			m_lpDIDev2[i] = NULL;
		}

		// G[tOOFF()
		bError[i] = FALSE;
	}

	// G[NfoCXɂāA
	for (i=0; i<JoyDevices; i++) {
		if (bError[i]) {
			ASSERT(m_lpDIJoy[i]);
			m_lpDIJoy[i]->Unacquire();
			m_lpDIJoy[i]->Release();
			m_lpDIJoy[i] = NULL;
		}
	}
}

//---------------------------------------------------------------------------
//
//	WCXeBbN
//
//---------------------------------------------------------------------------
void FASTCALL CInput::InputJoy(BOOL bEnable)
{
	int i;
	int nAxis;
	BYTE *pOffset;
	LONG *pAxis;
	LONG lRange;
	LONG lAxis;

	ASSERT(this);

	// bEnable=FALSEŁAm_bJoyEnable=TRUE(VM)̏ꍇA̓f[^NA
	if (!bEnable && m_bJoyEnable) {
		for (i=0; i<JoyDevices; i++) {
			// ̓f[^NA
			memset(&m_JoyState[i], 0, sizeof(DIJOYSTATE));
		}
		return;
	}

	// foCX[v
	for (i=0; i<JoyDevices; i++) {
		// foCXȂ΃XLbv
		if (!m_lpDIJoy[i]) {
			continue;
		}

		// |[O
		if (m_lpDIDev2[i]) {
			if (FAILED(m_lpDIDev2[i]->Poll())) {
				// Acquire݂
				m_lpDIJoy[i]->Acquire();
				m_dwJoyAcquire[i]++;
				continue;
			}
		}

		// f[^擾
		if (FAILED(m_lpDIJoy[i]->GetDeviceState(sizeof(DIJOYSTATE),
												&m_JoyState[i]))) {
			// Acquire݂
			m_lpDIJoy[i]->Acquire();
			m_dwJoyAcquire[i]++;
			continue;
		}

		// ϊ(-800 ` 7FFɕϊ)
		for (nAxis=0; nAxis<JoyAxes; nAxis++) {
			// |C^擾
			pOffset = (BYTE*)&m_JoyState[i];
			pOffset += JoyAxisOffsetTable[nAxis];
			pAxis = (LONG*)pOffset;

			// ȎȂXLbv
			if (m_lJoyAxisMin[i][nAxis] == m_lJoyAxisMax[i][nAxis]) {
				continue;
			}

			// -lMinグ([_0ɑ)
			lAxis = *pAxis - m_lJoyAxisMin[i][nAxis];

			// ͈͂oAI[o[t[h~ϊ
			lRange = m_lJoyAxisMax[i][nAxis] - m_lJoyAxisMin[i][nAxis] + 1;
			if (lRange >= 0x100000) {
				lRange >>= 12;
				lAxis >>= 12;
			}

			// ϊ
			lAxis <<= 12;
			lAxis /= lRange;
			lAxis -= 0x800;
			*pAxis = lAxis;
		}
	}
}

//---------------------------------------------------------------------------
//
//	WCXeBbN
//
//---------------------------------------------------------------------------
void FASTCALL CInput::MakeJoy(BOOL bEnable)
{
	int i;
	int nAxis;
	int nButton;
	BYTE *pOffset;
	LONG *pAxis;
	LONG lAxis;
	PPI::joyinfo_t ji[PPI::PortMax];

	int dmy;

	ASSERT(this);
	ASSERT(m_pPPI);

	// SăNA
	memset(ji, 0, sizeof(ji));

	// fBZ[uȂ
	if (!bEnable) {
		for (i=0; i<PPI::PortMax; i++) {
			// ͂Ȃf[^𑗐M
			m_pPPI->SetJoyInfo(i, &ji[i]);

			// {^A˂NA
			for (nButton=0; nButton<JoyButtons; nButton++) {
				m_JoyCfg[i].dwCount[nButton] = 0;
			}
		}
		return;
	}

	// ̓f[^
	for (i=0; i<JoyDevices; i++) {
		dmy = -1;

		// 
		for (nAxis=0; nAxis<JoyAxes; nAxis++) {
#if 0
			// 
			if (LOWORD(m_JoyCfg[i].dwAxis[nAxis]) == 0) {
				continue;
			}
#else
			// ȎȂXLbv
			if (m_lJoyAxisMin[i][nAxis] == m_lJoyAxisMax[i][nAxis]) {
				continue;
			}
			dmy++;
			if (dmy >= 4) {
				break;
			}
#endif

			// |C^擾
			pOffset = (BYTE*)&m_JoyState[i];
			pOffset += JoyAxisOffsetTable[nAxis];
			pAxis = (LONG*)pOffset;

			// f[^擾
			lAxis = *pAxis;

			// [͖(ŏɃNAĂ邽)
			if (lAxis == 0) {
				continue;
			}

			// ]
			if (m_JoyCfg[i].bAxis[nAxis]) {
				// 7FF-800 -8007FF
				lAxis = -1 - lAxis;
			}

#if 0
			// ړIʒuɊi[
			ASSERT(HIWORD(m_JoyCfg[i].dwAxis[nAxis]) >= 0);
			ASSERT(HIWORD(m_JoyCfg[i].dwAxis[nAxis]) < 2);
			ASSERT(LOWORD(m_JoyCfg[i].dwAxis[nAxis]) > 0);
			ASSERT(LOWORD(m_JoyCfg[i].dwAxis[nAxis]) <= 4);
			ji[HIWORD(m_JoyCfg[i].dwAxis[nAxis])].axis[LOWORD(m_JoyCfg[i].dwAxis[nAxis]) - 1]
				 = (DWORD)lAxis;
#else
			ji[HIWORD(m_JoyCfg[i].dwAxis[nAxis])].axis[dmy] = (DWORD)lAxis;
#endif
		}

		// {^
		for (nButton=0; nButton<JoyButtons; nButton++) {
			// 
			if (LOWORD(m_JoyCfg[i].dwButton[nButton]) == 0) {
				continue;
			}

			// It
			if ((m_JoyState[i].rgbButtons[nButton] & 0x80) == 0) {
				// A˃JE^NÂ({^́AŏŃNAĂ)
				m_JoyCfg[i].dwCount[nButton] = 0;
				continue;
			}

			ASSERT(HIWORD(m_JoyCfg[i].dwButton[nButton]) >= 0);
			ASSERT(HIWORD(m_JoyCfg[i].dwButton[nButton]) < PPI::PortMax);
			ASSERT(LOWORD(m_JoyCfg[i].dwButton[nButton]) > 0);
			ASSERT(LOWORD(m_JoyCfg[i].dwButton[nButton]) <= PPI::ButtonMax);

			// A0
			if (m_JoyCfg[i].dwRapid[nButton] == 0) {
				// ړIʒuɊi[
				ji[HIWORD(m_JoyCfg[i].dwButton[nButton])].button[LOWORD(m_JoyCfg[i].dwButton[nButton]) - 1]
					= TRUE;
				continue;
			}

			// A˂
			if (m_JoyCfg[i].dwCount[nButton] == 0) {
				// Ȃ̂ŁAONƃJE^[h
				ji[HIWORD(m_JoyCfg[i].dwButton[nButton])].button[LOWORD(m_JoyCfg[i].dwButton[nButton]) - 1]
					= TRUE;
				m_JoyCfg[i].dwCount[nButton] = JoyRapidTable[m_JoyCfg[i].dwRapid[nButton]];
				continue;
			}

			// A˃JEg_EB0ȂONƃJE^[h
			m_JoyCfg[i].dwCount[nButton]--;
			if (m_JoyCfg[i].dwCount[nButton] == 0) {
				ji[HIWORD(m_JoyCfg[i].dwButton[nButton])].button[LOWORD(m_JoyCfg[i].dwButton[nButton]) - 1]
					= TRUE;
				m_JoyCfg[i].dwCount[nButton] = JoyRapidTable[m_JoyCfg[i].dwRapid[nButton]];
				continue;
			}

			// JE^̑OE㔼ŁAON/OFFɕ
			if (m_JoyCfg[i].dwCount[nButton] > (JoyRapidTable[m_JoyCfg[i].dwRapid[nButton]] >> 1)) {
				ji[HIWORD(m_JoyCfg[i].dwButton[nButton])].button[LOWORD(m_JoyCfg[i].dwButton[nButton]) - 1]
					= TRUE;
			}
			else {
				ji[HIWORD(m_JoyCfg[i].dwButton[nButton])].button[LOWORD(m_JoyCfg[i].dwButton[nButton]) - 1]
					= FALSE;
			}
		}
	}

	// L[{[hƂ̍


	// PPI֑M
	for (i=0; i<PPI::PortMax; i++) {
		m_pPPI->SetJoyInfo(i, &ji[i]);
	}
}

//---------------------------------------------------------------------------
//
//	WCXeBbNLE
//
//---------------------------------------------------------------------------
void FASTCALL CInput::EnableJoy(BOOL bEnable)
{
	PPI::joyinfo_t ji;

	ASSERT(this);

	// ȂKvȂ
	if (m_bJoyEnable == bEnable) {
		return;
	}

	// ύX
	m_bJoyEnable = bEnable;

	// FALSEɕύXꍇAPPIɑ΂ăk񑗐M
	if (!bEnable) {
		memset(&ji, 0, sizeof(ji));
		m_pPPI->SetJoyInfo(0, &ji);
		m_pPPI->SetJoyInfo(1, &ji);
	}
}

//---------------------------------------------------------------------------
//
//	WCXeBbNfoCX擾
//
//---------------------------------------------------------------------------
int FASTCALL CInput::GetJoyDevice(int nJoy) const
{
	ASSERT(this);
	ASSERT((nJoy >= 0) && (nJoy < JoyDevices));

	// 0͊蓖ĂȂ
	if (m_JoyCfg[nJoy].nDevice == 0) {
		return 0;
	}

	// foCX|C^ĂȂ΁AG[Ƃ-1
	if (!m_lpDIJoy[nJoy]) {
		return -1;
	}

	// Ă̂ŁAfoCXԍ
	return m_JoyCfg[nJoy].nDevice;
}

//---------------------------------------------------------------------------
//
//	WCXeBbN擾
//
//---------------------------------------------------------------------------
LONG FASTCALL CInput::GetJoyAxis(int nJoy, int nAxis) const
{
	BYTE *pOffset;
	LONG *pAxis;

	ASSERT(this);
	ASSERT((nJoy >= 0) && (nJoy < JoyDevices));
	ASSERT((nAxis >= 0) && (nAxis < JoyAxes));

	// 0͊蓖ĂȂ
	if (m_JoyCfg[nJoy].nDevice == 0) {
		return 0x10000;
	}

	// foCX|C^ĂȂ΁AG[
	if (!m_lpDIJoy[nJoy]) {
		return 0x10000;
	}

	// ݂Ȃ΁AwG[
	if (m_lJoyAxisMin[nJoy][nAxis] == m_lJoyAxisMax[nJoy][nAxis]) {
		return 0x10000;
	}

	// lԂ
	pOffset = (BYTE*)&m_JoyState[nJoy];
	pOffset += JoyAxisOffsetTable[nAxis];
	pAxis = (LONG*)pOffset;
	return *pAxis;
}

//---------------------------------------------------------------------------
//
//	WCXeBbN{^擾
//
//---------------------------------------------------------------------------
DWORD FASTCALL CInput::GetJoyButton(int nJoy, int nButton) const
{
	ASSERT(this);
	ASSERT((nJoy >= 0) && (nJoy < JoyDevices));
	ASSERT((nButton >= 0) && (nButton < JoyButtons));

	// 0͊蓖ĂȂ
	if (m_JoyCfg[nJoy].nDevice == 0) {
		return 0x10000;
	}

	// foCX|C^ĂȂ΁AG[
	if (!m_lpDIJoy[nJoy]) {
		return 0x10000;
	}

	// {^Ȃ΁AwG[
	if (nButton >= (int)m_JoyDevCaps[m_JoyCfg[nJoy].nDevice - 1].dwButtons) {
		return 0x10000;
	}

	// lԂ
	return (DWORD)m_JoyState[nJoy].rgbButtons[nButton];
}

//---------------------------------------------------------------------------
//
//	WCXeBbNCaps擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CInput::GetJoyCaps(int nDevice, CString& strDesc, DIDEVCAPS *pCaps) const
{
	ASSERT(this);
	ASSERT(nDevice >= 0);
	ASSERT(pCaps);

	// WCXeBbNfoCXƔr
	if (nDevice >= (int)m_dwJoyDevs) {
		// wCfbNX̃foCX݂͑Ȃ
		return FALSE;
	}

	// Descݒ
	ASSERT(nDevice < JoyDeviceMax);
	strDesc = m_JoyDevInst[nDevice].tszInstanceName;

	// CapsRs[
	*pCaps = m_JoyDevCaps[nDevice];

	// 
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	WCXeBbNݒ擾
//
//---------------------------------------------------------------------------
void FASTCALL CInput::GetJoyCfg(int nJoy, LPJOYCFG lpJoyCfg) const
{
	ASSERT(this);
	ASSERT((nJoy >= 0) && (nJoy < JoyDevices));

	// ݒRs[
	*lpJoyCfg = m_JoyCfg[nJoy];
}

//---------------------------------------------------------------------------
//
//	WCXeBbNݒZbg
//
//---------------------------------------------------------------------------
void FASTCALL CInput::SetJoyCfg(int nJoy, const LPJOYCFG lpJoyCfg)
{
	ASSERT(this);
	ASSERT((nJoy >= 0) && (nJoy < JoyDevices));

	// ݒRs[
	m_JoyCfg[nJoy] = *lpJoyCfg;
}

//---------------------------------------------------------------------------
//
//	WCXeBbNe[u
//
//---------------------------------------------------------------------------
const DWORD CInput::JoyAxisOffsetTable[JoyAxes] = {
	DIJOFS_X,
	DIJOFS_Y,
	DIJOFS_Z,
	DIJOFS_RX,
	DIJOFS_RY,
	DIJOFS_RZ,
	DIJOFS_SLIDER(0),
	DIJOFS_SLIDER(1)
};

//---------------------------------------------------------------------------
//
//	WCXeBbNA˃e[u
//	Aˑx60t[/secƉ肵ꍇ̒l
//
//---------------------------------------------------------------------------
const DWORD CInput::JoyRapidTable[JoyRapids + 1] = {
	0,									// (gpGA)
	30,									// 2
	20,									// 3
	15,									// 4
	12,									// 5
	8,									// 7.5
	6,									// 10
	5,									// 12
	4,									// 15
	3,									// 20
	2									// 30
};

#endif	// _WIN32
