//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Cvbg ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_inp_h)
#define mfc_inp_h

//===========================================================================
//
//	Cvbg
//
//===========================================================================
class CInput : public CComponent
{
public:
	// WCXeBbN萔
	enum {
		JoyDeviceMax = 16,				// T|[gfoCXő吔
		JoyDevices = 2,					// gpfoCXő吔
		JoyAxes = 8,					// ő吔
		JoyButtons = 12,				// {^ő吔
		JoyRapids = 10,					// A˃x
	};
	// WCXeBbNݒ
	typedef struct _JOYCFG {
		int nDevice;					// foCXԍ(1`)Agp=0
		DWORD dwAxis[JoyAxes];			// ϊ (1`)Agp=0
		BOOL bAxis[JoyAxes];			// ]
		DWORD dwButton[JoyButtons];		// {^ϊ (1`)Agp=0
		DWORD dwRapid[JoyButtons];		// AˊԊu A˂Ȃ=0
		DWORD dwCount[JoyButtons];		// A˃JE^
	} JOYCFG, *LPJOYCFG;

public:
	// {t@NV
	CInput(CFrmWnd *pWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp
#if defined(_DEBUG)
	void AssertValid() const;
										// ff
#endif	// _DEBUG

	// Z[uE[h
	BOOL FASTCALL Save(Fileio *pFio, int nVer);
										// Z[u
	BOOL FASTCALL Load(Fileio *pFio, int nVer);
										// [h

	// OAPI
	void FASTCALL Process(BOOL bRun);
										// is
	void FASTCALL Activate(BOOL bActivate);
										// ANeBuʒm
	BOOL FASTCALL IsActive() const		{ return m_bActive; }
										// ANeBu󋵎擾
	void FASTCALL Menu(BOOL bMenu);
										// j[ʒm
	BOOL FASTCALL IsMenu() const		{ return m_bMenu; }
										// j[󋵎擾
	DWORD FASTCALL GetProcessCount() const	{ return m_dwProcessCount; }
										// isJE^擾
	DWORD FASTCALL GetAcquireCount(int nType) const;
										// lJE^擾

	// L[{[h
	void FASTCALL GetKeyBuf(BOOL *pKeyBuf) const;
										// L[͏擾
	void FASTCALL EnableKey(BOOL bEnable);
										// L[LE
	void FASTCALL SetDefaultKeyMap(DWORD *pKeyMap);
										// ftHg}bvݒ
	int FASTCALL Key2DirectX(int nKey);
										// L[ϊ
	int FASTCALL Key2X68k(int nDXKey);
										// L[ϊ
	static LPCTSTR FASTCALL GetKeyName(int nKey);
										// L[̎擾
	static LPCTSTR FASTCALL GetKeyID(int nID);
										// L[ID擾
	void FASTCALL GetKeyMap(DWORD *pKeyMap);
										// L[}bv擾
	void FASTCALL SetKeyMap(const DWORD *pKeyMap);
										// L[}bvݒ
	BOOL FASTCALL IsKeyMapped(int nID) const;
										// L[}bvL`FbN

	// }EX
	void FASTCALL SetMouseMode(BOOL bMode);
										// }EX[hݒ
	BOOL FASTCALL GetMouseMode() const	{ return m_bMouseMode; }
										// }EX[h擾
	void FASTCALL GetMouseInfo(int *pPos, BOOL *pBtn) const;
										// }EX擾

	// WCXeBbN
	static BOOL CALLBACK EnumCb(LPDIDEVICEINSTANCE pDevInst, LPVOID pvRef);
										// WCXeBbNR[obN
	void FASTCALL EnableJoy(BOOL bEnable);
										// WCXeBbNLE
	int FASTCALL GetJoyDevice(int nJoy) const;
										// WCXeBbNfoCX擾
	LONG FASTCALL GetJoyAxis(int nJoy, int nAxis) const;
										// WCXeBbN擾
	DWORD FASTCALL GetJoyButton(int nJoy, int nButton) const;
										// WCXeBbN{^擾
	BOOL FASTCALL GetJoyCaps(int nDevice, CString& strDesc, DIDEVCAPS *pCaps) const;
										// WCXeBbNCaps擾
	void FASTCALL GetJoyCfg(int nJoy, LPJOYCFG lpJoyCfg) const;
										// WCXeBbNݒ擾
	void FASTCALL SetJoyCfg(int nJoy, const LPJOYCFG lpJoyCfg);
										// WCXeBbNݒZbg

private:
	// 
	LPDIRECTINPUT m_lpDI;
										// DirectInput
	BOOL m_bActive;
										// ANeButO
	BOOL m_bMenu;
										// j[tO
	CRTC *m_pCRTC;
										// CRTC
	DWORD m_dwDispCount;
										// CRTC\JEg
	DWORD m_dwProcessCount;
										// isJEg

	// Z[uE[h
	BOOL FASTCALL SaveMain(Fileio *pFio);
										// Z[u{
	BOOL FASTCALL Load200(Fileio *pFio);
										// [h{ (version2.00)
	BOOL FASTCALL Load201(Fileio *pFio);
										// [h{ (version2.01)

	// L[{[h
	BOOL FASTCALL InitKey();
										// L[{[h
	void FASTCALL InputKey(BOOL bEnable);
										// L[{[h
	Keyboard *m_pKeyboard;
										// L[{[h
	LPDIRECTINPUTDEVICE m_lpDIKey;
										// L[{[hfoCX
	DWORD m_dwKeyAcquire;
										// L[{[hlJE^
	BOOL m_bKeyEnable;
										// L[{[hLtO
	BOOL m_KeyBuf[0x100];
										// L[{[hobt@
	DWORD m_KeyMap[0x100];
										// L[ϊ}bv
	static const DWORD m_KeyMap106[];
										// ftHg}bv(106)
	static LPCTSTR KeyNameTable[];
										// L[̃e[u
	static LPCSTR KeyIDTable[];
										// DirectXL[IDe[u

	// }EX
	BOOL FASTCALL InitMouse();
										// }EX
	void FASTCALL InputMouse(BOOL bEnable);
										// }EX
	Mouse *m_pMouse;
										// }EX
	LPDIRECTINPUTDEVICE m_lpDIMouse;
										// }EXfoCX
	DWORD m_dwMouseAcquire;
										// }EXlJE^
	BOOL m_bMouseMode;
										// }EX[htO
	int m_nMouseX;
										// }EXxW
	int m_nMouseY;
										// }EXyW
	BOOL m_bMouseB[2];
										// }EXE{^
	DWORD m_dwMouseMid;
										// }EX{^JEg
	BOOL m_bMouseMid;
										// }EX{^gptO

	// WCXeBbN
	void FASTCALL EnumJoy();
										// WCXeBbN
	BOOL FASTCALL EnumDev(LPDIDEVICEINSTANCE pDevInst);
										// WCXeBbNǉ
	void FASTCALL InitJoy();
										// WCXeBbN
	void FASTCALL InputJoy(BOOL bEnable);
										// WCXeBbN
	void FASTCALL MakeJoy(BOOL bEnable);
										// WCXeBbN
	PPI *m_pPPI;
										// PPI
	BOOL m_bJoyEnable;
										// WCXeBbNLE
	LPDIRECTINPUTDEVICE m_lpDIJoy[JoyDevices];
										// WCXeBbNfoCX
	LPDIRECTINPUTDEVICE2 m_lpDIDev2[JoyDevices];
										// tH[XtB[hobNfoCX
	JOYCFG m_JoyCfg[JoyDevices];
										// WCXeBbNRtBO
	LONG m_lJoyAxisMin[JoyDevices][JoyAxes];
										// WCXeBbNŏl
	LONG m_lJoyAxisMax[JoyDevices][JoyAxes];
										// WCXeBbNől
	DWORD m_dwJoyAcquire[JoyDevices];
										// WCXeBbNlJE^
	DIJOYSTATE m_JoyState[JoyDevices];
										// WCXeBbN
	DWORD m_dwJoyDevs;
										// WCXeBbNfoCX
	DIDEVCAPS m_JoyDevCaps[JoyDeviceMax];
										// WCXeBbNCaps
	DIDEVICEINSTANCE m_JoyDevInst[JoyDeviceMax];
										// WCXeBbNCX^X
	static const DWORD JoyAxisOffsetTable[JoyAxes];
										// WCXeBbNItZbge[u
	static const DWORD JoyRapidTable[JoyRapids + 1];
										// WCXeBbNA˃e[u
};

#endif	// mfc_inp_h
#endif	// _WIN32
