//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC MIDI ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_midi_h)
#define mfc_midi_h

#include "mfc_com.h"
#include "mfc_que.h"

//===========================================================================
//
//	MIDI
//
//===========================================================================
class CMIDI : public CComponent
{
public:
	// 񑗐M^`
	typedef struct _MIDIINFO {
		DWORD dwDevices;				// foCX
		DWORD dwDevice;					// foCXԍ
		DWORD dwHandle;					// nh(HMIDI*)
		CWinThread *pThread;			// Xbh
		DWORD dwShort;					// V[gbZ[WJE^
		DWORD dwLong;					// GNXN[VuJE^
		DWORD dwUnprepare;				// wb_JE^
		DWORD dwBufNum;					// obt@L
		DWORD dwBufRead;				// obt@ǂݎʒu
		DWORD dwBufWrite;				// obt@݈ʒu
	} MIDIINFO, *LPMIDIINFO;

public:
	// {t@NV
	CMIDI(CFrmWnd *pWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp
#if !defined(NDEBUG)
	void AssertValid() const;
										// ff
#endif	// NDEBUG

	// R[obN
	HMIDIOUT GetOutHandle() const		{ return m_hOut; }
										// OutfoCXnh擾
	HMIDIIN GetInHandle() const			{ return m_hIn; }
										// InfoCXnh擾

	// foCX
	DWORD FASTCALL GetOutDevs() const;
										// OutfoCX擾
	BOOL FASTCALL GetOutDevDesc(int nDevice, CString& strDesc) const;
										// OutfoCX̎擾
	DWORD FASTCALL GetInDevs() const;
										// INfoCX擾
	BOOL FASTCALL GetInDevDesc(int nDevice, CString& strDesc) const;
										// INfoCX̎擾

	// fBC
	void FASTCALL SetOutDelay(int nDelay);
										// OutfBCݒ
	void FASTCALL SetInDelay(int nDelay);
										// InfBCݒ

	// ~LT
	int FASTCALL GetOutVolume();
										// Outʎ擾
	void FASTCALL SetOutVolume(int nVolume);
										// Outʐݒ

	// 擾
	void FASTCALL GetOutInfo(LPMIDIINFO pInfo) const;
										// Out擾
	void FASTCALL GetInInfo(LPMIDIINFO pInfo) const;
										// In擾

private:
	MIDI *m_pMIDI;
										// MIDI
	Scheduler *m_pScheduler;
										// XPW[
	CScheduler *m_pSch;
										// XPW[

	// Out
	enum OutState {
		OutReady,						// f[^҂ԂȂ
		OutEx,							// GNXN[VubZ[Wo͒
		OutShort,						// V[gbZ[Wo͒
	};
	void FASTCALL OpenOut(DWORD dwDevice);
										// OutI[v
	void FASTCALL CloseOut();
										// OutN[Y
	void FASTCALL RunOut();
										// OutXbh
	void FASTCALL CallbackOut(UINT wMsg, DWORD dwParam1, DWORD dwParam2);
										// OutR[obN
	void FASTCALL GetOutCaps();
										// OutfoCXCaps擾
	BOOL FASTCALL SendEx(const BYTE *pExData);
										// GNXN[VuM
	BOOL FASTCALL SendExWait();
										// GNXN[Vu҂
	void FASTCALL SendAllNoteOff();
										// Sm[gIt
	BOOL FASTCALL SendReset();
										// ZbgM
	static UINT OutThread(LPVOID pParam);
										// OutXbh
#if _MFC_VER >= 0x700
	static void CALLBACK OutProc(HMIDIOUT hOut, UINT wMsg, DWORD_PTR dwInstance,
		DWORD dwParam1, DWORD dwParam2);// OutR[obN
#else
	static void CALLBACK OutProc(HMIDIOUT hOut, UINT wMsg, DWORD dwInstance,
		DWORD dwParam1, DWORD dwParam2);// OutR[obN
#endif
	DWORD m_dwOutDevice;
										// OutfoCXiD
	HMIDIOUT m_hOut;
										// OutfoCXnh
	CWinThread *m_pOutThread;
										// OutXbh
	BOOL m_bOutThread;
										// OutXbhItO
	DWORD m_dwOutDevs;
										// OutfoCX
	LPMIDIOUTCAPS m_pOutCaps;
										// OutfoCXCaps
	DWORD m_dwOutDelay;
										// OutfBC(ms)
	BOOL m_bSendEx;
										// GNXN[VuMtO
	BOOL m_bSendExHdr;
										// GNXN[Vuwb_gptO
	BYTE m_ExBuf[0x2000];
										// GNXN[Vuobt@
	MIDIHDR m_ExHdr;
										// GNXN[Vuwb_
	int m_nOutReset;
										// ZbgR}h
	DWORD m_dwShortSend;
										// V[gR}hMJE^
	DWORD m_dwExSend;
										// GNXN[VuMsJE^
	DWORD m_dwUnSend;
										// wb_JE^
	CCriticalSection m_OutSection;
										// NeBJZNV
	static const BYTE ResetGM[];
										// GMZbgR}h
	static const BYTE ResetGS[];
										// GSZbgR}h
	static const BYTE ResetXG[];
										// XGZbgR}h
	static const BYTE ResetLA[];
										// LAZbgR}h

	// In
	enum InState {
		InNotUsed,						// gp
		InReady,						// f[^҂
		InDone							// f[^
	};
	enum {
		InBufMax = 0x800				// obt@TCY
	};
	void FASTCALL OpenIn(DWORD dwDevice);
										// InI[v
	void FASTCALL CloseIn();
										// InN[Y
	void FASTCALL RunIn();
										// InXbh
	void FASTCALL CallbackIn(UINT wMsg, DWORD dwParam1, DWORD dwParam2);
										// InR[obN
	void FASTCALL GetInCaps();
										// InfoCXCaps擾
	BOOL FASTCALL StartIn();
										// InJn
	void FASTCALL StopIn();
										// In~
	void FASTCALL ShortIn();
										// InV[gbZ[W
	void FASTCALL LongIn(int nHdr);
										// InObZ[W
	static UINT InThread(LPVOID pParam);
										// InXbh
#if _MFC_VER >= 0x700
	static void CALLBACK InProc(HMIDIIN hIn, UINT wMsg, DWORD_PTR dwInstance,
		DWORD dwParam1, DWORD dwParam2);// InR[obN
#else
	static void CALLBACK InProc(HMIDIIN hIn, UINT wMsg, DWORD dwInstance,
		DWORD dwParam1, DWORD dwParam2);// InR[obN
#endif
	DWORD m_dwInDevice;
										// InfoCXiD
	HMIDIIN m_hIn;
										// InfoCXnh
	CWinThread *m_pInThread;
										// InTXbh
	BOOL m_bInThread;
										// InXbhItO
	DWORD m_dwInDevs;
										// InfoCX
	LPMIDIINCAPS m_pInCaps;
										// InfoCXCaps
	MIDIHDR m_InHdr[2];
										// GNXN[Vuwb_
	BYTE m_InBuf[2][InBufMax];
										// GNXN[Vuobt@
	InState m_InState[2];
										// GNXN[Vuobt@
	CQueue m_InQueue;
										// V[gbZ[W̓L[
	DWORD m_dwShortRecv;
										// V[gR}hMJE^
	DWORD m_dwExRecv;
										// GNXN[VuMJE^
	DWORD m_dwUnRecv;
										// wb_JE^
	CCriticalSection m_InSection;
										// NeBJZNV
};

#endif	// mfc_midi_h
#endif	// _WIN32
