//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2005 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC |[g ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "scc.h"
#include "printer.h"
#include "config.h"
#include "filepath.h"
#include "fileio.h"
#include "mfc_com.h"
#include "mfc_cfg.h"
#include "mfc_que.h"
#include "mfc_port.h"

//===========================================================================
//
//	|[g
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	COMXbh֐
//
//---------------------------------------------------------------------------
static UINT COMThread(LPVOID pParam)
{
	CPort *pPort;

	// p[^󂯎
	pPort = (CPort*)pParam;
	ASSERT(pPort);

	// s
	pPort->RunCOM();

	// IR[hăXbhI
	return 0;
}

//---------------------------------------------------------------------------
//
//	LPTXbh֐
//
//---------------------------------------------------------------------------
static UINT LPTThread(LPVOID pParam)
{
	CPort *pPort;

	// p[^󂯎
	pPort = (CPort*)pParam;
	ASSERT(pPort);

	// s
	pPort->RunLPT();

	// IR[hăXbhI
	return 0;
}

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CPort::CPort(CFrmWnd *pWnd) : CComponent(pWnd)
{
	// R|[lgp[^
	m_dwID = MAKEID('P', 'O', 'R', 'T');
	m_strDesc = _T("Port Handler");

	// VA|[g
	m_nCOM = 0;
	m_hCOM = INVALID_HANDLE_VALUE;
	m_pCOM = NULL;
	m_bCOMReq = FALSE;
	m_bBreak = FALSE;
	m_bRTS = FALSE;
	m_bDTR = FALSE;
	m_bCTS = FALSE;
	m_bDSR = FALSE;
	m_bTxValid = FALSE;
	memset(&m_TxOver, 0, sizeof(m_TxOver));
	m_dwErr = 0;
	memset(&m_RxOver, 0, sizeof(m_RxOver));
	m_RecvLog[0] = _T('\0');
	m_bForce = FALSE;
	m_pSCC = NULL;

	// p|[g
	m_nLPT = 0;
	m_hLPT = INVALID_HANDLE_VALUE;
	m_pLPT = NULL;
	m_bLPTValid = FALSE;
	m_bLPTReq = FALSE;
	memset(&m_LPTOver, 0, sizeof(m_LPTOver));
	m_SendLog[0] = _T('\0');
	m_pPrinter = NULL;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CPort::Init()
{
	ASSERT(this);

	// {NX
	if (!CComponent::Init()) {
		return FALSE;
	}

	// SCC擾
	ASSERT(!m_pSCC);
	m_pSCC = (SCC*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'C', ' '));
	ASSERT(m_pSCC);

	// VAL[
	if (!m_TxQueue.Init(0x1000)) {
		return FALSE;
	}
	if (!m_RxQueue.Init(0x1000)) {
		return FALSE;
	}

	// VA|[g
	OpenCOM();

	// v^擾
	ASSERT(!m_pPrinter);
	m_pPrinter = (Printer*)::GetVM()->SearchDevice(MAKEID('P', 'R', 'N', ' '));
	ASSERT(m_pPrinter);

	// pL[
	if (!m_LPTQueue.Init(0x1000)) {
		return FALSE;
	}

	// p|[g
	OpenLPT();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CPort::Cleanup()
{
	ASSERT(this);

	// p|[g
	CloseLPT();

	// VA|[g
	CloseCOM();

	// {NX
	CComponent::Cleanup();
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CPort::ApplyCfg(const Config* pConfig)
{
	BOOL bCOM;
	BOOL bLPT;

	ASSERT(this);
	ASSERT(pConfig);

	// COMtO
	bCOM = FALSE;

	// COM|[gԍĂ邩
	if (pConfig->port_com != (int)m_nCOM) {
		m_nCOM = pConfig->port_com;
		bCOM = TRUE;

		// TrueKeyƃ|[gԍdȂĂATrueKeyD
		if (pConfig->port_com == pConfig->tkey_com) {
			m_nCOM = 0;
		}
	}

	// Mt@CĂ邩
	if (_tcscmp(pConfig->port_recvlog, m_RecvLog) != 0) {
		ASSERT(_tcslen(pConfig->port_recvlog) < _MAX_PATH);
		_tcscpy(m_RecvLog, pConfig->port_recvlog);
		bCOM = TRUE;
	}

	// tOĂ邩
	if (pConfig->port_384 != m_bForce) {
		m_bForce = pConfig->port_384;
		bCOM = TRUE;
	}

	// ύX_
	if (bCOM) {
		// N[Y邽߁AxbNĂVM𗣂
		::UnlockVM();
		CloseCOM();
		OpenCOM();
		::LockVM();
	}

	// LPTtO
	bLPT = FALSE;

	// LPT|[gԍĂ邩
	if (pConfig->port_lpt != (int)m_nLPT) {
		m_nLPT = pConfig->port_lpt;
		bLPT = TRUE;
	}

	// Mt@CĂ邩
	if (strcmp(pConfig->port_sendlog, m_SendLog) != 0) {
		ASSERT(strlen(pConfig->port_sendlog) < sizeof(m_SendLog));
		strcpy(m_SendLog, pConfig->port_sendlog);
		bLPT = TRUE;
	}

	// ύX_
	if (bLPT) {
		// N[Y邽߁AxbNĂVM𗣂
		::UnlockVM();
		CloseLPT();
		OpenLPT();
		::LockVM();
	}
}

//===========================================================================
//
//	VA|[g
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	COMI[v
//	VMbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CPort::OpenCOM()
{
	CString strFile;
	DCB dcb;

	ASSERT(this);

	// |[g0ȂA蓖ĂȂ
	if (m_nCOM == 0) {
		m_hCOM = INVALID_HANDLE_VALUE;
		return TRUE;
	}

	// t@C쐬
	strFile.Format(_T("\\\\.\\COM%d"), m_nCOM);

	// I[v
	m_hCOM = ::CreateFile(  strFile,
							GENERIC_READ | GENERIC_WRITE,
							0,
							NULL,
							OPEN_EXISTING,
							FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
							0);
	if (m_hCOM == INVALID_HANDLE_VALUE) {
		return FALSE;
	}

	// obt@TCY
	::SetupComm(m_hCOM, 0x1000, 0x1000);

	// MNA
	m_TxQueue.Clear();
	m_RxQueue.Clear();
	::PurgeComm(m_hCOM, PURGE_TXCLEAR);
	::PurgeComm(m_hCOM, PURGE_RXCLEAR);

	// M̏ݒ
	OnErr();
	OnCTSDSR();
	::GetCommState(m_hCOM, &dcb);
	::LockVM();
	AdjustCOM(&dcb);
	SignalCOM();
	::UnlockVM();
	CtrlCOM();

	// Ot@C̍쐬(Ayh)
	AppendCOM();

	// Xbh𗧂Ă
	m_bCOMReq = FALSE;
	m_pCOM = AfxBeginThread(COMThread, this);
	if (!m_pCOM) {
		CloseCOM();
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	COMOt@C
//
//---------------------------------------------------------------------------
void FASTCALL CPort::AppendCOM()
{
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];
	TCHAR szFile[_MAX_FNAME];
	TCHAR szExt[_MAX_EXT];
	Filepath path;

	ASSERT(this);

	// Ot@Cw肪ł΁AKvȂ
	if (_tcslen(m_RecvLog) == 0) {
		return;
	}

	// 
	_tsplitpath(m_RecvLog, szDrive, szDir, szFile, szExt);

	// tpXwłȂΑ΃pX̗p
	path.SetPath(m_RecvLog);
	if ((_tcslen(szDrive) == 0) && (szDir[0] != _T('\\'))) {
		path.SetBaseDir();
	}

	// AyhI[v
	m_RecvFile.Open(path, Fileio::Append);
}

//---------------------------------------------------------------------------
//
//	COMN[Y
//	VMbN
//
//---------------------------------------------------------------------------
void FASTCALL CPort::CloseCOM()
{
	DWORD dwCompleted;

	ASSERT(this);

	// Xbh
	if (m_pCOM) {
		// Ivグ
		m_bCOMReq = TRUE;

		// I҂()
		::WaitForSingleObject(m_pCOM->m_hThread, INFINITE);

		m_pCOM = NULL;
	}

	// nh
	if (m_hCOM != INVALID_HANDLE_VALUE) {
		// obt@p[W
		m_TxQueue.Clear();
		m_RxQueue.Clear();
		::PurgeComm(m_hCOM, PURGE_TXCLEAR);
		::PurgeComm(m_hCOM, PURGE_RXCLEAR);

		// M
		if (m_bTxValid) {
			// MI/OĂ邩
			if (!GetOverlappedResult(m_hCOM, &m_TxOver, &dwCompleted, FALSE)) {
				// ܂ۗȂ̂ŁALZ
				CancelIo(m_hCOM);
			}
			m_bTxValid = FALSE;
		}

		// MI/OĂ邩
		if (!GetOverlappedResult(m_hCOM, &m_RxOver, &dwCompleted, FALSE)) {
			// ܂ۗȂ̂ŁALZ
			CancelIo(m_hCOM);
		}

		// N[Y
		::CloseHandle(m_hCOM);
		m_hCOM = INVALID_HANDLE_VALUE;
	}

	// Ot@CN[Y
	m_RecvFile.Close();

	// SCCɑ΂AMEFCgȂ
	m_pSCC->WaitTx(0, FALSE);
	m_pSCC->SetCTS(0, FALSE);
	m_pSCC->SetDCD(0, FALSE);
}

//---------------------------------------------------------------------------
//
//	COMs
//
//---------------------------------------------------------------------------
void FASTCALL CPort::RunCOM()
{
	COMMTIMEOUTS cto;
	DCB dcb;

	ASSERT(this);
	ASSERT(m_hCOM);

	// Cxg}XN
	::SetCommMask(m_hCOM, 0);

	// ^CAEg
	::GetCommTimeouts(m_hCOM, &cto);
	cto.ReadIntervalTimeout = 1;
	cto.ReadTotalTimeoutMultiplier = 0;
	cto.ReadTotalTimeoutConstant = 10000;
	cto.WriteTotalTimeoutMultiplier = 0;
	cto.WriteTotalTimeoutConstant = 10000;
	::SetCommTimeouts(m_hCOM, &cto);

	// M҂
	memset(&m_RxOver, 0, sizeof(m_RxOver));
	::ReadFile(m_hCOM, m_RxBuf, sizeof(m_RxBuf), NULL, &m_RxOver);

	// MȂ
	m_bTxValid = FALSE;
	memset(&m_TxOver, 0, sizeof(m_TxOver));

	// ItOオ܂
	while (!m_bCOMReq) {
		// X[v
		::Sleep(5);

		// CTS, DSR
		OnCTSDSR();

		// G[
		OnErr();

		// M
		OnRx();

		// Win32擾
		::GetCommState(m_hCOM, &dcb);

		// VMbN
		::LockVM();

		// 
		AdjustCOM(&dcb);
		SignalCOM();
		BufCOM();

		// VMAbN
		::UnlockVM();

		// M
		CtrlCOM();

		// M
		OnTx();
	}
}

//---------------------------------------------------------------------------
//
//	p[^킹
//
//---------------------------------------------------------------------------
void FASTCALL CPort::AdjustCOM(DCB *pDCB)
{
	DCB dcb;
	const SCC::scc_t *scc;
	const SCC::ch_t *p;
	int i;
	BOOL bFlag;
	DWORD dwValue;
	static DWORD dwTable[] = {
		CBR_110,
		CBR_300,
		CBR_600,
		CBR_1200,
		CBR_2400,
		CBR_4800,
		CBR_9600,
		CBR_14400,
		CBR_19200,
		31250,
		CBR_38400,
		CBR_57600,
		CBR_115200,
		0
	};

	ASSERT(this);
	ASSERT(m_pSCC);
	ASSERT(m_hCOM);
	ASSERT(pDCB);

	// ύXLIt
	bFlag = FALSE;

	// SCC擾
	scc = m_pSCC->GetWork();
	p = &scc->ch[0];

	// Win32擾
	memcpy(&dcb, pDCB, sizeof(dcb));

	// {[[g
	dwValue = CBR_300;
	for (i=0;; i++) {
		// e[uI[ł300bps
		if (dwTable[i] == 0) {
			break;
		}
		// ㉺5%̕Ń}b`
		if (MatchCOM(p->baudrate, dwTable[i])) {
			dwValue = dwTable[i];
			break;
		}
	}

	// 38400bps
	if (m_bForce) {
		dwValue = CBR_38400;
	}

	// r
	if (dcb.BaudRate != dwValue) {
		dcb.BaudRate = dwValue;
		bFlag = TRUE;
	}

	// oCi[h
	dcb.fBinary = 0;

	// peBL
	if (p->parity == 0) {
		dwValue = 0;
	}
	else {
		dwValue = 1;
	}
	if (dcb.fParity != dwValue) {
		dcb.fParity = dwValue;
	}

	// CTSt[
	if (dcb.fOutxCtsFlow != 0) {
		dcb.fOutxCtsFlow = 0;
		bFlag = TRUE;
	}

	// DSRt[
	if (dcb.fOutxDsrFlow != 0) {
		dcb.fOutxDsrFlow = 0;
		bFlag = TRUE;
	}

	// DTR
	if (dcb.fDtrControl != DTR_CONTROL_ENABLE) {
		dcb.fDtrControl = DTR_CONTROL_ENABLE;
		bFlag = TRUE;
	}

	// DSRZX
	if (dcb.fDsrSensitivity != 0) {
		dcb.fDsrSensitivity = 0;
		bFlag = TRUE;
	}

	// XON,XOFF
	if (dcb.fTXContinueOnXoff != 0) {
		dcb.fTXContinueOnXoff = 0;
		bFlag = TRUE;
	}

	// OutX
	if (dcb.fOutX != 0) {
		dcb.fOutX = 0;
		bFlag = TRUE;
	}

	// InX
	if (dcb.fInX != 0) {
		dcb.fInX = 0;
		bFlag = TRUE;
	}

	// ErrorChar
	if (dcb.fErrorChar != 0) {
		dcb.fErrorChar = 0;
		bFlag = TRUE;
	}

	// fRTSControl
	if (dcb.fRtsControl != RTS_CONTROL_ENABLE) {
		dcb.fRtsControl = RTS_CONTROL_ENABLE;
		bFlag = TRUE;
	}

	// fAbortOnError
	if (dcb.fAbortOnError != TRUE) {
		dcb.fAbortOnError = TRUE;
		bFlag = TRUE;
	}

	// f[^rbg
	if (dcb.ByteSize != (BYTE)p->rxbit) {
		if (p->rxbit == p->txbit) {
			if (p->rxbit >= 5) {
				dcb.ByteSize = (BYTE)p->rxbit;
				bFlag = TRUE;
			}
		}
	}

	// peB
	switch (p->parity) {
		case 0:
			dwValue = NOPARITY;
			break;
		case 1:
			dwValue = ODDPARITY;
			break;
		case 2:
			dwValue = EVENPARITY;
			break;
		default:
			ASSERT(FALSE);
			break;
	}
	if (dcb.Parity != (BYTE)dwValue) {
		dcb.Parity = (BYTE)dwValue;
		bFlag = TRUE;
	}

	// Xgbvrbg
	switch (p->stopbit) {
		case 1:
			dwValue = ONESTOPBIT;
			break;
		case 2:
			dwValue = ONE5STOPBITS;
			break;
		case 3:
			dwValue = TWOSTOPBITS;
			break;
		default:
			dwValue = ONESTOPBIT;
			break;
	}
	if (dcb.StopBits != (BYTE)dwValue) {
		dcb.StopBits = (BYTE)dwValue;
		bFlag = TRUE;
	}

	// قȂĂ
	if (bFlag) {
		// ݒ
		::SetCommState(m_hCOM, &dcb);

		// obt@NA
		m_TxQueue.Clear();
		m_RxQueue.Clear();

		// Win32p[W
		::PurgeComm(m_hCOM, PURGE_TXCLEAR);
		::PurgeComm(m_hCOM, PURGE_RXCLEAR);
	}
}

//---------------------------------------------------------------------------
//
//	{[[g}b`
//
//---------------------------------------------------------------------------
BOOL FASTCALL CPort::MatchCOM(DWORD dwSCC, DWORD dwBase)
{
	DWORD dwOffset;

	ASSERT(this);

	// IWiɑ΂5%̃ItZbg
	dwOffset = (dwBase * 5);
	dwOffset /= 100;

	// ͈͂Ɏ܂ĂOK
	if ((dwBase - dwOffset) <= dwSCC) {
		if (dwSCC <= (dwBase + dwOffset)) {
			return TRUE;
		}
	}

	// Ⴄ
	return FALSE;
}

//---------------------------------------------------------------------------
//
//	M킹
//
//---------------------------------------------------------------------------
void FASTCALL CPort::SignalCOM()
{
	ASSERT(this);
	ASSERT(m_pSCC);

	// VM֒ʒm(G[)
	if (m_dwErr & CE_BREAK) {
		m_pSCC->SetBreak(0, TRUE);
	}
	else {
		m_pSCC->SetBreak(0, FALSE);
	}
	if (m_dwErr & CE_FRAME) {
		m_pSCC->FramingErr(0);
	}
	if (m_dwErr & CE_RXPARITY) {
		m_pSCC->ParityErr(0);
	}

	// VM֒ʒm(M)
	m_pSCC->SetCTS(0, m_bCTS);
	m_pSCC->SetDCD(0, m_bDSR);

	// VMʒm(M)
	m_bBreak = m_pSCC->GetBreak(0);
	m_bRTS = m_pSCC->GetRTS(0);
	m_bDTR = m_pSCC->GetDTR(0);
}

//---------------------------------------------------------------------------
//
//	obt@킹
//
//---------------------------------------------------------------------------
void FASTCALL CPort::BufCOM()
{
	DWORD i;
	BYTE RxBuf[0x1000];
	DWORD dwRx;
	BYTE TxData;

	ASSERT(this);
	ASSERT(m_pSCC);

	// Mf[^ꊇ擾
	dwRx = m_RxQueue.Get(RxBuf);

	// Lȃf[^ׂ͂SCC֑
	for (i=0; i<dwRx; i++) {
		m_pSCC->Send(0, RxBuf[i]);
	}

	// SCCobt@̏ԂāAMEFCg
	if (m_pSCC->IsTxFull(0)) {
		// obt@tȂ̂ŁAȏ㑗MȂ
		m_pSCC->WaitTx(0, TRUE);
	}
	else {
		// M
		m_pSCC->WaitTx(0, FALSE);
	}

	// Mf[^΁A󂯎
	while (!m_pSCC->IsTxEmpty(0)) {
		// obt@𒴂Ȃ͈͂ɉ
		if (m_TxQueue.GetFree() == 0) {
			break;
		}

		TxData = (BYTE)m_pSCC->Receive(0);
		m_TxQueue.Insert(&TxData, 1);
	}
}

//---------------------------------------------------------------------------
//
//	M
//
//---------------------------------------------------------------------------
void FASTCALL CPort::CtrlCOM()
{
	ASSERT(this);
	ASSERT(m_hCOM);

	// u[N
	if (m_bBreak) {
		::EscapeCommFunction(m_hCOM, SETBREAK);
	}
	else {
		::EscapeCommFunction(m_hCOM, CLRBREAK);
	}

	// RTS
	if (m_bRTS) {
		::EscapeCommFunction(m_hCOM, SETRTS);
	}
	else {
		::EscapeCommFunction(m_hCOM, CLRRTS);
	}

	// DTR
	if (m_bDTR) {
		::EscapeCommFunction(m_hCOM, SETDTR);
	}
	else {
		::EscapeCommFunction(m_hCOM, CLRDTR);
	}
}

//---------------------------------------------------------------------------
//
//	CTS,DSR
//
//---------------------------------------------------------------------------
void FASTCALL CPort::OnCTSDSR()
{
	DWORD dwStat;

	ASSERT(this);
	ASSERT(m_hCOM);

	// Ԏ擾
	::GetCommModemStatus(m_hCOM, &dwStat);

	// CTS
	if (dwStat & MS_CTS_ON) {
		m_bCTS = TRUE;
	}
	else {
		m_bCTS = FALSE;
	}

	// DSR
	if (dwStat & MS_DSR_ON) {
		m_bDSR = TRUE;
	}
	else {
		m_bDSR = FALSE;
	}
}

//---------------------------------------------------------------------------
//
//	MG[
//
//---------------------------------------------------------------------------
void FASTCALL CPort::OnErr()
{
	ASSERT(this);
	ASSERT(m_hCOM);

	// G[NAAɏL^
	::ClearCommError(m_hCOM, &m_dwErr, NULL);
}

//---------------------------------------------------------------------------
//
//	MTu
//
//---------------------------------------------------------------------------
void FASTCALL CPort::OnRx()
{
	DWORD dwReceived;

	ASSERT(this);
	ASSERT(m_hCOM);

	// MĂȂΉȂ
	dwReceived = 0;
	if (!GetOverlappedResult(m_hCOM, &m_RxOver, &dwReceived, FALSE)) {
		return;
	}

	// MLł
	if (dwReceived > 0) {
		// MOt@CLł΁A
		if (m_RecvFile.IsValid()) {
			m_RecvFile.Write(m_RxBuf, dwReceived);
		}

		// L[ɑ}
		m_RxQueue.Insert(m_RxBuf, dwReceived);
	}

	// ̎M
	memset(&m_RxOver, 0, sizeof(m_RxOver));
	::ReadFile(m_hCOM, m_RxBuf, sizeof(m_RxBuf), NULL, &m_RxOver);
}

//---------------------------------------------------------------------------
//
//	MTu
//
//---------------------------------------------------------------------------
void FASTCALL CPort::OnTx()
{
	DWORD dwSize;
	DWORD dwSent;

	ASSERT(this);
	ASSERT(m_hCOM);

	// ȎMIĂȂ΁A^[
	if (m_bTxValid) {
		if (!GetOverlappedResult(m_hCOM, &m_TxOver, &dwSent, FALSE)) {
			return;
		}

		// MłAMobt@i߂
		if (dwSent > 0) {
			m_TxQueue.Discard(dwSent);
		}

		// 󑗐MȂ
		m_bTxValid = FALSE;
	}

	// M̂Ȃ΁A^[
	if (m_TxQueue.IsEmpty()) {
		return;
	}

	// ML[擾(|C^͐i߂Ȃ)
	dwSize = m_TxQueue.Copy(m_TxBuf);

	// MJn
	memset(&m_TxOver, 0, sizeof(m_TxOver));
	m_bTxValid = TRUE;
	::WriteFile(m_hCOM, m_TxBuf, dwSize, NULL, &m_TxOver);
}

//---------------------------------------------------------------------------
//
//	COM擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CPort::GetCOMInfo(LPTSTR lpszDevFile, DWORD *dwLogFile) const
{
	ASSERT(this);
	ASSERT(lpszDevFile);
	ASSERT(dwLogFile);

	// t@C̓kAnh͖
	_tcscpy(lpszDevFile, _T("  (None)"));
	*dwLogFile = (DWORD)INVALID_HANDLE_VALUE;

	// XbhĂȂ΁A̎_FALSEŋA
	if (!m_pCOM) {
		return FALSE;
	}

	// foCXt@Cݒ
	if (m_nCOM > 0) {
		_stprintf(lpszDevFile, _T("\\\\.\\COM%d"), m_nCOM);
	}

	// Ot@Cݒ
	if (m_RecvFile.IsValid()) {
		*dwLogFile = (DWORD)m_RecvFile.GetHandle();
	}

	// Xbh͓Ă
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	ML[擾
//
//---------------------------------------------------------------------------
void FASTCALL CPort::GetTxQueue(CQueue::LPQUEUEINFO lpqi) const
{
	ASSERT(this);
	ASSERT(lpqi);

	m_TxQueue.GetQueue(lpqi);
}

//---------------------------------------------------------------------------
//
//	ML[擾
//
//---------------------------------------------------------------------------
void FASTCALL CPort::GetRxQueue(CQueue::LPQUEUEINFO lpqi) const
{
	ASSERT(this);
	ASSERT(lpqi);

	m_RxQueue.GetQueue(lpqi);
}

//===========================================================================
//
//	p|[g
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	LPTI[v
//	VMbN
//
//---------------------------------------------------------------------------
BOOL FASTCALL CPort::OpenLPT()
{
	COMMTIMEOUTS cto;
	CString strFile;

	ASSERT(this);

	// nh
	m_hLPT = INVALID_HANDLE_VALUE;
	m_pLPT = NULL;
	m_bLPTValid = FALSE;

	// Ot@C̍쐬(Ayh)
	AppendLPT();

	// |[g0łȂꍇALPTfoCX֏o
	if (m_nLPT != 0) {
		// t@C쐬
		strFile.Format(_T("\\\\.\\LPT%d"), m_nLPT);

		// I[v
		m_hLPT = ::CreateFile(  strFile,
								GENERIC_WRITE,
								0,
								NULL,
								OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
								0);

		// I[vłĂݒ
		if (m_hLPT != INVALID_HANDLE_VALUE) {
			// obt@TCY
			::SetupComm(m_hLPT, 0x400, 0x1000);

			// Cxg}XN
			::SetCommMask(m_hLPT, 0);

			// ^CAEg
			::GetCommTimeouts(m_hLPT, &cto);
			cto.WriteTotalTimeoutMultiplier = 1;
			cto.WriteTotalTimeoutConstant = 10;
			::SetCommTimeouts(m_hLPT, &cto);
		}
	}

	// obt@
	m_LPTQueue.Clear();

	// Ot@CLPTfoCX
	if (m_SendFile.IsValid() || (m_hLPT != INVALID_HANDLE_VALUE)) {
		// Xbh𗧂Ă
		m_bLPTReq = FALSE;
		m_pLPT = AfxBeginThread(LPTThread, this);

		// XbhȂAv^֒ʒm
		if (m_pLPT) {
			m_pPrinter->Connect(TRUE);
			return TRUE;
		}
	}

	// |[g(m_pPrinter->Connect(FALSE)Ă)
	CloseLPT();
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	LPTOt@C
//
//---------------------------------------------------------------------------
void FASTCALL CPort::AppendLPT()
{
	TCHAR szDrive[_MAX_DRIVE];
	TCHAR szDir[_MAX_DIR];
	TCHAR szFile[_MAX_FNAME];
	TCHAR szExt[_MAX_EXT];
	Filepath path;

	ASSERT(this);

	// Ot@Cw肪ł΁AKvȂ
	if (_tcslen(m_SendLog) == 0) {
		return;
	}

	// 
	_tsplitpath(m_SendLog, szDrive, szDir, szFile, szExt);

	// tpXwłȂΑ΃pX̗p
	path.SetPath(m_SendLog);
	if ((_tcslen(szDrive) == 0) && (szDir[0] != _T('\\'))) {
		path.SetBaseDir();
	}

	// AyhI[v
	m_SendFile.Open(path, Fileio::Append);
}

//---------------------------------------------------------------------------
//
//	LPTN[Y
//	VMbN
//
//---------------------------------------------------------------------------
void FASTCALL CPort::CloseLPT()
{
	DWORD dwCompleted;

	ASSERT(this);

	// Xbh
	if (m_pLPT) {
		// Ivグ
		m_bLPTReq = TRUE;

		// I҂()
		::WaitForSingleObject(m_pLPT->m_hThread, INFINITE);

		m_pLPT = NULL;
	}

	// nh
	if (m_hLPT != INVALID_HANDLE_VALUE) {
		// M
		if (m_bLPTValid) {
			if (!GetOverlappedResult(m_hLPT, &m_LPTOver, &dwCompleted, FALSE)) {
				// ܂ۗ
				CancelIo(m_hLPT);
			}
			// MĂȂ
			m_bLPTValid = FALSE;
		}

		// N[Y
		::CloseHandle(m_hLPT);

		// [N
		m_hLPT = INVALID_HANDLE_VALUE;
		m_bLPTValid = FALSE;
		memset(&m_LPTOver, 0, sizeof(m_LPTOver));
	}

	// Ot@CN[Y
	if (m_SendFile.IsValid()) {
		m_SendFile.Close();
	}

	// v^ɑ΂Aؒfʒm
	m_pPrinter->Connect(FALSE);
}

//---------------------------------------------------------------------------
//
//	LPTs
//
//---------------------------------------------------------------------------
void FASTCALL CPort::RunLPT()
{
	ASSERT(this);

	// ItOオ܂
	while (!m_bLPTReq) {
		// X[v
		::Sleep(10);

		// obt@̓e𑗐M܂̓Oo
		SendLPT();

		// v^f[^擾
		RecvLPT();
	}
}

//---------------------------------------------------------------------------
//
//	v^f[^M
//
//---------------------------------------------------------------------------
void FASTCALL CPort::SendLPT()
{
	BYTE Buffer[0x1000];
	DWORD dwNum;
	DWORD dwWritten;

	ASSERT(this);

	// M
	if (!m_bLPTValid) {
		// 莝̃obt@ȂAȂ
		if (m_LPTQueue.IsEmpty()) {
			return;
		}

		// f[^ꊇĎ󂯎
		dwNum = m_LPTQueue.Copy(Buffer);
		ASSERT(dwNum > 0);
		ASSERT(dwNum <= sizeof(Buffer));

		// obt@͗LBLPTfoCXȂ΃OL^̂
		if (m_hLPT == INVALID_HANDLE_VALUE) {
			// MOt@C͕K
			ASSERT(m_SendFile.IsValid());

			// Ot@C
			m_SendFile.Write(Buffer, dwNum);

			// Ői߂
			m_LPTQueue.Discard(dwNum);
			return;
		}

		// obt@LLPTfoCXB݂s
		memset(&m_LPTOver, 0, sizeof(m_LPTOver));
		::WriteFile(m_hLPT, Buffer, dwNum, &dwWritten, &m_LPTOver);
		m_bLPTValid = TRUE;
		return;
	}

	// foCXȂ΂Ŋ
	if (m_hLPT == INVALID_HANDLE_VALUE) {
		return;
	}

	// M
	if (!GetOverlappedResult(m_hLPT, &m_LPTOver, &dwWritten, FALSE)) {
		return;
	}

	// MBo߂Ď󂯎(obt@)
	m_LPTQueue.Copy(Buffer);
	m_LPTQueue.Discard(dwWritten);

	// Ot@C
	if (m_SendFile.IsValid()) {
		m_SendFile.Write(Buffer, dwWritten);
	}

	// MtOƂ
	m_bLPTValid = FALSE;
}

//---------------------------------------------------------------------------
//
//	v^f[^擾
//	v^foCXŔr䂪
//
//---------------------------------------------------------------------------
void FASTCALL CPort::RecvLPT()
{
	BYTE Buffer[0x1000];
	DWORD dwNum;
	DWORD dwFree;

	ASSERT(this);

	// obt@]T擾
	dwFree = m_LPTQueue.GetFree();
	dwNum = 0;

	// obt@ɗ]T邾[v
	while (dwFree > 0) {
		// f[^擾݂
		if (!m_pPrinter->GetData(&Buffer[dwNum])) {
			break;
		}

		// f[^𑝂₷
		dwFree--;
		dwNum++;
	}

	// ǉ̂΃L[
	if (dwNum > 0) {
		m_LPTQueue.Insert(Buffer, dwNum);
	}
}

//---------------------------------------------------------------------------
//
//	LPT擾
//
//---------------------------------------------------------------------------
BOOL FASTCALL CPort::GetLPTInfo(LPTSTR lpszDevFile, DWORD *dwLogFile) const
{
	ASSERT(this);
	ASSERT(lpszDevFile);
	ASSERT(dwLogFile);

	// t@C̓kAnh͖
	_tcscpy(lpszDevFile, _T("  (None)"));
	*dwLogFile = (DWORD)INVALID_HANDLE_VALUE;

	// XbhĂȂ΁A̎_FALSEŋA
	if (!m_pLPT) {
		return FALSE;
	}

	// foCXt@Cݒ
	if (m_nLPT > 0) {
		_stprintf(lpszDevFile, _T("\\\\.\\LPT%d"), m_nLPT);
	}

	// Ot@Cݒ
	if (m_SendFile.IsValid()) {
		*dwLogFile = (DWORD)m_SendFile.GetHandle();
	}

	// Xbh͓Ă
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	LPTL[擾
//
//---------------------------------------------------------------------------
void FASTCALL CPort::GetLPTQueue(CQueue::LPQUEUEINFO lpqi) const
{
	ASSERT(this);
	ASSERT(lpqi);

	m_LPTQueue.GetQueue(lpqi);
}

#endif	// _WIN32
