//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2004 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC |[g ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_port_h)
#define mfc_port_h

#include "fileio.h"
#include "mfc_que.h"

//===========================================================================
//
//	|[g
//
//===========================================================================
class CPort : public CComponent
{
public:
	// {t@NV
	CPort(CFrmWnd *pWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp

	// OAPI
	void FASTCALL RunCOM();
										// COMs
	BOOL FASTCALL GetCOMInfo(LPTSTR lpszDevFile, DWORD *dwLogFile) const;
										// COM擾
	void FASTCALL GetTxQueue(CQueue::LPQUEUEINFO lpqi) const;
										// ML[擾
	void FASTCALL GetRxQueue(CQueue::LPQUEUEINFO lpqi) const;
										// ML[擾
	void FASTCALL RunLPT();
										// LPTs
	BOOL FASTCALL GetLPTInfo(LPTSTR lpszDevFile, DWORD *dwLogFile) const;
										// LPT擾
	void FASTCALL GetLPTQueue(CQueue::LPQUEUEINFO lpqi) const;
										// LPTL[擾

private:
	// VA|[g
	BOOL FASTCALL OpenCOM();
										// COMI[v
	void FASTCALL AppendCOM();
										// COMt@C
	void FASTCALL CloseCOM();
										// COMN[Y
	void FASTCALL AdjustCOM(DCB *pDCB);
										// p[^킹
	BOOL FASTCALL MatchCOM(DWORD dwSCC, DWORD dwBase);
										// {[[g}b`
	void FASTCALL SignalCOM();
										// M킹
	void FASTCALL BufCOM();
										// obt@킹
	void FASTCALL CtrlCOM();
										// M
	void FASTCALL OnCTSDSR();
										// CTS, DSRω
	void FASTCALL OnErr();
										// MG[
	void FASTCALL OnRx();
										// MTu
	void FASTCALL OnTx();
										// MTu
	UINT m_nCOM;
										// COM|[g(0ŎgpȂ)
	HANDLE m_hCOM;
										// t@Cnh
	CWinThread *m_pCOM;
										// Xbh
	BOOL m_bCOMReq;
										// XbhIv
	BOOL m_bBreak;
										// X68000ou[N
	BOOL m_bRTS;
										// RTS(M)
	BOOL m_bDTR;
										// DTR(M)
	BOOL m_bCTS;
										// CTS(M)
	BOOL m_bDSR;
										// DSR(M)
	OVERLAPPED m_TxOver;
										// I[o[bv
	CQueue m_TxQueue;
										// ML[
	BYTE m_TxBuf[0x1000];
										// MI[o[bvobt@
	BOOL m_bTxValid;
										// MLtO
	OVERLAPPED m_RxOver;
										// I[o[bv
	CQueue m_RxQueue;
										// ML[
	BYTE m_RxBuf[0x1000];
										// MI[o[bvobt@
	DWORD m_dwErr;
										// MG[
	TCHAR m_RecvLog[_MAX_PATH];
										// MO
	Fileio m_RecvFile;
										// MO
	BOOL m_bForce;
										// 38400bps[h
	SCC *m_pSCC;
										// SCC

	// p|[g
	BOOL FASTCALL OpenLPT();
										// LPTI[v
	void FASTCALL AppendLPT();
										// LPTt@C
	void FASTCALL CloseLPT();
										// LPTN[Y
	void FASTCALL RecvLPT();
										// LPTM
	void FASTCALL SendLPT();
										// LPTM

	UINT m_nLPT;
										// LPT|[g(0ŎgpȂ)
	HANDLE m_hLPT;
										// t@Cnh
	CWinThread *m_pLPT;
										// Xbh
	BOOL m_bLPTReq;
										// XbhIv
	BOOL m_bLPTValid;
										// MLtO
	OVERLAPPED m_LPTOver;
										// I[o[bv
	CQueue m_LPTQueue;
										// L[
	TCHAR m_SendLog[_MAX_PATH];
										// MO
	Fileio m_SendFile;
										// MO
	Printer *m_pPrinter;
										// v^
};

#endif	// mfc_port_h
#endif	// _WIN32
