//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC ROMx_CAO ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "mfc_res.h"
#include "mfc_rom.h"

//===========================================================================
//
//	ROMx_CAO
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CROMDlg::CROMDlg(CWnd *pParent) : CDialog(IDD_ROMDLG, pParent)
{
	// pւ̑Ή
	if (!::IsJapanese()) {
		m_lpszTemplateName = MAKEINTRESOURCE(IDD_US_ROMDLG);
		m_nIDHelp = IDD_US_ROMDLG;
	}

	// p[^EUg
	m_nType = 0;
	m_bFuture = TRUE;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CROMDlg, CDialog)
	ON_WM_PAINT()
	ON_COMMAND(IDC_ROM_QUITC, OnQuit)
	ON_COMMAND(IDC_ROM_CONTC, OnContinue)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	_CAO
//
//---------------------------------------------------------------------------
BOOL CROMDlg::OnInitDialog()
{
	CStatic *pStatic;
	CString strText;
	CString strFormat;

	// {NX
	if (!CDialog::OnInitDialog()) {
		return FALSE;
	}

	// ACRʒuX^eBbN擾
	pStatic = (CStatic*)GetDlgItem(IDC_ROM_STOPI);
	ASSERT(pStatic);

	// TCY32x32֕ύX
	pStatic->SetWindowPos(&wndTop, 0, 0, 32, 32, SWP_NOMOVE);

	// EBhE΋`擾A폜
	pStatic->GetWindowRect(&m_rectIcon);
	ScreenToClient(&m_rectIcon);
	pStatic->DestroyWindow();

	// ^Cv
	pStatic = (CStatic*)GetDlgItem(IDC_ROM_MSGS);
	pStatic->GetWindowText(strFormat);
	switch (m_nType) {
		// 0:IPL-ROM
		case 0:
			// ʂ̃eLXg[h
			::GetMsg(IDS_INIT_IPLERR, strText);
			break;

		// 1:CG-ROM
		case 1:
			strText.Format(strFormat, _T("CG-ROM"));
			break;

		// 2:SCSI-ROM
		case 2:
			strText.Format(strFormat, _T("SCSI-ROM"));
			break;

		// ̑(肦Ȃ)
		default:
			ASSERT(FALSE);
			break;
	}
	pStatic->SetWindowText(strText);

	// BEEP炷
	::MessageBeep(MB_ICONHAND);

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	OK
//
//---------------------------------------------------------------------------
void CROMDlg::OnOK()
{
	// [ENTER]ɂ_CAOI}
}

//---------------------------------------------------------------------------
//
//	`
//
//---------------------------------------------------------------------------
void CROMDlg::OnPaint()
{
	CPaintDC dc(this);
	HICON hIcon;

	// STOPWACR[h
	hIcon = AfxGetApp()->LoadStandardIcon(MAKEINTRESOURCE(IDI_ERROR));

	// [hłꍇ
	if (hIcon) {
		// DrawIconŕ`
		dc.DrawIcon(m_rectIcon.left, m_rectIcon.top, hIcon);
	}

	// WACR폜Kv͂Ȃ
}

//---------------------------------------------------------------------------
//
//	I
//
//---------------------------------------------------------------------------
void CROMDlg::OnQuit()
{
	// LZƓ
	OnCancel();
}

//---------------------------------------------------------------------------
//
//	p
//
//---------------------------------------------------------------------------
void CROMDlg::OnContinue()
{
	CButton *pButton;

	// `FbN{bNX̓e擾
	pButton = (CButton*)GetDlgItem(IDC_ROM_FUTUREC);
	ASSERT(pButton);
	if (pButton->GetCheck() == 1) {
		// A\ȂFALSE
		m_bFuture = FALSE;
	}
	else {
		// A\遨TRUE
		m_bFuture = TRUE;
	}

	// _CAOI
	CDialog::OnOK();
}

#endif	// _WIN32
