//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC XPW[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "cpu.h"
#include "mouse.h"
#include "render.h"
#include "config.h"
#include "mfc_com.h"
#include "mfc_frm.h"
#include "mfc_draw.h"
#include "mfc_snd.h"
#include "mfc_inp.h"
#include "mfc_cpu.h"
#include "mfc_sch.h"

//===========================================================================
//
//	XPW[
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CScheduler::CScheduler(CFrmWnd *pFrmWnd) : CComponent(pFrmWnd)
{
	int nIndex;

	// R|[lgp[^
	m_dwID = MAKEID('S', 'C', 'H', 'E');
	m_strDesc = _T("Scheduler");

	// foCXER|[lg
	m_pCPU = NULL;
	m_pRender = NULL;
	m_pThread = NULL;
	m_pSound = NULL;
	m_pInput = NULL;

	// [N
	m_bExitReq = FALSE;
	m_dwExecTime = 0;
	m_nSubWndNum = 0;
	m_nSubWndDisp = -1;
	m_dwDrawCount = 0;
	m_dwDrawTime = 0;
	m_bMenu = FALSE;
	m_bActivate = TRUE;
	m_bBackup = TRUE;
	m_bSavedValid = FALSE;
	m_bSavedEnable = FALSE;

	// [N(L[ɂꎞIȗL\Ȃ)
	for (nIndex=0; nIndex<IdxMax; nIndex++) {
		m_bMPUFull[nIndex] = FALSE;
		m_bVMFull[nIndex] = FALSE;
		m_dwRendThres[nIndex] = 1;
		m_bRendRefresh[nIndex] = FALSE;
	}
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CScheduler::Init()
{
	ASSERT(this);

	// {NX
	if (!CComponent::Init()) {
		return FALSE;
	}

	// CPU擾
	ASSERT(!m_pCPU);
	m_pCPU = (CPU*)::GetVM()->SearchDevice(MAKEID('C', 'P', 'U', ' '));
	ASSERT(m_pCPU);

	// _擾
	ASSERT(!m_pRender);
	m_pRender = (Render*)::GetVM()->SearchDevice(MAKEID('R', 'E', 'N', 'D'));
	ASSERT(m_pRender);

	// TEhR|[lg
	ASSERT(!m_pSound);
	m_pSound = (CSound*)SearchComponent(MAKEID('S', 'N', 'D', ' '));
	ASSERT(m_pSound);

	// CvbgR|[lg
	ASSERT(!m_pInput);
	m_pInput = (CInput*)SearchComponent(MAKEID('I', 'N', 'P', ' '));
	ASSERT(m_pInput);

	// }`fBA^C}[̎ԊԊu1msɐݒ
	::timeBeginPeriod(1);

	// Xbh𗧂Ă
	m_pThread = AfxBeginThread(ThreadFunc, this);
	if (!m_pThread) {
		::timeEndPeriod(1);
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::Cleanup()
{
	ASSERT(this);
	ASSERT_VALID(this);

	// ~
	Stop();

	// }`fBA^C}[̎ԊԊu߂
	::timeEndPeriod(1);

	// {NX
	CComponent::Cleanup();
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::ApplyCfg(const Config *pConfig)
{
	BOOL bFlag;

	ASSERT(this);
	ASSERT_VALID(this);
	ASSERT(pConfig);

	// VMtۑ
	bFlag = m_bVMFull[ValIdx];

	// Rs[
	m_bMPUFull[CfgIdx] = pConfig->mpu_fullspeed;
	m_bVMFull[CfgIdx] = pConfig->vm_fullspeed;
	m_dwRendThres[CfgIdx] = pConfig->rend_thres;
	m_bRendRefresh[CfgIdx] = pConfig->rend_refresh;

	// [Nč\z
	Construct();

	// 烊Zbg
	if (bFlag != m_bVMFull[ValIdx]) {
		Reset();
	}
}

#if defined(_DEBUG)
//---------------------------------------------------------------------------
//
//	ff
//
//---------------------------------------------------------------------------
void CScheduler::AssertValid() const
{
	ASSERT(this);
	ASSERT(GetID() == MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pCPU);
	ASSERT(m_pCPU->GetID() == MAKEID('C', 'P', 'U', ' '));
	ASSERT(m_pRender);
	ASSERT(m_pRender->GetID() == MAKEID('R', 'E', 'N', 'D'));
	ASSERT(m_pSound);
	ASSERT(m_pSound->GetID() == MAKEID('S', 'N', 'D', ' '));
	ASSERT(m_pInput);
	ASSERT(m_pInput->GetID() == MAKEID('I', 'N', 'P', ' '));
}
#endif	// _DEBUG

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::Reset()
{
	ASSERT(this);
	ASSERT_VALID(this);

	// Zbg
	m_dwExecTime = GetTime();
	m_dwDrawTime = m_dwExecTime;
	m_dwDrawBackup = 0;
	m_dwDrawCount = 0;
	m_dwDrawPrev = 0;
}

//---------------------------------------------------------------------------
//
//	~
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::Stop()
{
	ASSERT(this);
	ASSERT_VALID(this);

	// XbhオĂꍇ̂ݏI
	if (m_pThread) {
		// INGXg𗧂Ă
		m_bExitReq = TRUE;

		// ~܂ő҂
		::WaitForSingleObject(m_pThread->m_hThread, INFINITE);

		// Xbh͏I
		m_pThread = NULL;
	}
}

//---------------------------------------------------------------------------
//
//	Z[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL CScheduler::Save(Fileio *pFio, int /*nVer*/)
{
	ASSERT(this);
	ASSERT_VALID(this);

	// Z[uEnableԂۑ(version2.04)
	if (!pFio->Write(&m_bSavedEnable, sizeof(m_bSavedEnable))) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	[h
//
//---------------------------------------------------------------------------
BOOL FASTCALL CScheduler::Load(Fileio *pFio, int nVer)
{
	ASSERT(this);
	ASSERT(nVer >= 0x0200);
	ASSERT_VALID(this);

	// Z[uEnableԕۑ͂ĂȂ̂Ɖ
	m_bSavedValid = FALSE;

	// version2.04ȍ~ł΁A[h
	if (nVer >= 0x0204) {
		if (!pFio->Read(&m_bSavedEnable, sizeof(m_bSavedEnable))) {
			return FALSE;
		}
		m_bSavedValid = TRUE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Xbh֐
//
//---------------------------------------------------------------------------
UINT CScheduler::ThreadFunc(LPVOID pParam)
{
	CScheduler *pSch;

	// p[^󂯎
	pSch = (CScheduler*)pParam;
	ASSERT(pSch);
#if defined(_DEBUG)
	pSch->AssertValid();
#endif	// _DEBUG

	// s
	pSch->Run();

	// IR[hăXbhI
	return 0;
}

//---------------------------------------------------------------------------
//
//	s
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::Run()
{
	VM *pVM;
	Scheduler *pScheduler;
	Render *pRender;
	DWORD dwExecCount;
	DWORD dwCycle;
	DWORD dwTime;

	ASSERT(this);
	ASSERT_VALID(this);

	// VM擾
	pVM = ::GetVM();
	ASSERT(pVM);
	pScheduler = (Scheduler*)pVM->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(pScheduler);
	pRender = (Render*)pVM->SearchDevice(MAKEID('R', 'E', 'N', 'D'));
	ASSERT(pRender);

	// ԃJE^
	m_dwExecTime = GetTime();
	dwExecCount = 0;
	m_dwDrawTime = m_dwExecTime;
	m_dwDrawBackup = 0;
	m_dwDrawCount = 0;
	m_dwDrawPrev = 0;
	m_bBackup = m_bEnable;

	// INGXgオ܂Ń[v
	while (!m_bExitReq) {
		// 펞ff
		ASSERT_VALID(this);

		// Sleep
		::Sleep(0);

		// bN
		Lock();

		// LtOオĂȂ΁A~
		if (!m_bEnable) {
			// u[N|CgAd~ȂǂŗLɂȂAKĕ`
			if (m_bBackup) {
				m_pFrmWnd->GetView()->Invalidate(FALSE);
				m_bBackup = FALSE;
			}

			// `
			Refresh();
			dwExecCount = 0;

			// R|[lg̏AԂ킹
			m_pSound->Process(FALSE);
			m_pInput->Process(FALSE);
			m_dwExecTime = GetTime();
			Unlock();

			// Sleep
			::Sleep(10);
			continue;
		}

		// obNAbvtOXV(O܂Ŏs)
		m_bBackup = TRUE;

		// ԂtȂA\]T
		dwTime = GetTime();
		if (m_dwExecTime > dwTime) {
			// 啝ɂĂȂ獇킹(49[vΉ)
			if ((m_dwExecTime - dwTime) > 1000) {
				m_dwExecTime = dwTime;
			}

			// `
			Refresh();
			dwExecCount = 0;

			// [h̏
			if (m_dwExecTime > GetTime()) {
				// Ԃɗ]T
				if (m_bVMFull[ValIdx]) {
					// VM[h
					m_dwExecTime = GetTime();
				}
				else {
					if (!m_bMPUFull[ValIdx]) {
						// ʏ탂[h
						Unlock();
						::Sleep(1);
						continue;
					}
					// MPU[h
					dwCycle = pScheduler->GetCPUCycle();
					while (m_dwExecTime > GetTime()) {
						m_pCPU->Exec(pScheduler->GetCPUSpeed());
					}
					pScheduler->SetCPUCycle(dwCycle);
					Unlock();
					continue;
				}
			}
		}

		// _Oۂ𔻒(1or36)
		if (m_dwExecTime >= dwTime) {
			pRender->EnableAct(TRUE);
		}
		else {
			if ((dwTime - m_dwExecTime) <= m_dwRendThres[ValIdx]) {
				// 
				pRender->EnableAct(TRUE);
			}
			else {
				pRender->EnableAct(FALSE);
			}
		}

		// `惂[h
		if (m_bRendRefresh[ValIdx] && !m_bVMFull[ValIdx]) {
			// ANeBuj[\łȂƂ
			if (m_bActivate && !m_bMenu) {
				// _̏łĂ邱
				if (m_pRender->IsReady()) {
					// Ready~܂ŁA[vɌĂ
					Refresh();
				}
			}
		}

		// VM쓮
		if (!pVM->Exec(1000 * 2)) {
			// u[N|Cg
			SyncDisasm();
			dwExecCount++;
			m_bEnable = FALSE;
			Unlock();
			continue;
		}

		// d`FbN
		if (!pVM->IsPower()) {
			// dIt
			SyncDisasm();
			dwExecCount++;
			m_bEnable = FALSE;
			Unlock();
			continue;
		}
		dwExecCount++;
		m_dwExecTime++;

		// R|[lg̏
		m_pSound->Process(TRUE);
		m_pInput->Process(TRUE);

		// dwExecCountK萔𒴂Ax\ċԍ킹
		if (dwExecCount > 400) {
			Refresh();
			dwExecCount = 0;
			m_dwExecTime = GetTime();
		}

		// ANeBu܂̓j[ONȂA8msƂ1xSleep
		if (!m_bActivate || m_bMenu) {
			if ((m_dwExecTime & 0x07) == 0) {
				Unlock();
				::Sleep(1);
				continue;
			}
		}

		// AbN
		Unlock();
	}
}

//---------------------------------------------------------------------------
//
//	tbV
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::Refresh()
{
	int num;
	CDrawView *pView;

	ASSERT(this);
	ASSERT_VALID(this);
	ASSERT(m_pFrmWnd);

	// r[擾
	pView = m_pFrmWnd->GetView();
	ASSERT(pView);

	// TuEBhĚ擾
	num = pView->GetSubWndNum();

	// Llƈ烊Zbg
	if (m_nSubWndNum != num) {
		m_nSubWndNum = num;
		m_nSubWndDisp = -1;
	}

	if (m_bEnable) {
		// sŃCʂ̔Ԃ
		if (m_nSubWndDisp < 0) {
			// _̏łĂȂΕ`悵Ȃ
			if (!m_pRender->IsReady()) {
				return;
			}
			SyncDisasm();
		}
	}

	// \(ꕔ)
	pView->Draw(m_nSubWndDisp);

	// Cʕ\ȂAJEg_E
	if (m_nSubWndDisp < 0) {
		m_pRender->Complete();
		m_dwDrawCount++;
	}

	// TCNbNɕ\
	m_nSubWndDisp++;
	if (m_nSubWndDisp >= m_nSubWndNum) {
		m_nSubWndDisp = -1;
	}
}

//---------------------------------------------------------------------------
//
//	tAZuPC킹
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::SyncDisasm()
{
	CDisasmWnd *pWnd;
	CDrawView *pView;
	DWORD dwID;
	int i;

	ASSERT(this);
	ASSERT_VALID(this);

	// r[擾
	pView = m_pFrmWnd->GetView();
	ASSERT(pView);

	// ő8R܂
	for (i=0; i<8; i++) {
		dwID = MAKEID('D', 'I', 'S', ('A' + i));
		pWnd = (CDisasmWnd*)pView->SearchSWnd(dwID);
		if (pWnd) {
			// 
			pWnd->SetPC(m_pCPU->GetPC());
		}
	}
}

//---------------------------------------------------------------------------
//
//	t[[g擾
//
//---------------------------------------------------------------------------
int FASTCALL CScheduler::GetFrameRate()
{
	DWORD dwCount;
	DWORD dwTime;
    DWORD dwDiff;

	ASSERT(this);
	ASSERT_VALID(this);

	// `FbN
	if (!m_bEnable) {
		return 0;
	}

	// Ԏ擾([vΉAꍇ͏)
	dwTime = GetTime();
	if (dwTime <= m_dwDrawTime) {
		m_dwDrawTime = dwTime;
		m_dwDrawBackup = 0;
		m_dwDrawCount = 0;
		m_dwDrawPrev = 0;
		return 0;
	}
	dwDiff = dwTime - m_dwDrawTime;
	if (dwDiff > 3500) {
		m_dwDrawTime = dwTime;
		m_dwDrawBackup = 0;
		m_dwDrawCount = 0;
		m_dwDrawPrev = 0;
		return 0;
	}

	// 500msȉȂ畁ʂɏ
	if (dwDiff < 500) {
		m_dwDrawBackup = 0;
		dwDiff /= 10;
		dwCount = m_dwDrawCount * 1000;
		if (dwDiff == 0) {
			return 0;
		}
		return (dwCount / dwDiff);
	}

	// 1000msȉȂL
	if (dwDiff < 1000) {
		if (m_dwDrawBackup == 0) {
			m_dwDrawBackup = dwTime;
			m_dwDrawPrev = m_dwDrawCount;
		}
		dwDiff /= 10;
		dwCount = m_dwDrawCount * 1000;
		return (dwCount / dwDiff);
	}

	// ȏȂ̂ŁAPrevɐ؂ւ
	dwDiff /= 10;
	dwCount = m_dwDrawCount * 1000;
	m_dwDrawTime = m_dwDrawBackup;
	m_dwDrawBackup = 0;
	m_dwDrawCount -= m_dwDrawPrev;
	return (dwCount / dwDiff);
}

//---------------------------------------------------------------------------
//
//	z񃏁[Nč\z
//
//---------------------------------------------------------------------------
void FASTCALL CScheduler::Construct()
{
	ASSERT(this);
	ASSERT_VALID(this);

	// MPUōVMṓAXORɂĎ
	m_bMPUFull[ValIdx] = m_bMPUFull[CfgIdx] ^ m_bMPUFull[KeyIdx];
	m_bVMFull[ValIdx] = m_bVMFull[CfgIdx] ^ m_bVMFull[KeyIdx];

	// _Opx
	m_bRendRefresh[ValIdx] = m_bRendRefresh[CfgIdx] ^ m_bRendRefresh[KeyIdx];
	if (m_bRendRefresh[ValIdx]) {
		// `惂[hȂ̂ŁAl͑傫ق
		if (m_dwRendThres[CfgIdx] < m_dwRendThres[KeyIdx]) {
			m_dwRendThres[ValIdx] = m_dwRendThres[KeyIdx];
		}
		else {
			m_dwRendThres[ValIdx] = m_dwRendThres[CfgIdx];
		}
	}
	else {
		// ʏ탂[hȂ̂ŁA1Œ
		m_dwRendThres[ValIdx] = 1;
	}
}

#endif	// _WIN32
