//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC XPW[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#if !defined(mfc_sch_h)
#define mfc_sch_h

//===========================================================================
//
//	XPW[
//
//===========================================================================
class CScheduler : public CComponent
{
public:
	// {t@NV
	CScheduler(CFrmWnd *pFrmWnd);
										// RXgN^
	BOOL FASTCALL Init();
										// 
	void FASTCALL Cleanup();
										// N[Abv
	void FASTCALL ApplyCfg(const Config *pConfig);
										// ݒKp
#if defined(_DEBUG)
	void AssertValid() const;
										// ff
#endif	// _DEBUG

	// s
	void FASTCALL Reset();
										// ԂZbg
	void FASTCALL Run();
										// s
	void FASTCALL Stop();
										// XPW[~

	// Z[uE[h
	BOOL FASTCALL Save(Fileio *pFio, int nVer);
										// Z[u
	BOOL FASTCALL Load(Fileio *pFio, int nVer);
										// [h
	BOOL FASTCALL HasSavedEnable() const { return m_bSavedValid; }
										// Z[uEnableԂۑĂ邩
	BOOL FASTCALL GetSavedEnable() const { return m_bSavedEnable; }
										// Z[uEnableԂ
	void FASTCALL SetSavedEnable(BOOL bEnable) { m_bSavedEnable = bEnable; }
										// Z[ȕԂݒ

	// ̑
	void FASTCALL Menu(BOOL bMenu)		{ m_bMenu = bMenu; }
										// j[ʒm
	void FASTCALL Activate(BOOL bAct)	{ m_bActivate = bAct; }
										// ANeBuʒm
	void FASTCALL SyncDisasm();
										// tAZu
	int FASTCALL GetFrameRate();
										// t[[g擾

private:
	// Indexf[^`
	enum {
		CfgIdx = 0,						// Configf[^
		KeyIdx,							// Keyf[^
		ValIdx,							// 
		IdxMax
	};

	// Xbh֐
	static UINT ThreadFunc(LPVOID pParam);
										// Xbh֐

	// Tu֐
	DWORD FASTCALL GetTime()			{ return timeGetTime(); }
										// Ԏ擾
	void FASTCALL Lock()				{ ::LockVM(); }
										// VMbN
	void FASTCALL Unlock()				{ ::UnlockVM(); }
										// VMAbN
	void FASTCALL Refresh();
										// tbV
	void FASTCALL Construct();
										// z񃏁[Nč\z

	// foCXER|[lg
	CPU *m_pCPU;
										// CPU
	Render *m_pRender;
										// _
	CWinThread *m_pThread;
										// Xbh|C^
	CSound *m_pSound;
										// TEh
	CInput *m_pInput;
										// Cvbg

	// [N
	BOOL m_bExitReq;
										// XbhIv
	DWORD m_dwExecTime;
										// ^C}[JEg(s)
	int m_nSubWndNum;
										// TuEBhĚ
	int m_nSubWndDisp;
										// TuEBhE̕\(-1:C)
	DWORD m_dwDrawCount;
										// CEBhE\
	DWORD m_dwDrawPrev;
										// CEBhE\(O)
	DWORD m_dwDrawTime;
										// CEBhE\
	DWORD m_dwDrawBackup;
										// CEBhE\(O)
	BOOL m_bMenu;
										// j[tO
	BOOL m_bActivate;
										// ANeButO
	BOOL m_bBackup;
										// EnabletOobNAbv
	BOOL m_bSavedValid;
										// Z[uEnableԂۑĂ邩
	BOOL m_bSavedEnable;
										// Z[uEnable

	// [N(z)
	BOOL m_bMPUFull[IdxMax];
										// MPUtO
	BOOL m_bVMFull[IdxMax];
										// VMtO
	DWORD m_dwRendThres[IdxMax];
										// _Ol
	BOOL m_bRendRefresh[IdxMax];
										// _OK`
};

#endif	// mfc_sch_h
#endif	// _WIN32
