//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TEh ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "opmif.h"
#include "opm.h"
#include "adpcm.h"
#include "scsi.h"
#include "schedule.h"
#include "config.h"
#include "mfc_frm.h"
#include "mfc_com.h"
#include "mfc_asm.h"
#include "mfc_snd.h"

//===========================================================================
//
//	TEh
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CSound::CSound(CFrmWnd *pWnd) : CComponent(pWnd)
{
	// R|[lgp[^
	m_dwID = MAKEID('S', 'N', 'D', ' ');
	m_strDesc = _T("Sound Renderer");

	// [N(ݒp[^)
	m_uRate = 0;
	m_uTick = 90;
	m_uPoll = 7;
	m_uBufSize = 0;
	m_bPlay = FALSE;
	m_uCount = 0;
	m_dwWrite = 0;
	m_nMaster = 90;
	m_nFMVol = 54;
	m_nADPCMVol = 52;

	// [N(DirectSoundƃIuWFNg)
	m_lpDS = NULL;
	m_lpDSp = NULL;
	m_lpDSb = NULL;
	m_lpBuf = NULL;
	m_pScheduler = NULL;
	m_pOPM = NULL;
	m_pOPMIF = NULL;
	m_pADPCM = NULL;
	m_pSCSI = NULL;
	m_nDeviceNum = 0;
	m_nSelectDevice = 0;

	// [N(WAV^)
	m_pWav = NULL;
	m_nWav = 0;
	m_dwWav = 0;
}

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CSound::Init()
{
	// {NX
	if (!CComponent::Init()) {
		return FALSE;
	}

	// XPW[擾
	m_pScheduler = (Scheduler*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pScheduler);

	// OPMIF擾
	m_pOPMIF = (OPMIF*)::GetVM()->SearchDevice(MAKEID('O', 'P', 'M', ' '));
	ASSERT(m_pOPMIF);

	// ADPCM擾
	m_pADPCM = (ADPCM*)::GetVM()->SearchDevice(MAKEID('A', 'P', 'C', 'M'));
	ASSERT(m_pADPCM);

	// SCSI擾
	m_pSCSI = (SCSI*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'S', 'I'));
	ASSERT(m_pSCSI);

	// foCX
	EnumDevice();

	// ł͏Ȃ(ApplyCfgɔC)
	return TRUE;
}

//---------------------------------------------------------------------------
//
//	Tu
//
//---------------------------------------------------------------------------
BOOL FASTCALL CSound::InitSub()
{
	PCMWAVEFORMAT pcmwf;
	DSBUFFERDESC dsbd;
	WAVEFORMATEX wfex;

	// rate==0ȂAȂ
	if (m_uRate == 0) {
		return TRUE;
	}

	ASSERT(!m_lpDS);
	ASSERT(!m_lpDSp);
	ASSERT(!m_lpDSb);
	ASSERT(!m_lpBuf);
	ASSERT(!m_pOPM);

	// foCXȂ0ŎAłȂreturn
	if (m_nDeviceNum <= m_nSelectDevice) {
		if (m_nDeviceNum == 0) {
			return TRUE;
		}
		m_nSelectDevice = 0;
	}

	// DiectSoundIuWFNg쐬
	if (FAILED(DirectSoundCreate(m_lpGUID[m_nSelectDevice], &m_lpDS, NULL))) {
		// foCX͎gp
		return TRUE;
	}

	// xݒ(D拦)
	if (FAILED(m_lpDS->SetCooperativeLevel(m_pFrmWnd->m_hWnd, DSSCL_PRIORITY))) {
		return FALSE;
	}

	// vC}obt@쐬
	memset(&dsbd, 0, sizeof(dsbd));
	dsbd.dwSize = sizeof(dsbd);
	dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER;
	if (FAILED(m_lpDS->CreateSoundBuffer(&dsbd, &m_lpDSp, NULL))) {
		return FALSE;
	}

	// vC}obt@̃tH[}bgw
	memset(&wfex, 0, sizeof(wfex));
	wfex.wFormatTag = WAVE_FORMAT_PCM;
	wfex.nChannels = 2;
	wfex.nSamplesPerSec = m_uRate;
	wfex.nBlockAlign = 4;
	wfex.nAvgBytesPerSec = wfex.nSamplesPerSec * wfex.nBlockAlign;
	wfex.wBitsPerSample = 16;
	if (FAILED(m_lpDSp->SetFormat(&wfex))) {
		return FALSE;
	}

	// ZJ_obt@쐬
	memset(&pcmwf, 0, sizeof(pcmwf));
	pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;
	pcmwf.wf.nChannels = 2;
	pcmwf.wf.nSamplesPerSec = m_uRate;
	pcmwf.wf.nBlockAlign = 4;
	pcmwf.wf.nAvgBytesPerSec = pcmwf.wf.nSamplesPerSec * pcmwf.wf.nBlockAlign;
	pcmwf.wBitsPerSample = 16;
	memset(&dsbd, 0, sizeof(dsbd));
	dsbd.dwSize = sizeof(dsbd);
	dsbd.dwFlags = DSBCAPS_STICKYFOCUS | DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_CTRLVOLUME;
	dsbd.dwBufferBytes = (pcmwf.wf.nAvgBytesPerSec * m_uTick) / 1000;
	dsbd.dwBufferBytes = ((dsbd.dwBufferBytes + 7) >> 3) << 3;	// 8oCgE
	m_uBufSize = dsbd.dwBufferBytes;
	dsbd.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;
	if (FAILED(m_lpDS->CreateSoundBuffer(&dsbd, &m_lpDSb, NULL))) {
		return FALSE;
	}

	// TEhobt@쐬(ZJ_obt@Ɠ̒A1PDWORD)
	try {
		m_lpBuf = new DWORD [ m_uBufSize / 2 ];
	}
	catch (...) {
		return FALSE;
	}
	if (!m_lpBuf) {
		return FALSE;
	}
	memset(m_lpBuf, sizeof(DWORD) * (m_uBufSize / 2), m_uBufSize);

	// OPMfoCX(W)쐬
	m_pOPM = new FM::OPM;
	m_pOPM->Init(4000000, m_uRate, true);
	m_pOPM->Reset();
	m_pOPM->SetVolume(m_nFMVol);

	// OPMIF֒ʒm
	m_pOPMIF->InitBuf(m_uRate);
	m_pOPMIF->SetEngine(m_pOPM);

	// Cl[uȂ牉tJn
	if (m_bEnable) {
		Play();
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	N[Abv
//
//---------------------------------------------------------------------------
void FASTCALL CSound::Cleanup()
{
	// N[AbvTu
	CleanupSub();

	// {NX
	CComponent::Cleanup();
}

//---------------------------------------------------------------------------
//
//	N[AbvTu
//
//---------------------------------------------------------------------------
void FASTCALL CSound::CleanupSub()
{
	// TEh~
	Stop();

	// OPMIF֒ʒm
	if (m_pOPMIF) {
		m_pOPMIF->SetEngine(NULL);
	}

	// OPM
	if (m_pOPM) {
		delete m_pOPM;
		m_pOPM = NULL;
	}

	// TEh쐬obt@
	if (m_lpBuf) {
		delete[] m_lpBuf;
		m_lpBuf = NULL;
	}

	// DirectSoundBuffer
	if (m_lpDSb) {
		m_lpDSb->Release();
		m_lpDSb = NULL;
	}
	if (m_lpDSp) {
		m_lpDSp->Release();
		m_lpDSp = NULL;
	}

	// DirectSound
	if (m_lpDS) {
		m_lpDS->Release();
		m_lpDS = NULL;
	}

	// uRateNA
	m_uRate = 0;
}

//---------------------------------------------------------------------------
//
//	ݒKp
//
//---------------------------------------------------------------------------
void FASTCALL CSound::ApplyCfg(const Config *pConfig)
{
	BOOL bFlag;

	ASSERT(this);
	ASSERT(pConfig);

	// ď`FbN
	bFlag = FALSE;
	if (m_nSelectDevice != pConfig->sound_device) {
		bFlag = TRUE;
	}
	if (m_uRate != RateTable[pConfig->sample_rate]) {
		bFlag = TRUE;
	}
	if (m_uTick != (UINT)(pConfig->primary_buffer * 10)) {
		bFlag = TRUE;
	}

	// ď
	if (bFlag) {
		CleanupSub();
		m_nSelectDevice = pConfig->sound_device;
		m_uRate = RateTable[pConfig->sample_rate];
		m_uTick = pConfig->primary_buffer * 10;

		// 62.5kHz̏ꍇ́Ax96kHzɃZbgĂ(Prodigy7.1΍)
		if (m_uRate == 62500) {
			// 96kHzŏ
			m_uRate = 96000;
			InitSub();

			// łꍇ́At
			if (m_lpDSb) {
				// X^[g
				if (!m_bEnable) {
					m_lpDSb->Play(0, 0, DSBPLAY_LOOPING);
				}

				// 
				::Sleep(20);

				// ~߂
				if (!m_bEnable) {
					m_lpDSb->Stop();
				}
			}

			// 62.5kHzŏ
			CleanupSub();
			m_uRate = 62500;
		}
		InitSub();
	}

	// ɐݒ
	if (m_pOPM) {
		SetVolume(pConfig->master_volume);
		m_pOPMIF->EnableFM(pConfig->fm_enable);
		SetFMVol(pConfig->fm_volume);
		m_pADPCM->EnableADPCM(pConfig->adpcm_enable);
		SetADPCMVol(pConfig->adpcm_volume);
	}
	m_nMaster = pConfig->master_volume;
	m_uPoll = (UINT)pConfig->polling_buffer;
}

//---------------------------------------------------------------------------
//
//	TvO[ge[u
//
//---------------------------------------------------------------------------
const UINT CSound::RateTable[] = {
	0,
	44100,
	48000,
	88200,
	96000,
	62500
};

//---------------------------------------------------------------------------
//
//	LtOݒ
//
//---------------------------------------------------------------------------
void FASTCALL CSound::Enable(BOOL bEnable)
{
	if (bEnable) {
		// L tJn
		if (!m_bEnable) {
			m_bEnable = TRUE;
			Play();
		}
	}
	else {
		// L t~
		if (m_bEnable) {
			m_bEnable = FALSE;
			Stop();
		}
	}
}

//---------------------------------------------------------------------------
//
//	tJn
//
//---------------------------------------------------------------------------
void FASTCALL CSound::Play()
{
	ASSERT(m_bEnable);

	// ɉtJnȂKvȂ
	if (m_bPlay) {
		return;
	}

	// |C^LȂ牉tJn
	if (m_pOPM) {
		m_lpDSb->Play(0, 0, DSBPLAY_LOOPING);
		m_bPlay = TRUE;
		m_uCount = 0;
		m_dwWrite = 0;
	}
}

//---------------------------------------------------------------------------
//
//	t~
//
//---------------------------------------------------------------------------
void FASTCALL CSound::Stop()
{
	// ɉt~ȂKvȂ
	if (!m_bPlay) {
		return;
	}

	// WAVZ[uI
	if (m_pWav) {
		EndSaveWav();
	}

	// |C^LȂ牉t~
	if (m_pOPM) {
		m_lpDSb->Stop();
		m_bPlay = FALSE;
	}
}

//---------------------------------------------------------------------------
//
//	is
//
//---------------------------------------------------------------------------
void FASTCALL CSound::Process(BOOL bRun)
{
	HRESULT hr;
	DWORD dwOffset;
	DWORD dwWrite;
	DWORD dwRequest;
	DWORD dwReady;
	WORD *pBuf1;
	WORD *pBuf2;
	DWORD dwSize1;
	DWORD dwSize2;

	ASSERT(this);

	// JEg(m_nPollɂPAVM~͏펞)
	m_uCount++;
	if ((m_uCount < m_uPoll) && bRun) {
		return;
	}
	m_uCount = 0;

	// fBZ[uȂAȂ
	if (!m_bEnable) {
		return;
	}

	// ĂȂ΁AȂ
	if (!m_pOPM) {
		m_pScheduler->SetSoundTime(0);
		return;
	}

	// vCԂłȂ΁A֌WȂ
	if (!m_bPlay) {
		m_pScheduler->SetSoundTime(0);
		return;
	}

	// ݂̃vCʒu𓾂(oCgP)
	ASSERT(m_lpDSb);
	ASSERT(m_lpBuf);
	if (FAILED(m_lpDSb->GetCurrentPosition(&dwOffset, &dwWrite))) {
		return;
	}
	ASSERT(m_lpDSb);
	ASSERT(m_lpBuf);

	// O񏑂񂾈ʒuA󂫃TCYvZ(oCgP)
	if (m_dwWrite <= dwOffset) {
		dwRequest = dwOffset - m_dwWrite;
	}
	else {
		dwRequest = m_uBufSize - m_dwWrite;
		dwRequest += dwOffset;
	}

	// 󂫃TCYŜ1/4𒴂ĂȂ΁A̋@
	if (dwRequest < (m_uBufSize / 4)) {
		return;
	}

	// 󂫃TvɊZ(L,R1Ɛ)
	ASSERT((dwRequest & 3) == 0);
	dwRequest /= 4;

	// m_lpBufɃobt@f[^쐬B܂bRun`FbN
	if (!bRun) {
		memset(m_lpBuf, 0, m_uBufSize * 2);
		m_pOPMIF->InitBuf(m_uRate);
	}
	else {
		// OPMɑ΂āAvƑx
		dwReady = m_pOPMIF->ProcessBuf();
		m_pOPMIF->GetBuf(m_lpBuf, (int)dwRequest);
		if (dwReady < dwRequest) {
			dwRequest = dwReady;
		}

		// ADPCMɑ΂āAf[^v(Z邱)
		m_pADPCM->GetBuf(m_lpBuf, (int)dwRequest);

		// ADPCM̓
		if (dwReady > dwRequest) {
			m_pADPCM->Wait(dwReady - dwRequest);
		}
		else {
			m_pADPCM->Wait(0);
		}

		// SCSIɑ΂āAf[^v(Z邱)
		m_pSCSI->GetBuf(m_lpBuf, (int)dwRequest, m_uRate);
	}

	// ŃbN
	hr = m_lpDSb->Lock(m_dwWrite, (dwRequest * 4),
						(void**)&pBuf1, &dwSize1,
						(void**)&pBuf2, &dwSize2,
						0);
	// obt@Ă΁AXgA
	if (hr == DSERR_BUFFERLOST) {
		m_lpDSb->Restore();
	}
	// bNȂ΁AĂӖȂ
	if (FAILED(hr)) {
		m_dwWrite = dwOffset;
		return;
	}

	// ʎqbit=16OƂ
	ASSERT((dwSize1 & 1) == 0);
	ASSERT((dwSize2 & 1) == 0);

	// MMX߂ɂpbN(dwSize1+dwSize2ŁA5000`15000x͏)
	SoundMMX(m_lpBuf, pBuf1, dwSize1);
	if (dwSize2 > 0) {
		SoundMMX(&m_lpBuf[dwSize1 / 2], pBuf2, dwSize2);
	}
	SoundEMMS();

	// AbN
	m_lpDSb->Unlock(pBuf1, dwSize1, pBuf2, dwSize2);

	// m_dwWriteXV
	m_dwWrite += dwSize1;
	m_dwWrite += dwSize2;
	if (m_dwWrite >= m_uBufSize) {
		m_dwWrite -= m_uBufSize;
	}
	ASSERT(m_dwWrite < m_uBufSize);

	// 쒆ȂWAVXV
	if (bRun && m_pWav) {
		ProcessSaveWav((int*)m_lpBuf, (dwSize1 + dwSize2));
	}
}

//---------------------------------------------------------------------------
//
//	ʃZbg
//
//---------------------------------------------------------------------------
void FASTCALL CSound::SetVolume(int nVolume)
{
	LONG lVolume;

	ASSERT(this);
	ASSERT((nVolume >= 0) && (nVolume <= 100));

	// ĂȂΐݒ肵Ȃ
	if (!m_pOPM) {
		return;
	}

	// lϊ
	lVolume = 100 - nVolume;
	lVolume *= (DSBVOLUME_MAX - DSBVOLUME_MIN);
	lVolume /= -200;

	// ݒ
	m_lpDSb->SetVolume(lVolume);
}

//---------------------------------------------------------------------------
//
//	ʎ擾
//
//---------------------------------------------------------------------------
int FASTCALL CSound::GetVolume()
{
	LONG lVolume;

	ASSERT(this);

	// ĂȂ΁A̒l󂯎
	if (!m_pOPM) {
		return m_nMaster;
	}

	// l擾
	ASSERT(m_lpDSb);
	if (FAILED(m_lpDSb->GetVolume(&lVolume))) {
		return 0;
	}

	// l␳
	lVolume *= -200;
	lVolume /= (DSBVOLUME_MAX - DSBVOLUME_MIN);
	ASSERT((lVolume >= 0) && (lVolume <= 200));
	if (lVolume >= 100) {
		lVolume = 0;
	}
	else {
		lVolume = 100 - lVolume;
	}

	return (int)lVolume;
}

//---------------------------------------------------------------------------
//
//	FMʃZbg
//
//---------------------------------------------------------------------------
void FASTCALL CSound::SetFMVol(int nVol)
{
	ASSERT(this);
	ASSERT((nVol >= 0) && (nVol <= 100));

	// Rs[
	m_nFMVol = nVol;

	// ݒ
	if (m_pOPM) {
		m_pOPM->SetVolume(m_nFMVol);
	}
}

//---------------------------------------------------------------------------
//
//	ADPCMʃZbg
//
//---------------------------------------------------------------------------
void FASTCALL CSound::SetADPCMVol(int nVol)
{
	ASSERT(this);
	ASSERT((nVol >= 0) && (nVol <= 100));

	// Rs[
	m_nADPCMVol = nVol;

	// ݒ
	ASSERT(m_pADPCM);
	m_pADPCM->SetVolume(m_nADPCMVol);
}

//---------------------------------------------------------------------------
//
//	foCX
//
//---------------------------------------------------------------------------
void FASTCALL CSound::EnumDevice()
{
	// 
	m_nDeviceNum = 0;

	// 񋓊Jn
	DirectSoundEnumerate(EnumCallback, this);
}

//---------------------------------------------------------------------------
//
//	foCX񋓃R[obN
//
//---------------------------------------------------------------------------
BOOL CALLBACK CSound::EnumCallback(LPGUID lpGuid, LPCTSTR lpDescr, LPCTSTR /*lpModule*/, LPVOID lpContext)
{
	CSound *pSound;
	int index;

	// this|C^󂯎
	pSound = (CSound*)lpContext;
	ASSERT(pSound);

	// Jg16ȂL
	if (pSound->m_nDeviceNum < 16) {
		index = pSound->m_nDeviceNum;

		// o^
		pSound->m_lpGUID[index] = lpGuid;
		pSound->m_DeviceDescr[index] = lpDescr;
		pSound->m_nDeviceNum++;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	}X^ʎ擾
//
//---------------------------------------------------------------------------
int FASTCALL CSound::GetMasterVol(int& nMaximum)
{
	MMRESULT mmResult;
	HMIXER hMixer;
	MIXERLINE mixLine;
	MIXERLINECONTROLS mixLCs;
	MIXERCONTROL mixCtrl;
	MIXERCONTROLDETAILS mixDetail;
	MIXERCONTROLDETAILS_UNSIGNED *pData;
	int nNum;
	int nValue;

	ASSERT(this);

	// gpĂfoCXԍ0ł邱ƂKv
	if ((m_nSelectDevice != 0) || (m_uRate == 0)) {
		return -1;
	}

	// ~LTI[v
	mmResult = ::mixerOpen(&hMixer, 0, 0, 0,
					MIXER_OBJECTF_MIXER);
	if (mmResult != MMSYSERR_NOERROR) {
		// ~LTI[vG[
		return -1;
	}

	// C𓾂
	memset(&mixLine, 0, sizeof(mixLine));
	mixLine.cbStruct = sizeof(mixLine);
	mixLine.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;
	mmResult = ::mixerGetLineInfo((HMIXEROBJ)hMixer, &mixLine,
					MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE);
	if (mmResult != MMSYSERR_NOERROR) {
		// N[YďI
		::mixerClose(hMixer);
		return -1;
	}

	// Rg[𓾂
	memset(&mixLCs, 0, sizeof(mixLCs));
	mixLCs.cbStruct = sizeof(mixLCs);
	mixLCs.dwLineID = mixLine.dwLineID;
	mixLCs.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
	mixLCs.cbmxctrl = sizeof(mixCtrl);
	mixLCs.pamxctrl = &mixCtrl;
	memset(&mixCtrl, 0, sizeof(mixCtrl));
	mixCtrl.cbStruct = sizeof(mixCtrl);
	mmResult = ::mixerGetLineControls((HMIXEROBJ)hMixer, &mixLCs,
					MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE);
	if (mmResult != MMSYSERR_NOERROR) {
		// N[YďI
		::mixerClose(hMixer);
		return -1;
	}

	// Rg[̌āAm
	nNum = 1;
	if (mixLine.cChannels > 0) {
		nNum *= mixLine.cChannels;
	}
	if (mixCtrl.cMultipleItems > 0) {
		nNum *= mixCtrl.cMultipleItems;
	}
	pData = new MIXERCONTROLDETAILS_UNSIGNED[nNum];

	// Rg[̒l𓾂
	memset(&mixDetail, 0, sizeof(mixDetail));
	mixDetail.cbStruct = sizeof(mixDetail);
	mixDetail.dwControlID = mixCtrl.dwControlID;
	mixDetail.cChannels = mixLine.cChannels;
	mixDetail.cMultipleItems = mixCtrl.cMultipleItems;
	mixDetail.cbDetails = nNum * sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mixDetail.paDetails = pData;
	mmResult = ::mixerGetControlDetails((HMIXEROBJ)hMixer, &mixDetail,
					MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE);
	if (mmResult != MMSYSERR_NOERROR) {
		// N[YďI
		delete[] pData;
		::mixerClose(hMixer);
		return -1;
	}

	// ŏl0̏ꍇ̂
	if (mixCtrl.Bounds.lMinimum != 0) {
		// N[YďI
		delete[] pData;
		::mixerClose(hMixer);
		return -1;
	}

	// l
	nValue = pData[0].dwValue;
	nMaximum = mixCtrl.Bounds.lMaximum;

	// 
	delete[] pData;
	::mixerClose(hMixer);

	return nValue;
}

//---------------------------------------------------------------------------
//
//	}X^ʃZbg
//
//---------------------------------------------------------------------------
void FASTCALL CSound::SetMasterVol(int nVolume)
{
	MMRESULT mmResult;
	HMIXER hMixer;
	MIXERLINE mixLine;
	MIXERLINECONTROLS mixLCs;
	MIXERCONTROL mixCtrl;
	MIXERCONTROLDETAILS mixDetail;
	MIXERCONTROLDETAILS_UNSIGNED *pData;
	int nIndex;
	int nNum;

	ASSERT(this);

	// gpĂfoCXԍ0ł邱ƂKv
	if ((m_nSelectDevice != 0) || (m_uRate == 0)) {
		return;
	}

	// ~LTI[v
	mmResult = ::mixerOpen(&hMixer, 0, 0, 0,
					MIXER_OBJECTF_MIXER);
	if (mmResult != MMSYSERR_NOERROR) {
		// ~LTI[vG[
		return;
	}

	// C𓾂
	memset(&mixLine, 0, sizeof(mixLine));
	mixLine.cbStruct = sizeof(mixLine);
	mixLine.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;
	mmResult = ::mixerGetLineInfo((HMIXEROBJ)hMixer, &mixLine,
					MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE);
	if (mmResult != MMSYSERR_NOERROR) {
		// N[YďI
		::mixerClose(hMixer);
		return;
	}

	// Rg[𓾂
	memset(&mixLCs, 0, sizeof(mixLCs));
	mixLCs.cbStruct = sizeof(mixLCs);
	mixLCs.dwLineID = mixLine.dwLineID;
	mixLCs.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
	mixLCs.cbmxctrl = sizeof(mixCtrl);
	mixLCs.pamxctrl = &mixCtrl;
	memset(&mixCtrl, 0, sizeof(mixCtrl));
	mixCtrl.cbStruct = sizeof(mixCtrl);
	mmResult = ::mixerGetLineControls((HMIXEROBJ)hMixer, &mixLCs,
					MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE);
	if (mmResult != MMSYSERR_NOERROR) {
		// N[YďI
		::mixerClose(hMixer);
		return;
	}

	// Rg[̌āAm
	nNum = 1;
	if (mixLine.cChannels > 0) {
		nNum *= mixLine.cChannels;
	}
	if (mixCtrl.cMultipleItems > 0) {
		nNum *= mixCtrl.cMultipleItems;
	}
	pData = new MIXERCONTROLDETAILS_UNSIGNED[nNum];

	// Rg[̒l𓾂
	memset(&mixDetail, 0, sizeof(mixDetail));
	mixDetail.cbStruct = sizeof(mixDetail);
	mixDetail.dwControlID = mixCtrl.dwControlID;
	mixDetail.cChannels = mixLine.cChannels;
	mixDetail.cMultipleItems = mixCtrl.cMultipleItems;
	mixDetail.cbDetails = nNum * sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mixDetail.paDetails = pData;
	mmResult = ::mixerGetControlDetails((HMIXEROBJ)hMixer, &mixDetail,
					MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE);
	if (mmResult != MMSYSERR_NOERROR) {
		// N[YďI
		delete[] pData;
		::mixerClose(hMixer);
		return;
	}

	// l
	ASSERT(mixCtrl.Bounds.lMinimum <= nVolume);
	ASSERT(nVolume <= mixCtrl.Bounds.lMaximum);
	for (nIndex=0; nIndex<nNum; nIndex++) {
		pData[nIndex].dwValue = (DWORD)nVolume;
	}

	// Rg[̒lݒ
	mmResult = mixerSetControlDetails((HMIXEROBJ)hMixer, &mixDetail,
					MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE);
	if (mmResult != MMSYSERR_NOERROR) {
		delete[] pData;
		::mixerClose(hMixer);
		return;
	}

	// 
	::mixerClose(hMixer);
	delete[] pData;
}

//---------------------------------------------------------------------------
//
//	WAVZ[uJn
//
//---------------------------------------------------------------------------
BOOL FASTCALL CSound::StartSaveWav(LPCTSTR lpszWavFile)
{
	DWORD dwSize;
	WAVEFORMATEX wfex;

	ASSERT(this);
	ASSERT(lpszWavFile);

	// ɘ^ȂG[
	if (m_pWav) {
		return FALSE;
	}
	// ĐłȂ΃G[
	if (!m_bEnable || !m_bPlay) {
		return FALSE;
	}

	// t@C쐬݂
	if (!m_WavFile.Open(lpszWavFile, Fileio::WriteOnly)) {
		return FALSE;
	}

	// RIFFwb_
	if (!m_WavFile.Write((BYTE*)"RIFF0123WAVEfmt ", 16)) {
		m_WavFile.Close();
		return FALSE;
	}

	// WAVEFORMATEX
	dwSize = sizeof(wfex);
	if (!m_WavFile.Write((BYTE*)&dwSize, sizeof(dwSize))) {
		m_WavFile.Close();
		return FALSE;
	}
	memset(&wfex, 0, sizeof(wfex));
	wfex.cbSize = sizeof(wfex);
	wfex.wFormatTag = WAVE_FORMAT_PCM;
	wfex.nChannels = 2;
	wfex.nSamplesPerSec = m_uRate;
	wfex.nBlockAlign = 4;
	wfex.nAvgBytesPerSec = wfex.nSamplesPerSec * wfex.nBlockAlign;
	wfex.wBitsPerSample = 16;
	if (!m_WavFile.Write((BYTE*)&wfex, sizeof(wfex))) {
		m_WavFile.Close();
		return FALSE;
	}

	// dataTuwb_
	if (!m_WavFile.Write((BYTE*)"data0123", 8)) {
		m_WavFile.Close();
		return FALSE;
	}

	// ^obt@m
	try {
		m_pWav = new WORD[0x20000];
	}
	catch (...) {
		return FALSE;
	}
	if (!m_pWav) {
		return FALSE;
	}

	// [N
	m_nWav = 0;
	m_dwWav = 0;

	// R|[lg̃tONA
	m_pOPMIF->ClrStarted();
	m_pADPCM->ClrStarted();

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	WAVZ[u
//
//---------------------------------------------------------------------------
BOOL FASTCALL CSound::IsSaveWav() const
{
	ASSERT(this);

	// obt@Ń`FbN
	if (m_pWav) {
		return TRUE;
	}

	return FALSE;
}

//---------------------------------------------------------------------------
//
//	WAVZ[u
//
//---------------------------------------------------------------------------
void FASTCALL CSound::ProcessSaveWav(int *pStream, DWORD dwLength)
{
	DWORD dwPrev;
	int i;
	int nLen;
	int rawData;

	ASSERT(this);
	ASSERT(pStream);
	ASSERT(dwLength > 0);
	ASSERT((dwLength & 3) == 0);

	// StartedtO𒲂ׁAƂɃNAȂXLbv
	if (!m_pOPMIF->IsStarted() && !m_pADPCM->IsStarted()) {
		return;
	}

	// OE㔼ɕKv邩`FbN
	dwPrev = 0;
	if ((dwLength + m_nWav) >= 256 * 1024) {
		dwPrev = 256 * 1024 - m_nWav;
		dwLength -= dwPrev;
	}

	// O
	if (dwPrev > 0) {
		nLen = (int)(dwPrev >> 1);
		for (i=0; i<nLen; i++) {
			rawData = *pStream++;
			if (rawData > 0x7fff) {
				rawData = 0x7fff;
			}
			if (rawData < -0x8000) {
				rawData = -0x8000;
			}
			m_pWav[(m_nWav >> 1) + i] = (WORD)rawData;
		}

		m_WavFile.Write(m_pWav, 256 * 1024);
		m_nWav = 0;
	}

	// 㔼
	nLen = (int)(dwLength >> 1);
	for (i=0; i<nLen; i++) {
		rawData = *pStream++;
		if (rawData > 0x7fff) {
			rawData = 0x7fff;
		}
		if (rawData < -0x8000) {
			rawData = -0x8000;
		}
		m_pWav[(m_nWav >> 1) + i] = (WORD)rawData;
	}
	m_nWav += dwLength;
	m_dwWav += dwPrev;
	m_dwWav += dwLength;
}

//---------------------------------------------------------------------------
//
//	WAVZ[uI
//
//---------------------------------------------------------------------------
void FASTCALL CSound::EndSaveWav()
{
	DWORD dwLength;

	// cf[^
	if (m_nWav > 0) {
		m_WavFile.Write(m_pWav, m_nWav);
		m_nWav = 0;
	}

	// wb_C
	m_WavFile.Seek(4);
	dwLength = m_dwWav + sizeof(WAVEFORMATEX) + 20;
	m_WavFile.Write((BYTE*)&dwLength, sizeof(dwLength));
	m_WavFile.Seek(sizeof(WAVEFORMATEX) + 24);
	m_WavFile.Write((BYTE*)&m_dwWav, sizeof(m_dwWav));

	// t@CN[Y
	m_WavFile.Close();

	// 
	delete[] m_pWav;
	m_pWav = NULL;
}

#endif	// _WIN32
