//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC Xe[^Xr[ ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "vm.h"
#include "render.h"
#include "mfc_frm.h"
#include "mfc_res.h"
#include "mfc_draw.h"
#include "mfc_info.h"
#include "mfc_stat.h"

//===========================================================================
//
//	Xe[^Xr[
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CStatusView::CStatusView()
{
	int i;

	// t[EBhE
	m_pFrmWnd = NULL;

	// bZ[W
	m_strCaption.Empty();
	::GetMsg(AFX_IDS_IDLEMESSAGE, m_strIdle);
	m_strMenu = m_strIdle;
	m_strInfo.Empty();

	// FDD`
	for (i=0; i<2; i++) {
		m_rectFDD[i].left = 0;
		m_rectFDD[i].top = 0;
		m_rectFDD[i].right = 0;
		m_rectFDD[i].bottom = 0;
	}

	// LED`
	for (i=0; i<3; i++) {
		m_rectLED[i].left = 0;
		m_rectLED[i].top = 0;
		m_rectLED[i].right = 0;
		m_rectLED[i].bottom = 0;
	}
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CStatusView, CWnd)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_MOVE()
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	
//
//---------------------------------------------------------------------------
BOOL FASTCALL CStatusView::Init(CFrmWnd *pFrmWnd)
{
	CRect rectParent;

	ASSERT(this);
	ASSERT(pFrmWnd);

	// t[EBhEL
	m_pFrmWnd = pFrmWnd;

	// t[EBhE̋`擾
	pFrmWnd->GetClientRect(&rectParent);

	// t[EBhÊ̕܂܁A20̋`
	m_rectClient.left = 0;
	m_rectClient.top = 0;
	m_rectClient.right = rectParent.Width();
	m_rectClient.bottom = 20;

	// 쐬
	if (!Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
				m_rectClient, pFrmWnd, IDM_FULLSCREEN, NULL)) {
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhEĕ`
//
//---------------------------------------------------------------------------
void CStatusView::OnPaint()
{
	CPaintDC dc(this);
	CInfo *pInfo;
	int i;

	// ŏȂ牽Ȃ
	if (IsIconic()) {
		return;
	}

	// bZ[W
	DrawMessage(&dc);

	// Xe[^X
	pInfo = m_pFrmWnd->GetInfo();
	if (pInfo) {
		// InfoɔC
		for (i=0; i<2; i++) {
			// FDD
			if (m_rectFDD[i].Width() > 0) {
				pInfo->DrawStatus(i, dc.m_hDC, m_rectFDD[i]);
			}
		}
		for (i=0; i<3; i++) {
			// LED
			if (m_rectLED[i].Width() > 0) {
				pInfo->DrawStatus(i + 2, dc.m_hDC, m_rectLED[i]);
			}
		}
	}
}

//---------------------------------------------------------------------------
//
//	EBhEwi`
//
//---------------------------------------------------------------------------
BOOL CStatusView::OnEraseBkgnd(CDC *pDC)
{
	// ۏ؂
	pDC->FillSolidRect(&m_rectClient, RGB(0, 0, 0));

	return TRUE;
}

//---------------------------------------------------------------------------
//
//	EBhETCYύX
//
//---------------------------------------------------------------------------
void CStatusView::OnSize(UINT nType, int cx, int cy)
{
	CClientDC *pDC;
	TEXTMETRIC tm;
	HFONT hFont;
	HFONT hDefFont;
	int i;
	int nRest;

	// ŏȂNCAg`ŏ
	if ((cx == 0) || (cy == 0)) {
		m_rectClient.right = 0;
		m_rectClient.bottom = 0;
		return;
	}

	// NCAg`L
	m_rectClient.right = cx;
	m_rectClient.bottom = cy;

	// eLXggbN擾
	pDC = new CClientDC(this);
	hFont = (HFONT)::GetStockObject(DEFAULT_GUI_FONT);
	hDefFont = (HFONT)::SelectObject(pDC->m_hDC, hFont);
	ASSERT(hDefFont);
	pDC->GetTextMetrics(&tm);
	::SelectObject(pDC->m_hDC, hDefFont);
	delete pDC;

	// eLXggbNL
	m_tmWidth = tm.tmAveCharWidth;
	m_tmHeight = tm.tmHeight + tm.tmExternalLeading;

	// eLXgɑ΂ANCAg`̏㉺̗]ʂ߂
	nRest = cy - m_tmHeight;

	// LED`߂
	for (i=0; i<3; i++) {
		m_rectLED[i].top = nRest >> 2;
		m_rectLED[i].bottom = cy - (nRest >> 2);

		// X̃TCYݒ
		switch (i) {
			// HD BUSY
			case 0:
				m_rectLED[i].left = cx - m_tmWidth * 31;
				m_rectLED[i].right = m_rectLED[i].left;
				m_rectLED[i].right += m_tmWidth * 11;
				break;
			// TIMER
			case 1:
				m_rectLED[i].left = cx - m_tmWidth * 19;
				m_rectLED[i].right = m_rectLED[i].left;
				m_rectLED[i].right += m_tmWidth * 9;
				break;
			// POWER
			case 2:
				m_rectLED[i].left = cx - m_tmWidth * 9;
				m_rectLED[i].right = m_rectLED[i].left;
				m_rectLED[i].right += m_tmWidth * 9;
				break;
			// ̑(肦Ȃ)
			default:
				ASSERT(FALSE);
				break;
		}
	}

	// FDD`߂
	m_rectFDD[0].left = cx * 4 / 10;
	m_rectFDD[0].right = m_rectLED[0].left - m_tmWidth;
	m_rectFDD[1].left = m_rectFDD[0].left + m_rectFDD[0].Width() / 2;
	m_rectFDD[1].right = m_rectFDD[0].right;
	m_rectFDD[0].right = m_rectFDD[1].left - m_tmWidth / 2;
	m_rectFDD[1].left += m_tmWidth / 2;
	for (i=0; i<2; i++) {
		m_rectFDD[i].top = nRest >> 2;
		m_rectFDD[i].bottom = cy - (nRest >> 2);
	}

	// ĕ`𑣂
	Invalidate(FALSE);

	// {NX
	CWnd::OnSize(nType, cx, cy);
}

//---------------------------------------------------------------------------
//
//	EBhEړ
//
//---------------------------------------------------------------------------
void CStatusView::OnMove(int x, int y)
{
	ASSERT(m_pFrmWnd);

	// {NX
	CWnd::OnMove(x, y);

	// t[EBhE̍Ĕzu
	m_pFrmWnd->RecalcStatusView();
}

//---------------------------------------------------------------------------
//
//	EBhE폜
//
//---------------------------------------------------------------------------
void CStatusView::PostNcDestroy()
{
	// C^tF[Xvf폜
	delete this;
}

//---------------------------------------------------------------------------
//
//	LvV
//
//---------------------------------------------------------------------------
void FASTCALL CStatusView::SetCaptionString(CString& strCap)
{
	CClientDC dc(this);

	ASSERT(this);

	// vĂAȂ
	if (m_strCaption == strCap) {
		return;
	}

	// Lĕ\
	m_strCaption = strCap;
	DrawMessage(&dc);
}

//---------------------------------------------------------------------------
//
//	j[
//
//---------------------------------------------------------------------------
void FASTCALL CStatusView::SetMenuString(CString& strMenu)
{
	CClientDC dc(this);

	ASSERT(this);

	// Lĕ\
	m_strMenu = strMenu;
	DrawMessage(&dc);
}

//---------------------------------------------------------------------------
//
//	񕶎
//
//---------------------------------------------------------------------------
void FASTCALL CStatusView::SetInfoString(CString& strInfo)
{
	CClientDC dc(this);

	ASSERT(this);

	// Lĕ\
	m_strInfo = strInfo;
	DrawMessage(&dc);
}

//---------------------------------------------------------------------------
//
//	bZ[W`
//
//---------------------------------------------------------------------------
void FASTCALL CStatusView::DrawMessage(CDC *pDC) const
{
	CString strMsg;
	CBitmap Bitmap;
	CBitmap *pBitmap;
	CDC mDC;
	HFONT hFont;
	HFONT hDefFont;
	CRect rectDraw;

	ASSERT(pDC);

	// ŏȂ牽Ȃ
	if ((m_rectClient.Width() == 0) || (m_rectClient.Height() == 0)) {
		return;
	}

	// \񌈒(MenuōAInfo̎ACapŒ)
	strMsg = m_strMenu;
	if (strMsg == m_strIdle) {
		if (m_strInfo.GetLength() > 0) {
			strMsg = m_strInfo;
		}
		else {
			strMsg = m_strCaption;
		}
	}

	// `(40%)
	rectDraw.left = 0;
	rectDraw.top = 0;
	rectDraw.right = m_rectClient.right * 4 / 10;
	rectDraw.bottom = m_rectClient.bottom;

	// DCƁÃrbg}bv쐬
	VERIFY(mDC.CreateCompatibleDC(pDC));
	VERIFY(Bitmap.CreateCompatibleBitmap(pDC, rectDraw.right, rectDraw.bottom));
	pBitmap = mDC.SelectObject(&Bitmap);
	ASSERT(pBitmap);

	// tHgZNg
	hFont = (HFONT)::GetStockObject(DEFAULT_GUI_FONT);
	hDefFont = (HFONT)::SelectObject(mDC.m_hDC, hFont);
	ASSERT(hDefFont);

	// ŃNAAFݒ
	mDC.SetTextColor(RGB(255, 255, 255));
	mDC.FillSolidRect(&rectDraw, RGB(0, 0, 0));

	// DrawTextŕ`
	rectDraw.left = 16;
	mDC.DrawText(strMsg, &rectDraw, DT_LEFT | DT_VCENTER | DT_SINGLELINE | DT_NOPREFIX);

	// BitBlt
	pDC->BitBlt(0, 0, rectDraw.right, rectDraw.bottom, &mDC, 0, 0, SRCCOPY);

	// I
	::SelectObject(mDC.m_hDC, hDefFont);
	mDC.SelectObject(pBitmap);
	VERIFY(Bitmap.DeleteObject());
	VERIFY(mDC.DeleteDC());
}

//---------------------------------------------------------------------------
//
//	Xe[^X`
//
//---------------------------------------------------------------------------
void FASTCALL CStatusView::DrawStatus(int nPane)
{
	CClientDC dc(this);
	CRect rect;
	CInfo *pInfo;

	ASSERT(this);
	ASSERT(nPane >= 0);
	ASSERT(m_pFrmWnd);

	// Info擾
	pInfo = m_pFrmWnd->GetInfo();
	if (!pInfo) {
		return;
	}

	// `擾
	if (nPane > 2) {
		rect = m_rectLED[nPane - 2];
	}
	else {
		rect = m_rectFDD[nPane];
	}

	// InfoɔC
	pInfo->DrawStatus(nPane, dc.m_hDC, rect);
}

#endif	// _WIN32
