//---------------------------------------------------------------------------
//
//	X68000 EMULATOR "XM6"
//
//	Copyright (C) 2001-2006 ohD(ytanaka@ipc-tokai.or.jp)
//	[ MFC TuEBhE(VXe) ]
//
//---------------------------------------------------------------------------

#if defined(_WIN32)

#include "os.h"
#include "xm6.h"
#include "log.h"
#include "device.h"
#include "vm.h"
#include "schedule.h"
#include "event.h"
#include "render.h"
#include "mfc_sub.h"
#include "mfc_frm.h"
#include "mfc_draw.h"
#include "mfc_com.h"
#include "mfc_sch.h"
#include "mfc_res.h"
#include "mfc_cpu.h"
#include "mfc_sys.h"

//===========================================================================
//
//	OEBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CLogWnd::CLogWnd() : CSubListWnd()
{
	// EBhEp[^`
	m_dwID = MAKEID('L', 'O', 'G', 'L');
	::GetMsg(IDS_SWND_LOG, m_strCaption);
	m_nWidth = 64;
	m_nHeight = 8;

	// tH[JXȂ
	m_nFocus = -1;

	// ̑
	m_pLog = NULL;
}

//---------------------------------------------------------------------------
//
//	bZ[W }bv
//
//---------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CLogWnd, CSubListWnd)
	ON_WM_CREATE()
	ON_WM_DRAWITEM()
	ON_NOTIFY(NM_DBLCLK, 0, OnDblClick)
END_MESSAGE_MAP()

//---------------------------------------------------------------------------
//
//	EBhE쐬
//
//---------------------------------------------------------------------------
int CLogWnd::OnCreate(LPCREATESTRUCT lpcs)
{
	ASSERT(this);

	// {NX
	if (CSubListWnd::OnCreate(lpcs) != 0) {
		return -1;
	}

	// ǂݍ
	::GetMsg(IDS_SWND_LOG_DETAIL, m_strDetail);
	::GetMsg(IDS_SWND_LOG_NORMAL, m_strNormal);
	::GetMsg(IDS_SWND_LOG_WARNING, m_strWarning);

	// O擾
	ASSERT(!m_pLog);
	m_pLog = &(::GetVM()->log);
	ASSERT(m_pLog);

	return 0;
}

//---------------------------------------------------------------------------
//
//	_uNbN
//
//---------------------------------------------------------------------------
void CLogWnd::OnDblClick(NMHDR* /*pNotifyStruct*/, LRESULT* /*result*/)
{
	Log::logdata_t logdata;
	BOOL bSuccess;
	CDrawView *pView;
	CDisasmWnd *pDisWnd;

	ASSERT(this);
	ASSERT_VALID(this);

	// tH[JXꍇɌ
	if (m_nFocus < 0) {
		return;
	}

	// Of[^擾Aobt@
	bSuccess = m_pLog->GetData(m_nFocus, &logdata);
	if (!bSuccess) {
		// obt@̉KvȂ
		return;
	}

	// tAZuEBhEփAhXw
	pView = (CDrawView*)GetParent();
	pDisWnd = (CDisasmWnd*)pView->SearchSWnd(MAKEID('D', 'I', 'S', 'A'));
	if (pDisWnd) {
		pDisWnd->SetAddr(logdata.pc);
	}

	// GetData()Ŋmۂobt@
	delete[] logdata.string;
}

//---------------------------------------------------------------------------
//
//	I[i[`
//
//---------------------------------------------------------------------------
void CLogWnd::OnDrawItem(int nID, LPDRAWITEMSTRUCT lpDIS)
{
	CDC dc;
	CDC mDC;
	CBitmap Bitmap;
	CBitmap *pBitmap;
	CFont *pFont;
	CRect rectItem(&lpDIS->rcItem);
	CRect rectClient;
	CString strText;
	Log::logdata_t logdata;
	CSize size;
	int nItem;
	int nWidth;
#if !defined(UNICODE)
	wchar_t szWide[100];
#endif	// UNICODE

	ASSERT(this);
	ASSERT(nID == 0);
	ASSERT(lpDIS);
	ASSERT_VALID(this);

	// DCA^b`
	VERIFY(dc.Attach(lpDIS->hDC));

	// Ȃ󔒂`
	if (!m_bEnable) {
		dc.FillSolidRect(&rectItem, ::GetSysColor(COLOR_WINDOW));
		dc.Detach();
		return;
	}

	// Of[^擾
	if (!m_pLog->GetData(lpDIS->itemID, &logdata)) {
		// Ȃ΋󔒂\
		dc.FillSolidRect(&rectItem, ::GetSysColor(COLOR_WINDOW));
		dc.Detach();
		return;
	}

	// \
	VERIFY(mDC.CreateCompatibleDC(&dc));
	VERIFY(Bitmap.CreateCompatibleBitmap(&dc, rectItem.Width(), rectItem.Height()));
	pBitmap = mDC.SelectObject(&Bitmap);
	ASSERT(pBitmap);

	// tHgړ]
	pFont = mDC.SelectObject(m_ListCtrl.GetFont());
	ASSERT(pFont);

	// nF߂ăx^h肷
	rectClient.left = 0;
	rectClient.right = rectItem.Width();
	rectClient.top = 0;
	rectClient.bottom = rectItem.Height();
	if (lpDIS->itemState & ODS_FOCUS) {
		// tH[JXԍL^̂Yꂸ
		m_nFocus = lpDIS->itemID;
		mDC.FillSolidRect(&rectClient, ::GetSysColor(COLOR_HIGHLIGHT));
		mDC.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
		mDC.SetBkColor(::GetSysColor(COLOR_HIGHLIGHT));
	}
	else {
		// tH[JXȂ
		mDC.FillSolidRect(&rectClient, ::GetSysColor(COLOR_WINDOW));
		mDC.SetBkColor(::GetSysColor(COLOR_WINDOW));
	}

	// TuACeԂɕ\
	for (nItem=0; nItem<6; nItem++) {
		// W쐬
		nWidth = m_ListCtrl.GetColumnWidth(nItem);
		rectClient.right = rectClient.left + nWidth;

		// eLXg擾
		TextSub(nItem, &logdata, strText);

		// Fݒ
		if (!(lpDIS->itemState & ODS_FOCUS)) {
			mDC.SetTextColor(RGB(0, 0, 0));
			if (nItem == 3) {
				switch (logdata.level) {
					// ڍ(DF)
					case Log::Detail:
						mDC.SetTextColor(RGB(192, 192, 192));
						break;
					// x(ԐF)
					case Log::Warning:
						mDC.SetTextColor(RGB(255, 0, 0));
						break;
				}
			}
		}

		// \
		switch (nItem) {
			// No.(El)
			case 0:
			// z(El)
			case 1:
				mDC.DrawText(strText, &rectClient, DT_SINGLELINE | DT_RIGHT | DT_VCENTER);
				break;

			// PC()
			case 2:
			// x()
			case 3:
			// foCX()
			case 4:
				mDC.DrawText(strText, &rectClient, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
				break;

			// bZ[W(l)
			case 5:
#if !defined(UNICODE)
				// {ȂAVM̃VtgJIŜ܂ܕ\ł
				if (::IsJapanese()) {
					// {
					mDC.DrawText(strText, &rectClient, DT_SINGLELINE | DT_LEFT | DT_VCENTER | DT_NOPREFIX);
					break;
				}

				// CP932T|[g
				if (::Support932()) {
					// CP932T|[g(UNICODET|[gĂ)
					memset(&szWide[0], 0, sizeof(szWide));
					if (strText.GetLength() < 0x100) {
						// VtgJISAUNICODE֕ϊ
						::MultiByteToWideChar(932, MB_PRECOMPOSED, (LPCSTR)(LPCTSTR)strText, -1, szWide, 100);

						// UNICODEƂĕ\
						::DrawTextWide(mDC.m_hDC, szWide, -1, rectClient, DT_SINGLELINE | DT_LEFT | DT_VCENTER | DT_NOPREFIX);
					}
					break;
				}

				// \łȂ
				if (::IsWinNT()) {
					strText = _T("CP932(Japanese Shift-JIS) is required");
				}
				else {
					strText = _T("(Japanese Text)");
				}
#endif	// !UNICODE
				// \łȂAUNICODȄꍇ̂݁Aɂ
				mDC.DrawText(strText, &rectClient, DT_SINGLELINE | DT_LEFT | DT_VCENTER | DT_NOPREFIX);
				break;

			// ̑(肦Ȃ)
			default:
				ASSERT(FALSE);
		}

		// `XV
		rectClient.left += nWidth;
	}

	// \I
	VERIFY(dc.BitBlt(rectItem.left, rectItem.top, rectItem.Width(), rectItem.Height(),
						&mDC, 0, 0, SRCCOPY));
	VERIFY(mDC.SelectObject(pFont));
	VERIFY(mDC.SelectObject(pBitmap));
	VERIFY(Bitmap.DeleteObject());
	VERIFY(mDC.DeleteDC());
	dc.Detach();

	// obt@
	delete[] logdata.string;
}

//---------------------------------------------------------------------------
//
//	XgRg[
//
//---------------------------------------------------------------------------
void FASTCALL CLogWnd::InitList()
{
	CString strHeader;

	ASSERT(this);
	ASSERT_VALID(this);

	// J0(ʂԍ)
	::GetMsg(IDS_SWND_LOG_NUMBER, strHeader);
	m_ListCtrl.InsertColumn(0, strHeader, LVCFMT_RIGHT, m_tmWidth * 7, 0);

	// J1()
	::GetMsg(IDS_SWND_LOG_TIME, strHeader);
	m_ListCtrl.InsertColumn(1, strHeader, LVCFMT_RIGHT, m_tmWidth * 10, 1);

	// J2(PC)
	::GetMsg(IDS_SWND_LOG_PC, strHeader);
	m_ListCtrl.InsertColumn(2, strHeader, LVCFMT_CENTER, m_tmWidth * 8, 2);

	// J3(x)
	::GetMsg(IDS_SWND_LOG_LEVEL, strHeader);
	m_ListCtrl.InsertColumn(3, strHeader, LVCFMT_CENTER, m_tmWidth * 6, 3);

	// J4(foCX)
	::GetMsg(IDS_SWND_LOG_DEVICE, strHeader);
	m_ListCtrl.InsertColumn(4, strHeader, LVCFMT_CENTER, m_tmWidth * 8, 4);

	// J5(bZ[W)
	::GetMsg(IDS_SWND_LOG_MSG, strHeader);
	m_ListCtrl.InsertColumn(5, strHeader, LVCFMT_LEFT, m_tmWidth * 32, 5);

	// Sč폜
	m_ListCtrl.DeleteAllItems();
}

//---------------------------------------------------------------------------
//
//	tbV
//
//---------------------------------------------------------------------------
void FASTCALL CLogWnd::Refresh()
{
	// UpdateŃbZ[WXbh珈邽߁AȂ
}

//---------------------------------------------------------------------------
//
//	bZ[WXbh̍XV
//
//---------------------------------------------------------------------------
void FASTCALL CLogWnd::Update()
{
	int nItem;
	int nLog;
	BOOL bRun;
	CString strEmpty;

	ASSERT(this);
	ASSERT_VALID(this);

	// Ȃ牽Ȃ
	if (!m_bEnable) {
		return;
	}

	// ݂̐𓾂āAACe𒲐
	nItem = m_ListCtrl.GetItemCount();
	nLog = m_pLog->GetNum();

	// k
	if (nItem > nLog) {
		m_ListCtrl.DeleteAllItems();
		nItem = 0;
	}

	// g
	if (nItem < nLog) {
		// _~[p
		strEmpty.Empty();

		// 1024ACeȏ̏ꍇAUVM~߂āAACe𑝂₷
		if ((nLog - nItem) >= 0x400) {
			// ̊g͎Ԃ邽߁AVM~߂
			bRun = m_pSch->IsEnable();
			m_pSch->Enable(FALSE);

			// g
			while (nItem < nLog) {
				m_ListCtrl.InsertItem(nItem, strEmpty);
				nItem++;
			}

			// VM𕜌
			m_pSch->Enable(bRun);
			m_pSch->Reset();
		}
		else {
			// 1023ACeȉȂ̂ŁAVMsȂg
			while (nItem < nLog) {
				m_ListCtrl.InsertItem(nItem, strEmpty);
				nItem++;
			}
		}
	}

	// ɕ`w͂Ȃ悢ʂ炷
}

//---------------------------------------------------------------------------
//
//	Zbg
//
//---------------------------------------------------------------------------
void FASTCALL CLogWnd::TextSub(int nType, Log::logdata_t *pLogData, CString& string)
{
	DWORD dwTime;
	CString strTemp;
#if defined(UNICODE)
	wchar_t szWide[100];
#endif	// UNICODE

	ASSERT(this);
	ASSERT((nType >= 0) && (nType <= 5));
	ASSERT(pLogData);

	switch (nType) {
		// ʂԍ
		case 0:
			string.Format("%d", pLogData->number);
			return;

		//  (s.ms.us)
		case 1:
			dwTime = pLogData->time;
			dwTime /= 2;
			strTemp.Format("%d.", dwTime / (1000 * 1000));
			string = strTemp;
			dwTime %= (1000 * 1000);
			strTemp.Format("%03d.", dwTime / 1000);
			string += strTemp;
			dwTime %= 1000;
			strTemp.Format("%03d", dwTime);
			string += strTemp;
			return;

		// PC
		case 2:
			string.Format("$%06X", pLogData->pc);
			return;

		// x
		case 3:
			switch (pLogData->level) {
				// ڍ
				case Log::Detail:
					string = m_strDetail;
					break;
				// ʏ
				case Log::Normal:
					string = m_strNormal;
					break;
				// x
				case Log::Warning:
					string = m_strWarning;
					break;
				// ̑(肦Ȃ)
				default:
					ASSERT(FALSE);
					string.Empty();
					break;
			}
			return;

		// foCX
		case 4:
			string.Format(_T("%c%c%c%c"),
						(BYTE)(pLogData->id >> 24),
						(BYTE)(pLogData->id >> 16),
						(BYTE)(pLogData->id >> 8),
						(BYTE)(pLogData->id));
			return;

		// bZ[W
		case 5:
#if defined(UNICODE)
			// CP932ϊĂ
			if (::Support932()) {
				// VtgJISAUNICODE֕ϊ
				::MultiByteToWideChar(932, MB_PRECOMPOSED, (LPCSTR)pLogData->string, -1, szWide, 100);

				// Zbg
				string = szWide;
			}
			else {
				if (::IsWinNT()) {
					// UNICODET|[gĂ邪ACP932
					string = _T("CP932(Japanese Shift-JIS) is required");
				}
				else {
					// UNICODEwȂ̂ɁAWin9xœĂ
					string = _T("(Japanese Text)");
				}
			}
#else
			// UNICODEłȂ̂ŁAstring}`oCg
			string = pLogData->string;
#endif	// UNICODE
			return;

		// ̑(肦Ȃ)
		default:
			break;
	}

	// ʏAɂ͂Ȃ
	ASSERT(FALSE);
}

//===========================================================================
//
//	XPW[EBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CSchedulerWnd::CSchedulerWnd()
{
	// EBhEp[^`
	m_dwID = MAKEID('S', 'C', 'H', 'E');
	::GetMsg(IDS_SWND_SCHEDULER, m_strCaption);
	m_nWidth = 72;
	m_nHeight = 23;

	// XPW[擾
	m_pScheduler = (Scheduler*)::GetVM()->SearchDevice(MAKEID('S', 'C', 'H', 'E'));
	ASSERT(m_pScheduler);
}

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CSchedulerWnd::Setup()
{
	int x;
	int y;
	int nIndex;
	DWORD dwRate;
	Event *pEvent;
	Device *pDevice;
	DWORD dwID;
	CString strText;
	Scheduler::scheduler_t sch;

	ASSERT(this);
	ASSERT(m_pSch);
	ASSERT(m_pScheduler);

	// XPW[[N擾
	m_pScheduler->GetScheduler(&sch);

	// NA
	Clear();
	x = 44;

	// 
	y = 0;

	// g[^s
	SetString(0, y, _T("Passed Time"));
	strText.Format(_T("%12dms"), sch.total / 2000);
	SetString(15, y, strText);
	y++;

	// s
	SetString(0, y, _T("Execution Time"));
	strText.Format(_T("%6d.%1dus"), sch.one / 2, (sch.one & 1) * 5);
	SetString(19, y, strText);
	y++;

	// t[[g
	dwRate = m_pSch->GetFrameRate();
	SetString(0, y, _T("Frame Rate"));
	strText.Format(_T("%2d.%1dfps"), dwRate / 10, (dwRate % 10));
	SetString(22, y, strText);

	// E
	y = 0;

	// CPU(x)
	SetString(x, y, _T("MPU Speed"));
	strText.Format(_T("%d.%02dMHz"), sch.speed / 100, sch.speed % 100);
	if (sch.speed >= 1000) {
		SetString(x + 20, y, strText);
	}
	else {
		SetString(x + 21, y, strText);
	}
	y++;

	// CPU(ԃTCN)
	SetString(x, y, _T("MPU Over Cycle"));
	strText.Format(_T("%5u"), sch.cycle);
	SetString(x + 23, y, strText);
	y++;

	// CPU()
	SetString(x, y, _T("MPU Over Time"));
	strText.Format(_T("%3d.%1dus"), sch.time / 2, (sch.time & 1) * 5);
	SetString(x + 21, y, strText);
	y++;

	// CxgKCh
	y++;
	SetString(0, y, _T("No."));
	SetString(6, y, _T("Remain"));
	SetString(20, y, _T("Time"));
	SetString(34, y, _T("User"));
	SetString(42, y, _T("Flag"));
	SetString(48, y, _T("Device"));
	SetString(56, y, _T("Description"));
	y++;

	// Cxg[v
	pEvent = m_pScheduler->GetFirstEvent();
	nIndex = 0;
	while (pEvent) {
		// {p[^
		strText.Format(_T("%2d %5d.%04dms (%5d.%04dms) $%08X "),
			nIndex + 1,
			pEvent->GetRemain() / 2000,
			(pEvent->GetRemain() % 2000) * 5,
			pEvent->GetTime() / 2000,
			(pEvent->GetTime() % 2000) * 5,
			pEvent->GetUser());
		SetString(0, y, strText);

		// LtO
		if (pEvent->GetTime() != 0) {
			SetString(42, y, _T("Enable"));
		}

		// foCX
		pDevice = pEvent->GetDevice();
		ASSERT(pDevice);
		dwID = pDevice->GetID();
		strText.Format(_T("%c%c%c%c"),
						(BYTE)(dwID >> 24),
						(BYTE)(dwID >> 16),
						(BYTE)(dwID >> 8),
						(BYTE)dwID);
		SetString(49, y, strText);

		// 
		SetString(54, y, pEvent->GetDesc());

		// ̃Cxg
		pEvent = pEvent->GetNextEvent();
		nIndex++;
		y++;
	}
}

//---------------------------------------------------------------------------
//
//	bZ[WXbh̍XV
//
//---------------------------------------------------------------------------
void FASTCALL CSchedulerWnd::Update()
{
	int nNum;

	ASSERT(this);

	// XPW[̂Cxg擾ATCY
	nNum = m_pScheduler->GetEventNum();
	ReSize(m_nWidth, nNum + 5);
}

//===========================================================================
//
//	foCXEBhE
//
//===========================================================================

//---------------------------------------------------------------------------
//
//	RXgN^
//
//---------------------------------------------------------------------------
CDeviceWnd::CDeviceWnd()
{
	// EBhEp[^`
	m_dwID = MAKEID('D', 'E', 'V', 'I');
	::GetMsg(IDS_SWND_DEVICE, m_strCaption);

	m_nWidth = 57;
	m_nHeight = 32;
}

//---------------------------------------------------------------------------
//
//	ZbgAbv
//
//---------------------------------------------------------------------------
void FASTCALL CDeviceWnd::Setup()
{
	int nDevice;
	const Device *pDevice;
	const MemDevice *pMemDev;
	CString strText;
	CString strTemp;
	DWORD dwID;
	DWORD dwMemID;
	BOOL bMem;

	ASSERT(this);

	// NA
	Clear();

	// ŏ̃foCX擾AID쐬
	pDevice = ::GetVM()->GetFirstDevice();
	ASSERT(pDevice);
	dwMemID = MAKEID('M', 'E', 'M', ' ');
	bMem = FALSE;

	SetString(0, 0, _T("No. Device Object"));
	SetString(23, 0, _T("Address Range"));
	SetString(41, 0, _T("Description"));

	// [v
	nDevice = 0;
	while (pDevice) {
		// ԍ
		strText.Format(_T("%2d  "), nDevice + 1);

		// ID
		dwID = pDevice->GetID();
		strTemp.Format(_T("%c%c%c%c"),
						(BYTE)(dwID >> 24),
						(BYTE)(dwID >> 16),
						(BYTE)(dwID >> 8),
						(BYTE)(dwID));
		strText += strTemp;

		// |C^
		strTemp.Format(_T("  %08x  "), pDevice);
		strText += strTemp;

		// tO
		if (dwID == dwMemID) {
			bMem = TRUE;
		}

		// ͈
		if (bMem) {
			pMemDev = (MemDevice *)pDevice;
			strTemp.Format(_T("$%06X - $%06X"),
						pMemDev->GetFirstAddr(), pMemDev->GetLastAddr());
		}
		else {
			strTemp = _T("(NO MEMORY)");
		}
		strText += strTemp;

		// Zbg
		SetString(0, nDevice + 1, strText);

		// 
		strText = pDevice->GetDesc();
		SetString(39, nDevice + 1, strText);

		// 
		nDevice++;
		pDevice = pDevice->GetNextDevice();
	}
}

#endif	// _WIN32
